(function () {
  'use strict';

  // packages/alpinejs/src/scheduler.js
  var flushPending = false;
  var flushing = false;
  var queue = [];
  var lastFlushedIndex = -1;
  function scheduler(callback) {
    queueJob(callback);
  }
  function queueJob(job) {
    if (!queue.includes(job)) queue.push(job);
    queueFlush();
  }
  function dequeueJob(job) {
    let index = queue.indexOf(job);
    if (index !== -1 && index > lastFlushedIndex) queue.splice(index, 1);
  }
  function queueFlush() {
    if (!flushing && !flushPending) {
      flushPending = true;
      queueMicrotask(flushJobs);
    }
  }
  function flushJobs() {
    flushPending = false;
    flushing = true;
    for (let i = 0; i < queue.length; i++) {
      queue[i]();
      lastFlushedIndex = i;
    }
    queue.length = 0;
    lastFlushedIndex = -1;
    flushing = false;
  }

  // packages/alpinejs/src/reactivity.js
  var reactive;
  var effect;
  var release;
  var raw;
  var shouldSchedule = true;
  function disableEffectScheduling(callback) {
    shouldSchedule = false;
    callback();
    shouldSchedule = true;
  }
  function setReactivityEngine(engine) {
    reactive = engine.reactive;
    release = engine.release;
    effect = callback => engine.effect(callback, {
      scheduler: task => {
        if (shouldSchedule) {
          scheduler(task);
        } else {
          task();
        }
      }
    });
    raw = engine.raw;
  }
  function overrideEffect(override) {
    effect = override;
  }
  function elementBoundEffect(el) {
    let cleanup2 = () => {};
    let wrappedEffect = callback => {
      let effectReference = effect(callback);
      if (!el._x_effects) {
        el._x_effects = new Set();
        el._x_runEffects = () => {
          el._x_effects.forEach(i => i());
        };
      }
      el._x_effects.add(effectReference);
      cleanup2 = () => {
        if (effectReference === void 0) return;
        el._x_effects.delete(effectReference);
        release(effectReference);
      };
      return effectReference;
    };
    return [wrappedEffect, () => {
      cleanup2();
    }];
  }

  // packages/alpinejs/src/mutation.js
  var onAttributeAddeds = [];
  var onElRemoveds = [];
  var onElAddeds = [];
  function onElAdded(callback) {
    onElAddeds.push(callback);
  }
  function onElRemoved(el, callback) {
    if (typeof callback === "function") {
      if (!el._x_cleanups) el._x_cleanups = [];
      el._x_cleanups.push(callback);
    } else {
      callback = el;
      onElRemoveds.push(callback);
    }
  }
  function onAttributesAdded(callback) {
    onAttributeAddeds.push(callback);
  }
  function onAttributeRemoved(el, name, callback) {
    if (!el._x_attributeCleanups) el._x_attributeCleanups = {};
    if (!el._x_attributeCleanups[name]) el._x_attributeCleanups[name] = [];
    el._x_attributeCleanups[name].push(callback);
  }
  function cleanupAttributes(el, names) {
    if (!el._x_attributeCleanups) return;
    Object.entries(el._x_attributeCleanups).forEach(([name, value]) => {
      if (names === void 0 || names.includes(name)) {
        value.forEach(i => i());
        delete el._x_attributeCleanups[name];
      }
    });
  }
  var observer = new MutationObserver(onMutate);
  var currentlyObserving = false;
  function startObservingMutations() {
    observer.observe(document, {
      subtree: true,
      childList: true,
      attributes: true,
      attributeOldValue: true
    });
    currentlyObserving = true;
  }
  function stopObservingMutations() {
    flushObserver();
    observer.disconnect();
    currentlyObserving = false;
  }
  var recordQueue = [];
  var willProcessRecordQueue = false;
  function flushObserver() {
    recordQueue = recordQueue.concat(observer.takeRecords());
    if (recordQueue.length && !willProcessRecordQueue) {
      willProcessRecordQueue = true;
      queueMicrotask(() => {
        processRecordQueue();
        willProcessRecordQueue = false;
      });
    }
  }
  function processRecordQueue() {
    onMutate(recordQueue);
    recordQueue.length = 0;
  }
  function mutateDom(callback) {
    if (!currentlyObserving) return callback();
    stopObservingMutations();
    let result = callback();
    startObservingMutations();
    return result;
  }
  var isCollecting = false;
  var deferredMutations = [];
  function deferMutations() {
    isCollecting = true;
  }
  function flushAndStopDeferringMutations() {
    isCollecting = false;
    onMutate(deferredMutations);
    deferredMutations = [];
  }
  function onMutate(mutations) {
    if (isCollecting) {
      deferredMutations = deferredMutations.concat(mutations);
      return;
    }
    let addedNodes = [];
    let removedNodes = [];
    let addedAttributes = new Map();
    let removedAttributes = new Map();
    for (let i = 0; i < mutations.length; i++) {
      if (mutations[i].target._x_ignoreMutationObserver) continue;
      if (mutations[i].type === "childList") {
        mutations[i].addedNodes.forEach(node => node.nodeType === 1 && addedNodes.push(node));
        mutations[i].removedNodes.forEach(node => node.nodeType === 1 && removedNodes.push(node));
      }
      if (mutations[i].type === "attributes") {
        let el = mutations[i].target;
        let name = mutations[i].attributeName;
        let oldValue = mutations[i].oldValue;
        let add2 = () => {
          if (!addedAttributes.has(el)) addedAttributes.set(el, []);
          addedAttributes.get(el).push({
            name,
            value: el.getAttribute(name)
          });
        };
        let remove = () => {
          if (!removedAttributes.has(el)) removedAttributes.set(el, []);
          removedAttributes.get(el).push(name);
        };
        if (el.hasAttribute(name) && oldValue === null) {
          add2();
        } else if (el.hasAttribute(name)) {
          remove();
          add2();
        } else {
          remove();
        }
      }
    }
    removedAttributes.forEach((attrs, el) => {
      cleanupAttributes(el, attrs);
    });
    addedAttributes.forEach((attrs, el) => {
      onAttributeAddeds.forEach(i => i(el, attrs));
    });
    for (let node of removedNodes) {
      if (addedNodes.includes(node)) continue;
      onElRemoveds.forEach(i => i(node));
      if (node._x_cleanups) {
        while (node._x_cleanups.length) node._x_cleanups.pop()();
      }
    }
    addedNodes.forEach(node => {
      node._x_ignoreSelf = true;
      node._x_ignore = true;
    });
    for (let node of addedNodes) {
      if (removedNodes.includes(node)) continue;
      if (!node.isConnected) continue;
      delete node._x_ignoreSelf;
      delete node._x_ignore;
      onElAddeds.forEach(i => i(node));
      node._x_ignore = true;
      node._x_ignoreSelf = true;
    }
    addedNodes.forEach(node => {
      delete node._x_ignoreSelf;
      delete node._x_ignore;
    });
    addedNodes = null;
    removedNodes = null;
    addedAttributes = null;
    removedAttributes = null;
  }

  // packages/alpinejs/src/scope.js
  function scope(node) {
    return mergeProxies(closestDataStack(node));
  }
  function addScopeToNode(node, data2, referenceNode) {
    node._x_dataStack = [data2, ...closestDataStack(referenceNode || node)];
    return () => {
      node._x_dataStack = node._x_dataStack.filter(i => i !== data2);
    };
  }
  function closestDataStack(node) {
    if (node._x_dataStack) return node._x_dataStack;
    if (typeof ShadowRoot === "function" && node instanceof ShadowRoot) {
      return closestDataStack(node.host);
    }
    if (!node.parentNode) {
      return [];
    }
    return closestDataStack(node.parentNode);
  }
  function mergeProxies(objects) {
    let thisProxy = new Proxy({}, {
      ownKeys: () => {
        return Array.from(new Set(objects.flatMap(i => Object.keys(i))));
      },
      has: (target, name) => {
        return objects.some(obj => obj.hasOwnProperty(name));
      },
      get: (target, name) => {
        return (objects.find(obj => {
          if (obj.hasOwnProperty(name)) {
            let descriptor = Object.getOwnPropertyDescriptor(obj, name);
            if (descriptor.get && descriptor.get._x_alreadyBound || descriptor.set && descriptor.set._x_alreadyBound) {
              return true;
            }
            if ((descriptor.get || descriptor.set) && descriptor.enumerable) {
              let getter = descriptor.get;
              let setter = descriptor.set;
              let property = descriptor;
              getter = getter && getter.bind(thisProxy);
              setter = setter && setter.bind(thisProxy);
              if (getter) getter._x_alreadyBound = true;
              if (setter) setter._x_alreadyBound = true;
              Object.defineProperty(obj, name, {
                ...property,
                get: getter,
                set: setter
              });
            }
            return true;
          }
          return false;
        }) || {})[name];
      },
      set: (target, name, value) => {
        let closestObjectWithKey = objects.find(obj => obj.hasOwnProperty(name));
        if (closestObjectWithKey) {
          closestObjectWithKey[name] = value;
        } else {
          objects[objects.length - 1][name] = value;
        }
        return true;
      }
    });
    return thisProxy;
  }

  // packages/alpinejs/src/interceptor.js
  function initInterceptors(data2) {
    let isObject2 = val => typeof val === "object" && !Array.isArray(val) && val !== null;
    let recurse = (obj, basePath = "") => {
      Object.entries(Object.getOwnPropertyDescriptors(obj)).forEach(([key, {
        value,
        enumerable
      }]) => {
        if (enumerable === false || value === void 0) return;
        let path = basePath === "" ? key : `${basePath}.${key}`;
        if (typeof value === "object" && value !== null && value._x_interceptor) {
          obj[key] = value.initialize(data2, path, key);
        } else {
          if (isObject2(value) && value !== obj && !(value instanceof Element)) {
            recurse(value, path);
          }
        }
      });
    };
    return recurse(data2);
  }
  function interceptor(callback, mutateObj = () => {}) {
    let obj = {
      initialValue: void 0,
      _x_interceptor: true,
      initialize(data2, path, key) {
        return callback(this.initialValue, () => get$1(data2, path), value => set$1(data2, path, value), path, key);
      }
    };
    mutateObj(obj);
    return initialValue => {
      if (typeof initialValue === "object" && initialValue !== null && initialValue._x_interceptor) {
        let initialize = obj.initialize.bind(obj);
        obj.initialize = (data2, path, key) => {
          let innerValue = initialValue.initialize(data2, path, key);
          obj.initialValue = innerValue;
          return initialize(data2, path, key);
        };
      } else {
        obj.initialValue = initialValue;
      }
      return obj;
    };
  }
  function get$1(obj, path) {
    return path.split(".").reduce((carry, segment) => carry[segment], obj);
  }
  function set$1(obj, path, value) {
    if (typeof path === "string") path = path.split(".");
    if (path.length === 1) obj[path[0]] = value;else if (path.length === 0) throw error;else {
      if (obj[path[0]]) return set$1(obj[path[0]], path.slice(1), value);else {
        obj[path[0]] = {};
        return set$1(obj[path[0]], path.slice(1), value);
      }
    }
  }

  // packages/alpinejs/src/magics.js
  var magics = {};
  function magic(name, callback) {
    magics[name] = callback;
  }
  function injectMagics(obj, el) {
    Object.entries(magics).forEach(([name, callback]) => {
      let memoizedUtilities = null;
      function getUtilities() {
        if (memoizedUtilities) {
          return memoizedUtilities;
        } else {
          let [utilities, cleanup2] = getElementBoundUtilities(el);
          memoizedUtilities = {
            interceptor,
            ...utilities
          };
          onElRemoved(el, cleanup2);
          return memoizedUtilities;
        }
      }
      Object.defineProperty(obj, `$${name}`, {
        get() {
          return callback(el, getUtilities());
        },
        enumerable: false
      });
    });
    return obj;
  }

  // packages/alpinejs/src/utils/error.js
  function tryCatch(el, expression, callback, ...args) {
    try {
      return callback(...args);
    } catch (e) {
      handleError(e, el, expression);
    }
  }
  function handleError(error2, el, expression = void 0) {
    Object.assign(error2, {
      el,
      expression
    });
    console.warn(`Alpine Expression Error: ${error2.message}

${expression ? 'Expression: "' + expression + '"\n\n' : ""}`, el);
    setTimeout(() => {
      throw error2;
    }, 0);
  }

  // packages/alpinejs/src/evaluator.js
  var shouldAutoEvaluateFunctions = true;
  function dontAutoEvaluateFunctions(callback) {
    let cache = shouldAutoEvaluateFunctions;
    shouldAutoEvaluateFunctions = false;
    let result = callback();
    shouldAutoEvaluateFunctions = cache;
    return result;
  }
  function evaluate(el, expression, extras = {}) {
    let result;
    evaluateLater(el, expression)(value => result = value, extras);
    return result;
  }
  function evaluateLater(...args) {
    return theEvaluatorFunction(...args);
  }
  var theEvaluatorFunction = normalEvaluator;
  function setEvaluator(newEvaluator) {
    theEvaluatorFunction = newEvaluator;
  }
  function normalEvaluator(el, expression) {
    let overriddenMagics = {};
    injectMagics(overriddenMagics, el);
    let dataStack = [overriddenMagics, ...closestDataStack(el)];
    let evaluator = typeof expression === "function" ? generateEvaluatorFromFunction(dataStack, expression) : generateEvaluatorFromString(dataStack, expression, el);
    return tryCatch.bind(null, el, expression, evaluator);
  }
  function generateEvaluatorFromFunction(dataStack, func) {
    return (receiver = () => {}, {
      scope: scope2 = {},
      params = []
    } = {}) => {
      let result = func.apply(mergeProxies([scope2, ...dataStack]), params);
      runIfTypeOfFunction(receiver, result);
    };
  }
  var evaluatorMemo = {};
  function generateFunctionFromString(expression, el) {
    if (evaluatorMemo[expression]) {
      return evaluatorMemo[expression];
    }
    let AsyncFunction = Object.getPrototypeOf(async function () {}).constructor;
    let rightSideSafeExpression = /^[\n\s]*if.*\(.*\)/.test(expression) || /^(let|const)\s/.test(expression) ? `(async()=>{ ${expression} })()` : expression;
    const safeAsyncFunction = () => {
      try {
        return new AsyncFunction(["__self", "scope"], `with (scope) { __self.result = ${rightSideSafeExpression} }; __self.finished = true; return __self.result;`);
      } catch (error2) {
        handleError(error2, el, expression);
        return Promise.resolve();
      }
    };
    let func = safeAsyncFunction();
    evaluatorMemo[expression] = func;
    return func;
  }
  function generateEvaluatorFromString(dataStack, expression, el) {
    let func = generateFunctionFromString(expression, el);
    return (receiver = () => {}, {
      scope: scope2 = {},
      params = []
    } = {}) => {
      func.result = void 0;
      func.finished = false;
      let completeScope = mergeProxies([scope2, ...dataStack]);
      if (typeof func === "function") {
        let promise = func(func, completeScope).catch(error2 => handleError(error2, el, expression));
        if (func.finished) {
          runIfTypeOfFunction(receiver, func.result, completeScope, params, el);
          func.result = void 0;
        } else {
          promise.then(result => {
            runIfTypeOfFunction(receiver, result, completeScope, params, el);
          }).catch(error2 => handleError(error2, el, expression)).finally(() => func.result = void 0);
        }
      }
    };
  }
  function runIfTypeOfFunction(receiver, value, scope2, params, el) {
    if (shouldAutoEvaluateFunctions && typeof value === "function") {
      let result = value.apply(scope2, params);
      if (result instanceof Promise) {
        result.then(i => runIfTypeOfFunction(receiver, i, scope2, params)).catch(error2 => handleError(error2, el, value));
      } else {
        receiver(result);
      }
    } else if (typeof value === "object" && value instanceof Promise) {
      value.then(i => receiver(i));
    } else {
      receiver(value);
    }
  }

  // packages/alpinejs/src/directives.js
  var prefixAsString = "x-";
  function prefix(subject = "") {
    return prefixAsString + subject;
  }
  function setPrefix(newPrefix) {
    prefixAsString = newPrefix;
  }
  var directiveHandlers = {};
  function directive(name, callback) {
    directiveHandlers[name] = callback;
    return {
      before(directive2) {
        if (!directiveHandlers[directive2]) {
          console.warn("Cannot find directive `${directive}`. `${name}` will use the default order of execution");
          return;
        }
        const pos = directiveOrder.indexOf(directive2);
        directiveOrder.splice(pos >= 0 ? pos : directiveOrder.indexOf("DEFAULT"), 0, name);
      }
    };
  }
  function directives(el, attributes, originalAttributeOverride) {
    attributes = Array.from(attributes);
    if (el._x_virtualDirectives) {
      let vAttributes = Object.entries(el._x_virtualDirectives).map(([name, value]) => ({
        name,
        value
      }));
      let staticAttributes = attributesOnly(vAttributes);
      vAttributes = vAttributes.map(attribute => {
        if (staticAttributes.find(attr => attr.name === attribute.name)) {
          return {
            name: `x-bind:${attribute.name}`,
            value: `"${attribute.value}"`
          };
        }
        return attribute;
      });
      attributes = attributes.concat(vAttributes);
    }
    let transformedAttributeMap = {};
    let directives2 = attributes.map(toTransformedAttributes((newName, oldName) => transformedAttributeMap[newName] = oldName)).filter(outNonAlpineAttributes).map(toParsedDirectives(transformedAttributeMap, originalAttributeOverride)).sort(byPriority);
    return directives2.map(directive2 => {
      return getDirectiveHandler(el, directive2);
    });
  }
  function attributesOnly(attributes) {
    return Array.from(attributes).map(toTransformedAttributes()).filter(attr => !outNonAlpineAttributes(attr));
  }
  var isDeferringHandlers = false;
  var directiveHandlerStacks = new Map();
  var currentHandlerStackKey = Symbol();
  function deferHandlingDirectives(callback) {
    isDeferringHandlers = true;
    let key = Symbol();
    currentHandlerStackKey = key;
    directiveHandlerStacks.set(key, []);
    let flushHandlers = () => {
      while (directiveHandlerStacks.get(key).length) directiveHandlerStacks.get(key).shift()();
      directiveHandlerStacks.delete(key);
    };
    let stopDeferring = () => {
      isDeferringHandlers = false;
      flushHandlers();
    };
    callback(flushHandlers);
    stopDeferring();
  }
  function getElementBoundUtilities(el) {
    let cleanups = [];
    let cleanup2 = callback => cleanups.push(callback);
    let [effect3, cleanupEffect] = elementBoundEffect(el);
    cleanups.push(cleanupEffect);
    let utilities = {
      Alpine: alpine_default,
      effect: effect3,
      cleanup: cleanup2,
      evaluateLater: evaluateLater.bind(evaluateLater, el),
      evaluate: evaluate.bind(evaluate, el)
    };
    let doCleanup = () => cleanups.forEach(i => i());
    return [utilities, doCleanup];
  }
  function getDirectiveHandler(el, directive2) {
    let noop = () => {};
    let handler4 = directiveHandlers[directive2.type] || noop;
    let [utilities, cleanup2] = getElementBoundUtilities(el);
    onAttributeRemoved(el, directive2.original, cleanup2);
    let fullHandler = () => {
      if (el._x_ignore || el._x_ignoreSelf) return;
      handler4.inline && handler4.inline(el, directive2, utilities);
      handler4 = handler4.bind(handler4, el, directive2, utilities);
      isDeferringHandlers ? directiveHandlerStacks.get(currentHandlerStackKey).push(handler4) : handler4();
    };
    fullHandler.runCleanups = cleanup2;
    return fullHandler;
  }
  var startingWith = (subject, replacement) => ({
    name,
    value
  }) => {
    if (name.startsWith(subject)) name = name.replace(subject, replacement);
    return {
      name,
      value
    };
  };
  var into = i => i;
  function toTransformedAttributes(callback = () => {}) {
    return ({
      name,
      value
    }) => {
      let {
        name: newName,
        value: newValue
      } = attributeTransformers.reduce((carry, transform) => {
        return transform(carry);
      }, {
        name,
        value
      });
      if (newName !== name) callback(newName, name);
      return {
        name: newName,
        value: newValue
      };
    };
  }
  var attributeTransformers = [];
  function mapAttributes(callback) {
    attributeTransformers.push(callback);
  }
  function outNonAlpineAttributes({
    name
  }) {
    return alpineAttributeRegex().test(name);
  }
  var alpineAttributeRegex = () => new RegExp(`^${prefixAsString}([^:^.]+)\\b`);
  function toParsedDirectives(transformedAttributeMap, originalAttributeOverride) {
    return ({
      name,
      value
    }) => {
      let typeMatch = name.match(alpineAttributeRegex());
      let valueMatch = name.match(/:([a-zA-Z0-9\-:]+)/);
      let modifiers = name.match(/\.[^.\]]+(?=[^\]]*$)/g) || [];
      let original = originalAttributeOverride || transformedAttributeMap[name] || name;
      return {
        type: typeMatch ? typeMatch[1] : null,
        value: valueMatch ? valueMatch[1] : null,
        modifiers: modifiers.map(i => i.replace(".", "")),
        expression: value,
        original
      };
    };
  }
  var DEFAULT = "DEFAULT";
  var directiveOrder = ["ignore", "ref", "data", "id", "bind", "init", "for", "model", "modelable", "transition", "show", "if", DEFAULT, "teleport"];
  function byPriority(a, b) {
    let typeA = directiveOrder.indexOf(a.type) === -1 ? DEFAULT : a.type;
    let typeB = directiveOrder.indexOf(b.type) === -1 ? DEFAULT : b.type;
    return directiveOrder.indexOf(typeA) - directiveOrder.indexOf(typeB);
  }

  // packages/alpinejs/src/utils/dispatch.js
  function dispatch(el, name, detail = {}) {
    el.dispatchEvent(new CustomEvent(name, {
      detail,
      bubbles: true,
      composed: true,
      cancelable: true
    }));
  }

  // packages/alpinejs/src/utils/walk.js
  function walk(el, callback) {
    if (typeof ShadowRoot === "function" && el instanceof ShadowRoot) {
      Array.from(el.children).forEach(el2 => walk(el2, callback));
      return;
    }
    let skip = false;
    callback(el, () => skip = true);
    if (skip) return;
    let node = el.firstElementChild;
    while (node) {
      walk(node, callback);
      node = node.nextElementSibling;
    }
  }

  // packages/alpinejs/src/utils/warn.js
  function warn$1(message, ...args) {
    console.warn(`Alpine Warning: ${message}`, ...args);
  }

  // packages/alpinejs/src/lifecycle.js
  var started = false;
  function start() {
    if (started) warn$1("Alpine has already been initialized on this page. Calling Alpine.start() more than once can cause problems.");
    started = true;
    if (!document.body) warn$1("Unable to initialize. Trying to load Alpine before `<body>` is available. Did you forget to add `defer` in Alpine's `<script>` tag?");
    dispatch(document, "alpine:init");
    dispatch(document, "alpine:initializing");
    startObservingMutations();
    onElAdded(el => initTree(el, walk));
    onElRemoved(el => destroyTree(el));
    onAttributesAdded((el, attrs) => {
      directives(el, attrs).forEach(handle => handle());
    });
    let outNestedComponents = el => !closestRoot(el.parentElement, true);
    Array.from(document.querySelectorAll(allSelectors())).filter(outNestedComponents).forEach(el => {
      initTree(el);
    });
    dispatch(document, "alpine:initialized");
  }
  var rootSelectorCallbacks = [];
  var initSelectorCallbacks = [];
  function rootSelectors() {
    return rootSelectorCallbacks.map(fn => fn());
  }
  function allSelectors() {
    return rootSelectorCallbacks.concat(initSelectorCallbacks).map(fn => fn());
  }
  function addRootSelector(selectorCallback) {
    rootSelectorCallbacks.push(selectorCallback);
  }
  function addInitSelector(selectorCallback) {
    initSelectorCallbacks.push(selectorCallback);
  }
  function closestRoot(el, includeInitSelectors = false) {
    return findClosest(el, element => {
      const selectors = includeInitSelectors ? allSelectors() : rootSelectors();
      if (selectors.some(selector => element.matches(selector))) return true;
    });
  }
  function findClosest(el, callback) {
    if (!el) return;
    if (callback(el)) return el;
    if (el._x_teleportBack) el = el._x_teleportBack;
    if (!el.parentElement) return;
    return findClosest(el.parentElement, callback);
  }
  function isRoot(el) {
    return rootSelectors().some(selector => el.matches(selector));
  }
  var initInterceptors2 = [];
  function interceptInit(callback) {
    initInterceptors2.push(callback);
  }
  function initTree(el, walker = walk, intercept = () => {}) {
    deferHandlingDirectives(() => {
      walker(el, (el2, skip) => {
        intercept(el2, skip);
        initInterceptors2.forEach(i => i(el2, skip));
        directives(el2, el2.attributes).forEach(handle => handle());
        el2._x_ignore && skip();
      });
    });
  }
  function destroyTree(root) {
    walk(root, el => cleanupAttributes(el));
  }

  // packages/alpinejs/src/nextTick.js
  var tickStack = [];
  var isHolding = false;
  function nextTick(callback = () => {}) {
    queueMicrotask(() => {
      isHolding || setTimeout(() => {
        releaseNextTicks();
      });
    });
    return new Promise(res => {
      tickStack.push(() => {
        callback();
        res();
      });
    });
  }
  function releaseNextTicks() {
    isHolding = false;
    while (tickStack.length) tickStack.shift()();
  }
  function holdNextTicks() {
    isHolding = true;
  }

  // packages/alpinejs/src/utils/classes.js
  function setClasses(el, value) {
    if (Array.isArray(value)) {
      return setClassesFromString(el, value.join(" "));
    } else if (typeof value === "object" && value !== null) {
      return setClassesFromObject(el, value);
    } else if (typeof value === "function") {
      return setClasses(el, value());
    }
    return setClassesFromString(el, value);
  }
  function setClassesFromString(el, classString) {
    let missingClasses = classString2 => classString2.split(" ").filter(i => !el.classList.contains(i)).filter(Boolean);
    let addClassesAndReturnUndo = classes => {
      el.classList.add(...classes);
      return () => {
        el.classList.remove(...classes);
      };
    };
    classString = classString === true ? classString = "" : classString || "";
    return addClassesAndReturnUndo(missingClasses(classString));
  }
  function setClassesFromObject(el, classObject) {
    let split = classString => classString.split(" ").filter(Boolean);
    let forAdd = Object.entries(classObject).flatMap(([classString, bool]) => bool ? split(classString) : false).filter(Boolean);
    let forRemove = Object.entries(classObject).flatMap(([classString, bool]) => !bool ? split(classString) : false).filter(Boolean);
    let added = [];
    let removed = [];
    forRemove.forEach(i => {
      if (el.classList.contains(i)) {
        el.classList.remove(i);
        removed.push(i);
      }
    });
    forAdd.forEach(i => {
      if (!el.classList.contains(i)) {
        el.classList.add(i);
        added.push(i);
      }
    });
    return () => {
      removed.forEach(i => el.classList.add(i));
      added.forEach(i => el.classList.remove(i));
    };
  }

  // packages/alpinejs/src/utils/styles.js
  function setStyles(el, value) {
    if (typeof value === "object" && value !== null) {
      return setStylesFromObject(el, value);
    }
    return setStylesFromString(el, value);
  }
  function setStylesFromObject(el, value) {
    let previousStyles = {};
    Object.entries(value).forEach(([key, value2]) => {
      previousStyles[key] = el.style[key];
      if (!key.startsWith("--")) {
        key = kebabCase(key);
      }
      el.style.setProperty(key, value2);
    });
    setTimeout(() => {
      if (el.style.length === 0) {
        el.removeAttribute("style");
      }
    });
    return () => {
      setStyles(el, previousStyles);
    };
  }
  function setStylesFromString(el, value) {
    let cache = el.getAttribute("style", value);
    el.setAttribute("style", value);
    return () => {
      el.setAttribute("style", cache || "");
    };
  }
  function kebabCase(subject) {
    return subject.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
  }

  // packages/alpinejs/src/utils/once.js
  function once(callback, fallback = () => {}) {
    let called = false;
    return function () {
      if (!called) {
        called = true;
        callback.apply(this, arguments);
      } else {
        fallback.apply(this, arguments);
      }
    };
  }

  // packages/alpinejs/src/directives/x-transition.js
  directive("transition", (el, {
    value,
    modifiers,
    expression
  }, {
    evaluate: evaluate2
  }) => {
    if (typeof expression === "function") expression = evaluate2(expression);
    if (expression === false) return;
    if (!expression || typeof expression === "boolean") {
      registerTransitionsFromHelper(el, modifiers, value);
    } else {
      registerTransitionsFromClassString(el, expression, value);
    }
  });
  function registerTransitionsFromClassString(el, classString, stage) {
    registerTransitionObject(el, setClasses, "");
    let directiveStorageMap = {
      enter: classes => {
        el._x_transition.enter.during = classes;
      },
      "enter-start": classes => {
        el._x_transition.enter.start = classes;
      },
      "enter-end": classes => {
        el._x_transition.enter.end = classes;
      },
      leave: classes => {
        el._x_transition.leave.during = classes;
      },
      "leave-start": classes => {
        el._x_transition.leave.start = classes;
      },
      "leave-end": classes => {
        el._x_transition.leave.end = classes;
      }
    };
    directiveStorageMap[stage](classString);
  }
  function registerTransitionsFromHelper(el, modifiers, stage) {
    registerTransitionObject(el, setStyles);
    let doesntSpecify = !modifiers.includes("in") && !modifiers.includes("out") && !stage;
    let transitioningIn = doesntSpecify || modifiers.includes("in") || ["enter"].includes(stage);
    let transitioningOut = doesntSpecify || modifiers.includes("out") || ["leave"].includes(stage);
    if (modifiers.includes("in") && !doesntSpecify) {
      modifiers = modifiers.filter((i, index) => index < modifiers.indexOf("out"));
    }
    if (modifiers.includes("out") && !doesntSpecify) {
      modifiers = modifiers.filter((i, index) => index > modifiers.indexOf("out"));
    }
    let wantsAll = !modifiers.includes("opacity") && !modifiers.includes("scale");
    let wantsOpacity = wantsAll || modifiers.includes("opacity");
    let wantsScale = wantsAll || modifiers.includes("scale");
    let opacityValue = wantsOpacity ? 0 : 1;
    let scaleValue = wantsScale ? modifierValue(modifiers, "scale", 95) / 100 : 1;
    let delay = modifierValue(modifiers, "delay", 0) / 1e3;
    let origin = modifierValue(modifiers, "origin", "center");
    let property = "opacity, transform";
    let durationIn = modifierValue(modifiers, "duration", 150) / 1e3;
    let durationOut = modifierValue(modifiers, "duration", 75) / 1e3;
    let easing = `cubic-bezier(0.4, 0.0, 0.2, 1)`;
    if (transitioningIn) {
      el._x_transition.enter.during = {
        transformOrigin: origin,
        transitionDelay: `${delay}s`,
        transitionProperty: property,
        transitionDuration: `${durationIn}s`,
        transitionTimingFunction: easing
      };
      el._x_transition.enter.start = {
        opacity: opacityValue,
        transform: `scale(${scaleValue})`
      };
      el._x_transition.enter.end = {
        opacity: 1,
        transform: `scale(1)`
      };
    }
    if (transitioningOut) {
      el._x_transition.leave.during = {
        transformOrigin: origin,
        transitionDelay: `${delay}s`,
        transitionProperty: property,
        transitionDuration: `${durationOut}s`,
        transitionTimingFunction: easing
      };
      el._x_transition.leave.start = {
        opacity: 1,
        transform: `scale(1)`
      };
      el._x_transition.leave.end = {
        opacity: opacityValue,
        transform: `scale(${scaleValue})`
      };
    }
  }
  function registerTransitionObject(el, setFunction, defaultValue = {}) {
    if (!el._x_transition) el._x_transition = {
      enter: {
        during: defaultValue,
        start: defaultValue,
        end: defaultValue
      },
      leave: {
        during: defaultValue,
        start: defaultValue,
        end: defaultValue
      },
      in(before = () => {}, after = () => {}) {
        transition(el, setFunction, {
          during: this.enter.during,
          start: this.enter.start,
          end: this.enter.end
        }, before, after);
      },
      out(before = () => {}, after = () => {}) {
        transition(el, setFunction, {
          during: this.leave.during,
          start: this.leave.start,
          end: this.leave.end
        }, before, after);
      }
    };
  }
  window.Element.prototype._x_toggleAndCascadeWithTransitions = function (el, value, show, hide) {
    const nextTick2 = document.visibilityState === "visible" ? requestAnimationFrame : setTimeout;
    let clickAwayCompatibleShow = () => nextTick2(show);
    if (value) {
      if (el._x_transition && (el._x_transition.enter || el._x_transition.leave)) {
        el._x_transition.enter && (Object.entries(el._x_transition.enter.during).length || Object.entries(el._x_transition.enter.start).length || Object.entries(el._x_transition.enter.end).length) ? el._x_transition.in(show) : clickAwayCompatibleShow();
      } else {
        el._x_transition ? el._x_transition.in(show) : clickAwayCompatibleShow();
      }
      return;
    }
    el._x_hidePromise = el._x_transition ? new Promise((resolve, reject) => {
      el._x_transition.out(() => {}, () => resolve(hide));
      el._x_transitioning.beforeCancel(() => reject({
        isFromCancelledTransition: true
      }));
    }) : Promise.resolve(hide);
    queueMicrotask(() => {
      let closest = closestHide(el);
      if (closest) {
        if (!closest._x_hideChildren) closest._x_hideChildren = [];
        closest._x_hideChildren.push(el);
      } else {
        nextTick2(() => {
          let hideAfterChildren = el2 => {
            let carry = Promise.all([el2._x_hidePromise, ...(el2._x_hideChildren || []).map(hideAfterChildren)]).then(([i]) => i());
            delete el2._x_hidePromise;
            delete el2._x_hideChildren;
            return carry;
          };
          hideAfterChildren(el).catch(e => {
            if (!e.isFromCancelledTransition) throw e;
          });
        });
      }
    });
  };
  function closestHide(el) {
    let parent = el.parentNode;
    if (!parent) return;
    return parent._x_hidePromise ? parent : closestHide(parent);
  }
  function transition(el, setFunction, {
    during,
    start: start2,
    end
  } = {}, before = () => {}, after = () => {}) {
    if (el._x_transitioning) el._x_transitioning.cancel();
    if (Object.keys(during).length === 0 && Object.keys(start2).length === 0 && Object.keys(end).length === 0) {
      before();
      after();
      return;
    }
    let undoStart, undoDuring, undoEnd;
    performTransition(el, {
      start() {
        undoStart = setFunction(el, start2);
      },
      during() {
        undoDuring = setFunction(el, during);
      },
      before,
      end() {
        undoStart();
        undoEnd = setFunction(el, end);
      },
      after,
      cleanup() {
        undoDuring();
        undoEnd();
      }
    });
  }
  function performTransition(el, stages) {
    let interrupted, reachedBefore, reachedEnd;
    let finish = once(() => {
      mutateDom(() => {
        interrupted = true;
        if (!reachedBefore) stages.before();
        if (!reachedEnd) {
          stages.end();
          releaseNextTicks();
        }
        stages.after();
        if (el.isConnected) stages.cleanup();
        delete el._x_transitioning;
      });
    });
    el._x_transitioning = {
      beforeCancels: [],
      beforeCancel(callback) {
        this.beforeCancels.push(callback);
      },
      cancel: once(function () {
        while (this.beforeCancels.length) {
          this.beforeCancels.shift()();
        }
        finish();
      }),
      finish
    };
    mutateDom(() => {
      stages.start();
      stages.during();
    });
    holdNextTicks();
    requestAnimationFrame(() => {
      if (interrupted) return;
      let duration = Number(getComputedStyle(el).transitionDuration.replace(/,.*/, "").replace("s", "")) * 1e3;
      let delay = Number(getComputedStyle(el).transitionDelay.replace(/,.*/, "").replace("s", "")) * 1e3;
      if (duration === 0) duration = Number(getComputedStyle(el).animationDuration.replace("s", "")) * 1e3;
      mutateDom(() => {
        stages.before();
      });
      reachedBefore = true;
      requestAnimationFrame(() => {
        if (interrupted) return;
        mutateDom(() => {
          stages.end();
        });
        releaseNextTicks();
        setTimeout(el._x_transitioning.finish, duration + delay);
        reachedEnd = true;
      });
    });
  }
  function modifierValue(modifiers, key, fallback) {
    if (modifiers.indexOf(key) === -1) return fallback;
    const rawValue = modifiers[modifiers.indexOf(key) + 1];
    if (!rawValue) return fallback;
    if (key === "scale") {
      if (isNaN(rawValue)) return fallback;
    }
    if (key === "duration" || key === "delay") {
      let match = rawValue.match(/([0-9]+)ms/);
      if (match) return match[1];
    }
    if (key === "origin") {
      if (["top", "right", "left", "center", "bottom"].includes(modifiers[modifiers.indexOf(key) + 2])) {
        return [rawValue, modifiers[modifiers.indexOf(key) + 2]].join(" ");
      }
    }
    return rawValue;
  }

  // packages/alpinejs/src/clone.js
  var isCloning = false;
  function skipDuringClone(callback, fallback = () => {}) {
    return (...args) => isCloning ? fallback(...args) : callback(...args);
  }
  function onlyDuringClone(callback) {
    return (...args) => isCloning && callback(...args);
  }
  function clone$2(oldEl, newEl) {
    if (!newEl._x_dataStack) newEl._x_dataStack = oldEl._x_dataStack;
    isCloning = true;
    dontRegisterReactiveSideEffects(() => {
      cloneTree(newEl);
    });
    isCloning = false;
  }
  function cloneTree(el) {
    let hasRunThroughFirstEl = false;
    let shallowWalker = (el2, callback) => {
      walk(el2, (el3, skip) => {
        if (hasRunThroughFirstEl && isRoot(el3)) return skip();
        hasRunThroughFirstEl = true;
        callback(el3, skip);
      });
    };
    initTree(el, shallowWalker);
  }
  function dontRegisterReactiveSideEffects(callback) {
    let cache = effect;
    overrideEffect((callback2, el) => {
      let storedEffect = cache(callback2);
      release(storedEffect);
      return () => {};
    });
    callback();
    overrideEffect(cache);
  }

  // packages/alpinejs/src/utils/bind.js
  function bind(el, name, value, modifiers = []) {
    if (!el._x_bindings) el._x_bindings = reactive({});
    el._x_bindings[name] = value;
    name = modifiers.includes("camel") ? camelCase(name) : name;
    switch (name) {
      case "value":
        bindInputValue(el, value);
        break;
      case "style":
        bindStyles(el, value);
        break;
      case "class":
        bindClasses(el, value);
        break;
      case "selected":
      case "checked":
        bindAttributeAndProperty(el, name, value);
        break;
      default:
        bindAttribute(el, name, value);
        break;
    }
  }
  function bindInputValue(el, value) {
    if (el.type === "radio") {
      if (el.attributes.value === void 0) {
        el.value = value;
      }
      if (window.fromModel) {
        el.checked = checkedAttrLooseCompare(el.value, value);
      }
    } else if (el.type === "checkbox") {
      if (Number.isInteger(value)) {
        el.value = value;
      } else if (!Number.isInteger(value) && !Array.isArray(value) && typeof value !== "boolean" && ![null, void 0].includes(value)) {
        el.value = String(value);
      } else {
        if (Array.isArray(value)) {
          el.checked = value.some(val => checkedAttrLooseCompare(val, el.value));
        } else {
          el.checked = !!value;
        }
      }
    } else if (el.tagName === "SELECT") {
      updateSelect(el, value);
    } else {
      if (el.value === value) return;
      el.value = value;
    }
  }
  function bindClasses(el, value) {
    if (el._x_undoAddedClasses) el._x_undoAddedClasses();
    el._x_undoAddedClasses = setClasses(el, value);
  }
  function bindStyles(el, value) {
    if (el._x_undoAddedStyles) el._x_undoAddedStyles();
    el._x_undoAddedStyles = setStyles(el, value);
  }
  function bindAttributeAndProperty(el, name, value) {
    bindAttribute(el, name, value);
    setPropertyIfChanged(el, name, value);
  }
  function bindAttribute(el, name, value) {
    if ([null, void 0, false].includes(value) && attributeShouldntBePreservedIfFalsy(name)) {
      el.removeAttribute(name);
    } else {
      if (isBooleanAttr(name)) value = name;
      setIfChanged(el, name, value);
    }
  }
  function setIfChanged(el, attrName, value) {
    if (el.getAttribute(attrName) != value) {
      el.setAttribute(attrName, value);
    }
  }
  function setPropertyIfChanged(el, propName, value) {
    if (el[propName] !== value) {
      el[propName] = value;
    }
  }
  function updateSelect(el, value) {
    const arrayWrappedValue = [].concat(value).map(value2 => {
      return value2 + "";
    });
    Array.from(el.options).forEach(option => {
      option.selected = arrayWrappedValue.includes(option.value);
    });
  }
  function camelCase(subject) {
    return subject.toLowerCase().replace(/-(\w)/g, (match, char) => char.toUpperCase());
  }
  function checkedAttrLooseCompare(valueA, valueB) {
    return valueA == valueB;
  }
  function isBooleanAttr(attrName) {
    const booleanAttributes = ["disabled", "checked", "required", "readonly", "hidden", "open", "selected", "autofocus", "itemscope", "multiple", "novalidate", "allowfullscreen", "allowpaymentrequest", "formnovalidate", "autoplay", "controls", "loop", "muted", "playsinline", "default", "ismap", "reversed", "async", "defer", "nomodule"];
    return booleanAttributes.includes(attrName);
  }
  function attributeShouldntBePreservedIfFalsy(name) {
    return !["aria-pressed", "aria-checked", "aria-expanded", "aria-selected"].includes(name);
  }
  function getBinding(el, name, fallback) {
    if (el._x_bindings && el._x_bindings[name] !== void 0) return el._x_bindings[name];
    return getAttributeBinding(el, name, fallback);
  }
  function extractProp(el, name, fallback, extract = true) {
    if (el._x_bindings && el._x_bindings[name] !== void 0) return el._x_bindings[name];
    if (el._x_inlineBindings && el._x_inlineBindings[name] !== void 0) {
      let binding = el._x_inlineBindings[name];
      binding.extract = extract;
      return dontAutoEvaluateFunctions(() => {
        return evaluate(el, binding.expression);
      });
    }
    return getAttributeBinding(el, name, fallback);
  }
  function getAttributeBinding(el, name, fallback) {
    let attr = el.getAttribute(name);
    if (attr === null) return typeof fallback === "function" ? fallback() : fallback;
    if (attr === "") return true;
    if (isBooleanAttr(name)) {
      return !![name, "true"].includes(attr);
    }
    return attr;
  }

  // packages/alpinejs/src/utils/debounce.js
  function debounce(func, wait) {
    var timeout;
    return function () {
      var context = this,
        args = arguments;
      var later = function () {
        timeout = null;
        func.apply(context, args);
      };
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
    };
  }

  // packages/alpinejs/src/utils/throttle.js
  function throttle(func, limit) {
    let inThrottle;
    return function () {
      let context = this,
        args = arguments;
      if (!inThrottle) {
        func.apply(context, args);
        inThrottle = true;
        setTimeout(() => inThrottle = false, limit);
      }
    };
  }

  // packages/alpinejs/src/plugin.js
  function plugin(callback) {
    let callbacks = Array.isArray(callback) ? callback : [callback];
    callbacks.forEach(i => i(alpine_default));
  }

  // packages/alpinejs/src/store.js
  var stores = {};
  var isReactive = false;
  function store(name, value) {
    if (!isReactive) {
      stores = reactive(stores);
      isReactive = true;
    }
    if (value === void 0) {
      return stores[name];
    }
    stores[name] = value;
    if (typeof value === "object" && value !== null && value.hasOwnProperty("init") && typeof value.init === "function") {
      stores[name].init();
    }
    initInterceptors(stores[name]);
  }
  function getStores() {
    return stores;
  }

  // packages/alpinejs/src/binds.js
  var binds = {};
  function bind2(name, bindings) {
    let getBindings = typeof bindings !== "function" ? () => bindings : bindings;
    if (name instanceof Element) {
      applyBindingsObject(name, getBindings());
    } else {
      binds[name] = getBindings;
    }
  }
  function injectBindingProviders(obj) {
    Object.entries(binds).forEach(([name, callback]) => {
      Object.defineProperty(obj, name, {
        get() {
          return (...args) => {
            return callback(...args);
          };
        }
      });
    });
    return obj;
  }
  function applyBindingsObject(el, obj, original) {
    let cleanupRunners = [];
    while (cleanupRunners.length) cleanupRunners.pop()();
    let attributes = Object.entries(obj).map(([name, value]) => ({
      name,
      value
    }));
    let staticAttributes = attributesOnly(attributes);
    attributes = attributes.map(attribute => {
      if (staticAttributes.find(attr => attr.name === attribute.name)) {
        return {
          name: `x-bind:${attribute.name}`,
          value: `"${attribute.value}"`
        };
      }
      return attribute;
    });
    directives(el, attributes, original).map(handle => {
      cleanupRunners.push(handle.runCleanups);
      handle();
    });
  }

  // packages/alpinejs/src/datas.js
  var datas = {};
  function data(name, callback) {
    datas[name] = callback;
  }
  function injectDataProviders(obj, context) {
    Object.entries(datas).forEach(([name, callback]) => {
      Object.defineProperty(obj, name, {
        get() {
          return (...args) => {
            return callback.bind(context)(...args);
          };
        },
        enumerable: false
      });
    });
    return obj;
  }

  // packages/alpinejs/src/alpine.js
  var Alpine = {
    get reactive() {
      return reactive;
    },
    get release() {
      return release;
    },
    get effect() {
      return effect;
    },
    get raw() {
      return raw;
    },
    version: "3.12.3",
    flushAndStopDeferringMutations,
    dontAutoEvaluateFunctions,
    disableEffectScheduling,
    startObservingMutations,
    stopObservingMutations,
    setReactivityEngine,
    closestDataStack,
    skipDuringClone,
    onlyDuringClone,
    addRootSelector,
    addInitSelector,
    addScopeToNode,
    deferMutations,
    mapAttributes,
    evaluateLater,
    interceptInit,
    setEvaluator,
    mergeProxies,
    extractProp,
    findClosest,
    closestRoot,
    destroyTree,
    interceptor,
    transition,
    setStyles,
    mutateDom,
    directive,
    throttle,
    debounce,
    evaluate,
    initTree,
    nextTick,
    prefixed: prefix,
    prefix: setPrefix,
    plugin,
    magic,
    store,
    start,
    clone: clone$2,
    bound: getBinding,
    $data: scope,
    walk,
    data,
    bind: bind2
  };
  var alpine_default = Alpine;

  // node_modules/@vue/shared/dist/shared.esm-bundler.js
  function makeMap(str, expectsLowerCase) {
    const map = Object.create(null);
    const list = str.split(",");
    for (let i = 0; i < list.length; i++) {
      map[list[i]] = true;
    }
    return expectsLowerCase ? val => !!map[val.toLowerCase()] : val => !!map[val];
  }
  var EMPTY_OBJ = Object.freeze({}) ;
  var extend = Object.assign;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var hasOwn = (val, key) => hasOwnProperty.call(val, key);
  var isArray$1 = Array.isArray;
  var isMap = val => toTypeString(val) === "[object Map]";
  var isString = val => typeof val === "string";
  var isSymbol = val => typeof val === "symbol";
  var isObject = val => val !== null && typeof val === "object";
  var objectToString = Object.prototype.toString;
  var toTypeString = value => objectToString.call(value);
  var toRawType = value => {
    return toTypeString(value).slice(8, -1);
  };
  var isIntegerKey = key => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  var cacheStringFunction = fn => {
    const cache = Object.create(null);
    return str => {
      const hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  };
  var capitalize = cacheStringFunction(str => str.charAt(0).toUpperCase() + str.slice(1));
  var hasChanged = (value, oldValue) => value !== oldValue && (value === value || oldValue === oldValue);

  // node_modules/@vue/reactivity/dist/reactivity.esm-bundler.js
  var targetMap = new WeakMap();
  var effectStack = [];
  var activeEffect;
  var ITERATE_KEY = Symbol("iterate" );
  var MAP_KEY_ITERATE_KEY = Symbol("Map key iterate" );
  function isEffect(fn) {
    return fn && fn._isEffect === true;
  }
  function effect2(fn, options = EMPTY_OBJ) {
    if (isEffect(fn)) {
      fn = fn.raw;
    }
    const effect3 = createReactiveEffect(fn, options);
    if (!options.lazy) {
      effect3();
    }
    return effect3;
  }
  function stop(effect3) {
    if (effect3.active) {
      cleanup(effect3);
      if (effect3.options.onStop) {
        effect3.options.onStop();
      }
      effect3.active = false;
    }
  }
  var uid = 0;
  function createReactiveEffect(fn, options) {
    const effect3 = function reactiveEffect() {
      if (!effect3.active) {
        return fn();
      }
      if (!effectStack.includes(effect3)) {
        cleanup(effect3);
        try {
          enableTracking();
          effectStack.push(effect3);
          activeEffect = effect3;
          return fn();
        } finally {
          effectStack.pop();
          resetTracking();
          activeEffect = effectStack[effectStack.length - 1];
        }
      }
    };
    effect3.id = uid++;
    effect3.allowRecurse = !!options.allowRecurse;
    effect3._isEffect = true;
    effect3.active = true;
    effect3.raw = fn;
    effect3.deps = [];
    effect3.options = options;
    return effect3;
  }
  function cleanup(effect3) {
    const {
      deps
    } = effect3;
    if (deps.length) {
      for (let i = 0; i < deps.length; i++) {
        deps[i].delete(effect3);
      }
      deps.length = 0;
    }
  }
  var shouldTrack = true;
  var trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function enableTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = true;
  }
  function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
  }
  function track(target, type, key) {
    if (!shouldTrack || activeEffect === void 0) {
      return;
    }
    let depsMap = targetMap.get(target);
    if (!depsMap) {
      targetMap.set(target, depsMap = new Map());
    }
    let dep = depsMap.get(key);
    if (!dep) {
      depsMap.set(key, dep = new Set());
    }
    if (!dep.has(activeEffect)) {
      dep.add(activeEffect);
      activeEffect.deps.push(dep);
      if (activeEffect.options.onTrack) {
        activeEffect.options.onTrack({
          effect: activeEffect,
          target,
          type,
          key
        });
      }
    }
  }
  function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) {
      return;
    }
    const effects = new Set();
    const add2 = effectsToAdd => {
      if (effectsToAdd) {
        effectsToAdd.forEach(effect3 => {
          if (effect3 !== activeEffect || effect3.allowRecurse) {
            effects.add(effect3);
          }
        });
      }
    };
    if (type === "clear") {
      depsMap.forEach(add2);
    } else if (key === "length" && isArray$1(target)) {
      depsMap.forEach((dep, key2) => {
        if (key2 === "length" || key2 >= newValue) {
          add2(dep);
        }
      });
    } else {
      if (key !== void 0) {
        add2(depsMap.get(key));
      }
      switch (type) {
        case "add":
          if (!isArray$1(target)) {
            add2(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              add2(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          } else if (isIntegerKey(key)) {
            add2(depsMap.get("length"));
          }
          break;
        case "delete":
          if (!isArray$1(target)) {
            add2(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              add2(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          }
          break;
        case "set":
          if (isMap(target)) {
            add2(depsMap.get(ITERATE_KEY));
          }
          break;
      }
    }
    const run = effect3 => {
      if (effect3.options.onTrigger) {
        effect3.options.onTrigger({
          effect: effect3,
          target,
          key,
          type,
          newValue,
          oldValue,
          oldTarget
        });
      }
      if (effect3.options.scheduler) {
        effect3.options.scheduler(effect3);
      } else {
        effect3();
      }
    };
    effects.forEach(run);
  }
  var isNonTrackableKeys = /* @__PURE__ */makeMap(`__proto__,__v_isRef,__isVue`);
  var builtInSymbols = new Set(Object.getOwnPropertyNames(Symbol).map(key => Symbol[key]).filter(isSymbol));
  var get2 = /* @__PURE__ */createGetter();
  var shallowGet = /* @__PURE__ */createGetter(false, true);
  var readonlyGet = /* @__PURE__ */createGetter(true);
  var shallowReadonlyGet = /* @__PURE__ */createGetter(true, true);
  var arrayInstrumentations = {};
  ["includes", "indexOf", "lastIndexOf"].forEach(key => {
    const method = Array.prototype[key];
    arrayInstrumentations[key] = function (...args) {
      const arr = toRaw(this);
      for (let i = 0, l = this.length; i < l; i++) {
        track(arr, "get", i + "");
      }
      const res = method.apply(arr, args);
      if (res === -1 || res === false) {
        return method.apply(arr, args.map(toRaw));
      } else {
        return res;
      }
    };
  });
  ["push", "pop", "shift", "unshift", "splice"].forEach(key => {
    const method = Array.prototype[key];
    arrayInstrumentations[key] = function (...args) {
      pauseTracking();
      const res = method.apply(this, args);
      resetTracking();
      return res;
    };
  });
  function createGetter(isReadonly = false, shallow = false) {
    return function get3(target, key, receiver) {
      if (key === "__v_isReactive") {
        return !isReadonly;
      } else if (key === "__v_isReadonly") {
        return isReadonly;
      } else if (key === "__v_raw" && receiver === (isReadonly ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target)) {
        return target;
      }
      const targetIsArray = isArray$1(target);
      if (!isReadonly && targetIsArray && hasOwn(arrayInstrumentations, key)) {
        return Reflect.get(arrayInstrumentations, key, receiver);
      }
      const res = Reflect.get(target, key, receiver);
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly) {
        track(target, "get", key);
      }
      if (shallow) {
        return res;
      }
      if (isRef(res)) {
        const shouldUnwrap = !targetIsArray || !isIntegerKey(key);
        return shouldUnwrap ? res.value : res;
      }
      if (isObject(res)) {
        return isReadonly ? readonly(res) : reactive2(res);
      }
      return res;
    };
  }
  var set2 = /* @__PURE__ */createSetter();
  var shallowSet = /* @__PURE__ */createSetter(true);
  function createSetter(shallow = false) {
    return function set3(target, key, value, receiver) {
      let oldValue = target[key];
      if (!shallow) {
        value = toRaw(value);
        oldValue = toRaw(oldValue);
        if (!isArray$1(target) && isRef(oldValue) && !isRef(value)) {
          oldValue.value = value;
          return true;
        }
      }
      const hadKey = isArray$1(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn(target, key);
      const result = Reflect.set(target, key, value, receiver);
      if (target === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if (hasChanged(value, oldValue)) {
          trigger(target, "set", key, value, oldValue);
        }
      }
      return result;
    };
  }
  function deleteProperty(target, key) {
    const hadKey = hasOwn(target, key);
    const oldValue = target[key];
    const result = Reflect.deleteProperty(target, key);
    if (result && hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  function has(target, key) {
    const result = Reflect.has(target, key);
    if (!isSymbol(key) || !builtInSymbols.has(key)) {
      track(target, "has", key);
    }
    return result;
  }
  function ownKeys$1(target) {
    track(target, "iterate", isArray$1(target) ? "length" : ITERATE_KEY);
    return Reflect.ownKeys(target);
  }
  var mutableHandlers = {
    get: get2,
    set: set2,
    deleteProperty,
    has,
    ownKeys: ownKeys$1
  };
  var readonlyHandlers = {
    get: readonlyGet,
    set(target, key) {
      {
        console.warn(`Set operation on key "${String(key)}" failed: target is readonly.`, target);
      }
      return true;
    },
    deleteProperty(target, key) {
      {
        console.warn(`Delete operation on key "${String(key)}" failed: target is readonly.`, target);
      }
      return true;
    }
  };
  extend({}, mutableHandlers, {
    get: shallowGet,
    set: shallowSet
  });
  extend({}, readonlyHandlers, {
    get: shallowReadonlyGet
  });
  var toReactive = value => isObject(value) ? reactive2(value) : value;
  var toReadonly = value => isObject(value) ? readonly(value) : value;
  var toShallow = value => value;
  var getProto = v => Reflect.getPrototypeOf(v);
  function get$1$1(target, key, isReadonly = false, isShallow = false) {
    target = target["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (key !== rawKey) {
      !isReadonly && track(rawTarget, "get", key);
    }
    !isReadonly && track(rawTarget, "get", rawKey);
    const {
      has: has2
    } = getProto(rawTarget);
    const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
    if (has2.call(rawTarget, key)) {
      return wrap(target.get(key));
    } else if (has2.call(rawTarget, rawKey)) {
      return wrap(target.get(rawKey));
    } else if (target !== rawTarget) {
      target.get(key);
    }
  }
  function has$1(key, isReadonly = false) {
    const target = this["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (key !== rawKey) {
      !isReadonly && track(rawTarget, "has", key);
    }
    !isReadonly && track(rawTarget, "has", rawKey);
    return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
  }
  function size(target, isReadonly = false) {
    target = target["__v_raw"];
    !isReadonly && track(toRaw(target), "iterate", ITERATE_KEY);
    return Reflect.get(target, "size", target);
  }
  function add(value) {
    value = toRaw(value);
    const target = toRaw(this);
    const proto = getProto(target);
    const hadKey = proto.has.call(target, value);
    if (!hadKey) {
      target.add(value);
      trigger(target, "add", value, value);
    }
    return this;
  }
  function set$1$1(key, value) {
    value = toRaw(value);
    const target = toRaw(this);
    const {
      has: has2,
      get: get3
    } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get3.call(target, key);
    target.set(key, value);
    if (!hadKey) {
      trigger(target, "add", key, value);
    } else if (hasChanged(value, oldValue)) {
      trigger(target, "set", key, value, oldValue);
    }
    return this;
  }
  function deleteEntry(key) {
    const target = toRaw(this);
    const {
      has: has2,
      get: get3
    } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get3 ? get3.call(target, key) : void 0;
    const result = target.delete(key);
    if (hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  function clear() {
    const target = toRaw(this);
    const hadItems = target.size !== 0;
    const oldTarget = isMap(target) ? new Map(target) : new Set(target) ;
    const result = target.clear();
    if (hadItems) {
      trigger(target, "clear", void 0, void 0, oldTarget);
    }
    return result;
  }
  function createForEach(isReadonly, isShallow) {
    return function forEach(callback, thisArg) {
      const observed = this;
      const target = observed["__v_raw"];
      const rawTarget = toRaw(target);
      const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
      !isReadonly && track(rawTarget, "iterate", ITERATE_KEY);
      return target.forEach((value, key) => {
        return callback.call(thisArg, wrap(value), wrap(key), observed);
      });
    };
  }
  function createIterableMethod(method, isReadonly, isShallow) {
    return function (...args) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target[method](...args);
      const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
      !isReadonly && track(rawTarget, "iterate", isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY);
      return {
        next() {
          const {
            value,
            done
          } = innerIterator.next();
          return done ? {
            value,
            done
          } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function (...args) {
      {
        const key = args[0] ? `on key "${args[0]}" ` : ``;
        console.warn(`${capitalize(type)} operation ${key}failed: target is readonly.`, toRaw(this));
      }
      return type === "delete" ? false : this;
    };
  }
  var mutableInstrumentations = {
    get(key) {
      return get$1$1(this, key);
    },
    get size() {
      return size(this);
    },
    has: has$1,
    add,
    set: set$1$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, false)
  };
  var shallowInstrumentations = {
    get(key) {
      return get$1$1(this, key, false, true);
    },
    get size() {
      return size(this);
    },
    has: has$1,
    add,
    set: set$1$1,
    delete: deleteEntry,
    clear,
    forEach: createForEach(false, true)
  };
  var readonlyInstrumentations = {
    get(key) {
      return get$1$1(this, key, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false)
  };
  var shallowReadonlyInstrumentations = {
    get(key) {
      return get$1$1(this, key, true, true);
    },
    get size() {
      return size(this, true);
    },
    has(key) {
      return has$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true)
  };
  var iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
  iteratorMethods.forEach(method => {
    mutableInstrumentations[method] = createIterableMethod(method, false, false);
    readonlyInstrumentations[method] = createIterableMethod(method, true, false);
    shallowInstrumentations[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations[method] = createIterableMethod(method, true, true);
  });
  function createInstrumentationGetter(isReadonly, shallow) {
    const instrumentations = shallow ? isReadonly ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly ? readonlyInstrumentations : mutableInstrumentations;
    return (target, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly;
      } else if (key === "__v_isReadonly") {
        return isReadonly;
      } else if (key === "__v_raw") {
        return target;
      }
      return Reflect.get(hasOwn(instrumentations, key) && key in target ? instrumentations : target, key, receiver);
    };
  }
  var mutableCollectionHandlers = {
    get: createInstrumentationGetter(false, false)
  };
  var readonlyCollectionHandlers = {
    get: createInstrumentationGetter(true, false)
  };
  function checkIdentityKeys(target, has2, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has2.call(target, rawKey)) {
      const type = toRawType(target);
      console.warn(`Reactive ${type} contains both the raw and reactive versions of the same object${type === `Map` ? ` as keys` : ``}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`);
    }
  }
  var reactiveMap = new WeakMap();
  var shallowReactiveMap = new WeakMap();
  var readonlyMap = new WeakMap();
  var shallowReadonlyMap = new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2;
      default:
        return 0;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 : targetTypeMap(toRawType(value));
  }
  function reactive2(target) {
    if (target && target["__v_isReadonly"]) {
      return target;
    }
    return createReactiveObject(target, false, mutableHandlers, mutableCollectionHandlers, reactiveMap);
  }
  function readonly(target) {
    return createReactiveObject(target, true, readonlyHandlers, readonlyCollectionHandlers, readonlyMap);
  }
  function createReactiveObject(target, isReadonly, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject(target)) {
      {
        console.warn(`value cannot be made reactive: ${String(target)}`);
      }
      return target;
    }
    if (target["__v_raw"] && !(isReadonly && target["__v_isReactive"])) {
      return target;
    }
    const existingProxy = proxyMap.get(target);
    if (existingProxy) {
      return existingProxy;
    }
    const targetType = getTargetType(target);
    if (targetType === 0) {
      return target;
    }
    const proxy = new Proxy(target, targetType === 2 ? collectionHandlers : baseHandlers);
    proxyMap.set(target, proxy);
    return proxy;
  }
  function toRaw(observed) {
    return observed && toRaw(observed["__v_raw"]) || observed;
  }
  function isRef(r) {
    return Boolean(r && r.__v_isRef === true);
  }

  // packages/alpinejs/src/magics/$nextTick.js
  magic("nextTick", () => nextTick);

  // packages/alpinejs/src/magics/$dispatch.js
  magic("dispatch", el => dispatch.bind(dispatch, el));

  // packages/alpinejs/src/magics/$watch.js
  magic("watch", (el, {
    evaluateLater: evaluateLater2,
    effect: effect3
  }) => (key, callback) => {
    let evaluate2 = evaluateLater2(key);
    let firstTime = true;
    let oldValue;
    let effectReference = effect3(() => evaluate2(value => {
      JSON.stringify(value);
      if (!firstTime) {
        queueMicrotask(() => {
          callback(value, oldValue);
          oldValue = value;
        });
      } else {
        oldValue = value;
      }
      firstTime = false;
    }));
    el._x_effects.delete(effectReference);
  });

  // packages/alpinejs/src/magics/$store.js
  magic("store", getStores);

  // packages/alpinejs/src/magics/$data.js
  magic("data", el => scope(el));

  // packages/alpinejs/src/magics/$root.js
  magic("root", el => closestRoot(el));

  // packages/alpinejs/src/magics/$refs.js
  magic("refs", el => {
    if (el._x_refs_proxy) return el._x_refs_proxy;
    el._x_refs_proxy = mergeProxies(getArrayOfRefObject(el));
    return el._x_refs_proxy;
  });
  function getArrayOfRefObject(el) {
    let refObjects = [];
    let currentEl = el;
    while (currentEl) {
      if (currentEl._x_refs) refObjects.push(currentEl._x_refs);
      currentEl = currentEl.parentNode;
    }
    return refObjects;
  }

  // packages/alpinejs/src/ids.js
  var globalIdMemo = {};
  function findAndIncrementId(name) {
    if (!globalIdMemo[name]) globalIdMemo[name] = 0;
    return ++globalIdMemo[name];
  }
  function closestIdRoot(el, name) {
    return findClosest(el, element => {
      if (element._x_ids && element._x_ids[name]) return true;
    });
  }
  function setIdRoot(el, name) {
    if (!el._x_ids) el._x_ids = {};
    if (!el._x_ids[name]) el._x_ids[name] = findAndIncrementId(name);
  }

  // packages/alpinejs/src/magics/$id.js
  magic("id", el => (name, key = null) => {
    let root = closestIdRoot(el, name);
    let id = root ? root._x_ids[name] : findAndIncrementId(name);
    return key ? `${name}-${id}-${key}` : `${name}-${id}`;
  });

  // packages/alpinejs/src/magics/$el.js
  magic("el", el => el);

  // packages/alpinejs/src/magics/index.js
  warnMissingPluginMagic("Focus", "focus", "focus");
  warnMissingPluginMagic("Persist", "persist", "persist");
  function warnMissingPluginMagic(name, magicName, slug) {
    magic(magicName, el => warn$1(`You can't use [$${directiveName}] without first installing the "${name}" plugin here: https://alpinejs.dev/plugins/${slug}`, el));
  }

  // packages/alpinejs/src/entangle.js
  function entangle({
    get: outerGet,
    set: outerSet
  }, {
    get: innerGet,
    set: innerSet
  }) {
    let firstRun = true;
    let outerHash, outerHashLatest;
    let reference = effect(() => {
      let outer, inner;
      if (firstRun) {
        outer = outerGet();
        innerSet(outer);
        inner = innerGet();
        firstRun = false;
      } else {
        outer = outerGet();
        inner = innerGet();
        outerHashLatest = JSON.stringify(outer);
        JSON.stringify(inner);
        if (outerHashLatest !== outerHash) {
          inner = innerGet();
          innerSet(outer);
          inner = outer;
        } else {
          outerSet(inner);
          outer = inner;
        }
      }
      outerHash = JSON.stringify(outer);
      JSON.stringify(inner);
    });
    return () => {
      release(reference);
    };
  }

  // packages/alpinejs/src/directives/x-modelable.js
  directive("modelable", (el, {
    expression
  }, {
    effect: effect3,
    evaluateLater: evaluateLater2,
    cleanup: cleanup2
  }) => {
    let func = evaluateLater2(expression);
    let innerGet = () => {
      let result;
      func(i => result = i);
      return result;
    };
    let evaluateInnerSet = evaluateLater2(`${expression} = __placeholder`);
    let innerSet = val => evaluateInnerSet(() => {}, {
      scope: {
        __placeholder: val
      }
    });
    let initialValue = innerGet();
    innerSet(initialValue);
    queueMicrotask(() => {
      if (!el._x_model) return;
      el._x_removeModelListeners["default"]();
      let outerGet = el._x_model.get;
      let outerSet = el._x_model.set;
      let releaseEntanglement = entangle({
        get() {
          return outerGet();
        },
        set(value) {
          outerSet(value);
        }
      }, {
        get() {
          return innerGet();
        },
        set(value) {
          innerSet(value);
        }
      });
      cleanup2(releaseEntanglement);
    });
  });

  // packages/alpinejs/src/directives/x-teleport.js
  var teleportContainerDuringClone = document.createElement("div");
  directive("teleport", (el, {
    modifiers,
    expression
  }, {
    cleanup: cleanup2
  }) => {
    if (el.tagName.toLowerCase() !== "template") warn$1("x-teleport can only be used on a <template> tag", el);
    let target = skipDuringClone(() => {
      return document.querySelector(expression);
    }, () => {
      return teleportContainerDuringClone;
    })();
    if (!target) warn$1(`Cannot find x-teleport element for selector: "${expression}"`);
    let clone2 = el.content.cloneNode(true).firstElementChild;
    el._x_teleport = clone2;
    clone2._x_teleportBack = el;
    if (el._x_forwardEvents) {
      el._x_forwardEvents.forEach(eventName => {
        clone2.addEventListener(eventName, e => {
          e.stopPropagation();
          el.dispatchEvent(new e.constructor(e.type, e));
        });
      });
    }
    addScopeToNode(clone2, {}, el);
    mutateDom(() => {
      if (modifiers.includes("prepend")) {
        target.parentNode.insertBefore(clone2, target);
      } else if (modifiers.includes("append")) {
        target.parentNode.insertBefore(clone2, target.nextSibling);
      } else {
        target.appendChild(clone2);
      }
      initTree(clone2);
      clone2._x_ignore = true;
    });
    cleanup2(() => clone2.remove());
  });

  // packages/alpinejs/src/directives/x-ignore.js
  var handler = () => {};
  handler.inline = (el, {
    modifiers
  }, {
    cleanup: cleanup2
  }) => {
    modifiers.includes("self") ? el._x_ignoreSelf = true : el._x_ignore = true;
    cleanup2(() => {
      modifiers.includes("self") ? delete el._x_ignoreSelf : delete el._x_ignore;
    });
  };
  directive("ignore", handler);

  // packages/alpinejs/src/directives/x-effect.js
  directive("effect", (el, {
    expression
  }, {
    effect: effect3
  }) => effect3(evaluateLater(el, expression)));

  // packages/alpinejs/src/utils/on.js
  function on(el, event, modifiers, callback) {
    let listenerTarget = el;
    let handler4 = e => callback(e);
    let options = {};
    let wrapHandler = (callback2, wrapper) => e => wrapper(callback2, e);
    if (modifiers.includes("dot")) event = dotSyntax(event);
    if (modifiers.includes("camel")) event = camelCase2(event);
    if (modifiers.includes("passive")) options.passive = true;
    if (modifiers.includes("capture")) options.capture = true;
    if (modifiers.includes("window")) listenerTarget = window;
    if (modifiers.includes("document")) listenerTarget = document;
    if (modifiers.includes("debounce")) {
      let nextModifier = modifiers[modifiers.indexOf("debounce") + 1] || "invalid-wait";
      let wait = isNumeric(nextModifier.split("ms")[0]) ? Number(nextModifier.split("ms")[0]) : 250;
      handler4 = debounce(handler4, wait);
    }
    if (modifiers.includes("throttle")) {
      let nextModifier = modifiers[modifiers.indexOf("throttle") + 1] || "invalid-wait";
      let wait = isNumeric(nextModifier.split("ms")[0]) ? Number(nextModifier.split("ms")[0]) : 250;
      handler4 = throttle(handler4, wait);
    }
    if (modifiers.includes("prevent")) handler4 = wrapHandler(handler4, (next, e) => {
      e.preventDefault();
      next(e);
    });
    if (modifiers.includes("stop")) handler4 = wrapHandler(handler4, (next, e) => {
      e.stopPropagation();
      next(e);
    });
    if (modifiers.includes("self")) handler4 = wrapHandler(handler4, (next, e) => {
      e.target === el && next(e);
    });
    if (modifiers.includes("away") || modifiers.includes("outside")) {
      listenerTarget = document;
      handler4 = wrapHandler(handler4, (next, e) => {
        if (el.contains(e.target)) return;
        if (e.target.isConnected === false) return;
        if (el.offsetWidth < 1 && el.offsetHeight < 1) return;
        if (el._x_isShown === false) return;
        next(e);
      });
    }
    if (modifiers.includes("once")) {
      handler4 = wrapHandler(handler4, (next, e) => {
        next(e);
        listenerTarget.removeEventListener(event, handler4, options);
      });
    }
    handler4 = wrapHandler(handler4, (next, e) => {
      if (isKeyEvent(event)) {
        if (isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers)) {
          return;
        }
      }
      next(e);
    });
    listenerTarget.addEventListener(event, handler4, options);
    return () => {
      listenerTarget.removeEventListener(event, handler4, options);
    };
  }
  function dotSyntax(subject) {
    return subject.replace(/-/g, ".");
  }
  function camelCase2(subject) {
    return subject.toLowerCase().replace(/-(\w)/g, (match, char) => char.toUpperCase());
  }
  function isNumeric(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
  }
  function kebabCase2(subject) {
    if ([" ", "_"].includes(subject)) return subject;
    return subject.replace(/([a-z])([A-Z])/g, "$1-$2").replace(/[_\s]/, "-").toLowerCase();
  }
  function isKeyEvent(event) {
    return ["keydown", "keyup"].includes(event);
  }
  function isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers) {
    let keyModifiers = modifiers.filter(i => {
      return !["window", "document", "prevent", "stop", "once", "capture"].includes(i);
    });
    if (keyModifiers.includes("debounce")) {
      let debounceIndex = keyModifiers.indexOf("debounce");
      keyModifiers.splice(debounceIndex, isNumeric((keyModifiers[debounceIndex + 1] || "invalid-wait").split("ms")[0]) ? 2 : 1);
    }
    if (keyModifiers.includes("throttle")) {
      let debounceIndex = keyModifiers.indexOf("throttle");
      keyModifiers.splice(debounceIndex, isNumeric((keyModifiers[debounceIndex + 1] || "invalid-wait").split("ms")[0]) ? 2 : 1);
    }
    if (keyModifiers.length === 0) return false;
    if (keyModifiers.length === 1 && keyToModifiers(e.key).includes(keyModifiers[0])) return false;
    const systemKeyModifiers = ["ctrl", "shift", "alt", "meta", "cmd", "super"];
    const selectedSystemKeyModifiers = systemKeyModifiers.filter(modifier => keyModifiers.includes(modifier));
    keyModifiers = keyModifiers.filter(i => !selectedSystemKeyModifiers.includes(i));
    if (selectedSystemKeyModifiers.length > 0) {
      const activelyPressedKeyModifiers = selectedSystemKeyModifiers.filter(modifier => {
        if (modifier === "cmd" || modifier === "super") modifier = "meta";
        return e[`${modifier}Key`];
      });
      if (activelyPressedKeyModifiers.length === selectedSystemKeyModifiers.length) {
        if (keyToModifiers(e.key).includes(keyModifiers[0])) return false;
      }
    }
    return true;
  }
  function keyToModifiers(key) {
    if (!key) return [];
    key = kebabCase2(key);
    let modifierToKeyMap = {
      ctrl: "control",
      slash: "/",
      space: " ",
      spacebar: " ",
      cmd: "meta",
      esc: "escape",
      up: "arrow-up",
      down: "arrow-down",
      left: "arrow-left",
      right: "arrow-right",
      period: ".",
      equal: "=",
      minus: "-",
      underscore: "_"
    };
    modifierToKeyMap[key] = key;
    return Object.keys(modifierToKeyMap).map(modifier => {
      if (modifierToKeyMap[modifier] === key) return modifier;
    }).filter(modifier => modifier);
  }

  // packages/alpinejs/src/directives/x-model.js
  directive("model", (el, {
    modifiers,
    expression
  }, {
    effect: effect3,
    cleanup: cleanup2
  }) => {
    let scopeTarget = el;
    if (modifiers.includes("parent")) {
      scopeTarget = el.parentNode;
    }
    let evaluateGet = evaluateLater(scopeTarget, expression);
    let evaluateSet;
    if (typeof expression === "string") {
      evaluateSet = evaluateLater(scopeTarget, `${expression} = __placeholder`);
    } else if (typeof expression === "function" && typeof expression() === "string") {
      evaluateSet = evaluateLater(scopeTarget, `${expression()} = __placeholder`);
    } else {
      evaluateSet = () => {};
    }
    let getValue = () => {
      let result;
      evaluateGet(value => result = value);
      return isGetterSetter(result) ? result.get() : result;
    };
    let setValue = value => {
      let result;
      evaluateGet(value2 => result = value2);
      if (isGetterSetter(result)) {
        result.set(value);
      } else {
        evaluateSet(() => {}, {
          scope: {
            __placeholder: value
          }
        });
      }
    };
    if (typeof expression === "string" && el.type === "radio") {
      mutateDom(() => {
        if (!el.hasAttribute("name")) el.setAttribute("name", expression);
      });
    }
    var event = el.tagName.toLowerCase() === "select" || ["checkbox", "radio"].includes(el.type) || modifiers.includes("lazy") ? "change" : "input";
    let removeListener = isCloning ? () => {} : on(el, event, modifiers, e => {
      setValue(getInputValue(el, modifiers, e, getValue()));
    });
    if (modifiers.includes("fill") && [null, ""].includes(getValue())) {
      el.dispatchEvent(new Event(event, {}));
    }
    if (!el._x_removeModelListeners) el._x_removeModelListeners = {};
    el._x_removeModelListeners["default"] = removeListener;
    cleanup2(() => el._x_removeModelListeners["default"]());
    if (el.form) {
      let removeResetListener = on(el.form, "reset", [], e => {
        nextTick(() => el._x_model && el._x_model.set(el.value));
      });
      cleanup2(() => removeResetListener());
    }
    el._x_model = {
      get() {
        return getValue();
      },
      set(value) {
        setValue(value);
      }
    };
    el._x_forceModelUpdate = value => {
      value = value === void 0 ? getValue() : value;
      if (value === void 0 && typeof expression === "string" && expression.match(/\./)) value = "";
      window.fromModel = true;
      mutateDom(() => bind(el, "value", value));
      delete window.fromModel;
    };
    effect3(() => {
      let value = getValue();
      if (modifiers.includes("unintrusive") && document.activeElement.isSameNode(el)) return;
      el._x_forceModelUpdate(value);
    });
  });
  function getInputValue(el, modifiers, event, currentValue) {
    return mutateDom(() => {
      if (event instanceof CustomEvent && event.detail !== void 0) return event.detail ?? event.target.value;else if (el.type === "checkbox") {
        if (Array.isArray(currentValue)) {
          let newValue = modifiers.includes("number") ? safeParseNumber(event.target.value) : event.target.value;
          return event.target.checked ? currentValue.concat([newValue]) : currentValue.filter(el2 => !checkedAttrLooseCompare2(el2, newValue));
        } else {
          return event.target.checked;
        }
      } else if (el.tagName.toLowerCase() === "select" && el.multiple) {
        return modifiers.includes("number") ? Array.from(event.target.selectedOptions).map(option => {
          let rawValue = option.value || option.text;
          return safeParseNumber(rawValue);
        }) : Array.from(event.target.selectedOptions).map(option => {
          return option.value || option.text;
        });
      } else {
        let rawValue = event.target.value;
        return modifiers.includes("number") ? safeParseNumber(rawValue) : modifiers.includes("trim") ? rawValue.trim() : rawValue;
      }
    });
  }
  function safeParseNumber(rawValue) {
    let number = rawValue ? parseFloat(rawValue) : null;
    return isNumeric2(number) ? number : rawValue;
  }
  function checkedAttrLooseCompare2(valueA, valueB) {
    return valueA == valueB;
  }
  function isNumeric2(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
  }
  function isGetterSetter(value) {
    return value !== null && typeof value === "object" && typeof value.get === "function" && typeof value.set === "function";
  }

  // packages/alpinejs/src/directives/x-cloak.js
  directive("cloak", el => queueMicrotask(() => mutateDom(() => el.removeAttribute(prefix("cloak")))));

  // packages/alpinejs/src/directives/x-init.js
  addInitSelector(() => `[${prefix("init")}]`);
  directive("init", skipDuringClone((el, {
    expression
  }, {
    evaluate: evaluate2
  }) => {
    if (typeof expression === "string") {
      return !!expression.trim() && evaluate2(expression, {}, false);
    }
    return evaluate2(expression, {}, false);
  }));

  // packages/alpinejs/src/directives/x-text.js
  directive("text", (el, {
    expression
  }, {
    effect: effect3,
    evaluateLater: evaluateLater2
  }) => {
    let evaluate2 = evaluateLater2(expression);
    effect3(() => {
      evaluate2(value => {
        mutateDom(() => {
          el.textContent = value;
        });
      });
    });
  });

  // packages/alpinejs/src/directives/x-html.js
  directive("html", (el, {
    expression
  }, {
    effect: effect3,
    evaluateLater: evaluateLater2
  }) => {
    let evaluate2 = evaluateLater2(expression);
    effect3(() => {
      evaluate2(value => {
        mutateDom(() => {
          el.innerHTML = value;
          el._x_ignoreSelf = true;
          initTree(el);
          delete el._x_ignoreSelf;
        });
      });
    });
  });

  // packages/alpinejs/src/directives/x-bind.js
  mapAttributes(startingWith(":", into(prefix("bind:"))));
  var handler2 = (el, {
    value,
    modifiers,
    expression,
    original
  }, {
    effect: effect3
  }) => {
    if (!value) {
      let bindingProviders = {};
      injectBindingProviders(bindingProviders);
      let getBindings = evaluateLater(el, expression);
      getBindings(bindings => {
        applyBindingsObject(el, bindings, original);
      }, {
        scope: bindingProviders
      });
      return;
    }
    if (value === "key") return storeKeyForXFor(el, expression);
    if (el._x_inlineBindings && el._x_inlineBindings[value] && el._x_inlineBindings[value].extract) {
      return;
    }
    let evaluate2 = evaluateLater(el, expression);
    effect3(() => evaluate2(result => {
      if (result === void 0 && typeof expression === "string" && expression.match(/\./)) {
        result = "";
      }
      mutateDom(() => bind(el, value, result, modifiers));
    }));
  };
  handler2.inline = (el, {
    value,
    modifiers,
    expression
  }) => {
    if (!value) return;
    if (!el._x_inlineBindings) el._x_inlineBindings = {};
    el._x_inlineBindings[value] = {
      expression,
      extract: false
    };
  };
  directive("bind", handler2);
  function storeKeyForXFor(el, expression) {
    el._x_keyExpression = expression;
  }

  // packages/alpinejs/src/directives/x-data.js
  addRootSelector(() => `[${prefix("data")}]`);
  directive("data", skipDuringClone((el, {
    expression
  }, {
    cleanup: cleanup2
  }) => {
    expression = expression === "" ? "{}" : expression;
    let magicContext = {};
    injectMagics(magicContext, el);
    let dataProviderContext = {};
    injectDataProviders(dataProviderContext, magicContext);
    let data2 = evaluate(el, expression, {
      scope: dataProviderContext
    });
    if (data2 === void 0 || data2 === true) data2 = {};
    injectMagics(data2, el);
    let reactiveData = reactive(data2);
    initInterceptors(reactiveData);
    let undo = addScopeToNode(el, reactiveData);
    reactiveData["init"] && evaluate(el, reactiveData["init"]);
    cleanup2(() => {
      reactiveData["destroy"] && evaluate(el, reactiveData["destroy"]);
      undo();
    });
  }));

  // packages/alpinejs/src/directives/x-show.js
  directive("show", (el, {
    modifiers,
    expression
  }, {
    effect: effect3
  }) => {
    let evaluate2 = evaluateLater(el, expression);
    if (!el._x_doHide) el._x_doHide = () => {
      mutateDom(() => {
        el.style.setProperty("display", "none", modifiers.includes("important") ? "important" : void 0);
      });
    };
    if (!el._x_doShow) el._x_doShow = () => {
      mutateDom(() => {
        if (el.style.length === 1 && el.style.display === "none") {
          el.removeAttribute("style");
        } else {
          el.style.removeProperty("display");
        }
      });
    };
    let hide = () => {
      el._x_doHide();
      el._x_isShown = false;
    };
    let show = () => {
      el._x_doShow();
      el._x_isShown = true;
    };
    let clickAwayCompatibleShow = () => setTimeout(show);
    let toggle = once(value => value ? show() : hide(), value => {
      if (typeof el._x_toggleAndCascadeWithTransitions === "function") {
        el._x_toggleAndCascadeWithTransitions(el, value, show, hide);
      } else {
        value ? clickAwayCompatibleShow() : hide();
      }
    });
    let oldValue;
    let firstTime = true;
    effect3(() => evaluate2(value => {
      if (!firstTime && value === oldValue) return;
      if (modifiers.includes("immediate")) value ? clickAwayCompatibleShow() : hide();
      toggle(value);
      oldValue = value;
      firstTime = false;
    }));
  });

  // packages/alpinejs/src/directives/x-for.js
  directive("for", (el, {
    expression
  }, {
    effect: effect3,
    cleanup: cleanup2
  }) => {
    let iteratorNames = parseForExpression(expression);
    let evaluateItems = evaluateLater(el, iteratorNames.items);
    let evaluateKey = evaluateLater(el, el._x_keyExpression || "index");
    el._x_prevKeys = [];
    el._x_lookup = {};
    effect3(() => loop(el, iteratorNames, evaluateItems, evaluateKey));
    cleanup2(() => {
      Object.values(el._x_lookup).forEach(el2 => el2.remove());
      delete el._x_prevKeys;
      delete el._x_lookup;
    });
  });
  function loop(el, iteratorNames, evaluateItems, evaluateKey) {
    let isObject2 = i => typeof i === "object" && !Array.isArray(i);
    let templateEl = el;
    evaluateItems(items => {
      if (isNumeric3(items) && items >= 0) {
        items = Array.from(Array(items).keys(), i => i + 1);
      }
      if (items === void 0) items = [];
      let lookup = el._x_lookup;
      let prevKeys = el._x_prevKeys;
      let scopes = [];
      let keys = [];
      if (isObject2(items)) {
        items = Object.entries(items).map(([key, value]) => {
          let scope2 = getIterationScopeVariables(iteratorNames, value, key, items);
          evaluateKey(value2 => keys.push(value2), {
            scope: {
              index: key,
              ...scope2
            }
          });
          scopes.push(scope2);
        });
      } else {
        for (let i = 0; i < items.length; i++) {
          let scope2 = getIterationScopeVariables(iteratorNames, items[i], i, items);
          evaluateKey(value => keys.push(value), {
            scope: {
              index: i,
              ...scope2
            }
          });
          scopes.push(scope2);
        }
      }
      let adds = [];
      let moves = [];
      let removes = [];
      let sames = [];
      for (let i = 0; i < prevKeys.length; i++) {
        let key = prevKeys[i];
        if (keys.indexOf(key) === -1) removes.push(key);
      }
      prevKeys = prevKeys.filter(key => !removes.includes(key));
      let lastKey = "template";
      for (let i = 0; i < keys.length; i++) {
        let key = keys[i];
        let prevIndex = prevKeys.indexOf(key);
        if (prevIndex === -1) {
          prevKeys.splice(i, 0, key);
          adds.push([lastKey, i]);
        } else if (prevIndex !== i) {
          let keyInSpot = prevKeys.splice(i, 1)[0];
          let keyForSpot = prevKeys.splice(prevIndex - 1, 1)[0];
          prevKeys.splice(i, 0, keyForSpot);
          prevKeys.splice(prevIndex, 0, keyInSpot);
          moves.push([keyInSpot, keyForSpot]);
        } else {
          sames.push(key);
        }
        lastKey = key;
      }
      for (let i = 0; i < removes.length; i++) {
        let key = removes[i];
        if (!!lookup[key]._x_effects) {
          lookup[key]._x_effects.forEach(dequeueJob);
        }
        lookup[key].remove();
        lookup[key] = null;
        delete lookup[key];
      }
      for (let i = 0; i < moves.length; i++) {
        let [keyInSpot, keyForSpot] = moves[i];
        let elInSpot = lookup[keyInSpot];
        let elForSpot = lookup[keyForSpot];
        let marker = document.createElement("div");
        mutateDom(() => {
          if (!elForSpot) warn$1(`x-for ":key" is undefined or invalid`, templateEl);
          elForSpot.after(marker);
          elInSpot.after(elForSpot);
          elForSpot._x_currentIfEl && elForSpot.after(elForSpot._x_currentIfEl);
          marker.before(elInSpot);
          elInSpot._x_currentIfEl && elInSpot.after(elInSpot._x_currentIfEl);
          marker.remove();
        });
        elForSpot._x_refreshXForScope(scopes[keys.indexOf(keyForSpot)]);
      }
      for (let i = 0; i < adds.length; i++) {
        let [lastKey2, index] = adds[i];
        let lastEl = lastKey2 === "template" ? templateEl : lookup[lastKey2];
        if (lastEl._x_currentIfEl) lastEl = lastEl._x_currentIfEl;
        let scope2 = scopes[index];
        let key = keys[index];
        let clone2 = document.importNode(templateEl.content, true).firstElementChild;
        let reactiveScope = reactive(scope2);
        addScopeToNode(clone2, reactiveScope, templateEl);
        clone2._x_refreshXForScope = newScope => {
          Object.entries(newScope).forEach(([key2, value]) => {
            reactiveScope[key2] = value;
          });
        };
        mutateDom(() => {
          lastEl.after(clone2);
          initTree(clone2);
        });
        if (typeof key === "object") {
          warn$1("x-for key cannot be an object, it must be a string or an integer", templateEl);
        }
        lookup[key] = clone2;
      }
      for (let i = 0; i < sames.length; i++) {
        lookup[sames[i]]._x_refreshXForScope(scopes[keys.indexOf(sames[i])]);
      }
      templateEl._x_prevKeys = keys;
    });
  }
  function parseForExpression(expression) {
    let forIteratorRE = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
    let stripParensRE = /^\s*\(|\)\s*$/g;
    let forAliasRE = /([\s\S]*?)\s+(?:in|of)\s+([\s\S]*)/;
    let inMatch = expression.match(forAliasRE);
    if (!inMatch) return;
    let res = {};
    res.items = inMatch[2].trim();
    let item = inMatch[1].replace(stripParensRE, "").trim();
    let iteratorMatch = item.match(forIteratorRE);
    if (iteratorMatch) {
      res.item = item.replace(forIteratorRE, "").trim();
      res.index = iteratorMatch[1].trim();
      if (iteratorMatch[2]) {
        res.collection = iteratorMatch[2].trim();
      }
    } else {
      res.item = item;
    }
    return res;
  }
  function getIterationScopeVariables(iteratorNames, item, index, items) {
    let scopeVariables = {};
    if (/^\[.*\]$/.test(iteratorNames.item) && Array.isArray(item)) {
      let names = iteratorNames.item.replace("[", "").replace("]", "").split(",").map(i => i.trim());
      names.forEach((name, i) => {
        scopeVariables[name] = item[i];
      });
    } else if (/^\{.*\}$/.test(iteratorNames.item) && !Array.isArray(item) && typeof item === "object") {
      let names = iteratorNames.item.replace("{", "").replace("}", "").split(",").map(i => i.trim());
      names.forEach(name => {
        scopeVariables[name] = item[name];
      });
    } else {
      scopeVariables[iteratorNames.item] = item;
    }
    if (iteratorNames.index) scopeVariables[iteratorNames.index] = index;
    if (iteratorNames.collection) scopeVariables[iteratorNames.collection] = items;
    return scopeVariables;
  }
  function isNumeric3(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
  }

  // packages/alpinejs/src/directives/x-ref.js
  function handler3() {}
  handler3.inline = (el, {
    expression
  }, {
    cleanup: cleanup2
  }) => {
    let root = closestRoot(el);
    if (!root._x_refs) root._x_refs = {};
    root._x_refs[expression] = el;
    cleanup2(() => delete root._x_refs[expression]);
  };
  directive("ref", handler3);

  // packages/alpinejs/src/directives/x-if.js
  directive("if", (el, {
    expression
  }, {
    effect: effect3,
    cleanup: cleanup2
  }) => {
    let evaluate2 = evaluateLater(el, expression);
    let show = () => {
      if (el._x_currentIfEl) return el._x_currentIfEl;
      let clone2 = el.content.cloneNode(true).firstElementChild;
      addScopeToNode(clone2, {}, el);
      mutateDom(() => {
        el.after(clone2);
        initTree(clone2);
      });
      el._x_currentIfEl = clone2;
      el._x_undoIf = () => {
        walk(clone2, node => {
          if (!!node._x_effects) {
            node._x_effects.forEach(dequeueJob);
          }
        });
        clone2.remove();
        delete el._x_currentIfEl;
      };
      return clone2;
    };
    let hide = () => {
      if (!el._x_undoIf) return;
      el._x_undoIf();
      delete el._x_undoIf;
    };
    effect3(() => evaluate2(value => {
      value ? show() : hide();
    }));
    cleanup2(() => el._x_undoIf && el._x_undoIf());
  });

  // packages/alpinejs/src/directives/x-id.js
  directive("id", (el, {
    expression
  }, {
    evaluate: evaluate2
  }) => {
    let names = evaluate2(expression);
    names.forEach(name => setIdRoot(el, name));
  });

  // packages/alpinejs/src/directives/x-on.js
  mapAttributes(startingWith("@", into(prefix("on:"))));
  directive("on", skipDuringClone((el, {
    value,
    modifiers,
    expression
  }, {
    cleanup: cleanup2
  }) => {
    let evaluate2 = expression ? evaluateLater(el, expression) : () => {};
    if (el.tagName.toLowerCase() === "template") {
      if (!el._x_forwardEvents) el._x_forwardEvents = [];
      if (!el._x_forwardEvents.includes(value)) el._x_forwardEvents.push(value);
    }
    let removeListener = on(el, value, modifiers, e => {
      evaluate2(() => {}, {
        scope: {
          $event: e
        },
        params: [e]
      });
    });
    cleanup2(() => removeListener());
  }));

  // packages/alpinejs/src/directives/index.js
  warnMissingPluginDirective("Collapse", "collapse", "collapse");
  warnMissingPluginDirective("Intersect", "intersect", "intersect");
  warnMissingPluginDirective("Focus", "trap", "focus");
  warnMissingPluginDirective("Mask", "mask", "mask");
  function warnMissingPluginDirective(name, directiveName2, slug) {
    directive(directiveName2, el => warn$1(`You can't use [x-${directiveName2}] without first installing the "${name}" plugin here: https://alpinejs.dev/plugins/${slug}`, el));
  }

  // packages/alpinejs/src/index.js
  alpine_default.setEvaluator(normalEvaluator);
  alpine_default.setReactivityEngine({
    reactive: reactive2,
    effect: effect2,
    release: stop,
    raw: toRaw
  });
  var src_default$1 = alpine_default;

  // packages/alpinejs/builds/module.js
  var module_default$1 = src_default$1;

  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __markAsModule = target => __defProp(target, "__esModule", {
    value: true
  });
  var __commonJS = (callback, module) => () => {
    if (!module) {
      module = {
        exports: {}
      };
      callback(module.exports, module);
    }
    return module.exports;
  };
  var __exportStar = (target, module, desc) => {
    if (module && typeof module === "object" || typeof module === "function") {
      for (let key of __getOwnPropNames(module)) if (!__hasOwnProp.call(target, key) && key !== "default") __defProp(target, key, {
        get: () => module[key],
        enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable
      });
    }
    return target;
  };
  var __toModule = module => {
    return __exportStar(__markAsModule(__defProp(module != null ? __create(__getProtoOf(module)) : {}, "default", module && module.__esModule && "default" in module ? {
      get: () => module.default,
      enumerable: true
    } : {
      value: module,
      enumerable: true
    })), module);
  };

  // node_modules/@popperjs/core/dist/cjs/popper.js
  var require_popper = __commonJS(exports => {

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function getBoundingClientRect(element) {
      var rect = element.getBoundingClientRect();
      return {
        width: rect.width,
        height: rect.height,
        top: rect.top,
        right: rect.right,
        bottom: rect.bottom,
        left: rect.left,
        x: rect.left,
        y: rect.top
      };
    }
    function getWindow(node) {
      if (node == null) {
        return window;
      }
      if (node.toString() !== "[object Window]") {
        var ownerDocument = node.ownerDocument;
        return ownerDocument ? ownerDocument.defaultView || window : window;
      }
      return node;
    }
    function getWindowScroll(node) {
      var win = getWindow(node);
      var scrollLeft = win.pageXOffset;
      var scrollTop = win.pageYOffset;
      return {
        scrollLeft,
        scrollTop
      };
    }
    function isElement(node) {
      var OwnElement = getWindow(node).Element;
      return node instanceof OwnElement || node instanceof Element;
    }
    function isHTMLElement(node) {
      var OwnElement = getWindow(node).HTMLElement;
      return node instanceof OwnElement || node instanceof HTMLElement;
    }
    function isShadowRoot(node) {
      if (typeof ShadowRoot === "undefined") {
        return false;
      }
      var OwnElement = getWindow(node).ShadowRoot;
      return node instanceof OwnElement || node instanceof ShadowRoot;
    }
    function getHTMLElementScroll(element) {
      return {
        scrollLeft: element.scrollLeft,
        scrollTop: element.scrollTop
      };
    }
    function getNodeScroll(node) {
      if (node === getWindow(node) || !isHTMLElement(node)) {
        return getWindowScroll(node);
      } else {
        return getHTMLElementScroll(node);
      }
    }
    function getNodeName(element) {
      return element ? (element.nodeName || "").toLowerCase() : null;
    }
    function getDocumentElement(element) {
      return ((isElement(element) ? element.ownerDocument : element.document) || window.document).documentElement;
    }
    function getWindowScrollBarX(element) {
      return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
    }
    function getComputedStyle(element) {
      return getWindow(element).getComputedStyle(element);
    }
    function isScrollParent(element) {
      var _getComputedStyle = getComputedStyle(element),
        overflow = _getComputedStyle.overflow,
        overflowX = _getComputedStyle.overflowX,
        overflowY = _getComputedStyle.overflowY;
      return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
    }
    function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
      if (isFixed === void 0) {
        isFixed = false;
      }
      var documentElement = getDocumentElement(offsetParent);
      var rect = getBoundingClientRect(elementOrVirtualElement);
      var isOffsetParentAnElement = isHTMLElement(offsetParent);
      var scroll = {
        scrollLeft: 0,
        scrollTop: 0
      };
      var offsets = {
        x: 0,
        y: 0
      };
      if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
        if (getNodeName(offsetParent) !== "body" || isScrollParent(documentElement)) {
          scroll = getNodeScroll(offsetParent);
        }
        if (isHTMLElement(offsetParent)) {
          offsets = getBoundingClientRect(offsetParent);
          offsets.x += offsetParent.clientLeft;
          offsets.y += offsetParent.clientTop;
        } else if (documentElement) {
          offsets.x = getWindowScrollBarX(documentElement);
        }
      }
      return {
        x: rect.left + scroll.scrollLeft - offsets.x,
        y: rect.top + scroll.scrollTop - offsets.y,
        width: rect.width,
        height: rect.height
      };
    }
    function getLayoutRect(element) {
      var clientRect = getBoundingClientRect(element);
      var width = element.offsetWidth;
      var height = element.offsetHeight;
      if (Math.abs(clientRect.width - width) <= 1) {
        width = clientRect.width;
      }
      if (Math.abs(clientRect.height - height) <= 1) {
        height = clientRect.height;
      }
      return {
        x: element.offsetLeft,
        y: element.offsetTop,
        width,
        height
      };
    }
    function getParentNode(element) {
      if (getNodeName(element) === "html") {
        return element;
      }
      return element.assignedSlot || element.parentNode || (isShadowRoot(element) ? element.host : null) || getDocumentElement(element);
    }
    function getScrollParent(node) {
      if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
        return node.ownerDocument.body;
      }
      if (isHTMLElement(node) && isScrollParent(node)) {
        return node;
      }
      return getScrollParent(getParentNode(node));
    }
    function listScrollParents(element, list) {
      var _element$ownerDocumen;
      if (list === void 0) {
        list = [];
      }
      var scrollParent = getScrollParent(element);
      var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
      var win = getWindow(scrollParent);
      var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
      var updatedList = list.concat(target);
      return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
    }
    function isTableElement(element) {
      return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
    }
    function getTrueOffsetParent(element) {
      if (!isHTMLElement(element) || getComputedStyle(element).position === "fixed") {
        return null;
      }
      return element.offsetParent;
    }
    function getContainingBlock(element) {
      var isFirefox = navigator.userAgent.toLowerCase().indexOf("firefox") !== -1;
      var isIE = navigator.userAgent.indexOf("Trident") !== -1;
      if (isIE && isHTMLElement(element)) {
        var elementCss = getComputedStyle(element);
        if (elementCss.position === "fixed") {
          return null;
        }
      }
      var currentNode = getParentNode(element);
      while (isHTMLElement(currentNode) && ["html", "body"].indexOf(getNodeName(currentNode)) < 0) {
        var css = getComputedStyle(currentNode);
        if (css.transform !== "none" || css.perspective !== "none" || css.contain === "paint" || ["transform", "perspective"].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === "filter" || isFirefox && css.filter && css.filter !== "none") {
          return currentNode;
        } else {
          currentNode = currentNode.parentNode;
        }
      }
      return null;
    }
    function getOffsetParent(element) {
      var window2 = getWindow(element);
      var offsetParent = getTrueOffsetParent(element);
      while (offsetParent && isTableElement(offsetParent) && getComputedStyle(offsetParent).position === "static") {
        offsetParent = getTrueOffsetParent(offsetParent);
      }
      if (offsetParent && (getNodeName(offsetParent) === "html" || getNodeName(offsetParent) === "body" && getComputedStyle(offsetParent).position === "static")) {
        return window2;
      }
      return offsetParent || getContainingBlock(element) || window2;
    }
    var top = "top";
    var bottom = "bottom";
    var right = "right";
    var left = "left";
    var auto = "auto";
    var basePlacements = [top, bottom, right, left];
    var start = "start";
    var end = "end";
    var clippingParents = "clippingParents";
    var viewport = "viewport";
    var popper = "popper";
    var reference = "reference";
    var variationPlacements = /* @__PURE__ */basePlacements.reduce(function (acc, placement) {
      return acc.concat([placement + "-" + start, placement + "-" + end]);
    }, []);
    var placements = /* @__PURE__ */[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
      return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
    }, []);
    var beforeRead = "beforeRead";
    var read = "read";
    var afterRead = "afterRead";
    var beforeMain = "beforeMain";
    var main = "main";
    var afterMain = "afterMain";
    var beforeWrite = "beforeWrite";
    var write = "write";
    var afterWrite = "afterWrite";
    var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];
    function order(modifiers) {
      var map = new Map();
      var visited = new Set();
      var result = [];
      modifiers.forEach(function (modifier) {
        map.set(modifier.name, modifier);
      });
      function sort(modifier) {
        visited.add(modifier.name);
        var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
        requires.forEach(function (dep) {
          if (!visited.has(dep)) {
            var depModifier = map.get(dep);
            if (depModifier) {
              sort(depModifier);
            }
          }
        });
        result.push(modifier);
      }
      modifiers.forEach(function (modifier) {
        if (!visited.has(modifier.name)) {
          sort(modifier);
        }
      });
      return result;
    }
    function orderModifiers(modifiers) {
      var orderedModifiers = order(modifiers);
      return modifierPhases.reduce(function (acc, phase) {
        return acc.concat(orderedModifiers.filter(function (modifier) {
          return modifier.phase === phase;
        }));
      }, []);
    }
    function debounce(fn) {
      var pending;
      return function () {
        if (!pending) {
          pending = new Promise(function (resolve) {
            Promise.resolve().then(function () {
              pending = void 0;
              resolve(fn());
            });
          });
        }
        return pending;
      };
    }
    function format(str) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return [].concat(args).reduce(function (p, c) {
        return p.replace(/%s/, c);
      }, str);
    }
    var INVALID_MODIFIER_ERROR = 'Popper: modifier "%s" provided an invalid %s property, expected %s but got %s';
    var MISSING_DEPENDENCY_ERROR = 'Popper: modifier "%s" requires "%s", but "%s" modifier is not available';
    var VALID_PROPERTIES = ["name", "enabled", "phase", "fn", "effect", "requires", "options"];
    function validateModifiers(modifiers) {
      modifiers.forEach(function (modifier) {
        Object.keys(modifier).forEach(function (key) {
          switch (key) {
            case "name":
              if (typeof modifier.name !== "string") {
                console.error(format(INVALID_MODIFIER_ERROR, String(modifier.name), '"name"', '"string"', '"' + String(modifier.name) + '"'));
              }
              break;
            case "enabled":
              if (typeof modifier.enabled !== "boolean") {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"enabled"', '"boolean"', '"' + String(modifier.enabled) + '"'));
              }
            case "phase":
              if (modifierPhases.indexOf(modifier.phase) < 0) {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"phase"', "either " + modifierPhases.join(", "), '"' + String(modifier.phase) + '"'));
              }
              break;
            case "fn":
              if (typeof modifier.fn !== "function") {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"fn"', '"function"', '"' + String(modifier.fn) + '"'));
              }
              break;
            case "effect":
              if (typeof modifier.effect !== "function") {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"effect"', '"function"', '"' + String(modifier.fn) + '"'));
              }
              break;
            case "requires":
              if (!Array.isArray(modifier.requires)) {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"requires"', '"array"', '"' + String(modifier.requires) + '"'));
              }
              break;
            case "requiresIfExists":
              if (!Array.isArray(modifier.requiresIfExists)) {
                console.error(format(INVALID_MODIFIER_ERROR, modifier.name, '"requiresIfExists"', '"array"', '"' + String(modifier.requiresIfExists) + '"'));
              }
              break;
            case "options":
            case "data":
              break;
            default:
              console.error('PopperJS: an invalid property has been provided to the "' + modifier.name + '" modifier, valid properties are ' + VALID_PROPERTIES.map(function (s) {
                return '"' + s + '"';
              }).join(", ") + '; but "' + key + '" was provided.');
          }
          modifier.requires && modifier.requires.forEach(function (requirement) {
            if (modifiers.find(function (mod) {
              return mod.name === requirement;
            }) == null) {
              console.error(format(MISSING_DEPENDENCY_ERROR, String(modifier.name), requirement, requirement));
            }
          });
        });
      });
    }
    function uniqueBy(arr, fn) {
      var identifiers = new Set();
      return arr.filter(function (item) {
        var identifier = fn(item);
        if (!identifiers.has(identifier)) {
          identifiers.add(identifier);
          return true;
        }
      });
    }
    function getBasePlacement(placement) {
      return placement.split("-")[0];
    }
    function mergeByName(modifiers) {
      var merged = modifiers.reduce(function (merged2, current) {
        var existing = merged2[current.name];
        merged2[current.name] = existing ? Object.assign({}, existing, current, {
          options: Object.assign({}, existing.options, current.options),
          data: Object.assign({}, existing.data, current.data)
        }) : current;
        return merged2;
      }, {});
      return Object.keys(merged).map(function (key) {
        return merged[key];
      });
    }
    function getViewportRect(element) {
      var win = getWindow(element);
      var html = getDocumentElement(element);
      var visualViewport = win.visualViewport;
      var width = html.clientWidth;
      var height = html.clientHeight;
      var x = 0;
      var y = 0;
      if (visualViewport) {
        width = visualViewport.width;
        height = visualViewport.height;
        if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
          x = visualViewport.offsetLeft;
          y = visualViewport.offsetTop;
        }
      }
      return {
        width,
        height,
        x: x + getWindowScrollBarX(element),
        y
      };
    }
    var max = Math.max;
    var min = Math.min;
    var round = Math.round;
    function getDocumentRect(element) {
      var _element$ownerDocumen;
      var html = getDocumentElement(element);
      var winScroll = getWindowScroll(element);
      var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
      var width = max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
      var height = max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
      var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
      var y = -winScroll.scrollTop;
      if (getComputedStyle(body || html).direction === "rtl") {
        x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
      }
      return {
        width,
        height,
        x,
        y
      };
    }
    function contains(parent, child) {
      var rootNode = child.getRootNode && child.getRootNode();
      if (parent.contains(child)) {
        return true;
      } else if (rootNode && isShadowRoot(rootNode)) {
        var next = child;
        do {
          if (next && parent.isSameNode(next)) {
            return true;
          }
          next = next.parentNode || next.host;
        } while (next);
      }
      return false;
    }
    function rectToClientRect(rect) {
      return Object.assign({}, rect, {
        left: rect.x,
        top: rect.y,
        right: rect.x + rect.width,
        bottom: rect.y + rect.height
      });
    }
    function getInnerBoundingClientRect(element) {
      var rect = getBoundingClientRect(element);
      rect.top = rect.top + element.clientTop;
      rect.left = rect.left + element.clientLeft;
      rect.bottom = rect.top + element.clientHeight;
      rect.right = rect.left + element.clientWidth;
      rect.width = element.clientWidth;
      rect.height = element.clientHeight;
      rect.x = rect.left;
      rect.y = rect.top;
      return rect;
    }
    function getClientRectFromMixedType(element, clippingParent) {
      return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isHTMLElement(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
    }
    function getClippingParents(element) {
      var clippingParents2 = listScrollParents(getParentNode(element));
      var canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle(element).position) >= 0;
      var clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;
      if (!isElement(clipperElement)) {
        return [];
      }
      return clippingParents2.filter(function (clippingParent) {
        return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== "body";
      });
    }
    function getClippingRect(element, boundary, rootBoundary) {
      var mainClippingParents = boundary === "clippingParents" ? getClippingParents(element) : [].concat(boundary);
      var clippingParents2 = [].concat(mainClippingParents, [rootBoundary]);
      var firstClippingParent = clippingParents2[0];
      var clippingRect = clippingParents2.reduce(function (accRect, clippingParent) {
        var rect = getClientRectFromMixedType(element, clippingParent);
        accRect.top = max(rect.top, accRect.top);
        accRect.right = min(rect.right, accRect.right);
        accRect.bottom = min(rect.bottom, accRect.bottom);
        accRect.left = max(rect.left, accRect.left);
        return accRect;
      }, getClientRectFromMixedType(element, firstClippingParent));
      clippingRect.width = clippingRect.right - clippingRect.left;
      clippingRect.height = clippingRect.bottom - clippingRect.top;
      clippingRect.x = clippingRect.left;
      clippingRect.y = clippingRect.top;
      return clippingRect;
    }
    function getVariation(placement) {
      return placement.split("-")[1];
    }
    function getMainAxisFromPlacement(placement) {
      return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
    }
    function computeOffsets(_ref) {
      var reference2 = _ref.reference,
        element = _ref.element,
        placement = _ref.placement;
      var basePlacement = placement ? getBasePlacement(placement) : null;
      var variation = placement ? getVariation(placement) : null;
      var commonX = reference2.x + reference2.width / 2 - element.width / 2;
      var commonY = reference2.y + reference2.height / 2 - element.height / 2;
      var offsets;
      switch (basePlacement) {
        case top:
          offsets = {
            x: commonX,
            y: reference2.y - element.height
          };
          break;
        case bottom:
          offsets = {
            x: commonX,
            y: reference2.y + reference2.height
          };
          break;
        case right:
          offsets = {
            x: reference2.x + reference2.width,
            y: commonY
          };
          break;
        case left:
          offsets = {
            x: reference2.x - element.width,
            y: commonY
          };
          break;
        default:
          offsets = {
            x: reference2.x,
            y: reference2.y
          };
      }
      var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
      if (mainAxis != null) {
        var len = mainAxis === "y" ? "height" : "width";
        switch (variation) {
          case start:
            offsets[mainAxis] = offsets[mainAxis] - (reference2[len] / 2 - element[len] / 2);
            break;
          case end:
            offsets[mainAxis] = offsets[mainAxis] + (reference2[len] / 2 - element[len] / 2);
            break;
        }
      }
      return offsets;
    }
    function getFreshSideObject() {
      return {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
      };
    }
    function mergePaddingObject(paddingObject) {
      return Object.assign({}, getFreshSideObject(), paddingObject);
    }
    function expandToHashMap(value, keys) {
      return keys.reduce(function (hashMap, key) {
        hashMap[key] = value;
        return hashMap;
      }, {});
    }
    function detectOverflow(state, options) {
      if (options === void 0) {
        options = {};
      }
      var _options = options,
        _options$placement = _options.placement,
        placement = _options$placement === void 0 ? state.placement : _options$placement,
        _options$boundary = _options.boundary,
        boundary = _options$boundary === void 0 ? clippingParents : _options$boundary,
        _options$rootBoundary = _options.rootBoundary,
        rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary,
        _options$elementConte = _options.elementContext,
        elementContext = _options$elementConte === void 0 ? popper : _options$elementConte,
        _options$altBoundary = _options.altBoundary,
        altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
        _options$padding = _options.padding,
        padding = _options$padding === void 0 ? 0 : _options$padding;
      var paddingObject = mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
      var altContext = elementContext === popper ? reference : popper;
      var referenceElement = state.elements.reference;
      var popperRect = state.rects.popper;
      var element = state.elements[altBoundary ? altContext : elementContext];
      var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
      var referenceClientRect = getBoundingClientRect(referenceElement);
      var popperOffsets2 = computeOffsets({
        reference: referenceClientRect,
        element: popperRect,
        strategy: "absolute",
        placement
      });
      var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets2));
      var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
      var overflowOffsets = {
        top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
        bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
        left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
        right: elementClientRect.right - clippingClientRect.right + paddingObject.right
      };
      var offsetData = state.modifiersData.offset;
      if (elementContext === popper && offsetData) {
        var offset2 = offsetData[placement];
        Object.keys(overflowOffsets).forEach(function (key) {
          var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
          var axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
          overflowOffsets[key] += offset2[axis] * multiply;
        });
      }
      return overflowOffsets;
    }
    var INVALID_ELEMENT_ERROR = "Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.";
    var INFINITE_LOOP_ERROR = "Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.";
    var DEFAULT_OPTIONS = {
      placement: "bottom",
      modifiers: [],
      strategy: "absolute"
    };
    function areValidElements() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return !args.some(function (element) {
        return !(element && typeof element.getBoundingClientRect === "function");
      });
    }
    function popperGenerator(generatorOptions) {
      if (generatorOptions === void 0) {
        generatorOptions = {};
      }
      var _generatorOptions = generatorOptions,
        _generatorOptions$def = _generatorOptions.defaultModifiers,
        defaultModifiers2 = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
        _generatorOptions$def2 = _generatorOptions.defaultOptions,
        defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
      return function createPopper2(reference2, popper2, options) {
        if (options === void 0) {
          options = defaultOptions;
        }
        var state = {
          placement: "bottom",
          orderedModifiers: [],
          options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
          modifiersData: {},
          elements: {
            reference: reference2,
            popper: popper2
          },
          attributes: {},
          styles: {}
        };
        var effectCleanupFns = [];
        var isDestroyed = false;
        var instance = {
          state,
          setOptions: function setOptions(options2) {
            cleanupModifierEffects();
            state.options = Object.assign({}, defaultOptions, state.options, options2);
            state.scrollParents = {
              reference: isElement(reference2) ? listScrollParents(reference2) : reference2.contextElement ? listScrollParents(reference2.contextElement) : [],
              popper: listScrollParents(popper2)
            };
            var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers2, state.options.modifiers)));
            state.orderedModifiers = orderedModifiers.filter(function (m) {
              return m.enabled;
            });
            {
              var modifiers = uniqueBy([].concat(orderedModifiers, state.options.modifiers), function (_ref) {
                var name = _ref.name;
                return name;
              });
              validateModifiers(modifiers);
              if (getBasePlacement(state.options.placement) === auto) {
                var flipModifier = state.orderedModifiers.find(function (_ref2) {
                  var name = _ref2.name;
                  return name === "flip";
                });
                if (!flipModifier) {
                  console.error(['Popper: "auto" placements require the "flip" modifier be', "present and enabled to work."].join(" "));
                }
              }
              var _getComputedStyle = getComputedStyle(popper2),
                marginTop = _getComputedStyle.marginTop,
                marginRight = _getComputedStyle.marginRight,
                marginBottom = _getComputedStyle.marginBottom,
                marginLeft = _getComputedStyle.marginLeft;
              if ([marginTop, marginRight, marginBottom, marginLeft].some(function (margin) {
                return parseFloat(margin);
              })) {
                console.warn(['Popper: CSS "margin" styles cannot be used to apply padding', "between the popper and its reference element or boundary.", "To replicate margin, use the `offset` modifier, as well as", "the `padding` option in the `preventOverflow` and `flip`", "modifiers."].join(" "));
              }
            }
            runModifierEffects();
            return instance.update();
          },
          forceUpdate: function forceUpdate() {
            if (isDestroyed) {
              return;
            }
            var _state$elements = state.elements,
              reference3 = _state$elements.reference,
              popper3 = _state$elements.popper;
            if (!areValidElements(reference3, popper3)) {
              {
                console.error(INVALID_ELEMENT_ERROR);
              }
              return;
            }
            state.rects = {
              reference: getCompositeRect(reference3, getOffsetParent(popper3), state.options.strategy === "fixed"),
              popper: getLayoutRect(popper3)
            };
            state.reset = false;
            state.placement = state.options.placement;
            state.orderedModifiers.forEach(function (modifier) {
              return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
            });
            var __debug_loops__ = 0;
            for (var index = 0; index < state.orderedModifiers.length; index++) {
              {
                __debug_loops__ += 1;
                if (__debug_loops__ > 100) {
                  console.error(INFINITE_LOOP_ERROR);
                  break;
                }
              }
              if (state.reset === true) {
                state.reset = false;
                index = -1;
                continue;
              }
              var _state$orderedModifie = state.orderedModifiers[index],
                fn = _state$orderedModifie.fn,
                _state$orderedModifie2 = _state$orderedModifie.options,
                _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
                name = _state$orderedModifie.name;
              if (typeof fn === "function") {
                state = fn({
                  state,
                  options: _options,
                  name,
                  instance
                }) || state;
              }
            }
          },
          update: debounce(function () {
            return new Promise(function (resolve) {
              instance.forceUpdate();
              resolve(state);
            });
          }),
          destroy: function destroy() {
            cleanupModifierEffects();
            isDestroyed = true;
          }
        };
        if (!areValidElements(reference2, popper2)) {
          {
            console.error(INVALID_ELEMENT_ERROR);
          }
          return instance;
        }
        instance.setOptions(options).then(function (state2) {
          if (!isDestroyed && options.onFirstUpdate) {
            options.onFirstUpdate(state2);
          }
        });
        function runModifierEffects() {
          state.orderedModifiers.forEach(function (_ref3) {
            var name = _ref3.name,
              _ref3$options = _ref3.options,
              options2 = _ref3$options === void 0 ? {} : _ref3$options,
              effect2 = _ref3.effect;
            if (typeof effect2 === "function") {
              var cleanupFn = effect2({
                state,
                name,
                instance,
                options: options2
              });
              var noopFn = function noopFn2() {};
              effectCleanupFns.push(cleanupFn || noopFn);
            }
          });
        }
        function cleanupModifierEffects() {
          effectCleanupFns.forEach(function (fn) {
            return fn();
          });
          effectCleanupFns = [];
        }
        return instance;
      };
    }
    var passive = {
      passive: true
    };
    function effect$2(_ref) {
      var state = _ref.state,
        instance = _ref.instance,
        options = _ref.options;
      var _options$scroll = options.scroll,
        scroll = _options$scroll === void 0 ? true : _options$scroll,
        _options$resize = options.resize,
        resize = _options$resize === void 0 ? true : _options$resize;
      var window2 = getWindow(state.elements.popper);
      var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);
      if (scroll) {
        scrollParents.forEach(function (scrollParent) {
          scrollParent.addEventListener("scroll", instance.update, passive);
        });
      }
      if (resize) {
        window2.addEventListener("resize", instance.update, passive);
      }
      return function () {
        if (scroll) {
          scrollParents.forEach(function (scrollParent) {
            scrollParent.removeEventListener("scroll", instance.update, passive);
          });
        }
        if (resize) {
          window2.removeEventListener("resize", instance.update, passive);
        }
      };
    }
    var eventListeners = {
      name: "eventListeners",
      enabled: true,
      phase: "write",
      fn: function fn() {},
      effect: effect$2,
      data: {}
    };
    function popperOffsets(_ref) {
      var state = _ref.state,
        name = _ref.name;
      state.modifiersData[name] = computeOffsets({
        reference: state.rects.reference,
        element: state.rects.popper,
        strategy: "absolute",
        placement: state.placement
      });
    }
    var popperOffsets$1 = {
      name: "popperOffsets",
      enabled: true,
      phase: "read",
      fn: popperOffsets,
      data: {}
    };
    var unsetSides = {
      top: "auto",
      right: "auto",
      bottom: "auto",
      left: "auto"
    };
    function roundOffsetsByDPR(_ref) {
      var x = _ref.x,
        y = _ref.y;
      var win = window;
      var dpr = win.devicePixelRatio || 1;
      return {
        x: round(round(x * dpr) / dpr) || 0,
        y: round(round(y * dpr) / dpr) || 0
      };
    }
    function mapToStyles(_ref2) {
      var _Object$assign2;
      var popper2 = _ref2.popper,
        popperRect = _ref2.popperRect,
        placement = _ref2.placement,
        offsets = _ref2.offsets,
        position = _ref2.position,
        gpuAcceleration = _ref2.gpuAcceleration,
        adaptive = _ref2.adaptive,
        roundOffsets = _ref2.roundOffsets;
      var _ref3 = roundOffsets === true ? roundOffsetsByDPR(offsets) : typeof roundOffsets === "function" ? roundOffsets(offsets) : offsets,
        _ref3$x = _ref3.x,
        x = _ref3$x === void 0 ? 0 : _ref3$x,
        _ref3$y = _ref3.y,
        y = _ref3$y === void 0 ? 0 : _ref3$y;
      var hasX = offsets.hasOwnProperty("x");
      var hasY = offsets.hasOwnProperty("y");
      var sideX = left;
      var sideY = top;
      var win = window;
      if (adaptive) {
        var offsetParent = getOffsetParent(popper2);
        var heightProp = "clientHeight";
        var widthProp = "clientWidth";
        if (offsetParent === getWindow(popper2)) {
          offsetParent = getDocumentElement(popper2);
          if (getComputedStyle(offsetParent).position !== "static") {
            heightProp = "scrollHeight";
            widthProp = "scrollWidth";
          }
        }
        offsetParent = offsetParent;
        if (placement === top) {
          sideY = bottom;
          y -= offsetParent[heightProp] - popperRect.height;
          y *= gpuAcceleration ? 1 : -1;
        }
        if (placement === left) {
          sideX = right;
          x -= offsetParent[widthProp] - popperRect.width;
          x *= gpuAcceleration ? 1 : -1;
        }
      }
      var commonStyles = Object.assign({
        position
      }, adaptive && unsetSides);
      if (gpuAcceleration) {
        var _Object$assign;
        return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? "0" : "", _Object$assign[sideX] = hasX ? "0" : "", _Object$assign.transform = (win.devicePixelRatio || 1) < 2 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
      }
      return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : "", _Object$assign2[sideX] = hasX ? x + "px" : "", _Object$assign2.transform = "", _Object$assign2));
    }
    function computeStyles(_ref4) {
      var state = _ref4.state,
        options = _ref4.options;
      var _options$gpuAccelerat = options.gpuAcceleration,
        gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
        _options$adaptive = options.adaptive,
        adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
        _options$roundOffsets = options.roundOffsets,
        roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
      {
        var transitionProperty = getComputedStyle(state.elements.popper).transitionProperty || "";
        if (adaptive && ["transform", "top", "right", "bottom", "left"].some(function (property) {
          return transitionProperty.indexOf(property) >= 0;
        })) {
          console.warn(["Popper: Detected CSS transitions on at least one of the following", 'CSS properties: "transform", "top", "right", "bottom", "left".', "\n\n", 'Disable the "computeStyles" modifier\'s `adaptive` option to allow', "for smooth transitions, or remove these properties from the CSS", "transition declaration on the popper element if only transitioning", "opacity or background-color for example.", "\n\n", "We recommend using the popper element as a wrapper around an inner", "element that can have any CSS property transitioned for animations."].join(" "));
        }
      }
      var commonStyles = {
        placement: getBasePlacement(state.placement),
        popper: state.elements.popper,
        popperRect: state.rects.popper,
        gpuAcceleration
      };
      if (state.modifiersData.popperOffsets != null) {
        state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
          offsets: state.modifiersData.popperOffsets,
          position: state.options.strategy,
          adaptive,
          roundOffsets
        })));
      }
      if (state.modifiersData.arrow != null) {
        state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
          offsets: state.modifiersData.arrow,
          position: "absolute",
          adaptive: false,
          roundOffsets
        })));
      }
      state.attributes.popper = Object.assign({}, state.attributes.popper, {
        "data-popper-placement": state.placement
      });
    }
    var computeStyles$1 = {
      name: "computeStyles",
      enabled: true,
      phase: "beforeWrite",
      fn: computeStyles,
      data: {}
    };
    function applyStyles(_ref) {
      var state = _ref.state;
      Object.keys(state.elements).forEach(function (name) {
        var style = state.styles[name] || {};
        var attributes = state.attributes[name] || {};
        var element = state.elements[name];
        if (!isHTMLElement(element) || !getNodeName(element)) {
          return;
        }
        Object.assign(element.style, style);
        Object.keys(attributes).forEach(function (name2) {
          var value = attributes[name2];
          if (value === false) {
            element.removeAttribute(name2);
          } else {
            element.setAttribute(name2, value === true ? "" : value);
          }
        });
      });
    }
    function effect$1(_ref2) {
      var state = _ref2.state;
      var initialStyles = {
        popper: {
          position: state.options.strategy,
          left: "0",
          top: "0",
          margin: "0"
        },
        arrow: {
          position: "absolute"
        },
        reference: {}
      };
      Object.assign(state.elements.popper.style, initialStyles.popper);
      state.styles = initialStyles;
      if (state.elements.arrow) {
        Object.assign(state.elements.arrow.style, initialStyles.arrow);
      }
      return function () {
        Object.keys(state.elements).forEach(function (name) {
          var element = state.elements[name];
          var attributes = state.attributes[name] || {};
          var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]);
          var style = styleProperties.reduce(function (style2, property) {
            style2[property] = "";
            return style2;
          }, {});
          if (!isHTMLElement(element) || !getNodeName(element)) {
            return;
          }
          Object.assign(element.style, style);
          Object.keys(attributes).forEach(function (attribute) {
            element.removeAttribute(attribute);
          });
        });
      };
    }
    var applyStyles$1 = {
      name: "applyStyles",
      enabled: true,
      phase: "write",
      fn: applyStyles,
      effect: effect$1,
      requires: ["computeStyles"]
    };
    function distanceAndSkiddingToXY(placement, rects, offset2) {
      var basePlacement = getBasePlacement(placement);
      var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;
      var _ref = typeof offset2 === "function" ? offset2(Object.assign({}, rects, {
          placement
        })) : offset2,
        skidding = _ref[0],
        distance = _ref[1];
      skidding = skidding || 0;
      distance = (distance || 0) * invertDistance;
      return [left, right].indexOf(basePlacement) >= 0 ? {
        x: distance,
        y: skidding
      } : {
        x: skidding,
        y: distance
      };
    }
    function offset(_ref2) {
      var state = _ref2.state,
        options = _ref2.options,
        name = _ref2.name;
      var _options$offset = options.offset,
        offset2 = _options$offset === void 0 ? [0, 0] : _options$offset;
      var data = placements.reduce(function (acc, placement) {
        acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset2);
        return acc;
      }, {});
      var _data$state$placement = data[state.placement],
        x = _data$state$placement.x,
        y = _data$state$placement.y;
      if (state.modifiersData.popperOffsets != null) {
        state.modifiersData.popperOffsets.x += x;
        state.modifiersData.popperOffsets.y += y;
      }
      state.modifiersData[name] = data;
    }
    var offset$1 = {
      name: "offset",
      enabled: true,
      phase: "main",
      requires: ["popperOffsets"],
      fn: offset
    };
    var hash$1 = {
      left: "right",
      right: "left",
      bottom: "top",
      top: "bottom"
    };
    function getOppositePlacement(placement) {
      return placement.replace(/left|right|bottom|top/g, function (matched) {
        return hash$1[matched];
      });
    }
    var hash = {
      start: "end",
      end: "start"
    };
    function getOppositeVariationPlacement(placement) {
      return placement.replace(/start|end/g, function (matched) {
        return hash[matched];
      });
    }
    function computeAutoPlacement(state, options) {
      if (options === void 0) {
        options = {};
      }
      var _options = options,
        placement = _options.placement,
        boundary = _options.boundary,
        rootBoundary = _options.rootBoundary,
        padding = _options.padding,
        flipVariations = _options.flipVariations,
        _options$allowedAutoP = _options.allowedAutoPlacements,
        allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
      var variation = getVariation(placement);
      var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function (placement2) {
        return getVariation(placement2) === variation;
      }) : basePlacements;
      var allowedPlacements = placements$1.filter(function (placement2) {
        return allowedAutoPlacements.indexOf(placement2) >= 0;
      });
      if (allowedPlacements.length === 0) {
        allowedPlacements = placements$1;
        {
          console.error(["Popper: The `allowedAutoPlacements` option did not allow any", "placements. Ensure the `placement` option matches the variation", "of the allowed placements.", 'For example, "auto" cannot be used to allow "bottom-start".', 'Use "auto-start" instead.'].join(" "));
        }
      }
      var overflows = allowedPlacements.reduce(function (acc, placement2) {
        acc[placement2] = detectOverflow(state, {
          placement: placement2,
          boundary,
          rootBoundary,
          padding
        })[getBasePlacement(placement2)];
        return acc;
      }, {});
      return Object.keys(overflows).sort(function (a, b) {
        return overflows[a] - overflows[b];
      });
    }
    function getExpandedFallbackPlacements(placement) {
      if (getBasePlacement(placement) === auto) {
        return [];
      }
      var oppositePlacement = getOppositePlacement(placement);
      return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
    }
    function flip(_ref) {
      var state = _ref.state,
        options = _ref.options,
        name = _ref.name;
      if (state.modifiersData[name]._skip) {
        return;
      }
      var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
        specifiedFallbackPlacements = options.fallbackPlacements,
        padding = options.padding,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        _options$flipVariatio = options.flipVariations,
        flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
        allowedAutoPlacements = options.allowedAutoPlacements;
      var preferredPlacement = state.options.placement;
      var basePlacement = getBasePlacement(preferredPlacement);
      var isBasePlacement = basePlacement === preferredPlacement;
      var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
      var placements2 = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement2) {
        return acc.concat(getBasePlacement(placement2) === auto ? computeAutoPlacement(state, {
          placement: placement2,
          boundary,
          rootBoundary,
          padding,
          flipVariations,
          allowedAutoPlacements
        }) : placement2);
      }, []);
      var referenceRect = state.rects.reference;
      var popperRect = state.rects.popper;
      var checksMap = new Map();
      var makeFallbackChecks = true;
      var firstFittingPlacement = placements2[0];
      for (var i = 0; i < placements2.length; i++) {
        var placement = placements2[i];
        var _basePlacement = getBasePlacement(placement);
        var isStartVariation = getVariation(placement) === start;
        var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
        var len = isVertical ? "width" : "height";
        var overflow = detectOverflow(state, {
          placement,
          boundary,
          rootBoundary,
          altBoundary,
          padding
        });
        var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;
        if (referenceRect[len] > popperRect[len]) {
          mainVariationSide = getOppositePlacement(mainVariationSide);
        }
        var altVariationSide = getOppositePlacement(mainVariationSide);
        var checks = [];
        if (checkMainAxis) {
          checks.push(overflow[_basePlacement] <= 0);
        }
        if (checkAltAxis) {
          checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
        }
        if (checks.every(function (check) {
          return check;
        })) {
          firstFittingPlacement = placement;
          makeFallbackChecks = false;
          break;
        }
        checksMap.set(placement, checks);
      }
      if (makeFallbackChecks) {
        var numberOfChecks = flipVariations ? 3 : 1;
        var _loop = function _loop2(_i2) {
          var fittingPlacement = placements2.find(function (placement2) {
            var checks2 = checksMap.get(placement2);
            if (checks2) {
              return checks2.slice(0, _i2).every(function (check) {
                return check;
              });
            }
          });
          if (fittingPlacement) {
            firstFittingPlacement = fittingPlacement;
            return "break";
          }
        };
        for (var _i = numberOfChecks; _i > 0; _i--) {
          var _ret = _loop(_i);
          if (_ret === "break") break;
        }
      }
      if (state.placement !== firstFittingPlacement) {
        state.modifiersData[name]._skip = true;
        state.placement = firstFittingPlacement;
        state.reset = true;
      }
    }
    var flip$1 = {
      name: "flip",
      enabled: true,
      phase: "main",
      fn: flip,
      requiresIfExists: ["offset"],
      data: {
        _skip: false
      }
    };
    function getAltAxis(axis) {
      return axis === "x" ? "y" : "x";
    }
    function within(min$1, value, max$1) {
      return max(min$1, min(value, max$1));
    }
    function preventOverflow(_ref) {
      var state = _ref.state,
        options = _ref.options,
        name = _ref.name;
      var _options$mainAxis = options.mainAxis,
        checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
        _options$altAxis = options.altAxis,
        checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
        boundary = options.boundary,
        rootBoundary = options.rootBoundary,
        altBoundary = options.altBoundary,
        padding = options.padding,
        _options$tether = options.tether,
        tether = _options$tether === void 0 ? true : _options$tether,
        _options$tetherOffset = options.tetherOffset,
        tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
      var overflow = detectOverflow(state, {
        boundary,
        rootBoundary,
        padding,
        altBoundary
      });
      var basePlacement = getBasePlacement(state.placement);
      var variation = getVariation(state.placement);
      var isBasePlacement = !variation;
      var mainAxis = getMainAxisFromPlacement(basePlacement);
      var altAxis = getAltAxis(mainAxis);
      var popperOffsets2 = state.modifiersData.popperOffsets;
      var referenceRect = state.rects.reference;
      var popperRect = state.rects.popper;
      var tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign({}, state.rects, {
        placement: state.placement
      })) : tetherOffset;
      var data = {
        x: 0,
        y: 0
      };
      if (!popperOffsets2) {
        return;
      }
      if (checkMainAxis || checkAltAxis) {
        var mainSide = mainAxis === "y" ? top : left;
        var altSide = mainAxis === "y" ? bottom : right;
        var len = mainAxis === "y" ? "height" : "width";
        var offset2 = popperOffsets2[mainAxis];
        var min$1 = popperOffsets2[mainAxis] + overflow[mainSide];
        var max$1 = popperOffsets2[mainAxis] - overflow[altSide];
        var additive = tether ? -popperRect[len] / 2 : 0;
        var minLen = variation === start ? referenceRect[len] : popperRect[len];
        var maxLen = variation === start ? -popperRect[len] : -referenceRect[len];
        var arrowElement = state.elements.arrow;
        var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
          width: 0,
          height: 0
        };
        var arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject();
        var arrowPaddingMin = arrowPaddingObject[mainSide];
        var arrowPaddingMax = arrowPaddingObject[altSide];
        var arrowLen = within(0, referenceRect[len], arrowRect[len]);
        var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
        var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
        var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
        var clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
        var offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
        var tetherMin = popperOffsets2[mainAxis] + minOffset - offsetModifierValue - clientOffset;
        var tetherMax = popperOffsets2[mainAxis] + maxOffset - offsetModifierValue;
        if (checkMainAxis) {
          var preventedOffset = within(tether ? min(min$1, tetherMin) : min$1, offset2, tether ? max(max$1, tetherMax) : max$1);
          popperOffsets2[mainAxis] = preventedOffset;
          data[mainAxis] = preventedOffset - offset2;
        }
        if (checkAltAxis) {
          var _mainSide = mainAxis === "x" ? top : left;
          var _altSide = mainAxis === "x" ? bottom : right;
          var _offset = popperOffsets2[altAxis];
          var _min = _offset + overflow[_mainSide];
          var _max = _offset - overflow[_altSide];
          var _preventedOffset = within(tether ? min(_min, tetherMin) : _min, _offset, tether ? max(_max, tetherMax) : _max);
          popperOffsets2[altAxis] = _preventedOffset;
          data[altAxis] = _preventedOffset - _offset;
        }
      }
      state.modifiersData[name] = data;
    }
    var preventOverflow$1 = {
      name: "preventOverflow",
      enabled: true,
      phase: "main",
      fn: preventOverflow,
      requiresIfExists: ["offset"]
    };
    var toPaddingObject = function toPaddingObject2(padding, state) {
      padding = typeof padding === "function" ? padding(Object.assign({}, state.rects, {
        placement: state.placement
      })) : padding;
      return mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
    };
    function arrow(_ref) {
      var _state$modifiersData$;
      var state = _ref.state,
        name = _ref.name,
        options = _ref.options;
      var arrowElement = state.elements.arrow;
      var popperOffsets2 = state.modifiersData.popperOffsets;
      var basePlacement = getBasePlacement(state.placement);
      var axis = getMainAxisFromPlacement(basePlacement);
      var isVertical = [left, right].indexOf(basePlacement) >= 0;
      var len = isVertical ? "height" : "width";
      if (!arrowElement || !popperOffsets2) {
        return;
      }
      var paddingObject = toPaddingObject(options.padding, state);
      var arrowRect = getLayoutRect(arrowElement);
      var minProp = axis === "y" ? top : left;
      var maxProp = axis === "y" ? bottom : right;
      var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets2[axis] - state.rects.popper[len];
      var startDiff = popperOffsets2[axis] - state.rects.reference[axis];
      var arrowOffsetParent = getOffsetParent(arrowElement);
      var clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
      var centerToReference = endDiff / 2 - startDiff / 2;
      var min2 = paddingObject[minProp];
      var max2 = clientSize - arrowRect[len] - paddingObject[maxProp];
      var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
      var offset2 = within(min2, center, max2);
      var axisProp = axis;
      state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset2, _state$modifiersData$.centerOffset = offset2 - center, _state$modifiersData$);
    }
    function effect(_ref2) {
      var state = _ref2.state,
        options = _ref2.options;
      var _options$element = options.element,
        arrowElement = _options$element === void 0 ? "[data-popper-arrow]" : _options$element;
      if (arrowElement == null) {
        return;
      }
      if (typeof arrowElement === "string") {
        arrowElement = state.elements.popper.querySelector(arrowElement);
        if (!arrowElement) {
          return;
        }
      }
      {
        if (!isHTMLElement(arrowElement)) {
          console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).', "To use an SVG arrow, wrap it in an HTMLElement that will be used as", "the arrow."].join(" "));
        }
      }
      if (!contains(state.elements.popper, arrowElement)) {
        {
          console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper', "element."].join(" "));
        }
        return;
      }
      state.elements.arrow = arrowElement;
    }
    var arrow$1 = {
      name: "arrow",
      enabled: true,
      phase: "main",
      fn: arrow,
      effect,
      requires: ["popperOffsets"],
      requiresIfExists: ["preventOverflow"]
    };
    function getSideOffsets(overflow, rect, preventedOffsets) {
      if (preventedOffsets === void 0) {
        preventedOffsets = {
          x: 0,
          y: 0
        };
      }
      return {
        top: overflow.top - rect.height - preventedOffsets.y,
        right: overflow.right - rect.width + preventedOffsets.x,
        bottom: overflow.bottom - rect.height + preventedOffsets.y,
        left: overflow.left - rect.width - preventedOffsets.x
      };
    }
    function isAnySideFullyClipped(overflow) {
      return [top, right, bottom, left].some(function (side) {
        return overflow[side] >= 0;
      });
    }
    function hide(_ref) {
      var state = _ref.state,
        name = _ref.name;
      var referenceRect = state.rects.reference;
      var popperRect = state.rects.popper;
      var preventedOffsets = state.modifiersData.preventOverflow;
      var referenceOverflow = detectOverflow(state, {
        elementContext: "reference"
      });
      var popperAltOverflow = detectOverflow(state, {
        altBoundary: true
      });
      var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
      var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
      var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
      var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
      state.modifiersData[name] = {
        referenceClippingOffsets,
        popperEscapeOffsets,
        isReferenceHidden,
        hasPopperEscaped
      };
      state.attributes.popper = Object.assign({}, state.attributes.popper, {
        "data-popper-reference-hidden": isReferenceHidden,
        "data-popper-escaped": hasPopperEscaped
      });
    }
    var hide$1 = {
      name: "hide",
      enabled: true,
      phase: "main",
      requiresIfExists: ["preventOverflow"],
      fn: hide
    };
    var defaultModifiers$1 = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1];
    var createPopper$1 = /* @__PURE__ */popperGenerator({
      defaultModifiers: defaultModifiers$1
    });
    var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
    var createPopper = /* @__PURE__ */popperGenerator({
      defaultModifiers
    });
    exports.applyStyles = applyStyles$1;
    exports.arrow = arrow$1;
    exports.computeStyles = computeStyles$1;
    exports.createPopper = createPopper;
    exports.createPopperLite = createPopper$1;
    exports.defaultModifiers = defaultModifiers;
    exports.detectOverflow = detectOverflow;
    exports.eventListeners = eventListeners;
    exports.flip = flip$1;
    exports.hide = hide$1;
    exports.offset = offset$1;
    exports.popperGenerator = popperGenerator;
    exports.popperOffsets = popperOffsets$1;
    exports.preventOverflow = preventOverflow$1;
  });

  // node_modules/tippy.js/dist/tippy.cjs.js
  var require_tippy_cjs = __commonJS(exports => {

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    var core = require_popper();
    var ROUND_ARROW = '<svg width="16" height="6" xmlns="http://www.w3.org/2000/svg"><path d="M0 6s1.796-.013 4.67-3.615C5.851.9 6.93.006 8 0c1.07-.006 2.148.887 3.343 2.385C14.233 6.005 16 6 16 6H0z"></svg>';
    var BOX_CLASS = "tippy-box";
    var CONTENT_CLASS = "tippy-content";
    var BACKDROP_CLASS = "tippy-backdrop";
    var ARROW_CLASS = "tippy-arrow";
    var SVG_ARROW_CLASS = "tippy-svg-arrow";
    var TOUCH_OPTIONS = {
      passive: true,
      capture: true
    };
    function hasOwnProperty(obj, key) {
      return {}.hasOwnProperty.call(obj, key);
    }
    function getValueAtIndexOrReturn(value, index, defaultValue) {
      if (Array.isArray(value)) {
        var v = value[index];
        return v == null ? Array.isArray(defaultValue) ? defaultValue[index] : defaultValue : v;
      }
      return value;
    }
    function isType(value, type) {
      var str = {}.toString.call(value);
      return str.indexOf("[object") === 0 && str.indexOf(type + "]") > -1;
    }
    function invokeWithArgsOrReturn(value, args) {
      return typeof value === "function" ? value.apply(void 0, args) : value;
    }
    function debounce(fn, ms) {
      if (ms === 0) {
        return fn;
      }
      var timeout;
      return function (arg) {
        clearTimeout(timeout);
        timeout = setTimeout(function () {
          fn(arg);
        }, ms);
      };
    }
    function removeProperties(obj, keys) {
      var clone = Object.assign({}, obj);
      keys.forEach(function (key) {
        delete clone[key];
      });
      return clone;
    }
    function splitBySpaces(value) {
      return value.split(/\s+/).filter(Boolean);
    }
    function normalizeToArray(value) {
      return [].concat(value);
    }
    function pushIfUnique(arr, value) {
      if (arr.indexOf(value) === -1) {
        arr.push(value);
      }
    }
    function unique(arr) {
      return arr.filter(function (item, index) {
        return arr.indexOf(item) === index;
      });
    }
    function getBasePlacement(placement) {
      return placement.split("-")[0];
    }
    function arrayFrom(value) {
      return [].slice.call(value);
    }
    function removeUndefinedProps(obj) {
      return Object.keys(obj).reduce(function (acc, key) {
        if (obj[key] !== void 0) {
          acc[key] = obj[key];
        }
        return acc;
      }, {});
    }
    function div() {
      return document.createElement("div");
    }
    function isElement(value) {
      return ["Element", "Fragment"].some(function (type) {
        return isType(value, type);
      });
    }
    function isNodeList(value) {
      return isType(value, "NodeList");
    }
    function isMouseEvent(value) {
      return isType(value, "MouseEvent");
    }
    function isReferenceElement(value) {
      return !!(value && value._tippy && value._tippy.reference === value);
    }
    function getArrayOfElements(value) {
      if (isElement(value)) {
        return [value];
      }
      if (isNodeList(value)) {
        return arrayFrom(value);
      }
      if (Array.isArray(value)) {
        return value;
      }
      return arrayFrom(document.querySelectorAll(value));
    }
    function setTransitionDuration(els, value) {
      els.forEach(function (el) {
        if (el) {
          el.style.transitionDuration = value + "ms";
        }
      });
    }
    function setVisibilityState(els, state) {
      els.forEach(function (el) {
        if (el) {
          el.setAttribute("data-state", state);
        }
      });
    }
    function getOwnerDocument(elementOrElements) {
      var _element$ownerDocumen;
      var _normalizeToArray = normalizeToArray(elementOrElements),
        element = _normalizeToArray[0];
      return (element == null ? void 0 : (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body) ? element.ownerDocument : document;
    }
    function isCursorOutsideInteractiveBorder(popperTreeData, event) {
      var clientX = event.clientX,
        clientY = event.clientY;
      return popperTreeData.every(function (_ref) {
        var popperRect = _ref.popperRect,
          popperState = _ref.popperState,
          props = _ref.props;
        var interactiveBorder = props.interactiveBorder;
        var basePlacement = getBasePlacement(popperState.placement);
        var offsetData = popperState.modifiersData.offset;
        if (!offsetData) {
          return true;
        }
        var topDistance = basePlacement === "bottom" ? offsetData.top.y : 0;
        var bottomDistance = basePlacement === "top" ? offsetData.bottom.y : 0;
        var leftDistance = basePlacement === "right" ? offsetData.left.x : 0;
        var rightDistance = basePlacement === "left" ? offsetData.right.x : 0;
        var exceedsTop = popperRect.top - clientY + topDistance > interactiveBorder;
        var exceedsBottom = clientY - popperRect.bottom - bottomDistance > interactiveBorder;
        var exceedsLeft = popperRect.left - clientX + leftDistance > interactiveBorder;
        var exceedsRight = clientX - popperRect.right - rightDistance > interactiveBorder;
        return exceedsTop || exceedsBottom || exceedsLeft || exceedsRight;
      });
    }
    function updateTransitionEndListener(box, action, listener) {
      var method = action + "EventListener";
      ["transitionend", "webkitTransitionEnd"].forEach(function (event) {
        box[method](event, listener);
      });
    }
    var currentInput = {
      isTouch: false
    };
    var lastMouseMoveTime = 0;
    function onDocumentTouchStart() {
      if (currentInput.isTouch) {
        return;
      }
      currentInput.isTouch = true;
      if (window.performance) {
        document.addEventListener("mousemove", onDocumentMouseMove);
      }
    }
    function onDocumentMouseMove() {
      var now = performance.now();
      if (now - lastMouseMoveTime < 20) {
        currentInput.isTouch = false;
        document.removeEventListener("mousemove", onDocumentMouseMove);
      }
      lastMouseMoveTime = now;
    }
    function onWindowBlur() {
      var activeElement = document.activeElement;
      if (isReferenceElement(activeElement)) {
        var instance = activeElement._tippy;
        if (activeElement.blur && !instance.state.isVisible) {
          activeElement.blur();
        }
      }
    }
    function bindGlobalEventListeners() {
      document.addEventListener("touchstart", onDocumentTouchStart, TOUCH_OPTIONS);
      window.addEventListener("blur", onWindowBlur);
    }
    var isBrowser = typeof window !== "undefined" && typeof document !== "undefined";
    var ua = isBrowser ? navigator.userAgent : "";
    var isIE = /MSIE |Trident\//.test(ua);
    function createMemoryLeakWarning(method) {
      var txt = method === "destroy" ? "n already-" : " ";
      return [method + "() was called on a" + txt + "destroyed instance. This is a no-op but", "indicates a potential memory leak."].join(" ");
    }
    function clean(value) {
      var spacesAndTabs = /[ \t]{2,}/g;
      var lineStartWithSpaces = /^[ \t]*/gm;
      return value.replace(spacesAndTabs, " ").replace(lineStartWithSpaces, "").trim();
    }
    function getDevMessage(message) {
      return clean("\n  %ctippy.js\n\n  %c" + clean(message) + "\n\n  %c\u{1F477}\u200D This is a development-only message. It will be removed in production.\n  ");
    }
    function getFormattedMessage(message) {
      return [getDevMessage(message), "color: #00C584; font-size: 1.3em; font-weight: bold;", "line-height: 1.5", "color: #a6a095;"];
    }
    var visitedMessages;
    {
      resetVisitedMessages();
    }
    function resetVisitedMessages() {
      visitedMessages = new Set();
    }
    function warnWhen(condition, message) {
      if (condition && !visitedMessages.has(message)) {
        var _console;
        visitedMessages.add(message);
        (_console = console).warn.apply(_console, getFormattedMessage(message));
      }
    }
    function errorWhen(condition, message) {
      if (condition && !visitedMessages.has(message)) {
        var _console2;
        visitedMessages.add(message);
        (_console2 = console).error.apply(_console2, getFormattedMessage(message));
      }
    }
    function validateTargets(targets) {
      var didPassFalsyValue = !targets;
      var didPassPlainObject = Object.prototype.toString.call(targets) === "[object Object]" && !targets.addEventListener;
      errorWhen(didPassFalsyValue, ["tippy() was passed", "`" + String(targets) + "`", "as its targets (first) argument. Valid types are: String, Element,", "Element[], or NodeList."].join(" "));
      errorWhen(didPassPlainObject, ["tippy() was passed a plain object which is not supported as an argument", "for virtual positioning. Use props.getReferenceClientRect instead."].join(" "));
    }
    var pluginProps = {
      animateFill: false,
      followCursor: false,
      inlinePositioning: false,
      sticky: false
    };
    var renderProps = {
      allowHTML: false,
      animation: "fade",
      arrow: true,
      content: "",
      inertia: false,
      maxWidth: 350,
      role: "tooltip",
      theme: "",
      zIndex: 9999
    };
    var defaultProps = Object.assign({
      appendTo: function appendTo() {
        return document.body;
      },
      aria: {
        content: "auto",
        expanded: "auto"
      },
      delay: 0,
      duration: [300, 250],
      getReferenceClientRect: null,
      hideOnClick: true,
      ignoreAttributes: false,
      interactive: false,
      interactiveBorder: 2,
      interactiveDebounce: 0,
      moveTransition: "",
      offset: [0, 10],
      onAfterUpdate: function onAfterUpdate() {},
      onBeforeUpdate: function onBeforeUpdate() {},
      onCreate: function onCreate() {},
      onDestroy: function onDestroy() {},
      onHidden: function onHidden() {},
      onHide: function onHide() {},
      onMount: function onMount() {},
      onShow: function onShow() {},
      onShown: function onShown() {},
      onTrigger: function onTrigger() {},
      onUntrigger: function onUntrigger() {},
      onClickOutside: function onClickOutside() {},
      placement: "top",
      plugins: [],
      popperOptions: {},
      render: null,
      showOnCreate: false,
      touch: true,
      trigger: "mouseenter focus",
      triggerTarget: null
    }, pluginProps, {}, renderProps);
    var defaultKeys = Object.keys(defaultProps);
    var setDefaultProps = function setDefaultProps2(partialProps) {
      {
        validateProps(partialProps, []);
      }
      var keys = Object.keys(partialProps);
      keys.forEach(function (key) {
        defaultProps[key] = partialProps[key];
      });
    };
    function getExtendedPassedProps(passedProps) {
      var plugins = passedProps.plugins || [];
      var pluginProps2 = plugins.reduce(function (acc, plugin) {
        var name = plugin.name,
          defaultValue = plugin.defaultValue;
        if (name) {
          acc[name] = passedProps[name] !== void 0 ? passedProps[name] : defaultValue;
        }
        return acc;
      }, {});
      return Object.assign({}, passedProps, {}, pluginProps2);
    }
    function getDataAttributeProps(reference, plugins) {
      var propKeys = plugins ? Object.keys(getExtendedPassedProps(Object.assign({}, defaultProps, {
        plugins
      }))) : defaultKeys;
      var props = propKeys.reduce(function (acc, key) {
        var valueAsString = (reference.getAttribute("data-tippy-" + key) || "").trim();
        if (!valueAsString) {
          return acc;
        }
        if (key === "content") {
          acc[key] = valueAsString;
        } else {
          try {
            acc[key] = JSON.parse(valueAsString);
          } catch (e) {
            acc[key] = valueAsString;
          }
        }
        return acc;
      }, {});
      return props;
    }
    function evaluateProps(reference, props) {
      var out = Object.assign({}, props, {
        content: invokeWithArgsOrReturn(props.content, [reference])
      }, props.ignoreAttributes ? {} : getDataAttributeProps(reference, props.plugins));
      out.aria = Object.assign({}, defaultProps.aria, {}, out.aria);
      out.aria = {
        expanded: out.aria.expanded === "auto" ? props.interactive : out.aria.expanded,
        content: out.aria.content === "auto" ? props.interactive ? null : "describedby" : out.aria.content
      };
      return out;
    }
    function validateProps(partialProps, plugins) {
      if (partialProps === void 0) {
        partialProps = {};
      }
      if (plugins === void 0) {
        plugins = [];
      }
      var keys = Object.keys(partialProps);
      keys.forEach(function (prop) {
        var nonPluginProps = removeProperties(defaultProps, Object.keys(pluginProps));
        var didPassUnknownProp = !hasOwnProperty(nonPluginProps, prop);
        if (didPassUnknownProp) {
          didPassUnknownProp = plugins.filter(function (plugin) {
            return plugin.name === prop;
          }).length === 0;
        }
        warnWhen(didPassUnknownProp, ["`" + prop + "`", "is not a valid prop. You may have spelled it incorrectly, or if it's", "a plugin, forgot to pass it in an array as props.plugins.", "\n\n", "All props: https://atomiks.github.io/tippyjs/v6/all-props/\n", "Plugins: https://atomiks.github.io/tippyjs/v6/plugins/"].join(" "));
      });
    }
    var innerHTML = function innerHTML2() {
      return "innerHTML";
    };
    function dangerouslySetInnerHTML(element, html) {
      element[innerHTML()] = html;
    }
    function createArrowElement(value) {
      var arrow = div();
      if (value === true) {
        arrow.className = ARROW_CLASS;
      } else {
        arrow.className = SVG_ARROW_CLASS;
        if (isElement(value)) {
          arrow.appendChild(value);
        } else {
          dangerouslySetInnerHTML(arrow, value);
        }
      }
      return arrow;
    }
    function setContent(content, props) {
      if (isElement(props.content)) {
        dangerouslySetInnerHTML(content, "");
        content.appendChild(props.content);
      } else if (typeof props.content !== "function") {
        if (props.allowHTML) {
          dangerouslySetInnerHTML(content, props.content);
        } else {
          content.textContent = props.content;
        }
      }
    }
    function getChildren(popper) {
      var box = popper.firstElementChild;
      var boxChildren = arrayFrom(box.children);
      return {
        box,
        content: boxChildren.find(function (node) {
          return node.classList.contains(CONTENT_CLASS);
        }),
        arrow: boxChildren.find(function (node) {
          return node.classList.contains(ARROW_CLASS) || node.classList.contains(SVG_ARROW_CLASS);
        }),
        backdrop: boxChildren.find(function (node) {
          return node.classList.contains(BACKDROP_CLASS);
        })
      };
    }
    function render(instance) {
      var popper = div();
      var box = div();
      box.className = BOX_CLASS;
      box.setAttribute("data-state", "hidden");
      box.setAttribute("tabindex", "-1");
      var content = div();
      content.className = CONTENT_CLASS;
      content.setAttribute("data-state", "hidden");
      setContent(content, instance.props);
      popper.appendChild(box);
      box.appendChild(content);
      onUpdate(instance.props, instance.props);
      function onUpdate(prevProps, nextProps) {
        var _getChildren = getChildren(popper),
          box2 = _getChildren.box,
          content2 = _getChildren.content,
          arrow = _getChildren.arrow;
        if (nextProps.theme) {
          box2.setAttribute("data-theme", nextProps.theme);
        } else {
          box2.removeAttribute("data-theme");
        }
        if (typeof nextProps.animation === "string") {
          box2.setAttribute("data-animation", nextProps.animation);
        } else {
          box2.removeAttribute("data-animation");
        }
        if (nextProps.inertia) {
          box2.setAttribute("data-inertia", "");
        } else {
          box2.removeAttribute("data-inertia");
        }
        box2.style.maxWidth = typeof nextProps.maxWidth === "number" ? nextProps.maxWidth + "px" : nextProps.maxWidth;
        if (nextProps.role) {
          box2.setAttribute("role", nextProps.role);
        } else {
          box2.removeAttribute("role");
        }
        if (prevProps.content !== nextProps.content || prevProps.allowHTML !== nextProps.allowHTML) {
          setContent(content2, instance.props);
        }
        if (nextProps.arrow) {
          if (!arrow) {
            box2.appendChild(createArrowElement(nextProps.arrow));
          } else if (prevProps.arrow !== nextProps.arrow) {
            box2.removeChild(arrow);
            box2.appendChild(createArrowElement(nextProps.arrow));
          }
        } else if (arrow) {
          box2.removeChild(arrow);
        }
      }
      return {
        popper,
        onUpdate
      };
    }
    render.$$tippy = true;
    var idCounter = 1;
    var mouseMoveListeners = [];
    var mountedInstances = [];
    function createTippy(reference, passedProps) {
      var props = evaluateProps(reference, Object.assign({}, defaultProps, {}, getExtendedPassedProps(removeUndefinedProps(passedProps))));
      var showTimeout;
      var hideTimeout;
      var scheduleHideAnimationFrame;
      var isVisibleFromClick = false;
      var didHideDueToDocumentMouseDown = false;
      var didTouchMove = false;
      var ignoreOnFirstUpdate = false;
      var lastTriggerEvent;
      var currentTransitionEndListener;
      var onFirstUpdate;
      var listeners = [];
      var debouncedOnMouseMove = debounce(onMouseMove, props.interactiveDebounce);
      var currentTarget;
      var id = idCounter++;
      var popperInstance = null;
      var plugins = unique(props.plugins);
      var state = {
        isEnabled: true,
        isVisible: false,
        isDestroyed: false,
        isMounted: false,
        isShown: false
      };
      var instance = {
        id,
        reference,
        popper: div(),
        popperInstance,
        props,
        state,
        plugins,
        clearDelayTimeouts,
        setProps,
        setContent: setContent2,
        show,
        hide,
        hideWithInteractivity,
        enable,
        disable,
        unmount,
        destroy
      };
      if (!props.render) {
        {
          errorWhen(true, "render() function has not been supplied.");
        }
        return instance;
      }
      var _props$render = props.render(instance),
        popper = _props$render.popper,
        onUpdate = _props$render.onUpdate;
      popper.setAttribute("data-tippy-root", "");
      popper.id = "tippy-" + instance.id;
      instance.popper = popper;
      reference._tippy = instance;
      popper._tippy = instance;
      var pluginsHooks = plugins.map(function (plugin) {
        return plugin.fn(instance);
      });
      var hasAriaExpanded = reference.hasAttribute("aria-expanded");
      addListeners();
      handleAriaExpandedAttribute();
      handleStyles();
      invokeHook("onCreate", [instance]);
      if (props.showOnCreate) {
        scheduleShow();
      }
      popper.addEventListener("mouseenter", function () {
        if (instance.props.interactive && instance.state.isVisible) {
          instance.clearDelayTimeouts();
        }
      });
      popper.addEventListener("mouseleave", function (event) {
        if (instance.props.interactive && instance.props.trigger.indexOf("mouseenter") >= 0) {
          getDocument().addEventListener("mousemove", debouncedOnMouseMove);
          debouncedOnMouseMove(event);
        }
      });
      return instance;
      function getNormalizedTouchSettings() {
        var touch = instance.props.touch;
        return Array.isArray(touch) ? touch : [touch, 0];
      }
      function getIsCustomTouchBehavior() {
        return getNormalizedTouchSettings()[0] === "hold";
      }
      function getIsDefaultRenderFn() {
        var _instance$props$rende;
        return !!((_instance$props$rende = instance.props.render) == null ? void 0 : _instance$props$rende.$$tippy);
      }
      function getCurrentTarget() {
        return currentTarget || reference;
      }
      function getDocument() {
        var parent = getCurrentTarget().parentNode;
        return parent ? getOwnerDocument(parent) : document;
      }
      function getDefaultTemplateChildren() {
        return getChildren(popper);
      }
      function getDelay(isShow) {
        if (instance.state.isMounted && !instance.state.isVisible || currentInput.isTouch || lastTriggerEvent && lastTriggerEvent.type === "focus") {
          return 0;
        }
        return getValueAtIndexOrReturn(instance.props.delay, isShow ? 0 : 1, defaultProps.delay);
      }
      function handleStyles() {
        popper.style.pointerEvents = instance.props.interactive && instance.state.isVisible ? "" : "none";
        popper.style.zIndex = "" + instance.props.zIndex;
      }
      function invokeHook(hook, args, shouldInvokePropsHook) {
        if (shouldInvokePropsHook === void 0) {
          shouldInvokePropsHook = true;
        }
        pluginsHooks.forEach(function (pluginHooks) {
          if (pluginHooks[hook]) {
            pluginHooks[hook].apply(void 0, args);
          }
        });
        if (shouldInvokePropsHook) {
          var _instance$props;
          (_instance$props = instance.props)[hook].apply(_instance$props, args);
        }
      }
      function handleAriaContentAttribute() {
        var aria = instance.props.aria;
        if (!aria.content) {
          return;
        }
        var attr = "aria-" + aria.content;
        var id2 = popper.id;
        var nodes = normalizeToArray(instance.props.triggerTarget || reference);
        nodes.forEach(function (node) {
          var currentValue = node.getAttribute(attr);
          if (instance.state.isVisible) {
            node.setAttribute(attr, currentValue ? currentValue + " " + id2 : id2);
          } else {
            var nextValue = currentValue && currentValue.replace(id2, "").trim();
            if (nextValue) {
              node.setAttribute(attr, nextValue);
            } else {
              node.removeAttribute(attr);
            }
          }
        });
      }
      function handleAriaExpandedAttribute() {
        if (hasAriaExpanded || !instance.props.aria.expanded) {
          return;
        }
        var nodes = normalizeToArray(instance.props.triggerTarget || reference);
        nodes.forEach(function (node) {
          if (instance.props.interactive) {
            node.setAttribute("aria-expanded", instance.state.isVisible && node === getCurrentTarget() ? "true" : "false");
          } else {
            node.removeAttribute("aria-expanded");
          }
        });
      }
      function cleanupInteractiveMouseListeners() {
        getDocument().removeEventListener("mousemove", debouncedOnMouseMove);
        mouseMoveListeners = mouseMoveListeners.filter(function (listener) {
          return listener !== debouncedOnMouseMove;
        });
      }
      function onDocumentPress(event) {
        if (currentInput.isTouch) {
          if (didTouchMove || event.type === "mousedown") {
            return;
          }
        }
        if (instance.props.interactive && popper.contains(event.target)) {
          return;
        }
        if (getCurrentTarget().contains(event.target)) {
          if (currentInput.isTouch) {
            return;
          }
          if (instance.state.isVisible && instance.props.trigger.indexOf("click") >= 0) {
            return;
          }
        } else {
          invokeHook("onClickOutside", [instance, event]);
        }
        if (instance.props.hideOnClick === true) {
          instance.clearDelayTimeouts();
          instance.hide();
          didHideDueToDocumentMouseDown = true;
          setTimeout(function () {
            didHideDueToDocumentMouseDown = false;
          });
          if (!instance.state.isMounted) {
            removeDocumentPress();
          }
        }
      }
      function onTouchMove() {
        didTouchMove = true;
      }
      function onTouchStart() {
        didTouchMove = false;
      }
      function addDocumentPress() {
        var doc = getDocument();
        doc.addEventListener("mousedown", onDocumentPress, true);
        doc.addEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
        doc.addEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
        doc.addEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
      }
      function removeDocumentPress() {
        var doc = getDocument();
        doc.removeEventListener("mousedown", onDocumentPress, true);
        doc.removeEventListener("touchend", onDocumentPress, TOUCH_OPTIONS);
        doc.removeEventListener("touchstart", onTouchStart, TOUCH_OPTIONS);
        doc.removeEventListener("touchmove", onTouchMove, TOUCH_OPTIONS);
      }
      function onTransitionedOut(duration, callback) {
        onTransitionEnd(duration, function () {
          if (!instance.state.isVisible && popper.parentNode && popper.parentNode.contains(popper)) {
            callback();
          }
        });
      }
      function onTransitionedIn(duration, callback) {
        onTransitionEnd(duration, callback);
      }
      function onTransitionEnd(duration, callback) {
        var box = getDefaultTemplateChildren().box;
        function listener(event) {
          if (event.target === box) {
            updateTransitionEndListener(box, "remove", listener);
            callback();
          }
        }
        if (duration === 0) {
          return callback();
        }
        updateTransitionEndListener(box, "remove", currentTransitionEndListener);
        updateTransitionEndListener(box, "add", listener);
        currentTransitionEndListener = listener;
      }
      function on(eventType, handler, options) {
        if (options === void 0) {
          options = false;
        }
        var nodes = normalizeToArray(instance.props.triggerTarget || reference);
        nodes.forEach(function (node) {
          node.addEventListener(eventType, handler, options);
          listeners.push({
            node,
            eventType,
            handler,
            options
          });
        });
      }
      function addListeners() {
        if (getIsCustomTouchBehavior()) {
          on("touchstart", onTrigger, {
            passive: true
          });
          on("touchend", onMouseLeave, {
            passive: true
          });
        }
        splitBySpaces(instance.props.trigger).forEach(function (eventType) {
          if (eventType === "manual") {
            return;
          }
          on(eventType, onTrigger);
          switch (eventType) {
            case "mouseenter":
              on("mouseleave", onMouseLeave);
              break;
            case "focus":
              on(isIE ? "focusout" : "blur", onBlurOrFocusOut);
              break;
            case "focusin":
              on("focusout", onBlurOrFocusOut);
              break;
          }
        });
      }
      function removeListeners() {
        listeners.forEach(function (_ref) {
          var node = _ref.node,
            eventType = _ref.eventType,
            handler = _ref.handler,
            options = _ref.options;
          node.removeEventListener(eventType, handler, options);
        });
        listeners = [];
      }
      function onTrigger(event) {
        var _lastTriggerEvent;
        var shouldScheduleClickHide = false;
        if (!instance.state.isEnabled || isEventListenerStopped(event) || didHideDueToDocumentMouseDown) {
          return;
        }
        var wasFocused = ((_lastTriggerEvent = lastTriggerEvent) == null ? void 0 : _lastTriggerEvent.type) === "focus";
        lastTriggerEvent = event;
        currentTarget = event.currentTarget;
        handleAriaExpandedAttribute();
        if (!instance.state.isVisible && isMouseEvent(event)) {
          mouseMoveListeners.forEach(function (listener) {
            return listener(event);
          });
        }
        if (event.type === "click" && (instance.props.trigger.indexOf("mouseenter") < 0 || isVisibleFromClick) && instance.props.hideOnClick !== false && instance.state.isVisible) {
          shouldScheduleClickHide = true;
        } else {
          scheduleShow(event);
        }
        if (event.type === "click") {
          isVisibleFromClick = !shouldScheduleClickHide;
        }
        if (shouldScheduleClickHide && !wasFocused) {
          scheduleHide(event);
        }
      }
      function onMouseMove(event) {
        var target = event.target;
        var isCursorOverReferenceOrPopper = getCurrentTarget().contains(target) || popper.contains(target);
        if (event.type === "mousemove" && isCursorOverReferenceOrPopper) {
          return;
        }
        var popperTreeData = getNestedPopperTree().concat(popper).map(function (popper2) {
          var _instance$popperInsta;
          var instance2 = popper2._tippy;
          var state2 = (_instance$popperInsta = instance2.popperInstance) == null ? void 0 : _instance$popperInsta.state;
          if (state2) {
            return {
              popperRect: popper2.getBoundingClientRect(),
              popperState: state2,
              props
            };
          }
          return null;
        }).filter(Boolean);
        if (isCursorOutsideInteractiveBorder(popperTreeData, event)) {
          cleanupInteractiveMouseListeners();
          scheduleHide(event);
        }
      }
      function onMouseLeave(event) {
        var shouldBail = isEventListenerStopped(event) || instance.props.trigger.indexOf("click") >= 0 && isVisibleFromClick;
        if (shouldBail) {
          return;
        }
        if (instance.props.interactive) {
          instance.hideWithInteractivity(event);
          return;
        }
        scheduleHide(event);
      }
      function onBlurOrFocusOut(event) {
        if (instance.props.trigger.indexOf("focusin") < 0 && event.target !== getCurrentTarget()) {
          return;
        }
        if (instance.props.interactive && event.relatedTarget && popper.contains(event.relatedTarget)) {
          return;
        }
        scheduleHide(event);
      }
      function isEventListenerStopped(event) {
        return currentInput.isTouch ? getIsCustomTouchBehavior() !== event.type.indexOf("touch") >= 0 : false;
      }
      function createPopperInstance() {
        destroyPopperInstance();
        var _instance$props2 = instance.props,
          popperOptions = _instance$props2.popperOptions,
          placement = _instance$props2.placement,
          offset = _instance$props2.offset,
          getReferenceClientRect = _instance$props2.getReferenceClientRect,
          moveTransition = _instance$props2.moveTransition;
        var arrow = getIsDefaultRenderFn() ? getChildren(popper).arrow : null;
        var computedReference = getReferenceClientRect ? {
          getBoundingClientRect: getReferenceClientRect,
          contextElement: getReferenceClientRect.contextElement || getCurrentTarget()
        } : reference;
        var tippyModifier = {
          name: "$$tippy",
          enabled: true,
          phase: "beforeWrite",
          requires: ["computeStyles"],
          fn: function fn(_ref2) {
            var state2 = _ref2.state;
            if (getIsDefaultRenderFn()) {
              var _getDefaultTemplateCh = getDefaultTemplateChildren(),
                box = _getDefaultTemplateCh.box;
              ["placement", "reference-hidden", "escaped"].forEach(function (attr) {
                if (attr === "placement") {
                  box.setAttribute("data-placement", state2.placement);
                } else {
                  if (state2.attributes.popper["data-popper-" + attr]) {
                    box.setAttribute("data-" + attr, "");
                  } else {
                    box.removeAttribute("data-" + attr);
                  }
                }
              });
              state2.attributes.popper = {};
            }
          }
        };
        var modifiers = [{
          name: "offset",
          options: {
            offset
          }
        }, {
          name: "preventOverflow",
          options: {
            padding: {
              top: 2,
              bottom: 2,
              left: 5,
              right: 5
            }
          }
        }, {
          name: "flip",
          options: {
            padding: 5
          }
        }, {
          name: "computeStyles",
          options: {
            adaptive: !moveTransition
          }
        }, tippyModifier];
        if (getIsDefaultRenderFn() && arrow) {
          modifiers.push({
            name: "arrow",
            options: {
              element: arrow,
              padding: 3
            }
          });
        }
        modifiers.push.apply(modifiers, (popperOptions == null ? void 0 : popperOptions.modifiers) || []);
        instance.popperInstance = core.createPopper(computedReference, popper, Object.assign({}, popperOptions, {
          placement,
          onFirstUpdate,
          modifiers
        }));
      }
      function destroyPopperInstance() {
        if (instance.popperInstance) {
          instance.popperInstance.destroy();
          instance.popperInstance = null;
        }
      }
      function mount() {
        var appendTo = instance.props.appendTo;
        var parentNode;
        var node = getCurrentTarget();
        if (instance.props.interactive && appendTo === defaultProps.appendTo || appendTo === "parent") {
          parentNode = node.parentNode;
        } else {
          parentNode = invokeWithArgsOrReturn(appendTo, [node]);
        }
        if (!parentNode.contains(popper)) {
          parentNode.appendChild(popper);
        }
        createPopperInstance();
        {
          warnWhen(instance.props.interactive && appendTo === defaultProps.appendTo && node.nextElementSibling !== popper, ["Interactive tippy element may not be accessible via keyboard", "navigation because it is not directly after the reference element", "in the DOM source order.", "\n\n", "Using a wrapper <div> or <span> tag around the reference element", "solves this by creating a new parentNode context.", "\n\n", "Specifying `appendTo: document.body` silences this warning, but it", "assumes you are using a focus management solution to handle", "keyboard navigation.", "\n\n", "See: https://atomiks.github.io/tippyjs/v6/accessibility/#interactivity"].join(" "));
        }
      }
      function getNestedPopperTree() {
        return arrayFrom(popper.querySelectorAll("[data-tippy-root]"));
      }
      function scheduleShow(event) {
        instance.clearDelayTimeouts();
        if (event) {
          invokeHook("onTrigger", [instance, event]);
        }
        addDocumentPress();
        var delay = getDelay(true);
        var _getNormalizedTouchSe = getNormalizedTouchSettings(),
          touchValue = _getNormalizedTouchSe[0],
          touchDelay = _getNormalizedTouchSe[1];
        if (currentInput.isTouch && touchValue === "hold" && touchDelay) {
          delay = touchDelay;
        }
        if (delay) {
          showTimeout = setTimeout(function () {
            instance.show();
          }, delay);
        } else {
          instance.show();
        }
      }
      function scheduleHide(event) {
        instance.clearDelayTimeouts();
        invokeHook("onUntrigger", [instance, event]);
        if (!instance.state.isVisible) {
          removeDocumentPress();
          return;
        }
        if (instance.props.trigger.indexOf("mouseenter") >= 0 && instance.props.trigger.indexOf("click") >= 0 && ["mouseleave", "mousemove"].indexOf(event.type) >= 0 && isVisibleFromClick) {
          return;
        }
        var delay = getDelay(false);
        if (delay) {
          hideTimeout = setTimeout(function () {
            if (instance.state.isVisible) {
              instance.hide();
            }
          }, delay);
        } else {
          scheduleHideAnimationFrame = requestAnimationFrame(function () {
            instance.hide();
          });
        }
      }
      function enable() {
        instance.state.isEnabled = true;
      }
      function disable() {
        instance.hide();
        instance.state.isEnabled = false;
      }
      function clearDelayTimeouts() {
        clearTimeout(showTimeout);
        clearTimeout(hideTimeout);
        cancelAnimationFrame(scheduleHideAnimationFrame);
      }
      function setProps(partialProps) {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("setProps"));
        }
        if (instance.state.isDestroyed) {
          return;
        }
        invokeHook("onBeforeUpdate", [instance, partialProps]);
        removeListeners();
        var prevProps = instance.props;
        var nextProps = evaluateProps(reference, Object.assign({}, instance.props, {}, partialProps, {
          ignoreAttributes: true
        }));
        instance.props = nextProps;
        addListeners();
        if (prevProps.interactiveDebounce !== nextProps.interactiveDebounce) {
          cleanupInteractiveMouseListeners();
          debouncedOnMouseMove = debounce(onMouseMove, nextProps.interactiveDebounce);
        }
        if (prevProps.triggerTarget && !nextProps.triggerTarget) {
          normalizeToArray(prevProps.triggerTarget).forEach(function (node) {
            node.removeAttribute("aria-expanded");
          });
        } else if (nextProps.triggerTarget) {
          reference.removeAttribute("aria-expanded");
        }
        handleAriaExpandedAttribute();
        handleStyles();
        if (onUpdate) {
          onUpdate(prevProps, nextProps);
        }
        if (instance.popperInstance) {
          createPopperInstance();
          getNestedPopperTree().forEach(function (nestedPopper) {
            requestAnimationFrame(nestedPopper._tippy.popperInstance.forceUpdate);
          });
        }
        invokeHook("onAfterUpdate", [instance, partialProps]);
      }
      function setContent2(content) {
        instance.setProps({
          content
        });
      }
      function show() {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("show"));
        }
        var isAlreadyVisible = instance.state.isVisible;
        var isDestroyed = instance.state.isDestroyed;
        var isDisabled = !instance.state.isEnabled;
        var isTouchAndTouchDisabled = currentInput.isTouch && !instance.props.touch;
        var duration = getValueAtIndexOrReturn(instance.props.duration, 0, defaultProps.duration);
        if (isAlreadyVisible || isDestroyed || isDisabled || isTouchAndTouchDisabled) {
          return;
        }
        if (getCurrentTarget().hasAttribute("disabled")) {
          return;
        }
        invokeHook("onShow", [instance], false);
        if (instance.props.onShow(instance) === false) {
          return;
        }
        instance.state.isVisible = true;
        if (getIsDefaultRenderFn()) {
          popper.style.visibility = "visible";
        }
        handleStyles();
        addDocumentPress();
        if (!instance.state.isMounted) {
          popper.style.transition = "none";
        }
        if (getIsDefaultRenderFn()) {
          var _getDefaultTemplateCh2 = getDefaultTemplateChildren(),
            box = _getDefaultTemplateCh2.box,
            content = _getDefaultTemplateCh2.content;
          setTransitionDuration([box, content], 0);
        }
        onFirstUpdate = function onFirstUpdate2() {
          var _instance$popperInsta2;
          if (!instance.state.isVisible || ignoreOnFirstUpdate) {
            return;
          }
          ignoreOnFirstUpdate = true;
          void popper.offsetHeight;
          popper.style.transition = instance.props.moveTransition;
          if (getIsDefaultRenderFn() && instance.props.animation) {
            var _getDefaultTemplateCh3 = getDefaultTemplateChildren(),
              _box = _getDefaultTemplateCh3.box,
              _content = _getDefaultTemplateCh3.content;
            setTransitionDuration([_box, _content], duration);
            setVisibilityState([_box, _content], "visible");
          }
          handleAriaContentAttribute();
          handleAriaExpandedAttribute();
          pushIfUnique(mountedInstances, instance);
          (_instance$popperInsta2 = instance.popperInstance) == null ? void 0 : _instance$popperInsta2.forceUpdate();
          instance.state.isMounted = true;
          invokeHook("onMount", [instance]);
          if (instance.props.animation && getIsDefaultRenderFn()) {
            onTransitionedIn(duration, function () {
              instance.state.isShown = true;
              invokeHook("onShown", [instance]);
            });
          }
        };
        mount();
      }
      function hide() {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("hide"));
        }
        var isAlreadyHidden = !instance.state.isVisible;
        var isDestroyed = instance.state.isDestroyed;
        var isDisabled = !instance.state.isEnabled;
        var duration = getValueAtIndexOrReturn(instance.props.duration, 1, defaultProps.duration);
        if (isAlreadyHidden || isDestroyed || isDisabled) {
          return;
        }
        invokeHook("onHide", [instance], false);
        if (instance.props.onHide(instance) === false) {
          return;
        }
        instance.state.isVisible = false;
        instance.state.isShown = false;
        ignoreOnFirstUpdate = false;
        isVisibleFromClick = false;
        if (getIsDefaultRenderFn()) {
          popper.style.visibility = "hidden";
        }
        cleanupInteractiveMouseListeners();
        removeDocumentPress();
        handleStyles();
        if (getIsDefaultRenderFn()) {
          var _getDefaultTemplateCh4 = getDefaultTemplateChildren(),
            box = _getDefaultTemplateCh4.box,
            content = _getDefaultTemplateCh4.content;
          if (instance.props.animation) {
            setTransitionDuration([box, content], duration);
            setVisibilityState([box, content], "hidden");
          }
        }
        handleAriaContentAttribute();
        handleAriaExpandedAttribute();
        if (instance.props.animation) {
          if (getIsDefaultRenderFn()) {
            onTransitionedOut(duration, instance.unmount);
          }
        } else {
          instance.unmount();
        }
      }
      function hideWithInteractivity(event) {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("hideWithInteractivity"));
        }
        getDocument().addEventListener("mousemove", debouncedOnMouseMove);
        pushIfUnique(mouseMoveListeners, debouncedOnMouseMove);
        debouncedOnMouseMove(event);
      }
      function unmount() {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("unmount"));
        }
        if (instance.state.isVisible) {
          instance.hide();
        }
        if (!instance.state.isMounted) {
          return;
        }
        destroyPopperInstance();
        getNestedPopperTree().forEach(function (nestedPopper) {
          nestedPopper._tippy.unmount();
        });
        if (popper.parentNode) {
          popper.parentNode.removeChild(popper);
        }
        mountedInstances = mountedInstances.filter(function (i) {
          return i !== instance;
        });
        instance.state.isMounted = false;
        invokeHook("onHidden", [instance]);
      }
      function destroy() {
        {
          warnWhen(instance.state.isDestroyed, createMemoryLeakWarning("destroy"));
        }
        if (instance.state.isDestroyed) {
          return;
        }
        instance.clearDelayTimeouts();
        instance.unmount();
        removeListeners();
        delete reference._tippy;
        instance.state.isDestroyed = true;
        invokeHook("onDestroy", [instance]);
      }
    }
    function tippy2(targets, optionalProps) {
      if (optionalProps === void 0) {
        optionalProps = {};
      }
      var plugins = defaultProps.plugins.concat(optionalProps.plugins || []);
      {
        validateTargets(targets);
        validateProps(optionalProps, plugins);
      }
      bindGlobalEventListeners();
      var passedProps = Object.assign({}, optionalProps, {
        plugins
      });
      var elements = getArrayOfElements(targets);
      {
        var isSingleContentElement = isElement(passedProps.content);
        var isMoreThanOneReferenceElement = elements.length > 1;
        warnWhen(isSingleContentElement && isMoreThanOneReferenceElement, ["tippy() was passed an Element as the `content` prop, but more than", "one tippy instance was created by this invocation. This means the", "content element will only be appended to the last tippy instance.", "\n\n", "Instead, pass the .innerHTML of the element, or use a function that", "returns a cloned version of the element instead.", "\n\n", "1) content: element.innerHTML\n", "2) content: () => element.cloneNode(true)"].join(" "));
      }
      var instances = elements.reduce(function (acc, reference) {
        var instance = reference && createTippy(reference, passedProps);
        if (instance) {
          acc.push(instance);
        }
        return acc;
      }, []);
      return isElement(targets) ? instances[0] : instances;
    }
    tippy2.defaultProps = defaultProps;
    tippy2.setDefaultProps = setDefaultProps;
    tippy2.currentInput = currentInput;
    var hideAll = function hideAll2(_temp) {
      var _ref = _temp === void 0 ? {} : _temp,
        excludedReferenceOrInstance = _ref.exclude,
        duration = _ref.duration;
      mountedInstances.forEach(function (instance) {
        var isExcluded = false;
        if (excludedReferenceOrInstance) {
          isExcluded = isReferenceElement(excludedReferenceOrInstance) ? instance.reference === excludedReferenceOrInstance : instance.popper === excludedReferenceOrInstance.popper;
        }
        if (!isExcluded) {
          var originalDuration = instance.props.duration;
          instance.setProps({
            duration
          });
          instance.hide();
          if (!instance.state.isDestroyed) {
            instance.setProps({
              duration: originalDuration
            });
          }
        }
      });
    };
    var applyStylesModifier = Object.assign({}, core.applyStyles, {
      effect: function effect(_ref) {
        var state = _ref.state;
        var initialStyles = {
          popper: {
            position: state.options.strategy,
            left: "0",
            top: "0",
            margin: "0"
          },
          arrow: {
            position: "absolute"
          },
          reference: {}
        };
        Object.assign(state.elements.popper.style, initialStyles.popper);
        state.styles = initialStyles;
        if (state.elements.arrow) {
          Object.assign(state.elements.arrow.style, initialStyles.arrow);
        }
      }
    });
    var createSingleton = function createSingleton2(tippyInstances, optionalProps) {
      var _optionalProps$popper;
      if (optionalProps === void 0) {
        optionalProps = {};
      }
      {
        errorWhen(!Array.isArray(tippyInstances), ["The first argument passed to createSingleton() must be an array of", "tippy instances. The passed value was", String(tippyInstances)].join(" "));
      }
      var individualInstances = tippyInstances;
      var references = [];
      var currentTarget;
      var overrides = optionalProps.overrides;
      var interceptSetPropsCleanups = [];
      var shownOnCreate = false;
      function setReferences() {
        references = individualInstances.map(function (instance) {
          return instance.reference;
        });
      }
      function enableInstances(isEnabled) {
        individualInstances.forEach(function (instance) {
          if (isEnabled) {
            instance.enable();
          } else {
            instance.disable();
          }
        });
      }
      function interceptSetProps(singleton2) {
        return individualInstances.map(function (instance) {
          var originalSetProps2 = instance.setProps;
          instance.setProps = function (props) {
            originalSetProps2(props);
            if (instance.reference === currentTarget) {
              singleton2.setProps(props);
            }
          };
          return function () {
            instance.setProps = originalSetProps2;
          };
        });
      }
      function prepareInstance(singleton2, target) {
        var index = references.indexOf(target);
        if (target === currentTarget) {
          return;
        }
        currentTarget = target;
        var overrideProps = (overrides || []).concat("content").reduce(function (acc, prop) {
          acc[prop] = individualInstances[index].props[prop];
          return acc;
        }, {});
        singleton2.setProps(Object.assign({}, overrideProps, {
          getReferenceClientRect: typeof overrideProps.getReferenceClientRect === "function" ? overrideProps.getReferenceClientRect : function () {
            return target.getBoundingClientRect();
          }
        }));
      }
      enableInstances(false);
      setReferences();
      var plugin = {
        fn: function fn() {
          return {
            onDestroy: function onDestroy() {
              enableInstances(true);
            },
            onHidden: function onHidden() {
              currentTarget = null;
            },
            onClickOutside: function onClickOutside(instance) {
              if (instance.props.showOnCreate && !shownOnCreate) {
                shownOnCreate = true;
                currentTarget = null;
              }
            },
            onShow: function onShow(instance) {
              if (instance.props.showOnCreate && !shownOnCreate) {
                shownOnCreate = true;
                prepareInstance(instance, references[0]);
              }
            },
            onTrigger: function onTrigger(instance, event) {
              prepareInstance(instance, event.currentTarget);
            }
          };
        }
      };
      var singleton = tippy2(div(), Object.assign({}, removeProperties(optionalProps, ["overrides"]), {
        plugins: [plugin].concat(optionalProps.plugins || []),
        triggerTarget: references,
        popperOptions: Object.assign({}, optionalProps.popperOptions, {
          modifiers: [].concat(((_optionalProps$popper = optionalProps.popperOptions) == null ? void 0 : _optionalProps$popper.modifiers) || [], [applyStylesModifier])
        })
      }));
      var originalShow = singleton.show;
      singleton.show = function (target) {
        originalShow();
        if (!currentTarget && target == null) {
          return prepareInstance(singleton, references[0]);
        }
        if (currentTarget && target == null) {
          return;
        }
        if (typeof target === "number") {
          return references[target] && prepareInstance(singleton, references[target]);
        }
        if (individualInstances.includes(target)) {
          var ref = target.reference;
          return prepareInstance(singleton, ref);
        }
        if (references.includes(target)) {
          return prepareInstance(singleton, target);
        }
      };
      singleton.showNext = function () {
        var first = references[0];
        if (!currentTarget) {
          return singleton.show(0);
        }
        var index = references.indexOf(currentTarget);
        singleton.show(references[index + 1] || first);
      };
      singleton.showPrevious = function () {
        var last = references[references.length - 1];
        if (!currentTarget) {
          return singleton.show(last);
        }
        var index = references.indexOf(currentTarget);
        var target = references[index - 1] || last;
        singleton.show(target);
      };
      var originalSetProps = singleton.setProps;
      singleton.setProps = function (props) {
        overrides = props.overrides || overrides;
        originalSetProps(props);
      };
      singleton.setInstances = function (nextInstances) {
        enableInstances(true);
        interceptSetPropsCleanups.forEach(function (fn) {
          return fn();
        });
        individualInstances = nextInstances;
        enableInstances(false);
        setReferences();
        interceptSetProps(singleton);
        singleton.setProps({
          triggerTarget: references
        });
      };
      interceptSetPropsCleanups = interceptSetProps(singleton);
      return singleton;
    };
    var BUBBLING_EVENTS_MAP = {
      mouseover: "mouseenter",
      focusin: "focus",
      click: "click"
    };
    function delegate(targets, props) {
      {
        errorWhen(!(props && props.target), ["You must specity a `target` prop indicating a CSS selector string matching", "the target elements that should receive a tippy."].join(" "));
      }
      var listeners = [];
      var childTippyInstances = [];
      var disabled = false;
      var target = props.target;
      var nativeProps = removeProperties(props, ["target"]);
      var parentProps = Object.assign({}, nativeProps, {
        trigger: "manual",
        touch: false
      });
      var childProps = Object.assign({}, nativeProps, {
        showOnCreate: true
      });
      var returnValue = tippy2(targets, parentProps);
      var normalizedReturnValue = normalizeToArray(returnValue);
      function onTrigger(event) {
        if (!event.target || disabled) {
          return;
        }
        var targetNode = event.target.closest(target);
        if (!targetNode) {
          return;
        }
        var trigger = targetNode.getAttribute("data-tippy-trigger") || props.trigger || defaultProps.trigger;
        if (targetNode._tippy) {
          return;
        }
        if (event.type === "touchstart" && typeof childProps.touch === "boolean") {
          return;
        }
        if (event.type !== "touchstart" && trigger.indexOf(BUBBLING_EVENTS_MAP[event.type]) < 0) {
          return;
        }
        var instance = tippy2(targetNode, childProps);
        if (instance) {
          childTippyInstances = childTippyInstances.concat(instance);
        }
      }
      function on(node, eventType, handler, options) {
        if (options === void 0) {
          options = false;
        }
        node.addEventListener(eventType, handler, options);
        listeners.push({
          node,
          eventType,
          handler,
          options
        });
      }
      function addEventListeners(instance) {
        var reference = instance.reference;
        on(reference, "touchstart", onTrigger, TOUCH_OPTIONS);
        on(reference, "mouseover", onTrigger);
        on(reference, "focusin", onTrigger);
        on(reference, "click", onTrigger);
      }
      function removeEventListeners() {
        listeners.forEach(function (_ref) {
          var node = _ref.node,
            eventType = _ref.eventType,
            handler = _ref.handler,
            options = _ref.options;
          node.removeEventListener(eventType, handler, options);
        });
        listeners = [];
      }
      function applyMutations(instance) {
        var originalDestroy = instance.destroy;
        var originalEnable = instance.enable;
        var originalDisable = instance.disable;
        instance.destroy = function (shouldDestroyChildInstances) {
          if (shouldDestroyChildInstances === void 0) {
            shouldDestroyChildInstances = true;
          }
          if (shouldDestroyChildInstances) {
            childTippyInstances.forEach(function (instance2) {
              instance2.destroy();
            });
          }
          childTippyInstances = [];
          removeEventListeners();
          originalDestroy();
        };
        instance.enable = function () {
          originalEnable();
          childTippyInstances.forEach(function (instance2) {
            return instance2.enable();
          });
          disabled = false;
        };
        instance.disable = function () {
          originalDisable();
          childTippyInstances.forEach(function (instance2) {
            return instance2.disable();
          });
          disabled = true;
        };
        addEventListeners(instance);
      }
      normalizedReturnValue.forEach(applyMutations);
      return returnValue;
    }
    var animateFill = {
      name: "animateFill",
      defaultValue: false,
      fn: function fn(instance) {
        var _instance$props$rende;
        if (!((_instance$props$rende = instance.props.render) == null ? void 0 : _instance$props$rende.$$tippy)) {
          {
            errorWhen(instance.props.animateFill, "The `animateFill` plugin requires the default render function.");
          }
          return {};
        }
        var _getChildren = getChildren(instance.popper),
          box = _getChildren.box,
          content = _getChildren.content;
        var backdrop = instance.props.animateFill ? createBackdropElement() : null;
        return {
          onCreate: function onCreate() {
            if (backdrop) {
              box.insertBefore(backdrop, box.firstElementChild);
              box.setAttribute("data-animatefill", "");
              box.style.overflow = "hidden";
              instance.setProps({
                arrow: false,
                animation: "shift-away"
              });
            }
          },
          onMount: function onMount() {
            if (backdrop) {
              var transitionDuration = box.style.transitionDuration;
              var duration = Number(transitionDuration.replace("ms", ""));
              content.style.transitionDelay = Math.round(duration / 10) + "ms";
              backdrop.style.transitionDuration = transitionDuration;
              setVisibilityState([backdrop], "visible");
            }
          },
          onShow: function onShow() {
            if (backdrop) {
              backdrop.style.transitionDuration = "0ms";
            }
          },
          onHide: function onHide() {
            if (backdrop) {
              setVisibilityState([backdrop], "hidden");
            }
          }
        };
      }
    };
    function createBackdropElement() {
      var backdrop = div();
      backdrop.className = BACKDROP_CLASS;
      setVisibilityState([backdrop], "hidden");
      return backdrop;
    }
    var mouseCoords = {
      clientX: 0,
      clientY: 0
    };
    var activeInstances = [];
    function storeMouseCoords(_ref) {
      var clientX = _ref.clientX,
        clientY = _ref.clientY;
      mouseCoords = {
        clientX,
        clientY
      };
    }
    function addMouseCoordsListener(doc) {
      doc.addEventListener("mousemove", storeMouseCoords);
    }
    function removeMouseCoordsListener(doc) {
      doc.removeEventListener("mousemove", storeMouseCoords);
    }
    var followCursor2 = {
      name: "followCursor",
      defaultValue: false,
      fn: function fn(instance) {
        var reference = instance.reference;
        var doc = getOwnerDocument(instance.props.triggerTarget || reference);
        var isInternalUpdate = false;
        var wasFocusEvent = false;
        var isUnmounted = true;
        var prevProps = instance.props;
        function getIsInitialBehavior() {
          return instance.props.followCursor === "initial" && instance.state.isVisible;
        }
        function addListener() {
          doc.addEventListener("mousemove", onMouseMove);
        }
        function removeListener() {
          doc.removeEventListener("mousemove", onMouseMove);
        }
        function unsetGetReferenceClientRect() {
          isInternalUpdate = true;
          instance.setProps({
            getReferenceClientRect: null
          });
          isInternalUpdate = false;
        }
        function onMouseMove(event) {
          var isCursorOverReference = event.target ? reference.contains(event.target) : true;
          var followCursor3 = instance.props.followCursor;
          var clientX = event.clientX,
            clientY = event.clientY;
          var rect = reference.getBoundingClientRect();
          var relativeX = clientX - rect.left;
          var relativeY = clientY - rect.top;
          if (isCursorOverReference || !instance.props.interactive) {
            instance.setProps({
              getReferenceClientRect: function getReferenceClientRect() {
                var rect2 = reference.getBoundingClientRect();
                var x = clientX;
                var y = clientY;
                if (followCursor3 === "initial") {
                  x = rect2.left + relativeX;
                  y = rect2.top + relativeY;
                }
                var top = followCursor3 === "horizontal" ? rect2.top : y;
                var right = followCursor3 === "vertical" ? rect2.right : x;
                var bottom = followCursor3 === "horizontal" ? rect2.bottom : y;
                var left = followCursor3 === "vertical" ? rect2.left : x;
                return {
                  width: right - left,
                  height: bottom - top,
                  top,
                  right,
                  bottom,
                  left
                };
              }
            });
          }
        }
        function create() {
          if (instance.props.followCursor) {
            activeInstances.push({
              instance,
              doc
            });
            addMouseCoordsListener(doc);
          }
        }
        function destroy() {
          activeInstances = activeInstances.filter(function (data) {
            return data.instance !== instance;
          });
          if (activeInstances.filter(function (data) {
            return data.doc === doc;
          }).length === 0) {
            removeMouseCoordsListener(doc);
          }
        }
        return {
          onCreate: create,
          onDestroy: destroy,
          onBeforeUpdate: function onBeforeUpdate() {
            prevProps = instance.props;
          },
          onAfterUpdate: function onAfterUpdate(_, _ref2) {
            var followCursor3 = _ref2.followCursor;
            if (isInternalUpdate) {
              return;
            }
            if (followCursor3 !== void 0 && prevProps.followCursor !== followCursor3) {
              destroy();
              if (followCursor3) {
                create();
                if (instance.state.isMounted && !wasFocusEvent && !getIsInitialBehavior()) {
                  addListener();
                }
              } else {
                removeListener();
                unsetGetReferenceClientRect();
              }
            }
          },
          onMount: function onMount() {
            if (instance.props.followCursor && !wasFocusEvent) {
              if (isUnmounted) {
                onMouseMove(mouseCoords);
                isUnmounted = false;
              }
              if (!getIsInitialBehavior()) {
                addListener();
              }
            }
          },
          onTrigger: function onTrigger(_, event) {
            if (isMouseEvent(event)) {
              mouseCoords = {
                clientX: event.clientX,
                clientY: event.clientY
              };
            }
            wasFocusEvent = event.type === "focus";
          },
          onHidden: function onHidden() {
            if (instance.props.followCursor) {
              unsetGetReferenceClientRect();
              removeListener();
              isUnmounted = true;
            }
          }
        };
      }
    };
    function getProps(props, modifier) {
      var _props$popperOptions;
      return {
        popperOptions: Object.assign({}, props.popperOptions, {
          modifiers: [].concat((((_props$popperOptions = props.popperOptions) == null ? void 0 : _props$popperOptions.modifiers) || []).filter(function (_ref) {
            var name = _ref.name;
            return name !== modifier.name;
          }), [modifier])
        })
      };
    }
    var inlinePositioning = {
      name: "inlinePositioning",
      defaultValue: false,
      fn: function fn(instance) {
        var reference = instance.reference;
        function isEnabled() {
          return !!instance.props.inlinePositioning;
        }
        var placement;
        var cursorRectIndex = -1;
        var isInternalUpdate = false;
        var modifier = {
          name: "tippyInlinePositioning",
          enabled: true,
          phase: "afterWrite",
          fn: function fn2(_ref2) {
            var state = _ref2.state;
            if (isEnabled()) {
              if (placement !== state.placement) {
                instance.setProps({
                  getReferenceClientRect: function getReferenceClientRect() {
                    return _getReferenceClientRect(state.placement);
                  }
                });
              }
              placement = state.placement;
            }
          }
        };
        function _getReferenceClientRect(placement2) {
          return getInlineBoundingClientRect(getBasePlacement(placement2), reference.getBoundingClientRect(), arrayFrom(reference.getClientRects()), cursorRectIndex);
        }
        function setInternalProps(partialProps) {
          isInternalUpdate = true;
          instance.setProps(partialProps);
          isInternalUpdate = false;
        }
        function addModifier() {
          if (!isInternalUpdate) {
            setInternalProps(getProps(instance.props, modifier));
          }
        }
        return {
          onCreate: addModifier,
          onAfterUpdate: addModifier,
          onTrigger: function onTrigger(_, event) {
            if (isMouseEvent(event)) {
              var rects = arrayFrom(instance.reference.getClientRects());
              var cursorRect = rects.find(function (rect) {
                return rect.left - 2 <= event.clientX && rect.right + 2 >= event.clientX && rect.top - 2 <= event.clientY && rect.bottom + 2 >= event.clientY;
              });
              cursorRectIndex = rects.indexOf(cursorRect);
            }
          },
          onUntrigger: function onUntrigger() {
            cursorRectIndex = -1;
          }
        };
      }
    };
    function getInlineBoundingClientRect(currentBasePlacement, boundingRect, clientRects, cursorRectIndex) {
      if (clientRects.length < 2 || currentBasePlacement === null) {
        return boundingRect;
      }
      if (clientRects.length === 2 && cursorRectIndex >= 0 && clientRects[0].left > clientRects[1].right) {
        return clientRects[cursorRectIndex] || boundingRect;
      }
      switch (currentBasePlacement) {
        case "top":
        case "bottom":
          {
            var firstRect = clientRects[0];
            var lastRect = clientRects[clientRects.length - 1];
            var isTop = currentBasePlacement === "top";
            var top = firstRect.top;
            var bottom = lastRect.bottom;
            var left = isTop ? firstRect.left : lastRect.left;
            var right = isTop ? firstRect.right : lastRect.right;
            var width = right - left;
            var height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height
            };
          }
        case "left":
        case "right":
          {
            var minLeft = Math.min.apply(Math, clientRects.map(function (rects) {
              return rects.left;
            }));
            var maxRight = Math.max.apply(Math, clientRects.map(function (rects) {
              return rects.right;
            }));
            var measureRects = clientRects.filter(function (rect) {
              return currentBasePlacement === "left" ? rect.left === minLeft : rect.right === maxRight;
            });
            var _top = measureRects[0].top;
            var _bottom = measureRects[measureRects.length - 1].bottom;
            var _left = minLeft;
            var _right = maxRight;
            var _width = _right - _left;
            var _height = _bottom - _top;
            return {
              top: _top,
              bottom: _bottom,
              left: _left,
              right: _right,
              width: _width,
              height: _height
            };
          }
        default:
          {
            return boundingRect;
          }
      }
    }
    var sticky = {
      name: "sticky",
      defaultValue: false,
      fn: function fn(instance) {
        var reference = instance.reference,
          popper = instance.popper;
        function getReference() {
          return instance.popperInstance ? instance.popperInstance.state.elements.reference : reference;
        }
        function shouldCheck(value) {
          return instance.props.sticky === true || instance.props.sticky === value;
        }
        var prevRefRect = null;
        var prevPopRect = null;
        function updatePosition() {
          var currentRefRect = shouldCheck("reference") ? getReference().getBoundingClientRect() : null;
          var currentPopRect = shouldCheck("popper") ? popper.getBoundingClientRect() : null;
          if (currentRefRect && areRectsDifferent(prevRefRect, currentRefRect) || currentPopRect && areRectsDifferent(prevPopRect, currentPopRect)) {
            if (instance.popperInstance) {
              instance.popperInstance.update();
            }
          }
          prevRefRect = currentRefRect;
          prevPopRect = currentPopRect;
          if (instance.state.isMounted) {
            requestAnimationFrame(updatePosition);
          }
        }
        return {
          onMount: function onMount() {
            if (instance.props.sticky) {
              updatePosition();
            }
          }
        };
      }
    };
    function areRectsDifferent(rectA, rectB) {
      if (rectA && rectB) {
        return rectA.top !== rectB.top || rectA.right !== rectB.right || rectA.bottom !== rectB.bottom || rectA.left !== rectB.left;
      }
      return true;
    }
    tippy2.setDefaultProps({
      render
    });
    exports.animateFill = animateFill;
    exports.createSingleton = createSingleton;
    exports.default = tippy2;
    exports.delegate = delegate;
    exports.followCursor = followCursor2;
    exports.hideAll = hideAll;
    exports.inlinePositioning = inlinePositioning;
    exports.roundArrow = ROUND_ARROW;
    exports.sticky = sticky;
  });

  // src/index.js
  var import_tippy2 = __toModule(require_tippy_cjs());

  // src/buildConfigFromModifiers.js
  var import_tippy = __toModule(require_tippy_cjs());
  var buildConfigFromModifiers = modifiers => {
    const config = {
      plugins: []
    };
    const getModifierArgument = modifier => {
      return modifiers[modifiers.indexOf(modifier) + 1];
    };
    if (modifiers.includes("animation")) {
      config.animation = getModifierArgument("animation");
    }
    if (modifiers.includes("duration")) {
      config.duration = parseInt(getModifierArgument("duration"));
    }
    if (modifiers.includes("delay")) {
      const delay = getModifierArgument("delay");
      config.delay = delay.includes("-") ? delay.split("-").map(n => parseInt(n)) : parseInt(delay);
    }
    if (modifiers.includes("cursor")) {
      config.plugins.push(import_tippy.followCursor);
      const next = getModifierArgument("cursor");
      if (["x", "initial"].includes(next)) {
        config.followCursor = next === "x" ? "horizontal" : "initial";
      } else {
        config.followCursor = true;
      }
    }
    if (modifiers.includes("on")) {
      config.trigger = getModifierArgument("on");
    }
    if (modifiers.includes("arrowless")) {
      config.arrow = false;
    }
    if (modifiers.includes("html")) {
      config.allowHTML = true;
    }
    if (modifiers.includes("interactive")) {
      config.interactive = true;
    }
    if (modifiers.includes("border") && config.interactive) {
      config.interactiveBorder = parseInt(getModifierArgument("border"));
    }
    if (modifiers.includes("debounce") && config.interactive) {
      config.interactiveDebounce = parseInt(getModifierArgument("debounce"));
    }
    if (modifiers.includes("max-width")) {
      config.maxWidth = parseInt(getModifierArgument("max-width"));
    }
    if (modifiers.includes("theme")) {
      config.theme = getModifierArgument("theme");
    }
    if (modifiers.includes("placement")) {
      config.placement = getModifierArgument("placement");
    }
    const popperOptions = {};
    if (modifiers.includes("no-flip")) {
      popperOptions.modifiers ||= [];
      popperOptions.modifiers.push({
        name: "flip",
        enabled: false
      });
    }
    config.popperOptions = popperOptions;
    return config;
  };

  // src/index.js
  function Tooltip(Alpine) {
    Alpine.magic("tooltip", el => {
      return (content, config = {}) => {
        const timeout = config.timeout;
        delete config.timeout;
        const instance = (0, import_tippy2.default)(el, {
          content,
          trigger: "manual",
          ...config
        });
        instance.show();
        setTimeout(() => {
          instance.hide();
          setTimeout(() => instance.destroy(), config.duration || 300);
        }, timeout || 2e3);
      };
    });
    Alpine.directive("tooltip", (el, {
      modifiers,
      expression
    }, {
      evaluateLater,
      effect
    }) => {
      const config = modifiers.length > 0 ? buildConfigFromModifiers(modifiers) : {};
      if (!el.__x_tippy) {
        el.__x_tippy = (0, import_tippy2.default)(el, config);
      }
      const enableTooltip = () => el.__x_tippy.enable();
      const disableTooltip = () => el.__x_tippy.disable();
      const setupTooltip = content => {
        if (!content) {
          disableTooltip();
        } else {
          enableTooltip();
          el.__x_tippy.setContent(content);
        }
      };
      if (modifiers.includes("raw")) {
        setupTooltip(expression);
      } else {
        const getContent = evaluateLater(expression);
        effect(() => {
          getContent(content => {
            if (typeof content === "object") {
              el.__x_tippy.setProps(content);
              enableTooltip();
            } else {
              setupTooltip(content);
            }
          });
        });
      }
    });
  }
  Tooltip.defaultProps = props => {
    import_tippy2.default.setDefaultProps(props);
    return Tooltip;
  };
  var src_default = Tooltip;

  // builds/module.js
  var module_default = src_default;

  function initState() {
    module_default$1.store('user', window.state.user);
    module_default$1.store('workspace', window.state.workspace);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"];
    if (null != _i) {
      var _s,
        _e,
        _x,
        _r,
        _arr = [],
        _n = !0,
        _d = !1;
      try {
        if (_x = (_i = _i.call(arr)).next, 0 === i) {
          if (Object(_i) !== _i) return;
          _n = !1;
        } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0);
      } catch (err) {
        _d = !0, _e = err;
      } finally {
        try {
          if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return;
        } finally {
          if (_d) throw _e;
        }
      }
      return _arr;
    }
  }
  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      enumerableOnly && (symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      })), keys.push.apply(keys, symbols);
    }
    return keys;
  }
  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = null != arguments[i] ? arguments[i] : {};
      i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
    return target;
  }
  function _regeneratorRuntime() {
    _regeneratorRuntime = function () {
      return exports;
    };
    var exports = {},
      Op = Object.prototype,
      hasOwn = Op.hasOwnProperty,
      defineProperty = Object.defineProperty || function (obj, key, desc) {
        obj[key] = desc.value;
      },
      $Symbol = "function" == typeof Symbol ? Symbol : {},
      iteratorSymbol = $Symbol.iterator || "@@iterator",
      asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
      toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
    function define(obj, key, value) {
      return Object.defineProperty(obj, key, {
        value: value,
        enumerable: !0,
        configurable: !0,
        writable: !0
      }), obj[key];
    }
    try {
      define({}, "");
    } catch (err) {
      define = function (obj, key, value) {
        return obj[key] = value;
      };
    }
    function wrap(innerFn, outerFn, self, tryLocsList) {
      var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
        generator = Object.create(protoGenerator.prototype),
        context = new Context(tryLocsList || []);
      return defineProperty(generator, "_invoke", {
        value: makeInvokeMethod(innerFn, self, context)
      }), generator;
    }
    function tryCatch(fn, obj, arg) {
      try {
        return {
          type: "normal",
          arg: fn.call(obj, arg)
        };
      } catch (err) {
        return {
          type: "throw",
          arg: err
        };
      }
    }
    exports.wrap = wrap;
    var ContinueSentinel = {};
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}
    var IteratorPrototype = {};
    define(IteratorPrototype, iteratorSymbol, function () {
      return this;
    });
    var getProto = Object.getPrototypeOf,
      NativeIteratorPrototype = getProto && getProto(getProto(values([])));
    NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
    var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
    function defineIteratorMethods(prototype) {
      ["next", "throw", "return"].forEach(function (method) {
        define(prototype, method, function (arg) {
          return this._invoke(method, arg);
        });
      });
    }
    function AsyncIterator(generator, PromiseImpl) {
      function invoke(method, arg, resolve, reject) {
        var record = tryCatch(generator[method], generator, arg);
        if ("throw" !== record.type) {
          var result = record.arg,
            value = result.value;
          return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
            invoke("next", value, resolve, reject);
          }, function (err) {
            invoke("throw", err, resolve, reject);
          }) : PromiseImpl.resolve(value).then(function (unwrapped) {
            result.value = unwrapped, resolve(result);
          }, function (error) {
            return invoke("throw", error, resolve, reject);
          });
        }
        reject(record.arg);
      }
      var previousPromise;
      defineProperty(this, "_invoke", {
        value: function (method, arg) {
          function callInvokeWithMethodAndArg() {
            return new PromiseImpl(function (resolve, reject) {
              invoke(method, arg, resolve, reject);
            });
          }
          return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        }
      });
    }
    function makeInvokeMethod(innerFn, self, context) {
      var state = "suspendedStart";
      return function (method, arg) {
        if ("executing" === state) throw new Error("Generator is already running");
        if ("completed" === state) {
          if ("throw" === method) throw arg;
          return doneResult();
        }
        for (context.method = method, context.arg = arg;;) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }
          if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
            if ("suspendedStart" === state) throw state = "completed", context.arg;
            context.dispatchException(context.arg);
          } else "return" === context.method && context.abrupt("return", context.arg);
          state = "executing";
          var record = tryCatch(innerFn, self, context);
          if ("normal" === record.type) {
            if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
            return {
              value: record.arg,
              done: context.done
            };
          }
          "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
        }
      };
    }
    function maybeInvokeDelegate(delegate, context) {
      var methodName = context.method,
        method = delegate.iterator[methodName];
      if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
      var record = tryCatch(method, delegate.iterator, context.arg);
      if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
      var info = record.arg;
      return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
    }
    function pushTryEntry(locs) {
      var entry = {
        tryLoc: locs[0]
      };
      1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
    }
    function resetTryEntry(entry) {
      var record = entry.completion || {};
      record.type = "normal", delete record.arg, entry.completion = record;
    }
    function Context(tryLocsList) {
      this.tryEntries = [{
        tryLoc: "root"
      }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
    }
    function values(iterable) {
      if (iterable) {
        var iteratorMethod = iterable[iteratorSymbol];
        if (iteratorMethod) return iteratorMethod.call(iterable);
        if ("function" == typeof iterable.next) return iterable;
        if (!isNaN(iterable.length)) {
          var i = -1,
            next = function next() {
              for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
              return next.value = undefined, next.done = !0, next;
            };
          return next.next = next;
        }
      }
      return {
        next: doneResult
      };
    }
    function doneResult() {
      return {
        value: undefined,
        done: !0
      };
    }
    return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
      value: GeneratorFunctionPrototype,
      configurable: !0
    }), defineProperty(GeneratorFunctionPrototype, "constructor", {
      value: GeneratorFunction,
      configurable: !0
    }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
      var ctor = "function" == typeof genFun && genFun.constructor;
      return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
    }, exports.mark = function (genFun) {
      return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
    }, exports.awrap = function (arg) {
      return {
        __await: arg
      };
    }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
      return this;
    }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
      void 0 === PromiseImpl && (PromiseImpl = Promise);
      var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
      return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
        return result.done ? result.value : iter.next();
      });
    }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
      return this;
    }), define(Gp, "toString", function () {
      return "[object Generator]";
    }), exports.keys = function (val) {
      var object = Object(val),
        keys = [];
      for (var key in object) keys.push(key);
      return keys.reverse(), function next() {
        for (; keys.length;) {
          var key = keys.pop();
          if (key in object) return next.value = key, next.done = !1, next;
        }
        return next.done = !0, next;
      };
    }, exports.values = values, Context.prototype = {
      constructor: Context,
      reset: function (skipTempReset) {
        if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
      },
      stop: function () {
        this.done = !0;
        var rootRecord = this.tryEntries[0].completion;
        if ("throw" === rootRecord.type) throw rootRecord.arg;
        return this.rval;
      },
      dispatchException: function (exception) {
        if (this.done) throw exception;
        var context = this;
        function handle(loc, caught) {
          return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
        }
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i],
            record = entry.completion;
          if ("root" === entry.tryLoc) return handle("end");
          if (entry.tryLoc <= this.prev) {
            var hasCatch = hasOwn.call(entry, "catchLoc"),
              hasFinally = hasOwn.call(entry, "finallyLoc");
            if (hasCatch && hasFinally) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            } else if (hasCatch) {
              if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            } else {
              if (!hasFinally) throw new Error("try statement without catch or finally");
              if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
            }
          }
        }
      },
      abrupt: function (type, arg) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
            var finallyEntry = entry;
            break;
          }
        }
        finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
        var record = finallyEntry ? finallyEntry.completion : {};
        return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
      },
      complete: function (record, afterLoc) {
        if ("throw" === record.type) throw record.arg;
        return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
      },
      finish: function (finallyLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
        }
      },
      catch: function (tryLoc) {
        for (var i = this.tryEntries.length - 1; i >= 0; --i) {
          var entry = this.tryEntries[i];
          if (entry.tryLoc === tryLoc) {
            var record = entry.completion;
            if ("throw" === record.type) {
              var thrown = record.arg;
              resetTryEntry(entry);
            }
            return thrown;
          }
        }
        throw new Error("illegal catch attempt");
      },
      delegateYield: function (iterable, resultName, nextLoc) {
        return this.delegate = {
          iterator: values(iterable),
          resultName: resultName,
          nextLoc: nextLoc
        }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
      }
    }, exports;
  }
  function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
      var info = gen[key](arg);
      var value = info.value;
    } catch (error) {
      reject(error);
      return;
    }
    if (info.done) {
      resolve(value);
    } else {
      Promise.resolve(value).then(_next, _throw);
    }
  }
  function _asyncToGenerator(fn) {
    return function () {
      var self = this,
        args = arguments;
      return new Promise(function (resolve, reject) {
        var gen = fn.apply(self, args);
        function _next(value) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
        }
        function _throw(err) {
          asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
        }
        _next(undefined);
      });
    };
  }
  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
    }
  }
  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    Object.defineProperty(subClass, "prototype", {
      writable: false
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }
  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }
  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };
    return _setPrototypeOf(o, p);
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct.bind();
    } else {
      _construct = function _construct(Parent, args, Class) {
        var a = [null];
        a.push.apply(a, args);
        var Constructor = Function.bind.apply(Parent, a);
        var instance = new Constructor();
        if (Class) _setPrototypeOf(instance, Class.prototype);
        return instance;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _isNativeFunction(fn) {
    return Function.toString.call(fn).indexOf("[native code]") !== -1;
  }
  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? new Map() : undefined;
    _wrapNativeSuper = function _wrapNativeSuper(Class) {
      if (Class === null || !_isNativeFunction(Class)) return Class;
      if (typeof Class !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }
      if (typeof _cache !== "undefined") {
        if (_cache.has(Class)) return _cache.get(Class);
        _cache.set(Class, Wrapper);
      }
      function Wrapper() {
        return _construct(Class, arguments, _getPrototypeOf(this).constructor);
      }
      Wrapper.prototype = Object.create(Class.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return _setPrototypeOf(Wrapper, Class);
    };
    return _wrapNativeSuper(Class);
  }
  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self;
  }
  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    } else if (call !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized(self);
  }
  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
        result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn(this, result);
    };
  }
  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }
  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }
  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }
  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }
  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _createForOfIteratorHelper(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;
        var F = function () {};
        return {
          s: F,
          n: function () {
            if (i >= o.length) return {
              done: true
            };
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function (e) {
            throw e;
          },
          f: F
        };
      }
      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    var normalCompletion = true,
      didErr = false,
      err;
    return {
      s: function () {
        it = it.call(o);
      },
      n: function () {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function (e) {
        didErr = true;
        err = e;
      },
      f: function () {
        try {
          if (!normalCompletion && it.return != null) it.return();
        } finally {
          if (didErr) throw err;
        }
      }
    };
  }
  function _toPrimitive(input, hint) {
    if (typeof input !== "object" || input === null) return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== undefined) {
      var res = prim.call(input, hint || "default");
      if (typeof res !== "object") return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return typeof key === "symbol" ? key : String(key);
  }

  function __(str) {
    return window.locale.messages[str] || str;
  }

  /** @type {Toast} */
  var toast$1 = document.querySelector('toast-message');
  window.toast = toast$1;

  function getCookie(name) {
    var value = "; ".concat(document.cookie);
    var parts = value.split("; ".concat(name, "="));
    if (parts.length === 2) return parts.pop().split(';').shift();
  }
  function getJwtToken() {
    return localStorage.getItem('jwt') || getCookie('user');
  }

  /**
   * Extended options for the Fetch request.
   * 
   * @typedef {Object} ResponseAddition
   * @property {Object} data - The JSON response data.
   * 
   * @typedef {Response & ResponseAddition} ExtendedResponse
   */

  /**
   * Extended options for the Fetch request.
   * 
   * @typedef {Object} FetchOptions
   * @property {Record<string, string>} [params] - Query parameter key-value pairs to be appended to the URL.
   * @property {'default' | 'no-store' | 'reload' | 'no-cache' | 'force-cache' | 'only-if-cached'} [cache] - Controls how the request can be cached.
   * @property {'high' | 'low' | 'auto'} [priority] - Indicates the importance of the request.
   * @property {'follow' | 'error' | 'manual'} [redirect] - Controls the behavior of following HTTP redirects.
   * @property {boolean|function(Response)} errorHandler=true - Whether to show a toast message on error.
   */

  /**
   * Defines the API's structure for making HTTP requests.
   *
   * @typedef {Object} Api
   * @property {function(string|URL, Record<string, string>, RequestInit & FetchOptions): Promise<ExtendedResponse>} get - Makes a GET request using the Fetch API.
   * @property {function(string|URL, Record<string, any>|FormData|URLSearchParams, RequestInit & FetchOptions): Promise<ExtendedResponse>} post - Makes a POST request.
   * @property {function(string|URL, Record<string, any>|FormData|URLSearchParams, RequestInit & FetchOptions): Promise<ExtendedResponse>} put - Makes a PUT request.
   * @property {function(string|URL, RequestInit & FetchOptions): Promise<ExtendedResponse>} delete - Makes a DELETE request.
   */

  var ApiError = /*#__PURE__*/function (_Error) {
    _inherits(ApiError, _Error);
    var _super = _createSuper(ApiError);
    /**
     * @param {Response} response
     * @param {string} message 
     */
    function ApiError(response, message) {
      var _this;
      _classCallCheck(this, ApiError);
      _this = _super.call(this, message);
      _this.response = response;
      return _this;
    }
    return _createClass(ApiError);
  }( /*#__PURE__*/_wrapNativeSuper(Error));
  var Api = /*#__PURE__*/function () {
    function Api() {
      _classCallCheck(this, Api);
      _defineProperty(this, "base", null);
    }
    _createClass(Api, [{
      key: "getDefaultHeaders",
      value: function getDefaultHeaders() {
        return {
          'Content-Type': 'application/json',
          'Accept': 'application/json'
        };
      }

      /**
       * Makes an HTTP request using the Fetch API.
       *
       * @param {string} [method='GET'] - The HTTP method.
       * @param {string|URL} url - The URL to send the request to.
       * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
       * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
       */
    }, {
      key: "request",
      value: function () {
        var _request = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
          var method,
            url,
            options,
            opts,
            token,
            _args2 = arguments;
          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                method = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : 'GET';
                url = _args2.length > 1 ? _args2[1] : undefined;
                options = _args2.length > 2 && _args2[2] !== undefined ? _args2[2] : {};
                opts = {
                  method: method,
                  headers: this.getDefaultHeaders() // Use method to avoid reference issues
                };
                token = getJwtToken();
                if (token) {
                  opts.headers['Authorization'] = "Bearer ".concat(token);
                }
                if (module_default$1.store('workspace')) {
                  opts.headers['X-Workspace-Id'] = module_default$1.store('workspace').id;
                }
                url = url instanceof URL ? url : new URL(((this.base || '') + "/" + url).replace(/([^:]\/)\/+/g, "$1"), window.location.origin);
                if (options.params) {
                  Object.keys(options.params).forEach(function (key) {
                    return url.searchParams.append(key, options.params[key]);
                  });
                  delete options.params;
                }
                options = _objectSpread2(_objectSpread2({}, opts), options);
                if (options.body) {
                  if (options.body instanceof FormData) {
                    // FormData already sets the correct Content-Type with the boundary
                    delete options.headers['Content-Type'];
                  } else if (options.body instanceof URLSearchParams) {
                    options.headers['Content-Type'] = 'application/x-www-form-urlencoded';
                  } else if (options.headers['Content-Type'] === 'application/json' && typeof options.body !== 'string') {
                    options.body = JSON.stringify(options.body);
                  }
                }
                return _context2.abrupt("return", fetch(url, _objectSpread2(_objectSpread2({}, opts), options)).then( /*#__PURE__*/function () {
                  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(response) {
                    var clone, message;
                    return _regeneratorRuntime().wrap(function _callee$(_context) {
                      while (1) switch (_context.prev = _context.next) {
                        case 0:
                          clone = response.clone();
                          response.data = {};
                          if (!(response.headers.get('Content-Type') && response.headers.get('Content-Type').toLocaleLowerCase().includes('application/json'))) {
                            _context.next = 11;
                            break;
                          }
                          _context.prev = 3;
                          _context.next = 6;
                          return clone.json();
                        case 6:
                          response.data = _context.sent;
                          _context.next = 11;
                          break;
                        case 9:
                          _context.prev = 9;
                          _context.t0 = _context["catch"](3);
                        case 11:
                          if (!response.ok) {
                            _context.next = 13;
                            break;
                          }
                          return _context.abrupt("return", response);
                        case 13:
                          message = response.data.message || null;
                          if (message) {
                            toast$1.error(message);
                            window.modal.close();
                          }
                          throw new ApiError(response, message || response.statusText);
                        case 16:
                        case "end":
                          return _context.stop();
                      }
                    }, _callee, null, [[3, 9]]);
                  }));
                  return function (_x) {
                    return _ref.apply(this, arguments);
                  };
                }()));
              case 12:
              case "end":
                return _context2.stop();
            }
          }, _callee2, this);
        }));
        function request() {
          return _request.apply(this, arguments);
        }
        return request;
      }()
      /**
       * Makes a GET request using the Fetch API.
       *
       * @param {string|URL} url - The URL to send the request to.
       * @param {Record<string, string>} [params={}] - Query parameter key-value pairs to be appended to the URL.
       * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
       * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
       */
    }, {
      key: "get",
      value: function get(url) {
        var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.request('GET', url, _objectSpread2(_objectSpread2({}, options), {}, {
          params: params
        }));
      }

      /**
       * Makes a POST request using the Fetch API.
       *
       * @param {string|URL} url - The URL to send the request to.
       * @param {Record<string, any>|FormData|URLSearchParams} [body={}] - The body of the request.
       * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
       * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
       */
    }, {
      key: "post",
      value: function post(url) {
        var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.request('POST', url, _objectSpread2(_objectSpread2({}, options), {}, {
          body: body
        }));
      }

      /**
       * Makes a PUT request using the Fetch API.
       *
       * @param {string|URL} url - The URL to send the request to.
       * @param {Record<string, any>|FormData|URLSearchParams} [body={}] - The body of the request.
       * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
       * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
       */
    }, {
      key: "put",
      value: function put(url) {
        var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
        return this.request('PUT', url, _objectSpread2(_objectSpread2({}, options), {}, {
          body: body
        }));
      }

      /**
       * Makes a DELETE request using the Fetch API.
       *
       * @param {string|URL} url - The URL to send the request to.
       * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
       * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
       */
    }, {
      key: "remove",
      value: function remove(url, options) {
        return this.request('DELETE', url, options);
      }

      /**
      * Makes a DELETE request using the Fetch API.
      *
      * @param {string|URL} url - The URL to send the request to.
      * @param {RequestInit & FetchOptions} [options={}] - Additional options for the request.
      * @returns {Promise<ExtendedResponse>} A Promise that resolves to the Response object representing the response to the request.
      */
    }, {
      key: "delete",
      value: function _delete(url, options) {
        return this.remove(url, options);
      }
    }]);
    return Api;
  }();

  var api = new Api();
  api.base = '/api';

  function getCategoryList() {
    var categories = [];
    var fetchedAll = false;
    function getList() {
      return _getList.apply(this, arguments);
    }
    function _getList() {
      _getList = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var cursor,
          params,
          response,
          content,
          _args = arguments;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              cursor = _args.length > 0 && _args[0] !== undefined ? _args[0] : null;
              params = {};
              if (cursor) {
                params.starting_after = cursor;
              }
              _context.next = 5;
              return api.get('/categories', params);
            case 5:
              response = _context.sent;
              _context.next = 8;
              return response.json();
            case 8:
              content = _context.sent;
              if (!(content.data.length == 0)) {
                _context.next = 12;
                break;
              }
              fetchedAll = true;
              return _context.abrupt("return");
            case 12:
              categories.push.apply(categories, _toConsumableArray(content.data));
              if (!fetchedAll) {
                getList(categories[categories.length - 1].id);
              }
              return _context.abrupt("return", categories);
            case 15:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return _getList.apply(this, arguments);
    }
    return getList();
  }
  function getPlanList() {
    var plans = [];
    var fetchedAll = false;
    function getList() {
      return _getList2.apply(this, arguments);
    }
    function _getList2() {
      _getList2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var cursor,
          params,
          response,
          content,
          _args2 = arguments;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              cursor = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : null;
              params = {
                'sort': 'price:asc'
              };
              if (cursor) {
                params.starting_after = cursor;
              }
              _context2.next = 5;
              return api.get('/billing/plans', params);
            case 5:
              response = _context2.sent;
              _context2.next = 8;
              return response.json();
            case 8:
              content = _context2.sent;
              if (!(content.data.length == 0)) {
                _context2.next = 12;
                break;
              }
              fetchedAll = true;
              return _context2.abrupt("return");
            case 12:
              plans.push.apply(plans, _toConsumableArray(content.data));
              if (!fetchedAll) {
                getList(plans[plans.length - 1].id);
              }
              return _context2.abrupt("return", plans);
            case 15:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      return _getList2.apply(this, arguments);
    }
    return getList();
  }

  function listView() {
    module_default$1.data('lc', function () {
      var filters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var sort = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return {
        filters: filters,
        sort: sort,
        orderby: null,
        dir: null,
        params: {
          query: null,
          sort: null
        },
        // total: null,
        init: function init() {
          var _this = this;
          this.filters.forEach(function (filter) {
            return _this.params[filter.model] = null;
          });
          this.getCategories();
          this.getPlans();
          var sortparams = ['orderby', 'dir'];
          sortparams.forEach(function (param) {
            _this.$watch(param, function () {
              _this.params.sort = null;
              if (_this.orderby) {
                _this.params.sort = _this.orderby;
                if (_this.dir) {
                  _this.params.sort += ":".concat(_this.dir);
                }
              }
            });
          });
          this.$watch('params', function (params) {
            _this.$dispatch('lc.filtered', params);
            _this.updateUrl();
          });
          this.parseUrl();
          window.addEventListener('lc.reset', function () {
            return _this.resetFilters();
          });
        },
        resetFilters: function resetFilters() {
          for (var key in this.params) {
            if (key != 'sort') {
              this.params[key] = null;
            }
          }
        },
        getCategories: function getCategories() {
          var _this2 = this;
          var filter = this.filters.find(function (filter) {
            return filter.model == 'category';
          });
          if (!filter) {
            return;
          }
          getCategoryList().then(function (categories) {
            categories.forEach(function (category) {
              filter.options.push({
                value: category.id,
                label: category.title
              });
              _this2.parseUrl();
            });
          });
        },
        getPlans: function getPlans() {
          var _this3 = this;
          var filter = this.filters.find(function (filter) {
            return filter.model == 'plan';
          });
          if (!filter) {
            return;
          }
          var cycles = filter.billing_cycle || [];
          getPlanList().then(function (plans) {
            plans.forEach(function (plan) {
              if (cycles.length == 0 || cycles.includes(plan.billing_cycle)) {
                filter.options.push({
                  value: plan.id,
                  label: plan.title + ' / ' + plan.billing_cycle
                });
              }
            });
            _this3.parseUrl();
          });
        },
        parseUrl: function parseUrl() {
          var _this4 = this;
          var url = new URL(window.location.href);
          var params = new URLSearchParams(url.search.slice(1));
          var _loop = function _loop(key) {
            var _filter$options;
            if (!params.has(key)) {
              return "continue";
            }
            var filter = _this4.filters.find(function (f) {
              return f.model == key;
            });
            if (!filter) {
              return "continue";
            }
            var option = (_filter$options = filter.options) === null || _filter$options === void 0 ? void 0 : _filter$options.find(function (o) {
              return o.value == params.get(key);
            });
            if (!option && !filter.hidden) {
              return "continue";
            }
            _this4.params[key] = params.get(key);
          };
          for (var key in this.params) {
            var _ret = _loop(key);
            if (_ret === "continue") continue;
          }
          if (this.params.sort) {
            var _sort = this.params.sort.split(':');
            this.orderby = _sort[0];
            this.dir = _sort[1] || 'asc';
          }
        },
        updateUrl: function updateUrl() {
          var url = new URL(window.location.href);
          var params = new URLSearchParams(url.search.slice(1));
          for (var key in this.params) {
            if (this.params[key]) {
              params.set(key, this.params[key]);
            } else {
              params["delete"](key);
            }
          }
          window.history.pushState({}, '', "".concat(url.origin).concat(url.pathname, "?").concat(params));
        }
      };
    });
    module_default$1.data('list', function (basePath) {
      var strings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return {
        state: 'initial',
        params: {},
        total: null,
        cursor: null,
        resources: [],
        isLoading: false,
        hasMore: true,
        isFiltered: false,
        currentResource: null,
        isDeleting: false,
        init: function init() {
          var _this5 = this;
          this.loadMore();
          this.getTotalCount();
          var timer = null;
          timer = setTimeout(function () {
            return _this5.retrieveResources();
          }, 200);
          window.addEventListener('lc.filtered', function (e) {
            clearTimeout(timer);
            timer = setTimeout(function () {
              _this5.params = e.detail;
              _this5.retrieveResources(true);
            }, 200);
          });
        },
        getTotalCount: function getTotalCount() {
          var _this6 = this;
          api.get("".concat(basePath, "/count")).then(function (response) {
            return response.json();
          }).then(function (response) {
            return _this6.total = response.count;
          });
        },
        retrieveResources: function retrieveResources() {
          var _this7 = this;
          var reset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
          this.isLoading = true;
          var params = {};
          var isFiltered = false;
          for (var key in this.params) {
            if (this.params[key]) {
              if (key != 'sort') {
                isFiltered = true;
              }
              params[key] = this.params[key];
            }
          }
          this.isFiltered = isFiltered;
          if (!reset && this.cursor) {
            params.starting_after = this.cursor;
          }
          api.get(basePath, params).then(function (response) {
            return response.json();
          }).then(function (list) {
            _this7.state = 'loaded';
            _this7.resources = reset ? list.data : _this7.resources.concat(list.data);
            if (_this7.resources.length > 0) {
              _this7.cursor = _this7.resources[_this7.resources.length - 1].id;
            } else {
              _this7.state = 'empty';
            }
            _this7.isLoading = false;
            _this7.hasMore = list.data.length >= 25;
          });
        },
        loadMore: function loadMore() {
          var _this8 = this;
          window.addEventListener('scroll', function () {
            if (_this8.hasMore && !_this8.isLoading && window.innerHeight + window.scrollY + 500 >= document.documentElement.scrollHeight) {
              _this8.retrieveResources();
            }
          });
        },
        toggleStatus: function toggleStatus(resource) {
          resource.status = resource.status == 1 ? 0 : 1;
          api.post("".concat(basePath, "/").concat(resource.id), {
            status: resource.status
          });
        },
        deleteResource: function deleteResource(resource) {
          var _this9 = this;
          this.isDeleting = true;
          api["delete"]("".concat(basePath, "/").concat(resource.id)).then(function () {
            _this9.resources.splice(_this9.resources.indexOf(resource), 1);
            window.modal.close();
            _this9.currentResource = null;
            toast$1.show(strings.delete_success, 'ti ti-trash');
            _this9.isDeleting = false;
          })["catch"](function (error) {
            _this9.isDeleting = false;
          });
        }
      };
    });
  }

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  /* eslint-disable no-multi-assign */
  function deepFreeze(obj) {
    if (obj instanceof Map) {
      obj.clear = obj.delete = obj.set = function () {
        throw new Error('map is read-only');
      };
    } else if (obj instanceof Set) {
      obj.add = obj.clear = obj.delete = function () {
        throw new Error('set is read-only');
      };
    }

    // Freeze self
    Object.freeze(obj);
    Object.getOwnPropertyNames(obj).forEach(name => {
      const prop = obj[name];
      const type = typeof prop;

      // Freeze prop if it is an object or function and also not already frozen
      if ((type === 'object' || type === 'function') && !Object.isFrozen(prop)) {
        deepFreeze(prop);
      }
    });
    return obj;
  }

  /** @typedef {import('highlight.js').CallbackResponse} CallbackResponse */
  /** @typedef {import('highlight.js').CompiledMode} CompiledMode */
  /** @implements CallbackResponse */

  class Response {
    /**
     * @param {CompiledMode} mode
     */
    constructor(mode) {
      // eslint-disable-next-line no-undefined
      if (mode.data === undefined) mode.data = {};
      this.data = mode.data;
      this.isMatchIgnored = false;
    }
    ignoreMatch() {
      this.isMatchIgnored = true;
    }
  }

  /**
   * @param {string} value
   * @returns {string}
   */
  function escapeHTML(value) {
    return value.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#x27;');
  }

  /**
   * performs a shallow merge of multiple objects into one
   *
   * @template T
   * @param {T} original
   * @param {Record<string,any>[]} objects
   * @returns {T} a single new object
   */
  function inherit$1(original, ...objects) {
    /** @type Record<string,any> */
    const result = Object.create(null);
    for (const key in original) {
      result[key] = original[key];
    }
    objects.forEach(function (obj) {
      for (const key in obj) {
        result[key] = obj[key];
      }
    });
    return (/** @type {T} */result
    );
  }

  /**
   * @typedef {object} Renderer
   * @property {(text: string) => void} addText
   * @property {(node: Node) => void} openNode
   * @property {(node: Node) => void} closeNode
   * @property {() => string} value
   */

  /** @typedef {{scope?: string, language?: string, sublanguage?: boolean}} Node */
  /** @typedef {{walk: (r: Renderer) => void}} Tree */
  /** */

  const SPAN_CLOSE = '</span>';

  /**
   * Determines if a node needs to be wrapped in <span>
   *
   * @param {Node} node */
  const emitsWrappingTags = node => {
    // rarely we can have a sublanguage where language is undefined
    // TODO: track down why
    return !!node.scope;
  };

  /**
   *
   * @param {string} name
   * @param {{prefix:string}} options
   */
  const scopeToCSSClass = (name, {
    prefix
  }) => {
    // sub-language
    if (name.startsWith("language:")) {
      return name.replace("language:", "language-");
    }
    // tiered scope: comment.line
    if (name.includes(".")) {
      const pieces = name.split(".");
      return [`${prefix}${pieces.shift()}`, ...pieces.map((x, i) => `${x}${"_".repeat(i + 1)}`)].join(" ");
    }
    // simple scope
    return `${prefix}${name}`;
  };

  /** @type {Renderer} */
  class HTMLRenderer {
    /**
     * Creates a new HTMLRenderer
     *
     * @param {Tree} parseTree - the parse tree (must support `walk` API)
     * @param {{classPrefix: string}} options
     */
    constructor(parseTree, options) {
      this.buffer = "";
      this.classPrefix = options.classPrefix;
      parseTree.walk(this);
    }

    /**
     * Adds texts to the output stream
     *
     * @param {string} text */
    addText(text) {
      this.buffer += escapeHTML(text);
    }

    /**
     * Adds a node open to the output stream (if needed)
     *
     * @param {Node} node */
    openNode(node) {
      if (!emitsWrappingTags(node)) return;
      const className = scopeToCSSClass(node.scope, {
        prefix: this.classPrefix
      });
      this.span(className);
    }

    /**
     * Adds a node close to the output stream (if needed)
     *
     * @param {Node} node */
    closeNode(node) {
      if (!emitsWrappingTags(node)) return;
      this.buffer += SPAN_CLOSE;
    }

    /**
     * returns the accumulated buffer
    */
    value() {
      return this.buffer;
    }

    // helpers

    /**
     * Builds a span element
     *
     * @param {string} className */
    span(className) {
      this.buffer += `<span class="${className}">`;
    }
  }

  /** @typedef {{scope?: string, language?: string, sublanguage?: boolean, children: Node[]} | string} Node */
  /** @typedef {{scope?: string, language?: string, sublanguage?: boolean, children: Node[]} } DataNode */
  /** @typedef {import('highlight.js').Emitter} Emitter */
  /**  */

  /** @returns {DataNode} */
  const newNode = (opts = {}) => {
    /** @type DataNode */
    const result = {
      children: []
    };
    Object.assign(result, opts);
    return result;
  };
  class TokenTree {
    constructor() {
      /** @type DataNode */
      this.rootNode = newNode();
      this.stack = [this.rootNode];
    }
    get top() {
      return this.stack[this.stack.length - 1];
    }
    get root() {
      return this.rootNode;
    }

    /** @param {Node} node */
    add(node) {
      this.top.children.push(node);
    }

    /** @param {string} scope */
    openNode(scope) {
      /** @type Node */
      const node = newNode({
        scope
      });
      this.add(node);
      this.stack.push(node);
    }
    closeNode() {
      if (this.stack.length > 1) {
        return this.stack.pop();
      }
      // eslint-disable-next-line no-undefined
      return undefined;
    }
    closeAllNodes() {
      while (this.closeNode());
    }
    toJSON() {
      return JSON.stringify(this.rootNode, null, 4);
    }

    /**
     * @typedef { import("./html_renderer").Renderer } Renderer
     * @param {Renderer} builder
     */
    walk(builder) {
      // this does not
      return this.constructor._walk(builder, this.rootNode);
      // this works
      // return TokenTree._walk(builder, this.rootNode);
    }

    /**
     * @param {Renderer} builder
     * @param {Node} node
     */
    static _walk(builder, node) {
      if (typeof node === "string") {
        builder.addText(node);
      } else if (node.children) {
        builder.openNode(node);
        node.children.forEach(child => this._walk(builder, child));
        builder.closeNode(node);
      }
      return builder;
    }

    /**
     * @param {Node} node
     */
    static _collapse(node) {
      if (typeof node === "string") return;
      if (!node.children) return;
      if (node.children.every(el => typeof el === "string")) {
        // node.text = node.children.join("");
        // delete node.children;
        node.children = [node.children.join("")];
      } else {
        node.children.forEach(child => {
          TokenTree._collapse(child);
        });
      }
    }
  }

  /**
    Currently this is all private API, but this is the minimal API necessary
    that an Emitter must implement to fully support the parser.

    Minimal interface:

    - addText(text)
    - __addSublanguage(emitter, subLanguageName)
    - startScope(scope)
    - endScope()
    - finalize()
    - toHTML()

  */

  /**
   * @implements {Emitter}
   */
  class TokenTreeEmitter extends TokenTree {
    /**
     * @param {*} options
     */
    constructor(options) {
      super();
      this.options = options;
    }

    /**
     * @param {string} text
     */
    addText(text) {
      if (text === "") {
        return;
      }
      this.add(text);
    }

    /** @param {string} scope */
    startScope(scope) {
      this.openNode(scope);
    }
    endScope() {
      this.closeNode();
    }

    /**
     * @param {Emitter & {root: DataNode}} emitter
     * @param {string} name
     */
    __addSublanguage(emitter, name) {
      /** @type DataNode */
      const node = emitter.root;
      if (name) node.scope = `language:${name}`;
      this.add(node);
    }
    toHTML() {
      const renderer = new HTMLRenderer(this, this.options);
      return renderer.value();
    }
    finalize() {
      this.closeAllNodes();
      return true;
    }
  }

  /**
   * @param {string} value
   * @returns {RegExp}
   * */

  /**
   * @param {RegExp | string } re
   * @returns {string}
   */
  function source(re) {
    if (!re) return null;
    if (typeof re === "string") return re;
    return re.source;
  }

  /**
   * @param {RegExp | string } re
   * @returns {string}
   */
  function lookahead(re) {
    return concat('(?=', re, ')');
  }

  /**
   * @param {RegExp | string } re
   * @returns {string}
   */
  function anyNumberOfTimes(re) {
    return concat('(?:', re, ')*');
  }

  /**
   * @param {RegExp | string } re
   * @returns {string}
   */
  function optional(re) {
    return concat('(?:', re, ')?');
  }

  /**
   * @param {...(RegExp | string) } args
   * @returns {string}
   */
  function concat(...args) {
    const joined = args.map(x => source(x)).join("");
    return joined;
  }

  /**
   * @param { Array<string | RegExp | Object> } args
   * @returns {object}
   */
  function stripOptionsFromArgs(args) {
    const opts = args[args.length - 1];
    if (typeof opts === 'object' && opts.constructor === Object) {
      args.splice(args.length - 1, 1);
      return opts;
    } else {
      return {};
    }
  }

  /** @typedef { {capture?: boolean} } RegexEitherOptions */

  /**
   * Any of the passed expresssions may match
   *
   * Creates a huge this | this | that | that match
   * @param {(RegExp | string)[] | [...(RegExp | string)[], RegexEitherOptions]} args
   * @returns {string}
   */
  function either(...args) {
    /** @type { object & {capture?: boolean} }  */
    const opts = stripOptionsFromArgs(args);
    const joined = '(' + (opts.capture ? "" : "?:") + args.map(x => source(x)).join("|") + ")";
    return joined;
  }

  /**
   * @param {RegExp | string} re
   * @returns {number}
   */
  function countMatchGroups(re) {
    return new RegExp(re.toString() + '|').exec('').length - 1;
  }

  /**
   * Does lexeme start with a regular expression match at the beginning
   * @param {RegExp} re
   * @param {string} lexeme
   */
  function startsWith(re, lexeme) {
    const match = re && re.exec(lexeme);
    return match && match.index === 0;
  }

  // BACKREF_RE matches an open parenthesis or backreference. To avoid
  // an incorrect parse, it additionally matches the following:
  // - [...] elements, where the meaning of parentheses and escapes change
  // - other escape sequences, so we do not misparse escape sequences as
  //   interesting elements
  // - non-matching or lookahead parentheses, which do not capture. These
  //   follow the '(' with a '?'.
  const BACKREF_RE = /\[(?:[^\\\]]|\\.)*\]|\(\??|\\([1-9][0-9]*)|\\./;

  // **INTERNAL** Not intended for outside usage
  // join logically computes regexps.join(separator), but fixes the
  // backreferences so they continue to match.
  // it also places each individual regular expression into it's own
  // match group, keeping track of the sequencing of those match groups
  // is currently an exercise for the caller. :-)
  /**
   * @param {(string | RegExp)[]} regexps
   * @param {{joinWith: string}} opts
   * @returns {string}
   */
  function _rewriteBackreferences(regexps, {
    joinWith
  }) {
    let numCaptures = 0;
    return regexps.map(regex => {
      numCaptures += 1;
      const offset = numCaptures;
      let re = source(regex);
      let out = '';
      while (re.length > 0) {
        const match = BACKREF_RE.exec(re);
        if (!match) {
          out += re;
          break;
        }
        out += re.substring(0, match.index);
        re = re.substring(match.index + match[0].length);
        if (match[0][0] === '\\' && match[1]) {
          // Adjust the backreference.
          out += '\\' + String(Number(match[1]) + offset);
        } else {
          out += match[0];
          if (match[0] === '(') {
            numCaptures++;
          }
        }
      }
      return out;
    }).map(re => `(${re})`).join(joinWith);
  }

  /** @typedef {import('highlight.js').Mode} Mode */
  /** @typedef {import('highlight.js').ModeCallback} ModeCallback */

  // Common regexps
  const MATCH_NOTHING_RE = /\b\B/;
  const IDENT_RE = '[a-zA-Z]\\w*';
  const UNDERSCORE_IDENT_RE = '[a-zA-Z_]\\w*';
  const NUMBER_RE = '\\b\\d+(\\.\\d+)?';
  const C_NUMBER_RE = '(-?)(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)'; // 0x..., 0..., decimal, float
  const BINARY_NUMBER_RE = '\\b(0b[01]+)'; // 0b...
  const RE_STARTERS_RE = '!|!=|!==|%|%=|&|&&|&=|\\*|\\*=|\\+|\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\?|\\[|\\{|\\(|\\^|\\^=|\\||\\|=|\\|\\||~';

  /**
  * @param { Partial<Mode> & {binary?: string | RegExp} } opts
  */
  const SHEBANG = (opts = {}) => {
    const beginShebang = /^#![ ]*\//;
    if (opts.binary) {
      opts.begin = concat(beginShebang, /.*\b/, opts.binary, /\b.*/);
    }
    return inherit$1({
      scope: 'meta',
      begin: beginShebang,
      end: /$/,
      relevance: 0,
      /** @type {ModeCallback} */
      "on:begin": (m, resp) => {
        if (m.index !== 0) resp.ignoreMatch();
      }
    }, opts);
  };

  // Common modes
  const BACKSLASH_ESCAPE = {
    begin: '\\\\[\\s\\S]',
    relevance: 0
  };
  const APOS_STRING_MODE = {
    scope: 'string',
    begin: '\'',
    end: '\'',
    illegal: '\\n',
    contains: [BACKSLASH_ESCAPE]
  };
  const QUOTE_STRING_MODE = {
    scope: 'string',
    begin: '"',
    end: '"',
    illegal: '\\n',
    contains: [BACKSLASH_ESCAPE]
  };
  const PHRASAL_WORDS_MODE = {
    begin: /\b(a|an|the|are|I'm|isn't|don't|doesn't|won't|but|just|should|pretty|simply|enough|gonna|going|wtf|so|such|will|you|your|they|like|more)\b/
  };
  /**
   * Creates a comment mode
   *
   * @param {string | RegExp} begin
   * @param {string | RegExp} end
   * @param {Mode | {}} [modeOptions]
   * @returns {Partial<Mode>}
   */
  const COMMENT = function (begin, end, modeOptions = {}) {
    const mode = inherit$1({
      scope: 'comment',
      begin,
      end,
      contains: []
    }, modeOptions);
    mode.contains.push({
      scope: 'doctag',
      // hack to avoid the space from being included. the space is necessary to
      // match here to prevent the plain text rule below from gobbling up doctags
      begin: '[ ]*(?=(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):)',
      end: /(TODO|FIXME|NOTE|BUG|OPTIMIZE|HACK|XXX):/,
      excludeBegin: true,
      relevance: 0
    });
    const ENGLISH_WORD = either(
    // list of common 1 and 2 letter words in English
    "I", "a", "is", "so", "us", "to", "at", "if", "in", "it", "on",
    // note: this is not an exhaustive list of contractions, just popular ones
    /[A-Za-z]+['](d|ve|re|ll|t|s|n)/,
    // contractions - can't we'd they're let's, etc
    /[A-Za-z]+[-][a-z]+/,
    // `no-way`, etc.
    /[A-Za-z][a-z]{2,}/ // allow capitalized words at beginning of sentences
    );
    // looking like plain text, more likely to be a comment
    mode.contains.push({
      // TODO: how to include ", (, ) without breaking grammars that use these for
      // comment delimiters?
      // begin: /[ ]+([()"]?([A-Za-z'-]{3,}|is|a|I|so|us|[tT][oO]|at|if|in|it|on)[.]?[()":]?([.][ ]|[ ]|\))){3}/
      // ---

      // this tries to find sequences of 3 english words in a row (without any
      // "programming" type syntax) this gives us a strong signal that we've
      // TRULY found a comment - vs perhaps scanning with the wrong language.
      // It's possible to find something that LOOKS like the start of the
      // comment - but then if there is no readable text - good chance it is a
      // false match and not a comment.
      //
      // for a visual example please see:
      // https://github.com/highlightjs/highlight.js/issues/2827

      begin: concat(/[ ]+/,
      // necessary to prevent us gobbling up doctags like /* @author Bob Mcgill */
      '(', ENGLISH_WORD, /[.]?[:]?([.][ ]|[ ])/, '){3}') // look for 3 words in a row
    });

    return mode;
  };
  const C_LINE_COMMENT_MODE = COMMENT('//', '$');
  const C_BLOCK_COMMENT_MODE = COMMENT('/\\*', '\\*/');
  const HASH_COMMENT_MODE = COMMENT('#', '$');
  const NUMBER_MODE = {
    scope: 'number',
    begin: NUMBER_RE,
    relevance: 0
  };
  const C_NUMBER_MODE = {
    scope: 'number',
    begin: C_NUMBER_RE,
    relevance: 0
  };
  const BINARY_NUMBER_MODE = {
    scope: 'number',
    begin: BINARY_NUMBER_RE,
    relevance: 0
  };
  const REGEXP_MODE = {
    // this outer rule makes sure we actually have a WHOLE regex and not simply
    // an expression such as:
    //
    //     3 / something
    //
    // (which will then blow up when regex's `illegal` sees the newline)
    begin: /(?=\/[^/\n]*\/)/,
    contains: [{
      scope: 'regexp',
      begin: /\//,
      end: /\/[gimuy]*/,
      illegal: /\n/,
      contains: [BACKSLASH_ESCAPE, {
        begin: /\[/,
        end: /\]/,
        relevance: 0,
        contains: [BACKSLASH_ESCAPE]
      }]
    }]
  };
  const TITLE_MODE = {
    scope: 'title',
    begin: IDENT_RE,
    relevance: 0
  };
  const UNDERSCORE_TITLE_MODE = {
    scope: 'title',
    begin: UNDERSCORE_IDENT_RE,
    relevance: 0
  };
  const METHOD_GUARD = {
    // excludes method names from keyword processing
    begin: '\\.\\s*' + UNDERSCORE_IDENT_RE,
    relevance: 0
  };

  /**
   * Adds end same as begin mechanics to a mode
   *
   * Your mode must include at least a single () match group as that first match
   * group is what is used for comparison
   * @param {Partial<Mode>} mode
   */
  const END_SAME_AS_BEGIN = function (mode) {
    return Object.assign(mode, {
      /** @type {ModeCallback} */
      'on:begin': (m, resp) => {
        resp.data._beginMatch = m[1];
      },
      /** @type {ModeCallback} */
      'on:end': (m, resp) => {
        if (resp.data._beginMatch !== m[1]) resp.ignoreMatch();
      }
    });
  };
  var MODES = /*#__PURE__*/Object.freeze({
    __proto__: null,
    MATCH_NOTHING_RE: MATCH_NOTHING_RE,
    IDENT_RE: IDENT_RE,
    UNDERSCORE_IDENT_RE: UNDERSCORE_IDENT_RE,
    NUMBER_RE: NUMBER_RE,
    C_NUMBER_RE: C_NUMBER_RE,
    BINARY_NUMBER_RE: BINARY_NUMBER_RE,
    RE_STARTERS_RE: RE_STARTERS_RE,
    SHEBANG: SHEBANG,
    BACKSLASH_ESCAPE: BACKSLASH_ESCAPE,
    APOS_STRING_MODE: APOS_STRING_MODE,
    QUOTE_STRING_MODE: QUOTE_STRING_MODE,
    PHRASAL_WORDS_MODE: PHRASAL_WORDS_MODE,
    COMMENT: COMMENT,
    C_LINE_COMMENT_MODE: C_LINE_COMMENT_MODE,
    C_BLOCK_COMMENT_MODE: C_BLOCK_COMMENT_MODE,
    HASH_COMMENT_MODE: HASH_COMMENT_MODE,
    NUMBER_MODE: NUMBER_MODE,
    C_NUMBER_MODE: C_NUMBER_MODE,
    BINARY_NUMBER_MODE: BINARY_NUMBER_MODE,
    REGEXP_MODE: REGEXP_MODE,
    TITLE_MODE: TITLE_MODE,
    UNDERSCORE_TITLE_MODE: UNDERSCORE_TITLE_MODE,
    METHOD_GUARD: METHOD_GUARD,
    END_SAME_AS_BEGIN: END_SAME_AS_BEGIN
  });

  /**
  @typedef {import('highlight.js').CallbackResponse} CallbackResponse
  @typedef {import('highlight.js').CompilerExt} CompilerExt
  */

  // Grammar extensions / plugins
  // See: https://github.com/highlightjs/highlight.js/issues/2833

  // Grammar extensions allow "syntactic sugar" to be added to the grammar modes
  // without requiring any underlying changes to the compiler internals.

  // `compileMatch` being the perfect small example of now allowing a grammar
  // author to write `match` when they desire to match a single expression rather
  // than being forced to use `begin`.  The extension then just moves `match` into
  // `begin` when it runs.  Ie, no features have been added, but we've just made
  // the experience of writing (and reading grammars) a little bit nicer.

  // ------

  // TODO: We need negative look-behind support to do this properly
  /**
   * Skip a match if it has a preceding dot
   *
   * This is used for `beginKeywords` to prevent matching expressions such as
   * `bob.keyword.do()`. The mode compiler automatically wires this up as a
   * special _internal_ 'on:begin' callback for modes with `beginKeywords`
   * @param {RegExpMatchArray} match
   * @param {CallbackResponse} response
   */
  function skipIfHasPrecedingDot(match, response) {
    const before = match.input[match.index - 1];
    if (before === ".") {
      response.ignoreMatch();
    }
  }

  /**
   *
   * @type {CompilerExt}
   */
  function scopeClassName(mode, _parent) {
    // eslint-disable-next-line no-undefined
    if (mode.className !== undefined) {
      mode.scope = mode.className;
      delete mode.className;
    }
  }

  /**
   * `beginKeywords` syntactic sugar
   * @type {CompilerExt}
   */
  function beginKeywords(mode, parent) {
    if (!parent) return;
    if (!mode.beginKeywords) return;

    // for languages with keywords that include non-word characters checking for
    // a word boundary is not sufficient, so instead we check for a word boundary
    // or whitespace - this does no harm in any case since our keyword engine
    // doesn't allow spaces in keywords anyways and we still check for the boundary
    // first
    mode.begin = '\\b(' + mode.beginKeywords.split(' ').join('|') + ')(?!\\.)(?=\\b|\\s)';
    mode.__beforeBegin = skipIfHasPrecedingDot;
    mode.keywords = mode.keywords || mode.beginKeywords;
    delete mode.beginKeywords;

    // prevents double relevance, the keywords themselves provide
    // relevance, the mode doesn't need to double it
    // eslint-disable-next-line no-undefined
    if (mode.relevance === undefined) mode.relevance = 0;
  }

  /**
   * Allow `illegal` to contain an array of illegal values
   * @type {CompilerExt}
   */
  function compileIllegal(mode, _parent) {
    if (!Array.isArray(mode.illegal)) return;
    mode.illegal = either(...mode.illegal);
  }

  /**
   * `match` to match a single expression for readability
   * @type {CompilerExt}
   */
  function compileMatch(mode, _parent) {
    if (!mode.match) return;
    if (mode.begin || mode.end) throw new Error("begin & end are not supported with match");
    mode.begin = mode.match;
    delete mode.match;
  }

  /**
   * provides the default 1 relevance to all modes
   * @type {CompilerExt}
   */
  function compileRelevance(mode, _parent) {
    // eslint-disable-next-line no-undefined
    if (mode.relevance === undefined) mode.relevance = 1;
  }

  // allow beforeMatch to act as a "qualifier" for the match
  // the full match begin must be [beforeMatch][begin]
  const beforeMatchExt = (mode, parent) => {
    if (!mode.beforeMatch) return;
    // starts conflicts with endsParent which we need to make sure the child
    // rule is not matched multiple times
    if (mode.starts) throw new Error("beforeMatch cannot be used with starts");
    const originalMode = Object.assign({}, mode);
    Object.keys(mode).forEach(key => {
      delete mode[key];
    });
    mode.keywords = originalMode.keywords;
    mode.begin = concat(originalMode.beforeMatch, lookahead(originalMode.begin));
    mode.starts = {
      relevance: 0,
      contains: [Object.assign(originalMode, {
        endsParent: true
      })]
    };
    mode.relevance = 0;
    delete originalMode.beforeMatch;
  };

  // keywords that should have no default relevance value
  const COMMON_KEYWORDS = ['of', 'and', 'for', 'in', 'not', 'or', 'if', 'then', 'parent',
  // common variable name
  'list',
  // common variable name
  'value' // common variable name
  ];

  const DEFAULT_KEYWORD_SCOPE = "keyword";

  /**
   * Given raw keywords from a language definition, compile them.
   *
   * @param {string | Record<string,string|string[]> | Array<string>} rawKeywords
   * @param {boolean} caseInsensitive
   */
  function compileKeywords(rawKeywords, caseInsensitive, scopeName = DEFAULT_KEYWORD_SCOPE) {
    /** @type {import("highlight.js/private").KeywordDict} */
    const compiledKeywords = Object.create(null);

    // input can be a string of keywords, an array of keywords, or a object with
    // named keys representing scopeName (which can then point to a string or array)
    if (typeof rawKeywords === 'string') {
      compileList(scopeName, rawKeywords.split(" "));
    } else if (Array.isArray(rawKeywords)) {
      compileList(scopeName, rawKeywords);
    } else {
      Object.keys(rawKeywords).forEach(function (scopeName) {
        // collapse all our objects back into the parent object
        Object.assign(compiledKeywords, compileKeywords(rawKeywords[scopeName], caseInsensitive, scopeName));
      });
    }
    return compiledKeywords;

    // ---

    /**
     * Compiles an individual list of keywords
     *
     * Ex: "for if when while|5"
     *
     * @param {string} scopeName
     * @param {Array<string>} keywordList
     */
    function compileList(scopeName, keywordList) {
      if (caseInsensitive) {
        keywordList = keywordList.map(x => x.toLowerCase());
      }
      keywordList.forEach(function (keyword) {
        const pair = keyword.split('|');
        compiledKeywords[pair[0]] = [scopeName, scoreForKeyword(pair[0], pair[1])];
      });
    }
  }

  /**
   * Returns the proper score for a given keyword
   *
   * Also takes into account comment keywords, which will be scored 0 UNLESS
   * another score has been manually assigned.
   * @param {string} keyword
   * @param {string} [providedScore]
   */
  function scoreForKeyword(keyword, providedScore) {
    // manual scores always win over common keywords
    // so you can force a score of 1 if you really insist
    if (providedScore) {
      return Number(providedScore);
    }
    return commonKeyword(keyword) ? 0 : 1;
  }

  /**
   * Determines if a given keyword is common or not
   *
   * @param {string} keyword */
  function commonKeyword(keyword) {
    return COMMON_KEYWORDS.includes(keyword.toLowerCase());
  }

  /*

  For the reasoning behind this please see:
  https://github.com/highlightjs/highlight.js/issues/2880#issuecomment-747275419

  */

  /**
   * @type {Record<string, boolean>}
   */
  const seenDeprecations = {};

  /**
   * @param {string} message
   */
  const error$1 = message => {
    console.error(message);
  };

  /**
   * @param {string} message
   * @param {any} args
   */
  const warn = (message, ...args) => {
    console.log(`WARN: ${message}`, ...args);
  };

  /**
   * @param {string} version
   * @param {string} message
   */
  const deprecated = (version, message) => {
    if (seenDeprecations[`${version}/${message}`]) return;
    console.log(`Deprecated as of ${version}. ${message}`);
    seenDeprecations[`${version}/${message}`] = true;
  };

  /* eslint-disable no-throw-literal */

  /**
  @typedef {import('highlight.js').CompiledMode} CompiledMode
  */

  const MultiClassError = new Error();

  /**
   * Renumbers labeled scope names to account for additional inner match
   * groups that otherwise would break everything.
   *
   * Lets say we 3 match scopes:
   *
   *   { 1 => ..., 2 => ..., 3 => ... }
   *
   * So what we need is a clean match like this:
   *
   *   (a)(b)(c) => [ "a", "b", "c" ]
   *
   * But this falls apart with inner match groups:
   *
   * (a)(((b)))(c) => ["a", "b", "b", "b", "c" ]
   *
   * Our scopes are now "out of alignment" and we're repeating `b` 3 times.
   * What needs to happen is the numbers are remapped:
   *
   *   { 1 => ..., 2 => ..., 5 => ... }
   *
   * We also need to know that the ONLY groups that should be output
   * are 1, 2, and 5.  This function handles this behavior.
   *
   * @param {CompiledMode} mode
   * @param {Array<RegExp | string>} regexes
   * @param {{key: "beginScope"|"endScope"}} opts
   */
  function remapScopeNames(mode, regexes, {
    key
  }) {
    let offset = 0;
    const scopeNames = mode[key];
    /** @type Record<number,boolean> */
    const emit = {};
    /** @type Record<number,string> */
    const positions = {};
    for (let i = 1; i <= regexes.length; i++) {
      positions[i + offset] = scopeNames[i];
      emit[i + offset] = true;
      offset += countMatchGroups(regexes[i - 1]);
    }
    // we use _emit to keep track of which match groups are "top-level" to avoid double
    // output from inside match groups
    mode[key] = positions;
    mode[key]._emit = emit;
    mode[key]._multi = true;
  }

  /**
   * @param {CompiledMode} mode
   */
  function beginMultiClass(mode) {
    if (!Array.isArray(mode.begin)) return;
    if (mode.skip || mode.excludeBegin || mode.returnBegin) {
      error$1("skip, excludeBegin, returnBegin not compatible with beginScope: {}");
      throw MultiClassError;
    }
    if (typeof mode.beginScope !== "object" || mode.beginScope === null) {
      error$1("beginScope must be object");
      throw MultiClassError;
    }
    remapScopeNames(mode, mode.begin, {
      key: "beginScope"
    });
    mode.begin = _rewriteBackreferences(mode.begin, {
      joinWith: ""
    });
  }

  /**
   * @param {CompiledMode} mode
   */
  function endMultiClass(mode) {
    if (!Array.isArray(mode.end)) return;
    if (mode.skip || mode.excludeEnd || mode.returnEnd) {
      error$1("skip, excludeEnd, returnEnd not compatible with endScope: {}");
      throw MultiClassError;
    }
    if (typeof mode.endScope !== "object" || mode.endScope === null) {
      error$1("endScope must be object");
      throw MultiClassError;
    }
    remapScopeNames(mode, mode.end, {
      key: "endScope"
    });
    mode.end = _rewriteBackreferences(mode.end, {
      joinWith: ""
    });
  }

  /**
   * this exists only to allow `scope: {}` to be used beside `match:`
   * Otherwise `beginScope` would necessary and that would look weird

    {
      match: [ /def/, /\w+/ ]
      scope: { 1: "keyword" , 2: "title" }
    }

   * @param {CompiledMode} mode
   */
  function scopeSugar(mode) {
    if (mode.scope && typeof mode.scope === "object" && mode.scope !== null) {
      mode.beginScope = mode.scope;
      delete mode.scope;
    }
  }

  /**
   * @param {CompiledMode} mode
   */
  function MultiClass(mode) {
    scopeSugar(mode);
    if (typeof mode.beginScope === "string") {
      mode.beginScope = {
        _wrap: mode.beginScope
      };
    }
    if (typeof mode.endScope === "string") {
      mode.endScope = {
        _wrap: mode.endScope
      };
    }
    beginMultiClass(mode);
    endMultiClass(mode);
  }

  /**
  @typedef {import('highlight.js').Mode} Mode
  @typedef {import('highlight.js').CompiledMode} CompiledMode
  @typedef {import('highlight.js').Language} Language
  @typedef {import('highlight.js').HLJSPlugin} HLJSPlugin
  @typedef {import('highlight.js').CompiledLanguage} CompiledLanguage
  */

  // compilation

  /**
   * Compiles a language definition result
   *
   * Given the raw result of a language definition (Language), compiles this so
   * that it is ready for highlighting code.
   * @param {Language} language
   * @returns {CompiledLanguage}
   */
  function compileLanguage(language) {
    /**
     * Builds a regex with the case sensitivity of the current language
     *
     * @param {RegExp | string} value
     * @param {boolean} [global]
     */
    function langRe(value, global) {
      return new RegExp(source(value), 'm' + (language.case_insensitive ? 'i' : '') + (language.unicodeRegex ? 'u' : '') + (global ? 'g' : ''));
    }

    /**
      Stores multiple regular expressions and allows you to quickly search for
      them all in a string simultaneously - returning the first match.  It does
      this by creating a huge (a|b|c) regex - each individual item wrapped with ()
      and joined by `|` - using match groups to track position.  When a match is
      found checking which position in the array has content allows us to figure
      out which of the original regexes / match groups triggered the match.
       The match object itself (the result of `Regex.exec`) is returned but also
      enhanced by merging in any meta-data that was registered with the regex.
      This is how we keep track of which mode matched, and what type of rule
      (`illegal`, `begin`, end, etc).
    */
    class MultiRegex {
      constructor() {
        this.matchIndexes = {};
        // @ts-ignore
        this.regexes = [];
        this.matchAt = 1;
        this.position = 0;
      }

      // @ts-ignore
      addRule(re, opts) {
        opts.position = this.position++;
        // @ts-ignore
        this.matchIndexes[this.matchAt] = opts;
        this.regexes.push([opts, re]);
        this.matchAt += countMatchGroups(re) + 1;
      }
      compile() {
        if (this.regexes.length === 0) {
          // avoids the need to check length every time exec is called
          // @ts-ignore
          this.exec = () => null;
        }
        const terminators = this.regexes.map(el => el[1]);
        this.matcherRe = langRe(_rewriteBackreferences(terminators, {
          joinWith: '|'
        }), true);
        this.lastIndex = 0;
      }

      /** @param {string} s */
      exec(s) {
        this.matcherRe.lastIndex = this.lastIndex;
        const match = this.matcherRe.exec(s);
        if (!match) {
          return null;
        }

        // eslint-disable-next-line no-undefined
        const i = match.findIndex((el, i) => i > 0 && el !== undefined);
        // @ts-ignore
        const matchData = this.matchIndexes[i];
        // trim off any earlier non-relevant match groups (ie, the other regex
        // match groups that make up the multi-matcher)
        match.splice(0, i);
        return Object.assign(match, matchData);
      }
    }

    /*
      Created to solve the key deficiently with MultiRegex - there is no way to
      test for multiple matches at a single location.  Why would we need to do
      that?  In the future a more dynamic engine will allow certain matches to be
      ignored.  An example: if we matched say the 3rd regex in a large group but
      decided to ignore it - we'd need to started testing again at the 4th
      regex... but MultiRegex itself gives us no real way to do that.
       So what this class creates MultiRegexs on the fly for whatever search
      position they are needed.
       NOTE: These additional MultiRegex objects are created dynamically.  For most
      grammars most of the time we will never actually need anything more than the
      first MultiRegex - so this shouldn't have too much overhead.
       Say this is our search group, and we match regex3, but wish to ignore it.
         regex1 | regex2 | regex3 | regex4 | regex5    ' ie, startAt = 0
       What we need is a new MultiRegex that only includes the remaining
      possibilities:
         regex4 | regex5                               ' ie, startAt = 3
       This class wraps all that complexity up in a simple API... `startAt` decides
      where in the array of expressions to start doing the matching. It
      auto-increments, so if a match is found at position 2, then startAt will be
      set to 3.  If the end is reached startAt will return to 0.
       MOST of the time the parser will be setting startAt manually to 0.
    */
    class ResumableMultiRegex {
      constructor() {
        // @ts-ignore
        this.rules = [];
        // @ts-ignore
        this.multiRegexes = [];
        this.count = 0;
        this.lastIndex = 0;
        this.regexIndex = 0;
      }

      // @ts-ignore
      getMatcher(index) {
        if (this.multiRegexes[index]) return this.multiRegexes[index];
        const matcher = new MultiRegex();
        this.rules.slice(index).forEach(([re, opts]) => matcher.addRule(re, opts));
        matcher.compile();
        this.multiRegexes[index] = matcher;
        return matcher;
      }
      resumingScanAtSamePosition() {
        return this.regexIndex !== 0;
      }
      considerAll() {
        this.regexIndex = 0;
      }

      // @ts-ignore
      addRule(re, opts) {
        this.rules.push([re, opts]);
        if (opts.type === "begin") this.count++;
      }

      /** @param {string} s */
      exec(s) {
        const m = this.getMatcher(this.regexIndex);
        m.lastIndex = this.lastIndex;
        let result = m.exec(s);

        // The following is because we have no easy way to say "resume scanning at the
        // existing position but also skip the current rule ONLY". What happens is
        // all prior rules are also skipped which can result in matching the wrong
        // thing. Example of matching "booger":

        // our matcher is [string, "booger", number]
        //
        // ....booger....

        // if "booger" is ignored then we'd really need a regex to scan from the
        // SAME position for only: [string, number] but ignoring "booger" (if it
        // was the first match), a simple resume would scan ahead who knows how
        // far looking only for "number", ignoring potential string matches (or
        // future "booger" matches that might be valid.)

        // So what we do: We execute two matchers, one resuming at the same
        // position, but the second full matcher starting at the position after:

        //     /--- resume first regex match here (for [number])
        //     |/---- full match here for [string, "booger", number]
        //     vv
        // ....booger....

        // Which ever results in a match first is then used. So this 3-4 step
        // process essentially allows us to say "match at this position, excluding
        // a prior rule that was ignored".
        //
        // 1. Match "booger" first, ignore. Also proves that [string] does non match.
        // 2. Resume matching for [number]
        // 3. Match at index + 1 for [string, "booger", number]
        // 4. If #2 and #3 result in matches, which came first?
        if (this.resumingScanAtSamePosition()) {
          if (result && result.index === this.lastIndex) ;else {
            // use the second matcher result
            const m2 = this.getMatcher(0);
            m2.lastIndex = this.lastIndex + 1;
            result = m2.exec(s);
          }
        }
        if (result) {
          this.regexIndex += result.position + 1;
          if (this.regexIndex === this.count) {
            // wrap-around to considering all matches again
            this.considerAll();
          }
        }
        return result;
      }
    }

    /**
     * Given a mode, builds a huge ResumableMultiRegex that can be used to walk
     * the content and find matches.
     *
     * @param {CompiledMode} mode
     * @returns {ResumableMultiRegex}
     */
    function buildModeRegex(mode) {
      const mm = new ResumableMultiRegex();
      mode.contains.forEach(term => mm.addRule(term.begin, {
        rule: term,
        type: "begin"
      }));
      if (mode.terminatorEnd) {
        mm.addRule(mode.terminatorEnd, {
          type: "end"
        });
      }
      if (mode.illegal) {
        mm.addRule(mode.illegal, {
          type: "illegal"
        });
      }
      return mm;
    }

    /** skip vs abort vs ignore
     *
     * @skip   - The mode is still entered and exited normally (and contains rules apply),
     *           but all content is held and added to the parent buffer rather than being
     *           output when the mode ends.  Mostly used with `sublanguage` to build up
     *           a single large buffer than can be parsed by sublanguage.
     *
     *             - The mode begin ands ends normally.
     *             - Content matched is added to the parent mode buffer.
     *             - The parser cursor is moved forward normally.
     *
     * @abort  - A hack placeholder until we have ignore.  Aborts the mode (as if it
     *           never matched) but DOES NOT continue to match subsequent `contains`
     *           modes.  Abort is bad/suboptimal because it can result in modes
     *           farther down not getting applied because an earlier rule eats the
     *           content but then aborts.
     *
     *             - The mode does not begin.
     *             - Content matched by `begin` is added to the mode buffer.
     *             - The parser cursor is moved forward accordingly.
     *
     * @ignore - Ignores the mode (as if it never matched) and continues to match any
     *           subsequent `contains` modes.  Ignore isn't technically possible with
     *           the current parser implementation.
     *
     *             - The mode does not begin.
     *             - Content matched by `begin` is ignored.
     *             - The parser cursor is not moved forward.
     */

    /**
     * Compiles an individual mode
     *
     * This can raise an error if the mode contains certain detectable known logic
     * issues.
     * @param {Mode} mode
     * @param {CompiledMode | null} [parent]
     * @returns {CompiledMode | never}
     */
    function compileMode(mode, parent) {
      const cmode = /** @type CompiledMode */mode;
      if (mode.isCompiled) return cmode;
      [scopeClassName,
      // do this early so compiler extensions generally don't have to worry about
      // the distinction between match/begin
      compileMatch, MultiClass, beforeMatchExt].forEach(ext => ext(mode, parent));
      language.compilerExtensions.forEach(ext => ext(mode, parent));

      // __beforeBegin is considered private API, internal use only
      mode.__beforeBegin = null;
      [beginKeywords,
      // do this later so compiler extensions that come earlier have access to the
      // raw array if they wanted to perhaps manipulate it, etc.
      compileIllegal,
      // default to 1 relevance if not specified
      compileRelevance].forEach(ext => ext(mode, parent));
      mode.isCompiled = true;
      let keywordPattern = null;
      if (typeof mode.keywords === "object" && mode.keywords.$pattern) {
        // we need a copy because keywords might be compiled multiple times
        // so we can't go deleting $pattern from the original on the first
        // pass
        mode.keywords = Object.assign({}, mode.keywords);
        keywordPattern = mode.keywords.$pattern;
        delete mode.keywords.$pattern;
      }
      keywordPattern = keywordPattern || /\w+/;
      if (mode.keywords) {
        mode.keywords = compileKeywords(mode.keywords, language.case_insensitive);
      }
      cmode.keywordPatternRe = langRe(keywordPattern, true);
      if (parent) {
        if (!mode.begin) mode.begin = /\B|\b/;
        cmode.beginRe = langRe(cmode.begin);
        if (!mode.end && !mode.endsWithParent) mode.end = /\B|\b/;
        if (mode.end) cmode.endRe = langRe(cmode.end);
        cmode.terminatorEnd = source(cmode.end) || '';
        if (mode.endsWithParent && parent.terminatorEnd) {
          cmode.terminatorEnd += (mode.end ? '|' : '') + parent.terminatorEnd;
        }
      }
      if (mode.illegal) cmode.illegalRe = langRe( /** @type {RegExp | string} */mode.illegal);
      if (!mode.contains) mode.contains = [];
      mode.contains = [].concat(...mode.contains.map(function (c) {
        return expandOrCloneMode(c === 'self' ? mode : c);
      }));
      mode.contains.forEach(function (c) {
        compileMode( /** @type Mode */c, cmode);
      });
      if (mode.starts) {
        compileMode(mode.starts, parent);
      }
      cmode.matcher = buildModeRegex(cmode);
      return cmode;
    }
    if (!language.compilerExtensions) language.compilerExtensions = [];

    // self is not valid at the top-level
    if (language.contains && language.contains.includes('self')) {
      throw new Error("ERR: contains `self` is not supported at the top-level of a language.  See documentation.");
    }

    // we need a null object, which inherit will guarantee
    language.classNameAliases = inherit$1(language.classNameAliases || {});
    return compileMode( /** @type Mode */language);
  }

  /**
   * Determines if a mode has a dependency on it's parent or not
   *
   * If a mode does have a parent dependency then often we need to clone it if
   * it's used in multiple places so that each copy points to the correct parent,
   * where-as modes without a parent can often safely be re-used at the bottom of
   * a mode chain.
   *
   * @param {Mode | null} mode
   * @returns {boolean} - is there a dependency on the parent?
   * */
  function dependencyOnParent(mode) {
    if (!mode) return false;
    return mode.endsWithParent || dependencyOnParent(mode.starts);
  }

  /**
   * Expands a mode or clones it if necessary
   *
   * This is necessary for modes with parental dependenceis (see notes on
   * `dependencyOnParent`) and for nodes that have `variants` - which must then be
   * exploded into their own individual modes at compile time.
   *
   * @param {Mode} mode
   * @returns {Mode | Mode[]}
   * */
  function expandOrCloneMode(mode) {
    if (mode.variants && !mode.cachedVariants) {
      mode.cachedVariants = mode.variants.map(function (variant) {
        return inherit$1(mode, {
          variants: null
        }, variant);
      });
    }

    // EXPAND
    // if we have variants then essentially "replace" the mode with the variants
    // this happens in compileMode, where this function is called from
    if (mode.cachedVariants) {
      return mode.cachedVariants;
    }

    // CLONE
    // if we have dependencies on parents then we need a unique
    // instance of ourselves, so we can be reused with many
    // different parents without issue
    if (dependencyOnParent(mode)) {
      return inherit$1(mode, {
        starts: mode.starts ? inherit$1(mode.starts) : null
      });
    }
    if (Object.isFrozen(mode)) {
      return inherit$1(mode);
    }

    // no special dependency issues, just return ourselves
    return mode;
  }
  var version = "11.8.0";
  class HTMLInjectionError extends Error {
    constructor(reason, html) {
      super(reason);
      this.name = "HTMLInjectionError";
      this.html = html;
    }
  }

  /*
  Syntax highlighting with language autodetection.
  https://highlightjs.org/
  */

  /**
  @typedef {import('highlight.js').Mode} Mode
  @typedef {import('highlight.js').CompiledMode} CompiledMode
  @typedef {import('highlight.js').CompiledScope} CompiledScope
  @typedef {import('highlight.js').Language} Language
  @typedef {import('highlight.js').HLJSApi} HLJSApi
  @typedef {import('highlight.js').HLJSPlugin} HLJSPlugin
  @typedef {import('highlight.js').PluginEvent} PluginEvent
  @typedef {import('highlight.js').HLJSOptions} HLJSOptions
  @typedef {import('highlight.js').LanguageFn} LanguageFn
  @typedef {import('highlight.js').HighlightedHTMLElement} HighlightedHTMLElement
  @typedef {import('highlight.js').BeforeHighlightContext} BeforeHighlightContext
  @typedef {import('highlight.js/private').MatchType} MatchType
  @typedef {import('highlight.js/private').KeywordData} KeywordData
  @typedef {import('highlight.js/private').EnhancedMatch} EnhancedMatch
  @typedef {import('highlight.js/private').AnnotatedError} AnnotatedError
  @typedef {import('highlight.js').AutoHighlightResult} AutoHighlightResult
  @typedef {import('highlight.js').HighlightOptions} HighlightOptions
  @typedef {import('highlight.js').HighlightResult} HighlightResult
  */

  const escape = escapeHTML;
  const inherit = inherit$1;
  const NO_MATCH = Symbol("nomatch");
  const MAX_KEYWORD_HITS = 7;

  /**
   * @param {any} hljs - object that is extended (legacy)
   * @returns {HLJSApi}
   */
  const HLJS = function (hljs) {
    // Global internal variables used within the highlight.js library.
    /** @type {Record<string, Language>} */
    const languages = Object.create(null);
    /** @type {Record<string, string>} */
    const aliases = Object.create(null);
    /** @type {HLJSPlugin[]} */
    const plugins = [];

    // safe/production mode - swallows more errors, tries to keep running
    // even if a single syntax or parse hits a fatal error
    let SAFE_MODE = true;
    const LANGUAGE_NOT_FOUND = "Could not find the language '{}', did you forget to load/include a language module?";
    /** @type {Language} */
    const PLAINTEXT_LANGUAGE = {
      disableAutodetect: true,
      name: 'Plain text',
      contains: []
    };

    // Global options used when within external APIs. This is modified when
    // calling the `hljs.configure` function.
    /** @type HLJSOptions */
    let options = {
      ignoreUnescapedHTML: false,
      throwUnescapedHTML: false,
      noHighlightRe: /^(no-?highlight)$/i,
      languageDetectRe: /\blang(?:uage)?-([\w-]+)\b/i,
      classPrefix: 'hljs-',
      cssSelector: 'pre code',
      languages: null,
      // beta configuration options, subject to change, welcome to discuss
      // https://github.com/highlightjs/highlight.js/issues/1086
      __emitter: TokenTreeEmitter
    };

    /* Utility functions */

    /**
     * Tests a language name to see if highlighting should be skipped
     * @param {string} languageName
     */
    function shouldNotHighlight(languageName) {
      return options.noHighlightRe.test(languageName);
    }

    /**
     * @param {HighlightedHTMLElement} block - the HTML element to determine language for
     */
    function blockLanguage(block) {
      let classes = block.className + ' ';
      classes += block.parentNode ? block.parentNode.className : '';

      // language-* takes precedence over non-prefixed class names.
      const match = options.languageDetectRe.exec(classes);
      if (match) {
        const language = getLanguage(match[1]);
        if (!language) {
          warn(LANGUAGE_NOT_FOUND.replace("{}", match[1]));
          warn("Falling back to no-highlight mode for this block.", block);
        }
        return language ? match[1] : 'no-highlight';
      }
      return classes.split(/\s+/).find(_class => shouldNotHighlight(_class) || getLanguage(_class));
    }

    /**
     * Core highlighting function.
     *
     * OLD API
     * highlight(lang, code, ignoreIllegals, continuation)
     *
     * NEW API
     * highlight(code, {lang, ignoreIllegals})
     *
     * @param {string} codeOrLanguageName - the language to use for highlighting
     * @param {string | HighlightOptions} optionsOrCode - the code to highlight
     * @param {boolean} [ignoreIllegals] - whether to ignore illegal matches, default is to bail
     *
     * @returns {HighlightResult} Result - an object that represents the result
     * @property {string} language - the language name
     * @property {number} relevance - the relevance score
     * @property {string} value - the highlighted HTML code
     * @property {string} code - the original raw code
     * @property {CompiledMode} top - top of the current mode stack
     * @property {boolean} illegal - indicates whether any illegal matches were found
    */
    function highlight(codeOrLanguageName, optionsOrCode, ignoreIllegals) {
      let code = "";
      let languageName = "";
      if (typeof optionsOrCode === "object") {
        code = codeOrLanguageName;
        ignoreIllegals = optionsOrCode.ignoreIllegals;
        languageName = optionsOrCode.language;
      } else {
        // old API
        deprecated("10.7.0", "highlight(lang, code, ...args) has been deprecated.");
        deprecated("10.7.0", "Please use highlight(code, options) instead.\nhttps://github.com/highlightjs/highlight.js/issues/2277");
        languageName = codeOrLanguageName;
        code = optionsOrCode;
      }

      // https://github.com/highlightjs/highlight.js/issues/3149
      // eslint-disable-next-line no-undefined
      if (ignoreIllegals === undefined) {
        ignoreIllegals = true;
      }

      /** @type {BeforeHighlightContext} */
      const context = {
        code,
        language: languageName
      };
      // the plugin can change the desired language or the code to be highlighted
      // just be changing the object it was passed
      fire("before:highlight", context);

      // a before plugin can usurp the result completely by providing it's own
      // in which case we don't even need to call highlight
      const result = context.result ? context.result : _highlight(context.language, context.code, ignoreIllegals);
      result.code = context.code;
      // the plugin can change anything in result to suite it
      fire("after:highlight", result);
      return result;
    }

    /**
     * private highlight that's used internally and does not fire callbacks
     *
     * @param {string} languageName - the language to use for highlighting
     * @param {string} codeToHighlight - the code to highlight
     * @param {boolean?} [ignoreIllegals] - whether to ignore illegal matches, default is to bail
     * @param {CompiledMode?} [continuation] - current continuation mode, if any
     * @returns {HighlightResult} - result of the highlight operation
    */
    function _highlight(languageName, codeToHighlight, ignoreIllegals, continuation) {
      const keywordHits = Object.create(null);

      /**
       * Return keyword data if a match is a keyword
       * @param {CompiledMode} mode - current mode
       * @param {string} matchText - the textual match
       * @returns {KeywordData | false}
       */
      function keywordData(mode, matchText) {
        return mode.keywords[matchText];
      }
      function processKeywords() {
        if (!top.keywords) {
          emitter.addText(modeBuffer);
          return;
        }
        let lastIndex = 0;
        top.keywordPatternRe.lastIndex = 0;
        let match = top.keywordPatternRe.exec(modeBuffer);
        let buf = "";
        while (match) {
          buf += modeBuffer.substring(lastIndex, match.index);
          const word = language.case_insensitive ? match[0].toLowerCase() : match[0];
          const data = keywordData(top, word);
          if (data) {
            const [kind, keywordRelevance] = data;
            emitter.addText(buf);
            buf = "";
            keywordHits[word] = (keywordHits[word] || 0) + 1;
            if (keywordHits[word] <= MAX_KEYWORD_HITS) relevance += keywordRelevance;
            if (kind.startsWith("_")) {
              // _ implied for relevance only, do not highlight
              // by applying a class name
              buf += match[0];
            } else {
              const cssClass = language.classNameAliases[kind] || kind;
              emitKeyword(match[0], cssClass);
            }
          } else {
            buf += match[0];
          }
          lastIndex = top.keywordPatternRe.lastIndex;
          match = top.keywordPatternRe.exec(modeBuffer);
        }
        buf += modeBuffer.substring(lastIndex);
        emitter.addText(buf);
      }
      function processSubLanguage() {
        if (modeBuffer === "") return;
        /** @type HighlightResult */
        let result = null;
        if (typeof top.subLanguage === 'string') {
          if (!languages[top.subLanguage]) {
            emitter.addText(modeBuffer);
            return;
          }
          result = _highlight(top.subLanguage, modeBuffer, true, continuations[top.subLanguage]);
          continuations[top.subLanguage] = /** @type {CompiledMode} */result._top;
        } else {
          result = highlightAuto(modeBuffer, top.subLanguage.length ? top.subLanguage : null);
        }

        // Counting embedded language score towards the host language may be disabled
        // with zeroing the containing mode relevance. Use case in point is Markdown that
        // allows XML everywhere and makes every XML snippet to have a much larger Markdown
        // score.
        if (top.relevance > 0) {
          relevance += result.relevance;
        }
        emitter.__addSublanguage(result._emitter, result.language);
      }
      function processBuffer() {
        if (top.subLanguage != null) {
          processSubLanguage();
        } else {
          processKeywords();
        }
        modeBuffer = '';
      }

      /**
       * @param {string} text
       * @param {string} scope
       */
      function emitKeyword(keyword, scope) {
        if (keyword === "") return;
        emitter.startScope(scope);
        emitter.addText(keyword);
        emitter.endScope();
      }

      /**
       * @param {CompiledScope} scope
       * @param {RegExpMatchArray} match
       */
      function emitMultiClass(scope, match) {
        let i = 1;
        const max = match.length - 1;
        while (i <= max) {
          if (!scope._emit[i]) {
            i++;
            continue;
          }
          const klass = language.classNameAliases[scope[i]] || scope[i];
          const text = match[i];
          if (klass) {
            emitKeyword(text, klass);
          } else {
            modeBuffer = text;
            processKeywords();
            modeBuffer = "";
          }
          i++;
        }
      }

      /**
       * @param {CompiledMode} mode - new mode to start
       * @param {RegExpMatchArray} match
       */
      function startNewMode(mode, match) {
        if (mode.scope && typeof mode.scope === "string") {
          emitter.openNode(language.classNameAliases[mode.scope] || mode.scope);
        }
        if (mode.beginScope) {
          // beginScope just wraps the begin match itself in a scope
          if (mode.beginScope._wrap) {
            emitKeyword(modeBuffer, language.classNameAliases[mode.beginScope._wrap] || mode.beginScope._wrap);
            modeBuffer = "";
          } else if (mode.beginScope._multi) {
            // at this point modeBuffer should just be the match
            emitMultiClass(mode.beginScope, match);
            modeBuffer = "";
          }
        }
        top = Object.create(mode, {
          parent: {
            value: top
          }
        });
        return top;
      }

      /**
       * @param {CompiledMode } mode - the mode to potentially end
       * @param {RegExpMatchArray} match - the latest match
       * @param {string} matchPlusRemainder - match plus remainder of content
       * @returns {CompiledMode | void} - the next mode, or if void continue on in current mode
       */
      function endOfMode(mode, match, matchPlusRemainder) {
        let matched = startsWith(mode.endRe, matchPlusRemainder);
        if (matched) {
          if (mode["on:end"]) {
            const resp = new Response(mode);
            mode["on:end"](match, resp);
            if (resp.isMatchIgnored) matched = false;
          }
          if (matched) {
            while (mode.endsParent && mode.parent) {
              mode = mode.parent;
            }
            return mode;
          }
        }
        // even if on:end fires an `ignore` it's still possible
        // that we might trigger the end node because of a parent mode
        if (mode.endsWithParent) {
          return endOfMode(mode.parent, match, matchPlusRemainder);
        }
      }

      /**
       * Handle matching but then ignoring a sequence of text
       *
       * @param {string} lexeme - string containing full match text
       */
      function doIgnore(lexeme) {
        if (top.matcher.regexIndex === 0) {
          // no more regexes to potentially match here, so we move the cursor forward one
          // space
          modeBuffer += lexeme[0];
          return 1;
        } else {
          // no need to move the cursor, we still have additional regexes to try and
          // match at this very spot
          resumeScanAtSamePosition = true;
          return 0;
        }
      }

      /**
       * Handle the start of a new potential mode match
       *
       * @param {EnhancedMatch} match - the current match
       * @returns {number} how far to advance the parse cursor
       */
      function doBeginMatch(match) {
        const lexeme = match[0];
        const newMode = match.rule;
        const resp = new Response(newMode);
        // first internal before callbacks, then the public ones
        const beforeCallbacks = [newMode.__beforeBegin, newMode["on:begin"]];
        for (const cb of beforeCallbacks) {
          if (!cb) continue;
          cb(match, resp);
          if (resp.isMatchIgnored) return doIgnore(lexeme);
        }
        if (newMode.skip) {
          modeBuffer += lexeme;
        } else {
          if (newMode.excludeBegin) {
            modeBuffer += lexeme;
          }
          processBuffer();
          if (!newMode.returnBegin && !newMode.excludeBegin) {
            modeBuffer = lexeme;
          }
        }
        startNewMode(newMode, match);
        return newMode.returnBegin ? 0 : lexeme.length;
      }

      /**
       * Handle the potential end of mode
       *
       * @param {RegExpMatchArray} match - the current match
       */
      function doEndMatch(match) {
        const lexeme = match[0];
        const matchPlusRemainder = codeToHighlight.substring(match.index);
        const endMode = endOfMode(top, match, matchPlusRemainder);
        if (!endMode) {
          return NO_MATCH;
        }
        const origin = top;
        if (top.endScope && top.endScope._wrap) {
          processBuffer();
          emitKeyword(lexeme, top.endScope._wrap);
        } else if (top.endScope && top.endScope._multi) {
          processBuffer();
          emitMultiClass(top.endScope, match);
        } else if (origin.skip) {
          modeBuffer += lexeme;
        } else {
          if (!(origin.returnEnd || origin.excludeEnd)) {
            modeBuffer += lexeme;
          }
          processBuffer();
          if (origin.excludeEnd) {
            modeBuffer = lexeme;
          }
        }
        do {
          if (top.scope) {
            emitter.closeNode();
          }
          if (!top.skip && !top.subLanguage) {
            relevance += top.relevance;
          }
          top = top.parent;
        } while (top !== endMode.parent);
        if (endMode.starts) {
          startNewMode(endMode.starts, match);
        }
        return origin.returnEnd ? 0 : lexeme.length;
      }
      function processContinuations() {
        const list = [];
        for (let current = top; current !== language; current = current.parent) {
          if (current.scope) {
            list.unshift(current.scope);
          }
        }
        list.forEach(item => emitter.openNode(item));
      }

      /** @type {{type?: MatchType, index?: number, rule?: Mode}}} */
      let lastMatch = {};

      /**
       *  Process an individual match
       *
       * @param {string} textBeforeMatch - text preceding the match (since the last match)
       * @param {EnhancedMatch} [match] - the match itself
       */
      function processLexeme(textBeforeMatch, match) {
        const lexeme = match && match[0];

        // add non-matched text to the current mode buffer
        modeBuffer += textBeforeMatch;
        if (lexeme == null) {
          processBuffer();
          return 0;
        }

        // we've found a 0 width match and we're stuck, so we need to advance
        // this happens when we have badly behaved rules that have optional matchers to the degree that
        // sometimes they can end up matching nothing at all
        // Ref: https://github.com/highlightjs/highlight.js/issues/2140
        if (lastMatch.type === "begin" && match.type === "end" && lastMatch.index === match.index && lexeme === "") {
          // spit the "skipped" character that our regex choked on back into the output sequence
          modeBuffer += codeToHighlight.slice(match.index, match.index + 1);
          if (!SAFE_MODE) {
            /** @type {AnnotatedError} */
            const err = new Error(`0 width match regex (${languageName})`);
            err.languageName = languageName;
            err.badRule = lastMatch.rule;
            throw err;
          }
          return 1;
        }
        lastMatch = match;
        if (match.type === "begin") {
          return doBeginMatch(match);
        } else if (match.type === "illegal" && !ignoreIllegals) {
          // illegal match, we do not continue processing
          /** @type {AnnotatedError} */
          const err = new Error('Illegal lexeme "' + lexeme + '" for mode "' + (top.scope || '<unnamed>') + '"');
          err.mode = top;
          throw err;
        } else if (match.type === "end") {
          const processed = doEndMatch(match);
          if (processed !== NO_MATCH) {
            return processed;
          }
        }

        // edge case for when illegal matches $ (end of line) which is technically
        // a 0 width match but not a begin/end match so it's not caught by the
        // first handler (when ignoreIllegals is true)
        if (match.type === "illegal" && lexeme === "") {
          // advance so we aren't stuck in an infinite loop
          return 1;
        }

        // infinite loops are BAD, this is a last ditch catch all. if we have a
        // decent number of iterations yet our index (cursor position in our
        // parsing) still 3x behind our index then something is very wrong
        // so we bail
        if (iterations > 100000 && iterations > match.index * 3) {
          const err = new Error('potential infinite loop, way more iterations than matches');
          throw err;
        }

        /*
        Why might be find ourselves here?  An potential end match that was
        triggered but could not be completed.  IE, `doEndMatch` returned NO_MATCH.
        (this could be because a callback requests the match be ignored, etc)
         This causes no real harm other than stopping a few times too many.
        */

        modeBuffer += lexeme;
        return lexeme.length;
      }
      const language = getLanguage(languageName);
      if (!language) {
        error$1(LANGUAGE_NOT_FOUND.replace("{}", languageName));
        throw new Error('Unknown language: "' + languageName + '"');
      }
      const md = compileLanguage(language);
      let result = '';
      /** @type {CompiledMode} */
      let top = continuation || md;
      /** @type Record<string,CompiledMode> */
      const continuations = {}; // keep continuations for sub-languages
      const emitter = new options.__emitter(options);
      processContinuations();
      let modeBuffer = '';
      let relevance = 0;
      let index = 0;
      let iterations = 0;
      let resumeScanAtSamePosition = false;
      try {
        if (!language.__emitTokens) {
          top.matcher.considerAll();
          for (;;) {
            iterations++;
            if (resumeScanAtSamePosition) {
              // only regexes not matched previously will now be
              // considered for a potential match
              resumeScanAtSamePosition = false;
            } else {
              top.matcher.considerAll();
            }
            top.matcher.lastIndex = index;
            const match = top.matcher.exec(codeToHighlight);
            // console.log("match", match[0], match.rule && match.rule.begin)

            if (!match) break;
            const beforeMatch = codeToHighlight.substring(index, match.index);
            const processedCount = processLexeme(beforeMatch, match);
            index = match.index + processedCount;
          }
          processLexeme(codeToHighlight.substring(index));
        } else {
          language.__emitTokens(codeToHighlight, emitter);
        }
        emitter.finalize();
        result = emitter.toHTML();
        return {
          language: languageName,
          value: result,
          relevance,
          illegal: false,
          _emitter: emitter,
          _top: top
        };
      } catch (err) {
        if (err.message && err.message.includes('Illegal')) {
          return {
            language: languageName,
            value: escape(codeToHighlight),
            illegal: true,
            relevance: 0,
            _illegalBy: {
              message: err.message,
              index,
              context: codeToHighlight.slice(index - 100, index + 100),
              mode: err.mode,
              resultSoFar: result
            },
            _emitter: emitter
          };
        } else if (SAFE_MODE) {
          return {
            language: languageName,
            value: escape(codeToHighlight),
            illegal: false,
            relevance: 0,
            errorRaised: err,
            _emitter: emitter,
            _top: top
          };
        } else {
          throw err;
        }
      }
    }

    /**
     * returns a valid highlight result, without actually doing any actual work,
     * auto highlight starts with this and it's possible for small snippets that
     * auto-detection may not find a better match
     * @param {string} code
     * @returns {HighlightResult}
     */
    function justTextHighlightResult(code) {
      const result = {
        value: escape(code),
        illegal: false,
        relevance: 0,
        _top: PLAINTEXT_LANGUAGE,
        _emitter: new options.__emitter(options)
      };
      result._emitter.addText(code);
      return result;
    }

    /**
    Highlighting with language detection. Accepts a string with the code to
    highlight. Returns an object with the following properties:
     - language (detected language)
    - relevance (int)
    - value (an HTML string with highlighting markup)
    - secondBest (object with the same structure for second-best heuristically
      detected language, may be absent)
       @param {string} code
      @param {Array<string>} [languageSubset]
      @returns {AutoHighlightResult}
    */
    function highlightAuto(code, languageSubset) {
      languageSubset = languageSubset || options.languages || Object.keys(languages);
      const plaintext = justTextHighlightResult(code);
      const results = languageSubset.filter(getLanguage).filter(autoDetection).map(name => _highlight(name, code, false));
      results.unshift(plaintext); // plaintext is always an option

      const sorted = results.sort((a, b) => {
        // sort base on relevance
        if (a.relevance !== b.relevance) return b.relevance - a.relevance;

        // always award the tie to the base language
        // ie if C++ and Arduino are tied, it's more likely to be C++
        if (a.language && b.language) {
          if (getLanguage(a.language).supersetOf === b.language) {
            return 1;
          } else if (getLanguage(b.language).supersetOf === a.language) {
            return -1;
          }
        }

        // otherwise say they are equal, which has the effect of sorting on
        // relevance while preserving the original ordering - which is how ties
        // have historically been settled, ie the language that comes first always
        // wins in the case of a tie
        return 0;
      });
      const [best, secondBest] = sorted;

      /** @type {AutoHighlightResult} */
      const result = best;
      result.secondBest = secondBest;
      return result;
    }

    /**
     * Builds new class name for block given the language name
     *
     * @param {HTMLElement} element
     * @param {string} [currentLang]
     * @param {string} [resultLang]
     */
    function updateClassName(element, currentLang, resultLang) {
      const language = currentLang && aliases[currentLang] || resultLang;
      element.classList.add("hljs");
      element.classList.add(`language-${language}`);
    }

    /**
     * Applies highlighting to a DOM node containing code.
     *
     * @param {HighlightedHTMLElement} element - the HTML element to highlight
    */
    function highlightElement(element) {
      /** @type HTMLElement */
      let node = null;
      const language = blockLanguage(element);
      if (shouldNotHighlight(language)) return;
      fire("before:highlightElement", {
        el: element,
        language
      });

      // we should be all text, no child nodes (unescaped HTML) - this is possibly
      // an HTML injection attack - it's likely too late if this is already in
      // production (the code has likely already done its damage by the time
      // we're seeing it)... but we yell loudly about this so that hopefully it's
      // more likely to be caught in development before making it to production
      if (element.children.length > 0) {
        if (!options.ignoreUnescapedHTML) {
          console.warn("One of your code blocks includes unescaped HTML. This is a potentially serious security risk.");
          console.warn("https://github.com/highlightjs/highlight.js/wiki/security");
          console.warn("The element with unescaped HTML:");
          console.warn(element);
        }
        if (options.throwUnescapedHTML) {
          const err = new HTMLInjectionError("One of your code blocks includes unescaped HTML.", element.innerHTML);
          throw err;
        }
      }
      node = element;
      const text = node.textContent;
      const result = language ? highlight(text, {
        language,
        ignoreIllegals: true
      }) : highlightAuto(text);
      element.innerHTML = result.value;
      updateClassName(element, language, result.language);
      element.result = {
        language: result.language,
        // TODO: remove with version 11.0
        re: result.relevance,
        relevance: result.relevance
      };
      if (result.secondBest) {
        element.secondBest = {
          language: result.secondBest.language,
          relevance: result.secondBest.relevance
        };
      }
      fire("after:highlightElement", {
        el: element,
        result,
        text
      });
    }

    /**
     * Updates highlight.js global options with the passed options
     *
     * @param {Partial<HLJSOptions>} userOptions
     */
    function configure(userOptions) {
      options = inherit(options, userOptions);
    }

    // TODO: remove v12, deprecated
    const initHighlighting = () => {
      highlightAll();
      deprecated("10.6.0", "initHighlighting() deprecated.  Use highlightAll() now.");
    };

    // TODO: remove v12, deprecated
    function initHighlightingOnLoad() {
      highlightAll();
      deprecated("10.6.0", "initHighlightingOnLoad() deprecated.  Use highlightAll() now.");
    }
    let wantsHighlight = false;

    /**
     * auto-highlights all pre>code elements on the page
     */
    function highlightAll() {
      // if we are called too early in the loading process
      if (document.readyState === "loading") {
        wantsHighlight = true;
        return;
      }
      const blocks = document.querySelectorAll(options.cssSelector);
      blocks.forEach(highlightElement);
    }
    function boot() {
      // if a highlight was requested before DOM was loaded, do now
      if (wantsHighlight) highlightAll();
    }

    // make sure we are in the browser environment
    if (typeof window !== 'undefined' && window.addEventListener) {
      window.addEventListener('DOMContentLoaded', boot, false);
    }

    /**
     * Register a language grammar module
     *
     * @param {string} languageName
     * @param {LanguageFn} languageDefinition
     */
    function registerLanguage(languageName, languageDefinition) {
      let lang = null;
      try {
        lang = languageDefinition(hljs);
      } catch (error$1$1) {
        error$1("Language definition for '{}' could not be registered.".replace("{}", languageName));
        // hard or soft error
        if (!SAFE_MODE) {
          throw error$1$1;
        } else {
          error$1(error$1$1);
        }
        // languages that have serious errors are replaced with essentially a
        // "plaintext" stand-in so that the code blocks will still get normal
        // css classes applied to them - and one bad language won't break the
        // entire highlighter
        lang = PLAINTEXT_LANGUAGE;
      }
      // give it a temporary name if it doesn't have one in the meta-data
      if (!lang.name) lang.name = languageName;
      languages[languageName] = lang;
      lang.rawDefinition = languageDefinition.bind(null, hljs);
      if (lang.aliases) {
        registerAliases(lang.aliases, {
          languageName
        });
      }
    }

    /**
     * Remove a language grammar module
     *
     * @param {string} languageName
     */
    function unregisterLanguage(languageName) {
      delete languages[languageName];
      for (const alias of Object.keys(aliases)) {
        if (aliases[alias] === languageName) {
          delete aliases[alias];
        }
      }
    }

    /**
     * @returns {string[]} List of language internal names
     */
    function listLanguages() {
      return Object.keys(languages);
    }

    /**
     * @param {string} name - name of the language to retrieve
     * @returns {Language | undefined}
     */
    function getLanguage(name) {
      name = (name || '').toLowerCase();
      return languages[name] || languages[aliases[name]];
    }

    /**
     *
     * @param {string|string[]} aliasList - single alias or list of aliases
     * @param {{languageName: string}} opts
     */
    function registerAliases(aliasList, {
      languageName
    }) {
      if (typeof aliasList === 'string') {
        aliasList = [aliasList];
      }
      aliasList.forEach(alias => {
        aliases[alias.toLowerCase()] = languageName;
      });
    }

    /**
     * Determines if a given language has auto-detection enabled
     * @param {string} name - name of the language
     */
    function autoDetection(name) {
      const lang = getLanguage(name);
      return lang && !lang.disableAutodetect;
    }

    /**
     * Upgrades the old highlightBlock plugins to the new
     * highlightElement API
     * @param {HLJSPlugin} plugin
     */
    function upgradePluginAPI(plugin) {
      // TODO: remove with v12
      if (plugin["before:highlightBlock"] && !plugin["before:highlightElement"]) {
        plugin["before:highlightElement"] = data => {
          plugin["before:highlightBlock"](Object.assign({
            block: data.el
          }, data));
        };
      }
      if (plugin["after:highlightBlock"] && !plugin["after:highlightElement"]) {
        plugin["after:highlightElement"] = data => {
          plugin["after:highlightBlock"](Object.assign({
            block: data.el
          }, data));
        };
      }
    }

    /**
     * @param {HLJSPlugin} plugin
     */
    function addPlugin(plugin) {
      upgradePluginAPI(plugin);
      plugins.push(plugin);
    }

    /**
     * @param {HLJSPlugin} plugin
     */
    function removePlugin(plugin) {
      const index = plugins.indexOf(plugin);
      if (index !== -1) {
        plugins.splice(index, 1);
      }
    }

    /**
     *
     * @param {PluginEvent} event
     * @param {any} args
     */
    function fire(event, args) {
      const cb = event;
      plugins.forEach(function (plugin) {
        if (plugin[cb]) {
          plugin[cb](args);
        }
      });
    }

    /**
     * DEPRECATED
     * @param {HighlightedHTMLElement} el
     */
    function deprecateHighlightBlock(el) {
      deprecated("10.7.0", "highlightBlock will be removed entirely in v12.0");
      deprecated("10.7.0", "Please use highlightElement now.");
      return highlightElement(el);
    }

    /* Interface definition */
    Object.assign(hljs, {
      highlight,
      highlightAuto,
      highlightAll,
      highlightElement,
      // TODO: Remove with v12 API
      highlightBlock: deprecateHighlightBlock,
      configure,
      initHighlighting,
      initHighlightingOnLoad,
      registerLanguage,
      unregisterLanguage,
      listLanguages,
      getLanguage,
      registerAliases,
      autoDetection,
      inherit,
      addPlugin,
      removePlugin
    });
    hljs.debugMode = function () {
      SAFE_MODE = false;
    };
    hljs.safeMode = function () {
      SAFE_MODE = true;
    };
    hljs.versionString = version;
    hljs.regex = {
      concat: concat,
      lookahead: lookahead,
      either: either,
      optional: optional,
      anyNumberOfTimes: anyNumberOfTimes
    };
    for (const key in MODES) {
      // @ts-ignore
      if (typeof MODES[key] === "object") {
        // @ts-ignore
        deepFreeze(MODES[key]);
      }
    }

    // merge all the modes/regexes into our main object
    Object.assign(hljs, MODES);
    return hljs;
  };

  // Other names for the variable may break build script
  const highlight = HLJS({});

  // returns a new instance of the highlighter to be used for extensions
  // check https://github.com/wooorm/lowlight/issues/47
  highlight.newInstance = () => HLJS({});
  var core = highlight;
  highlight.HighlightJS = highlight;
  highlight.default = highlight;

  /*
  Language: HTML, XML
  Website: https://www.w3.org/XML/
  Category: common, web
  Audit: 2020
  */
  var xml_1;
  var hasRequiredXml;
  function requireXml() {
    if (hasRequiredXml) return xml_1;
    hasRequiredXml = 1;
    /** @type LanguageFn */
    function xml(hljs) {
      const regex = hljs.regex;
      // XML names can have the following additional letters: https://www.w3.org/TR/xml/#NT-NameChar
      // OTHER_NAME_CHARS = /[:\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]/;
      // Element names start with NAME_START_CHAR followed by optional other Unicode letters, ASCII digits, hyphens, underscores, and periods
      // const TAG_NAME_RE = regex.concat(/[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/, regex.optional(/[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*:/), /[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*/);;
      // const XML_IDENT_RE = /[A-Z_a-z:\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]+/;
      // const TAG_NAME_RE = regex.concat(/[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/, regex.optional(/[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*:/), /[A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*/);
      // however, to cater for performance and more Unicode support rely simply on the Unicode letter class
      const TAG_NAME_RE = regex.concat(/[\p{L}_]/u, regex.optional(/[\p{L}0-9_.-]*:/u), /[\p{L}0-9_.-]*/u);
      const XML_IDENT_RE = /[\p{L}0-9._:-]+/u;
      const XML_ENTITIES = {
        className: 'symbol',
        begin: /&[a-z]+;|&#[0-9]+;|&#x[a-f0-9]+;/
      };
      const XML_META_KEYWORDS = {
        begin: /\s/,
        contains: [{
          className: 'keyword',
          begin: /#?[a-z_][a-z1-9_-]+/,
          illegal: /\n/
        }]
      };
      const XML_META_PAR_KEYWORDS = hljs.inherit(XML_META_KEYWORDS, {
        begin: /\(/,
        end: /\)/
      });
      const APOS_META_STRING_MODE = hljs.inherit(hljs.APOS_STRING_MODE, {
        className: 'string'
      });
      const QUOTE_META_STRING_MODE = hljs.inherit(hljs.QUOTE_STRING_MODE, {
        className: 'string'
      });
      const TAG_INTERNALS = {
        endsWithParent: true,
        illegal: /</,
        relevance: 0,
        contains: [{
          className: 'attr',
          begin: XML_IDENT_RE,
          relevance: 0
        }, {
          begin: /=\s*/,
          relevance: 0,
          contains: [{
            className: 'string',
            endsParent: true,
            variants: [{
              begin: /"/,
              end: /"/,
              contains: [XML_ENTITIES]
            }, {
              begin: /'/,
              end: /'/,
              contains: [XML_ENTITIES]
            }, {
              begin: /[^\s"'=<>`]+/
            }]
          }]
        }]
      };
      return {
        name: 'HTML, XML',
        aliases: ['html', 'xhtml', 'rss', 'atom', 'xjb', 'xsd', 'xsl', 'plist', 'wsf', 'svg'],
        case_insensitive: true,
        unicodeRegex: true,
        contains: [{
          className: 'meta',
          begin: /<![a-z]/,
          end: />/,
          relevance: 10,
          contains: [XML_META_KEYWORDS, QUOTE_META_STRING_MODE, APOS_META_STRING_MODE, XML_META_PAR_KEYWORDS, {
            begin: /\[/,
            end: /\]/,
            contains: [{
              className: 'meta',
              begin: /<![a-z]/,
              end: />/,
              contains: [XML_META_KEYWORDS, XML_META_PAR_KEYWORDS, QUOTE_META_STRING_MODE, APOS_META_STRING_MODE]
            }]
          }]
        }, hljs.COMMENT(/<!--/, /-->/, {
          relevance: 10
        }), {
          begin: /<!\[CDATA\[/,
          end: /\]\]>/,
          relevance: 10
        }, XML_ENTITIES,
        // xml processing instructions
        {
          className: 'meta',
          end: /\?>/,
          variants: [{
            begin: /<\?xml/,
            relevance: 10,
            contains: [QUOTE_META_STRING_MODE]
          }, {
            begin: /<\?[a-z][a-z0-9]+/
          }]
        }, {
          className: 'tag',
          /*
          The lookahead pattern (?=...) ensures that 'begin' only matches
          '<style' as a single word, followed by a whitespace or an
          ending bracket.
          */
          begin: /<style(?=\s|>)/,
          end: />/,
          keywords: {
            name: 'style'
          },
          contains: [TAG_INTERNALS],
          starts: {
            end: /<\/style>/,
            returnEnd: true,
            subLanguage: ['css', 'xml']
          }
        }, {
          className: 'tag',
          // See the comment in the <style tag about the lookahead pattern
          begin: /<script(?=\s|>)/,
          end: />/,
          keywords: {
            name: 'script'
          },
          contains: [TAG_INTERNALS],
          starts: {
            end: /<\/script>/,
            returnEnd: true,
            subLanguage: ['javascript', 'handlebars', 'xml']
          }
        },
        // we need this for now for jSX
        {
          className: 'tag',
          begin: /<>|<\/>/
        },
        // open tag
        {
          className: 'tag',
          begin: regex.concat(/</, regex.lookahead(regex.concat(TAG_NAME_RE,
          // <tag/>
          // <tag>
          // <tag ...
          regex.either(/\/>/, />/, /\s/)))),
          end: /\/?>/,
          contains: [{
            className: 'name',
            begin: TAG_NAME_RE,
            relevance: 0,
            starts: TAG_INTERNALS
          }]
        },
        // close tag
        {
          className: 'tag',
          begin: regex.concat(/<\//, regex.lookahead(regex.concat(TAG_NAME_RE, />/))),
          contains: [{
            className: 'name',
            begin: TAG_NAME_RE,
            relevance: 0
          }, {
            begin: />/,
            relevance: 0,
            endsParent: true
          }]
        }]
      };
    }
    xml_1 = xml;
    return xml_1;
  }

  /*
  Language: Bash
  Author: vah <vahtenberg@gmail.com>
  Contributrors: Benjamin Pannell <contact@sierrasoftworks.com>
  Website: https://www.gnu.org/software/bash/
  Category: common
  */
  var bash_1;
  var hasRequiredBash;
  function requireBash() {
    if (hasRequiredBash) return bash_1;
    hasRequiredBash = 1;
    /** @type LanguageFn */
    function bash(hljs) {
      const regex = hljs.regex;
      const VAR = {};
      const BRACED_VAR = {
        begin: /\$\{/,
        end: /\}/,
        contains: ["self", {
          begin: /:-/,
          contains: [VAR]
        } // default values
        ]
      };

      Object.assign(VAR, {
        className: 'variable',
        variants: [{
          begin: regex.concat(/\$[\w\d#@][\w\d_]*/,
          // negative look-ahead tries to avoid matching patterns that are not
          // Perl at all like $ident$, @ident@, etc.
          `(?![\\w\\d])(?![$])`)
        }, BRACED_VAR]
      });
      const SUBST = {
        className: 'subst',
        begin: /\$\(/,
        end: /\)/,
        contains: [hljs.BACKSLASH_ESCAPE]
      };
      const HERE_DOC = {
        begin: /<<-?\s*(?=\w+)/,
        starts: {
          contains: [hljs.END_SAME_AS_BEGIN({
            begin: /(\w+)/,
            end: /(\w+)/,
            className: 'string'
          })]
        }
      };
      const QUOTE_STRING = {
        className: 'string',
        begin: /"/,
        end: /"/,
        contains: [hljs.BACKSLASH_ESCAPE, VAR, SUBST]
      };
      SUBST.contains.push(QUOTE_STRING);
      const ESCAPED_QUOTE = {
        className: '',
        begin: /\\"/
      };
      const APOS_STRING = {
        className: 'string',
        begin: /'/,
        end: /'/
      };
      const ARITHMETIC = {
        begin: /\$?\(\(/,
        end: /\)\)/,
        contains: [{
          begin: /\d+#[0-9a-f]+/,
          className: "number"
        }, hljs.NUMBER_MODE, VAR]
      };
      const SH_LIKE_SHELLS = ["fish", "bash", "zsh", "sh", "csh", "ksh", "tcsh", "dash", "scsh"];
      const KNOWN_SHEBANG = hljs.SHEBANG({
        binary: `(${SH_LIKE_SHELLS.join("|")})`,
        relevance: 10
      });
      const FUNCTION = {
        className: 'function',
        begin: /\w[\w\d_]*\s*\(\s*\)\s*\{/,
        returnBegin: true,
        contains: [hljs.inherit(hljs.TITLE_MODE, {
          begin: /\w[\w\d_]*/
        })],
        relevance: 0
      };
      const KEYWORDS = ["if", "then", "else", "elif", "fi", "for", "while", "until", "in", "do", "done", "case", "esac", "function", "select"];
      const LITERALS = ["true", "false"];

      // to consume paths to prevent keyword matches inside them
      const PATH_MODE = {
        match: /(\/[a-z._-]+)+/
      };

      // http://www.gnu.org/software/bash/manual/html_node/Shell-Builtin-Commands.html
      const SHELL_BUILT_INS = ["break", "cd", "continue", "eval", "exec", "exit", "export", "getopts", "hash", "pwd", "readonly", "return", "shift", "test", "times", "trap", "umask", "unset"];
      const BASH_BUILT_INS = ["alias", "bind", "builtin", "caller", "command", "declare", "echo", "enable", "help", "let", "local", "logout", "mapfile", "printf", "read", "readarray", "source", "type", "typeset", "ulimit", "unalias"];
      const ZSH_BUILT_INS = ["autoload", "bg", "bindkey", "bye", "cap", "chdir", "clone", "comparguments", "compcall", "compctl", "compdescribe", "compfiles", "compgroups", "compquote", "comptags", "comptry", "compvalues", "dirs", "disable", "disown", "echotc", "echoti", "emulate", "fc", "fg", "float", "functions", "getcap", "getln", "history", "integer", "jobs", "kill", "limit", "log", "noglob", "popd", "print", "pushd", "pushln", "rehash", "sched", "setcap", "setopt", "stat", "suspend", "ttyctl", "unfunction", "unhash", "unlimit", "unsetopt", "vared", "wait", "whence", "where", "which", "zcompile", "zformat", "zftp", "zle", "zmodload", "zparseopts", "zprof", "zpty", "zregexparse", "zsocket", "zstyle", "ztcp"];
      const GNU_CORE_UTILS = ["chcon", "chgrp", "chown", "chmod", "cp", "dd", "df", "dir", "dircolors", "ln", "ls", "mkdir", "mkfifo", "mknod", "mktemp", "mv", "realpath", "rm", "rmdir", "shred", "sync", "touch", "truncate", "vdir", "b2sum", "base32", "base64", "cat", "cksum", "comm", "csplit", "cut", "expand", "fmt", "fold", "head", "join", "md5sum", "nl", "numfmt", "od", "paste", "ptx", "pr", "sha1sum", "sha224sum", "sha256sum", "sha384sum", "sha512sum", "shuf", "sort", "split", "sum", "tac", "tail", "tr", "tsort", "unexpand", "uniq", "wc", "arch", "basename", "chroot", "date", "dirname", "du", "echo", "env", "expr", "factor",
      // "false", // keyword literal already
      "groups", "hostid", "id", "link", "logname", "nice", "nohup", "nproc", "pathchk", "pinky", "printenv", "printf", "pwd", "readlink", "runcon", "seq", "sleep", "stat", "stdbuf", "stty", "tee", "test", "timeout",
      // "true", // keyword literal already
      "tty", "uname", "unlink", "uptime", "users", "who", "whoami", "yes"];
      return {
        name: 'Bash',
        aliases: ['sh'],
        keywords: {
          $pattern: /\b[a-z][a-z0-9._-]+\b/,
          keyword: KEYWORDS,
          literal: LITERALS,
          built_in: [...SHELL_BUILT_INS, ...BASH_BUILT_INS,
          // Shell modifiers
          "set", "shopt", ...ZSH_BUILT_INS, ...GNU_CORE_UTILS]
        },
        contains: [KNOWN_SHEBANG,
        // to catch known shells and boost relevancy
        hljs.SHEBANG(),
        // to catch unknown shells but still highlight the shebang
        FUNCTION, ARITHMETIC, hljs.HASH_COMMENT_MODE, HERE_DOC, PATH_MODE, QUOTE_STRING, ESCAPED_QUOTE, APOS_STRING, VAR]
      };
    }
    bash_1 = bash;
    return bash_1;
  }

  /*
  Language: C
  Category: common, system
  Website: https://en.wikipedia.org/wiki/C_(programming_language)
  */
  var c_1;
  var hasRequiredC;
  function requireC() {
    if (hasRequiredC) return c_1;
    hasRequiredC = 1;
    /** @type LanguageFn */
    function c(hljs) {
      const regex = hljs.regex;
      // added for historic reasons because `hljs.C_LINE_COMMENT_MODE` does
      // not include such support nor can we be sure all the grammars depending
      // on it would desire this behavior
      const C_LINE_COMMENT_MODE = hljs.COMMENT('//', '$', {
        contains: [{
          begin: /\\\n/
        }]
      });
      const DECLTYPE_AUTO_RE = 'decltype\\(auto\\)';
      const NAMESPACE_RE = '[a-zA-Z_]\\w*::';
      const TEMPLATE_ARGUMENT_RE = '<[^<>]+>';
      const FUNCTION_TYPE_RE = '(' + DECLTYPE_AUTO_RE + '|' + regex.optional(NAMESPACE_RE) + '[a-zA-Z_]\\w*' + regex.optional(TEMPLATE_ARGUMENT_RE) + ')';
      const TYPES = {
        className: 'type',
        variants: [{
          begin: '\\b[a-z\\d_]*_t\\b'
        }, {
          match: /\batomic_[a-z]{3,6}\b/
        }]
      };

      // https://en.cppreference.com/w/cpp/language/escape
      // \\ \x \xFF \u2837 \u00323747 \374
      const CHARACTER_ESCAPES = '\\\\(x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4,8}|[0-7]{3}|\\S)';
      const STRINGS = {
        className: 'string',
        variants: [{
          begin: '(u8?|U|L)?"',
          end: '"',
          illegal: '\\n',
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: '(u8?|U|L)?\'(' + CHARACTER_ESCAPES + "|.)",
          end: '\'',
          illegal: '.'
        }, hljs.END_SAME_AS_BEGIN({
          begin: /(?:u8?|U|L)?R"([^()\\ ]{0,16})\(/,
          end: /\)([^()\\ ]{0,16})"/
        })]
      };
      const NUMBERS = {
        className: 'number',
        variants: [{
          begin: '\\b(0b[01\']+)'
        }, {
          begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)((ll|LL|l|L)(u|U)?|(u|U)(ll|LL|l|L)?|f|F|b|B)'
        }, {
          begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)'
        }],
        relevance: 0
      };
      const PREPROCESSOR = {
        className: 'meta',
        begin: /#\s*[a-z]+\b/,
        end: /$/,
        keywords: {
          keyword: 'if else elif endif define undef warning error line ' + 'pragma _Pragma ifdef ifndef include'
        },
        contains: [{
          begin: /\\\n/,
          relevance: 0
        }, hljs.inherit(STRINGS, {
          className: 'string'
        }), {
          className: 'string',
          begin: /<.*?>/
        }, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
      };
      const TITLE_MODE = {
        className: 'title',
        begin: regex.optional(NAMESPACE_RE) + hljs.IDENT_RE,
        relevance: 0
      };
      const FUNCTION_TITLE = regex.optional(NAMESPACE_RE) + hljs.IDENT_RE + '\\s*\\(';
      const C_KEYWORDS = ["asm", "auto", "break", "case", "continue", "default", "do", "else", "enum", "extern", "for", "fortran", "goto", "if", "inline", "register", "restrict", "return", "sizeof", "struct", "switch", "typedef", "union", "volatile", "while", "_Alignas", "_Alignof", "_Atomic", "_Generic", "_Noreturn", "_Static_assert", "_Thread_local",
      // aliases
      "alignas", "alignof", "noreturn", "static_assert", "thread_local",
      // not a C keyword but is, for all intents and purposes, treated exactly like one.
      "_Pragma"];
      const C_TYPES = ["float", "double", "signed", "unsigned", "int", "short", "long", "char", "void", "_Bool", "_Complex", "_Imaginary", "_Decimal32", "_Decimal64", "_Decimal128",
      // modifiers
      "const", "static",
      // aliases
      "complex", "bool", "imaginary"];
      const KEYWORDS = {
        keyword: C_KEYWORDS,
        type: C_TYPES,
        literal: 'true false NULL',
        // TODO: apply hinting work similar to what was done in cpp.js
        built_in: 'std string wstring cin cout cerr clog stdin stdout stderr stringstream istringstream ostringstream ' + 'auto_ptr deque list queue stack vector map set pair bitset multiset multimap unordered_set ' + 'unordered_map unordered_multiset unordered_multimap priority_queue make_pair array shared_ptr abort terminate abs acos ' + 'asin atan2 atan calloc ceil cosh cos exit exp fabs floor fmod fprintf fputs free frexp ' + 'fscanf future isalnum isalpha iscntrl isdigit isgraph islower isprint ispunct isspace isupper ' + 'isxdigit tolower toupper labs ldexp log10 log malloc realloc memchr memcmp memcpy memset modf pow ' + 'printf putchar puts scanf sinh sin snprintf sprintf sqrt sscanf strcat strchr strcmp ' + 'strcpy strcspn strlen strncat strncmp strncpy strpbrk strrchr strspn strstr tanh tan ' + 'vfprintf vprintf vsprintf endl initializer_list unique_ptr'
      };
      const EXPRESSION_CONTAINS = [PREPROCESSOR, TYPES, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, NUMBERS, STRINGS];
      const EXPRESSION_CONTEXT = {
        // This mode covers expression context where we can't expect a function
        // definition and shouldn't highlight anything that looks like one:
        // `return some()`, `else if()`, `(x*sum(1, 2))`
        variants: [{
          begin: /=/,
          end: /;/
        }, {
          begin: /\(/,
          end: /\)/
        }, {
          beginKeywords: 'new throw return else',
          end: /;/
        }],
        keywords: KEYWORDS,
        contains: EXPRESSION_CONTAINS.concat([{
          begin: /\(/,
          end: /\)/,
          keywords: KEYWORDS,
          contains: EXPRESSION_CONTAINS.concat(['self']),
          relevance: 0
        }]),
        relevance: 0
      };
      const FUNCTION_DECLARATION = {
        begin: '(' + FUNCTION_TYPE_RE + '[\\*&\\s]+)+' + FUNCTION_TITLE,
        returnBegin: true,
        end: /[{;=]/,
        excludeEnd: true,
        keywords: KEYWORDS,
        illegal: /[^\w\s\*&:<>.]/,
        contains: [{
          // to prevent it from being confused as the function title
          begin: DECLTYPE_AUTO_RE,
          keywords: KEYWORDS,
          relevance: 0
        }, {
          begin: FUNCTION_TITLE,
          returnBegin: true,
          contains: [hljs.inherit(TITLE_MODE, {
            className: "title.function"
          })],
          relevance: 0
        },
        // allow for multiple declarations, e.g.:
        // extern void f(int), g(char);
        {
          relevance: 0,
          match: /,/
        }, {
          className: 'params',
          begin: /\(/,
          end: /\)/,
          keywords: KEYWORDS,
          relevance: 0,
          contains: [C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, STRINGS, NUMBERS, TYPES,
          // Count matching parentheses.
          {
            begin: /\(/,
            end: /\)/,
            keywords: KEYWORDS,
            relevance: 0,
            contains: ['self', C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, STRINGS, NUMBERS, TYPES]
          }]
        }, TYPES, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, PREPROCESSOR]
      };
      return {
        name: "C",
        aliases: ['h'],
        keywords: KEYWORDS,
        // Until differentiations are added between `c` and `cpp`, `c` will
        // not be auto-detected to avoid auto-detect conflicts between C and C++
        disableAutodetect: true,
        illegal: '</',
        contains: [].concat(EXPRESSION_CONTEXT, FUNCTION_DECLARATION, EXPRESSION_CONTAINS, [PREPROCESSOR, {
          begin: hljs.IDENT_RE + '::',
          keywords: KEYWORDS
        }, {
          className: 'class',
          beginKeywords: 'enum class struct union',
          end: /[{;:<>=]/,
          contains: [{
            beginKeywords: "final class struct"
          }, hljs.TITLE_MODE]
        }]),
        exports: {
          preprocessor: PREPROCESSOR,
          strings: STRINGS,
          keywords: KEYWORDS
        }
      };
    }
    c_1 = c;
    return c_1;
  }

  /*
  Language: C++
  Category: common, system
  Website: https://isocpp.org
  */
  var cpp_1;
  var hasRequiredCpp;
  function requireCpp() {
    if (hasRequiredCpp) return cpp_1;
    hasRequiredCpp = 1;
    /** @type LanguageFn */
    function cpp(hljs) {
      const regex = hljs.regex;
      // added for historic reasons because `hljs.C_LINE_COMMENT_MODE` does
      // not include such support nor can we be sure all the grammars depending
      // on it would desire this behavior
      const C_LINE_COMMENT_MODE = hljs.COMMENT('//', '$', {
        contains: [{
          begin: /\\\n/
        }]
      });
      const DECLTYPE_AUTO_RE = 'decltype\\(auto\\)';
      const NAMESPACE_RE = '[a-zA-Z_]\\w*::';
      const TEMPLATE_ARGUMENT_RE = '<[^<>]+>';
      const FUNCTION_TYPE_RE = '(?!struct)(' + DECLTYPE_AUTO_RE + '|' + regex.optional(NAMESPACE_RE) + '[a-zA-Z_]\\w*' + regex.optional(TEMPLATE_ARGUMENT_RE) + ')';
      const CPP_PRIMITIVE_TYPES = {
        className: 'type',
        begin: '\\b[a-z\\d_]*_t\\b'
      };

      // https://en.cppreference.com/w/cpp/language/escape
      // \\ \x \xFF \u2837 \u00323747 \374
      const CHARACTER_ESCAPES = '\\\\(x[0-9A-Fa-f]{2}|u[0-9A-Fa-f]{4,8}|[0-7]{3}|\\S)';
      const STRINGS = {
        className: 'string',
        variants: [{
          begin: '(u8?|U|L)?"',
          end: '"',
          illegal: '\\n',
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: '(u8?|U|L)?\'(' + CHARACTER_ESCAPES + '|.)',
          end: '\'',
          illegal: '.'
        }, hljs.END_SAME_AS_BEGIN({
          begin: /(?:u8?|U|L)?R"([^()\\ ]{0,16})\(/,
          end: /\)([^()\\ ]{0,16})"/
        })]
      };
      const NUMBERS = {
        className: 'number',
        variants: [{
          begin: '\\b(0b[01\']+)'
        }, {
          begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)((ll|LL|l|L)(u|U)?|(u|U)(ll|LL|l|L)?|f|F|b|B)'
        }, {
          begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)'
        }],
        relevance: 0
      };
      const PREPROCESSOR = {
        className: 'meta',
        begin: /#\s*[a-z]+\b/,
        end: /$/,
        keywords: {
          keyword: 'if else elif endif define undef warning error line ' + 'pragma _Pragma ifdef ifndef include'
        },
        contains: [{
          begin: /\\\n/,
          relevance: 0
        }, hljs.inherit(STRINGS, {
          className: 'string'
        }), {
          className: 'string',
          begin: /<.*?>/
        }, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
      };
      const TITLE_MODE = {
        className: 'title',
        begin: regex.optional(NAMESPACE_RE) + hljs.IDENT_RE,
        relevance: 0
      };
      const FUNCTION_TITLE = regex.optional(NAMESPACE_RE) + hljs.IDENT_RE + '\\s*\\(';

      // https://en.cppreference.com/w/cpp/keyword
      const RESERVED_KEYWORDS = ['alignas', 'alignof', 'and', 'and_eq', 'asm', 'atomic_cancel', 'atomic_commit', 'atomic_noexcept', 'auto', 'bitand', 'bitor', 'break', 'case', 'catch', 'class', 'co_await', 'co_return', 'co_yield', 'compl', 'concept', 'const_cast|10', 'consteval', 'constexpr', 'constinit', 'continue', 'decltype', 'default', 'delete', 'do', 'dynamic_cast|10', 'else', 'enum', 'explicit', 'export', 'extern', 'false', 'final', 'for', 'friend', 'goto', 'if', 'import', 'inline', 'module', 'mutable', 'namespace', 'new', 'noexcept', 'not', 'not_eq', 'nullptr', 'operator', 'or', 'or_eq', 'override', 'private', 'protected', 'public', 'reflexpr', 'register', 'reinterpret_cast|10', 'requires', 'return', 'sizeof', 'static_assert', 'static_cast|10', 'struct', 'switch', 'synchronized', 'template', 'this', 'thread_local', 'throw', 'transaction_safe', 'transaction_safe_dynamic', 'true', 'try', 'typedef', 'typeid', 'typename', 'union', 'using', 'virtual', 'volatile', 'while', 'xor', 'xor_eq'];

      // https://en.cppreference.com/w/cpp/keyword
      const RESERVED_TYPES = ['bool', 'char', 'char16_t', 'char32_t', 'char8_t', 'double', 'float', 'int', 'long', 'short', 'void', 'wchar_t', 'unsigned', 'signed', 'const', 'static'];
      const TYPE_HINTS = ['any', 'auto_ptr', 'barrier', 'binary_semaphore', 'bitset', 'complex', 'condition_variable', 'condition_variable_any', 'counting_semaphore', 'deque', 'false_type', 'future', 'imaginary', 'initializer_list', 'istringstream', 'jthread', 'latch', 'lock_guard', 'multimap', 'multiset', 'mutex', 'optional', 'ostringstream', 'packaged_task', 'pair', 'promise', 'priority_queue', 'queue', 'recursive_mutex', 'recursive_timed_mutex', 'scoped_lock', 'set', 'shared_future', 'shared_lock', 'shared_mutex', 'shared_timed_mutex', 'shared_ptr', 'stack', 'string_view', 'stringstream', 'timed_mutex', 'thread', 'true_type', 'tuple', 'unique_lock', 'unique_ptr', 'unordered_map', 'unordered_multimap', 'unordered_multiset', 'unordered_set', 'variant', 'vector', 'weak_ptr', 'wstring', 'wstring_view'];
      const FUNCTION_HINTS = ['abort', 'abs', 'acos', 'apply', 'as_const', 'asin', 'atan', 'atan2', 'calloc', 'ceil', 'cerr', 'cin', 'clog', 'cos', 'cosh', 'cout', 'declval', 'endl', 'exchange', 'exit', 'exp', 'fabs', 'floor', 'fmod', 'forward', 'fprintf', 'fputs', 'free', 'frexp', 'fscanf', 'future', 'invoke', 'isalnum', 'isalpha', 'iscntrl', 'isdigit', 'isgraph', 'islower', 'isprint', 'ispunct', 'isspace', 'isupper', 'isxdigit', 'labs', 'launder', 'ldexp', 'log', 'log10', 'make_pair', 'make_shared', 'make_shared_for_overwrite', 'make_tuple', 'make_unique', 'malloc', 'memchr', 'memcmp', 'memcpy', 'memset', 'modf', 'move', 'pow', 'printf', 'putchar', 'puts', 'realloc', 'scanf', 'sin', 'sinh', 'snprintf', 'sprintf', 'sqrt', 'sscanf', 'std', 'stderr', 'stdin', 'stdout', 'strcat', 'strchr', 'strcmp', 'strcpy', 'strcspn', 'strlen', 'strncat', 'strncmp', 'strncpy', 'strpbrk', 'strrchr', 'strspn', 'strstr', 'swap', 'tan', 'tanh', 'terminate', 'to_underlying', 'tolower', 'toupper', 'vfprintf', 'visit', 'vprintf', 'vsprintf'];
      const LITERALS = ['NULL', 'false', 'nullopt', 'nullptr', 'true'];

      // https://en.cppreference.com/w/cpp/keyword
      const BUILT_IN = ['_Pragma'];
      const CPP_KEYWORDS = {
        type: RESERVED_TYPES,
        keyword: RESERVED_KEYWORDS,
        literal: LITERALS,
        built_in: BUILT_IN,
        _type_hints: TYPE_HINTS
      };
      const FUNCTION_DISPATCH = {
        className: 'function.dispatch',
        relevance: 0,
        keywords: {
          // Only for relevance, not highlighting.
          _hint: FUNCTION_HINTS
        },
        begin: regex.concat(/\b/, /(?!decltype)/, /(?!if)/, /(?!for)/, /(?!switch)/, /(?!while)/, hljs.IDENT_RE, regex.lookahead(/(<[^<>]+>|)\s*\(/))
      };
      const EXPRESSION_CONTAINS = [FUNCTION_DISPATCH, PREPROCESSOR, CPP_PRIMITIVE_TYPES, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, NUMBERS, STRINGS];
      const EXPRESSION_CONTEXT = {
        // This mode covers expression context where we can't expect a function
        // definition and shouldn't highlight anything that looks like one:
        // `return some()`, `else if()`, `(x*sum(1, 2))`
        variants: [{
          begin: /=/,
          end: /;/
        }, {
          begin: /\(/,
          end: /\)/
        }, {
          beginKeywords: 'new throw return else',
          end: /;/
        }],
        keywords: CPP_KEYWORDS,
        contains: EXPRESSION_CONTAINS.concat([{
          begin: /\(/,
          end: /\)/,
          keywords: CPP_KEYWORDS,
          contains: EXPRESSION_CONTAINS.concat(['self']),
          relevance: 0
        }]),
        relevance: 0
      };
      const FUNCTION_DECLARATION = {
        className: 'function',
        begin: '(' + FUNCTION_TYPE_RE + '[\\*&\\s]+)+' + FUNCTION_TITLE,
        returnBegin: true,
        end: /[{;=]/,
        excludeEnd: true,
        keywords: CPP_KEYWORDS,
        illegal: /[^\w\s\*&:<>.]/,
        contains: [{
          // to prevent it from being confused as the function title
          begin: DECLTYPE_AUTO_RE,
          keywords: CPP_KEYWORDS,
          relevance: 0
        }, {
          begin: FUNCTION_TITLE,
          returnBegin: true,
          contains: [TITLE_MODE],
          relevance: 0
        },
        // needed because we do not have look-behind on the below rule
        // to prevent it from grabbing the final : in a :: pair
        {
          begin: /::/,
          relevance: 0
        },
        // initializers
        {
          begin: /:/,
          endsWithParent: true,
          contains: [STRINGS, NUMBERS]
        },
        // allow for multiple declarations, e.g.:
        // extern void f(int), g(char);
        {
          relevance: 0,
          match: /,/
        }, {
          className: 'params',
          begin: /\(/,
          end: /\)/,
          keywords: CPP_KEYWORDS,
          relevance: 0,
          contains: [C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, STRINGS, NUMBERS, CPP_PRIMITIVE_TYPES,
          // Count matching parentheses.
          {
            begin: /\(/,
            end: /\)/,
            keywords: CPP_KEYWORDS,
            relevance: 0,
            contains: ['self', C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, STRINGS, NUMBERS, CPP_PRIMITIVE_TYPES]
          }]
        }, CPP_PRIMITIVE_TYPES, C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, PREPROCESSOR]
      };
      return {
        name: 'C++',
        aliases: ['cc', 'c++', 'h++', 'hpp', 'hh', 'hxx', 'cxx'],
        keywords: CPP_KEYWORDS,
        illegal: '</',
        classNameAliases: {
          'function.dispatch': 'built_in'
        },
        contains: [].concat(EXPRESSION_CONTEXT, FUNCTION_DECLARATION, FUNCTION_DISPATCH, EXPRESSION_CONTAINS, [PREPROCESSOR, {
          // containers: ie, `vector <int> rooms (9);`
          begin: '\\b(deque|list|queue|priority_queue|pair|stack|vector|map|set|bitset|multiset|multimap|unordered_map|unordered_set|unordered_multiset|unordered_multimap|array|tuple|optional|variant|function)\\s*<(?!<)',
          end: '>',
          keywords: CPP_KEYWORDS,
          contains: ['self', CPP_PRIMITIVE_TYPES]
        }, {
          begin: hljs.IDENT_RE + '::',
          keywords: CPP_KEYWORDS
        }, {
          match: [
          // extra complexity to deal with `enum class` and `enum struct`
          /\b(?:enum(?:\s+(?:class|struct))?|class|struct|union)/, /\s+/, /\w+/],
          className: {
            1: 'keyword',
            3: 'title.class'
          }
        }])
      };
    }
    cpp_1 = cpp;
    return cpp_1;
  }

  /*
  Language: C#
  Author: Jason Diamond <jason@diamond.name>
  Contributor: Nicolas LLOBERA <nllobera@gmail.com>, Pieter Vantorre <pietervantorre@gmail.com>, David Pine <david.pine@microsoft.com>
  Website: https://docs.microsoft.com/dotnet/csharp/
  Category: common
  */
  var csharp_1;
  var hasRequiredCsharp;
  function requireCsharp() {
    if (hasRequiredCsharp) return csharp_1;
    hasRequiredCsharp = 1;
    /** @type LanguageFn */
    function csharp(hljs) {
      const BUILT_IN_KEYWORDS = ['bool', 'byte', 'char', 'decimal', 'delegate', 'double', 'dynamic', 'enum', 'float', 'int', 'long', 'nint', 'nuint', 'object', 'sbyte', 'short', 'string', 'ulong', 'uint', 'ushort'];
      const FUNCTION_MODIFIERS = ['public', 'private', 'protected', 'static', 'internal', 'protected', 'abstract', 'async', 'extern', 'override', 'unsafe', 'virtual', 'new', 'sealed', 'partial'];
      const LITERAL_KEYWORDS = ['default', 'false', 'null', 'true'];
      const NORMAL_KEYWORDS = ['abstract', 'as', 'base', 'break', 'case', 'catch', 'class', 'const', 'continue', 'do', 'else', 'event', 'explicit', 'extern', 'finally', 'fixed', 'for', 'foreach', 'goto', 'if', 'implicit', 'in', 'interface', 'internal', 'is', 'lock', 'namespace', 'new', 'operator', 'out', 'override', 'params', 'private', 'protected', 'public', 'readonly', 'record', 'ref', 'return', 'scoped', 'sealed', 'sizeof', 'stackalloc', 'static', 'struct', 'switch', 'this', 'throw', 'try', 'typeof', 'unchecked', 'unsafe', 'using', 'virtual', 'void', 'volatile', 'while'];
      const CONTEXTUAL_KEYWORDS = ['add', 'alias', 'and', 'ascending', 'async', 'await', 'by', 'descending', 'equals', 'from', 'get', 'global', 'group', 'init', 'into', 'join', 'let', 'nameof', 'not', 'notnull', 'on', 'or', 'orderby', 'partial', 'remove', 'select', 'set', 'unmanaged', 'value|0', 'var', 'when', 'where', 'with', 'yield'];
      const KEYWORDS = {
        keyword: NORMAL_KEYWORDS.concat(CONTEXTUAL_KEYWORDS),
        built_in: BUILT_IN_KEYWORDS,
        literal: LITERAL_KEYWORDS
      };
      const TITLE_MODE = hljs.inherit(hljs.TITLE_MODE, {
        begin: '[a-zA-Z](\\.?\\w)*'
      });
      const NUMBERS = {
        className: 'number',
        variants: [{
          begin: '\\b(0b[01\']+)'
        }, {
          begin: '(-?)\\b([\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)(u|U|l|L|ul|UL|f|F|b|B)'
        }, {
          begin: '(-?)(\\b0[xX][a-fA-F0-9\']+|(\\b[\\d\']+(\\.[\\d\']*)?|\\.[\\d\']+)([eE][-+]?[\\d\']+)?)'
        }],
        relevance: 0
      };
      const VERBATIM_STRING = {
        className: 'string',
        begin: '@"',
        end: '"',
        contains: [{
          begin: '""'
        }]
      };
      const VERBATIM_STRING_NO_LF = hljs.inherit(VERBATIM_STRING, {
        illegal: /\n/
      });
      const SUBST = {
        className: 'subst',
        begin: /\{/,
        end: /\}/,
        keywords: KEYWORDS
      };
      const SUBST_NO_LF = hljs.inherit(SUBST, {
        illegal: /\n/
      });
      const INTERPOLATED_STRING = {
        className: 'string',
        begin: /\$"/,
        end: '"',
        illegal: /\n/,
        contains: [{
          begin: /\{\{/
        }, {
          begin: /\}\}/
        }, hljs.BACKSLASH_ESCAPE, SUBST_NO_LF]
      };
      const INTERPOLATED_VERBATIM_STRING = {
        className: 'string',
        begin: /\$@"/,
        end: '"',
        contains: [{
          begin: /\{\{/
        }, {
          begin: /\}\}/
        }, {
          begin: '""'
        }, SUBST]
      };
      const INTERPOLATED_VERBATIM_STRING_NO_LF = hljs.inherit(INTERPOLATED_VERBATIM_STRING, {
        illegal: /\n/,
        contains: [{
          begin: /\{\{/
        }, {
          begin: /\}\}/
        }, {
          begin: '""'
        }, SUBST_NO_LF]
      });
      SUBST.contains = [INTERPOLATED_VERBATIM_STRING, INTERPOLATED_STRING, VERBATIM_STRING, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, NUMBERS, hljs.C_BLOCK_COMMENT_MODE];
      SUBST_NO_LF.contains = [INTERPOLATED_VERBATIM_STRING_NO_LF, INTERPOLATED_STRING, VERBATIM_STRING_NO_LF, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, NUMBERS, hljs.inherit(hljs.C_BLOCK_COMMENT_MODE, {
        illegal: /\n/
      })];
      const STRING = {
        variants: [INTERPOLATED_VERBATIM_STRING, INTERPOLATED_STRING, VERBATIM_STRING, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE]
      };
      const GENERIC_MODIFIER = {
        begin: "<",
        end: ">",
        contains: [{
          beginKeywords: "in out"
        }, TITLE_MODE]
      };
      const TYPE_IDENT_RE = hljs.IDENT_RE + '(<' + hljs.IDENT_RE + '(\\s*,\\s*' + hljs.IDENT_RE + ')*>)?(\\[\\])?';
      const AT_IDENTIFIER = {
        // prevents expressions like `@class` from incorrect flagging
        // `class` as a keyword
        begin: "@" + hljs.IDENT_RE,
        relevance: 0
      };
      return {
        name: 'C#',
        aliases: ['cs', 'c#'],
        keywords: KEYWORDS,
        illegal: /::/,
        contains: [hljs.COMMENT('///', '$', {
          returnBegin: true,
          contains: [{
            className: 'doctag',
            variants: [{
              begin: '///',
              relevance: 0
            }, {
              begin: '<!--|-->'
            }, {
              begin: '</?',
              end: '>'
            }]
          }]
        }), hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, {
          className: 'meta',
          begin: '#',
          end: '$',
          keywords: {
            keyword: 'if else elif endif define undef warning error line region endregion pragma checksum'
          }
        }, STRING, NUMBERS, {
          beginKeywords: 'class interface',
          relevance: 0,
          end: /[{;=]/,
          illegal: /[^\s:,]/,
          contains: [{
            beginKeywords: "where class"
          }, TITLE_MODE, GENERIC_MODIFIER, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, {
          beginKeywords: 'namespace',
          relevance: 0,
          end: /[{;=]/,
          illegal: /[^\s:]/,
          contains: [TITLE_MODE, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, {
          beginKeywords: 'record',
          relevance: 0,
          end: /[{;=]/,
          illegal: /[^\s:]/,
          contains: [TITLE_MODE, GENERIC_MODIFIER, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, {
          // [Attributes("")]
          className: 'meta',
          begin: '^\\s*\\[(?=[\\w])',
          excludeBegin: true,
          end: '\\]',
          excludeEnd: true,
          contains: [{
            className: 'string',
            begin: /"/,
            end: /"/
          }]
        }, {
          // Expression keywords prevent 'keyword Name(...)' from being
          // recognized as a function definition
          beginKeywords: 'new return throw await else',
          relevance: 0
        }, {
          className: 'function',
          begin: '(' + TYPE_IDENT_RE + '\\s+)+' + hljs.IDENT_RE + '\\s*(<[^=]+>\\s*)?\\(',
          returnBegin: true,
          end: /\s*[{;=]/,
          excludeEnd: true,
          keywords: KEYWORDS,
          contains: [
          // prevents these from being highlighted `title`
          {
            beginKeywords: FUNCTION_MODIFIERS.join(" "),
            relevance: 0
          }, {
            begin: hljs.IDENT_RE + '\\s*(<[^=]+>\\s*)?\\(',
            returnBegin: true,
            contains: [hljs.TITLE_MODE, GENERIC_MODIFIER],
            relevance: 0
          }, {
            match: /\(\)/
          }, {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            excludeBegin: true,
            excludeEnd: true,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [STRING, NUMBERS, hljs.C_BLOCK_COMMENT_MODE]
          }, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, AT_IDENTIFIER]
      };
    }
    csharp_1 = csharp;
    return csharp_1;
  }

  var css_1;
  var hasRequiredCss;
  function requireCss() {
    if (hasRequiredCss) return css_1;
    hasRequiredCss = 1;
    const MODES = hljs => {
      return {
        IMPORTANT: {
          scope: 'meta',
          begin: '!important'
        },
        BLOCK_COMMENT: hljs.C_BLOCK_COMMENT_MODE,
        HEXCOLOR: {
          scope: 'number',
          begin: /#(([0-9a-fA-F]{3,4})|(([0-9a-fA-F]{2}){3,4}))\b/
        },
        FUNCTION_DISPATCH: {
          className: "built_in",
          begin: /[\w-]+(?=\()/
        },
        ATTRIBUTE_SELECTOR_MODE: {
          scope: 'selector-attr',
          begin: /\[/,
          end: /\]/,
          illegal: '$',
          contains: [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE]
        },
        CSS_NUMBER_MODE: {
          scope: 'number',
          begin: hljs.NUMBER_RE + '(' + '%|em|ex|ch|rem' + '|vw|vh|vmin|vmax' + '|cm|mm|in|pt|pc|px' + '|deg|grad|rad|turn' + '|s|ms' + '|Hz|kHz' + '|dpi|dpcm|dppx' + ')?',
          relevance: 0
        },
        CSS_VARIABLE: {
          className: "attr",
          begin: /--[A-Za-z][A-Za-z0-9_-]*/
        }
      };
    };
    const TAGS = ['a', 'abbr', 'address', 'article', 'aside', 'audio', 'b', 'blockquote', 'body', 'button', 'canvas', 'caption', 'cite', 'code', 'dd', 'del', 'details', 'dfn', 'div', 'dl', 'dt', 'em', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'mark', 'menu', 'nav', 'object', 'ol', 'p', 'q', 'quote', 'samp', 'section', 'span', 'strong', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'ul', 'var', 'video'];
    const MEDIA_FEATURES = ['any-hover', 'any-pointer', 'aspect-ratio', 'color', 'color-gamut', 'color-index', 'device-aspect-ratio', 'device-height', 'device-width', 'display-mode', 'forced-colors', 'grid', 'height', 'hover', 'inverted-colors', 'monochrome', 'orientation', 'overflow-block', 'overflow-inline', 'pointer', 'prefers-color-scheme', 'prefers-contrast', 'prefers-reduced-motion', 'prefers-reduced-transparency', 'resolution', 'scan', 'scripting', 'update', 'width',
    // TODO: find a better solution?
    'min-width', 'max-width', 'min-height', 'max-height'];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-classes
    const PSEUDO_CLASSES = ['active', 'any-link', 'blank', 'checked', 'current', 'default', 'defined', 'dir',
    // dir()
    'disabled', 'drop', 'empty', 'enabled', 'first', 'first-child', 'first-of-type', 'fullscreen', 'future', 'focus', 'focus-visible', 'focus-within', 'has',
    // has()
    'host',
    // host or host()
    'host-context',
    // host-context()
    'hover', 'indeterminate', 'in-range', 'invalid', 'is',
    // is()
    'lang',
    // lang()
    'last-child', 'last-of-type', 'left', 'link', 'local-link', 'not',
    // not()
    'nth-child',
    // nth-child()
    'nth-col',
    // nth-col()
    'nth-last-child',
    // nth-last-child()
    'nth-last-col',
    // nth-last-col()
    'nth-last-of-type',
    //nth-last-of-type()
    'nth-of-type',
    //nth-of-type()
    'only-child', 'only-of-type', 'optional', 'out-of-range', 'past', 'placeholder-shown', 'read-only', 'read-write', 'required', 'right', 'root', 'scope', 'target', 'target-within', 'user-invalid', 'valid', 'visited', 'where' // where()
    ];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-elements
    const PSEUDO_ELEMENTS = ['after', 'backdrop', 'before', 'cue', 'cue-region', 'first-letter', 'first-line', 'grammar-error', 'marker', 'part', 'placeholder', 'selection', 'slotted', 'spelling-error'];
    const ATTRIBUTES = ['align-content', 'align-items', 'align-self', 'all', 'animation', 'animation-delay', 'animation-direction', 'animation-duration', 'animation-fill-mode', 'animation-iteration-count', 'animation-name', 'animation-play-state', 'animation-timing-function', 'backface-visibility', 'background', 'background-attachment', 'background-blend-mode', 'background-clip', 'background-color', 'background-image', 'background-origin', 'background-position', 'background-repeat', 'background-size', 'block-size', 'border', 'border-block', 'border-block-color', 'border-block-end', 'border-block-end-color', 'border-block-end-style', 'border-block-end-width', 'border-block-start', 'border-block-start-color', 'border-block-start-style', 'border-block-start-width', 'border-block-style', 'border-block-width', 'border-bottom', 'border-bottom-color', 'border-bottom-left-radius', 'border-bottom-right-radius', 'border-bottom-style', 'border-bottom-width', 'border-collapse', 'border-color', 'border-image', 'border-image-outset', 'border-image-repeat', 'border-image-slice', 'border-image-source', 'border-image-width', 'border-inline', 'border-inline-color', 'border-inline-end', 'border-inline-end-color', 'border-inline-end-style', 'border-inline-end-width', 'border-inline-start', 'border-inline-start-color', 'border-inline-start-style', 'border-inline-start-width', 'border-inline-style', 'border-inline-width', 'border-left', 'border-left-color', 'border-left-style', 'border-left-width', 'border-radius', 'border-right', 'border-right-color', 'border-right-style', 'border-right-width', 'border-spacing', 'border-style', 'border-top', 'border-top-color', 'border-top-left-radius', 'border-top-right-radius', 'border-top-style', 'border-top-width', 'border-width', 'bottom', 'box-decoration-break', 'box-shadow', 'box-sizing', 'break-after', 'break-before', 'break-inside', 'caption-side', 'caret-color', 'clear', 'clip', 'clip-path', 'clip-rule', 'color', 'column-count', 'column-fill', 'column-gap', 'column-rule', 'column-rule-color', 'column-rule-style', 'column-rule-width', 'column-span', 'column-width', 'columns', 'contain', 'content', 'content-visibility', 'counter-increment', 'counter-reset', 'cue', 'cue-after', 'cue-before', 'cursor', 'direction', 'display', 'empty-cells', 'filter', 'flex', 'flex-basis', 'flex-direction', 'flex-flow', 'flex-grow', 'flex-shrink', 'flex-wrap', 'float', 'flow', 'font', 'font-display', 'font-family', 'font-feature-settings', 'font-kerning', 'font-language-override', 'font-size', 'font-size-adjust', 'font-smoothing', 'font-stretch', 'font-style', 'font-synthesis', 'font-variant', 'font-variant-caps', 'font-variant-east-asian', 'font-variant-ligatures', 'font-variant-numeric', 'font-variant-position', 'font-variation-settings', 'font-weight', 'gap', 'glyph-orientation-vertical', 'grid', 'grid-area', 'grid-auto-columns', 'grid-auto-flow', 'grid-auto-rows', 'grid-column', 'grid-column-end', 'grid-column-start', 'grid-gap', 'grid-row', 'grid-row-end', 'grid-row-start', 'grid-template', 'grid-template-areas', 'grid-template-columns', 'grid-template-rows', 'hanging-punctuation', 'height', 'hyphens', 'icon', 'image-orientation', 'image-rendering', 'image-resolution', 'ime-mode', 'inline-size', 'isolation', 'justify-content', 'left', 'letter-spacing', 'line-break', 'line-height', 'list-style', 'list-style-image', 'list-style-position', 'list-style-type', 'margin', 'margin-block', 'margin-block-end', 'margin-block-start', 'margin-bottom', 'margin-inline', 'margin-inline-end', 'margin-inline-start', 'margin-left', 'margin-right', 'margin-top', 'marks', 'mask', 'mask-border', 'mask-border-mode', 'mask-border-outset', 'mask-border-repeat', 'mask-border-slice', 'mask-border-source', 'mask-border-width', 'mask-clip', 'mask-composite', 'mask-image', 'mask-mode', 'mask-origin', 'mask-position', 'mask-repeat', 'mask-size', 'mask-type', 'max-block-size', 'max-height', 'max-inline-size', 'max-width', 'min-block-size', 'min-height', 'min-inline-size', 'min-width', 'mix-blend-mode', 'nav-down', 'nav-index', 'nav-left', 'nav-right', 'nav-up', 'none', 'normal', 'object-fit', 'object-position', 'opacity', 'order', 'orphans', 'outline', 'outline-color', 'outline-offset', 'outline-style', 'outline-width', 'overflow', 'overflow-wrap', 'overflow-x', 'overflow-y', 'padding', 'padding-block', 'padding-block-end', 'padding-block-start', 'padding-bottom', 'padding-inline', 'padding-inline-end', 'padding-inline-start', 'padding-left', 'padding-right', 'padding-top', 'page-break-after', 'page-break-before', 'page-break-inside', 'pause', 'pause-after', 'pause-before', 'perspective', 'perspective-origin', 'pointer-events', 'position', 'quotes', 'resize', 'rest', 'rest-after', 'rest-before', 'right', 'row-gap', 'scroll-margin', 'scroll-margin-block', 'scroll-margin-block-end', 'scroll-margin-block-start', 'scroll-margin-bottom', 'scroll-margin-inline', 'scroll-margin-inline-end', 'scroll-margin-inline-start', 'scroll-margin-left', 'scroll-margin-right', 'scroll-margin-top', 'scroll-padding', 'scroll-padding-block', 'scroll-padding-block-end', 'scroll-padding-block-start', 'scroll-padding-bottom', 'scroll-padding-inline', 'scroll-padding-inline-end', 'scroll-padding-inline-start', 'scroll-padding-left', 'scroll-padding-right', 'scroll-padding-top', 'scroll-snap-align', 'scroll-snap-stop', 'scroll-snap-type', 'scrollbar-color', 'scrollbar-gutter', 'scrollbar-width', 'shape-image-threshold', 'shape-margin', 'shape-outside', 'speak', 'speak-as', 'src',
    // @font-face
    'tab-size', 'table-layout', 'text-align', 'text-align-all', 'text-align-last', 'text-combine-upright', 'text-decoration', 'text-decoration-color', 'text-decoration-line', 'text-decoration-style', 'text-emphasis', 'text-emphasis-color', 'text-emphasis-position', 'text-emphasis-style', 'text-indent', 'text-justify', 'text-orientation', 'text-overflow', 'text-rendering', 'text-shadow', 'text-transform', 'text-underline-position', 'top', 'transform', 'transform-box', 'transform-origin', 'transform-style', 'transition', 'transition-delay', 'transition-duration', 'transition-property', 'transition-timing-function', 'unicode-bidi', 'vertical-align', 'visibility', 'voice-balance', 'voice-duration', 'voice-family', 'voice-pitch', 'voice-range', 'voice-rate', 'voice-stress', 'voice-volume', 'white-space', 'widows', 'width', 'will-change', 'word-break', 'word-spacing', 'word-wrap', 'writing-mode', 'z-index'
    // reverse makes sure longer attributes `font-weight` are matched fully
    // instead of getting false positives on say `font`
    ].reverse();

    /*
    Language: CSS
    Category: common, css, web
    Website: https://developer.mozilla.org/en-US/docs/Web/CSS
    */

    /** @type LanguageFn */
    function css(hljs) {
      const regex = hljs.regex;
      const modes = MODES(hljs);
      const VENDOR_PREFIX = {
        begin: /-(webkit|moz|ms|o)-(?=[a-z])/
      };
      const AT_MODIFIERS = "and or not only";
      const AT_PROPERTY_RE = /@-?\w[\w]*(-\w+)*/; // @-webkit-keyframes
      const IDENT_RE = '[a-zA-Z-][a-zA-Z0-9_-]*';
      const STRINGS = [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE];
      return {
        name: 'CSS',
        case_insensitive: true,
        illegal: /[=|'\$]/,
        keywords: {
          keyframePosition: "from to"
        },
        classNameAliases: {
          // for visual continuity with `tag {}` and because we
          // don't have a great class for this?
          keyframePosition: "selector-tag"
        },
        contains: [modes.BLOCK_COMMENT, VENDOR_PREFIX,
        // to recognize keyframe 40% etc which are outside the scope of our
        // attribute value mode
        modes.CSS_NUMBER_MODE, {
          className: 'selector-id',
          begin: /#[A-Za-z0-9_-]+/,
          relevance: 0
        }, {
          className: 'selector-class',
          begin: '\\.' + IDENT_RE,
          relevance: 0
        }, modes.ATTRIBUTE_SELECTOR_MODE, {
          className: 'selector-pseudo',
          variants: [{
            begin: ':(' + PSEUDO_CLASSES.join('|') + ')'
          }, {
            begin: ':(:)?(' + PSEUDO_ELEMENTS.join('|') + ')'
          }]
        },
        // we may actually need this (12/2020)
        // { // pseudo-selector params
        //   begin: /\(/,
        //   end: /\)/,
        //   contains: [ hljs.CSS_NUMBER_MODE ]
        // },
        modes.CSS_VARIABLE, {
          className: 'attribute',
          begin: '\\b(' + ATTRIBUTES.join('|') + ')\\b'
        },
        // attribute values
        {
          begin: /:/,
          end: /[;}{]/,
          contains: [modes.BLOCK_COMMENT, modes.HEXCOLOR, modes.IMPORTANT, modes.CSS_NUMBER_MODE, ...STRINGS,
          // needed to highlight these as strings and to avoid issues with
          // illegal characters that might be inside urls that would tigger the
          // languages illegal stack
          {
            begin: /(url|data-uri)\(/,
            end: /\)/,
            relevance: 0,
            // from keywords
            keywords: {
              built_in: "url data-uri"
            },
            contains: [...STRINGS, {
              className: "string",
              // any character other than `)` as in `url()` will be the start
              // of a string, which ends with `)` (from the parent mode)
              begin: /[^)]/,
              endsWithParent: true,
              excludeEnd: true
            }]
          }, modes.FUNCTION_DISPATCH]
        }, {
          begin: regex.lookahead(/@/),
          end: '[{;]',
          relevance: 0,
          illegal: /:/,
          // break on Less variables @var: ...
          contains: [{
            className: 'keyword',
            begin: AT_PROPERTY_RE
          }, {
            begin: /\s/,
            endsWithParent: true,
            excludeEnd: true,
            relevance: 0,
            keywords: {
              $pattern: /[a-z-]+/,
              keyword: AT_MODIFIERS,
              attribute: MEDIA_FEATURES.join(" ")
            },
            contains: [{
              begin: /[a-z-]+(?=:)/,
              className: "attribute"
            }, ...STRINGS, modes.CSS_NUMBER_MODE]
          }]
        }, {
          className: 'selector-tag',
          begin: '\\b(' + TAGS.join('|') + ')\\b'
        }]
      };
    }
    css_1 = css;
    return css_1;
  }

  /*
  Language: Markdown
  Requires: xml.js
  Author: John Crepezzi <john.crepezzi@gmail.com>
  Website: https://daringfireball.net/projects/markdown/
  Category: common, markup
  */
  var markdown_1;
  var hasRequiredMarkdown;
  function requireMarkdown() {
    if (hasRequiredMarkdown) return markdown_1;
    hasRequiredMarkdown = 1;
    function markdown(hljs) {
      const regex = hljs.regex;
      const INLINE_HTML = {
        begin: /<\/?[A-Za-z_]/,
        end: '>',
        subLanguage: 'xml',
        relevance: 0
      };
      const HORIZONTAL_RULE = {
        begin: '^[-\\*]{3,}',
        end: '$'
      };
      const CODE = {
        className: 'code',
        variants: [
        // TODO: fix to allow these to work with sublanguage also
        {
          begin: '(`{3,})[^`](.|\\n)*?\\1`*[ ]*'
        }, {
          begin: '(~{3,})[^~](.|\\n)*?\\1~*[ ]*'
        },
        // needed to allow markdown as a sublanguage to work
        {
          begin: '```',
          end: '```+[ ]*$'
        }, {
          begin: '~~~',
          end: '~~~+[ ]*$'
        }, {
          begin: '`.+?`'
        }, {
          begin: '(?=^( {4}|\\t))',
          // use contains to gobble up multiple lines to allow the block to be whatever size
          // but only have a single open/close tag vs one per line
          contains: [{
            begin: '^( {4}|\\t)',
            end: '(\\n)$'
          }],
          relevance: 0
        }]
      };
      const LIST = {
        className: 'bullet',
        begin: '^[ \t]*([*+-]|(\\d+\\.))(?=\\s+)',
        end: '\\s+',
        excludeEnd: true
      };
      const LINK_REFERENCE = {
        begin: /^\[[^\n]+\]:/,
        returnBegin: true,
        contains: [{
          className: 'symbol',
          begin: /\[/,
          end: /\]/,
          excludeBegin: true,
          excludeEnd: true
        }, {
          className: 'link',
          begin: /:\s*/,
          end: /$/,
          excludeBegin: true
        }]
      };
      const URL_SCHEME = /[A-Za-z][A-Za-z0-9+.-]*/;
      const LINK = {
        variants: [
        // too much like nested array access in so many languages
        // to have any real relevance
        {
          begin: /\[.+?\]\[.*?\]/,
          relevance: 0
        },
        // popular internet URLs
        {
          begin: /\[.+?\]\(((data|javascript|mailto):|(?:http|ftp)s?:\/\/).*?\)/,
          relevance: 2
        }, {
          begin: regex.concat(/\[.+?\]\(/, URL_SCHEME, /:\/\/.*?\)/),
          relevance: 2
        },
        // relative urls
        {
          begin: /\[.+?\]\([./?&#].*?\)/,
          relevance: 1
        },
        // whatever else, lower relevance (might not be a link at all)
        {
          begin: /\[.*?\]\(.*?\)/,
          relevance: 0
        }],
        returnBegin: true,
        contains: [{
          // empty strings for alt or link text
          match: /\[(?=\])/
        }, {
          className: 'string',
          relevance: 0,
          begin: '\\[',
          end: '\\]',
          excludeBegin: true,
          returnEnd: true
        }, {
          className: 'link',
          relevance: 0,
          begin: '\\]\\(',
          end: '\\)',
          excludeBegin: true,
          excludeEnd: true
        }, {
          className: 'symbol',
          relevance: 0,
          begin: '\\]\\[',
          end: '\\]',
          excludeBegin: true,
          excludeEnd: true
        }]
      };
      const BOLD = {
        className: 'strong',
        contains: [],
        // defined later
        variants: [{
          begin: /_{2}(?!\s)/,
          end: /_{2}/
        }, {
          begin: /\*{2}(?!\s)/,
          end: /\*{2}/
        }]
      };
      const ITALIC = {
        className: 'emphasis',
        contains: [],
        // defined later
        variants: [{
          begin: /\*(?![*\s])/,
          end: /\*/
        }, {
          begin: /_(?![_\s])/,
          end: /_/,
          relevance: 0
        }]
      };

      // 3 level deep nesting is not allowed because it would create confusion
      // in cases like `***testing***` because where we don't know if the last
      // `***` is starting a new bold/italic or finishing the last one
      const BOLD_WITHOUT_ITALIC = hljs.inherit(BOLD, {
        contains: []
      });
      const ITALIC_WITHOUT_BOLD = hljs.inherit(ITALIC, {
        contains: []
      });
      BOLD.contains.push(ITALIC_WITHOUT_BOLD);
      ITALIC.contains.push(BOLD_WITHOUT_ITALIC);
      let CONTAINABLE = [INLINE_HTML, LINK];
      [BOLD, ITALIC, BOLD_WITHOUT_ITALIC, ITALIC_WITHOUT_BOLD].forEach(m => {
        m.contains = m.contains.concat(CONTAINABLE);
      });
      CONTAINABLE = CONTAINABLE.concat(BOLD, ITALIC);
      const HEADER = {
        className: 'section',
        variants: [{
          begin: '^#{1,6}',
          end: '$',
          contains: CONTAINABLE
        }, {
          begin: '(?=^.+?\\n[=-]{2,}$)',
          contains: [{
            begin: '^[=-]*$'
          }, {
            begin: '^',
            end: "\\n",
            contains: CONTAINABLE
          }]
        }]
      };
      const BLOCKQUOTE = {
        className: 'quote',
        begin: '^>\\s+',
        contains: CONTAINABLE,
        end: '$'
      };
      return {
        name: 'Markdown',
        aliases: ['md', 'mkdown', 'mkd'],
        contains: [HEADER, INLINE_HTML, LIST, BOLD, ITALIC, BLOCKQUOTE, CODE, HORIZONTAL_RULE, LINK, LINK_REFERENCE]
      };
    }
    markdown_1 = markdown;
    return markdown_1;
  }

  /*
  Language: Diff
  Description: Unified and context diff
  Author: Vasily Polovnyov <vast@whiteants.net>
  Website: https://www.gnu.org/software/diffutils/
  Category: common
  */
  var diff_1;
  var hasRequiredDiff;
  function requireDiff() {
    if (hasRequiredDiff) return diff_1;
    hasRequiredDiff = 1;
    /** @type LanguageFn */
    function diff(hljs) {
      const regex = hljs.regex;
      return {
        name: 'Diff',
        aliases: ['patch'],
        contains: [{
          className: 'meta',
          relevance: 10,
          match: regex.either(/^@@ +-\d+,\d+ +\+\d+,\d+ +@@/, /^\*\*\* +\d+,\d+ +\*\*\*\*$/, /^--- +\d+,\d+ +----$/)
        }, {
          className: 'comment',
          variants: [{
            begin: regex.either(/Index: /, /^index/, /={3,}/, /^-{3}/, /^\*{3} /, /^\+{3}/, /^diff --git/),
            end: /$/
          }, {
            match: /^\*{15}$/
          }]
        }, {
          className: 'addition',
          begin: /^\+/,
          end: /$/
        }, {
          className: 'deletion',
          begin: /^-/,
          end: /$/
        }, {
          className: 'addition',
          begin: /^!/,
          end: /$/
        }]
      };
    }
    diff_1 = diff;
    return diff_1;
  }

  /*
  Language: Ruby
  Description: Ruby is a dynamic, open source programming language with a focus on simplicity and productivity.
  Website: https://www.ruby-lang.org/
  Author: Anton Kovalyov <anton@kovalyov.net>
  Contributors: Peter Leonov <gojpeg@yandex.ru>, Vasily Polovnyov <vast@whiteants.net>, Loren Segal <lsegal@soen.ca>, Pascal Hurni <phi@ruby-reactive.org>, Cedric Sohrauer <sohrauer@googlemail.com>
  Category: common
  */
  var ruby_1;
  var hasRequiredRuby;
  function requireRuby() {
    if (hasRequiredRuby) return ruby_1;
    hasRequiredRuby = 1;
    function ruby(hljs) {
      const regex = hljs.regex;
      const RUBY_METHOD_RE = '([a-zA-Z_]\\w*[!?=]?|[-+~]@|<<|>>|=~|===?|<=>|[<>]=?|\\*\\*|[-/+%^&*~`|]|\\[\\]=?)';
      // TODO: move concepts like CAMEL_CASE into `modes.js`
      const CLASS_NAME_RE = regex.either(/\b([A-Z]+[a-z0-9]+)+/,
      // ends in caps
      /\b([A-Z]+[a-z0-9]+)+[A-Z]+/);
      const CLASS_NAME_WITH_NAMESPACE_RE = regex.concat(CLASS_NAME_RE, /(::\w+)*/);
      // very popular ruby built-ins that one might even assume
      // are actual keywords (despite that not being the case)
      const PSEUDO_KWS = ["include", "extend", "prepend", "public", "private", "protected", "raise", "throw"];
      const RUBY_KEYWORDS = {
        "variable.constant": ["__FILE__", "__LINE__", "__ENCODING__"],
        "variable.language": ["self", "super"],
        keyword: ["alias", "and", "begin", "BEGIN", "break", "case", "class", "defined", "do", "else", "elsif", "end", "END", "ensure", "for", "if", "in", "module", "next", "not", "or", "redo", "require", "rescue", "retry", "return", "then", "undef", "unless", "until", "when", "while", "yield", ...PSEUDO_KWS],
        built_in: ["proc", "lambda", "attr_accessor", "attr_reader", "attr_writer", "define_method", "private_constant", "module_function"],
        literal: ["true", "false", "nil"]
      };
      const YARDOCTAG = {
        className: 'doctag',
        begin: '@[A-Za-z]+'
      };
      const IRB_OBJECT = {
        begin: '#<',
        end: '>'
      };
      const COMMENT_MODES = [hljs.COMMENT('#', '$', {
        contains: [YARDOCTAG]
      }), hljs.COMMENT('^=begin', '^=end', {
        contains: [YARDOCTAG],
        relevance: 10
      }), hljs.COMMENT('^__END__', hljs.MATCH_NOTHING_RE)];
      const SUBST = {
        className: 'subst',
        begin: /#\{/,
        end: /\}/,
        keywords: RUBY_KEYWORDS
      };
      const STRING = {
        className: 'string',
        contains: [hljs.BACKSLASH_ESCAPE, SUBST],
        variants: [{
          begin: /'/,
          end: /'/
        }, {
          begin: /"/,
          end: /"/
        }, {
          begin: /`/,
          end: /`/
        }, {
          begin: /%[qQwWx]?\(/,
          end: /\)/
        }, {
          begin: /%[qQwWx]?\[/,
          end: /\]/
        }, {
          begin: /%[qQwWx]?\{/,
          end: /\}/
        }, {
          begin: /%[qQwWx]?</,
          end: />/
        }, {
          begin: /%[qQwWx]?\//,
          end: /\//
        }, {
          begin: /%[qQwWx]?%/,
          end: /%/
        }, {
          begin: /%[qQwWx]?-/,
          end: /-/
        }, {
          begin: /%[qQwWx]?\|/,
          end: /\|/
        },
        // in the following expressions, \B in the beginning suppresses recognition of ?-sequences
        // where ? is the last character of a preceding identifier, as in: `func?4`
        {
          begin: /\B\?(\\\d{1,3})/
        }, {
          begin: /\B\?(\\x[A-Fa-f0-9]{1,2})/
        }, {
          begin: /\B\?(\\u\{?[A-Fa-f0-9]{1,6}\}?)/
        }, {
          begin: /\B\?(\\M-\\C-|\\M-\\c|\\c\\M-|\\M-|\\C-\\M-)[\x20-\x7e]/
        }, {
          begin: /\B\?\\(c|C-)[\x20-\x7e]/
        }, {
          begin: /\B\?\\?\S/
        },
        // heredocs
        {
          // this guard makes sure that we have an entire heredoc and not a false
          // positive (auto-detect, etc.)
          begin: regex.concat(/<<[-~]?'?/, regex.lookahead(/(\w+)(?=\W)[^\n]*\n(?:[^\n]*\n)*?\s*\1\b/)),
          contains: [hljs.END_SAME_AS_BEGIN({
            begin: /(\w+)/,
            end: /(\w+)/,
            contains: [hljs.BACKSLASH_ESCAPE, SUBST]
          })]
        }]
      };

      // Ruby syntax is underdocumented, but this grammar seems to be accurate
      // as of version 2.7.2 (confirmed with (irb and `Ripper.sexp(...)`)
      // https://docs.ruby-lang.org/en/2.7.0/doc/syntax/literals_rdoc.html#label-Numbers
      const decimal = '[1-9](_?[0-9])*|0';
      const digits = '[0-9](_?[0-9])*';
      const NUMBER = {
        className: 'number',
        relevance: 0,
        variants: [
        // decimal integer/float, optionally exponential or rational, optionally imaginary
        {
          begin: `\\b(${decimal})(\\.(${digits}))?([eE][+-]?(${digits})|r)?i?\\b`
        },
        // explicit decimal/binary/octal/hexadecimal integer,
        // optionally rational and/or imaginary
        {
          begin: "\\b0[dD][0-9](_?[0-9])*r?i?\\b"
        }, {
          begin: "\\b0[bB][0-1](_?[0-1])*r?i?\\b"
        }, {
          begin: "\\b0[oO][0-7](_?[0-7])*r?i?\\b"
        }, {
          begin: "\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*r?i?\\b"
        },
        // 0-prefixed implicit octal integer, optionally rational and/or imaginary
        {
          begin: "\\b0(_?[0-7])+r?i?\\b"
        }]
      };
      const PARAMS = {
        variants: [{
          match: /\(\)/
        }, {
          className: 'params',
          begin: /\(/,
          end: /(?=\))/,
          excludeBegin: true,
          endsParent: true,
          keywords: RUBY_KEYWORDS
        }]
      };
      const INCLUDE_EXTEND = {
        match: [/(include|extend)\s+/, CLASS_NAME_WITH_NAMESPACE_RE],
        scope: {
          2: "title.class"
        },
        keywords: RUBY_KEYWORDS
      };
      const CLASS_DEFINITION = {
        variants: [{
          match: [/class\s+/, CLASS_NAME_WITH_NAMESPACE_RE, /\s+<\s+/, CLASS_NAME_WITH_NAMESPACE_RE]
        }, {
          match: [/\b(class|module)\s+/, CLASS_NAME_WITH_NAMESPACE_RE]
        }],
        scope: {
          2: "title.class",
          4: "title.class.inherited"
        },
        keywords: RUBY_KEYWORDS
      };
      const UPPER_CASE_CONSTANT = {
        relevance: 0,
        match: /\b[A-Z][A-Z_0-9]+\b/,
        className: "variable.constant"
      };
      const METHOD_DEFINITION = {
        match: [/def/, /\s+/, RUBY_METHOD_RE],
        scope: {
          1: "keyword",
          3: "title.function"
        },
        contains: [PARAMS]
      };
      const OBJECT_CREATION = {
        relevance: 0,
        match: [CLASS_NAME_WITH_NAMESPACE_RE, /\.new[. (]/],
        scope: {
          1: "title.class"
        }
      };

      // CamelCase
      const CLASS_REFERENCE = {
        relevance: 0,
        match: CLASS_NAME_RE,
        scope: "title.class"
      };
      const RUBY_DEFAULT_CONTAINS = [STRING, CLASS_DEFINITION, INCLUDE_EXTEND, OBJECT_CREATION, UPPER_CASE_CONSTANT, CLASS_REFERENCE, METHOD_DEFINITION, {
        // swallow namespace qualifiers before symbols
        begin: hljs.IDENT_RE + '::'
      }, {
        className: 'symbol',
        begin: hljs.UNDERSCORE_IDENT_RE + '(!|\\?)?:',
        relevance: 0
      }, {
        className: 'symbol',
        begin: ':(?!\\s)',
        contains: [STRING, {
          begin: RUBY_METHOD_RE
        }],
        relevance: 0
      }, NUMBER, {
        // negative-look forward attempts to prevent false matches like:
        // @ident@ or $ident$ that might indicate this is not ruby at all
        className: "variable",
        begin: '(\\$\\W)|((\\$|@@?)(\\w+))(?=[^@$?])' + `(?![A-Za-z])(?![@$?'])`
      }, {
        className: 'params',
        begin: /\|/,
        end: /\|/,
        excludeBegin: true,
        excludeEnd: true,
        relevance: 0,
        // this could be a lot of things (in other languages) other than params
        keywords: RUBY_KEYWORDS
      }, {
        // regexp container
        begin: '(' + hljs.RE_STARTERS_RE + '|unless)\\s*',
        keywords: 'unless',
        contains: [{
          className: 'regexp',
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          illegal: /\n/,
          variants: [{
            begin: '/',
            end: '/[a-z]*'
          }, {
            begin: /%r\{/,
            end: /\}[a-z]*/
          }, {
            begin: '%r\\(',
            end: '\\)[a-z]*'
          }, {
            begin: '%r!',
            end: '![a-z]*'
          }, {
            begin: '%r\\[',
            end: '\\][a-z]*'
          }]
        }].concat(IRB_OBJECT, COMMENT_MODES),
        relevance: 0
      }].concat(IRB_OBJECT, COMMENT_MODES);
      SUBST.contains = RUBY_DEFAULT_CONTAINS;
      PARAMS.contains = RUBY_DEFAULT_CONTAINS;

      // >>
      // ?>
      const SIMPLE_PROMPT = "[>?]>";
      // irb(main):001:0>
      const DEFAULT_PROMPT = "[\\w#]+\\(\\w+\\):\\d+:\\d+[>*]";
      const RVM_PROMPT = "(\\w+-)?\\d+\\.\\d+\\.\\d+(p\\d+)?[^\\d][^>]+>";
      const IRB_DEFAULT = [{
        begin: /^\s*=>/,
        starts: {
          end: '$',
          contains: RUBY_DEFAULT_CONTAINS
        }
      }, {
        className: 'meta.prompt',
        begin: '^(' + SIMPLE_PROMPT + "|" + DEFAULT_PROMPT + '|' + RVM_PROMPT + ')(?=[ ])',
        starts: {
          end: '$',
          keywords: RUBY_KEYWORDS,
          contains: RUBY_DEFAULT_CONTAINS
        }
      }];
      COMMENT_MODES.unshift(IRB_OBJECT);
      return {
        name: 'Ruby',
        aliases: ['rb', 'gemspec', 'podspec', 'thor', 'irb'],
        keywords: RUBY_KEYWORDS,
        illegal: /\/\*/,
        contains: [hljs.SHEBANG({
          binary: "ruby"
        })].concat(IRB_DEFAULT).concat(COMMENT_MODES).concat(RUBY_DEFAULT_CONTAINS)
      };
    }
    ruby_1 = ruby;
    return ruby_1;
  }

  /*
  Language: Go
  Author: Stephan Kountso aka StepLg <steplg@gmail.com>
  Contributors: Evgeny Stepanischev <imbolk@gmail.com>
  Description: Google go language (golang). For info about language
  Website: http://golang.org/
  Category: common, system
  */
  var go_1;
  var hasRequiredGo;
  function requireGo() {
    if (hasRequiredGo) return go_1;
    hasRequiredGo = 1;
    function go(hljs) {
      const LITERALS = ["true", "false", "iota", "nil"];
      const BUILT_INS = ["append", "cap", "close", "complex", "copy", "imag", "len", "make", "new", "panic", "print", "println", "real", "recover", "delete"];
      const TYPES = ["bool", "byte", "complex64", "complex128", "error", "float32", "float64", "int8", "int16", "int32", "int64", "string", "uint8", "uint16", "uint32", "uint64", "int", "uint", "uintptr", "rune"];
      const KWS = ["break", "case", "chan", "const", "continue", "default", "defer", "else", "fallthrough", "for", "func", "go", "goto", "if", "import", "interface", "map", "package", "range", "return", "select", "struct", "switch", "type", "var"];
      const KEYWORDS = {
        keyword: KWS,
        type: TYPES,
        literal: LITERALS,
        built_in: BUILT_INS
      };
      return {
        name: 'Go',
        aliases: ['golang'],
        keywords: KEYWORDS,
        illegal: '</',
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, {
          className: 'string',
          variants: [hljs.QUOTE_STRING_MODE, hljs.APOS_STRING_MODE, {
            begin: '`',
            end: '`'
          }]
        }, {
          className: 'number',
          variants: [{
            begin: hljs.C_NUMBER_RE + '[i]',
            relevance: 1
          }, hljs.C_NUMBER_MODE]
        }, {
          begin: /:=/ // relevance booster
        }, {
          className: 'function',
          beginKeywords: 'func',
          end: '\\s*(\\{|$)',
          excludeEnd: true,
          contains: [hljs.TITLE_MODE, {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            endsParent: true,
            keywords: KEYWORDS,
            illegal: /["']/
          }]
        }]
      };
    }
    go_1 = go;
    return go_1;
  }

  /*
   Language: GraphQL
   Author: John Foster (GH jf990), and others
   Description: GraphQL is a query language for APIs
   Category: web, common
  */
  var graphql_1;
  var hasRequiredGraphql;
  function requireGraphql() {
    if (hasRequiredGraphql) return graphql_1;
    hasRequiredGraphql = 1;
    /** @type LanguageFn */
    function graphql(hljs) {
      const regex = hljs.regex;
      const GQL_NAME = /[_A-Za-z][_0-9A-Za-z]*/;
      return {
        name: "GraphQL",
        aliases: ["gql"],
        case_insensitive: true,
        disableAutodetect: false,
        keywords: {
          keyword: ["query", "mutation", "subscription", "type", "input", "schema", "directive", "interface", "union", "scalar", "fragment", "enum", "on"],
          literal: ["true", "false", "null"]
        },
        contains: [hljs.HASH_COMMENT_MODE, hljs.QUOTE_STRING_MODE, hljs.NUMBER_MODE, {
          scope: "punctuation",
          match: /[.]{3}/,
          relevance: 0
        }, {
          scope: "punctuation",
          begin: /[\!\(\)\:\=\[\]\{\|\}]{1}/,
          relevance: 0
        }, {
          scope: "variable",
          begin: /\$/,
          end: /\W/,
          excludeEnd: true,
          relevance: 0
        }, {
          scope: "meta",
          match: /@\w+/,
          excludeEnd: true
        }, {
          scope: "symbol",
          begin: regex.concat(GQL_NAME, regex.lookahead(/\s*:/)),
          relevance: 0
        }],
        illegal: [/[;<']/, /BEGIN/]
      };
    }
    graphql_1 = graphql;
    return graphql_1;
  }

  /*
  Language: TOML, also INI
  Description: TOML aims to be a minimal configuration file format that's easy to read due to obvious semantics.
  Contributors: Guillaume Gomez <guillaume1.gomez@gmail.com>
  Category: common, config
  Website: https://github.com/toml-lang/toml
  */
  var ini_1;
  var hasRequiredIni;
  function requireIni() {
    if (hasRequiredIni) return ini_1;
    hasRequiredIni = 1;
    function ini(hljs) {
      const regex = hljs.regex;
      const NUMBERS = {
        className: 'number',
        relevance: 0,
        variants: [{
          begin: /([+-]+)?[\d]+_[\d_]+/
        }, {
          begin: hljs.NUMBER_RE
        }]
      };
      const COMMENTS = hljs.COMMENT();
      COMMENTS.variants = [{
        begin: /;/,
        end: /$/
      }, {
        begin: /#/,
        end: /$/
      }];
      const VARIABLES = {
        className: 'variable',
        variants: [{
          begin: /\$[\w\d"][\w\d_]*/
        }, {
          begin: /\$\{(.*?)\}/
        }]
      };
      const LITERALS = {
        className: 'literal',
        begin: /\bon|off|true|false|yes|no\b/
      };
      const STRINGS = {
        className: "string",
        contains: [hljs.BACKSLASH_ESCAPE],
        variants: [{
          begin: "'''",
          end: "'''",
          relevance: 10
        }, {
          begin: '"""',
          end: '"""',
          relevance: 10
        }, {
          begin: '"',
          end: '"'
        }, {
          begin: "'",
          end: "'"
        }]
      };
      const ARRAY = {
        begin: /\[/,
        end: /\]/,
        contains: [COMMENTS, LITERALS, VARIABLES, STRINGS, NUMBERS, 'self'],
        relevance: 0
      };
      const BARE_KEY = /[A-Za-z0-9_-]+/;
      const QUOTED_KEY_DOUBLE_QUOTE = /"(\\"|[^"])*"/;
      const QUOTED_KEY_SINGLE_QUOTE = /'[^']*'/;
      const ANY_KEY = regex.either(BARE_KEY, QUOTED_KEY_DOUBLE_QUOTE, QUOTED_KEY_SINGLE_QUOTE);
      const DOTTED_KEY = regex.concat(ANY_KEY, '(\\s*\\.\\s*', ANY_KEY, ')*', regex.lookahead(/\s*=\s*[^#\s]/));
      return {
        name: 'TOML, also INI',
        aliases: ['toml'],
        case_insensitive: true,
        illegal: /\S/,
        contains: [COMMENTS, {
          className: 'section',
          begin: /\[+/,
          end: /\]+/
        }, {
          begin: DOTTED_KEY,
          className: 'attr',
          starts: {
            end: /$/,
            contains: [COMMENTS, ARRAY, LITERALS, VARIABLES, STRINGS, NUMBERS]
          }
        }]
      };
    }
    ini_1 = ini;
    return ini_1;
  }

  var java_1;
  var hasRequiredJava;
  function requireJava() {
    if (hasRequiredJava) return java_1;
    hasRequiredJava = 1;
    // https://docs.oracle.com/javase/specs/jls/se15/html/jls-3.html#jls-3.10
    var decimalDigits = '[0-9](_*[0-9])*';
    var frac = `\\.(${decimalDigits})`;
    var hexDigits = '[0-9a-fA-F](_*[0-9a-fA-F])*';
    var NUMERIC = {
      className: 'number',
      variants: [
      // DecimalFloatingPointLiteral
      // including ExponentPart
      {
        begin: `(\\b(${decimalDigits})((${frac})|\\.)?|(${frac}))` + `[eE][+-]?(${decimalDigits})[fFdD]?\\b`
      },
      // excluding ExponentPart
      {
        begin: `\\b(${decimalDigits})((${frac})[fFdD]?\\b|\\.([fFdD]\\b)?)`
      }, {
        begin: `(${frac})[fFdD]?\\b`
      }, {
        begin: `\\b(${decimalDigits})[fFdD]\\b`
      },
      // HexadecimalFloatingPointLiteral
      {
        begin: `\\b0[xX]((${hexDigits})\\.?|(${hexDigits})?\\.(${hexDigits}))` + `[pP][+-]?(${decimalDigits})[fFdD]?\\b`
      },
      // DecimalIntegerLiteral
      {
        begin: '\\b(0|[1-9](_*[0-9])*)[lL]?\\b'
      },
      // HexIntegerLiteral
      {
        begin: `\\b0[xX](${hexDigits})[lL]?\\b`
      },
      // OctalIntegerLiteral
      {
        begin: '\\b0(_*[0-7])*[lL]?\\b'
      },
      // BinaryIntegerLiteral
      {
        begin: '\\b0[bB][01](_*[01])*[lL]?\\b'
      }],
      relevance: 0
    };

    /*
    Language: Java
    Author: Vsevolod Solovyov <vsevolod.solovyov@gmail.com>
    Category: common, enterprise
    Website: https://www.java.com/
    */

    /**
     * Allows recursive regex expressions to a given depth
     *
     * ie: recurRegex("(abc~~~)", /~~~/g, 2) becomes:
     * (abc(abc(abc)))
     *
     * @param {string} re
     * @param {RegExp} substitution (should be a g mode regex)
     * @param {number} depth
     * @returns {string}``
     */
    function recurRegex(re, substitution, depth) {
      if (depth === -1) return "";
      return re.replace(substitution, _ => {
        return recurRegex(re, substitution, depth - 1);
      });
    }

    /** @type LanguageFn */
    function java(hljs) {
      const regex = hljs.regex;
      const JAVA_IDENT_RE = '[\u00C0-\u02B8a-zA-Z_$][\u00C0-\u02B8a-zA-Z_$0-9]*';
      const GENERIC_IDENT_RE = JAVA_IDENT_RE + recurRegex('(?:<' + JAVA_IDENT_RE + '~~~(?:\\s*,\\s*' + JAVA_IDENT_RE + '~~~)*>)?', /~~~/g, 2);
      const MAIN_KEYWORDS = ['synchronized', 'abstract', 'private', 'var', 'static', 'if', 'const ', 'for', 'while', 'strictfp', 'finally', 'protected', 'import', 'native', 'final', 'void', 'enum', 'else', 'break', 'transient', 'catch', 'instanceof', 'volatile', 'case', 'assert', 'package', 'default', 'public', 'try', 'switch', 'continue', 'throws', 'protected', 'public', 'private', 'module', 'requires', 'exports', 'do', 'sealed', 'yield', 'permits'];
      const BUILT_INS = ['super', 'this'];
      const LITERALS = ['false', 'true', 'null'];
      const TYPES = ['char', 'boolean', 'long', 'float', 'int', 'byte', 'short', 'double'];
      const KEYWORDS = {
        keyword: MAIN_KEYWORDS,
        literal: LITERALS,
        type: TYPES,
        built_in: BUILT_INS
      };
      const ANNOTATION = {
        className: 'meta',
        begin: '@' + JAVA_IDENT_RE,
        contains: [{
          begin: /\(/,
          end: /\)/,
          contains: ["self"] // allow nested () inside our annotation
        }]
      };

      const PARAMS = {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        relevance: 0,
        contains: [hljs.C_BLOCK_COMMENT_MODE],
        endsParent: true
      };
      return {
        name: 'Java',
        aliases: ['jsp'],
        keywords: KEYWORDS,
        illegal: /<\/|#/,
        contains: [hljs.COMMENT('/\\*\\*', '\\*/', {
          relevance: 0,
          contains: [{
            // eat up @'s in emails to prevent them to be recognized as doctags
            begin: /\w+@/,
            relevance: 0
          }, {
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }]
        }),
        // relevance boost
        {
          begin: /import java\.[a-z]+\./,
          keywords: "import",
          relevance: 2
        }, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, {
          begin: /"""/,
          end: /"""/,
          className: "string",
          contains: [hljs.BACKSLASH_ESCAPE]
        }, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, {
          match: [/\b(?:class|interface|enum|extends|implements|new)/, /\s+/, JAVA_IDENT_RE],
          className: {
            1: "keyword",
            3: "title.class"
          }
        }, {
          // Exceptions for hyphenated keywords
          match: /non-sealed/,
          scope: "keyword"
        }, {
          begin: [regex.concat(/(?!else)/, JAVA_IDENT_RE), /\s+/, JAVA_IDENT_RE, /\s+/, /=(?!=)/],
          className: {
            1: "type",
            3: "variable",
            5: "operator"
          }
        }, {
          begin: [/record/, /\s+/, JAVA_IDENT_RE],
          className: {
            1: "keyword",
            3: "title.class"
          },
          contains: [PARAMS, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, {
          // Expression keywords prevent 'keyword Name(...)' from being
          // recognized as a function definition
          beginKeywords: 'new throw return else',
          relevance: 0
        }, {
          begin: ['(?:' + GENERIC_IDENT_RE + '\\s+)', hljs.UNDERSCORE_IDENT_RE, /\s*(?=\()/],
          className: {
            2: "title.function"
          },
          keywords: KEYWORDS,
          contains: [{
            className: 'params',
            begin: /\(/,
            end: /\)/,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [ANNOTATION, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, NUMERIC, hljs.C_BLOCK_COMMENT_MODE]
          }, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, NUMERIC, ANNOTATION]
      };
    }
    java_1 = java;
    return java_1;
  }

  var javascript_1;
  var hasRequiredJavascript;
  function requireJavascript() {
    if (hasRequiredJavascript) return javascript_1;
    hasRequiredJavascript = 1;
    const IDENT_RE = '[A-Za-z$_][0-9A-Za-z$_]*';
    const KEYWORDS = ["as",
    // for exports
    "in", "of", "if", "for", "while", "finally", "var", "new", "function", "do", "return", "void", "else", "break", "catch", "instanceof", "with", "throw", "case", "default", "try", "switch", "continue", "typeof", "delete", "let", "yield", "const", "class",
    // JS handles these with a special rule
    // "get",
    // "set",
    "debugger", "async", "await", "static", "import", "from", "export", "extends"];
    const LITERALS = ["true", "false", "null", "undefined", "NaN", "Infinity"];

    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
    const TYPES = [
    // Fundamental objects
    "Object", "Function", "Boolean", "Symbol",
    // numbers and dates
    "Math", "Date", "Number", "BigInt",
    // text
    "String", "RegExp",
    // Indexed collections
    "Array", "Float32Array", "Float64Array", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Int32Array", "Uint16Array", "Uint32Array", "BigInt64Array", "BigUint64Array",
    // Keyed collections
    "Set", "Map", "WeakSet", "WeakMap",
    // Structured data
    "ArrayBuffer", "SharedArrayBuffer", "Atomics", "DataView", "JSON",
    // Control abstraction objects
    "Promise", "Generator", "GeneratorFunction", "AsyncFunction",
    // Reflection
    "Reflect", "Proxy",
    // Internationalization
    "Intl",
    // WebAssembly
    "WebAssembly"];
    const ERROR_TYPES = ["Error", "EvalError", "InternalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"];
    const BUILT_IN_GLOBALS = ["setInterval", "setTimeout", "clearInterval", "clearTimeout", "require", "exports", "eval", "isFinite", "isNaN", "parseFloat", "parseInt", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", "escape", "unescape"];
    const BUILT_IN_VARIABLES = ["arguments", "this", "super", "console", "window", "document", "localStorage", "sessionStorage", "module", "global" // Node.js
    ];

    const BUILT_INS = [].concat(BUILT_IN_GLOBALS, TYPES, ERROR_TYPES);

    /*
    Language: JavaScript
    Description: JavaScript (JS) is a lightweight, interpreted, or just-in-time compiled programming language with first-class functions.
    Category: common, scripting, web
    Website: https://developer.mozilla.org/en-US/docs/Web/JavaScript
    */

    /** @type LanguageFn */
    function javascript(hljs) {
      const regex = hljs.regex;
      /**
       * Takes a string like "<Booger" and checks to see
       * if we can find a matching "</Booger" later in the
       * content.
       * @param {RegExpMatchArray} match
       * @param {{after:number}} param1
       */
      const hasClosingTag = (match, {
        after
      }) => {
        const tag = "</" + match[0].slice(1);
        const pos = match.input.indexOf(tag, after);
        return pos !== -1;
      };
      const IDENT_RE$1 = IDENT_RE;
      const FRAGMENT = {
        begin: '<>',
        end: '</>'
      };
      // to avoid some special cases inside isTrulyOpeningTag
      const XML_SELF_CLOSING = /<[A-Za-z0-9\\._:-]+\s*\/>/;
      const XML_TAG = {
        begin: /<[A-Za-z0-9\\._:-]+/,
        end: /\/[A-Za-z0-9\\._:-]+>|\/>/,
        /**
         * @param {RegExpMatchArray} match
         * @param {CallbackResponse} response
         */
        isTrulyOpeningTag: (match, response) => {
          const afterMatchIndex = match[0].length + match.index;
          const nextChar = match.input[afterMatchIndex];
          if (
          // HTML should not include another raw `<` inside a tag
          // nested type?
          // `<Array<Array<number>>`, etc.
          nextChar === "<" ||
          // the , gives away that this is not HTML
          // `<T, A extends keyof T, V>`
          nextChar === ",") {
            response.ignoreMatch();
            return;
          }

          // `<something>`
          // Quite possibly a tag, lets look for a matching closing tag...
          if (nextChar === ">") {
            // if we cannot find a matching closing tag, then we
            // will ignore it
            if (!hasClosingTag(match, {
              after: afterMatchIndex
            })) {
              response.ignoreMatch();
            }
          }

          // `<blah />` (self-closing)
          // handled by simpleSelfClosing rule

          let m;
          const afterMatch = match.input.substring(afterMatchIndex);

          // some more template typing stuff
          //  <T = any>(key?: string) => Modify<
          if (m = afterMatch.match(/^\s*=/)) {
            response.ignoreMatch();
            return;
          }

          // `<From extends string>`
          // technically this could be HTML, but it smells like a type
          // NOTE: This is ugh, but added specifically for https://github.com/highlightjs/highlight.js/issues/3276
          if (m = afterMatch.match(/^\s+extends\s+/)) {
            if (m.index === 0) {
              response.ignoreMatch();
              // eslint-disable-next-line no-useless-return
              return;
            }
          }
        }
      };
      const KEYWORDS$1 = {
        $pattern: IDENT_RE,
        keyword: KEYWORDS,
        literal: LITERALS,
        built_in: BUILT_INS,
        "variable.language": BUILT_IN_VARIABLES
      };

      // https://tc39.es/ecma262/#sec-literals-numeric-literals
      const decimalDigits = '[0-9](_?[0-9])*';
      const frac = `\\.(${decimalDigits})`;
      // DecimalIntegerLiteral, including Annex B NonOctalDecimalIntegerLiteral
      // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
      const decimalInteger = `0|[1-9](_?[0-9])*|0[0-7]*[89][0-9]*`;
      const NUMBER = {
        className: 'number',
        variants: [
        // DecimalLiteral
        {
          begin: `(\\b(${decimalInteger})((${frac})|\\.)?|(${frac}))` + `[eE][+-]?(${decimalDigits})\\b`
        }, {
          begin: `\\b(${decimalInteger})\\b((${frac})\\b|\\.)?|(${frac})\\b`
        },
        // DecimalBigIntegerLiteral
        {
          begin: `\\b(0|[1-9](_?[0-9])*)n\\b`
        },
        // NonDecimalIntegerLiteral
        {
          begin: "\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*n?\\b"
        }, {
          begin: "\\b0[bB][0-1](_?[0-1])*n?\\b"
        }, {
          begin: "\\b0[oO][0-7](_?[0-7])*n?\\b"
        },
        // LegacyOctalIntegerLiteral (does not include underscore separators)
        // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
        {
          begin: "\\b0[0-7]+n?\\b"
        }],
        relevance: 0
      };
      const SUBST = {
        className: 'subst',
        begin: '\\$\\{',
        end: '\\}',
        keywords: KEYWORDS$1,
        contains: [] // defined later
      };

      const HTML_TEMPLATE = {
        begin: 'html`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'xml'
        }
      };
      const CSS_TEMPLATE = {
        begin: 'css`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'css'
        }
      };
      const GRAPHQL_TEMPLATE = {
        begin: 'gql`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'graphql'
        }
      };
      const TEMPLATE_STRING = {
        className: 'string',
        begin: '`',
        end: '`',
        contains: [hljs.BACKSLASH_ESCAPE, SUBST]
      };
      const JSDOC_COMMENT = hljs.COMMENT(/\/\*\*(?!\/)/, '\\*/', {
        relevance: 0,
        contains: [{
          begin: '(?=@[A-Za-z]+)',
          relevance: 0,
          contains: [{
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }, {
            className: 'type',
            begin: '\\{',
            end: '\\}',
            excludeEnd: true,
            excludeBegin: true,
            relevance: 0
          }, {
            className: 'variable',
            begin: IDENT_RE$1 + '(?=\\s*(-)|$)',
            endsParent: true,
            relevance: 0
          },
          // eat spaces (not newlines) so we can find
          // types or variables
          {
            begin: /(?=[^\n])\s/,
            relevance: 0
          }]
        }]
      });
      const COMMENT = {
        className: "comment",
        variants: [JSDOC_COMMENT, hljs.C_BLOCK_COMMENT_MODE, hljs.C_LINE_COMMENT_MODE]
      };
      const SUBST_INTERNALS = [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, HTML_TEMPLATE, CSS_TEMPLATE, GRAPHQL_TEMPLATE, TEMPLATE_STRING,
      // Skip numbers when they are part of a variable name
      {
        match: /\$\d+/
      }, NUMBER
      // This is intentional:
      // See https://github.com/highlightjs/highlight.js/issues/3288
      // hljs.REGEXP_MODE
      ];

      SUBST.contains = SUBST_INTERNALS.concat({
        // we need to pair up {} inside our subst to prevent
        // it from ending too early by matching another }
        begin: /\{/,
        end: /\}/,
        keywords: KEYWORDS$1,
        contains: ["self"].concat(SUBST_INTERNALS)
      });
      const SUBST_AND_COMMENTS = [].concat(COMMENT, SUBST.contains);
      const PARAMS_CONTAINS = SUBST_AND_COMMENTS.concat([
      // eat recursive parens in sub expressions
      {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS$1,
        contains: ["self"].concat(SUBST_AND_COMMENTS)
      }]);
      const PARAMS = {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        excludeBegin: true,
        excludeEnd: true,
        keywords: KEYWORDS$1,
        contains: PARAMS_CONTAINS
      };

      // ES6 classes
      const CLASS_OR_EXTENDS = {
        variants: [
        // class Car extends vehicle
        {
          match: [/class/, /\s+/, IDENT_RE$1, /\s+/, /extends/, /\s+/, regex.concat(IDENT_RE$1, "(", regex.concat(/\./, IDENT_RE$1), ")*")],
          scope: {
            1: "keyword",
            3: "title.class",
            5: "keyword",
            7: "title.class.inherited"
          }
        },
        // class Car
        {
          match: [/class/, /\s+/, IDENT_RE$1],
          scope: {
            1: "keyword",
            3: "title.class"
          }
        }]
      };
      const CLASS_REFERENCE = {
        relevance: 0,
        match: regex.either(
        // Hard coded exceptions
        /\bJSON/,
        // Float32Array, OutT
        /\b[A-Z][a-z]+([A-Z][a-z]*|\d)*/,
        // CSSFactory, CSSFactoryT
        /\b[A-Z]{2,}([A-Z][a-z]+|\d)+([A-Z][a-z]*)*/,
        // FPs, FPsT
        /\b[A-Z]{2,}[a-z]+([A-Z][a-z]+|\d)*([A-Z][a-z]*)*/
        // P
        // single letters are not highlighted
        // BLAH
        // this will be flagged as a UPPER_CASE_CONSTANT instead
        ),

        className: "title.class",
        keywords: {
          _: [
          // se we still get relevance credit for JS library classes
          ...TYPES, ...ERROR_TYPES]
        }
      };
      const USE_STRICT = {
        label: "use_strict",
        className: 'meta',
        relevance: 10,
        begin: /^\s*['"]use (strict|asm)['"]/
      };
      const FUNCTION_DEFINITION = {
        variants: [{
          match: [/function/, /\s+/, IDENT_RE$1, /(?=\s*\()/]
        },
        // anonymous function
        {
          match: [/function/, /\s*(?=\()/]
        }],
        className: {
          1: "keyword",
          3: "title.function"
        },
        label: "func.def",
        contains: [PARAMS],
        illegal: /%/
      };
      const UPPER_CASE_CONSTANT = {
        relevance: 0,
        match: /\b[A-Z][A-Z_0-9]+\b/,
        className: "variable.constant"
      };
      function noneOf(list) {
        return regex.concat("(?!", list.join("|"), ")");
      }
      const FUNCTION_CALL = {
        match: regex.concat(/\b/, noneOf([...BUILT_IN_GLOBALS, "super", "import"]), IDENT_RE$1, regex.lookahead(/\(/)),
        className: "title.function",
        relevance: 0
      };
      const PROPERTY_ACCESS = {
        begin: regex.concat(/\./, regex.lookahead(regex.concat(IDENT_RE$1, /(?![0-9A-Za-z$_(])/))),
        end: IDENT_RE$1,
        excludeBegin: true,
        keywords: "prototype",
        className: "property",
        relevance: 0
      };
      const GETTER_OR_SETTER = {
        match: [/get|set/, /\s+/, IDENT_RE$1, /(?=\()/],
        className: {
          1: "keyword",
          3: "title.function"
        },
        contains: [{
          // eat to avoid empty params
          begin: /\(\)/
        }, PARAMS]
      };
      const FUNC_LEAD_IN_RE = '(\\(' + '[^()]*(\\(' + '[^()]*(\\(' + '[^()]*' + '\\)[^()]*)*' + '\\)[^()]*)*' + '\\)|' + hljs.UNDERSCORE_IDENT_RE + ')\\s*=>';
      const FUNCTION_VARIABLE = {
        match: [/const|var|let/, /\s+/, IDENT_RE$1, /\s*/, /=\s*/, /(async\s*)?/,
        // async is optional
        regex.lookahead(FUNC_LEAD_IN_RE)],
        keywords: "async",
        className: {
          1: "keyword",
          3: "title.function"
        },
        contains: [PARAMS]
      };
      return {
        name: 'JavaScript',
        aliases: ['js', 'jsx', 'mjs', 'cjs'],
        keywords: KEYWORDS$1,
        // this will be extended by TypeScript
        exports: {
          PARAMS_CONTAINS,
          CLASS_REFERENCE
        },
        illegal: /#(?![$_A-z])/,
        contains: [hljs.SHEBANG({
          label: "shebang",
          binary: "node",
          relevance: 5
        }), USE_STRICT, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, HTML_TEMPLATE, CSS_TEMPLATE, GRAPHQL_TEMPLATE, TEMPLATE_STRING, COMMENT,
        // Skip numbers when they are part of a variable name
        {
          match: /\$\d+/
        }, NUMBER, CLASS_REFERENCE, {
          className: 'attr',
          begin: IDENT_RE$1 + regex.lookahead(':'),
          relevance: 0
        }, FUNCTION_VARIABLE, {
          // "value" container
          begin: '(' + hljs.RE_STARTERS_RE + '|\\b(case|return|throw)\\b)\\s*',
          keywords: 'return throw case',
          relevance: 0,
          contains: [COMMENT, hljs.REGEXP_MODE, {
            className: 'function',
            // we have to count the parens to make sure we actually have the
            // correct bounding ( ) before the =>.  There could be any number of
            // sub-expressions inside also surrounded by parens.
            begin: FUNC_LEAD_IN_RE,
            returnBegin: true,
            end: '\\s*=>',
            contains: [{
              className: 'params',
              variants: [{
                begin: hljs.UNDERSCORE_IDENT_RE,
                relevance: 0
              }, {
                className: null,
                begin: /\(\s*\)/,
                skip: true
              }, {
                begin: /\(/,
                end: /\)/,
                excludeBegin: true,
                excludeEnd: true,
                keywords: KEYWORDS$1,
                contains: PARAMS_CONTAINS
              }]
            }]
          }, {
            // could be a comma delimited list of params to a function call
            begin: /,/,
            relevance: 0
          }, {
            match: /\s+/,
            relevance: 0
          }, {
            // JSX
            variants: [{
              begin: FRAGMENT.begin,
              end: FRAGMENT.end
            }, {
              match: XML_SELF_CLOSING
            }, {
              begin: XML_TAG.begin,
              // we carefully check the opening tag to see if it truly
              // is a tag and not a false positive
              'on:begin': XML_TAG.isTrulyOpeningTag,
              end: XML_TAG.end
            }],
            subLanguage: 'xml',
            contains: [{
              begin: XML_TAG.begin,
              end: XML_TAG.end,
              skip: true,
              contains: ['self']
            }]
          }]
        }, FUNCTION_DEFINITION, {
          // prevent this from getting swallowed up by function
          // since they appear "function like"
          beginKeywords: "while if switch catch for"
        }, {
          // we have to count the parens to make sure we actually have the correct
          // bounding ( ).  There could be any number of sub-expressions inside
          // also surrounded by parens.
          begin: '\\b(?!function)' + hljs.UNDERSCORE_IDENT_RE + '\\(' +
          // first parens
          '[^()]*(\\(' + '[^()]*(\\(' + '[^()]*' + '\\)[^()]*)*' + '\\)[^()]*)*' + '\\)\\s*\\{',
          // end parens
          returnBegin: true,
          label: "func.def",
          contains: [PARAMS, hljs.inherit(hljs.TITLE_MODE, {
            begin: IDENT_RE$1,
            className: "title.function"
          })]
        },
        // catch ... so it won't trigger the property rule below
        {
          match: /\.\.\./,
          relevance: 0
        }, PROPERTY_ACCESS,
        // hack: prevents detection of keywords in some circumstances
        // .keyword()
        // $keyword = x
        {
          match: '\\$' + IDENT_RE$1,
          relevance: 0
        }, {
          match: [/\bconstructor(?=\s*\()/],
          className: {
            1: "title.function"
          },
          contains: [PARAMS]
        }, FUNCTION_CALL, UPPER_CASE_CONSTANT, CLASS_OR_EXTENDS, GETTER_OR_SETTER, {
          match: /\$[(.]/ // relevance booster for a pattern common to JS libs: `$(something)` and `$.something`
        }]
      };
    }

    javascript_1 = javascript;
    return javascript_1;
  }

  /*
  Language: JSON
  Description: JSON (JavaScript Object Notation) is a lightweight data-interchange format.
  Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
  Website: http://www.json.org
  Category: common, protocols, web
  */
  var json_1;
  var hasRequiredJson;
  function requireJson() {
    if (hasRequiredJson) return json_1;
    hasRequiredJson = 1;
    function json(hljs) {
      const ATTRIBUTE = {
        className: 'attr',
        begin: /"(\\.|[^\\"\r\n])*"(?=\s*:)/,
        relevance: 1.01
      };
      const PUNCTUATION = {
        match: /[{}[\],:]/,
        className: "punctuation",
        relevance: 0
      };
      const LITERALS = ["true", "false", "null"];
      // NOTE: normally we would rely on `keywords` for this but using a mode here allows us
      // - to use the very tight `illegal: \S` rule later to flag any other character
      // - as illegal indicating that despite looking like JSON we do not truly have
      // - JSON and thus improve false-positively greatly since JSON will try and claim
      // - all sorts of JSON looking stuff
      const LITERALS_MODE = {
        scope: "literal",
        beginKeywords: LITERALS.join(" ")
      };
      return {
        name: 'JSON',
        keywords: {
          literal: LITERALS
        },
        contains: [ATTRIBUTE, PUNCTUATION, hljs.QUOTE_STRING_MODE, LITERALS_MODE, hljs.C_NUMBER_MODE, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE],
        illegal: '\\S'
      };
    }
    json_1 = json;
    return json_1;
  }

  var kotlin_1;
  var hasRequiredKotlin;
  function requireKotlin() {
    if (hasRequiredKotlin) return kotlin_1;
    hasRequiredKotlin = 1;
    // https://docs.oracle.com/javase/specs/jls/se15/html/jls-3.html#jls-3.10
    var decimalDigits = '[0-9](_*[0-9])*';
    var frac = `\\.(${decimalDigits})`;
    var hexDigits = '[0-9a-fA-F](_*[0-9a-fA-F])*';
    var NUMERIC = {
      className: 'number',
      variants: [
      // DecimalFloatingPointLiteral
      // including ExponentPart
      {
        begin: `(\\b(${decimalDigits})((${frac})|\\.)?|(${frac}))` + `[eE][+-]?(${decimalDigits})[fFdD]?\\b`
      },
      // excluding ExponentPart
      {
        begin: `\\b(${decimalDigits})((${frac})[fFdD]?\\b|\\.([fFdD]\\b)?)`
      }, {
        begin: `(${frac})[fFdD]?\\b`
      }, {
        begin: `\\b(${decimalDigits})[fFdD]\\b`
      },
      // HexadecimalFloatingPointLiteral
      {
        begin: `\\b0[xX]((${hexDigits})\\.?|(${hexDigits})?\\.(${hexDigits}))` + `[pP][+-]?(${decimalDigits})[fFdD]?\\b`
      },
      // DecimalIntegerLiteral
      {
        begin: '\\b(0|[1-9](_*[0-9])*)[lL]?\\b'
      },
      // HexIntegerLiteral
      {
        begin: `\\b0[xX](${hexDigits})[lL]?\\b`
      },
      // OctalIntegerLiteral
      {
        begin: '\\b0(_*[0-7])*[lL]?\\b'
      },
      // BinaryIntegerLiteral
      {
        begin: '\\b0[bB][01](_*[01])*[lL]?\\b'
      }],
      relevance: 0
    };

    /*
     Language: Kotlin
     Description: Kotlin is an OSS statically typed programming language that targets the JVM, Android, JavaScript and Native.
     Author: Sergey Mashkov <cy6erGn0m@gmail.com>
     Website: https://kotlinlang.org
     Category: common
     */

    function kotlin(hljs) {
      const KEYWORDS = {
        keyword: 'abstract as val var vararg get set class object open private protected public noinline ' + 'crossinline dynamic final enum if else do while for when throw try catch finally ' + 'import package is in fun override companion reified inline lateinit init ' + 'interface annotation data sealed internal infix operator out by constructor super ' + 'tailrec where const inner suspend typealias external expect actual',
        built_in: 'Byte Short Char Int Long Boolean Float Double Void Unit Nothing',
        literal: 'true false null'
      };
      const KEYWORDS_WITH_LABEL = {
        className: 'keyword',
        begin: /\b(break|continue|return|this)\b/,
        starts: {
          contains: [{
            className: 'symbol',
            begin: /@\w+/
          }]
        }
      };
      const LABEL = {
        className: 'symbol',
        begin: hljs.UNDERSCORE_IDENT_RE + '@'
      };

      // for string templates
      const SUBST = {
        className: 'subst',
        begin: /\$\{/,
        end: /\}/,
        contains: [hljs.C_NUMBER_MODE]
      };
      const VARIABLE = {
        className: 'variable',
        begin: '\\$' + hljs.UNDERSCORE_IDENT_RE
      };
      const STRING = {
        className: 'string',
        variants: [{
          begin: '"""',
          end: '"""(?=[^"])',
          contains: [VARIABLE, SUBST]
        },
        // Can't use built-in modes easily, as we want to use STRING in the meta
        // context as 'meta-string' and there's no syntax to remove explicitly set
        // classNames in built-in modes.
        {
          begin: '\'',
          end: '\'',
          illegal: /\n/,
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: '"',
          end: '"',
          illegal: /\n/,
          contains: [hljs.BACKSLASH_ESCAPE, VARIABLE, SUBST]
        }]
      };
      SUBST.contains.push(STRING);
      const ANNOTATION_USE_SITE = {
        className: 'meta',
        begin: '@(?:file|property|field|get|set|receiver|param|setparam|delegate)\\s*:(?:\\s*' + hljs.UNDERSCORE_IDENT_RE + ')?'
      };
      const ANNOTATION = {
        className: 'meta',
        begin: '@' + hljs.UNDERSCORE_IDENT_RE,
        contains: [{
          begin: /\(/,
          end: /\)/,
          contains: [hljs.inherit(STRING, {
            className: 'string'
          }), "self"]
        }]
      };

      // https://kotlinlang.org/docs/reference/whatsnew11.html#underscores-in-numeric-literals
      // According to the doc above, the number mode of kotlin is the same as java 8,
      // so the code below is copied from java.js
      const KOTLIN_NUMBER_MODE = NUMERIC;
      const KOTLIN_NESTED_COMMENT = hljs.COMMENT('/\\*', '\\*/', {
        contains: [hljs.C_BLOCK_COMMENT_MODE]
      });
      const KOTLIN_PAREN_TYPE = {
        variants: [{
          className: 'type',
          begin: hljs.UNDERSCORE_IDENT_RE
        }, {
          begin: /\(/,
          end: /\)/,
          contains: [] // defined later
        }]
      };

      const KOTLIN_PAREN_TYPE2 = KOTLIN_PAREN_TYPE;
      KOTLIN_PAREN_TYPE2.variants[1].contains = [KOTLIN_PAREN_TYPE];
      KOTLIN_PAREN_TYPE.variants[1].contains = [KOTLIN_PAREN_TYPE2];
      return {
        name: 'Kotlin',
        aliases: ['kt', 'kts'],
        keywords: KEYWORDS,
        contains: [hljs.COMMENT('/\\*\\*', '\\*/', {
          relevance: 0,
          contains: [{
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }]
        }), hljs.C_LINE_COMMENT_MODE, KOTLIN_NESTED_COMMENT, KEYWORDS_WITH_LABEL, LABEL, ANNOTATION_USE_SITE, ANNOTATION, {
          className: 'function',
          beginKeywords: 'fun',
          end: '[(]|$',
          returnBegin: true,
          excludeEnd: true,
          keywords: KEYWORDS,
          relevance: 5,
          contains: [{
            begin: hljs.UNDERSCORE_IDENT_RE + '\\s*\\(',
            returnBegin: true,
            relevance: 0,
            contains: [hljs.UNDERSCORE_TITLE_MODE]
          }, {
            className: 'type',
            begin: /</,
            end: />/,
            keywords: 'reified',
            relevance: 0
          }, {
            className: 'params',
            begin: /\(/,
            end: /\)/,
            endsParent: true,
            keywords: KEYWORDS,
            relevance: 0,
            contains: [{
              begin: /:/,
              end: /[=,\/]/,
              endsWithParent: true,
              contains: [KOTLIN_PAREN_TYPE, hljs.C_LINE_COMMENT_MODE, KOTLIN_NESTED_COMMENT],
              relevance: 0
            }, hljs.C_LINE_COMMENT_MODE, KOTLIN_NESTED_COMMENT, ANNOTATION_USE_SITE, ANNOTATION, STRING, hljs.C_NUMBER_MODE]
          }, KOTLIN_NESTED_COMMENT]
        }, {
          begin: [/class|interface|trait/, /\s+/, hljs.UNDERSCORE_IDENT_RE],
          beginScope: {
            3: "title.class"
          },
          keywords: 'class interface trait',
          end: /[:\{(]|$/,
          excludeEnd: true,
          illegal: 'extends implements',
          contains: [{
            beginKeywords: 'public protected internal private constructor'
          }, hljs.UNDERSCORE_TITLE_MODE, {
            className: 'type',
            begin: /</,
            end: />/,
            excludeBegin: true,
            excludeEnd: true,
            relevance: 0
          }, {
            className: 'type',
            begin: /[,:]\s*/,
            end: /[<\(,){\s]|$/,
            excludeBegin: true,
            returnEnd: true
          }, ANNOTATION_USE_SITE, ANNOTATION]
        }, STRING, {
          className: 'meta',
          begin: "^#!/usr/bin/env",
          end: '$',
          illegal: '\n'
        }, KOTLIN_NUMBER_MODE]
      };
    }
    kotlin_1 = kotlin;
    return kotlin_1;
  }

  var less_1;
  var hasRequiredLess;
  function requireLess() {
    if (hasRequiredLess) return less_1;
    hasRequiredLess = 1;
    const MODES = hljs => {
      return {
        IMPORTANT: {
          scope: 'meta',
          begin: '!important'
        },
        BLOCK_COMMENT: hljs.C_BLOCK_COMMENT_MODE,
        HEXCOLOR: {
          scope: 'number',
          begin: /#(([0-9a-fA-F]{3,4})|(([0-9a-fA-F]{2}){3,4}))\b/
        },
        FUNCTION_DISPATCH: {
          className: "built_in",
          begin: /[\w-]+(?=\()/
        },
        ATTRIBUTE_SELECTOR_MODE: {
          scope: 'selector-attr',
          begin: /\[/,
          end: /\]/,
          illegal: '$',
          contains: [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE]
        },
        CSS_NUMBER_MODE: {
          scope: 'number',
          begin: hljs.NUMBER_RE + '(' + '%|em|ex|ch|rem' + '|vw|vh|vmin|vmax' + '|cm|mm|in|pt|pc|px' + '|deg|grad|rad|turn' + '|s|ms' + '|Hz|kHz' + '|dpi|dpcm|dppx' + ')?',
          relevance: 0
        },
        CSS_VARIABLE: {
          className: "attr",
          begin: /--[A-Za-z][A-Za-z0-9_-]*/
        }
      };
    };
    const TAGS = ['a', 'abbr', 'address', 'article', 'aside', 'audio', 'b', 'blockquote', 'body', 'button', 'canvas', 'caption', 'cite', 'code', 'dd', 'del', 'details', 'dfn', 'div', 'dl', 'dt', 'em', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'mark', 'menu', 'nav', 'object', 'ol', 'p', 'q', 'quote', 'samp', 'section', 'span', 'strong', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'ul', 'var', 'video'];
    const MEDIA_FEATURES = ['any-hover', 'any-pointer', 'aspect-ratio', 'color', 'color-gamut', 'color-index', 'device-aspect-ratio', 'device-height', 'device-width', 'display-mode', 'forced-colors', 'grid', 'height', 'hover', 'inverted-colors', 'monochrome', 'orientation', 'overflow-block', 'overflow-inline', 'pointer', 'prefers-color-scheme', 'prefers-contrast', 'prefers-reduced-motion', 'prefers-reduced-transparency', 'resolution', 'scan', 'scripting', 'update', 'width',
    // TODO: find a better solution?
    'min-width', 'max-width', 'min-height', 'max-height'];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-classes
    const PSEUDO_CLASSES = ['active', 'any-link', 'blank', 'checked', 'current', 'default', 'defined', 'dir',
    // dir()
    'disabled', 'drop', 'empty', 'enabled', 'first', 'first-child', 'first-of-type', 'fullscreen', 'future', 'focus', 'focus-visible', 'focus-within', 'has',
    // has()
    'host',
    // host or host()
    'host-context',
    // host-context()
    'hover', 'indeterminate', 'in-range', 'invalid', 'is',
    // is()
    'lang',
    // lang()
    'last-child', 'last-of-type', 'left', 'link', 'local-link', 'not',
    // not()
    'nth-child',
    // nth-child()
    'nth-col',
    // nth-col()
    'nth-last-child',
    // nth-last-child()
    'nth-last-col',
    // nth-last-col()
    'nth-last-of-type',
    //nth-last-of-type()
    'nth-of-type',
    //nth-of-type()
    'only-child', 'only-of-type', 'optional', 'out-of-range', 'past', 'placeholder-shown', 'read-only', 'read-write', 'required', 'right', 'root', 'scope', 'target', 'target-within', 'user-invalid', 'valid', 'visited', 'where' // where()
    ];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-elements
    const PSEUDO_ELEMENTS = ['after', 'backdrop', 'before', 'cue', 'cue-region', 'first-letter', 'first-line', 'grammar-error', 'marker', 'part', 'placeholder', 'selection', 'slotted', 'spelling-error'];
    const ATTRIBUTES = ['align-content', 'align-items', 'align-self', 'all', 'animation', 'animation-delay', 'animation-direction', 'animation-duration', 'animation-fill-mode', 'animation-iteration-count', 'animation-name', 'animation-play-state', 'animation-timing-function', 'backface-visibility', 'background', 'background-attachment', 'background-blend-mode', 'background-clip', 'background-color', 'background-image', 'background-origin', 'background-position', 'background-repeat', 'background-size', 'block-size', 'border', 'border-block', 'border-block-color', 'border-block-end', 'border-block-end-color', 'border-block-end-style', 'border-block-end-width', 'border-block-start', 'border-block-start-color', 'border-block-start-style', 'border-block-start-width', 'border-block-style', 'border-block-width', 'border-bottom', 'border-bottom-color', 'border-bottom-left-radius', 'border-bottom-right-radius', 'border-bottom-style', 'border-bottom-width', 'border-collapse', 'border-color', 'border-image', 'border-image-outset', 'border-image-repeat', 'border-image-slice', 'border-image-source', 'border-image-width', 'border-inline', 'border-inline-color', 'border-inline-end', 'border-inline-end-color', 'border-inline-end-style', 'border-inline-end-width', 'border-inline-start', 'border-inline-start-color', 'border-inline-start-style', 'border-inline-start-width', 'border-inline-style', 'border-inline-width', 'border-left', 'border-left-color', 'border-left-style', 'border-left-width', 'border-radius', 'border-right', 'border-right-color', 'border-right-style', 'border-right-width', 'border-spacing', 'border-style', 'border-top', 'border-top-color', 'border-top-left-radius', 'border-top-right-radius', 'border-top-style', 'border-top-width', 'border-width', 'bottom', 'box-decoration-break', 'box-shadow', 'box-sizing', 'break-after', 'break-before', 'break-inside', 'caption-side', 'caret-color', 'clear', 'clip', 'clip-path', 'clip-rule', 'color', 'column-count', 'column-fill', 'column-gap', 'column-rule', 'column-rule-color', 'column-rule-style', 'column-rule-width', 'column-span', 'column-width', 'columns', 'contain', 'content', 'content-visibility', 'counter-increment', 'counter-reset', 'cue', 'cue-after', 'cue-before', 'cursor', 'direction', 'display', 'empty-cells', 'filter', 'flex', 'flex-basis', 'flex-direction', 'flex-flow', 'flex-grow', 'flex-shrink', 'flex-wrap', 'float', 'flow', 'font', 'font-display', 'font-family', 'font-feature-settings', 'font-kerning', 'font-language-override', 'font-size', 'font-size-adjust', 'font-smoothing', 'font-stretch', 'font-style', 'font-synthesis', 'font-variant', 'font-variant-caps', 'font-variant-east-asian', 'font-variant-ligatures', 'font-variant-numeric', 'font-variant-position', 'font-variation-settings', 'font-weight', 'gap', 'glyph-orientation-vertical', 'grid', 'grid-area', 'grid-auto-columns', 'grid-auto-flow', 'grid-auto-rows', 'grid-column', 'grid-column-end', 'grid-column-start', 'grid-gap', 'grid-row', 'grid-row-end', 'grid-row-start', 'grid-template', 'grid-template-areas', 'grid-template-columns', 'grid-template-rows', 'hanging-punctuation', 'height', 'hyphens', 'icon', 'image-orientation', 'image-rendering', 'image-resolution', 'ime-mode', 'inline-size', 'isolation', 'justify-content', 'left', 'letter-spacing', 'line-break', 'line-height', 'list-style', 'list-style-image', 'list-style-position', 'list-style-type', 'margin', 'margin-block', 'margin-block-end', 'margin-block-start', 'margin-bottom', 'margin-inline', 'margin-inline-end', 'margin-inline-start', 'margin-left', 'margin-right', 'margin-top', 'marks', 'mask', 'mask-border', 'mask-border-mode', 'mask-border-outset', 'mask-border-repeat', 'mask-border-slice', 'mask-border-source', 'mask-border-width', 'mask-clip', 'mask-composite', 'mask-image', 'mask-mode', 'mask-origin', 'mask-position', 'mask-repeat', 'mask-size', 'mask-type', 'max-block-size', 'max-height', 'max-inline-size', 'max-width', 'min-block-size', 'min-height', 'min-inline-size', 'min-width', 'mix-blend-mode', 'nav-down', 'nav-index', 'nav-left', 'nav-right', 'nav-up', 'none', 'normal', 'object-fit', 'object-position', 'opacity', 'order', 'orphans', 'outline', 'outline-color', 'outline-offset', 'outline-style', 'outline-width', 'overflow', 'overflow-wrap', 'overflow-x', 'overflow-y', 'padding', 'padding-block', 'padding-block-end', 'padding-block-start', 'padding-bottom', 'padding-inline', 'padding-inline-end', 'padding-inline-start', 'padding-left', 'padding-right', 'padding-top', 'page-break-after', 'page-break-before', 'page-break-inside', 'pause', 'pause-after', 'pause-before', 'perspective', 'perspective-origin', 'pointer-events', 'position', 'quotes', 'resize', 'rest', 'rest-after', 'rest-before', 'right', 'row-gap', 'scroll-margin', 'scroll-margin-block', 'scroll-margin-block-end', 'scroll-margin-block-start', 'scroll-margin-bottom', 'scroll-margin-inline', 'scroll-margin-inline-end', 'scroll-margin-inline-start', 'scroll-margin-left', 'scroll-margin-right', 'scroll-margin-top', 'scroll-padding', 'scroll-padding-block', 'scroll-padding-block-end', 'scroll-padding-block-start', 'scroll-padding-bottom', 'scroll-padding-inline', 'scroll-padding-inline-end', 'scroll-padding-inline-start', 'scroll-padding-left', 'scroll-padding-right', 'scroll-padding-top', 'scroll-snap-align', 'scroll-snap-stop', 'scroll-snap-type', 'scrollbar-color', 'scrollbar-gutter', 'scrollbar-width', 'shape-image-threshold', 'shape-margin', 'shape-outside', 'speak', 'speak-as', 'src',
    // @font-face
    'tab-size', 'table-layout', 'text-align', 'text-align-all', 'text-align-last', 'text-combine-upright', 'text-decoration', 'text-decoration-color', 'text-decoration-line', 'text-decoration-style', 'text-emphasis', 'text-emphasis-color', 'text-emphasis-position', 'text-emphasis-style', 'text-indent', 'text-justify', 'text-orientation', 'text-overflow', 'text-rendering', 'text-shadow', 'text-transform', 'text-underline-position', 'top', 'transform', 'transform-box', 'transform-origin', 'transform-style', 'transition', 'transition-delay', 'transition-duration', 'transition-property', 'transition-timing-function', 'unicode-bidi', 'vertical-align', 'visibility', 'voice-balance', 'voice-duration', 'voice-family', 'voice-pitch', 'voice-range', 'voice-rate', 'voice-stress', 'voice-volume', 'white-space', 'widows', 'width', 'will-change', 'word-break', 'word-spacing', 'word-wrap', 'writing-mode', 'z-index'
    // reverse makes sure longer attributes `font-weight` are matched fully
    // instead of getting false positives on say `font`
    ].reverse();

    // some grammars use them all as a single group
    const PSEUDO_SELECTORS = PSEUDO_CLASSES.concat(PSEUDO_ELEMENTS);

    /*
    Language: Less
    Description: It's CSS, with just a little more.
    Author:   Max Mikhailov <seven.phases.max@gmail.com>
    Website: http://lesscss.org
    Category: common, css, web
    */

    /** @type LanguageFn */
    function less(hljs) {
      const modes = MODES(hljs);
      const PSEUDO_SELECTORS$1 = PSEUDO_SELECTORS;
      const AT_MODIFIERS = "and or not only";
      const IDENT_RE = '[\\w-]+'; // yes, Less identifiers may begin with a digit
      const INTERP_IDENT_RE = '(' + IDENT_RE + '|@\\{' + IDENT_RE + '\\})';

      /* Generic Modes */

      const RULES = [];
      const VALUE_MODES = []; // forward def. for recursive modes

      const STRING_MODE = function (c) {
        return {
          // Less strings are not multiline (also include '~' for more consistent coloring of "escaped" strings)
          className: 'string',
          begin: '~?' + c + '.*?' + c
        };
      };
      const IDENT_MODE = function (name, begin, relevance) {
        return {
          className: name,
          begin: begin,
          relevance: relevance
        };
      };
      const AT_KEYWORDS = {
        $pattern: /[a-z-]+/,
        keyword: AT_MODIFIERS,
        attribute: MEDIA_FEATURES.join(" ")
      };
      const PARENS_MODE = {
        // used only to properly balance nested parens inside mixin call, def. arg list
        begin: '\\(',
        end: '\\)',
        contains: VALUE_MODES,
        keywords: AT_KEYWORDS,
        relevance: 0
      };

      // generic Less highlighter (used almost everywhere except selectors):
      VALUE_MODES.push(hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, STRING_MODE("'"), STRING_MODE('"'), modes.CSS_NUMBER_MODE,
      // fixme: it does not include dot for numbers like .5em :(
      {
        begin: '(url|data-uri)\\(',
        starts: {
          className: 'string',
          end: '[\\)\\n]',
          excludeEnd: true
        }
      }, modes.HEXCOLOR, PARENS_MODE, IDENT_MODE('variable', '@@?' + IDENT_RE, 10), IDENT_MODE('variable', '@\\{' + IDENT_RE + '\\}'), IDENT_MODE('built_in', '~?`[^`]*?`'),
      // inline javascript (or whatever host language) *multiline* string
      {
        // @media features (it’s here to not duplicate things in AT_RULE_MODE with extra PARENS_MODE overriding):
        className: 'attribute',
        begin: IDENT_RE + '\\s*:',
        end: ':',
        returnBegin: true,
        excludeEnd: true
      }, modes.IMPORTANT, {
        beginKeywords: 'and not'
      }, modes.FUNCTION_DISPATCH);
      const VALUE_WITH_RULESETS = VALUE_MODES.concat({
        begin: /\{/,
        end: /\}/,
        contains: RULES
      });
      const MIXIN_GUARD_MODE = {
        beginKeywords: 'when',
        endsWithParent: true,
        contains: [{
          beginKeywords: 'and not'
        }].concat(VALUE_MODES) // using this form to override VALUE’s 'function' match
      };

      /* Rule-Level Modes */

      const RULE_MODE = {
        begin: INTERP_IDENT_RE + '\\s*:',
        returnBegin: true,
        end: /[;}]/,
        relevance: 0,
        contains: [{
          begin: /-(webkit|moz|ms|o)-/
        }, modes.CSS_VARIABLE, {
          className: 'attribute',
          begin: '\\b(' + ATTRIBUTES.join('|') + ')\\b',
          end: /(?=:)/,
          starts: {
            endsWithParent: true,
            illegal: '[<=$]',
            relevance: 0,
            contains: VALUE_MODES
          }
        }]
      };
      const AT_RULE_MODE = {
        className: 'keyword',
        begin: '@(import|media|charset|font-face|(-[a-z]+-)?keyframes|supports|document|namespace|page|viewport|host)\\b',
        starts: {
          end: '[;{}]',
          keywords: AT_KEYWORDS,
          returnEnd: true,
          contains: VALUE_MODES,
          relevance: 0
        }
      };

      // variable definitions and calls
      const VAR_RULE_MODE = {
        className: 'variable',
        variants: [
        // using more strict pattern for higher relevance to increase chances of Less detection.
        // this is *the only* Less specific statement used in most of the sources, so...
        // (we’ll still often loose to the css-parser unless there's '//' comment,
        // simply because 1 variable just can't beat 99 properties :)
        {
          begin: '@' + IDENT_RE + '\\s*:',
          relevance: 15
        }, {
          begin: '@' + IDENT_RE
        }],
        starts: {
          end: '[;}]',
          returnEnd: true,
          contains: VALUE_WITH_RULESETS
        }
      };
      const SELECTOR_MODE = {
        // first parse unambiguous selectors (i.e. those not starting with tag)
        // then fall into the scary lookahead-discriminator variant.
        // this mode also handles mixin definitions and calls
        variants: [{
          begin: '[\\.#:&\\[>]',
          end: '[;{}]' // mixin calls end with ';'
        }, {
          begin: INTERP_IDENT_RE,
          end: /\{/
        }],
        returnBegin: true,
        returnEnd: true,
        illegal: '[<=\'$"]',
        relevance: 0,
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, MIXIN_GUARD_MODE, IDENT_MODE('keyword', 'all\\b'), IDENT_MODE('variable', '@\\{' + IDENT_RE + '\\}'),
        // otherwise it’s identified as tag

        {
          begin: '\\b(' + TAGS.join('|') + ')\\b',
          className: 'selector-tag'
        }, modes.CSS_NUMBER_MODE, IDENT_MODE('selector-tag', INTERP_IDENT_RE, 0), IDENT_MODE('selector-id', '#' + INTERP_IDENT_RE), IDENT_MODE('selector-class', '\\.' + INTERP_IDENT_RE, 0), IDENT_MODE('selector-tag', '&', 0), modes.ATTRIBUTE_SELECTOR_MODE, {
          className: 'selector-pseudo',
          begin: ':(' + PSEUDO_CLASSES.join('|') + ')'
        }, {
          className: 'selector-pseudo',
          begin: ':(:)?(' + PSEUDO_ELEMENTS.join('|') + ')'
        }, {
          begin: /\(/,
          end: /\)/,
          relevance: 0,
          contains: VALUE_WITH_RULESETS
        },
        // argument list of parametric mixins
        {
          begin: '!important'
        },
        // eat !important after mixin call or it will be colored as tag
        modes.FUNCTION_DISPATCH]
      };
      const PSEUDO_SELECTOR_MODE = {
        begin: IDENT_RE + ':(:)?' + `(${PSEUDO_SELECTORS$1.join('|')})`,
        returnBegin: true,
        contains: [SELECTOR_MODE]
      };
      RULES.push(hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, AT_RULE_MODE, VAR_RULE_MODE, PSEUDO_SELECTOR_MODE, RULE_MODE, SELECTOR_MODE, MIXIN_GUARD_MODE, modes.FUNCTION_DISPATCH);
      return {
        name: 'Less',
        case_insensitive: true,
        illegal: '[=>\'/<($"]',
        contains: RULES
      };
    }
    less_1 = less;
    return less_1;
  }

  /*
  Language: Lua
  Description: Lua is a powerful, efficient, lightweight, embeddable scripting language.
  Author: Andrew Fedorov <dmmdrs@mail.ru>
  Category: common, scripting
  Website: https://www.lua.org
  */
  var lua_1;
  var hasRequiredLua;
  function requireLua() {
    if (hasRequiredLua) return lua_1;
    hasRequiredLua = 1;
    function lua(hljs) {
      const OPENING_LONG_BRACKET = '\\[=*\\[';
      const CLOSING_LONG_BRACKET = '\\]=*\\]';
      const LONG_BRACKETS = {
        begin: OPENING_LONG_BRACKET,
        end: CLOSING_LONG_BRACKET,
        contains: ['self']
      };
      const COMMENTS = [hljs.COMMENT('--(?!' + OPENING_LONG_BRACKET + ')', '$'), hljs.COMMENT('--' + OPENING_LONG_BRACKET, CLOSING_LONG_BRACKET, {
        contains: [LONG_BRACKETS],
        relevance: 10
      })];
      return {
        name: 'Lua',
        keywords: {
          $pattern: hljs.UNDERSCORE_IDENT_RE,
          literal: "true false nil",
          keyword: "and break do else elseif end for goto if in local not or repeat return then until while",
          built_in:
          // Metatags and globals:
          '_G _ENV _VERSION __index __newindex __mode __call __metatable __tostring __len ' + '__gc __add __sub __mul __div __mod __pow __concat __unm __eq __lt __le assert '
          // Standard methods and properties:
          + 'collectgarbage dofile error getfenv getmetatable ipairs load loadfile loadstring ' + 'module next pairs pcall print rawequal rawget rawset require select setfenv ' + 'setmetatable tonumber tostring type unpack xpcall arg self '
          // Library methods and properties (one line per library):
          + 'coroutine resume yield status wrap create running debug getupvalue ' + 'debug sethook getmetatable gethook setmetatable setlocal traceback setfenv getinfo setupvalue getlocal getregistry getfenv ' + 'io lines write close flush open output type read stderr stdin input stdout popen tmpfile ' + 'math log max acos huge ldexp pi cos tanh pow deg tan cosh sinh random randomseed frexp ceil floor rad abs sqrt modf asin min mod fmod log10 atan2 exp sin atan ' + 'os exit setlocale date getenv difftime remove time clock tmpname rename execute package preload loadlib loaded loaders cpath config path seeall ' + 'string sub upper len gfind rep find match char dump gmatch reverse byte format gsub lower ' + 'table setn insert getn foreachi maxn foreach concat sort remove'
        },
        contains: COMMENTS.concat([{
          className: 'function',
          beginKeywords: 'function',
          end: '\\)',
          contains: [hljs.inherit(hljs.TITLE_MODE, {
            begin: '([_a-zA-Z]\\w*\\.)*([_a-zA-Z]\\w*:)?[_a-zA-Z]\\w*'
          }), {
            className: 'params',
            begin: '\\(',
            endsWithParent: true,
            contains: COMMENTS
          }].concat(COMMENTS)
        }, hljs.C_NUMBER_MODE, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, {
          className: 'string',
          begin: OPENING_LONG_BRACKET,
          end: CLOSING_LONG_BRACKET,
          contains: [LONG_BRACKETS],
          relevance: 5
        }])
      };
    }
    lua_1 = lua;
    return lua_1;
  }

  /*
  Language: Makefile
  Author: Ivan Sagalaev <maniac@softwaremaniacs.org>
  Contributors: Joël Porquet <joel@porquet.org>
  Website: https://www.gnu.org/software/make/manual/html_node/Introduction.html
  Category: common
  */
  var makefile_1;
  var hasRequiredMakefile;
  function requireMakefile() {
    if (hasRequiredMakefile) return makefile_1;
    hasRequiredMakefile = 1;
    function makefile(hljs) {
      /* Variables: simple (eg $(var)) and special (eg $@) */
      const VARIABLE = {
        className: 'variable',
        variants: [{
          begin: '\\$\\(' + hljs.UNDERSCORE_IDENT_RE + '\\)',
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: /\$[@%<?\^\+\*]/
        }]
      };
      /* Quoted string with variables inside */
      const QUOTE_STRING = {
        className: 'string',
        begin: /"/,
        end: /"/,
        contains: [hljs.BACKSLASH_ESCAPE, VARIABLE]
      };
      /* Function: $(func arg,...) */
      const FUNC = {
        className: 'variable',
        begin: /\$\([\w-]+\s/,
        end: /\)/,
        keywords: {
          built_in: 'subst patsubst strip findstring filter filter-out sort ' + 'word wordlist firstword lastword dir notdir suffix basename ' + 'addsuffix addprefix join wildcard realpath abspath error warning ' + 'shell origin flavor foreach if or and call eval file value'
        },
        contains: [VARIABLE]
      };
      /* Variable assignment */
      const ASSIGNMENT = {
        begin: '^' + hljs.UNDERSCORE_IDENT_RE + '\\s*(?=[:+?]?=)'
      };
      /* Meta targets (.PHONY) */
      const META = {
        className: 'meta',
        begin: /^\.PHONY:/,
        end: /$/,
        keywords: {
          $pattern: /[\.\w]+/,
          keyword: '.PHONY'
        }
      };
      /* Targets */
      const TARGET = {
        className: 'section',
        begin: /^[^\s]+:/,
        end: /$/,
        contains: [VARIABLE]
      };
      return {
        name: 'Makefile',
        aliases: ['mk', 'mak', 'make'],
        keywords: {
          $pattern: /[\w-]+/,
          keyword: 'define endef undefine ifdef ifndef ifeq ifneq else endif ' + 'include -include sinclude override export unexport private vpath'
        },
        contains: [hljs.HASH_COMMENT_MODE, VARIABLE, QUOTE_STRING, FUNC, ASSIGNMENT, META, TARGET]
      };
    }
    makefile_1 = makefile;
    return makefile_1;
  }

  /*
  Language: Perl
  Author: Peter Leonov <gojpeg@yandex.ru>
  Website: https://www.perl.org
  Category: common
  */
  var perl_1;
  var hasRequiredPerl;
  function requirePerl() {
    if (hasRequiredPerl) return perl_1;
    hasRequiredPerl = 1;
    /** @type LanguageFn */
    function perl(hljs) {
      const regex = hljs.regex;
      const KEYWORDS = ['abs', 'accept', 'alarm', 'and', 'atan2', 'bind', 'binmode', 'bless', 'break', 'caller', 'chdir', 'chmod', 'chomp', 'chop', 'chown', 'chr', 'chroot', 'close', 'closedir', 'connect', 'continue', 'cos', 'crypt', 'dbmclose', 'dbmopen', 'defined', 'delete', 'die', 'do', 'dump', 'each', 'else', 'elsif', 'endgrent', 'endhostent', 'endnetent', 'endprotoent', 'endpwent', 'endservent', 'eof', 'eval', 'exec', 'exists', 'exit', 'exp', 'fcntl', 'fileno', 'flock', 'for', 'foreach', 'fork', 'format', 'formline', 'getc', 'getgrent', 'getgrgid', 'getgrnam', 'gethostbyaddr', 'gethostbyname', 'gethostent', 'getlogin', 'getnetbyaddr', 'getnetbyname', 'getnetent', 'getpeername', 'getpgrp', 'getpriority', 'getprotobyname', 'getprotobynumber', 'getprotoent', 'getpwent', 'getpwnam', 'getpwuid', 'getservbyname', 'getservbyport', 'getservent', 'getsockname', 'getsockopt', 'given', 'glob', 'gmtime', 'goto', 'grep', 'gt', 'hex', 'if', 'index', 'int', 'ioctl', 'join', 'keys', 'kill', 'last', 'lc', 'lcfirst', 'length', 'link', 'listen', 'local', 'localtime', 'log', 'lstat', 'lt', 'ma', 'map', 'mkdir', 'msgctl', 'msgget', 'msgrcv', 'msgsnd', 'my', 'ne', 'next', 'no', 'not', 'oct', 'open', 'opendir', 'or', 'ord', 'our', 'pack', 'package', 'pipe', 'pop', 'pos', 'print', 'printf', 'prototype', 'push', 'q|0', 'qq', 'quotemeta', 'qw', 'qx', 'rand', 'read', 'readdir', 'readline', 'readlink', 'readpipe', 'recv', 'redo', 'ref', 'rename', 'require', 'reset', 'return', 'reverse', 'rewinddir', 'rindex', 'rmdir', 'say', 'scalar', 'seek', 'seekdir', 'select', 'semctl', 'semget', 'semop', 'send', 'setgrent', 'sethostent', 'setnetent', 'setpgrp', 'setpriority', 'setprotoent', 'setpwent', 'setservent', 'setsockopt', 'shift', 'shmctl', 'shmget', 'shmread', 'shmwrite', 'shutdown', 'sin', 'sleep', 'socket', 'socketpair', 'sort', 'splice', 'split', 'sprintf', 'sqrt', 'srand', 'stat', 'state', 'study', 'sub', 'substr', 'symlink', 'syscall', 'sysopen', 'sysread', 'sysseek', 'system', 'syswrite', 'tell', 'telldir', 'tie', 'tied', 'time', 'times', 'tr', 'truncate', 'uc', 'ucfirst', 'umask', 'undef', 'unless', 'unlink', 'unpack', 'unshift', 'untie', 'until', 'use', 'utime', 'values', 'vec', 'wait', 'waitpid', 'wantarray', 'warn', 'when', 'while', 'write', 'x|0', 'xor', 'y|0'];

      // https://perldoc.perl.org/perlre#Modifiers
      const REGEX_MODIFIERS = /[dualxmsipngr]{0,12}/; // aa and xx are valid, making max length 12
      const PERL_KEYWORDS = {
        $pattern: /[\w.]+/,
        keyword: KEYWORDS.join(" ")
      };
      const SUBST = {
        className: 'subst',
        begin: '[$@]\\{',
        end: '\\}',
        keywords: PERL_KEYWORDS
      };
      const METHOD = {
        begin: /->\{/,
        end: /\}/
        // contains defined later
      };

      const VAR = {
        variants: [{
          begin: /\$\d/
        }, {
          begin: regex.concat(/[$%@](\^\w\b|#\w+(::\w+)*|\{\w+\}|\w+(::\w*)*)/,
          // negative look-ahead tries to avoid matching patterns that are not
          // Perl at all like $ident$, @ident@, etc.
          `(?![A-Za-z])(?![@$%])`)
        }, {
          begin: /[$%@][^\s\w{]/,
          relevance: 0
        }]
      };
      const STRING_CONTAINS = [hljs.BACKSLASH_ESCAPE, SUBST, VAR];
      const REGEX_DELIMS = [/!/, /\//, /\|/, /\?/, /'/, /"/,
      // valid but infrequent and weird
      /#/ // valid but infrequent and weird
      ];
      /**
       * @param {string|RegExp} prefix
       * @param {string|RegExp} open
       * @param {string|RegExp} close
       */
      const PAIRED_DOUBLE_RE = (prefix, open, close = '\\1') => {
        const middle = close === '\\1' ? close : regex.concat(close, open);
        return regex.concat(regex.concat("(?:", prefix, ")"), open, /(?:\\.|[^\\\/])*?/, middle, /(?:\\.|[^\\\/])*?/, close, REGEX_MODIFIERS);
      };
      /**
       * @param {string|RegExp} prefix
       * @param {string|RegExp} open
       * @param {string|RegExp} close
       */
      const PAIRED_RE = (prefix, open, close) => {
        return regex.concat(regex.concat("(?:", prefix, ")"), open, /(?:\\.|[^\\\/])*?/, close, REGEX_MODIFIERS);
      };
      const PERL_DEFAULT_CONTAINS = [VAR, hljs.HASH_COMMENT_MODE, hljs.COMMENT(/^=\w/, /=cut/, {
        endsWithParent: true
      }), METHOD, {
        className: 'string',
        contains: STRING_CONTAINS,
        variants: [{
          begin: 'q[qwxr]?\\s*\\(',
          end: '\\)',
          relevance: 5
        }, {
          begin: 'q[qwxr]?\\s*\\[',
          end: '\\]',
          relevance: 5
        }, {
          begin: 'q[qwxr]?\\s*\\{',
          end: '\\}',
          relevance: 5
        }, {
          begin: 'q[qwxr]?\\s*\\|',
          end: '\\|',
          relevance: 5
        }, {
          begin: 'q[qwxr]?\\s*<',
          end: '>',
          relevance: 5
        }, {
          begin: 'qw\\s+q',
          end: 'q',
          relevance: 5
        }, {
          begin: '\'',
          end: '\'',
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: '"',
          end: '"'
        }, {
          begin: '`',
          end: '`',
          contains: [hljs.BACKSLASH_ESCAPE]
        }, {
          begin: /\{\w+\}/,
          relevance: 0
        }, {
          begin: '-?\\w+\\s*=>',
          relevance: 0
        }]
      }, {
        className: 'number',
        begin: '(\\b0[0-7_]+)|(\\b0x[0-9a-fA-F_]+)|(\\b[1-9][0-9_]*(\\.[0-9_]+)?)|[0_]\\b',
        relevance: 0
      }, {
        // regexp container
        begin: '(\\/\\/|' + hljs.RE_STARTERS_RE + '|\\b(split|return|print|reverse|grep)\\b)\\s*',
        keywords: 'split return print reverse grep',
        relevance: 0,
        contains: [hljs.HASH_COMMENT_MODE, {
          className: 'regexp',
          variants: [
          // allow matching common delimiters
          {
            begin: PAIRED_DOUBLE_RE("s|tr|y", regex.either(...REGEX_DELIMS, {
              capture: true
            }))
          },
          // and then paired delmis
          {
            begin: PAIRED_DOUBLE_RE("s|tr|y", "\\(", "\\)")
          }, {
            begin: PAIRED_DOUBLE_RE("s|tr|y", "\\[", "\\]")
          }, {
            begin: PAIRED_DOUBLE_RE("s|tr|y", "\\{", "\\}")
          }],
          relevance: 2
        }, {
          className: 'regexp',
          variants: [{
            // could be a comment in many languages so do not count
            // as relevant
            begin: /(m|qr)\/\//,
            relevance: 0
          },
          // prefix is optional with /regex/
          {
            begin: PAIRED_RE("(?:m|qr)?", /\//, /\//)
          },
          // allow matching common delimiters
          {
            begin: PAIRED_RE("m|qr", regex.either(...REGEX_DELIMS, {
              capture: true
            }), /\1/)
          },
          // allow common paired delmins
          {
            begin: PAIRED_RE("m|qr", /\(/, /\)/)
          }, {
            begin: PAIRED_RE("m|qr", /\[/, /\]/)
          }, {
            begin: PAIRED_RE("m|qr", /\{/, /\}/)
          }]
        }]
      }, {
        className: 'function',
        beginKeywords: 'sub',
        end: '(\\s*\\(.*?\\))?[;{]',
        excludeEnd: true,
        relevance: 5,
        contains: [hljs.TITLE_MODE]
      }, {
        begin: '-\\w\\b',
        relevance: 0
      }, {
        begin: "^__DATA__$",
        end: "^__END__$",
        subLanguage: 'mojolicious',
        contains: [{
          begin: "^@@.*",
          end: "$",
          className: "comment"
        }]
      }];
      SUBST.contains = PERL_DEFAULT_CONTAINS;
      METHOD.contains = PERL_DEFAULT_CONTAINS;
      return {
        name: 'Perl',
        aliases: ['pl', 'pm'],
        keywords: PERL_KEYWORDS,
        contains: PERL_DEFAULT_CONTAINS
      };
    }
    perl_1 = perl;
    return perl_1;
  }

  /*
  Language: Objective-C
  Author: Valerii Hiora <valerii.hiora@gmail.com>
  Contributors: Angel G. Olloqui <angelgarcia.mail@gmail.com>, Matt Diephouse <matt@diephouse.com>, Andrew Farmer <ahfarmer@gmail.com>, Minh Nguyễn <mxn@1ec5.org>
  Website: https://developer.apple.com/documentation/objectivec
  Category: common
  */
  var objectivec_1;
  var hasRequiredObjectivec;
  function requireObjectivec() {
    if (hasRequiredObjectivec) return objectivec_1;
    hasRequiredObjectivec = 1;
    function objectivec(hljs) {
      const API_CLASS = {
        className: 'built_in',
        begin: '\\b(AV|CA|CF|CG|CI|CL|CM|CN|CT|MK|MP|MTK|MTL|NS|SCN|SK|UI|WK|XC)\\w+'
      };
      const IDENTIFIER_RE = /[a-zA-Z@][a-zA-Z0-9_]*/;
      const TYPES = ["int", "float", "char", "unsigned", "signed", "short", "long", "double", "wchar_t", "unichar", "void", "bool", "BOOL", "id|0", "_Bool"];
      const KWS = ["while", "export", "sizeof", "typedef", "const", "struct", "for", "union", "volatile", "static", "mutable", "if", "do", "return", "goto", "enum", "else", "break", "extern", "asm", "case", "default", "register", "explicit", "typename", "switch", "continue", "inline", "readonly", "assign", "readwrite", "self", "@synchronized", "id", "typeof", "nonatomic", "IBOutlet", "IBAction", "strong", "weak", "copy", "in", "out", "inout", "bycopy", "byref", "oneway", "__strong", "__weak", "__block", "__autoreleasing", "@private", "@protected", "@public", "@try", "@property", "@end", "@throw", "@catch", "@finally", "@autoreleasepool", "@synthesize", "@dynamic", "@selector", "@optional", "@required", "@encode", "@package", "@import", "@defs", "@compatibility_alias", "__bridge", "__bridge_transfer", "__bridge_retained", "__bridge_retain", "__covariant", "__contravariant", "__kindof", "_Nonnull", "_Nullable", "_Null_unspecified", "__FUNCTION__", "__PRETTY_FUNCTION__", "__attribute__", "getter", "setter", "retain", "unsafe_unretained", "nonnull", "nullable", "null_unspecified", "null_resettable", "class", "instancetype", "NS_DESIGNATED_INITIALIZER", "NS_UNAVAILABLE", "NS_REQUIRES_SUPER", "NS_RETURNS_INNER_POINTER", "NS_INLINE", "NS_AVAILABLE", "NS_DEPRECATED", "NS_ENUM", "NS_OPTIONS", "NS_SWIFT_UNAVAILABLE", "NS_ASSUME_NONNULL_BEGIN", "NS_ASSUME_NONNULL_END", "NS_REFINED_FOR_SWIFT", "NS_SWIFT_NAME", "NS_SWIFT_NOTHROW", "NS_DURING", "NS_HANDLER", "NS_ENDHANDLER", "NS_VALUERETURN", "NS_VOIDRETURN"];
      const LITERALS = ["false", "true", "FALSE", "TRUE", "nil", "YES", "NO", "NULL"];
      const BUILT_INS = ["dispatch_once_t", "dispatch_queue_t", "dispatch_sync", "dispatch_async", "dispatch_once"];
      const KEYWORDS = {
        "variable.language": ["this", "super"],
        $pattern: IDENTIFIER_RE,
        keyword: KWS,
        literal: LITERALS,
        built_in: BUILT_INS,
        type: TYPES
      };
      const CLASS_KEYWORDS = {
        $pattern: IDENTIFIER_RE,
        keyword: ["@interface", "@class", "@protocol", "@implementation"]
      };
      return {
        name: 'Objective-C',
        aliases: ['mm', 'objc', 'obj-c', 'obj-c++', 'objective-c++'],
        keywords: KEYWORDS,
        illegal: '</',
        contains: [API_CLASS, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE, hljs.C_NUMBER_MODE, hljs.QUOTE_STRING_MODE, hljs.APOS_STRING_MODE, {
          className: 'string',
          variants: [{
            begin: '@"',
            end: '"',
            illegal: '\\n',
            contains: [hljs.BACKSLASH_ESCAPE]
          }]
        }, {
          className: 'meta',
          begin: /#\s*[a-z]+\b/,
          end: /$/,
          keywords: {
            keyword: 'if else elif endif define undef warning error line ' + 'pragma ifdef ifndef include'
          },
          contains: [{
            begin: /\\\n/,
            relevance: 0
          }, hljs.inherit(hljs.QUOTE_STRING_MODE, {
            className: 'string'
          }), {
            className: 'string',
            begin: /<.*?>/,
            end: /$/,
            illegal: '\\n'
          }, hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE]
        }, {
          className: 'class',
          begin: '(' + CLASS_KEYWORDS.keyword.join('|') + ')\\b',
          end: /(\{|$)/,
          excludeEnd: true,
          keywords: CLASS_KEYWORDS,
          contains: [hljs.UNDERSCORE_TITLE_MODE]
        }, {
          begin: '\\.' + hljs.UNDERSCORE_IDENT_RE,
          relevance: 0
        }]
      };
    }
    objectivec_1 = objectivec;
    return objectivec_1;
  }

  /*
  Language: PHP
  Author: Victor Karamzin <Victor.Karamzin@enterra-inc.com>
  Contributors: Evgeny Stepanischev <imbolk@gmail.com>, Ivan Sagalaev <maniac@softwaremaniacs.org>
  Website: https://www.php.net
  Category: common
  */
  var php_1;
  var hasRequiredPhp;
  function requirePhp() {
    if (hasRequiredPhp) return php_1;
    hasRequiredPhp = 1;
    /**
     * @param {HLJSApi} hljs
     * @returns {LanguageDetail}
     * */
    function php(hljs) {
      const regex = hljs.regex;
      // negative look-ahead tries to avoid matching patterns that are not
      // Perl at all like $ident$, @ident@, etc.
      const NOT_PERL_ETC = /(?![A-Za-z0-9])(?![$])/;
      const IDENT_RE = regex.concat(/[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*/, NOT_PERL_ETC);
      // Will not detect camelCase classes
      const PASCAL_CASE_CLASS_NAME_RE = regex.concat(/(\\?[A-Z][a-z0-9_\x7f-\xff]+|\\?[A-Z]+(?=[A-Z][a-z0-9_\x7f-\xff])){1,}/, NOT_PERL_ETC);
      const VARIABLE = {
        scope: 'variable',
        match: '\\$+' + IDENT_RE
      };
      const PREPROCESSOR = {
        scope: 'meta',
        variants: [{
          begin: /<\?php/,
          relevance: 10
        },
        // boost for obvious PHP
        {
          begin: /<\?=/
        },
        // less relevant per PSR-1 which says not to use short-tags
        {
          begin: /<\?/,
          relevance: 0.1
        }, {
          begin: /\?>/
        } // end php tag
        ]
      };

      const SUBST = {
        scope: 'subst',
        variants: [{
          begin: /\$\w+/
        }, {
          begin: /\{\$/,
          end: /\}/
        }]
      };
      const SINGLE_QUOTED = hljs.inherit(hljs.APOS_STRING_MODE, {
        illegal: null
      });
      const DOUBLE_QUOTED = hljs.inherit(hljs.QUOTE_STRING_MODE, {
        illegal: null,
        contains: hljs.QUOTE_STRING_MODE.contains.concat(SUBST)
      });
      const HEREDOC = {
        begin: /<<<[ \t]*(?:(\w+)|"(\w+)")\n/,
        end: /[ \t]*(\w+)\b/,
        contains: hljs.QUOTE_STRING_MODE.contains.concat(SUBST),
        'on:begin': (m, resp) => {
          resp.data._beginMatch = m[1] || m[2];
        },
        'on:end': (m, resp) => {
          if (resp.data._beginMatch !== m[1]) resp.ignoreMatch();
        }
      };
      const NOWDOC = hljs.END_SAME_AS_BEGIN({
        begin: /<<<[ \t]*'(\w+)'\n/,
        end: /[ \t]*(\w+)\b/
      });
      // list of valid whitespaces because non-breaking space might be part of a IDENT_RE
      const WHITESPACE = '[ \t\n]';
      const STRING = {
        scope: 'string',
        variants: [DOUBLE_QUOTED, SINGLE_QUOTED, HEREDOC, NOWDOC]
      };
      const NUMBER = {
        scope: 'number',
        variants: [{
          begin: `\\b0[bB][01]+(?:_[01]+)*\\b`
        },
        // Binary w/ underscore support
        {
          begin: `\\b0[oO][0-7]+(?:_[0-7]+)*\\b`
        },
        // Octals w/ underscore support
        {
          begin: `\\b0[xX][\\da-fA-F]+(?:_[\\da-fA-F]+)*\\b`
        },
        // Hex w/ underscore support
        // Decimals w/ underscore support, with optional fragments and scientific exponent (e) suffix.
        {
          begin: `(?:\\b\\d+(?:_\\d+)*(\\.(?:\\d+(?:_\\d+)*))?|\\B\\.\\d+)(?:[eE][+-]?\\d+)?`
        }],
        relevance: 0
      };
      const LITERALS = ["false", "null", "true"];
      const KWS = [
      // Magic constants:
      // <https://www.php.net/manual/en/language.constants.predefined.php>
      "__CLASS__", "__DIR__", "__FILE__", "__FUNCTION__", "__COMPILER_HALT_OFFSET__", "__LINE__", "__METHOD__", "__NAMESPACE__", "__TRAIT__",
      // Function that look like language construct or language construct that look like function:
      // List of keywords that may not require parenthesis
      "die", "echo", "exit", "include", "include_once", "print", "require", "require_once",
      // These are not language construct (function) but operate on the currently-executing function and can access the current symbol table
      // 'compact extract func_get_arg func_get_args func_num_args get_called_class get_parent_class ' +
      // Other keywords:
      // <https://www.php.net/manual/en/reserved.php>
      // <https://www.php.net/manual/en/language.types.type-juggling.php>
      "array", "abstract", "and", "as", "binary", "bool", "boolean", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "do", "double", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "enum", "eval", "extends", "final", "finally", "float", "for", "foreach", "from", "global", "goto", "if", "implements", "instanceof", "insteadof", "int", "integer", "interface", "isset", "iterable", "list", "match|0", "mixed", "new", "never", "object", "or", "private", "protected", "public", "readonly", "real", "return", "string", "switch", "throw", "trait", "try", "unset", "use", "var", "void", "while", "xor", "yield"];
      const BUILT_INS = [
      // Standard PHP library:
      // <https://www.php.net/manual/en/book.spl.php>
      "Error|0", "AppendIterator", "ArgumentCountError", "ArithmeticError", "ArrayIterator", "ArrayObject", "AssertionError", "BadFunctionCallException", "BadMethodCallException", "CachingIterator", "CallbackFilterIterator", "CompileError", "Countable", "DirectoryIterator", "DivisionByZeroError", "DomainException", "EmptyIterator", "ErrorException", "Exception", "FilesystemIterator", "FilterIterator", "GlobIterator", "InfiniteIterator", "InvalidArgumentException", "IteratorIterator", "LengthException", "LimitIterator", "LogicException", "MultipleIterator", "NoRewindIterator", "OutOfBoundsException", "OutOfRangeException", "OuterIterator", "OverflowException", "ParentIterator", "ParseError", "RangeException", "RecursiveArrayIterator", "RecursiveCachingIterator", "RecursiveCallbackFilterIterator", "RecursiveDirectoryIterator", "RecursiveFilterIterator", "RecursiveIterator", "RecursiveIteratorIterator", "RecursiveRegexIterator", "RecursiveTreeIterator", "RegexIterator", "RuntimeException", "SeekableIterator", "SplDoublyLinkedList", "SplFileInfo", "SplFileObject", "SplFixedArray", "SplHeap", "SplMaxHeap", "SplMinHeap", "SplObjectStorage", "SplObserver", "SplPriorityQueue", "SplQueue", "SplStack", "SplSubject", "SplTempFileObject", "TypeError", "UnderflowException", "UnexpectedValueException", "UnhandledMatchError",
      // Reserved interfaces:
      // <https://www.php.net/manual/en/reserved.interfaces.php>
      "ArrayAccess", "BackedEnum", "Closure", "Fiber", "Generator", "Iterator", "IteratorAggregate", "Serializable", "Stringable", "Throwable", "Traversable", "UnitEnum", "WeakReference", "WeakMap",
      // Reserved classes:
      // <https://www.php.net/manual/en/reserved.classes.php>
      "Directory", "__PHP_Incomplete_Class", "parent", "php_user_filter", "self", "static", "stdClass"];

      /** Dual-case keywords
       *
       * ["then","FILE"] =>
       *     ["then", "THEN", "FILE", "file"]
       *
       * @param {string[]} items */
      const dualCase = items => {
        /** @type string[] */
        const result = [];
        items.forEach(item => {
          result.push(item);
          if (item.toLowerCase() === item) {
            result.push(item.toUpperCase());
          } else {
            result.push(item.toLowerCase());
          }
        });
        return result;
      };
      const KEYWORDS = {
        keyword: KWS,
        literal: dualCase(LITERALS),
        built_in: BUILT_INS
      };

      /**
       * @param {string[]} items */
      const normalizeKeywords = items => {
        return items.map(item => {
          return item.replace(/\|\d+$/, "");
        });
      };
      const CONSTRUCTOR_CALL = {
        variants: [{
          match: [/new/, regex.concat(WHITESPACE, "+"),
          // to prevent built ins from being confused as the class constructor call
          regex.concat("(?!", normalizeKeywords(BUILT_INS).join("\\b|"), "\\b)"), PASCAL_CASE_CLASS_NAME_RE],
          scope: {
            1: "keyword",
            4: "title.class"
          }
        }]
      };
      const CONSTANT_REFERENCE = regex.concat(IDENT_RE, "\\b(?!\\()");
      const LEFT_AND_RIGHT_SIDE_OF_DOUBLE_COLON = {
        variants: [{
          match: [regex.concat(/::/, regex.lookahead(/(?!class\b)/)), CONSTANT_REFERENCE],
          scope: {
            2: "variable.constant"
          }
        }, {
          match: [/::/, /class/],
          scope: {
            2: "variable.language"
          }
        }, {
          match: [PASCAL_CASE_CLASS_NAME_RE, regex.concat(/::/, regex.lookahead(/(?!class\b)/)), CONSTANT_REFERENCE],
          scope: {
            1: "title.class",
            3: "variable.constant"
          }
        }, {
          match: [PASCAL_CASE_CLASS_NAME_RE, regex.concat("::", regex.lookahead(/(?!class\b)/))],
          scope: {
            1: "title.class"
          }
        }, {
          match: [PASCAL_CASE_CLASS_NAME_RE, /::/, /class/],
          scope: {
            1: "title.class",
            3: "variable.language"
          }
        }]
      };
      const NAMED_ARGUMENT = {
        scope: 'attr',
        match: regex.concat(IDENT_RE, regex.lookahead(':'), regex.lookahead(/(?!::)/))
      };
      const PARAMS_MODE = {
        relevance: 0,
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        contains: [NAMED_ARGUMENT, VARIABLE, LEFT_AND_RIGHT_SIDE_OF_DOUBLE_COLON, hljs.C_BLOCK_COMMENT_MODE, STRING, NUMBER, CONSTRUCTOR_CALL]
      };
      const FUNCTION_INVOKE = {
        relevance: 0,
        match: [/\b/,
        // to prevent keywords from being confused as the function title
        regex.concat("(?!fn\\b|function\\b|", normalizeKeywords(KWS).join("\\b|"), "|", normalizeKeywords(BUILT_INS).join("\\b|"), "\\b)"), IDENT_RE, regex.concat(WHITESPACE, "*"), regex.lookahead(/(?=\()/)],
        scope: {
          3: "title.function.invoke"
        },
        contains: [PARAMS_MODE]
      };
      PARAMS_MODE.contains.push(FUNCTION_INVOKE);
      const ATTRIBUTE_CONTAINS = [NAMED_ARGUMENT, LEFT_AND_RIGHT_SIDE_OF_DOUBLE_COLON, hljs.C_BLOCK_COMMENT_MODE, STRING, NUMBER, CONSTRUCTOR_CALL];
      const ATTRIBUTES = {
        begin: regex.concat(/#\[\s*/, PASCAL_CASE_CLASS_NAME_RE),
        beginScope: "meta",
        end: /]/,
        endScope: "meta",
        keywords: {
          literal: LITERALS,
          keyword: ['new', 'array']
        },
        contains: [{
          begin: /\[/,
          end: /]/,
          keywords: {
            literal: LITERALS,
            keyword: ['new', 'array']
          },
          contains: ['self', ...ATTRIBUTE_CONTAINS]
        }, ...ATTRIBUTE_CONTAINS, {
          scope: 'meta',
          match: PASCAL_CASE_CLASS_NAME_RE
        }]
      };
      return {
        case_insensitive: false,
        keywords: KEYWORDS,
        contains: [ATTRIBUTES, hljs.HASH_COMMENT_MODE, hljs.COMMENT('//', '$'), hljs.COMMENT('/\\*', '\\*/', {
          contains: [{
            scope: 'doctag',
            match: '@[A-Za-z]+'
          }]
        }), {
          match: /__halt_compiler\(\);/,
          keywords: '__halt_compiler',
          starts: {
            scope: "comment",
            end: hljs.MATCH_NOTHING_RE,
            contains: [{
              match: /\?>/,
              scope: "meta",
              endsParent: true
            }]
          }
        }, PREPROCESSOR, {
          scope: 'variable.language',
          match: /\$this\b/
        }, VARIABLE, FUNCTION_INVOKE, LEFT_AND_RIGHT_SIDE_OF_DOUBLE_COLON, {
          match: [/const/, /\s/, IDENT_RE],
          scope: {
            1: "keyword",
            3: "variable.constant"
          }
        }, CONSTRUCTOR_CALL, {
          scope: 'function',
          relevance: 0,
          beginKeywords: 'fn function',
          end: /[;{]/,
          excludeEnd: true,
          illegal: '[$%\\[]',
          contains: [{
            beginKeywords: 'use'
          }, hljs.UNDERSCORE_TITLE_MODE, {
            begin: '=>',
            // No markup, just a relevance booster
            endsParent: true
          }, {
            scope: 'params',
            begin: '\\(',
            end: '\\)',
            excludeBegin: true,
            excludeEnd: true,
            keywords: KEYWORDS,
            contains: ['self', VARIABLE, LEFT_AND_RIGHT_SIDE_OF_DOUBLE_COLON, hljs.C_BLOCK_COMMENT_MODE, STRING, NUMBER]
          }]
        }, {
          scope: 'class',
          variants: [{
            beginKeywords: "enum",
            illegal: /[($"]/
          }, {
            beginKeywords: "class interface trait",
            illegal: /[:($"]/
          }],
          relevance: 0,
          end: /\{/,
          excludeEnd: true,
          contains: [{
            beginKeywords: 'extends implements'
          }, hljs.UNDERSCORE_TITLE_MODE]
        },
        // both use and namespace still use "old style" rules (vs multi-match)
        // because the namespace name can include `\` and we still want each
        // element to be treated as its own *individual* title
        {
          beginKeywords: 'namespace',
          relevance: 0,
          end: ';',
          illegal: /[.']/,
          contains: [hljs.inherit(hljs.UNDERSCORE_TITLE_MODE, {
            scope: "title.class"
          })]
        }, {
          beginKeywords: 'use',
          relevance: 0,
          end: ';',
          contains: [
          // TODO: title.function vs title.class
          {
            match: /\b(as|const|function)\b/,
            scope: "keyword"
          },
          // TODO: could be title.class or title.function
          hljs.UNDERSCORE_TITLE_MODE]
        }, STRING, NUMBER]
      };
    }
    php_1 = php;
    return php_1;
  }

  /*
  Language: PHP Template
  Requires: xml.js, php.js
  Author: Josh Goebel <hello@joshgoebel.com>
  Website: https://www.php.net
  Category: common
  */
  var phpTemplate_1;
  var hasRequiredPhpTemplate;
  function requirePhpTemplate() {
    if (hasRequiredPhpTemplate) return phpTemplate_1;
    hasRequiredPhpTemplate = 1;
    function phpTemplate(hljs) {
      return {
        name: "PHP template",
        subLanguage: 'xml',
        contains: [{
          begin: /<\?(php|=)?/,
          end: /\?>/,
          subLanguage: 'php',
          contains: [
          // We don't want the php closing tag ?> to close the PHP block when
          // inside any of the following blocks:
          {
            begin: '/\\*',
            end: '\\*/',
            skip: true
          }, {
            begin: 'b"',
            end: '"',
            skip: true
          }, {
            begin: 'b\'',
            end: '\'',
            skip: true
          }, hljs.inherit(hljs.APOS_STRING_MODE, {
            illegal: null,
            className: null,
            contains: null,
            skip: true
          }), hljs.inherit(hljs.QUOTE_STRING_MODE, {
            illegal: null,
            className: null,
            contains: null,
            skip: true
          })]
        }]
      };
    }
    phpTemplate_1 = phpTemplate;
    return phpTemplate_1;
  }

  /*
  Language: Plain text
  Author: Egor Rogov (e.rogov@postgrespro.ru)
  Description: Plain text without any highlighting.
  Category: common
  */
  var plaintext_1;
  var hasRequiredPlaintext;
  function requirePlaintext() {
    if (hasRequiredPlaintext) return plaintext_1;
    hasRequiredPlaintext = 1;
    function plaintext(hljs) {
      return {
        name: 'Plain text',
        aliases: ['text', 'txt'],
        disableAutodetect: true
      };
    }
    plaintext_1 = plaintext;
    return plaintext_1;
  }

  /*
  Language: Python
  Description: Python is an interpreted, object-oriented, high-level programming language with dynamic semantics.
  Website: https://www.python.org
  Category: common
  */
  var python_1;
  var hasRequiredPython;
  function requirePython() {
    if (hasRequiredPython) return python_1;
    hasRequiredPython = 1;
    function python(hljs) {
      const regex = hljs.regex;
      const IDENT_RE = /[\p{XID_Start}_]\p{XID_Continue}*/u;
      const RESERVED_WORDS = ['and', 'as', 'assert', 'async', 'await', 'break', 'case', 'class', 'continue', 'def', 'del', 'elif', 'else', 'except', 'finally', 'for', 'from', 'global', 'if', 'import', 'in', 'is', 'lambda', 'match', 'nonlocal|10', 'not', 'or', 'pass', 'raise', 'return', 'try', 'while', 'with', 'yield'];
      const BUILT_INS = ['__import__', 'abs', 'all', 'any', 'ascii', 'bin', 'bool', 'breakpoint', 'bytearray', 'bytes', 'callable', 'chr', 'classmethod', 'compile', 'complex', 'delattr', 'dict', 'dir', 'divmod', 'enumerate', 'eval', 'exec', 'filter', 'float', 'format', 'frozenset', 'getattr', 'globals', 'hasattr', 'hash', 'help', 'hex', 'id', 'input', 'int', 'isinstance', 'issubclass', 'iter', 'len', 'list', 'locals', 'map', 'max', 'memoryview', 'min', 'next', 'object', 'oct', 'open', 'ord', 'pow', 'print', 'property', 'range', 'repr', 'reversed', 'round', 'set', 'setattr', 'slice', 'sorted', 'staticmethod', 'str', 'sum', 'super', 'tuple', 'type', 'vars', 'zip'];
      const LITERALS = ['__debug__', 'Ellipsis', 'False', 'None', 'NotImplemented', 'True'];

      // https://docs.python.org/3/library/typing.html
      // TODO: Could these be supplemented by a CamelCase matcher in certain
      // contexts, leaving these remaining only for relevance hinting?
      const TYPES = ["Any", "Callable", "Coroutine", "Dict", "List", "Literal", "Generic", "Optional", "Sequence", "Set", "Tuple", "Type", "Union"];
      const KEYWORDS = {
        $pattern: /[A-Za-z]\w+|__\w+__/,
        keyword: RESERVED_WORDS,
        built_in: BUILT_INS,
        literal: LITERALS,
        type: TYPES
      };
      const PROMPT = {
        className: 'meta',
        begin: /^(>>>|\.\.\.) /
      };
      const SUBST = {
        className: 'subst',
        begin: /\{/,
        end: /\}/,
        keywords: KEYWORDS,
        illegal: /#/
      };
      const LITERAL_BRACKET = {
        begin: /\{\{/,
        relevance: 0
      };
      const STRING = {
        className: 'string',
        contains: [hljs.BACKSLASH_ESCAPE],
        variants: [{
          begin: /([uU]|[bB]|[rR]|[bB][rR]|[rR][bB])?'''/,
          end: /'''/,
          contains: [hljs.BACKSLASH_ESCAPE, PROMPT],
          relevance: 10
        }, {
          begin: /([uU]|[bB]|[rR]|[bB][rR]|[rR][bB])?"""/,
          end: /"""/,
          contains: [hljs.BACKSLASH_ESCAPE, PROMPT],
          relevance: 10
        }, {
          begin: /([fF][rR]|[rR][fF]|[fF])'''/,
          end: /'''/,
          contains: [hljs.BACKSLASH_ESCAPE, PROMPT, LITERAL_BRACKET, SUBST]
        }, {
          begin: /([fF][rR]|[rR][fF]|[fF])"""/,
          end: /"""/,
          contains: [hljs.BACKSLASH_ESCAPE, PROMPT, LITERAL_BRACKET, SUBST]
        }, {
          begin: /([uU]|[rR])'/,
          end: /'/,
          relevance: 10
        }, {
          begin: /([uU]|[rR])"/,
          end: /"/,
          relevance: 10
        }, {
          begin: /([bB]|[bB][rR]|[rR][bB])'/,
          end: /'/
        }, {
          begin: /([bB]|[bB][rR]|[rR][bB])"/,
          end: /"/
        }, {
          begin: /([fF][rR]|[rR][fF]|[fF])'/,
          end: /'/,
          contains: [hljs.BACKSLASH_ESCAPE, LITERAL_BRACKET, SUBST]
        }, {
          begin: /([fF][rR]|[rR][fF]|[fF])"/,
          end: /"/,
          contains: [hljs.BACKSLASH_ESCAPE, LITERAL_BRACKET, SUBST]
        }, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE]
      };

      // https://docs.python.org/3.9/reference/lexical_analysis.html#numeric-literals
      const digitpart = '[0-9](_?[0-9])*';
      const pointfloat = `(\\b(${digitpart}))?\\.(${digitpart})|\\b(${digitpart})\\.`;
      // Whitespace after a number (or any lexical token) is needed only if its absence
      // would change the tokenization
      // https://docs.python.org/3.9/reference/lexical_analysis.html#whitespace-between-tokens
      // We deviate slightly, requiring a word boundary or a keyword
      // to avoid accidentally recognizing *prefixes* (e.g., `0` in `0x41` or `08` or `0__1`)
      const lookahead = `\\b|${RESERVED_WORDS.join('|')}`;
      const NUMBER = {
        className: 'number',
        relevance: 0,
        variants: [
        // exponentfloat, pointfloat
        // https://docs.python.org/3.9/reference/lexical_analysis.html#floating-point-literals
        // optionally imaginary
        // https://docs.python.org/3.9/reference/lexical_analysis.html#imaginary-literals
        // Note: no leading \b because floats can start with a decimal point
        // and we don't want to mishandle e.g. `fn(.5)`,
        // no trailing \b for pointfloat because it can end with a decimal point
        // and we don't want to mishandle e.g. `0..hex()`; this should be safe
        // because both MUST contain a decimal point and so cannot be confused with
        // the interior part of an identifier
        {
          begin: `(\\b(${digitpart})|(${pointfloat}))[eE][+-]?(${digitpart})[jJ]?(?=${lookahead})`
        }, {
          begin: `(${pointfloat})[jJ]?`
        },
        // decinteger, bininteger, octinteger, hexinteger
        // https://docs.python.org/3.9/reference/lexical_analysis.html#integer-literals
        // optionally "long" in Python 2
        // https://docs.python.org/2.7/reference/lexical_analysis.html#integer-and-long-integer-literals
        // decinteger is optionally imaginary
        // https://docs.python.org/3.9/reference/lexical_analysis.html#imaginary-literals
        {
          begin: `\\b([1-9](_?[0-9])*|0+(_?0)*)[lLjJ]?(?=${lookahead})`
        }, {
          begin: `\\b0[bB](_?[01])+[lL]?(?=${lookahead})`
        }, {
          begin: `\\b0[oO](_?[0-7])+[lL]?(?=${lookahead})`
        }, {
          begin: `\\b0[xX](_?[0-9a-fA-F])+[lL]?(?=${lookahead})`
        },
        // imagnumber (digitpart-based)
        // https://docs.python.org/3.9/reference/lexical_analysis.html#imaginary-literals
        {
          begin: `\\b(${digitpart})[jJ](?=${lookahead})`
        }]
      };
      const COMMENT_TYPE = {
        className: "comment",
        begin: regex.lookahead(/# type:/),
        end: /$/,
        keywords: KEYWORDS,
        contains: [{
          // prevent keywords from coloring `type`
          begin: /# type:/
        },
        // comment within a datatype comment includes no keywords
        {
          begin: /#/,
          end: /\b\B/,
          endsWithParent: true
        }]
      };
      const PARAMS = {
        className: 'params',
        variants: [
        // Exclude params in functions without params
        {
          className: "",
          begin: /\(\s*\)/,
          skip: true
        }, {
          begin: /\(/,
          end: /\)/,
          excludeBegin: true,
          excludeEnd: true,
          keywords: KEYWORDS,
          contains: ['self', PROMPT, NUMBER, STRING, hljs.HASH_COMMENT_MODE]
        }]
      };
      SUBST.contains = [STRING, NUMBER, PROMPT];
      return {
        name: 'Python',
        aliases: ['py', 'gyp', 'ipython'],
        unicodeRegex: true,
        keywords: KEYWORDS,
        illegal: /(<\/|\?)|=>/,
        contains: [PROMPT, NUMBER, {
          // very common convention
          begin: /\bself\b/
        }, {
          // eat "if" prior to string so that it won't accidentally be
          // labeled as an f-string
          beginKeywords: "if",
          relevance: 0
        }, STRING, COMMENT_TYPE, hljs.HASH_COMMENT_MODE, {
          match: [/\bdef/, /\s+/, IDENT_RE],
          scope: {
            1: "keyword",
            3: "title.function"
          },
          contains: [PARAMS]
        }, {
          variants: [{
            match: [/\bclass/, /\s+/, IDENT_RE, /\s*/, /\(\s*/, IDENT_RE, /\s*\)/]
          }, {
            match: [/\bclass/, /\s+/, IDENT_RE]
          }],
          scope: {
            1: "keyword",
            3: "title.class",
            6: "title.class.inherited"
          }
        }, {
          className: 'meta',
          begin: /^[\t ]*@/,
          end: /(?=#)|$/,
          contains: [NUMBER, PARAMS, STRING]
        }]
      };
    }
    python_1 = python;
    return python_1;
  }

  /*
  Language: Python REPL
  Requires: python.js
  Author: Josh Goebel <hello@joshgoebel.com>
  Category: common
  */
  var pythonRepl_1;
  var hasRequiredPythonRepl;
  function requirePythonRepl() {
    if (hasRequiredPythonRepl) return pythonRepl_1;
    hasRequiredPythonRepl = 1;
    function pythonRepl(hljs) {
      return {
        aliases: ['pycon'],
        contains: [{
          className: 'meta.prompt',
          starts: {
            // a space separates the REPL prefix from the actual code
            // this is purely for cleaner HTML output
            end: / |$/,
            starts: {
              end: '$',
              subLanguage: 'python'
            }
          },
          variants: [{
            begin: /^>>>(?=[ ]|$)/
          }, {
            begin: /^\.\.\.(?=[ ]|$)/
          }]
        }]
      };
    }
    pythonRepl_1 = pythonRepl;
    return pythonRepl_1;
  }

  /*
  Language: R
  Description: R is a free software environment for statistical computing and graphics.
  Author: Joe Cheng <joe@rstudio.org>
  Contributors: Konrad Rudolph <konrad.rudolph@gmail.com>
  Website: https://www.r-project.org
  Category: common,scientific
  */
  var r_1;
  var hasRequiredR;
  function requireR() {
    if (hasRequiredR) return r_1;
    hasRequiredR = 1;
    /** @type LanguageFn */
    function r(hljs) {
      const regex = hljs.regex;
      // Identifiers in R cannot start with `_`, but they can start with `.` if it
      // is not immediately followed by a digit.
      // R also supports quoted identifiers, which are near-arbitrary sequences
      // delimited by backticks (`…`), which may contain escape sequences. These are
      // handled in a separate mode. See `test/markup/r/names.txt` for examples.
      // FIXME: Support Unicode identifiers.
      const IDENT_RE = /(?:(?:[a-zA-Z]|\.[._a-zA-Z])[._a-zA-Z0-9]*)|\.(?!\d)/;
      const NUMBER_TYPES_RE = regex.either(
      // Special case: only hexadecimal binary powers can contain fractions
      /0[xX][0-9a-fA-F]+\.[0-9a-fA-F]*[pP][+-]?\d+i?/,
      // Hexadecimal numbers without fraction and optional binary power
      /0[xX][0-9a-fA-F]+(?:[pP][+-]?\d+)?[Li]?/,
      // Decimal numbers
      /(?:\d+(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+)?[Li]?/);
      const OPERATORS_RE = /[=!<>:]=|\|\||&&|:::?|<-|<<-|->>|->|\|>|[-+*\/?!$&|:<=>@^~]|\*\*/;
      const PUNCTUATION_RE = regex.either(/[()]/, /[{}]/, /\[\[/, /[[\]]/, /\\/, /,/);
      return {
        name: 'R',
        keywords: {
          $pattern: IDENT_RE,
          keyword: 'function if in break next repeat else for while',
          literal: 'NULL NA TRUE FALSE Inf NaN NA_integer_|10 NA_real_|10 ' + 'NA_character_|10 NA_complex_|10',
          built_in:
          // Builtin constants
          'LETTERS letters month.abb month.name pi T F '
          // Primitive functions
          // These are all the functions in `base` that are implemented as a
          // `.Primitive`, minus those functions that are also keywords.
          + 'abs acos acosh all any anyNA Arg as.call as.character ' + 'as.complex as.double as.environment as.integer as.logical ' + 'as.null.default as.numeric as.raw asin asinh atan atanh attr ' + 'attributes baseenv browser c call ceiling class Conj cos cosh ' + 'cospi cummax cummin cumprod cumsum digamma dim dimnames ' + 'emptyenv exp expression floor forceAndCall gamma gc.time ' + 'globalenv Im interactive invisible is.array is.atomic is.call ' + 'is.character is.complex is.double is.environment is.expression ' + 'is.finite is.function is.infinite is.integer is.language ' + 'is.list is.logical is.matrix is.na is.name is.nan is.null ' + 'is.numeric is.object is.pairlist is.raw is.recursive is.single ' + 'is.symbol lazyLoadDBfetch length lgamma list log max min ' + 'missing Mod names nargs nzchar oldClass on.exit pos.to.env ' + 'proc.time prod quote range Re rep retracemem return round ' + 'seq_along seq_len seq.int sign signif sin sinh sinpi sqrt ' + 'standardGeneric substitute sum switch tan tanh tanpi tracemem ' + 'trigamma trunc unclass untracemem UseMethod xtfrm'
        },
        contains: [
        // Roxygen comments
        hljs.COMMENT(/#'/, /$/, {
          contains: [{
            // Handle `@examples` separately to cause all subsequent code
            // until the next `@`-tag on its own line to be kept as-is,
            // preventing highlighting. This code is example R code, so nested
            // doctags shouldn’t be treated as such. See
            // `test/markup/r/roxygen.txt` for an example.
            scope: 'doctag',
            match: /@examples/,
            starts: {
              end: regex.lookahead(regex.either(
              // end if another doc comment
              /\n^#'\s*(?=@[a-zA-Z]+)/,
              // or a line with no comment
              /\n^(?!#')/)),
              endsParent: true
            }
          }, {
            // Handle `@param` to highlight the parameter name following
            // after.
            scope: 'doctag',
            begin: '@param',
            end: /$/,
            contains: [{
              scope: 'variable',
              variants: [{
                match: IDENT_RE
              }, {
                match: /`(?:\\.|[^`\\])+`/
              }],
              endsParent: true
            }]
          }, {
            scope: 'doctag',
            match: /@[a-zA-Z]+/
          }, {
            scope: 'keyword',
            match: /\\[a-zA-Z]+/
          }]
        }), hljs.HASH_COMMENT_MODE, {
          scope: 'string',
          contains: [hljs.BACKSLASH_ESCAPE],
          variants: [hljs.END_SAME_AS_BEGIN({
            begin: /[rR]"(-*)\(/,
            end: /\)(-*)"/
          }), hljs.END_SAME_AS_BEGIN({
            begin: /[rR]"(-*)\{/,
            end: /\}(-*)"/
          }), hljs.END_SAME_AS_BEGIN({
            begin: /[rR]"(-*)\[/,
            end: /\](-*)"/
          }), hljs.END_SAME_AS_BEGIN({
            begin: /[rR]'(-*)\(/,
            end: /\)(-*)'/
          }), hljs.END_SAME_AS_BEGIN({
            begin: /[rR]'(-*)\{/,
            end: /\}(-*)'/
          }), hljs.END_SAME_AS_BEGIN({
            begin: /[rR]'(-*)\[/,
            end: /\](-*)'/
          }), {
            begin: '"',
            end: '"',
            relevance: 0
          }, {
            begin: "'",
            end: "'",
            relevance: 0
          }]
        },
        // Matching numbers immediately following punctuation and operators is
        // tricky since we need to look at the character ahead of a number to
        // ensure the number is not part of an identifier, and we cannot use
        // negative look-behind assertions. So instead we explicitly handle all
        // possible combinations of (operator|punctuation), number.
        // TODO: replace with negative look-behind when available
        // { begin: /(?<![a-zA-Z0-9._])0[xX][0-9a-fA-F]+\.[0-9a-fA-F]*[pP][+-]?\d+i?/ },
        // { begin: /(?<![a-zA-Z0-9._])0[xX][0-9a-fA-F]+([pP][+-]?\d+)?[Li]?/ },
        // { begin: /(?<![a-zA-Z0-9._])(\d+(\.\d*)?|\.\d+)([eE][+-]?\d+)?[Li]?/ }
        {
          relevance: 0,
          variants: [{
            scope: {
              1: 'operator',
              2: 'number'
            },
            match: [OPERATORS_RE, NUMBER_TYPES_RE]
          }, {
            scope: {
              1: 'operator',
              2: 'number'
            },
            match: [/%[^%]*%/, NUMBER_TYPES_RE]
          }, {
            scope: {
              1: 'punctuation',
              2: 'number'
            },
            match: [PUNCTUATION_RE, NUMBER_TYPES_RE]
          }, {
            scope: {
              2: 'number'
            },
            match: [/[^a-zA-Z0-9._]|^/,
            // not part of an identifier, or start of document
            NUMBER_TYPES_RE]
          }]
        },
        // Operators/punctuation when they're not directly followed by numbers
        {
          // Relevance boost for the most common assignment form.
          scope: {
            3: 'operator'
          },
          match: [IDENT_RE, /\s+/, /<-/, /\s+/]
        }, {
          scope: 'operator',
          relevance: 0,
          variants: [{
            match: OPERATORS_RE
          }, {
            match: /%[^%]*%/
          }]
        }, {
          scope: 'punctuation',
          relevance: 0,
          match: PUNCTUATION_RE
        }, {
          // Escaped identifier
          begin: '`',
          end: '`',
          contains: [{
            begin: /\\./
          }]
        }]
      };
    }
    r_1 = r;
    return r_1;
  }

  /*
  Language: Rust
  Author: Andrey Vlasovskikh <andrey.vlasovskikh@gmail.com>
  Contributors: Roman Shmatov <romanshmatov@gmail.com>, Kasper Andersen <kma_untrusted@protonmail.com>
  Website: https://www.rust-lang.org
  Category: common, system
  */
  var rust_1;
  var hasRequiredRust;
  function requireRust() {
    if (hasRequiredRust) return rust_1;
    hasRequiredRust = 1;
    /** @type LanguageFn */
    function rust(hljs) {
      const regex = hljs.regex;
      const FUNCTION_INVOKE = {
        className: "title.function.invoke",
        relevance: 0,
        begin: regex.concat(/\b/, /(?!let\b)/, hljs.IDENT_RE, regex.lookahead(/\s*\(/))
      };
      const NUMBER_SUFFIX = '([ui](8|16|32|64|128|size)|f(32|64))\?';
      const KEYWORDS = ["abstract", "as", "async", "await", "become", "box", "break", "const", "continue", "crate", "do", "dyn", "else", "enum", "extern", "false", "final", "fn", "for", "if", "impl", "in", "let", "loop", "macro", "match", "mod", "move", "mut", "override", "priv", "pub", "ref", "return", "self", "Self", "static", "struct", "super", "trait", "true", "try", "type", "typeof", "unsafe", "unsized", "use", "virtual", "where", "while", "yield"];
      const LITERALS = ["true", "false", "Some", "None", "Ok", "Err"];
      const BUILTINS = [
      // functions
      'drop ',
      // traits
      "Copy", "Send", "Sized", "Sync", "Drop", "Fn", "FnMut", "FnOnce", "ToOwned", "Clone", "Debug", "PartialEq", "PartialOrd", "Eq", "Ord", "AsRef", "AsMut", "Into", "From", "Default", "Iterator", "Extend", "IntoIterator", "DoubleEndedIterator", "ExactSizeIterator", "SliceConcatExt", "ToString",
      // macros
      "assert!", "assert_eq!", "bitflags!", "bytes!", "cfg!", "col!", "concat!", "concat_idents!", "debug_assert!", "debug_assert_eq!", "env!", "panic!", "file!", "format!", "format_args!", "include_bytes!", "include_str!", "line!", "local_data_key!", "module_path!", "option_env!", "print!", "println!", "select!", "stringify!", "try!", "unimplemented!", "unreachable!", "vec!", "write!", "writeln!", "macro_rules!", "assert_ne!", "debug_assert_ne!"];
      const TYPES = ["i8", "i16", "i32", "i64", "i128", "isize", "u8", "u16", "u32", "u64", "u128", "usize", "f32", "f64", "str", "char", "bool", "Box", "Option", "Result", "String", "Vec"];
      return {
        name: 'Rust',
        aliases: ['rs'],
        keywords: {
          $pattern: hljs.IDENT_RE + '!?',
          type: TYPES,
          keyword: KEYWORDS,
          literal: LITERALS,
          built_in: BUILTINS
        },
        illegal: '</',
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.COMMENT('/\\*', '\\*/', {
          contains: ['self']
        }), hljs.inherit(hljs.QUOTE_STRING_MODE, {
          begin: /b?"/,
          illegal: null
        }), {
          className: 'string',
          variants: [{
            begin: /b?r(#*)"(.|\n)*?"\1(?!#)/
          }, {
            begin: /b?'\\?(x\w{2}|u\w{4}|U\w{8}|.)'/
          }]
        }, {
          className: 'symbol',
          begin: /'[a-zA-Z_][a-zA-Z0-9_]*/
        }, {
          className: 'number',
          variants: [{
            begin: '\\b0b([01_]+)' + NUMBER_SUFFIX
          }, {
            begin: '\\b0o([0-7_]+)' + NUMBER_SUFFIX
          }, {
            begin: '\\b0x([A-Fa-f0-9_]+)' + NUMBER_SUFFIX
          }, {
            begin: '\\b(\\d[\\d_]*(\\.[0-9_]+)?([eE][+-]?[0-9_]+)?)' + NUMBER_SUFFIX
          }],
          relevance: 0
        }, {
          begin: [/fn/, /\s+/, hljs.UNDERSCORE_IDENT_RE],
          className: {
            1: "keyword",
            3: "title.function"
          }
        }, {
          className: 'meta',
          begin: '#!?\\[',
          end: '\\]',
          contains: [{
            className: 'string',
            begin: /"/,
            end: /"/
          }]
        }, {
          begin: [/let/, /\s+/, /(?:mut\s+)?/, hljs.UNDERSCORE_IDENT_RE],
          className: {
            1: "keyword",
            3: "keyword",
            4: "variable"
          }
        },
        // must come before impl/for rule later
        {
          begin: [/for/, /\s+/, hljs.UNDERSCORE_IDENT_RE, /\s+/, /in/],
          className: {
            1: "keyword",
            3: "variable",
            5: "keyword"
          }
        }, {
          begin: [/type/, /\s+/, hljs.UNDERSCORE_IDENT_RE],
          className: {
            1: "keyword",
            3: "title.class"
          }
        }, {
          begin: [/(?:trait|enum|struct|union|impl|for)/, /\s+/, hljs.UNDERSCORE_IDENT_RE],
          className: {
            1: "keyword",
            3: "title.class"
          }
        }, {
          begin: hljs.IDENT_RE + '::',
          keywords: {
            keyword: "Self",
            built_in: BUILTINS,
            type: TYPES
          }
        }, {
          className: "punctuation",
          begin: '->'
        }, FUNCTION_INVOKE]
      };
    }
    rust_1 = rust;
    return rust_1;
  }

  var scss_1;
  var hasRequiredScss;
  function requireScss() {
    if (hasRequiredScss) return scss_1;
    hasRequiredScss = 1;
    const MODES = hljs => {
      return {
        IMPORTANT: {
          scope: 'meta',
          begin: '!important'
        },
        BLOCK_COMMENT: hljs.C_BLOCK_COMMENT_MODE,
        HEXCOLOR: {
          scope: 'number',
          begin: /#(([0-9a-fA-F]{3,4})|(([0-9a-fA-F]{2}){3,4}))\b/
        },
        FUNCTION_DISPATCH: {
          className: "built_in",
          begin: /[\w-]+(?=\()/
        },
        ATTRIBUTE_SELECTOR_MODE: {
          scope: 'selector-attr',
          begin: /\[/,
          end: /\]/,
          illegal: '$',
          contains: [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE]
        },
        CSS_NUMBER_MODE: {
          scope: 'number',
          begin: hljs.NUMBER_RE + '(' + '%|em|ex|ch|rem' + '|vw|vh|vmin|vmax' + '|cm|mm|in|pt|pc|px' + '|deg|grad|rad|turn' + '|s|ms' + '|Hz|kHz' + '|dpi|dpcm|dppx' + ')?',
          relevance: 0
        },
        CSS_VARIABLE: {
          className: "attr",
          begin: /--[A-Za-z][A-Za-z0-9_-]*/
        }
      };
    };
    const TAGS = ['a', 'abbr', 'address', 'article', 'aside', 'audio', 'b', 'blockquote', 'body', 'button', 'canvas', 'caption', 'cite', 'code', 'dd', 'del', 'details', 'dfn', 'div', 'dl', 'dt', 'em', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'mark', 'menu', 'nav', 'object', 'ol', 'p', 'q', 'quote', 'samp', 'section', 'span', 'strong', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'ul', 'var', 'video'];
    const MEDIA_FEATURES = ['any-hover', 'any-pointer', 'aspect-ratio', 'color', 'color-gamut', 'color-index', 'device-aspect-ratio', 'device-height', 'device-width', 'display-mode', 'forced-colors', 'grid', 'height', 'hover', 'inverted-colors', 'monochrome', 'orientation', 'overflow-block', 'overflow-inline', 'pointer', 'prefers-color-scheme', 'prefers-contrast', 'prefers-reduced-motion', 'prefers-reduced-transparency', 'resolution', 'scan', 'scripting', 'update', 'width',
    // TODO: find a better solution?
    'min-width', 'max-width', 'min-height', 'max-height'];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-classes
    const PSEUDO_CLASSES = ['active', 'any-link', 'blank', 'checked', 'current', 'default', 'defined', 'dir',
    // dir()
    'disabled', 'drop', 'empty', 'enabled', 'first', 'first-child', 'first-of-type', 'fullscreen', 'future', 'focus', 'focus-visible', 'focus-within', 'has',
    // has()
    'host',
    // host or host()
    'host-context',
    // host-context()
    'hover', 'indeterminate', 'in-range', 'invalid', 'is',
    // is()
    'lang',
    // lang()
    'last-child', 'last-of-type', 'left', 'link', 'local-link', 'not',
    // not()
    'nth-child',
    // nth-child()
    'nth-col',
    // nth-col()
    'nth-last-child',
    // nth-last-child()
    'nth-last-col',
    // nth-last-col()
    'nth-last-of-type',
    //nth-last-of-type()
    'nth-of-type',
    //nth-of-type()
    'only-child', 'only-of-type', 'optional', 'out-of-range', 'past', 'placeholder-shown', 'read-only', 'read-write', 'required', 'right', 'root', 'scope', 'target', 'target-within', 'user-invalid', 'valid', 'visited', 'where' // where()
    ];

    // https://developer.mozilla.org/en-US/docs/Web/CSS/Pseudo-elements
    const PSEUDO_ELEMENTS = ['after', 'backdrop', 'before', 'cue', 'cue-region', 'first-letter', 'first-line', 'grammar-error', 'marker', 'part', 'placeholder', 'selection', 'slotted', 'spelling-error'];
    const ATTRIBUTES = ['align-content', 'align-items', 'align-self', 'all', 'animation', 'animation-delay', 'animation-direction', 'animation-duration', 'animation-fill-mode', 'animation-iteration-count', 'animation-name', 'animation-play-state', 'animation-timing-function', 'backface-visibility', 'background', 'background-attachment', 'background-blend-mode', 'background-clip', 'background-color', 'background-image', 'background-origin', 'background-position', 'background-repeat', 'background-size', 'block-size', 'border', 'border-block', 'border-block-color', 'border-block-end', 'border-block-end-color', 'border-block-end-style', 'border-block-end-width', 'border-block-start', 'border-block-start-color', 'border-block-start-style', 'border-block-start-width', 'border-block-style', 'border-block-width', 'border-bottom', 'border-bottom-color', 'border-bottom-left-radius', 'border-bottom-right-radius', 'border-bottom-style', 'border-bottom-width', 'border-collapse', 'border-color', 'border-image', 'border-image-outset', 'border-image-repeat', 'border-image-slice', 'border-image-source', 'border-image-width', 'border-inline', 'border-inline-color', 'border-inline-end', 'border-inline-end-color', 'border-inline-end-style', 'border-inline-end-width', 'border-inline-start', 'border-inline-start-color', 'border-inline-start-style', 'border-inline-start-width', 'border-inline-style', 'border-inline-width', 'border-left', 'border-left-color', 'border-left-style', 'border-left-width', 'border-radius', 'border-right', 'border-right-color', 'border-right-style', 'border-right-width', 'border-spacing', 'border-style', 'border-top', 'border-top-color', 'border-top-left-radius', 'border-top-right-radius', 'border-top-style', 'border-top-width', 'border-width', 'bottom', 'box-decoration-break', 'box-shadow', 'box-sizing', 'break-after', 'break-before', 'break-inside', 'caption-side', 'caret-color', 'clear', 'clip', 'clip-path', 'clip-rule', 'color', 'column-count', 'column-fill', 'column-gap', 'column-rule', 'column-rule-color', 'column-rule-style', 'column-rule-width', 'column-span', 'column-width', 'columns', 'contain', 'content', 'content-visibility', 'counter-increment', 'counter-reset', 'cue', 'cue-after', 'cue-before', 'cursor', 'direction', 'display', 'empty-cells', 'filter', 'flex', 'flex-basis', 'flex-direction', 'flex-flow', 'flex-grow', 'flex-shrink', 'flex-wrap', 'float', 'flow', 'font', 'font-display', 'font-family', 'font-feature-settings', 'font-kerning', 'font-language-override', 'font-size', 'font-size-adjust', 'font-smoothing', 'font-stretch', 'font-style', 'font-synthesis', 'font-variant', 'font-variant-caps', 'font-variant-east-asian', 'font-variant-ligatures', 'font-variant-numeric', 'font-variant-position', 'font-variation-settings', 'font-weight', 'gap', 'glyph-orientation-vertical', 'grid', 'grid-area', 'grid-auto-columns', 'grid-auto-flow', 'grid-auto-rows', 'grid-column', 'grid-column-end', 'grid-column-start', 'grid-gap', 'grid-row', 'grid-row-end', 'grid-row-start', 'grid-template', 'grid-template-areas', 'grid-template-columns', 'grid-template-rows', 'hanging-punctuation', 'height', 'hyphens', 'icon', 'image-orientation', 'image-rendering', 'image-resolution', 'ime-mode', 'inline-size', 'isolation', 'justify-content', 'left', 'letter-spacing', 'line-break', 'line-height', 'list-style', 'list-style-image', 'list-style-position', 'list-style-type', 'margin', 'margin-block', 'margin-block-end', 'margin-block-start', 'margin-bottom', 'margin-inline', 'margin-inline-end', 'margin-inline-start', 'margin-left', 'margin-right', 'margin-top', 'marks', 'mask', 'mask-border', 'mask-border-mode', 'mask-border-outset', 'mask-border-repeat', 'mask-border-slice', 'mask-border-source', 'mask-border-width', 'mask-clip', 'mask-composite', 'mask-image', 'mask-mode', 'mask-origin', 'mask-position', 'mask-repeat', 'mask-size', 'mask-type', 'max-block-size', 'max-height', 'max-inline-size', 'max-width', 'min-block-size', 'min-height', 'min-inline-size', 'min-width', 'mix-blend-mode', 'nav-down', 'nav-index', 'nav-left', 'nav-right', 'nav-up', 'none', 'normal', 'object-fit', 'object-position', 'opacity', 'order', 'orphans', 'outline', 'outline-color', 'outline-offset', 'outline-style', 'outline-width', 'overflow', 'overflow-wrap', 'overflow-x', 'overflow-y', 'padding', 'padding-block', 'padding-block-end', 'padding-block-start', 'padding-bottom', 'padding-inline', 'padding-inline-end', 'padding-inline-start', 'padding-left', 'padding-right', 'padding-top', 'page-break-after', 'page-break-before', 'page-break-inside', 'pause', 'pause-after', 'pause-before', 'perspective', 'perspective-origin', 'pointer-events', 'position', 'quotes', 'resize', 'rest', 'rest-after', 'rest-before', 'right', 'row-gap', 'scroll-margin', 'scroll-margin-block', 'scroll-margin-block-end', 'scroll-margin-block-start', 'scroll-margin-bottom', 'scroll-margin-inline', 'scroll-margin-inline-end', 'scroll-margin-inline-start', 'scroll-margin-left', 'scroll-margin-right', 'scroll-margin-top', 'scroll-padding', 'scroll-padding-block', 'scroll-padding-block-end', 'scroll-padding-block-start', 'scroll-padding-bottom', 'scroll-padding-inline', 'scroll-padding-inline-end', 'scroll-padding-inline-start', 'scroll-padding-left', 'scroll-padding-right', 'scroll-padding-top', 'scroll-snap-align', 'scroll-snap-stop', 'scroll-snap-type', 'scrollbar-color', 'scrollbar-gutter', 'scrollbar-width', 'shape-image-threshold', 'shape-margin', 'shape-outside', 'speak', 'speak-as', 'src',
    // @font-face
    'tab-size', 'table-layout', 'text-align', 'text-align-all', 'text-align-last', 'text-combine-upright', 'text-decoration', 'text-decoration-color', 'text-decoration-line', 'text-decoration-style', 'text-emphasis', 'text-emphasis-color', 'text-emphasis-position', 'text-emphasis-style', 'text-indent', 'text-justify', 'text-orientation', 'text-overflow', 'text-rendering', 'text-shadow', 'text-transform', 'text-underline-position', 'top', 'transform', 'transform-box', 'transform-origin', 'transform-style', 'transition', 'transition-delay', 'transition-duration', 'transition-property', 'transition-timing-function', 'unicode-bidi', 'vertical-align', 'visibility', 'voice-balance', 'voice-duration', 'voice-family', 'voice-pitch', 'voice-range', 'voice-rate', 'voice-stress', 'voice-volume', 'white-space', 'widows', 'width', 'will-change', 'word-break', 'word-spacing', 'word-wrap', 'writing-mode', 'z-index'
    // reverse makes sure longer attributes `font-weight` are matched fully
    // instead of getting false positives on say `font`
    ].reverse();

    /*
    Language: SCSS
    Description: Scss is an extension of the syntax of CSS.
    Author: Kurt Emch <kurt@kurtemch.com>
    Website: https://sass-lang.com
    Category: common, css, web
    */

    /** @type LanguageFn */
    function scss(hljs) {
      const modes = MODES(hljs);
      const PSEUDO_ELEMENTS$1 = PSEUDO_ELEMENTS;
      const PSEUDO_CLASSES$1 = PSEUDO_CLASSES;
      const AT_IDENTIFIER = '@[a-z-]+'; // @font-face
      const AT_MODIFIERS = "and or not only";
      const IDENT_RE = '[a-zA-Z-][a-zA-Z0-9_-]*';
      const VARIABLE = {
        className: 'variable',
        begin: '(\\$' + IDENT_RE + ')\\b',
        relevance: 0
      };
      return {
        name: 'SCSS',
        case_insensitive: true,
        illegal: '[=/|\']',
        contains: [hljs.C_LINE_COMMENT_MODE, hljs.C_BLOCK_COMMENT_MODE,
        // to recognize keyframe 40% etc which are outside the scope of our
        // attribute value mode
        modes.CSS_NUMBER_MODE, {
          className: 'selector-id',
          begin: '#[A-Za-z0-9_-]+',
          relevance: 0
        }, {
          className: 'selector-class',
          begin: '\\.[A-Za-z0-9_-]+',
          relevance: 0
        }, modes.ATTRIBUTE_SELECTOR_MODE, {
          className: 'selector-tag',
          begin: '\\b(' + TAGS.join('|') + ')\\b',
          // was there, before, but why?
          relevance: 0
        }, {
          className: 'selector-pseudo',
          begin: ':(' + PSEUDO_CLASSES$1.join('|') + ')'
        }, {
          className: 'selector-pseudo',
          begin: ':(:)?(' + PSEUDO_ELEMENTS$1.join('|') + ')'
        }, VARIABLE, {
          // pseudo-selector params
          begin: /\(/,
          end: /\)/,
          contains: [modes.CSS_NUMBER_MODE]
        }, modes.CSS_VARIABLE, {
          className: 'attribute',
          begin: '\\b(' + ATTRIBUTES.join('|') + ')\\b'
        }, {
          begin: '\\b(whitespace|wait|w-resize|visible|vertical-text|vertical-ideographic|uppercase|upper-roman|upper-alpha|underline|transparent|top|thin|thick|text|text-top|text-bottom|tb-rl|table-header-group|table-footer-group|sw-resize|super|strict|static|square|solid|small-caps|separate|se-resize|scroll|s-resize|rtl|row-resize|ridge|right|repeat|repeat-y|repeat-x|relative|progress|pointer|overline|outside|outset|oblique|nowrap|not-allowed|normal|none|nw-resize|no-repeat|no-drop|newspaper|ne-resize|n-resize|move|middle|medium|ltr|lr-tb|lowercase|lower-roman|lower-alpha|loose|list-item|line|line-through|line-edge|lighter|left|keep-all|justify|italic|inter-word|inter-ideograph|inside|inset|inline|inline-block|inherit|inactive|ideograph-space|ideograph-parenthesis|ideograph-numeric|ideograph-alpha|horizontal|hidden|help|hand|groove|fixed|ellipsis|e-resize|double|dotted|distribute|distribute-space|distribute-letter|distribute-all-lines|disc|disabled|default|decimal|dashed|crosshair|collapse|col-resize|circle|char|center|capitalize|break-word|break-all|bottom|both|bolder|bold|block|bidi-override|below|baseline|auto|always|all-scroll|absolute|table|table-cell)\\b'
        }, {
          begin: /:/,
          end: /[;}{]/,
          relevance: 0,
          contains: [modes.BLOCK_COMMENT, VARIABLE, modes.HEXCOLOR, modes.CSS_NUMBER_MODE, hljs.QUOTE_STRING_MODE, hljs.APOS_STRING_MODE, modes.IMPORTANT, modes.FUNCTION_DISPATCH]
        },
        // matching these here allows us to treat them more like regular CSS
        // rules so everything between the {} gets regular rule highlighting,
        // which is what we want for page and font-face
        {
          begin: '@(page|font-face)',
          keywords: {
            $pattern: AT_IDENTIFIER,
            keyword: '@page @font-face'
          }
        }, {
          begin: '@',
          end: '[{;]',
          returnBegin: true,
          keywords: {
            $pattern: /[a-z-]+/,
            keyword: AT_MODIFIERS,
            attribute: MEDIA_FEATURES.join(" ")
          },
          contains: [{
            begin: AT_IDENTIFIER,
            className: "keyword"
          }, {
            begin: /[a-z-]+(?=:)/,
            className: "attribute"
          }, VARIABLE, hljs.QUOTE_STRING_MODE, hljs.APOS_STRING_MODE, modes.HEXCOLOR, modes.CSS_NUMBER_MODE]
        }, modes.FUNCTION_DISPATCH]
      };
    }
    scss_1 = scss;
    return scss_1;
  }

  /*
  Language: Shell Session
  Requires: bash.js
  Author: TSUYUSATO Kitsune <make.just.on@gmail.com>
  Category: common
  Audit: 2020
  */
  var shell_1;
  var hasRequiredShell;
  function requireShell() {
    if (hasRequiredShell) return shell_1;
    hasRequiredShell = 1;
    /** @type LanguageFn */
    function shell(hljs) {
      return {
        name: 'Shell Session',
        aliases: ['console', 'shellsession'],
        contains: [{
          className: 'meta.prompt',
          // We cannot add \s (spaces) in the regular expression otherwise it will be too broad and produce unexpected result.
          // For instance, in the following example, it would match "echo /path/to/home >" as a prompt:
          // echo /path/to/home > t.exe
          begin: /^\s{0,3}[/~\w\d[\]()@-]*[>%$#][ ]?/,
          starts: {
            end: /[^\\](?=\s*$)/,
            subLanguage: 'bash'
          }
        }]
      };
    }
    shell_1 = shell;
    return shell_1;
  }

  /*
   Language: SQL
   Website: https://en.wikipedia.org/wiki/SQL
   Category: common, database
   */
  var sql_1;
  var hasRequiredSql;
  function requireSql() {
    if (hasRequiredSql) return sql_1;
    hasRequiredSql = 1;
    /*
    	Goals:
    	SQL is intended to highlight basic/common SQL keywords and expressions
    	- If pretty much every single SQL server includes supports, then it's a canidate.
    - It is NOT intended to include tons of vendor specific keywords (Oracle, MySQL,
      PostgreSQL) although the list of data types is purposely a bit more expansive.
    - For more specific SQL grammars please see:
      - PostgreSQL and PL/pgSQL - core
      - T-SQL - https://github.com/highlightjs/highlightjs-tsql
      - sql_more (core)
    	 */

    function sql(hljs) {
      const regex = hljs.regex;
      const COMMENT_MODE = hljs.COMMENT('--', '$');
      const STRING = {
        className: 'string',
        variants: [{
          begin: /'/,
          end: /'/,
          contains: [{
            begin: /''/
          }]
        }]
      };
      const QUOTED_IDENTIFIER = {
        begin: /"/,
        end: /"/,
        contains: [{
          begin: /""/
        }]
      };
      const LITERALS = ["true", "false",
      // Not sure it's correct to call NULL literal, and clauses like IS [NOT] NULL look strange that way.
      // "null",
      "unknown"];
      const MULTI_WORD_TYPES = ["double precision", "large object", "with timezone", "without timezone"];
      const TYPES = ['bigint', 'binary', 'blob', 'boolean', 'char', 'character', 'clob', 'date', 'dec', 'decfloat', 'decimal', 'float', 'int', 'integer', 'interval', 'nchar', 'nclob', 'national', 'numeric', 'real', 'row', 'smallint', 'time', 'timestamp', 'varchar', 'varying',
      // modifier (character varying)
      'varbinary'];
      const NON_RESERVED_WORDS = ["add", "asc", "collation", "desc", "final", "first", "last", "view"];

      // https://jakewheat.github.io/sql-overview/sql-2016-foundation-grammar.html#reserved-word
      const RESERVED_WORDS = ["abs", "acos", "all", "allocate", "alter", "and", "any", "are", "array", "array_agg", "array_max_cardinality", "as", "asensitive", "asin", "asymmetric", "at", "atan", "atomic", "authorization", "avg", "begin", "begin_frame", "begin_partition", "between", "bigint", "binary", "blob", "boolean", "both", "by", "call", "called", "cardinality", "cascaded", "case", "cast", "ceil", "ceiling", "char", "char_length", "character", "character_length", "check", "classifier", "clob", "close", "coalesce", "collate", "collect", "column", "commit", "condition", "connect", "constraint", "contains", "convert", "copy", "corr", "corresponding", "cos", "cosh", "count", "covar_pop", "covar_samp", "create", "cross", "cube", "cume_dist", "current", "current_catalog", "current_date", "current_default_transform_group", "current_path", "current_role", "current_row", "current_schema", "current_time", "current_timestamp", "current_path", "current_role", "current_transform_group_for_type", "current_user", "cursor", "cycle", "date", "day", "deallocate", "dec", "decimal", "decfloat", "declare", "default", "define", "delete", "dense_rank", "deref", "describe", "deterministic", "disconnect", "distinct", "double", "drop", "dynamic", "each", "element", "else", "empty", "end", "end_frame", "end_partition", "end-exec", "equals", "escape", "every", "except", "exec", "execute", "exists", "exp", "external", "extract", "false", "fetch", "filter", "first_value", "float", "floor", "for", "foreign", "frame_row", "free", "from", "full", "function", "fusion", "get", "global", "grant", "group", "grouping", "groups", "having", "hold", "hour", "identity", "in", "indicator", "initial", "inner", "inout", "insensitive", "insert", "int", "integer", "intersect", "intersection", "interval", "into", "is", "join", "json_array", "json_arrayagg", "json_exists", "json_object", "json_objectagg", "json_query", "json_table", "json_table_primitive", "json_value", "lag", "language", "large", "last_value", "lateral", "lead", "leading", "left", "like", "like_regex", "listagg", "ln", "local", "localtime", "localtimestamp", "log", "log10", "lower", "match", "match_number", "match_recognize", "matches", "max", "member", "merge", "method", "min", "minute", "mod", "modifies", "module", "month", "multiset", "national", "natural", "nchar", "nclob", "new", "no", "none", "normalize", "not", "nth_value", "ntile", "null", "nullif", "numeric", "octet_length", "occurrences_regex", "of", "offset", "old", "omit", "on", "one", "only", "open", "or", "order", "out", "outer", "over", "overlaps", "overlay", "parameter", "partition", "pattern", "per", "percent", "percent_rank", "percentile_cont", "percentile_disc", "period", "portion", "position", "position_regex", "power", "precedes", "precision", "prepare", "primary", "procedure", "ptf", "range", "rank", "reads", "real", "recursive", "ref", "references", "referencing", "regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy", "release", "result", "return", "returns", "revoke", "right", "rollback", "rollup", "row", "row_number", "rows", "running", "savepoint", "scope", "scroll", "search", "second", "seek", "select", "sensitive", "session_user", "set", "show", "similar", "sin", "sinh", "skip", "smallint", "some", "specific", "specifictype", "sql", "sqlexception", "sqlstate", "sqlwarning", "sqrt", "start", "static", "stddev_pop", "stddev_samp", "submultiset", "subset", "substring", "substring_regex", "succeeds", "sum", "symmetric", "system", "system_time", "system_user", "table", "tablesample", "tan", "tanh", "then", "time", "timestamp", "timezone_hour", "timezone_minute", "to", "trailing", "translate", "translate_regex", "translation", "treat", "trigger", "trim", "trim_array", "true", "truncate", "uescape", "union", "unique", "unknown", "unnest", "update", "upper", "user", "using", "value", "values", "value_of", "var_pop", "var_samp", "varbinary", "varchar", "varying", "versioning", "when", "whenever", "where", "width_bucket", "window", "with", "within", "without", "year"];

      // these are reserved words we have identified to be functions
      // and should only be highlighted in a dispatch-like context
      // ie, array_agg(...), etc.
      const RESERVED_FUNCTIONS = ["abs", "acos", "array_agg", "asin", "atan", "avg", "cast", "ceil", "ceiling", "coalesce", "corr", "cos", "cosh", "count", "covar_pop", "covar_samp", "cume_dist", "dense_rank", "deref", "element", "exp", "extract", "first_value", "floor", "json_array", "json_arrayagg", "json_exists", "json_object", "json_objectagg", "json_query", "json_table", "json_table_primitive", "json_value", "lag", "last_value", "lead", "listagg", "ln", "log", "log10", "lower", "max", "min", "mod", "nth_value", "ntile", "nullif", "percent_rank", "percentile_cont", "percentile_disc", "position", "position_regex", "power", "rank", "regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy", "row_number", "sin", "sinh", "sqrt", "stddev_pop", "stddev_samp", "substring", "substring_regex", "sum", "tan", "tanh", "translate", "translate_regex", "treat", "trim", "trim_array", "unnest", "upper", "value_of", "var_pop", "var_samp", "width_bucket"];

      // these functions can
      const POSSIBLE_WITHOUT_PARENS = ["current_catalog", "current_date", "current_default_transform_group", "current_path", "current_role", "current_schema", "current_transform_group_for_type", "current_user", "session_user", "system_time", "system_user", "current_time", "localtime", "current_timestamp", "localtimestamp"];

      // those exist to boost relevance making these very
      // "SQL like" keyword combos worth +1 extra relevance
      const COMBOS = ["create table", "insert into", "primary key", "foreign key", "not null", "alter table", "add constraint", "grouping sets", "on overflow", "character set", "respect nulls", "ignore nulls", "nulls first", "nulls last", "depth first", "breadth first"];
      const FUNCTIONS = RESERVED_FUNCTIONS;
      const KEYWORDS = [...RESERVED_WORDS, ...NON_RESERVED_WORDS].filter(keyword => {
        return !RESERVED_FUNCTIONS.includes(keyword);
      });
      const VARIABLE = {
        className: "variable",
        begin: /@[a-z0-9][a-z0-9_]*/
      };
      const OPERATOR = {
        className: "operator",
        begin: /[-+*/=%^~]|&&?|\|\|?|!=?|<(?:=>?|<|>)?|>[>=]?/,
        relevance: 0
      };
      const FUNCTION_CALL = {
        begin: regex.concat(/\b/, regex.either(...FUNCTIONS), /\s*\(/),
        relevance: 0,
        keywords: {
          built_in: FUNCTIONS
        }
      };

      // keywords with less than 3 letters are reduced in relevancy
      function reduceRelevancy(list, {
        exceptions,
        when
      } = {}) {
        const qualifyFn = when;
        exceptions = exceptions || [];
        return list.map(item => {
          if (item.match(/\|\d+$/) || exceptions.includes(item)) {
            return item;
          } else if (qualifyFn(item)) {
            return `${item}|0`;
          } else {
            return item;
          }
        });
      }
      return {
        name: 'SQL',
        case_insensitive: true,
        // does not include {} or HTML tags `</`
        illegal: /[{}]|<\//,
        keywords: {
          $pattern: /\b[\w\.]+/,
          keyword: reduceRelevancy(KEYWORDS, {
            when: x => x.length < 3
          }),
          literal: LITERALS,
          type: TYPES,
          built_in: POSSIBLE_WITHOUT_PARENS
        },
        contains: [{
          begin: regex.either(...COMBOS),
          relevance: 0,
          keywords: {
            $pattern: /[\w\.]+/,
            keyword: KEYWORDS.concat(COMBOS),
            literal: LITERALS,
            type: TYPES
          }
        }, {
          className: "type",
          begin: regex.either(...MULTI_WORD_TYPES)
        }, FUNCTION_CALL, VARIABLE, STRING, QUOTED_IDENTIFIER, hljs.C_NUMBER_MODE, hljs.C_BLOCK_COMMENT_MODE, COMMENT_MODE, OPERATOR]
      };
    }
    sql_1 = sql;
    return sql_1;
  }

  /**
   * @param {string} value
   * @returns {RegExp}
   * */
  var swift_1;
  var hasRequiredSwift;
  function requireSwift() {
    if (hasRequiredSwift) return swift_1;
    hasRequiredSwift = 1;
    /**
     * @param {RegExp | string } re
     * @returns {string}
     */
    function source(re) {
      if (!re) return null;
      if (typeof re === "string") return re;
      return re.source;
    }

    /**
     * @param {RegExp | string } re
     * @returns {string}
     */
    function lookahead(re) {
      return concat('(?=', re, ')');
    }

    /**
     * @param {...(RegExp | string) } args
     * @returns {string}
     */
    function concat(...args) {
      const joined = args.map(x => source(x)).join("");
      return joined;
    }

    /**
     * @param { Array<string | RegExp | Object> } args
     * @returns {object}
     */
    function stripOptionsFromArgs(args) {
      const opts = args[args.length - 1];
      if (typeof opts === 'object' && opts.constructor === Object) {
        args.splice(args.length - 1, 1);
        return opts;
      } else {
        return {};
      }
    }

    /** @typedef { {capture?: boolean} } RegexEitherOptions */

    /**
     * Any of the passed expresssions may match
     *
     * Creates a huge this | this | that | that match
     * @param {(RegExp | string)[] | [...(RegExp | string)[], RegexEitherOptions]} args
     * @returns {string}
     */
    function either(...args) {
      /** @type { object & {capture?: boolean} }  */
      const opts = stripOptionsFromArgs(args);
      const joined = '(' + (opts.capture ? "" : "?:") + args.map(x => source(x)).join("|") + ")";
      return joined;
    }
    const keywordWrapper = keyword => concat(/\b/, keyword, /\w$/.test(keyword) ? /\b/ : /\B/);

    // Keywords that require a leading dot.
    const dotKeywords = ['Protocol',
    // contextual
    'Type' // contextual
    ].map(keywordWrapper);

    // Keywords that may have a leading dot.
    const optionalDotKeywords = ['init', 'self'].map(keywordWrapper);

    // should register as keyword, not type
    const keywordTypes = ['Any', 'Self'];

    // Regular keywords and literals.
    const keywords = [
    // strings below will be fed into the regular `keywords` engine while regex
    // will result in additional modes being created to scan for those keywords to
    // avoid conflicts with other rules
    'actor', 'any',
    // contextual
    'associatedtype', 'async', 'await', /as\?/,
    // operator
    /as!/,
    // operator
    'as',
    // operator
    'break', 'case', 'catch', 'class', 'continue', 'convenience',
    // contextual
    'default', 'defer', 'deinit', 'didSet',
    // contextual
    'distributed', 'do', 'dynamic',
    // contextual
    'else', 'enum', 'extension', 'fallthrough', /fileprivate\(set\)/, 'fileprivate', 'final',
    // contextual
    'for', 'func', 'get',
    // contextual
    'guard', 'if', 'import', 'indirect',
    // contextual
    'infix',
    // contextual
    /init\?/, /init!/, 'inout', /internal\(set\)/, 'internal', 'in', 'is',
    // operator
    'isolated',
    // contextual
    'nonisolated',
    // contextual
    'lazy',
    // contextual
    'let', 'mutating',
    // contextual
    'nonmutating',
    // contextual
    /open\(set\)/,
    // contextual
    'open',
    // contextual
    'operator', 'optional',
    // contextual
    'override',
    // contextual
    'postfix',
    // contextual
    'precedencegroup', 'prefix',
    // contextual
    /private\(set\)/, 'private', 'protocol', /public\(set\)/, 'public', 'repeat', 'required',
    // contextual
    'rethrows', 'return', 'set',
    // contextual
    'some',
    // contextual
    'static', 'struct', 'subscript', 'super', 'switch', 'throws', 'throw', /try\?/,
    // operator
    /try!/,
    // operator
    'try',
    // operator
    'typealias', /unowned\(safe\)/,
    // contextual
    /unowned\(unsafe\)/,
    // contextual
    'unowned',
    // contextual
    'var', 'weak',
    // contextual
    'where', 'while', 'willSet' // contextual
    ];

    // NOTE: Contextual keywords are reserved only in specific contexts.
    // Ideally, these should be matched using modes to avoid false positives.

    // Literals.
    const literals = ['false', 'nil', 'true'];

    // Keywords used in precedence groups.
    const precedencegroupKeywords = ['assignment', 'associativity', 'higherThan', 'left', 'lowerThan', 'none', 'right'];

    // Keywords that start with a number sign (#).
    // #(un)available is handled separately.
    const numberSignKeywords = ['#colorLiteral', '#column', '#dsohandle', '#else', '#elseif', '#endif', '#error', '#file', '#fileID', '#fileLiteral', '#filePath', '#function', '#if', '#imageLiteral', '#keyPath', '#line', '#selector', '#sourceLocation', '#warn_unqualified_access', '#warning'];

    // Global functions in the Standard Library.
    const builtIns = ['abs', 'all', 'any', 'assert', 'assertionFailure', 'debugPrint', 'dump', 'fatalError', 'getVaList', 'isKnownUniquelyReferenced', 'max', 'min', 'numericCast', 'pointwiseMax', 'pointwiseMin', 'precondition', 'preconditionFailure', 'print', 'readLine', 'repeatElement', 'sequence', 'stride', 'swap', 'swift_unboxFromSwiftValueWithType', 'transcode', 'type', 'unsafeBitCast', 'unsafeDowncast', 'withExtendedLifetime', 'withUnsafeMutablePointer', 'withUnsafePointer', 'withVaList', 'withoutActuallyEscaping', 'zip'];

    // Valid first characters for operators.
    const operatorHead = either(/[/=\-+!*%<>&|^~?]/, /[\u00A1-\u00A7]/, /[\u00A9\u00AB]/, /[\u00AC\u00AE]/, /[\u00B0\u00B1]/, /[\u00B6\u00BB\u00BF\u00D7\u00F7]/, /[\u2016-\u2017]/, /[\u2020-\u2027]/, /[\u2030-\u203E]/, /[\u2041-\u2053]/, /[\u2055-\u205E]/, /[\u2190-\u23FF]/, /[\u2500-\u2775]/, /[\u2794-\u2BFF]/, /[\u2E00-\u2E7F]/, /[\u3001-\u3003]/, /[\u3008-\u3020]/, /[\u3030]/);

    // Valid characters for operators.
    const operatorCharacter = either(operatorHead, /[\u0300-\u036F]/, /[\u1DC0-\u1DFF]/, /[\u20D0-\u20FF]/, /[\uFE00-\uFE0F]/, /[\uFE20-\uFE2F]/
    // TODO: The following characters are also allowed, but the regex isn't supported yet.
    // /[\u{E0100}-\u{E01EF}]/u
    );

    // Valid operator.
    const operator = concat(operatorHead, operatorCharacter, '*');

    // Valid first characters for identifiers.
    const identifierHead = either(/[a-zA-Z_]/, /[\u00A8\u00AA\u00AD\u00AF\u00B2-\u00B5\u00B7-\u00BA]/, /[\u00BC-\u00BE\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u00FF]/, /[\u0100-\u02FF\u0370-\u167F\u1681-\u180D\u180F-\u1DBF]/, /[\u1E00-\u1FFF]/, /[\u200B-\u200D\u202A-\u202E\u203F-\u2040\u2054\u2060-\u206F]/, /[\u2070-\u20CF\u2100-\u218F\u2460-\u24FF\u2776-\u2793]/, /[\u2C00-\u2DFF\u2E80-\u2FFF]/, /[\u3004-\u3007\u3021-\u302F\u3031-\u303F\u3040-\uD7FF]/, /[\uF900-\uFD3D\uFD40-\uFDCF\uFDF0-\uFE1F\uFE30-\uFE44]/, /[\uFE47-\uFEFE\uFF00-\uFFFD]/ // Should be /[\uFE47-\uFFFD]/, but we have to exclude FEFF.
    // The following characters are also allowed, but the regexes aren't supported yet.
    // /[\u{10000}-\u{1FFFD}\u{20000-\u{2FFFD}\u{30000}-\u{3FFFD}\u{40000}-\u{4FFFD}]/u,
    // /[\u{50000}-\u{5FFFD}\u{60000-\u{6FFFD}\u{70000}-\u{7FFFD}\u{80000}-\u{8FFFD}]/u,
    // /[\u{90000}-\u{9FFFD}\u{A0000-\u{AFFFD}\u{B0000}-\u{BFFFD}\u{C0000}-\u{CFFFD}]/u,
    // /[\u{D0000}-\u{DFFFD}\u{E0000-\u{EFFFD}]/u
    );

    // Valid characters for identifiers.
    const identifierCharacter = either(identifierHead, /\d/, /[\u0300-\u036F\u1DC0-\u1DFF\u20D0-\u20FF\uFE20-\uFE2F]/);

    // Valid identifier.
    const identifier = concat(identifierHead, identifierCharacter, '*');

    // Valid type identifier.
    const typeIdentifier = concat(/[A-Z]/, identifierCharacter, '*');

    // Built-in attributes, which are highlighted as keywords.
    // @available is handled separately.
    const keywordAttributes = ['autoclosure', concat(/convention\(/, either('swift', 'block', 'c'), /\)/), 'discardableResult', 'dynamicCallable', 'dynamicMemberLookup', 'escaping', 'frozen', 'GKInspectable', 'IBAction', 'IBDesignable', 'IBInspectable', 'IBOutlet', 'IBSegueAction', 'inlinable', 'main', 'nonobjc', 'NSApplicationMain', 'NSCopying', 'NSManaged', concat(/objc\(/, identifier, /\)/), 'objc', 'objcMembers', 'propertyWrapper', 'requires_stored_property_inits', 'resultBuilder', 'testable', 'UIApplicationMain', 'unknown', 'usableFromInline'];

    // Contextual keywords used in @available and #(un)available.
    const availabilityKeywords = ['iOS', 'iOSApplicationExtension', 'macOS', 'macOSApplicationExtension', 'macCatalyst', 'macCatalystApplicationExtension', 'watchOS', 'watchOSApplicationExtension', 'tvOS', 'tvOSApplicationExtension', 'swift'];

    /*
    Language: Swift
    Description: Swift is a general-purpose programming language built using a modern approach to safety, performance, and software design patterns.
    Author: Steven Van Impe <steven.vanimpe@icloud.com>
    Contributors: Chris Eidhof <chris@eidhof.nl>, Nate Cook <natecook@gmail.com>, Alexander Lichter <manniL@gmx.net>, Richard Gibson <gibson042@github>
    Website: https://swift.org
    Category: common, system
    */

    /** @type LanguageFn */
    function swift(hljs) {
      const WHITESPACE = {
        match: /\s+/,
        relevance: 0
      };
      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#ID411
      const BLOCK_COMMENT = hljs.COMMENT('/\\*', '\\*/', {
        contains: ['self']
      });
      const COMMENTS = [hljs.C_LINE_COMMENT_MODE, BLOCK_COMMENT];

      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#ID413
      // https://docs.swift.org/swift-book/ReferenceManual/zzSummaryOfTheGrammar.html
      const DOT_KEYWORD = {
        match: [/\./, either(...dotKeywords, ...optionalDotKeywords)],
        className: {
          2: "keyword"
        }
      };
      const KEYWORD_GUARD = {
        // Consume .keyword to prevent highlighting properties and methods as keywords.
        match: concat(/\./, either(...keywords)),
        relevance: 0
      };
      const PLAIN_KEYWORDS = keywords.filter(kw => typeof kw === 'string').concat(["_|0"]); // seems common, so 0 relevance
      const REGEX_KEYWORDS = keywords.filter(kw => typeof kw !== 'string') // find regex
      .concat(keywordTypes).map(keywordWrapper);
      const KEYWORD = {
        variants: [{
          className: 'keyword',
          match: either(...REGEX_KEYWORDS, ...optionalDotKeywords)
        }]
      };
      // find all the regular keywords
      const KEYWORDS = {
        $pattern: either(/\b\w+/,
        // regular keywords
        /#\w+/ // number keywords
        ),

        keyword: PLAIN_KEYWORDS.concat(numberSignKeywords),
        literal: literals
      };
      const KEYWORD_MODES = [DOT_KEYWORD, KEYWORD_GUARD, KEYWORD];

      // https://github.com/apple/swift/tree/main/stdlib/public/core
      const BUILT_IN_GUARD = {
        // Consume .built_in to prevent highlighting properties and methods.
        match: concat(/\./, either(...builtIns)),
        relevance: 0
      };
      const BUILT_IN = {
        className: 'built_in',
        match: concat(/\b/, either(...builtIns), /(?=\()/)
      };
      const BUILT_INS = [BUILT_IN_GUARD, BUILT_IN];

      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#ID418
      const OPERATOR_GUARD = {
        // Prevent -> from being highlighting as an operator.
        match: /->/,
        relevance: 0
      };
      const OPERATOR = {
        className: 'operator',
        relevance: 0,
        variants: [{
          match: operator
        }, {
          // dot-operator: only operators that start with a dot are allowed to use dots as
          // characters (..., ...<, .*, etc). So there rule here is: a dot followed by one or more
          // characters that may also include dots.
          match: `\\.(\\.|${operatorCharacter})+`
        }]
      };
      const OPERATORS = [OPERATOR_GUARD, OPERATOR];

      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#grammar_numeric-literal
      // TODO: Update for leading `-` after lookbehind is supported everywhere
      const decimalDigits = '([0-9]_*)+';
      const hexDigits = '([0-9a-fA-F]_*)+';
      const NUMBER = {
        className: 'number',
        relevance: 0,
        variants: [
        // decimal floating-point-literal (subsumes decimal-literal)
        {
          match: `\\b(${decimalDigits})(\\.(${decimalDigits}))?` + `([eE][+-]?(${decimalDigits}))?\\b`
        },
        // hexadecimal floating-point-literal (subsumes hexadecimal-literal)
        {
          match: `\\b0x(${hexDigits})(\\.(${hexDigits}))?` + `([pP][+-]?(${decimalDigits}))?\\b`
        },
        // octal-literal
        {
          match: /\b0o([0-7]_*)+\b/
        },
        // binary-literal
        {
          match: /\b0b([01]_*)+\b/
        }]
      };

      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#grammar_string-literal
      const ESCAPED_CHARACTER = (rawDelimiter = "") => ({
        className: 'subst',
        variants: [{
          match: concat(/\\/, rawDelimiter, /[0\\tnr"']/)
        }, {
          match: concat(/\\/, rawDelimiter, /u\{[0-9a-fA-F]{1,8}\}/)
        }]
      });
      const ESCAPED_NEWLINE = (rawDelimiter = "") => ({
        className: 'subst',
        match: concat(/\\/, rawDelimiter, /[\t ]*(?:[\r\n]|\r\n)/)
      });
      const INTERPOLATION = (rawDelimiter = "") => ({
        className: 'subst',
        label: "interpol",
        begin: concat(/\\/, rawDelimiter, /\(/),
        end: /\)/
      });
      const MULTILINE_STRING = (rawDelimiter = "") => ({
        begin: concat(rawDelimiter, /"""/),
        end: concat(/"""/, rawDelimiter),
        contains: [ESCAPED_CHARACTER(rawDelimiter), ESCAPED_NEWLINE(rawDelimiter), INTERPOLATION(rawDelimiter)]
      });
      const SINGLE_LINE_STRING = (rawDelimiter = "") => ({
        begin: concat(rawDelimiter, /"/),
        end: concat(/"/, rawDelimiter),
        contains: [ESCAPED_CHARACTER(rawDelimiter), INTERPOLATION(rawDelimiter)]
      });
      const STRING = {
        className: 'string',
        variants: [MULTILINE_STRING(), MULTILINE_STRING("#"), MULTILINE_STRING("##"), MULTILINE_STRING("###"), SINGLE_LINE_STRING(), SINGLE_LINE_STRING("#"), SINGLE_LINE_STRING("##"), SINGLE_LINE_STRING("###")]
      };

      // https://docs.swift.org/swift-book/ReferenceManual/LexicalStructure.html#ID412
      const QUOTED_IDENTIFIER = {
        match: concat(/`/, identifier, /`/)
      };
      const IMPLICIT_PARAMETER = {
        className: 'variable',
        match: /\$\d+/
      };
      const PROPERTY_WRAPPER_PROJECTION = {
        className: 'variable',
        match: `\\$${identifierCharacter}+`
      };
      const IDENTIFIERS = [QUOTED_IDENTIFIER, IMPLICIT_PARAMETER, PROPERTY_WRAPPER_PROJECTION];

      // https://docs.swift.org/swift-book/ReferenceManual/Attributes.html
      const AVAILABLE_ATTRIBUTE = {
        match: /(@|#(un)?)available/,
        className: "keyword",
        starts: {
          contains: [{
            begin: /\(/,
            end: /\)/,
            keywords: availabilityKeywords,
            contains: [...OPERATORS, NUMBER, STRING]
          }]
        }
      };
      const KEYWORD_ATTRIBUTE = {
        className: 'keyword',
        match: concat(/@/, either(...keywordAttributes))
      };
      const USER_DEFINED_ATTRIBUTE = {
        className: 'meta',
        match: concat(/@/, identifier)
      };
      const ATTRIBUTES = [AVAILABLE_ATTRIBUTE, KEYWORD_ATTRIBUTE, USER_DEFINED_ATTRIBUTE];

      // https://docs.swift.org/swift-book/ReferenceManual/Types.html
      const TYPE = {
        match: lookahead(/\b[A-Z]/),
        relevance: 0,
        contains: [{
          // Common Apple frameworks, for relevance boost
          className: 'type',
          match: concat(/(AV|CA|CF|CG|CI|CL|CM|CN|CT|MK|MP|MTK|MTL|NS|SCN|SK|UI|WK|XC)/, identifierCharacter, '+')
        }, {
          // Type identifier
          className: 'type',
          match: typeIdentifier,
          relevance: 0
        }, {
          // Optional type
          match: /[?!]+/,
          relevance: 0
        }, {
          // Variadic parameter
          match: /\.\.\./,
          relevance: 0
        }, {
          // Protocol composition
          match: concat(/\s+&\s+/, lookahead(typeIdentifier)),
          relevance: 0
        }]
      };
      const GENERIC_ARGUMENTS = {
        begin: /</,
        end: />/,
        keywords: KEYWORDS,
        contains: [...COMMENTS, ...KEYWORD_MODES, ...ATTRIBUTES, OPERATOR_GUARD, TYPE]
      };
      TYPE.contains.push(GENERIC_ARGUMENTS);

      // https://docs.swift.org/swift-book/ReferenceManual/Expressions.html#ID552
      // Prevents element names from being highlighted as keywords.
      const TUPLE_ELEMENT_NAME = {
        match: concat(identifier, /\s*:/),
        keywords: "_|0",
        relevance: 0
      };
      // Matches tuples as well as the parameter list of a function type.
      const TUPLE = {
        begin: /\(/,
        end: /\)/,
        relevance: 0,
        keywords: KEYWORDS,
        contains: ['self', TUPLE_ELEMENT_NAME, ...COMMENTS, ...KEYWORD_MODES, ...BUILT_INS, ...OPERATORS, NUMBER, STRING, ...IDENTIFIERS, ...ATTRIBUTES, TYPE]
      };
      const GENERIC_PARAMETERS = {
        begin: /</,
        end: />/,
        contains: [...COMMENTS, TYPE]
      };
      const FUNCTION_PARAMETER_NAME = {
        begin: either(lookahead(concat(identifier, /\s*:/)), lookahead(concat(identifier, /\s+/, identifier, /\s*:/))),
        end: /:/,
        relevance: 0,
        contains: [{
          className: 'keyword',
          match: /\b_\b/
        }, {
          className: 'params',
          match: identifier
        }]
      };
      const FUNCTION_PARAMETERS = {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS,
        contains: [FUNCTION_PARAMETER_NAME, ...COMMENTS, ...KEYWORD_MODES, ...OPERATORS, NUMBER, STRING, ...ATTRIBUTES, TYPE, TUPLE],
        endsParent: true,
        illegal: /["']/
      };
      // https://docs.swift.org/swift-book/ReferenceManual/Declarations.html#ID362
      const FUNCTION = {
        match: [/func/, /\s+/, either(QUOTED_IDENTIFIER.match, identifier, operator)],
        className: {
          1: "keyword",
          3: "title.function"
        },
        contains: [GENERIC_PARAMETERS, FUNCTION_PARAMETERS, WHITESPACE],
        illegal: [/\[/, /%/]
      };

      // https://docs.swift.org/swift-book/ReferenceManual/Declarations.html#ID375
      // https://docs.swift.org/swift-book/ReferenceManual/Declarations.html#ID379
      const INIT_SUBSCRIPT = {
        match: [/\b(?:subscript|init[?!]?)/, /\s*(?=[<(])/],
        className: {
          1: "keyword"
        },
        contains: [GENERIC_PARAMETERS, FUNCTION_PARAMETERS, WHITESPACE],
        illegal: /\[|%/
      };
      // https://docs.swift.org/swift-book/ReferenceManual/Declarations.html#ID380
      const OPERATOR_DECLARATION = {
        match: [/operator/, /\s+/, operator],
        className: {
          1: "keyword",
          3: "title"
        }
      };

      // https://docs.swift.org/swift-book/ReferenceManual/Declarations.html#ID550
      const PRECEDENCEGROUP = {
        begin: [/precedencegroup/, /\s+/, typeIdentifier],
        className: {
          1: "keyword",
          3: "title"
        },
        contains: [TYPE],
        keywords: [...precedencegroupKeywords, ...literals],
        end: /}/
      };

      // Add supported submodes to string interpolation.
      for (const variant of STRING.variants) {
        const interpolation = variant.contains.find(mode => mode.label === "interpol");
        // TODO: Interpolation can contain any expression, so there's room for improvement here.
        interpolation.keywords = KEYWORDS;
        const submodes = [...KEYWORD_MODES, ...BUILT_INS, ...OPERATORS, NUMBER, STRING, ...IDENTIFIERS];
        interpolation.contains = [...submodes, {
          begin: /\(/,
          end: /\)/,
          contains: ['self', ...submodes]
        }];
      }
      return {
        name: 'Swift',
        keywords: KEYWORDS,
        contains: [...COMMENTS, FUNCTION, INIT_SUBSCRIPT, {
          beginKeywords: 'struct protocol class extension enum actor',
          end: '\\{',
          excludeEnd: true,
          keywords: KEYWORDS,
          contains: [hljs.inherit(hljs.TITLE_MODE, {
            className: "title.class",
            begin: /[A-Za-z$_][\u00C0-\u02B80-9A-Za-z$_]*/
          }), ...KEYWORD_MODES]
        }, OPERATOR_DECLARATION, PRECEDENCEGROUP, {
          beginKeywords: 'import',
          end: /$/,
          contains: [...COMMENTS],
          relevance: 0
        }, ...KEYWORD_MODES, ...BUILT_INS, ...OPERATORS, NUMBER, STRING, ...IDENTIFIERS, ...ATTRIBUTES, TYPE, TUPLE]
      };
    }
    swift_1 = swift;
    return swift_1;
  }

  /*
  Language: YAML
  Description: Yet Another Markdown Language
  Author: Stefan Wienert <stwienert@gmail.com>
  Contributors: Carl Baxter <carl@cbax.tech>
  Requires: ruby.js
  Website: https://yaml.org
  Category: common, config
  */
  var yaml_1;
  var hasRequiredYaml;
  function requireYaml() {
    if (hasRequiredYaml) return yaml_1;
    hasRequiredYaml = 1;
    function yaml(hljs) {
      const LITERALS = 'true false yes no null';

      // YAML spec allows non-reserved URI characters in tags.
      const URI_CHARACTERS = '[\\w#;/?:@&=+$,.~*\'()[\\]]+';

      // Define keys as starting with a word character
      // ...containing word chars, spaces, colons, forward-slashes, hyphens and periods
      // ...and ending with a colon followed immediately by a space, tab or newline.
      // The YAML spec allows for much more than this, but this covers most use-cases.
      const KEY = {
        className: 'attr',
        variants: [{
          begin: '\\w[\\w :\\/.-]*:(?=[ \t]|$)'
        }, {
          // double quoted keys
          begin: '"\\w[\\w :\\/.-]*":(?=[ \t]|$)'
        }, {
          // single quoted keys
          begin: '\'\\w[\\w :\\/.-]*\':(?=[ \t]|$)'
        }]
      };
      const TEMPLATE_VARIABLES = {
        className: 'template-variable',
        variants: [{
          // jinja templates Ansible
          begin: /\{\{/,
          end: /\}\}/
        }, {
          // Ruby i18n
          begin: /%\{/,
          end: /\}/
        }]
      };
      const STRING = {
        className: 'string',
        relevance: 0,
        variants: [{
          begin: /'/,
          end: /'/
        }, {
          begin: /"/,
          end: /"/
        }, {
          begin: /\S+/
        }],
        contains: [hljs.BACKSLASH_ESCAPE, TEMPLATE_VARIABLES]
      };

      // Strings inside of value containers (objects) can't contain braces,
      // brackets, or commas
      const CONTAINER_STRING = hljs.inherit(STRING, {
        variants: [{
          begin: /'/,
          end: /'/
        }, {
          begin: /"/,
          end: /"/
        }, {
          begin: /[^\s,{}[\]]+/
        }]
      });
      const DATE_RE = '[0-9]{4}(-[0-9][0-9]){0,2}';
      const TIME_RE = '([Tt \\t][0-9][0-9]?(:[0-9][0-9]){2})?';
      const FRACTION_RE = '(\\.[0-9]*)?';
      const ZONE_RE = '([ \\t])*(Z|[-+][0-9][0-9]?(:[0-9][0-9])?)?';
      const TIMESTAMP = {
        className: 'number',
        begin: '\\b' + DATE_RE + TIME_RE + FRACTION_RE + ZONE_RE + '\\b'
      };
      const VALUE_CONTAINER = {
        end: ',',
        endsWithParent: true,
        excludeEnd: true,
        keywords: LITERALS,
        relevance: 0
      };
      const OBJECT = {
        begin: /\{/,
        end: /\}/,
        contains: [VALUE_CONTAINER],
        illegal: '\\n',
        relevance: 0
      };
      const ARRAY = {
        begin: '\\[',
        end: '\\]',
        contains: [VALUE_CONTAINER],
        illegal: '\\n',
        relevance: 0
      };
      const MODES = [KEY, {
        className: 'meta',
        begin: '^---\\s*$',
        relevance: 10
      }, {
        // multi line string
        // Blocks start with a | or > followed by a newline
        //
        // Indentation of subsequent lines must be the same to
        // be considered part of the block
        className: 'string',
        begin: '[\\|>]([1-9]?[+-])?[ ]*\\n( +)[^ ][^\\n]*\\n(\\2[^\\n]+\\n?)*'
      }, {
        // Ruby/Rails erb
        begin: '<%[%=-]?',
        end: '[%-]?%>',
        subLanguage: 'ruby',
        excludeBegin: true,
        excludeEnd: true,
        relevance: 0
      }, {
        // named tags
        className: 'type',
        begin: '!\\w+!' + URI_CHARACTERS
      },
      // https://yaml.org/spec/1.2/spec.html#id2784064
      {
        // verbatim tags
        className: 'type',
        begin: '!<' + URI_CHARACTERS + ">"
      }, {
        // primary tags
        className: 'type',
        begin: '!' + URI_CHARACTERS
      }, {
        // secondary tags
        className: 'type',
        begin: '!!' + URI_CHARACTERS
      }, {
        // fragment id &ref
        className: 'meta',
        begin: '&' + hljs.UNDERSCORE_IDENT_RE + '$'
      }, {
        // fragment reference *ref
        className: 'meta',
        begin: '\\*' + hljs.UNDERSCORE_IDENT_RE + '$'
      }, {
        // array listing
        className: 'bullet',
        // TODO: remove |$ hack when we have proper look-ahead support
        begin: '-(?=[ ]|$)',
        relevance: 0
      }, hljs.HASH_COMMENT_MODE, {
        beginKeywords: LITERALS,
        keywords: {
          literal: LITERALS
        }
      }, TIMESTAMP,
      // numbers are any valid C-style number that
      // sit isolated from other words
      {
        className: 'number',
        begin: hljs.C_NUMBER_RE + '\\b',
        relevance: 0
      }, OBJECT, ARRAY, STRING];
      const VALUE_MODES = [...MODES];
      VALUE_MODES.pop();
      VALUE_MODES.push(CONTAINER_STRING);
      VALUE_CONTAINER.contains = VALUE_MODES;
      return {
        name: 'YAML',
        case_insensitive: true,
        aliases: ['yml'],
        contains: MODES
      };
    }
    yaml_1 = yaml;
    return yaml_1;
  }

  var typescript_1;
  var hasRequiredTypescript;
  function requireTypescript() {
    if (hasRequiredTypescript) return typescript_1;
    hasRequiredTypescript = 1;
    const IDENT_RE = '[A-Za-z$_][0-9A-Za-z$_]*';
    const KEYWORDS = ["as",
    // for exports
    "in", "of", "if", "for", "while", "finally", "var", "new", "function", "do", "return", "void", "else", "break", "catch", "instanceof", "with", "throw", "case", "default", "try", "switch", "continue", "typeof", "delete", "let", "yield", "const", "class",
    // JS handles these with a special rule
    // "get",
    // "set",
    "debugger", "async", "await", "static", "import", "from", "export", "extends"];
    const LITERALS = ["true", "false", "null", "undefined", "NaN", "Infinity"];

    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects
    const TYPES = [
    // Fundamental objects
    "Object", "Function", "Boolean", "Symbol",
    // numbers and dates
    "Math", "Date", "Number", "BigInt",
    // text
    "String", "RegExp",
    // Indexed collections
    "Array", "Float32Array", "Float64Array", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Int32Array", "Uint16Array", "Uint32Array", "BigInt64Array", "BigUint64Array",
    // Keyed collections
    "Set", "Map", "WeakSet", "WeakMap",
    // Structured data
    "ArrayBuffer", "SharedArrayBuffer", "Atomics", "DataView", "JSON",
    // Control abstraction objects
    "Promise", "Generator", "GeneratorFunction", "AsyncFunction",
    // Reflection
    "Reflect", "Proxy",
    // Internationalization
    "Intl",
    // WebAssembly
    "WebAssembly"];
    const ERROR_TYPES = ["Error", "EvalError", "InternalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"];
    const BUILT_IN_GLOBALS = ["setInterval", "setTimeout", "clearInterval", "clearTimeout", "require", "exports", "eval", "isFinite", "isNaN", "parseFloat", "parseInt", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent", "escape", "unescape"];
    const BUILT_IN_VARIABLES = ["arguments", "this", "super", "console", "window", "document", "localStorage", "sessionStorage", "module", "global" // Node.js
    ];

    const BUILT_INS = [].concat(BUILT_IN_GLOBALS, TYPES, ERROR_TYPES);

    /*
    Language: JavaScript
    Description: JavaScript (JS) is a lightweight, interpreted, or just-in-time compiled programming language with first-class functions.
    Category: common, scripting, web
    Website: https://developer.mozilla.org/en-US/docs/Web/JavaScript
    */

    /** @type LanguageFn */
    function javascript(hljs) {
      const regex = hljs.regex;
      /**
       * Takes a string like "<Booger" and checks to see
       * if we can find a matching "</Booger" later in the
       * content.
       * @param {RegExpMatchArray} match
       * @param {{after:number}} param1
       */
      const hasClosingTag = (match, {
        after
      }) => {
        const tag = "</" + match[0].slice(1);
        const pos = match.input.indexOf(tag, after);
        return pos !== -1;
      };
      const IDENT_RE$1 = IDENT_RE;
      const FRAGMENT = {
        begin: '<>',
        end: '</>'
      };
      // to avoid some special cases inside isTrulyOpeningTag
      const XML_SELF_CLOSING = /<[A-Za-z0-9\\._:-]+\s*\/>/;
      const XML_TAG = {
        begin: /<[A-Za-z0-9\\._:-]+/,
        end: /\/[A-Za-z0-9\\._:-]+>|\/>/,
        /**
         * @param {RegExpMatchArray} match
         * @param {CallbackResponse} response
         */
        isTrulyOpeningTag: (match, response) => {
          const afterMatchIndex = match[0].length + match.index;
          const nextChar = match.input[afterMatchIndex];
          if (
          // HTML should not include another raw `<` inside a tag
          // nested type?
          // `<Array<Array<number>>`, etc.
          nextChar === "<" ||
          // the , gives away that this is not HTML
          // `<T, A extends keyof T, V>`
          nextChar === ",") {
            response.ignoreMatch();
            return;
          }

          // `<something>`
          // Quite possibly a tag, lets look for a matching closing tag...
          if (nextChar === ">") {
            // if we cannot find a matching closing tag, then we
            // will ignore it
            if (!hasClosingTag(match, {
              after: afterMatchIndex
            })) {
              response.ignoreMatch();
            }
          }

          // `<blah />` (self-closing)
          // handled by simpleSelfClosing rule

          let m;
          const afterMatch = match.input.substring(afterMatchIndex);

          // some more template typing stuff
          //  <T = any>(key?: string) => Modify<
          if (m = afterMatch.match(/^\s*=/)) {
            response.ignoreMatch();
            return;
          }

          // `<From extends string>`
          // technically this could be HTML, but it smells like a type
          // NOTE: This is ugh, but added specifically for https://github.com/highlightjs/highlight.js/issues/3276
          if (m = afterMatch.match(/^\s+extends\s+/)) {
            if (m.index === 0) {
              response.ignoreMatch();
              // eslint-disable-next-line no-useless-return
              return;
            }
          }
        }
      };
      const KEYWORDS$1 = {
        $pattern: IDENT_RE,
        keyword: KEYWORDS,
        literal: LITERALS,
        built_in: BUILT_INS,
        "variable.language": BUILT_IN_VARIABLES
      };

      // https://tc39.es/ecma262/#sec-literals-numeric-literals
      const decimalDigits = '[0-9](_?[0-9])*';
      const frac = `\\.(${decimalDigits})`;
      // DecimalIntegerLiteral, including Annex B NonOctalDecimalIntegerLiteral
      // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
      const decimalInteger = `0|[1-9](_?[0-9])*|0[0-7]*[89][0-9]*`;
      const NUMBER = {
        className: 'number',
        variants: [
        // DecimalLiteral
        {
          begin: `(\\b(${decimalInteger})((${frac})|\\.)?|(${frac}))` + `[eE][+-]?(${decimalDigits})\\b`
        }, {
          begin: `\\b(${decimalInteger})\\b((${frac})\\b|\\.)?|(${frac})\\b`
        },
        // DecimalBigIntegerLiteral
        {
          begin: `\\b(0|[1-9](_?[0-9])*)n\\b`
        },
        // NonDecimalIntegerLiteral
        {
          begin: "\\b0[xX][0-9a-fA-F](_?[0-9a-fA-F])*n?\\b"
        }, {
          begin: "\\b0[bB][0-1](_?[0-1])*n?\\b"
        }, {
          begin: "\\b0[oO][0-7](_?[0-7])*n?\\b"
        },
        // LegacyOctalIntegerLiteral (does not include underscore separators)
        // https://tc39.es/ecma262/#sec-additional-syntax-numeric-literals
        {
          begin: "\\b0[0-7]+n?\\b"
        }],
        relevance: 0
      };
      const SUBST = {
        className: 'subst',
        begin: '\\$\\{',
        end: '\\}',
        keywords: KEYWORDS$1,
        contains: [] // defined later
      };

      const HTML_TEMPLATE = {
        begin: 'html`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'xml'
        }
      };
      const CSS_TEMPLATE = {
        begin: 'css`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'css'
        }
      };
      const GRAPHQL_TEMPLATE = {
        begin: 'gql`',
        end: '',
        starts: {
          end: '`',
          returnEnd: false,
          contains: [hljs.BACKSLASH_ESCAPE, SUBST],
          subLanguage: 'graphql'
        }
      };
      const TEMPLATE_STRING = {
        className: 'string',
        begin: '`',
        end: '`',
        contains: [hljs.BACKSLASH_ESCAPE, SUBST]
      };
      const JSDOC_COMMENT = hljs.COMMENT(/\/\*\*(?!\/)/, '\\*/', {
        relevance: 0,
        contains: [{
          begin: '(?=@[A-Za-z]+)',
          relevance: 0,
          contains: [{
            className: 'doctag',
            begin: '@[A-Za-z]+'
          }, {
            className: 'type',
            begin: '\\{',
            end: '\\}',
            excludeEnd: true,
            excludeBegin: true,
            relevance: 0
          }, {
            className: 'variable',
            begin: IDENT_RE$1 + '(?=\\s*(-)|$)',
            endsParent: true,
            relevance: 0
          },
          // eat spaces (not newlines) so we can find
          // types or variables
          {
            begin: /(?=[^\n])\s/,
            relevance: 0
          }]
        }]
      });
      const COMMENT = {
        className: "comment",
        variants: [JSDOC_COMMENT, hljs.C_BLOCK_COMMENT_MODE, hljs.C_LINE_COMMENT_MODE]
      };
      const SUBST_INTERNALS = [hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, HTML_TEMPLATE, CSS_TEMPLATE, GRAPHQL_TEMPLATE, TEMPLATE_STRING,
      // Skip numbers when they are part of a variable name
      {
        match: /\$\d+/
      }, NUMBER
      // This is intentional:
      // See https://github.com/highlightjs/highlight.js/issues/3288
      // hljs.REGEXP_MODE
      ];

      SUBST.contains = SUBST_INTERNALS.concat({
        // we need to pair up {} inside our subst to prevent
        // it from ending too early by matching another }
        begin: /\{/,
        end: /\}/,
        keywords: KEYWORDS$1,
        contains: ["self"].concat(SUBST_INTERNALS)
      });
      const SUBST_AND_COMMENTS = [].concat(COMMENT, SUBST.contains);
      const PARAMS_CONTAINS = SUBST_AND_COMMENTS.concat([
      // eat recursive parens in sub expressions
      {
        begin: /\(/,
        end: /\)/,
        keywords: KEYWORDS$1,
        contains: ["self"].concat(SUBST_AND_COMMENTS)
      }]);
      const PARAMS = {
        className: 'params',
        begin: /\(/,
        end: /\)/,
        excludeBegin: true,
        excludeEnd: true,
        keywords: KEYWORDS$1,
        contains: PARAMS_CONTAINS
      };

      // ES6 classes
      const CLASS_OR_EXTENDS = {
        variants: [
        // class Car extends vehicle
        {
          match: [/class/, /\s+/, IDENT_RE$1, /\s+/, /extends/, /\s+/, regex.concat(IDENT_RE$1, "(", regex.concat(/\./, IDENT_RE$1), ")*")],
          scope: {
            1: "keyword",
            3: "title.class",
            5: "keyword",
            7: "title.class.inherited"
          }
        },
        // class Car
        {
          match: [/class/, /\s+/, IDENT_RE$1],
          scope: {
            1: "keyword",
            3: "title.class"
          }
        }]
      };
      const CLASS_REFERENCE = {
        relevance: 0,
        match: regex.either(
        // Hard coded exceptions
        /\bJSON/,
        // Float32Array, OutT
        /\b[A-Z][a-z]+([A-Z][a-z]*|\d)*/,
        // CSSFactory, CSSFactoryT
        /\b[A-Z]{2,}([A-Z][a-z]+|\d)+([A-Z][a-z]*)*/,
        // FPs, FPsT
        /\b[A-Z]{2,}[a-z]+([A-Z][a-z]+|\d)*([A-Z][a-z]*)*/
        // P
        // single letters are not highlighted
        // BLAH
        // this will be flagged as a UPPER_CASE_CONSTANT instead
        ),

        className: "title.class",
        keywords: {
          _: [
          // se we still get relevance credit for JS library classes
          ...TYPES, ...ERROR_TYPES]
        }
      };
      const USE_STRICT = {
        label: "use_strict",
        className: 'meta',
        relevance: 10,
        begin: /^\s*['"]use (strict|asm)['"]/
      };
      const FUNCTION_DEFINITION = {
        variants: [{
          match: [/function/, /\s+/, IDENT_RE$1, /(?=\s*\()/]
        },
        // anonymous function
        {
          match: [/function/, /\s*(?=\()/]
        }],
        className: {
          1: "keyword",
          3: "title.function"
        },
        label: "func.def",
        contains: [PARAMS],
        illegal: /%/
      };
      const UPPER_CASE_CONSTANT = {
        relevance: 0,
        match: /\b[A-Z][A-Z_0-9]+\b/,
        className: "variable.constant"
      };
      function noneOf(list) {
        return regex.concat("(?!", list.join("|"), ")");
      }
      const FUNCTION_CALL = {
        match: regex.concat(/\b/, noneOf([...BUILT_IN_GLOBALS, "super", "import"]), IDENT_RE$1, regex.lookahead(/\(/)),
        className: "title.function",
        relevance: 0
      };
      const PROPERTY_ACCESS = {
        begin: regex.concat(/\./, regex.lookahead(regex.concat(IDENT_RE$1, /(?![0-9A-Za-z$_(])/))),
        end: IDENT_RE$1,
        excludeBegin: true,
        keywords: "prototype",
        className: "property",
        relevance: 0
      };
      const GETTER_OR_SETTER = {
        match: [/get|set/, /\s+/, IDENT_RE$1, /(?=\()/],
        className: {
          1: "keyword",
          3: "title.function"
        },
        contains: [{
          // eat to avoid empty params
          begin: /\(\)/
        }, PARAMS]
      };
      const FUNC_LEAD_IN_RE = '(\\(' + '[^()]*(\\(' + '[^()]*(\\(' + '[^()]*' + '\\)[^()]*)*' + '\\)[^()]*)*' + '\\)|' + hljs.UNDERSCORE_IDENT_RE + ')\\s*=>';
      const FUNCTION_VARIABLE = {
        match: [/const|var|let/, /\s+/, IDENT_RE$1, /\s*/, /=\s*/, /(async\s*)?/,
        // async is optional
        regex.lookahead(FUNC_LEAD_IN_RE)],
        keywords: "async",
        className: {
          1: "keyword",
          3: "title.function"
        },
        contains: [PARAMS]
      };
      return {
        name: 'JavaScript',
        aliases: ['js', 'jsx', 'mjs', 'cjs'],
        keywords: KEYWORDS$1,
        // this will be extended by TypeScript
        exports: {
          PARAMS_CONTAINS,
          CLASS_REFERENCE
        },
        illegal: /#(?![$_A-z])/,
        contains: [hljs.SHEBANG({
          label: "shebang",
          binary: "node",
          relevance: 5
        }), USE_STRICT, hljs.APOS_STRING_MODE, hljs.QUOTE_STRING_MODE, HTML_TEMPLATE, CSS_TEMPLATE, GRAPHQL_TEMPLATE, TEMPLATE_STRING, COMMENT,
        // Skip numbers when they are part of a variable name
        {
          match: /\$\d+/
        }, NUMBER, CLASS_REFERENCE, {
          className: 'attr',
          begin: IDENT_RE$1 + regex.lookahead(':'),
          relevance: 0
        }, FUNCTION_VARIABLE, {
          // "value" container
          begin: '(' + hljs.RE_STARTERS_RE + '|\\b(case|return|throw)\\b)\\s*',
          keywords: 'return throw case',
          relevance: 0,
          contains: [COMMENT, hljs.REGEXP_MODE, {
            className: 'function',
            // we have to count the parens to make sure we actually have the
            // correct bounding ( ) before the =>.  There could be any number of
            // sub-expressions inside also surrounded by parens.
            begin: FUNC_LEAD_IN_RE,
            returnBegin: true,
            end: '\\s*=>',
            contains: [{
              className: 'params',
              variants: [{
                begin: hljs.UNDERSCORE_IDENT_RE,
                relevance: 0
              }, {
                className: null,
                begin: /\(\s*\)/,
                skip: true
              }, {
                begin: /\(/,
                end: /\)/,
                excludeBegin: true,
                excludeEnd: true,
                keywords: KEYWORDS$1,
                contains: PARAMS_CONTAINS
              }]
            }]
          }, {
            // could be a comma delimited list of params to a function call
            begin: /,/,
            relevance: 0
          }, {
            match: /\s+/,
            relevance: 0
          }, {
            // JSX
            variants: [{
              begin: FRAGMENT.begin,
              end: FRAGMENT.end
            }, {
              match: XML_SELF_CLOSING
            }, {
              begin: XML_TAG.begin,
              // we carefully check the opening tag to see if it truly
              // is a tag and not a false positive
              'on:begin': XML_TAG.isTrulyOpeningTag,
              end: XML_TAG.end
            }],
            subLanguage: 'xml',
            contains: [{
              begin: XML_TAG.begin,
              end: XML_TAG.end,
              skip: true,
              contains: ['self']
            }]
          }]
        }, FUNCTION_DEFINITION, {
          // prevent this from getting swallowed up by function
          // since they appear "function like"
          beginKeywords: "while if switch catch for"
        }, {
          // we have to count the parens to make sure we actually have the correct
          // bounding ( ).  There could be any number of sub-expressions inside
          // also surrounded by parens.
          begin: '\\b(?!function)' + hljs.UNDERSCORE_IDENT_RE + '\\(' +
          // first parens
          '[^()]*(\\(' + '[^()]*(\\(' + '[^()]*' + '\\)[^()]*)*' + '\\)[^()]*)*' + '\\)\\s*\\{',
          // end parens
          returnBegin: true,
          label: "func.def",
          contains: [PARAMS, hljs.inherit(hljs.TITLE_MODE, {
            begin: IDENT_RE$1,
            className: "title.function"
          })]
        },
        // catch ... so it won't trigger the property rule below
        {
          match: /\.\.\./,
          relevance: 0
        }, PROPERTY_ACCESS,
        // hack: prevents detection of keywords in some circumstances
        // .keyword()
        // $keyword = x
        {
          match: '\\$' + IDENT_RE$1,
          relevance: 0
        }, {
          match: [/\bconstructor(?=\s*\()/],
          className: {
            1: "title.function"
          },
          contains: [PARAMS]
        }, FUNCTION_CALL, UPPER_CASE_CONSTANT, CLASS_OR_EXTENDS, GETTER_OR_SETTER, {
          match: /\$[(.]/ // relevance booster for a pattern common to JS libs: `$(something)` and `$.something`
        }]
      };
    }

    /*
    Language: TypeScript
    Author: Panu Horsmalahti <panu.horsmalahti@iki.fi>
    Contributors: Ike Ku <dempfi@yahoo.com>
    Description: TypeScript is a strict superset of JavaScript
    Website: https://www.typescriptlang.org
    Category: common, scripting
    */

    /** @type LanguageFn */
    function typescript(hljs) {
      const tsLanguage = javascript(hljs);
      const IDENT_RE$1 = IDENT_RE;
      const TYPES = ["any", "void", "number", "boolean", "string", "object", "never", "symbol", "bigint", "unknown"];
      const NAMESPACE = {
        beginKeywords: 'namespace',
        end: /\{/,
        excludeEnd: true,
        contains: [tsLanguage.exports.CLASS_REFERENCE]
      };
      const INTERFACE = {
        beginKeywords: 'interface',
        end: /\{/,
        excludeEnd: true,
        keywords: {
          keyword: 'interface extends',
          built_in: TYPES
        },
        contains: [tsLanguage.exports.CLASS_REFERENCE]
      };
      const USE_STRICT = {
        className: 'meta',
        relevance: 10,
        begin: /^\s*['"]use strict['"]/
      };
      const TS_SPECIFIC_KEYWORDS = ["type", "namespace", "interface", "public", "private", "protected", "implements", "declare", "abstract", "readonly", "enum", "override"];
      const KEYWORDS$1 = {
        $pattern: IDENT_RE,
        keyword: KEYWORDS.concat(TS_SPECIFIC_KEYWORDS),
        literal: LITERALS,
        built_in: BUILT_INS.concat(TYPES),
        "variable.language": BUILT_IN_VARIABLES
      };
      const DECORATOR = {
        className: 'meta',
        begin: '@' + IDENT_RE$1
      };
      const swapMode = (mode, label, replacement) => {
        const indx = mode.contains.findIndex(m => m.label === label);
        if (indx === -1) {
          throw new Error("can not find mode to replace");
        }
        mode.contains.splice(indx, 1, replacement);
      };

      // this should update anywhere keywords is used since
      // it will be the same actual JS object
      Object.assign(tsLanguage.keywords, KEYWORDS$1);
      tsLanguage.exports.PARAMS_CONTAINS.push(DECORATOR);
      tsLanguage.contains = tsLanguage.contains.concat([DECORATOR, NAMESPACE, INTERFACE]);

      // TS gets a simpler shebang rule than JS
      swapMode(tsLanguage, "shebang", hljs.SHEBANG());
      // JS use strict rule purposely excludes `asm` which makes no sense
      swapMode(tsLanguage, "use_strict", USE_STRICT);
      const functionDeclaration = tsLanguage.contains.find(m => m.label === "func.def");
      functionDeclaration.relevance = 0; // () => {} is more typical in TypeScript

      Object.assign(tsLanguage, {
        name: 'TypeScript',
        aliases: ['ts', 'tsx', 'mts', 'cts']
      });
      return tsLanguage;
    }
    typescript_1 = typescript;
    return typescript_1;
  }

  /*
  Language: Visual Basic .NET
  Description: Visual Basic .NET (VB.NET) is a multi-paradigm, object-oriented programming language, implemented on the .NET Framework.
  Authors: Poren Chiang <ren.chiang@gmail.com>, Jan Pilzer
  Website: https://docs.microsoft.com/dotnet/visual-basic/getting-started
  Category: common
  */
  var vbnet_1;
  var hasRequiredVbnet;
  function requireVbnet() {
    if (hasRequiredVbnet) return vbnet_1;
    hasRequiredVbnet = 1;
    /** @type LanguageFn */
    function vbnet(hljs) {
      const regex = hljs.regex;
      /**
       * Character Literal
       * Either a single character ("a"C) or an escaped double quote (""""C).
       */
      const CHARACTER = {
        className: 'string',
        begin: /"(""|[^/n])"C\b/
      };
      const STRING = {
        className: 'string',
        begin: /"/,
        end: /"/,
        illegal: /\n/,
        contains: [{
          // double quote escape
          begin: /""/
        }]
      };

      /** Date Literals consist of a date, a time, or both separated by whitespace, surrounded by # */
      const MM_DD_YYYY = /\d{1,2}\/\d{1,2}\/\d{4}/;
      const YYYY_MM_DD = /\d{4}-\d{1,2}-\d{1,2}/;
      const TIME_12H = /(\d|1[012])(:\d+){0,2} *(AM|PM)/;
      const TIME_24H = /\d{1,2}(:\d{1,2}){1,2}/;
      const DATE = {
        className: 'literal',
        variants: [{
          // #YYYY-MM-DD# (ISO-Date) or #M/D/YYYY# (US-Date)
          begin: regex.concat(/# */, regex.either(YYYY_MM_DD, MM_DD_YYYY), / *#/)
        }, {
          // #H:mm[:ss]# (24h Time)
          begin: regex.concat(/# */, TIME_24H, / *#/)
        }, {
          // #h[:mm[:ss]] A# (12h Time)
          begin: regex.concat(/# */, TIME_12H, / *#/)
        }, {
          // date plus time
          begin: regex.concat(/# */, regex.either(YYYY_MM_DD, MM_DD_YYYY), / +/, regex.either(TIME_12H, TIME_24H), / *#/)
        }]
      };
      const NUMBER = {
        className: 'number',
        relevance: 0,
        variants: [{
          // Float
          begin: /\b\d[\d_]*((\.[\d_]+(E[+-]?[\d_]+)?)|(E[+-]?[\d_]+))[RFD@!#]?/
        }, {
          // Integer (base 10)
          begin: /\b\d[\d_]*((U?[SIL])|[%&])?/
        }, {
          // Integer (base 16)
          begin: /&H[\dA-F_]+((U?[SIL])|[%&])?/
        }, {
          // Integer (base 8)
          begin: /&O[0-7_]+((U?[SIL])|[%&])?/
        }, {
          // Integer (base 2)
          begin: /&B[01_]+((U?[SIL])|[%&])?/
        }]
      };
      const LABEL = {
        className: 'label',
        begin: /^\w+:/
      };
      const DOC_COMMENT = hljs.COMMENT(/'''/, /$/, {
        contains: [{
          className: 'doctag',
          begin: /<\/?/,
          end: />/
        }]
      });
      const COMMENT = hljs.COMMENT(null, /$/, {
        variants: [{
          begin: /'/
        }, {
          // TODO: Use multi-class for leading spaces
          begin: /([\t ]|^)REM(?=\s)/
        }]
      });
      const DIRECTIVES = {
        className: 'meta',
        // TODO: Use multi-class for indentation once available
        begin: /[\t ]*#(const|disable|else|elseif|enable|end|externalsource|if|region)\b/,
        end: /$/,
        keywords: {
          keyword: 'const disable else elseif enable end externalsource if region then'
        },
        contains: [COMMENT]
      };
      return {
        name: 'Visual Basic .NET',
        aliases: ['vb'],
        case_insensitive: true,
        classNameAliases: {
          label: 'symbol'
        },
        keywords: {
          keyword: 'addhandler alias aggregate ansi as async assembly auto binary by byref byval ' /* a-b */ + 'call case catch class compare const continue custom declare default delegate dim distinct do ' /* c-d */ + 'each equals else elseif end enum erase error event exit explicit finally for friend from function ' /* e-f */ + 'get global goto group handles if implements imports in inherits interface into iterator ' /* g-i */ + 'join key let lib loop me mid module mustinherit mustoverride mybase myclass ' /* j-m */ + 'namespace narrowing new next notinheritable notoverridable ' /* n */ + 'of off on operator option optional order overloads overridable overrides ' /* o */ + 'paramarray partial preserve private property protected public ' /* p */ + 'raiseevent readonly redim removehandler resume return ' /* r */ + 'select set shadows shared skip static step stop structure strict sub synclock ' /* s */ + 'take text then throw to try unicode until using when where while widening with withevents writeonly yield' /* t-y */,
          built_in:
          // Operators https://docs.microsoft.com/dotnet/visual-basic/language-reference/operators
          'addressof and andalso await directcast gettype getxmlnamespace is isfalse isnot istrue like mod nameof new not or orelse trycast typeof xor '
          // Type Conversion Functions https://docs.microsoft.com/dotnet/visual-basic/language-reference/functions/type-conversion-functions
          + 'cbool cbyte cchar cdate cdbl cdec cint clng cobj csbyte cshort csng cstr cuint culng cushort',
          type:
          // Data types https://docs.microsoft.com/dotnet/visual-basic/language-reference/data-types
          'boolean byte char date decimal double integer long object sbyte short single string uinteger ulong ushort',
          literal: 'true false nothing'
        },
        illegal: '//|\\{|\\}|endif|gosub|variant|wend|^\\$ ' /* reserved deprecated keywords */,
        contains: [CHARACTER, STRING, DATE, NUMBER, LABEL, DOC_COMMENT, COMMENT, DIRECTIVES]
      };
    }
    vbnet_1 = vbnet;
    return vbnet_1;
  }

  /*
  Language: WebAssembly
  Website: https://webassembly.org
  Description:  Wasm is designed as a portable compilation target for programming languages, enabling deployment on the web for client and server applications.
  Category: web, common
  Audit: 2020
  */
  var wasm_1;
  var hasRequiredWasm;
  function requireWasm() {
    if (hasRequiredWasm) return wasm_1;
    hasRequiredWasm = 1;
    /** @type LanguageFn */
    function wasm(hljs) {
      hljs.regex;
      const BLOCK_COMMENT = hljs.COMMENT(/\(;/, /;\)/);
      BLOCK_COMMENT.contains.push("self");
      const LINE_COMMENT = hljs.COMMENT(/;;/, /$/);
      const KWS = ["anyfunc", "block", "br", "br_if", "br_table", "call", "call_indirect", "data", "drop", "elem", "else", "end", "export", "func", "global.get", "global.set", "local.get", "local.set", "local.tee", "get_global", "get_local", "global", "if", "import", "local", "loop", "memory", "memory.grow", "memory.size", "module", "mut", "nop", "offset", "param", "result", "return", "select", "set_global", "set_local", "start", "table", "tee_local", "then", "type", "unreachable"];
      const FUNCTION_REFERENCE = {
        begin: [/(?:func|call|call_indirect)/, /\s+/, /\$[^\s)]+/],
        className: {
          1: "keyword",
          3: "title.function"
        }
      };
      const ARGUMENT = {
        className: "variable",
        begin: /\$[\w_]+/
      };
      const PARENS = {
        match: /(\((?!;)|\))+/,
        className: "punctuation",
        relevance: 0
      };
      const NUMBER = {
        className: "number",
        relevance: 0,
        // borrowed from Prism, TODO: split out into variants
        match: /[+-]?\b(?:\d(?:_?\d)*(?:\.\d(?:_?\d)*)?(?:[eE][+-]?\d(?:_?\d)*)?|0x[\da-fA-F](?:_?[\da-fA-F])*(?:\.[\da-fA-F](?:_?[\da-fA-D])*)?(?:[pP][+-]?\d(?:_?\d)*)?)\b|\binf\b|\bnan(?::0x[\da-fA-F](?:_?[\da-fA-D])*)?\b/
      };
      const TYPE = {
        // look-ahead prevents us from gobbling up opcodes
        match: /(i32|i64|f32|f64)(?!\.)/,
        className: "type"
      };
      const MATH_OPERATIONS = {
        className: "keyword",
        // borrowed from Prism, TODO: split out into variants
        match: /\b(f32|f64|i32|i64)(?:\.(?:abs|add|and|ceil|clz|const|convert_[su]\/i(?:32|64)|copysign|ctz|demote\/f64|div(?:_[su])?|eqz?|extend_[su]\/i32|floor|ge(?:_[su])?|gt(?:_[su])?|le(?:_[su])?|load(?:(?:8|16|32)_[su])?|lt(?:_[su])?|max|min|mul|nearest|neg?|or|popcnt|promote\/f32|reinterpret\/[fi](?:32|64)|rem_[su]|rot[lr]|shl|shr_[su]|store(?:8|16|32)?|sqrt|sub|trunc(?:_[su]\/f(?:32|64))?|wrap\/i64|xor))\b/
      };
      const OFFSET_ALIGN = {
        match: [/(?:offset|align)/, /\s*/, /=/],
        className: {
          1: "keyword",
          3: "operator"
        }
      };
      return {
        name: 'WebAssembly',
        keywords: {
          $pattern: /[\w.]+/,
          keyword: KWS
        },
        contains: [LINE_COMMENT, BLOCK_COMMENT, OFFSET_ALIGN, ARGUMENT, PARENS, FUNCTION_REFERENCE, hljs.QUOTE_STRING_MODE, TYPE, MATH_OPERATIONS, NUMBER]
      };
    }
    wasm_1 = wasm;
    return wasm_1;
  }

  var hljs$1 = core;
  hljs$1.registerLanguage('xml', requireXml());
  hljs$1.registerLanguage('bash', requireBash());
  hljs$1.registerLanguage('c', requireC());
  hljs$1.registerLanguage('cpp', requireCpp());
  hljs$1.registerLanguage('csharp', requireCsharp());
  hljs$1.registerLanguage('css', requireCss());
  hljs$1.registerLanguage('markdown', requireMarkdown());
  hljs$1.registerLanguage('diff', requireDiff());
  hljs$1.registerLanguage('ruby', requireRuby());
  hljs$1.registerLanguage('go', requireGo());
  hljs$1.registerLanguage('graphql', requireGraphql());
  hljs$1.registerLanguage('ini', requireIni());
  hljs$1.registerLanguage('java', requireJava());
  hljs$1.registerLanguage('javascript', requireJavascript());
  hljs$1.registerLanguage('json', requireJson());
  hljs$1.registerLanguage('kotlin', requireKotlin());
  hljs$1.registerLanguage('less', requireLess());
  hljs$1.registerLanguage('lua', requireLua());
  hljs$1.registerLanguage('makefile', requireMakefile());
  hljs$1.registerLanguage('perl', requirePerl());
  hljs$1.registerLanguage('objectivec', requireObjectivec());
  hljs$1.registerLanguage('php', requirePhp());
  hljs$1.registerLanguage('php-template', requirePhpTemplate());
  hljs$1.registerLanguage('plaintext', requirePlaintext());
  hljs$1.registerLanguage('python', requirePython());
  hljs$1.registerLanguage('python-repl', requirePythonRepl());
  hljs$1.registerLanguage('r', requireR());
  hljs$1.registerLanguage('rust', requireRust());
  hljs$1.registerLanguage('scss', requireScss());
  hljs$1.registerLanguage('shell', requireShell());
  hljs$1.registerLanguage('sql', requireSql());
  hljs$1.registerLanguage('swift', requireSwift());
  hljs$1.registerLanguage('yaml', requireYaml());
  hljs$1.registerLanguage('typescript', requireTypescript());
  hljs$1.registerLanguage('vbnet', requireVbnet());
  hljs$1.registerLanguage('wasm', requireWasm());
  hljs$1.HighlightJS = hljs$1;
  hljs$1.default = hljs$1;
  var common = hljs$1;

  var showdown = {exports: {}};

  (function (module) {
    (function () {
      /**
       * Created by Tivie on 13-07-2015.
       */

      function getDefaultOpts(simple) {

        var defaultOptions = {
          omitExtraWLInCodeBlocks: {
            defaultValue: false,
            describe: 'Omit the default extra whiteline added to code blocks',
            type: 'boolean'
          },
          noHeaderId: {
            defaultValue: false,
            describe: 'Turn on/off generated header id',
            type: 'boolean'
          },
          prefixHeaderId: {
            defaultValue: false,
            describe: 'Add a prefix to the generated header ids. Passing a string will prefix that string to the header id. Setting to true will add a generic \'section-\' prefix',
            type: 'string'
          },
          rawPrefixHeaderId: {
            defaultValue: false,
            describe: 'Setting this option to true will prevent showdown from modifying the prefix. This might result in malformed IDs (if, for instance, the " char is used in the prefix)',
            type: 'boolean'
          },
          ghCompatibleHeaderId: {
            defaultValue: false,
            describe: 'Generate header ids compatible with github style (spaces are replaced with dashes, a bunch of non alphanumeric chars are removed)',
            type: 'boolean'
          },
          rawHeaderId: {
            defaultValue: false,
            describe: 'Remove only spaces, \' and " from generated header ids (including prefixes), replacing them with dashes (-). WARNING: This might result in malformed ids',
            type: 'boolean'
          },
          headerLevelStart: {
            defaultValue: false,
            describe: 'The header blocks level start',
            type: 'integer'
          },
          parseImgDimensions: {
            defaultValue: false,
            describe: 'Turn on/off image dimension parsing',
            type: 'boolean'
          },
          simplifiedAutoLink: {
            defaultValue: false,
            describe: 'Turn on/off GFM autolink style',
            type: 'boolean'
          },
          excludeTrailingPunctuationFromURLs: {
            defaultValue: false,
            describe: 'Excludes trailing punctuation from links generated with autoLinking',
            type: 'boolean'
          },
          literalMidWordUnderscores: {
            defaultValue: false,
            describe: 'Parse midword underscores as literal underscores',
            type: 'boolean'
          },
          literalMidWordAsterisks: {
            defaultValue: false,
            describe: 'Parse midword asterisks as literal asterisks',
            type: 'boolean'
          },
          strikethrough: {
            defaultValue: false,
            describe: 'Turn on/off strikethrough support',
            type: 'boolean'
          },
          tables: {
            defaultValue: false,
            describe: 'Turn on/off tables support',
            type: 'boolean'
          },
          tablesHeaderId: {
            defaultValue: false,
            describe: 'Add an id to table headers',
            type: 'boolean'
          },
          ghCodeBlocks: {
            defaultValue: true,
            describe: 'Turn on/off GFM fenced code blocks support',
            type: 'boolean'
          },
          tasklists: {
            defaultValue: false,
            describe: 'Turn on/off GFM tasklist support',
            type: 'boolean'
          },
          smoothLivePreview: {
            defaultValue: false,
            describe: 'Prevents weird effects in live previews due to incomplete input',
            type: 'boolean'
          },
          smartIndentationFix: {
            defaultValue: false,
            describe: 'Tries to smartly fix indentation in es6 strings',
            type: 'boolean'
          },
          disableForced4SpacesIndentedSublists: {
            defaultValue: false,
            describe: 'Disables the requirement of indenting nested sublists by 4 spaces',
            type: 'boolean'
          },
          simpleLineBreaks: {
            defaultValue: false,
            describe: 'Parses simple line breaks as <br> (GFM Style)',
            type: 'boolean'
          },
          requireSpaceBeforeHeadingText: {
            defaultValue: false,
            describe: 'Makes adding a space between `#` and the header text mandatory (GFM Style)',
            type: 'boolean'
          },
          ghMentions: {
            defaultValue: false,
            describe: 'Enables github @mentions',
            type: 'boolean'
          },
          ghMentionsLink: {
            defaultValue: 'https://github.com/{u}',
            describe: 'Changes the link generated by @mentions. Only applies if ghMentions option is enabled.',
            type: 'string'
          },
          encodeEmails: {
            defaultValue: true,
            describe: 'Encode e-mail addresses through the use of Character Entities, transforming ASCII e-mail addresses into its equivalent decimal entities',
            type: 'boolean'
          },
          openLinksInNewWindow: {
            defaultValue: false,
            describe: 'Open all links in new windows',
            type: 'boolean'
          },
          backslashEscapesHTMLTags: {
            defaultValue: false,
            describe: 'Support for HTML Tag escaping. ex: \<div>foo\</div>',
            type: 'boolean'
          },
          emoji: {
            defaultValue: false,
            describe: 'Enable emoji support. Ex: `this is a :smile: emoji`',
            type: 'boolean'
          },
          underline: {
            defaultValue: false,
            describe: 'Enable support for underline. Syntax is double or triple underscores: `__underline word__`. With this option enabled, underscores no longer parses into `<em>` and `<strong>`',
            type: 'boolean'
          },
          ellipsis: {
            defaultValue: true,
            describe: 'Replaces three dots with the ellipsis unicode character',
            type: 'boolean'
          },
          completeHTMLDocument: {
            defaultValue: false,
            describe: 'Outputs a complete html document, including `<html>`, `<head>` and `<body>` tags',
            type: 'boolean'
          },
          metadata: {
            defaultValue: false,
            describe: 'Enable support for document metadata (defined at the top of the document between `«««` and `»»»` or between `---` and `---`).',
            type: 'boolean'
          },
          splitAdjacentBlockquotes: {
            defaultValue: false,
            describe: 'Split adjacent blockquote blocks',
            type: 'boolean'
          }
        };
        if (simple === false) {
          return JSON.parse(JSON.stringify(defaultOptions));
        }
        var ret = {};
        for (var opt in defaultOptions) {
          if (defaultOptions.hasOwnProperty(opt)) {
            ret[opt] = defaultOptions[opt].defaultValue;
          }
        }
        return ret;
      }
      function allOptionsOn() {

        var options = getDefaultOpts(true),
          ret = {};
        for (var opt in options) {
          if (options.hasOwnProperty(opt)) {
            ret[opt] = true;
          }
        }
        return ret;
      }

      /**
       * Created by Tivie on 06-01-2015.
       */

      // Private properties
      var showdown = {},
        parsers = {},
        extensions = {},
        globalOptions = getDefaultOpts(true),
        setFlavor = 'vanilla',
        flavor = {
          github: {
            omitExtraWLInCodeBlocks: true,
            simplifiedAutoLink: true,
            excludeTrailingPunctuationFromURLs: true,
            literalMidWordUnderscores: true,
            strikethrough: true,
            tables: true,
            tablesHeaderId: true,
            ghCodeBlocks: true,
            tasklists: true,
            disableForced4SpacesIndentedSublists: true,
            simpleLineBreaks: true,
            requireSpaceBeforeHeadingText: true,
            ghCompatibleHeaderId: true,
            ghMentions: true,
            backslashEscapesHTMLTags: true,
            emoji: true,
            splitAdjacentBlockquotes: true
          },
          original: {
            noHeaderId: true,
            ghCodeBlocks: false
          },
          ghost: {
            omitExtraWLInCodeBlocks: true,
            parseImgDimensions: true,
            simplifiedAutoLink: true,
            excludeTrailingPunctuationFromURLs: true,
            literalMidWordUnderscores: true,
            strikethrough: true,
            tables: true,
            tablesHeaderId: true,
            ghCodeBlocks: true,
            tasklists: true,
            smoothLivePreview: true,
            simpleLineBreaks: true,
            requireSpaceBeforeHeadingText: true,
            ghMentions: false,
            encodeEmails: true
          },
          vanilla: getDefaultOpts(true),
          allOn: allOptionsOn()
        };

      /**
       * helper namespace
       * @type {{}}
       */
      showdown.helper = {};

      /**
       * TODO LEGACY SUPPORT CODE
       * @type {{}}
       */
      showdown.extensions = {};

      /**
       * Set a global option
       * @static
       * @param {string} key
       * @param {*} value
       * @returns {showdown}
       */
      showdown.setOption = function (key, value) {

        globalOptions[key] = value;
        return this;
      };

      /**
       * Get a global option
       * @static
       * @param {string} key
       * @returns {*}
       */
      showdown.getOption = function (key) {

        return globalOptions[key];
      };

      /**
       * Get the global options
       * @static
       * @returns {{}}
       */
      showdown.getOptions = function () {

        return globalOptions;
      };

      /**
       * Reset global options to the default values
       * @static
       */
      showdown.resetOptions = function () {

        globalOptions = getDefaultOpts(true);
      };

      /**
       * Set the flavor showdown should use as default
       * @param {string} name
       */
      showdown.setFlavor = function (name) {

        if (!flavor.hasOwnProperty(name)) {
          throw Error(name + ' flavor was not found');
        }
        showdown.resetOptions();
        var preset = flavor[name];
        setFlavor = name;
        for (var option in preset) {
          if (preset.hasOwnProperty(option)) {
            globalOptions[option] = preset[option];
          }
        }
      };

      /**
       * Get the currently set flavor
       * @returns {string}
       */
      showdown.getFlavor = function () {

        return setFlavor;
      };

      /**
       * Get the options of a specified flavor. Returns undefined if the flavor was not found
       * @param {string} name Name of the flavor
       * @returns {{}|undefined}
       */
      showdown.getFlavorOptions = function (name) {

        if (flavor.hasOwnProperty(name)) {
          return flavor[name];
        }
      };

      /**
       * Get the default options
       * @static
       * @param {boolean} [simple=true]
       * @returns {{}}
       */
      showdown.getDefaultOptions = function (simple) {

        return getDefaultOpts(simple);
      };

      /**
       * Get or set a subParser
       *
       * subParser(name)       - Get a registered subParser
       * subParser(name, func) - Register a subParser
       * @static
       * @param {string} name
       * @param {function} [func]
       * @returns {*}
       */
      showdown.subParser = function (name, func) {

        if (showdown.helper.isString(name)) {
          if (typeof func !== 'undefined') {
            parsers[name] = func;
          } else {
            if (parsers.hasOwnProperty(name)) {
              return parsers[name];
            } else {
              throw Error('SubParser named ' + name + ' not registered!');
            }
          }
        }
      };

      /**
       * Gets or registers an extension
       * @static
       * @param {string} name
       * @param {object|object[]|function=} ext
       * @returns {*}
       */
      showdown.extension = function (name, ext) {

        if (!showdown.helper.isString(name)) {
          throw Error('Extension \'name\' must be a string');
        }
        name = showdown.helper.stdExtName(name);

        // Getter
        if (showdown.helper.isUndefined(ext)) {
          if (!extensions.hasOwnProperty(name)) {
            throw Error('Extension named ' + name + ' is not registered!');
          }
          return extensions[name];

          // Setter
        } else {
          // Expand extension if it's wrapped in a function
          if (typeof ext === 'function') {
            ext = ext();
          }

          // Ensure extension is an array
          if (!showdown.helper.isArray(ext)) {
            ext = [ext];
          }
          var validExtension = validate(ext, name);
          if (validExtension.valid) {
            extensions[name] = ext;
          } else {
            throw Error(validExtension.error);
          }
        }
      };

      /**
       * Gets all extensions registered
       * @returns {{}}
       */
      showdown.getAllExtensions = function () {

        return extensions;
      };

      /**
       * Remove an extension
       * @param {string} name
       */
      showdown.removeExtension = function (name) {

        delete extensions[name];
      };

      /**
       * Removes all extensions
       */
      showdown.resetExtensions = function () {

        extensions = {};
      };

      /**
       * Validate extension
       * @param {array} extension
       * @param {string} name
       * @returns {{valid: boolean, error: string}}
       */
      function validate(extension, name) {

        var errMsg = name ? 'Error in ' + name + ' extension->' : 'Error in unnamed extension',
          ret = {
            valid: true,
            error: ''
          };
        if (!showdown.helper.isArray(extension)) {
          extension = [extension];
        }
        for (var i = 0; i < extension.length; ++i) {
          var baseMsg = errMsg + ' sub-extension ' + i + ': ',
            ext = extension[i];
          if (typeof ext !== 'object') {
            ret.valid = false;
            ret.error = baseMsg + 'must be an object, but ' + typeof ext + ' given';
            return ret;
          }
          if (!showdown.helper.isString(ext.type)) {
            ret.valid = false;
            ret.error = baseMsg + 'property "type" must be a string, but ' + typeof ext.type + ' given';
            return ret;
          }
          var type = ext.type = ext.type.toLowerCase();

          // normalize extension type
          if (type === 'language') {
            type = ext.type = 'lang';
          }
          if (type === 'html') {
            type = ext.type = 'output';
          }
          if (type !== 'lang' && type !== 'output' && type !== 'listener') {
            ret.valid = false;
            ret.error = baseMsg + 'type ' + type + ' is not recognized. Valid values: "lang/language", "output/html" or "listener"';
            return ret;
          }
          if (type === 'listener') {
            if (showdown.helper.isUndefined(ext.listeners)) {
              ret.valid = false;
              ret.error = baseMsg + '. Extensions of type "listener" must have a property called "listeners"';
              return ret;
            }
          } else {
            if (showdown.helper.isUndefined(ext.filter) && showdown.helper.isUndefined(ext.regex)) {
              ret.valid = false;
              ret.error = baseMsg + type + ' extensions must define either a "regex" property or a "filter" method';
              return ret;
            }
          }
          if (ext.listeners) {
            if (typeof ext.listeners !== 'object') {
              ret.valid = false;
              ret.error = baseMsg + '"listeners" property must be an object but ' + typeof ext.listeners + ' given';
              return ret;
            }
            for (var ln in ext.listeners) {
              if (ext.listeners.hasOwnProperty(ln)) {
                if (typeof ext.listeners[ln] !== 'function') {
                  ret.valid = false;
                  ret.error = baseMsg + '"listeners" property must be an hash of [event name]: [callback]. listeners.' + ln + ' must be a function but ' + typeof ext.listeners[ln] + ' given';
                  return ret;
                }
              }
            }
          }
          if (ext.filter) {
            if (typeof ext.filter !== 'function') {
              ret.valid = false;
              ret.error = baseMsg + '"filter" must be a function, but ' + typeof ext.filter + ' given';
              return ret;
            }
          } else if (ext.regex) {
            if (showdown.helper.isString(ext.regex)) {
              ext.regex = new RegExp(ext.regex, 'g');
            }
            if (!(ext.regex instanceof RegExp)) {
              ret.valid = false;
              ret.error = baseMsg + '"regex" property must either be a string or a RegExp object, but ' + typeof ext.regex + ' given';
              return ret;
            }
            if (showdown.helper.isUndefined(ext.replace)) {
              ret.valid = false;
              ret.error = baseMsg + '"regex" extensions must implement a replace string or function';
              return ret;
            }
          }
        }
        return ret;
      }

      /**
       * Validate extension
       * @param {object} ext
       * @returns {boolean}
       */
      showdown.validateExtension = function (ext) {

        var validateExtension = validate(ext, null);
        if (!validateExtension.valid) {
          console.warn(validateExtension.error);
          return false;
        }
        return true;
      };

      /**
       * showdownjs helper functions
       */

      if (!showdown.hasOwnProperty('helper')) {
        showdown.helper = {};
      }

      /**
       * Check if var is string
       * @static
       * @param {string} a
       * @returns {boolean}
       */
      showdown.helper.isString = function (a) {

        return typeof a === 'string' || a instanceof String;
      };

      /**
       * Check if var is a function
       * @static
       * @param {*} a
       * @returns {boolean}
       */
      showdown.helper.isFunction = function (a) {

        var getType = {};
        return a && getType.toString.call(a) === '[object Function]';
      };

      /**
       * isArray helper function
       * @static
       * @param {*} a
       * @returns {boolean}
       */
      showdown.helper.isArray = function (a) {

        return Array.isArray(a);
      };

      /**
       * Check if value is undefined
       * @static
       * @param {*} value The value to check.
       * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
       */
      showdown.helper.isUndefined = function (value) {

        return typeof value === 'undefined';
      };

      /**
       * ForEach helper function
       * Iterates over Arrays and Objects (own properties only)
       * @static
       * @param {*} obj
       * @param {function} callback Accepts 3 params: 1. value, 2. key, 3. the original array/object
       */
      showdown.helper.forEach = function (obj, callback) {

        // check if obj is defined
        if (showdown.helper.isUndefined(obj)) {
          throw new Error('obj param is required');
        }
        if (showdown.helper.isUndefined(callback)) {
          throw new Error('callback param is required');
        }
        if (!showdown.helper.isFunction(callback)) {
          throw new Error('callback param must be a function/closure');
        }
        if (typeof obj.forEach === 'function') {
          obj.forEach(callback);
        } else if (showdown.helper.isArray(obj)) {
          for (var i = 0; i < obj.length; i++) {
            callback(obj[i], i, obj);
          }
        } else if (typeof obj === 'object') {
          for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) {
              callback(obj[prop], prop, obj);
            }
          }
        } else {
          throw new Error('obj does not seem to be an array or an iterable object');
        }
      };

      /**
       * Standardidize extension name
       * @static
       * @param {string} s extension name
       * @returns {string}
       */
      showdown.helper.stdExtName = function (s) {

        return s.replace(/[_?*+\/\\.^-]/g, '').replace(/\s/g, '').toLowerCase();
      };
      function escapeCharactersCallback(wholeMatch, m1) {

        var charCodeToEscape = m1.charCodeAt(0);
        return '¨E' + charCodeToEscape + 'E';
      }

      /**
       * Callback used to escape characters when passing through String.replace
       * @static
       * @param {string} wholeMatch
       * @param {string} m1
       * @returns {string}
       */
      showdown.helper.escapeCharactersCallback = escapeCharactersCallback;

      /**
       * Escape characters in a string
       * @static
       * @param {string} text
       * @param {string} charsToEscape
       * @param {boolean} afterBackslash
       * @returns {XML|string|void|*}
       */
      showdown.helper.escapeCharacters = function (text, charsToEscape, afterBackslash) {

        // First we have to escape the escape characters so that
        // we can build a character class out of them
        var regexString = '([' + charsToEscape.replace(/([\[\]\\])/g, '\\$1') + '])';
        if (afterBackslash) {
          regexString = '\\\\' + regexString;
        }
        var regex = new RegExp(regexString, 'g');
        text = text.replace(regex, escapeCharactersCallback);
        return text;
      };

      /**
       * Unescape HTML entities
       * @param txt
       * @returns {string}
       */
      showdown.helper.unescapeHTMLEntities = function (txt) {

        return txt.replace(/&quot;/g, '"').replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&amp;/g, '&');
      };
      var rgxFindMatchPos = function (str, left, right, flags) {

        var f = flags || '',
          g = f.indexOf('g') > -1,
          x = new RegExp(left + '|' + right, 'g' + f.replace(/g/g, '')),
          l = new RegExp(left, f.replace(/g/g, '')),
          pos = [],
          t,
          s,
          m,
          start,
          end;
        do {
          t = 0;
          while (m = x.exec(str)) {
            if (l.test(m[0])) {
              if (!t++) {
                s = x.lastIndex;
                start = s - m[0].length;
              }
            } else if (t) {
              if (! --t) {
                end = m.index + m[0].length;
                var obj = {
                  left: {
                    start: start,
                    end: s
                  },
                  match: {
                    start: s,
                    end: m.index
                  },
                  right: {
                    start: m.index,
                    end: end
                  },
                  wholeMatch: {
                    start: start,
                    end: end
                  }
                };
                pos.push(obj);
                if (!g) {
                  return pos;
                }
              }
            }
          }
        } while (t && (x.lastIndex = s));
        return pos;
      };

      /**
       * matchRecursiveRegExp
       *
       * (c) 2007 Steven Levithan <stevenlevithan.com>
       * MIT License
       *
       * Accepts a string to search, a left and right format delimiter
       * as regex patterns, and optional regex flags. Returns an array
       * of matches, allowing nested instances of left/right delimiters.
       * Use the "g" flag to return all matches, otherwise only the
       * first is returned. Be careful to ensure that the left and
       * right format delimiters produce mutually exclusive matches.
       * Backreferences are not supported within the right delimiter
       * due to how it is internally combined with the left delimiter.
       * When matching strings whose format delimiters are unbalanced
       * to the left or right, the output is intentionally as a
       * conventional regex library with recursion support would
       * produce, e.g. "<<x>" and "<x>>" both produce ["x"] when using
       * "<" and ">" as the delimiters (both strings contain a single,
       * balanced instance of "<x>").
       *
       * examples:
       * matchRecursiveRegExp("test", "\\(", "\\)")
       * returns: []
       * matchRecursiveRegExp("<t<<e>><s>>t<>", "<", ">", "g")
       * returns: ["t<<e>><s>", ""]
       * matchRecursiveRegExp("<div id=\"x\">test</div>", "<div\\b[^>]*>", "</div>", "gi")
       * returns: ["test"]
       */
      showdown.helper.matchRecursiveRegExp = function (str, left, right, flags) {

        var matchPos = rgxFindMatchPos(str, left, right, flags),
          results = [];
        for (var i = 0; i < matchPos.length; ++i) {
          results.push([str.slice(matchPos[i].wholeMatch.start, matchPos[i].wholeMatch.end), str.slice(matchPos[i].match.start, matchPos[i].match.end), str.slice(matchPos[i].left.start, matchPos[i].left.end), str.slice(matchPos[i].right.start, matchPos[i].right.end)]);
        }
        return results;
      };

      /**
       *
       * @param {string} str
       * @param {string|function} replacement
       * @param {string} left
       * @param {string} right
       * @param {string} flags
       * @returns {string}
       */
      showdown.helper.replaceRecursiveRegExp = function (str, replacement, left, right, flags) {

        if (!showdown.helper.isFunction(replacement)) {
          var repStr = replacement;
          replacement = function () {
            return repStr;
          };
        }
        var matchPos = rgxFindMatchPos(str, left, right, flags),
          finalStr = str,
          lng = matchPos.length;
        if (lng > 0) {
          var bits = [];
          if (matchPos[0].wholeMatch.start !== 0) {
            bits.push(str.slice(0, matchPos[0].wholeMatch.start));
          }
          for (var i = 0; i < lng; ++i) {
            bits.push(replacement(str.slice(matchPos[i].wholeMatch.start, matchPos[i].wholeMatch.end), str.slice(matchPos[i].match.start, matchPos[i].match.end), str.slice(matchPos[i].left.start, matchPos[i].left.end), str.slice(matchPos[i].right.start, matchPos[i].right.end)));
            if (i < lng - 1) {
              bits.push(str.slice(matchPos[i].wholeMatch.end, matchPos[i + 1].wholeMatch.start));
            }
          }
          if (matchPos[lng - 1].wholeMatch.end < str.length) {
            bits.push(str.slice(matchPos[lng - 1].wholeMatch.end));
          }
          finalStr = bits.join('');
        }
        return finalStr;
      };

      /**
       * Returns the index within the passed String object of the first occurrence of the specified regex,
       * starting the search at fromIndex. Returns -1 if the value is not found.
       *
       * @param {string} str string to search
       * @param {RegExp} regex Regular expression to search
       * @param {int} [fromIndex = 0] Index to start the search
       * @returns {Number}
       * @throws InvalidArgumentError
       */
      showdown.helper.regexIndexOf = function (str, regex, fromIndex) {

        if (!showdown.helper.isString(str)) {
          throw 'InvalidArgumentError: first parameter of showdown.helper.regexIndexOf function must be a string';
        }
        if (regex instanceof RegExp === false) {
          throw 'InvalidArgumentError: second parameter of showdown.helper.regexIndexOf function must be an instance of RegExp';
        }
        var indexOf = str.substring(fromIndex || 0).search(regex);
        return indexOf >= 0 ? indexOf + (fromIndex || 0) : indexOf;
      };

      /**
       * Splits the passed string object at the defined index, and returns an array composed of the two substrings
       * @param {string} str string to split
       * @param {int} index index to split string at
       * @returns {[string,string]}
       * @throws InvalidArgumentError
       */
      showdown.helper.splitAtIndex = function (str, index) {

        if (!showdown.helper.isString(str)) {
          throw 'InvalidArgumentError: first parameter of showdown.helper.regexIndexOf function must be a string';
        }
        return [str.substring(0, index), str.substring(index)];
      };

      /**
       * Obfuscate an e-mail address through the use of Character Entities,
       * transforming ASCII characters into their equivalent decimal or hex entities.
       *
       * Since it has a random component, subsequent calls to this function produce different results
       *
       * @param {string} mail
       * @returns {string}
       */
      showdown.helper.encodeEmailAddress = function (mail) {

        var encode = [function (ch) {
          return '&#' + ch.charCodeAt(0) + ';';
        }, function (ch) {
          return '&#x' + ch.charCodeAt(0).toString(16) + ';';
        }, function (ch) {
          return ch;
        }];
        mail = mail.replace(/./g, function (ch) {
          if (ch === '@') {
            // this *must* be encoded. I insist.
            ch = encode[Math.floor(Math.random() * 2)](ch);
          } else {
            var r = Math.random();
            // roughly 10% raw, 45% hex, 45% dec
            ch = r > 0.9 ? encode[2](ch) : r > 0.45 ? encode[1](ch) : encode[0](ch);
          }
          return ch;
        });
        return mail;
      };

      /**
       *
       * @param str
       * @param targetLength
       * @param padString
       * @returns {string}
       */
      showdown.helper.padEnd = function padEnd(str, targetLength, padString) {

        /*jshint bitwise: false*/
        // eslint-disable-next-line space-infix-ops
        targetLength = targetLength >> 0; //floor if number or convert non-number to 0;
        /*jshint bitwise: true*/
        padString = String(padString || ' ');
        if (str.length > targetLength) {
          return String(str);
        } else {
          targetLength = targetLength - str.length;
          if (targetLength > padString.length) {
            padString += padString.repeat(targetLength / padString.length); //append to original to ensure we are longer than needed
          }

          return String(str) + padString.slice(0, targetLength);
        }
      };

      /**
       * POLYFILLS
       */
      // use this instead of builtin is undefined for IE8 compatibility
      if (typeof console === 'undefined') {
        console = {
          warn: function (msg) {

            alert(msg);
          },
          log: function (msg) {

            alert(msg);
          },
          error: function (msg) {

            throw msg;
          }
        };
      }

      /**
       * Common regexes.
       * We declare some common regexes to improve performance
       */
      showdown.helper.regexes = {
        asteriskDashAndColon: /([*_:~])/g
      };

      /**
       * EMOJIS LIST
       */
      showdown.helper.emojis = {
        '+1': '\ud83d\udc4d',
        '-1': '\ud83d\udc4e',
        '100': '\ud83d\udcaf',
        '1234': '\ud83d\udd22',
        '1st_place_medal': '\ud83e\udd47',
        '2nd_place_medal': '\ud83e\udd48',
        '3rd_place_medal': '\ud83e\udd49',
        '8ball': '\ud83c\udfb1',
        'a': '\ud83c\udd70\ufe0f',
        'ab': '\ud83c\udd8e',
        'abc': '\ud83d\udd24',
        'abcd': '\ud83d\udd21',
        'accept': '\ud83c\ude51',
        'aerial_tramway': '\ud83d\udea1',
        'airplane': '\u2708\ufe0f',
        'alarm_clock': '\u23f0',
        'alembic': '\u2697\ufe0f',
        'alien': '\ud83d\udc7d',
        'ambulance': '\ud83d\ude91',
        'amphora': '\ud83c\udffa',
        'anchor': '\u2693\ufe0f',
        'angel': '\ud83d\udc7c',
        'anger': '\ud83d\udca2',
        'angry': '\ud83d\ude20',
        'anguished': '\ud83d\ude27',
        'ant': '\ud83d\udc1c',
        'apple': '\ud83c\udf4e',
        'aquarius': '\u2652\ufe0f',
        'aries': '\u2648\ufe0f',
        'arrow_backward': '\u25c0\ufe0f',
        'arrow_double_down': '\u23ec',
        'arrow_double_up': '\u23eb',
        'arrow_down': '\u2b07\ufe0f',
        'arrow_down_small': '\ud83d\udd3d',
        'arrow_forward': '\u25b6\ufe0f',
        'arrow_heading_down': '\u2935\ufe0f',
        'arrow_heading_up': '\u2934\ufe0f',
        'arrow_left': '\u2b05\ufe0f',
        'arrow_lower_left': '\u2199\ufe0f',
        'arrow_lower_right': '\u2198\ufe0f',
        'arrow_right': '\u27a1\ufe0f',
        'arrow_right_hook': '\u21aa\ufe0f',
        'arrow_up': '\u2b06\ufe0f',
        'arrow_up_down': '\u2195\ufe0f',
        'arrow_up_small': '\ud83d\udd3c',
        'arrow_upper_left': '\u2196\ufe0f',
        'arrow_upper_right': '\u2197\ufe0f',
        'arrows_clockwise': '\ud83d\udd03',
        'arrows_counterclockwise': '\ud83d\udd04',
        'art': '\ud83c\udfa8',
        'articulated_lorry': '\ud83d\ude9b',
        'artificial_satellite': '\ud83d\udef0',
        'astonished': '\ud83d\ude32',
        'athletic_shoe': '\ud83d\udc5f',
        'atm': '\ud83c\udfe7',
        'atom_symbol': '\u269b\ufe0f',
        'avocado': '\ud83e\udd51',
        'b': '\ud83c\udd71\ufe0f',
        'baby': '\ud83d\udc76',
        'baby_bottle': '\ud83c\udf7c',
        'baby_chick': '\ud83d\udc24',
        'baby_symbol': '\ud83d\udebc',
        'back': '\ud83d\udd19',
        'bacon': '\ud83e\udd53',
        'badminton': '\ud83c\udff8',
        'baggage_claim': '\ud83d\udec4',
        'baguette_bread': '\ud83e\udd56',
        'balance_scale': '\u2696\ufe0f',
        'balloon': '\ud83c\udf88',
        'ballot_box': '\ud83d\uddf3',
        'ballot_box_with_check': '\u2611\ufe0f',
        'bamboo': '\ud83c\udf8d',
        'banana': '\ud83c\udf4c',
        'bangbang': '\u203c\ufe0f',
        'bank': '\ud83c\udfe6',
        'bar_chart': '\ud83d\udcca',
        'barber': '\ud83d\udc88',
        'baseball': '\u26be\ufe0f',
        'basketball': '\ud83c\udfc0',
        'basketball_man': '\u26f9\ufe0f',
        'basketball_woman': '\u26f9\ufe0f&zwj;\u2640\ufe0f',
        'bat': '\ud83e\udd87',
        'bath': '\ud83d\udec0',
        'bathtub': '\ud83d\udec1',
        'battery': '\ud83d\udd0b',
        'beach_umbrella': '\ud83c\udfd6',
        'bear': '\ud83d\udc3b',
        'bed': '\ud83d\udecf',
        'bee': '\ud83d\udc1d',
        'beer': '\ud83c\udf7a',
        'beers': '\ud83c\udf7b',
        'beetle': '\ud83d\udc1e',
        'beginner': '\ud83d\udd30',
        'bell': '\ud83d\udd14',
        'bellhop_bell': '\ud83d\udece',
        'bento': '\ud83c\udf71',
        'biking_man': '\ud83d\udeb4',
        'bike': '\ud83d\udeb2',
        'biking_woman': '\ud83d\udeb4&zwj;\u2640\ufe0f',
        'bikini': '\ud83d\udc59',
        'biohazard': '\u2623\ufe0f',
        'bird': '\ud83d\udc26',
        'birthday': '\ud83c\udf82',
        'black_circle': '\u26ab\ufe0f',
        'black_flag': '\ud83c\udff4',
        'black_heart': '\ud83d\udda4',
        'black_joker': '\ud83c\udccf',
        'black_large_square': '\u2b1b\ufe0f',
        'black_medium_small_square': '\u25fe\ufe0f',
        'black_medium_square': '\u25fc\ufe0f',
        'black_nib': '\u2712\ufe0f',
        'black_small_square': '\u25aa\ufe0f',
        'black_square_button': '\ud83d\udd32',
        'blonde_man': '\ud83d\udc71',
        'blonde_woman': '\ud83d\udc71&zwj;\u2640\ufe0f',
        'blossom': '\ud83c\udf3c',
        'blowfish': '\ud83d\udc21',
        'blue_book': '\ud83d\udcd8',
        'blue_car': '\ud83d\ude99',
        'blue_heart': '\ud83d\udc99',
        'blush': '\ud83d\ude0a',
        'boar': '\ud83d\udc17',
        'boat': '\u26f5\ufe0f',
        'bomb': '\ud83d\udca3',
        'book': '\ud83d\udcd6',
        'bookmark': '\ud83d\udd16',
        'bookmark_tabs': '\ud83d\udcd1',
        'books': '\ud83d\udcda',
        'boom': '\ud83d\udca5',
        'boot': '\ud83d\udc62',
        'bouquet': '\ud83d\udc90',
        'bowing_man': '\ud83d\ude47',
        'bow_and_arrow': '\ud83c\udff9',
        'bowing_woman': '\ud83d\ude47&zwj;\u2640\ufe0f',
        'bowling': '\ud83c\udfb3',
        'boxing_glove': '\ud83e\udd4a',
        'boy': '\ud83d\udc66',
        'bread': '\ud83c\udf5e',
        'bride_with_veil': '\ud83d\udc70',
        'bridge_at_night': '\ud83c\udf09',
        'briefcase': '\ud83d\udcbc',
        'broken_heart': '\ud83d\udc94',
        'bug': '\ud83d\udc1b',
        'building_construction': '\ud83c\udfd7',
        'bulb': '\ud83d\udca1',
        'bullettrain_front': '\ud83d\ude85',
        'bullettrain_side': '\ud83d\ude84',
        'burrito': '\ud83c\udf2f',
        'bus': '\ud83d\ude8c',
        'business_suit_levitating': '\ud83d\udd74',
        'busstop': '\ud83d\ude8f',
        'bust_in_silhouette': '\ud83d\udc64',
        'busts_in_silhouette': '\ud83d\udc65',
        'butterfly': '\ud83e\udd8b',
        'cactus': '\ud83c\udf35',
        'cake': '\ud83c\udf70',
        'calendar': '\ud83d\udcc6',
        'call_me_hand': '\ud83e\udd19',
        'calling': '\ud83d\udcf2',
        'camel': '\ud83d\udc2b',
        'camera': '\ud83d\udcf7',
        'camera_flash': '\ud83d\udcf8',
        'camping': '\ud83c\udfd5',
        'cancer': '\u264b\ufe0f',
        'candle': '\ud83d\udd6f',
        'candy': '\ud83c\udf6c',
        'canoe': '\ud83d\udef6',
        'capital_abcd': '\ud83d\udd20',
        'capricorn': '\u2651\ufe0f',
        'car': '\ud83d\ude97',
        'card_file_box': '\ud83d\uddc3',
        'card_index': '\ud83d\udcc7',
        'card_index_dividers': '\ud83d\uddc2',
        'carousel_horse': '\ud83c\udfa0',
        'carrot': '\ud83e\udd55',
        'cat': '\ud83d\udc31',
        'cat2': '\ud83d\udc08',
        'cd': '\ud83d\udcbf',
        'chains': '\u26d3',
        'champagne': '\ud83c\udf7e',
        'chart': '\ud83d\udcb9',
        'chart_with_downwards_trend': '\ud83d\udcc9',
        'chart_with_upwards_trend': '\ud83d\udcc8',
        'checkered_flag': '\ud83c\udfc1',
        'cheese': '\ud83e\uddc0',
        'cherries': '\ud83c\udf52',
        'cherry_blossom': '\ud83c\udf38',
        'chestnut': '\ud83c\udf30',
        'chicken': '\ud83d\udc14',
        'children_crossing': '\ud83d\udeb8',
        'chipmunk': '\ud83d\udc3f',
        'chocolate_bar': '\ud83c\udf6b',
        'christmas_tree': '\ud83c\udf84',
        'church': '\u26ea\ufe0f',
        'cinema': '\ud83c\udfa6',
        'circus_tent': '\ud83c\udfaa',
        'city_sunrise': '\ud83c\udf07',
        'city_sunset': '\ud83c\udf06',
        'cityscape': '\ud83c\udfd9',
        'cl': '\ud83c\udd91',
        'clamp': '\ud83d\udddc',
        'clap': '\ud83d\udc4f',
        'clapper': '\ud83c\udfac',
        'classical_building': '\ud83c\udfdb',
        'clinking_glasses': '\ud83e\udd42',
        'clipboard': '\ud83d\udccb',
        'clock1': '\ud83d\udd50',
        'clock10': '\ud83d\udd59',
        'clock1030': '\ud83d\udd65',
        'clock11': '\ud83d\udd5a',
        'clock1130': '\ud83d\udd66',
        'clock12': '\ud83d\udd5b',
        'clock1230': '\ud83d\udd67',
        'clock130': '\ud83d\udd5c',
        'clock2': '\ud83d\udd51',
        'clock230': '\ud83d\udd5d',
        'clock3': '\ud83d\udd52',
        'clock330': '\ud83d\udd5e',
        'clock4': '\ud83d\udd53',
        'clock430': '\ud83d\udd5f',
        'clock5': '\ud83d\udd54',
        'clock530': '\ud83d\udd60',
        'clock6': '\ud83d\udd55',
        'clock630': '\ud83d\udd61',
        'clock7': '\ud83d\udd56',
        'clock730': '\ud83d\udd62',
        'clock8': '\ud83d\udd57',
        'clock830': '\ud83d\udd63',
        'clock9': '\ud83d\udd58',
        'clock930': '\ud83d\udd64',
        'closed_book': '\ud83d\udcd5',
        'closed_lock_with_key': '\ud83d\udd10',
        'closed_umbrella': '\ud83c\udf02',
        'cloud': '\u2601\ufe0f',
        'cloud_with_lightning': '\ud83c\udf29',
        'cloud_with_lightning_and_rain': '\u26c8',
        'cloud_with_rain': '\ud83c\udf27',
        'cloud_with_snow': '\ud83c\udf28',
        'clown_face': '\ud83e\udd21',
        'clubs': '\u2663\ufe0f',
        'cocktail': '\ud83c\udf78',
        'coffee': '\u2615\ufe0f',
        'coffin': '\u26b0\ufe0f',
        'cold_sweat': '\ud83d\ude30',
        'comet': '\u2604\ufe0f',
        'computer': '\ud83d\udcbb',
        'computer_mouse': '\ud83d\uddb1',
        'confetti_ball': '\ud83c\udf8a',
        'confounded': '\ud83d\ude16',
        'confused': '\ud83d\ude15',
        'congratulations': '\u3297\ufe0f',
        'construction': '\ud83d\udea7',
        'construction_worker_man': '\ud83d\udc77',
        'construction_worker_woman': '\ud83d\udc77&zwj;\u2640\ufe0f',
        'control_knobs': '\ud83c\udf9b',
        'convenience_store': '\ud83c\udfea',
        'cookie': '\ud83c\udf6a',
        'cool': '\ud83c\udd92',
        'policeman': '\ud83d\udc6e',
        'copyright': '\u00a9\ufe0f',
        'corn': '\ud83c\udf3d',
        'couch_and_lamp': '\ud83d\udecb',
        'couple': '\ud83d\udc6b',
        'couple_with_heart_woman_man': '\ud83d\udc91',
        'couple_with_heart_man_man': '\ud83d\udc68&zwj;\u2764\ufe0f&zwj;\ud83d\udc68',
        'couple_with_heart_woman_woman': '\ud83d\udc69&zwj;\u2764\ufe0f&zwj;\ud83d\udc69',
        'couplekiss_man_man': '\ud83d\udc68&zwj;\u2764\ufe0f&zwj;\ud83d\udc8b&zwj;\ud83d\udc68',
        'couplekiss_man_woman': '\ud83d\udc8f',
        'couplekiss_woman_woman': '\ud83d\udc69&zwj;\u2764\ufe0f&zwj;\ud83d\udc8b&zwj;\ud83d\udc69',
        'cow': '\ud83d\udc2e',
        'cow2': '\ud83d\udc04',
        'cowboy_hat_face': '\ud83e\udd20',
        'crab': '\ud83e\udd80',
        'crayon': '\ud83d\udd8d',
        'credit_card': '\ud83d\udcb3',
        'crescent_moon': '\ud83c\udf19',
        'cricket': '\ud83c\udfcf',
        'crocodile': '\ud83d\udc0a',
        'croissant': '\ud83e\udd50',
        'crossed_fingers': '\ud83e\udd1e',
        'crossed_flags': '\ud83c\udf8c',
        'crossed_swords': '\u2694\ufe0f',
        'crown': '\ud83d\udc51',
        'cry': '\ud83d\ude22',
        'crying_cat_face': '\ud83d\ude3f',
        'crystal_ball': '\ud83d\udd2e',
        'cucumber': '\ud83e\udd52',
        'cupid': '\ud83d\udc98',
        'curly_loop': '\u27b0',
        'currency_exchange': '\ud83d\udcb1',
        'curry': '\ud83c\udf5b',
        'custard': '\ud83c\udf6e',
        'customs': '\ud83d\udec3',
        'cyclone': '\ud83c\udf00',
        'dagger': '\ud83d\udde1',
        'dancer': '\ud83d\udc83',
        'dancing_women': '\ud83d\udc6f',
        'dancing_men': '\ud83d\udc6f&zwj;\u2642\ufe0f',
        'dango': '\ud83c\udf61',
        'dark_sunglasses': '\ud83d\udd76',
        'dart': '\ud83c\udfaf',
        'dash': '\ud83d\udca8',
        'date': '\ud83d\udcc5',
        'deciduous_tree': '\ud83c\udf33',
        'deer': '\ud83e\udd8c',
        'department_store': '\ud83c\udfec',
        'derelict_house': '\ud83c\udfda',
        'desert': '\ud83c\udfdc',
        'desert_island': '\ud83c\udfdd',
        'desktop_computer': '\ud83d\udda5',
        'male_detective': '\ud83d\udd75\ufe0f',
        'diamond_shape_with_a_dot_inside': '\ud83d\udca0',
        'diamonds': '\u2666\ufe0f',
        'disappointed': '\ud83d\ude1e',
        'disappointed_relieved': '\ud83d\ude25',
        'dizzy': '\ud83d\udcab',
        'dizzy_face': '\ud83d\ude35',
        'do_not_litter': '\ud83d\udeaf',
        'dog': '\ud83d\udc36',
        'dog2': '\ud83d\udc15',
        'dollar': '\ud83d\udcb5',
        'dolls': '\ud83c\udf8e',
        'dolphin': '\ud83d\udc2c',
        'door': '\ud83d\udeaa',
        'doughnut': '\ud83c\udf69',
        'dove': '\ud83d\udd4a',
        'dragon': '\ud83d\udc09',
        'dragon_face': '\ud83d\udc32',
        'dress': '\ud83d\udc57',
        'dromedary_camel': '\ud83d\udc2a',
        'drooling_face': '\ud83e\udd24',
        'droplet': '\ud83d\udca7',
        'drum': '\ud83e\udd41',
        'duck': '\ud83e\udd86',
        'dvd': '\ud83d\udcc0',
        'e-mail': '\ud83d\udce7',
        'eagle': '\ud83e\udd85',
        'ear': '\ud83d\udc42',
        'ear_of_rice': '\ud83c\udf3e',
        'earth_africa': '\ud83c\udf0d',
        'earth_americas': '\ud83c\udf0e',
        'earth_asia': '\ud83c\udf0f',
        'egg': '\ud83e\udd5a',
        'eggplant': '\ud83c\udf46',
        'eight_pointed_black_star': '\u2734\ufe0f',
        'eight_spoked_asterisk': '\u2733\ufe0f',
        'electric_plug': '\ud83d\udd0c',
        'elephant': '\ud83d\udc18',
        'email': '\u2709\ufe0f',
        'end': '\ud83d\udd1a',
        'envelope_with_arrow': '\ud83d\udce9',
        'euro': '\ud83d\udcb6',
        'european_castle': '\ud83c\udff0',
        'european_post_office': '\ud83c\udfe4',
        'evergreen_tree': '\ud83c\udf32',
        'exclamation': '\u2757\ufe0f',
        'expressionless': '\ud83d\ude11',
        'eye': '\ud83d\udc41',
        'eye_speech_bubble': '\ud83d\udc41&zwj;\ud83d\udde8',
        'eyeglasses': '\ud83d\udc53',
        'eyes': '\ud83d\udc40',
        'face_with_head_bandage': '\ud83e\udd15',
        'face_with_thermometer': '\ud83e\udd12',
        'fist_oncoming': '\ud83d\udc4a',
        'factory': '\ud83c\udfed',
        'fallen_leaf': '\ud83c\udf42',
        'family_man_woman_boy': '\ud83d\udc6a',
        'family_man_boy': '\ud83d\udc68&zwj;\ud83d\udc66',
        'family_man_boy_boy': '\ud83d\udc68&zwj;\ud83d\udc66&zwj;\ud83d\udc66',
        'family_man_girl': '\ud83d\udc68&zwj;\ud83d\udc67',
        'family_man_girl_boy': '\ud83d\udc68&zwj;\ud83d\udc67&zwj;\ud83d\udc66',
        'family_man_girl_girl': '\ud83d\udc68&zwj;\ud83d\udc67&zwj;\ud83d\udc67',
        'family_man_man_boy': '\ud83d\udc68&zwj;\ud83d\udc68&zwj;\ud83d\udc66',
        'family_man_man_boy_boy': '\ud83d\udc68&zwj;\ud83d\udc68&zwj;\ud83d\udc66&zwj;\ud83d\udc66',
        'family_man_man_girl': '\ud83d\udc68&zwj;\ud83d\udc68&zwj;\ud83d\udc67',
        'family_man_man_girl_boy': '\ud83d\udc68&zwj;\ud83d\udc68&zwj;\ud83d\udc67&zwj;\ud83d\udc66',
        'family_man_man_girl_girl': '\ud83d\udc68&zwj;\ud83d\udc68&zwj;\ud83d\udc67&zwj;\ud83d\udc67',
        'family_man_woman_boy_boy': '\ud83d\udc68&zwj;\ud83d\udc69&zwj;\ud83d\udc66&zwj;\ud83d\udc66',
        'family_man_woman_girl': '\ud83d\udc68&zwj;\ud83d\udc69&zwj;\ud83d\udc67',
        'family_man_woman_girl_boy': '\ud83d\udc68&zwj;\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc66',
        'family_man_woman_girl_girl': '\ud83d\udc68&zwj;\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc67',
        'family_woman_boy': '\ud83d\udc69&zwj;\ud83d\udc66',
        'family_woman_boy_boy': '\ud83d\udc69&zwj;\ud83d\udc66&zwj;\ud83d\udc66',
        'family_woman_girl': '\ud83d\udc69&zwj;\ud83d\udc67',
        'family_woman_girl_boy': '\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc66',
        'family_woman_girl_girl': '\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc67',
        'family_woman_woman_boy': '\ud83d\udc69&zwj;\ud83d\udc69&zwj;\ud83d\udc66',
        'family_woman_woman_boy_boy': '\ud83d\udc69&zwj;\ud83d\udc69&zwj;\ud83d\udc66&zwj;\ud83d\udc66',
        'family_woman_woman_girl': '\ud83d\udc69&zwj;\ud83d\udc69&zwj;\ud83d\udc67',
        'family_woman_woman_girl_boy': '\ud83d\udc69&zwj;\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc66',
        'family_woman_woman_girl_girl': '\ud83d\udc69&zwj;\ud83d\udc69&zwj;\ud83d\udc67&zwj;\ud83d\udc67',
        'fast_forward': '\u23e9',
        'fax': '\ud83d\udce0',
        'fearful': '\ud83d\ude28',
        'feet': '\ud83d\udc3e',
        'female_detective': '\ud83d\udd75\ufe0f&zwj;\u2640\ufe0f',
        'ferris_wheel': '\ud83c\udfa1',
        'ferry': '\u26f4',
        'field_hockey': '\ud83c\udfd1',
        'file_cabinet': '\ud83d\uddc4',
        'file_folder': '\ud83d\udcc1',
        'film_projector': '\ud83d\udcfd',
        'film_strip': '\ud83c\udf9e',
        'fire': '\ud83d\udd25',
        'fire_engine': '\ud83d\ude92',
        'fireworks': '\ud83c\udf86',
        'first_quarter_moon': '\ud83c\udf13',
        'first_quarter_moon_with_face': '\ud83c\udf1b',
        'fish': '\ud83d\udc1f',
        'fish_cake': '\ud83c\udf65',
        'fishing_pole_and_fish': '\ud83c\udfa3',
        'fist_raised': '\u270a',
        'fist_left': '\ud83e\udd1b',
        'fist_right': '\ud83e\udd1c',
        'flags': '\ud83c\udf8f',
        'flashlight': '\ud83d\udd26',
        'fleur_de_lis': '\u269c\ufe0f',
        'flight_arrival': '\ud83d\udeec',
        'flight_departure': '\ud83d\udeeb',
        'floppy_disk': '\ud83d\udcbe',
        'flower_playing_cards': '\ud83c\udfb4',
        'flushed': '\ud83d\ude33',
        'fog': '\ud83c\udf2b',
        'foggy': '\ud83c\udf01',
        'football': '\ud83c\udfc8',
        'footprints': '\ud83d\udc63',
        'fork_and_knife': '\ud83c\udf74',
        'fountain': '\u26f2\ufe0f',
        'fountain_pen': '\ud83d\udd8b',
        'four_leaf_clover': '\ud83c\udf40',
        'fox_face': '\ud83e\udd8a',
        'framed_picture': '\ud83d\uddbc',
        'free': '\ud83c\udd93',
        'fried_egg': '\ud83c\udf73',
        'fried_shrimp': '\ud83c\udf64',
        'fries': '\ud83c\udf5f',
        'frog': '\ud83d\udc38',
        'frowning': '\ud83d\ude26',
        'frowning_face': '\u2639\ufe0f',
        'frowning_man': '\ud83d\ude4d&zwj;\u2642\ufe0f',
        'frowning_woman': '\ud83d\ude4d',
        'middle_finger': '\ud83d\udd95',
        'fuelpump': '\u26fd\ufe0f',
        'full_moon': '\ud83c\udf15',
        'full_moon_with_face': '\ud83c\udf1d',
        'funeral_urn': '\u26b1\ufe0f',
        'game_die': '\ud83c\udfb2',
        'gear': '\u2699\ufe0f',
        'gem': '\ud83d\udc8e',
        'gemini': '\u264a\ufe0f',
        'ghost': '\ud83d\udc7b',
        'gift': '\ud83c\udf81',
        'gift_heart': '\ud83d\udc9d',
        'girl': '\ud83d\udc67',
        'globe_with_meridians': '\ud83c\udf10',
        'goal_net': '\ud83e\udd45',
        'goat': '\ud83d\udc10',
        'golf': '\u26f3\ufe0f',
        'golfing_man': '\ud83c\udfcc\ufe0f',
        'golfing_woman': '\ud83c\udfcc\ufe0f&zwj;\u2640\ufe0f',
        'gorilla': '\ud83e\udd8d',
        'grapes': '\ud83c\udf47',
        'green_apple': '\ud83c\udf4f',
        'green_book': '\ud83d\udcd7',
        'green_heart': '\ud83d\udc9a',
        'green_salad': '\ud83e\udd57',
        'grey_exclamation': '\u2755',
        'grey_question': '\u2754',
        'grimacing': '\ud83d\ude2c',
        'grin': '\ud83d\ude01',
        'grinning': '\ud83d\ude00',
        'guardsman': '\ud83d\udc82',
        'guardswoman': '\ud83d\udc82&zwj;\u2640\ufe0f',
        'guitar': '\ud83c\udfb8',
        'gun': '\ud83d\udd2b',
        'haircut_woman': '\ud83d\udc87',
        'haircut_man': '\ud83d\udc87&zwj;\u2642\ufe0f',
        'hamburger': '\ud83c\udf54',
        'hammer': '\ud83d\udd28',
        'hammer_and_pick': '\u2692',
        'hammer_and_wrench': '\ud83d\udee0',
        'hamster': '\ud83d\udc39',
        'hand': '\u270b',
        'handbag': '\ud83d\udc5c',
        'handshake': '\ud83e\udd1d',
        'hankey': '\ud83d\udca9',
        'hatched_chick': '\ud83d\udc25',
        'hatching_chick': '\ud83d\udc23',
        'headphones': '\ud83c\udfa7',
        'hear_no_evil': '\ud83d\ude49',
        'heart': '\u2764\ufe0f',
        'heart_decoration': '\ud83d\udc9f',
        'heart_eyes': '\ud83d\ude0d',
        'heart_eyes_cat': '\ud83d\ude3b',
        'heartbeat': '\ud83d\udc93',
        'heartpulse': '\ud83d\udc97',
        'hearts': '\u2665\ufe0f',
        'heavy_check_mark': '\u2714\ufe0f',
        'heavy_division_sign': '\u2797',
        'heavy_dollar_sign': '\ud83d\udcb2',
        'heavy_heart_exclamation': '\u2763\ufe0f',
        'heavy_minus_sign': '\u2796',
        'heavy_multiplication_x': '\u2716\ufe0f',
        'heavy_plus_sign': '\u2795',
        'helicopter': '\ud83d\ude81',
        'herb': '\ud83c\udf3f',
        'hibiscus': '\ud83c\udf3a',
        'high_brightness': '\ud83d\udd06',
        'high_heel': '\ud83d\udc60',
        'hocho': '\ud83d\udd2a',
        'hole': '\ud83d\udd73',
        'honey_pot': '\ud83c\udf6f',
        'horse': '\ud83d\udc34',
        'horse_racing': '\ud83c\udfc7',
        'hospital': '\ud83c\udfe5',
        'hot_pepper': '\ud83c\udf36',
        'hotdog': '\ud83c\udf2d',
        'hotel': '\ud83c\udfe8',
        'hotsprings': '\u2668\ufe0f',
        'hourglass': '\u231b\ufe0f',
        'hourglass_flowing_sand': '\u23f3',
        'house': '\ud83c\udfe0',
        'house_with_garden': '\ud83c\udfe1',
        'houses': '\ud83c\udfd8',
        'hugs': '\ud83e\udd17',
        'hushed': '\ud83d\ude2f',
        'ice_cream': '\ud83c\udf68',
        'ice_hockey': '\ud83c\udfd2',
        'ice_skate': '\u26f8',
        'icecream': '\ud83c\udf66',
        'id': '\ud83c\udd94',
        'ideograph_advantage': '\ud83c\ude50',
        'imp': '\ud83d\udc7f',
        'inbox_tray': '\ud83d\udce5',
        'incoming_envelope': '\ud83d\udce8',
        'tipping_hand_woman': '\ud83d\udc81',
        'information_source': '\u2139\ufe0f',
        'innocent': '\ud83d\ude07',
        'interrobang': '\u2049\ufe0f',
        'iphone': '\ud83d\udcf1',
        'izakaya_lantern': '\ud83c\udfee',
        'jack_o_lantern': '\ud83c\udf83',
        'japan': '\ud83d\uddfe',
        'japanese_castle': '\ud83c\udfef',
        'japanese_goblin': '\ud83d\udc7a',
        'japanese_ogre': '\ud83d\udc79',
        'jeans': '\ud83d\udc56',
        'joy': '\ud83d\ude02',
        'joy_cat': '\ud83d\ude39',
        'joystick': '\ud83d\udd79',
        'kaaba': '\ud83d\udd4b',
        'key': '\ud83d\udd11',
        'keyboard': '\u2328\ufe0f',
        'keycap_ten': '\ud83d\udd1f',
        'kick_scooter': '\ud83d\udef4',
        'kimono': '\ud83d\udc58',
        'kiss': '\ud83d\udc8b',
        'kissing': '\ud83d\ude17',
        'kissing_cat': '\ud83d\ude3d',
        'kissing_closed_eyes': '\ud83d\ude1a',
        'kissing_heart': '\ud83d\ude18',
        'kissing_smiling_eyes': '\ud83d\ude19',
        'kiwi_fruit': '\ud83e\udd5d',
        'koala': '\ud83d\udc28',
        'koko': '\ud83c\ude01',
        'label': '\ud83c\udff7',
        'large_blue_circle': '\ud83d\udd35',
        'large_blue_diamond': '\ud83d\udd37',
        'large_orange_diamond': '\ud83d\udd36',
        'last_quarter_moon': '\ud83c\udf17',
        'last_quarter_moon_with_face': '\ud83c\udf1c',
        'latin_cross': '\u271d\ufe0f',
        'laughing': '\ud83d\ude06',
        'leaves': '\ud83c\udf43',
        'ledger': '\ud83d\udcd2',
        'left_luggage': '\ud83d\udec5',
        'left_right_arrow': '\u2194\ufe0f',
        'leftwards_arrow_with_hook': '\u21a9\ufe0f',
        'lemon': '\ud83c\udf4b',
        'leo': '\u264c\ufe0f',
        'leopard': '\ud83d\udc06',
        'level_slider': '\ud83c\udf9a',
        'libra': '\u264e\ufe0f',
        'light_rail': '\ud83d\ude88',
        'link': '\ud83d\udd17',
        'lion': '\ud83e\udd81',
        'lips': '\ud83d\udc44',
        'lipstick': '\ud83d\udc84',
        'lizard': '\ud83e\udd8e',
        'lock': '\ud83d\udd12',
        'lock_with_ink_pen': '\ud83d\udd0f',
        'lollipop': '\ud83c\udf6d',
        'loop': '\u27bf',
        'loud_sound': '\ud83d\udd0a',
        'loudspeaker': '\ud83d\udce2',
        'love_hotel': '\ud83c\udfe9',
        'love_letter': '\ud83d\udc8c',
        'low_brightness': '\ud83d\udd05',
        'lying_face': '\ud83e\udd25',
        'm': '\u24c2\ufe0f',
        'mag': '\ud83d\udd0d',
        'mag_right': '\ud83d\udd0e',
        'mahjong': '\ud83c\udc04\ufe0f',
        'mailbox': '\ud83d\udceb',
        'mailbox_closed': '\ud83d\udcea',
        'mailbox_with_mail': '\ud83d\udcec',
        'mailbox_with_no_mail': '\ud83d\udced',
        'man': '\ud83d\udc68',
        'man_artist': '\ud83d\udc68&zwj;\ud83c\udfa8',
        'man_astronaut': '\ud83d\udc68&zwj;\ud83d\ude80',
        'man_cartwheeling': '\ud83e\udd38&zwj;\u2642\ufe0f',
        'man_cook': '\ud83d\udc68&zwj;\ud83c\udf73',
        'man_dancing': '\ud83d\udd7a',
        'man_facepalming': '\ud83e\udd26&zwj;\u2642\ufe0f',
        'man_factory_worker': '\ud83d\udc68&zwj;\ud83c\udfed',
        'man_farmer': '\ud83d\udc68&zwj;\ud83c\udf3e',
        'man_firefighter': '\ud83d\udc68&zwj;\ud83d\ude92',
        'man_health_worker': '\ud83d\udc68&zwj;\u2695\ufe0f',
        'man_in_tuxedo': '\ud83e\udd35',
        'man_judge': '\ud83d\udc68&zwj;\u2696\ufe0f',
        'man_juggling': '\ud83e\udd39&zwj;\u2642\ufe0f',
        'man_mechanic': '\ud83d\udc68&zwj;\ud83d\udd27',
        'man_office_worker': '\ud83d\udc68&zwj;\ud83d\udcbc',
        'man_pilot': '\ud83d\udc68&zwj;\u2708\ufe0f',
        'man_playing_handball': '\ud83e\udd3e&zwj;\u2642\ufe0f',
        'man_playing_water_polo': '\ud83e\udd3d&zwj;\u2642\ufe0f',
        'man_scientist': '\ud83d\udc68&zwj;\ud83d\udd2c',
        'man_shrugging': '\ud83e\udd37&zwj;\u2642\ufe0f',
        'man_singer': '\ud83d\udc68&zwj;\ud83c\udfa4',
        'man_student': '\ud83d\udc68&zwj;\ud83c\udf93',
        'man_teacher': '\ud83d\udc68&zwj;\ud83c\udfeb',
        'man_technologist': '\ud83d\udc68&zwj;\ud83d\udcbb',
        'man_with_gua_pi_mao': '\ud83d\udc72',
        'man_with_turban': '\ud83d\udc73',
        'tangerine': '\ud83c\udf4a',
        'mans_shoe': '\ud83d\udc5e',
        'mantelpiece_clock': '\ud83d\udd70',
        'maple_leaf': '\ud83c\udf41',
        'martial_arts_uniform': '\ud83e\udd4b',
        'mask': '\ud83d\ude37',
        'massage_woman': '\ud83d\udc86',
        'massage_man': '\ud83d\udc86&zwj;\u2642\ufe0f',
        'meat_on_bone': '\ud83c\udf56',
        'medal_military': '\ud83c\udf96',
        'medal_sports': '\ud83c\udfc5',
        'mega': '\ud83d\udce3',
        'melon': '\ud83c\udf48',
        'memo': '\ud83d\udcdd',
        'men_wrestling': '\ud83e\udd3c&zwj;\u2642\ufe0f',
        'menorah': '\ud83d\udd4e',
        'mens': '\ud83d\udeb9',
        'metal': '\ud83e\udd18',
        'metro': '\ud83d\ude87',
        'microphone': '\ud83c\udfa4',
        'microscope': '\ud83d\udd2c',
        'milk_glass': '\ud83e\udd5b',
        'milky_way': '\ud83c\udf0c',
        'minibus': '\ud83d\ude90',
        'minidisc': '\ud83d\udcbd',
        'mobile_phone_off': '\ud83d\udcf4',
        'money_mouth_face': '\ud83e\udd11',
        'money_with_wings': '\ud83d\udcb8',
        'moneybag': '\ud83d\udcb0',
        'monkey': '\ud83d\udc12',
        'monkey_face': '\ud83d\udc35',
        'monorail': '\ud83d\ude9d',
        'moon': '\ud83c\udf14',
        'mortar_board': '\ud83c\udf93',
        'mosque': '\ud83d\udd4c',
        'motor_boat': '\ud83d\udee5',
        'motor_scooter': '\ud83d\udef5',
        'motorcycle': '\ud83c\udfcd',
        'motorway': '\ud83d\udee3',
        'mount_fuji': '\ud83d\uddfb',
        'mountain': '\u26f0',
        'mountain_biking_man': '\ud83d\udeb5',
        'mountain_biking_woman': '\ud83d\udeb5&zwj;\u2640\ufe0f',
        'mountain_cableway': '\ud83d\udea0',
        'mountain_railway': '\ud83d\ude9e',
        'mountain_snow': '\ud83c\udfd4',
        'mouse': '\ud83d\udc2d',
        'mouse2': '\ud83d\udc01',
        'movie_camera': '\ud83c\udfa5',
        'moyai': '\ud83d\uddff',
        'mrs_claus': '\ud83e\udd36',
        'muscle': '\ud83d\udcaa',
        'mushroom': '\ud83c\udf44',
        'musical_keyboard': '\ud83c\udfb9',
        'musical_note': '\ud83c\udfb5',
        'musical_score': '\ud83c\udfbc',
        'mute': '\ud83d\udd07',
        'nail_care': '\ud83d\udc85',
        'name_badge': '\ud83d\udcdb',
        'national_park': '\ud83c\udfde',
        'nauseated_face': '\ud83e\udd22',
        'necktie': '\ud83d\udc54',
        'negative_squared_cross_mark': '\u274e',
        'nerd_face': '\ud83e\udd13',
        'neutral_face': '\ud83d\ude10',
        'new': '\ud83c\udd95',
        'new_moon': '\ud83c\udf11',
        'new_moon_with_face': '\ud83c\udf1a',
        'newspaper': '\ud83d\udcf0',
        'newspaper_roll': '\ud83d\uddde',
        'next_track_button': '\u23ed',
        'ng': '\ud83c\udd96',
        'no_good_man': '\ud83d\ude45&zwj;\u2642\ufe0f',
        'no_good_woman': '\ud83d\ude45',
        'night_with_stars': '\ud83c\udf03',
        'no_bell': '\ud83d\udd15',
        'no_bicycles': '\ud83d\udeb3',
        'no_entry': '\u26d4\ufe0f',
        'no_entry_sign': '\ud83d\udeab',
        'no_mobile_phones': '\ud83d\udcf5',
        'no_mouth': '\ud83d\ude36',
        'no_pedestrians': '\ud83d\udeb7',
        'no_smoking': '\ud83d\udead',
        'non-potable_water': '\ud83d\udeb1',
        'nose': '\ud83d\udc43',
        'notebook': '\ud83d\udcd3',
        'notebook_with_decorative_cover': '\ud83d\udcd4',
        'notes': '\ud83c\udfb6',
        'nut_and_bolt': '\ud83d\udd29',
        'o': '\u2b55\ufe0f',
        'o2': '\ud83c\udd7e\ufe0f',
        'ocean': '\ud83c\udf0a',
        'octopus': '\ud83d\udc19',
        'oden': '\ud83c\udf62',
        'office': '\ud83c\udfe2',
        'oil_drum': '\ud83d\udee2',
        'ok': '\ud83c\udd97',
        'ok_hand': '\ud83d\udc4c',
        'ok_man': '\ud83d\ude46&zwj;\u2642\ufe0f',
        'ok_woman': '\ud83d\ude46',
        'old_key': '\ud83d\udddd',
        'older_man': '\ud83d\udc74',
        'older_woman': '\ud83d\udc75',
        'om': '\ud83d\udd49',
        'on': '\ud83d\udd1b',
        'oncoming_automobile': '\ud83d\ude98',
        'oncoming_bus': '\ud83d\ude8d',
        'oncoming_police_car': '\ud83d\ude94',
        'oncoming_taxi': '\ud83d\ude96',
        'open_file_folder': '\ud83d\udcc2',
        'open_hands': '\ud83d\udc50',
        'open_mouth': '\ud83d\ude2e',
        'open_umbrella': '\u2602\ufe0f',
        'ophiuchus': '\u26ce',
        'orange_book': '\ud83d\udcd9',
        'orthodox_cross': '\u2626\ufe0f',
        'outbox_tray': '\ud83d\udce4',
        'owl': '\ud83e\udd89',
        'ox': '\ud83d\udc02',
        'package': '\ud83d\udce6',
        'page_facing_up': '\ud83d\udcc4',
        'page_with_curl': '\ud83d\udcc3',
        'pager': '\ud83d\udcdf',
        'paintbrush': '\ud83d\udd8c',
        'palm_tree': '\ud83c\udf34',
        'pancakes': '\ud83e\udd5e',
        'panda_face': '\ud83d\udc3c',
        'paperclip': '\ud83d\udcce',
        'paperclips': '\ud83d\udd87',
        'parasol_on_ground': '\u26f1',
        'parking': '\ud83c\udd7f\ufe0f',
        'part_alternation_mark': '\u303d\ufe0f',
        'partly_sunny': '\u26c5\ufe0f',
        'passenger_ship': '\ud83d\udef3',
        'passport_control': '\ud83d\udec2',
        'pause_button': '\u23f8',
        'peace_symbol': '\u262e\ufe0f',
        'peach': '\ud83c\udf51',
        'peanuts': '\ud83e\udd5c',
        'pear': '\ud83c\udf50',
        'pen': '\ud83d\udd8a',
        'pencil2': '\u270f\ufe0f',
        'penguin': '\ud83d\udc27',
        'pensive': '\ud83d\ude14',
        'performing_arts': '\ud83c\udfad',
        'persevere': '\ud83d\ude23',
        'person_fencing': '\ud83e\udd3a',
        'pouting_woman': '\ud83d\ude4e',
        'phone': '\u260e\ufe0f',
        'pick': '\u26cf',
        'pig': '\ud83d\udc37',
        'pig2': '\ud83d\udc16',
        'pig_nose': '\ud83d\udc3d',
        'pill': '\ud83d\udc8a',
        'pineapple': '\ud83c\udf4d',
        'ping_pong': '\ud83c\udfd3',
        'pisces': '\u2653\ufe0f',
        'pizza': '\ud83c\udf55',
        'place_of_worship': '\ud83d\uded0',
        'plate_with_cutlery': '\ud83c\udf7d',
        'play_or_pause_button': '\u23ef',
        'point_down': '\ud83d\udc47',
        'point_left': '\ud83d\udc48',
        'point_right': '\ud83d\udc49',
        'point_up': '\u261d\ufe0f',
        'point_up_2': '\ud83d\udc46',
        'police_car': '\ud83d\ude93',
        'policewoman': '\ud83d\udc6e&zwj;\u2640\ufe0f',
        'poodle': '\ud83d\udc29',
        'popcorn': '\ud83c\udf7f',
        'post_office': '\ud83c\udfe3',
        'postal_horn': '\ud83d\udcef',
        'postbox': '\ud83d\udcee',
        'potable_water': '\ud83d\udeb0',
        'potato': '\ud83e\udd54',
        'pouch': '\ud83d\udc5d',
        'poultry_leg': '\ud83c\udf57',
        'pound': '\ud83d\udcb7',
        'rage': '\ud83d\ude21',
        'pouting_cat': '\ud83d\ude3e',
        'pouting_man': '\ud83d\ude4e&zwj;\u2642\ufe0f',
        'pray': '\ud83d\ude4f',
        'prayer_beads': '\ud83d\udcff',
        'pregnant_woman': '\ud83e\udd30',
        'previous_track_button': '\u23ee',
        'prince': '\ud83e\udd34',
        'princess': '\ud83d\udc78',
        'printer': '\ud83d\udda8',
        'purple_heart': '\ud83d\udc9c',
        'purse': '\ud83d\udc5b',
        'pushpin': '\ud83d\udccc',
        'put_litter_in_its_place': '\ud83d\udeae',
        'question': '\u2753',
        'rabbit': '\ud83d\udc30',
        'rabbit2': '\ud83d\udc07',
        'racehorse': '\ud83d\udc0e',
        'racing_car': '\ud83c\udfce',
        'radio': '\ud83d\udcfb',
        'radio_button': '\ud83d\udd18',
        'radioactive': '\u2622\ufe0f',
        'railway_car': '\ud83d\ude83',
        'railway_track': '\ud83d\udee4',
        'rainbow': '\ud83c\udf08',
        'rainbow_flag': '\ud83c\udff3\ufe0f&zwj;\ud83c\udf08',
        'raised_back_of_hand': '\ud83e\udd1a',
        'raised_hand_with_fingers_splayed': '\ud83d\udd90',
        'raised_hands': '\ud83d\ude4c',
        'raising_hand_woman': '\ud83d\ude4b',
        'raising_hand_man': '\ud83d\ude4b&zwj;\u2642\ufe0f',
        'ram': '\ud83d\udc0f',
        'ramen': '\ud83c\udf5c',
        'rat': '\ud83d\udc00',
        'record_button': '\u23fa',
        'recycle': '\u267b\ufe0f',
        'red_circle': '\ud83d\udd34',
        'registered': '\u00ae\ufe0f',
        'relaxed': '\u263a\ufe0f',
        'relieved': '\ud83d\ude0c',
        'reminder_ribbon': '\ud83c\udf97',
        'repeat': '\ud83d\udd01',
        'repeat_one': '\ud83d\udd02',
        'rescue_worker_helmet': '\u26d1',
        'restroom': '\ud83d\udebb',
        'revolving_hearts': '\ud83d\udc9e',
        'rewind': '\u23ea',
        'rhinoceros': '\ud83e\udd8f',
        'ribbon': '\ud83c\udf80',
        'rice': '\ud83c\udf5a',
        'rice_ball': '\ud83c\udf59',
        'rice_cracker': '\ud83c\udf58',
        'rice_scene': '\ud83c\udf91',
        'right_anger_bubble': '\ud83d\uddef',
        'ring': '\ud83d\udc8d',
        'robot': '\ud83e\udd16',
        'rocket': '\ud83d\ude80',
        'rofl': '\ud83e\udd23',
        'roll_eyes': '\ud83d\ude44',
        'roller_coaster': '\ud83c\udfa2',
        'rooster': '\ud83d\udc13',
        'rose': '\ud83c\udf39',
        'rosette': '\ud83c\udff5',
        'rotating_light': '\ud83d\udea8',
        'round_pushpin': '\ud83d\udccd',
        'rowing_man': '\ud83d\udea3',
        'rowing_woman': '\ud83d\udea3&zwj;\u2640\ufe0f',
        'rugby_football': '\ud83c\udfc9',
        'running_man': '\ud83c\udfc3',
        'running_shirt_with_sash': '\ud83c\udfbd',
        'running_woman': '\ud83c\udfc3&zwj;\u2640\ufe0f',
        'sa': '\ud83c\ude02\ufe0f',
        'sagittarius': '\u2650\ufe0f',
        'sake': '\ud83c\udf76',
        'sandal': '\ud83d\udc61',
        'santa': '\ud83c\udf85',
        'satellite': '\ud83d\udce1',
        'saxophone': '\ud83c\udfb7',
        'school': '\ud83c\udfeb',
        'school_satchel': '\ud83c\udf92',
        'scissors': '\u2702\ufe0f',
        'scorpion': '\ud83e\udd82',
        'scorpius': '\u264f\ufe0f',
        'scream': '\ud83d\ude31',
        'scream_cat': '\ud83d\ude40',
        'scroll': '\ud83d\udcdc',
        'seat': '\ud83d\udcba',
        'secret': '\u3299\ufe0f',
        'see_no_evil': '\ud83d\ude48',
        'seedling': '\ud83c\udf31',
        'selfie': '\ud83e\udd33',
        'shallow_pan_of_food': '\ud83e\udd58',
        'shamrock': '\u2618\ufe0f',
        'shark': '\ud83e\udd88',
        'shaved_ice': '\ud83c\udf67',
        'sheep': '\ud83d\udc11',
        'shell': '\ud83d\udc1a',
        'shield': '\ud83d\udee1',
        'shinto_shrine': '\u26e9',
        'ship': '\ud83d\udea2',
        'shirt': '\ud83d\udc55',
        'shopping': '\ud83d\udecd',
        'shopping_cart': '\ud83d\uded2',
        'shower': '\ud83d\udebf',
        'shrimp': '\ud83e\udd90',
        'signal_strength': '\ud83d\udcf6',
        'six_pointed_star': '\ud83d\udd2f',
        'ski': '\ud83c\udfbf',
        'skier': '\u26f7',
        'skull': '\ud83d\udc80',
        'skull_and_crossbones': '\u2620\ufe0f',
        'sleeping': '\ud83d\ude34',
        'sleeping_bed': '\ud83d\udecc',
        'sleepy': '\ud83d\ude2a',
        'slightly_frowning_face': '\ud83d\ude41',
        'slightly_smiling_face': '\ud83d\ude42',
        'slot_machine': '\ud83c\udfb0',
        'small_airplane': '\ud83d\udee9',
        'small_blue_diamond': '\ud83d\udd39',
        'small_orange_diamond': '\ud83d\udd38',
        'small_red_triangle': '\ud83d\udd3a',
        'small_red_triangle_down': '\ud83d\udd3b',
        'smile': '\ud83d\ude04',
        'smile_cat': '\ud83d\ude38',
        'smiley': '\ud83d\ude03',
        'smiley_cat': '\ud83d\ude3a',
        'smiling_imp': '\ud83d\ude08',
        'smirk': '\ud83d\ude0f',
        'smirk_cat': '\ud83d\ude3c',
        'smoking': '\ud83d\udeac',
        'snail': '\ud83d\udc0c',
        'snake': '\ud83d\udc0d',
        'sneezing_face': '\ud83e\udd27',
        'snowboarder': '\ud83c\udfc2',
        'snowflake': '\u2744\ufe0f',
        'snowman': '\u26c4\ufe0f',
        'snowman_with_snow': '\u2603\ufe0f',
        'sob': '\ud83d\ude2d',
        'soccer': '\u26bd\ufe0f',
        'soon': '\ud83d\udd1c',
        'sos': '\ud83c\udd98',
        'sound': '\ud83d\udd09',
        'space_invader': '\ud83d\udc7e',
        'spades': '\u2660\ufe0f',
        'spaghetti': '\ud83c\udf5d',
        'sparkle': '\u2747\ufe0f',
        'sparkler': '\ud83c\udf87',
        'sparkles': '\u2728',
        'sparkling_heart': '\ud83d\udc96',
        'speak_no_evil': '\ud83d\ude4a',
        'speaker': '\ud83d\udd08',
        'speaking_head': '\ud83d\udde3',
        'speech_balloon': '\ud83d\udcac',
        'speedboat': '\ud83d\udea4',
        'spider': '\ud83d\udd77',
        'spider_web': '\ud83d\udd78',
        'spiral_calendar': '\ud83d\uddd3',
        'spiral_notepad': '\ud83d\uddd2',
        'spoon': '\ud83e\udd44',
        'squid': '\ud83e\udd91',
        'stadium': '\ud83c\udfdf',
        'star': '\u2b50\ufe0f',
        'star2': '\ud83c\udf1f',
        'star_and_crescent': '\u262a\ufe0f',
        'star_of_david': '\u2721\ufe0f',
        'stars': '\ud83c\udf20',
        'station': '\ud83d\ude89',
        'statue_of_liberty': '\ud83d\uddfd',
        'steam_locomotive': '\ud83d\ude82',
        'stew': '\ud83c\udf72',
        'stop_button': '\u23f9',
        'stop_sign': '\ud83d\uded1',
        'stopwatch': '\u23f1',
        'straight_ruler': '\ud83d\udccf',
        'strawberry': '\ud83c\udf53',
        'stuck_out_tongue': '\ud83d\ude1b',
        'stuck_out_tongue_closed_eyes': '\ud83d\ude1d',
        'stuck_out_tongue_winking_eye': '\ud83d\ude1c',
        'studio_microphone': '\ud83c\udf99',
        'stuffed_flatbread': '\ud83e\udd59',
        'sun_behind_large_cloud': '\ud83c\udf25',
        'sun_behind_rain_cloud': '\ud83c\udf26',
        'sun_behind_small_cloud': '\ud83c\udf24',
        'sun_with_face': '\ud83c\udf1e',
        'sunflower': '\ud83c\udf3b',
        'sunglasses': '\ud83d\ude0e',
        'sunny': '\u2600\ufe0f',
        'sunrise': '\ud83c\udf05',
        'sunrise_over_mountains': '\ud83c\udf04',
        'surfing_man': '\ud83c\udfc4',
        'surfing_woman': '\ud83c\udfc4&zwj;\u2640\ufe0f',
        'sushi': '\ud83c\udf63',
        'suspension_railway': '\ud83d\ude9f',
        'sweat': '\ud83d\ude13',
        'sweat_drops': '\ud83d\udca6',
        'sweat_smile': '\ud83d\ude05',
        'sweet_potato': '\ud83c\udf60',
        'swimming_man': '\ud83c\udfca',
        'swimming_woman': '\ud83c\udfca&zwj;\u2640\ufe0f',
        'symbols': '\ud83d\udd23',
        'synagogue': '\ud83d\udd4d',
        'syringe': '\ud83d\udc89',
        'taco': '\ud83c\udf2e',
        'tada': '\ud83c\udf89',
        'tanabata_tree': '\ud83c\udf8b',
        'taurus': '\u2649\ufe0f',
        'taxi': '\ud83d\ude95',
        'tea': '\ud83c\udf75',
        'telephone_receiver': '\ud83d\udcde',
        'telescope': '\ud83d\udd2d',
        'tennis': '\ud83c\udfbe',
        'tent': '\u26fa\ufe0f',
        'thermometer': '\ud83c\udf21',
        'thinking': '\ud83e\udd14',
        'thought_balloon': '\ud83d\udcad',
        'ticket': '\ud83c\udfab',
        'tickets': '\ud83c\udf9f',
        'tiger': '\ud83d\udc2f',
        'tiger2': '\ud83d\udc05',
        'timer_clock': '\u23f2',
        'tipping_hand_man': '\ud83d\udc81&zwj;\u2642\ufe0f',
        'tired_face': '\ud83d\ude2b',
        'tm': '\u2122\ufe0f',
        'toilet': '\ud83d\udebd',
        'tokyo_tower': '\ud83d\uddfc',
        'tomato': '\ud83c\udf45',
        'tongue': '\ud83d\udc45',
        'top': '\ud83d\udd1d',
        'tophat': '\ud83c\udfa9',
        'tornado': '\ud83c\udf2a',
        'trackball': '\ud83d\uddb2',
        'tractor': '\ud83d\ude9c',
        'traffic_light': '\ud83d\udea5',
        'train': '\ud83d\ude8b',
        'train2': '\ud83d\ude86',
        'tram': '\ud83d\ude8a',
        'triangular_flag_on_post': '\ud83d\udea9',
        'triangular_ruler': '\ud83d\udcd0',
        'trident': '\ud83d\udd31',
        'triumph': '\ud83d\ude24',
        'trolleybus': '\ud83d\ude8e',
        'trophy': '\ud83c\udfc6',
        'tropical_drink': '\ud83c\udf79',
        'tropical_fish': '\ud83d\udc20',
        'truck': '\ud83d\ude9a',
        'trumpet': '\ud83c\udfba',
        'tulip': '\ud83c\udf37',
        'tumbler_glass': '\ud83e\udd43',
        'turkey': '\ud83e\udd83',
        'turtle': '\ud83d\udc22',
        'tv': '\ud83d\udcfa',
        'twisted_rightwards_arrows': '\ud83d\udd00',
        'two_hearts': '\ud83d\udc95',
        'two_men_holding_hands': '\ud83d\udc6c',
        'two_women_holding_hands': '\ud83d\udc6d',
        'u5272': '\ud83c\ude39',
        'u5408': '\ud83c\ude34',
        'u55b6': '\ud83c\ude3a',
        'u6307': '\ud83c\ude2f\ufe0f',
        'u6708': '\ud83c\ude37\ufe0f',
        'u6709': '\ud83c\ude36',
        'u6e80': '\ud83c\ude35',
        'u7121': '\ud83c\ude1a\ufe0f',
        'u7533': '\ud83c\ude38',
        'u7981': '\ud83c\ude32',
        'u7a7a': '\ud83c\ude33',
        'umbrella': '\u2614\ufe0f',
        'unamused': '\ud83d\ude12',
        'underage': '\ud83d\udd1e',
        'unicorn': '\ud83e\udd84',
        'unlock': '\ud83d\udd13',
        'up': '\ud83c\udd99',
        'upside_down_face': '\ud83d\ude43',
        'v': '\u270c\ufe0f',
        'vertical_traffic_light': '\ud83d\udea6',
        'vhs': '\ud83d\udcfc',
        'vibration_mode': '\ud83d\udcf3',
        'video_camera': '\ud83d\udcf9',
        'video_game': '\ud83c\udfae',
        'violin': '\ud83c\udfbb',
        'virgo': '\u264d\ufe0f',
        'volcano': '\ud83c\udf0b',
        'volleyball': '\ud83c\udfd0',
        'vs': '\ud83c\udd9a',
        'vulcan_salute': '\ud83d\udd96',
        'walking_man': '\ud83d\udeb6',
        'walking_woman': '\ud83d\udeb6&zwj;\u2640\ufe0f',
        'waning_crescent_moon': '\ud83c\udf18',
        'waning_gibbous_moon': '\ud83c\udf16',
        'warning': '\u26a0\ufe0f',
        'wastebasket': '\ud83d\uddd1',
        'watch': '\u231a\ufe0f',
        'water_buffalo': '\ud83d\udc03',
        'watermelon': '\ud83c\udf49',
        'wave': '\ud83d\udc4b',
        'wavy_dash': '\u3030\ufe0f',
        'waxing_crescent_moon': '\ud83c\udf12',
        'wc': '\ud83d\udebe',
        'weary': '\ud83d\ude29',
        'wedding': '\ud83d\udc92',
        'weight_lifting_man': '\ud83c\udfcb\ufe0f',
        'weight_lifting_woman': '\ud83c\udfcb\ufe0f&zwj;\u2640\ufe0f',
        'whale': '\ud83d\udc33',
        'whale2': '\ud83d\udc0b',
        'wheel_of_dharma': '\u2638\ufe0f',
        'wheelchair': '\u267f\ufe0f',
        'white_check_mark': '\u2705',
        'white_circle': '\u26aa\ufe0f',
        'white_flag': '\ud83c\udff3\ufe0f',
        'white_flower': '\ud83d\udcae',
        'white_large_square': '\u2b1c\ufe0f',
        'white_medium_small_square': '\u25fd\ufe0f',
        'white_medium_square': '\u25fb\ufe0f',
        'white_small_square': '\u25ab\ufe0f',
        'white_square_button': '\ud83d\udd33',
        'wilted_flower': '\ud83e\udd40',
        'wind_chime': '\ud83c\udf90',
        'wind_face': '\ud83c\udf2c',
        'wine_glass': '\ud83c\udf77',
        'wink': '\ud83d\ude09',
        'wolf': '\ud83d\udc3a',
        'woman': '\ud83d\udc69',
        'woman_artist': '\ud83d\udc69&zwj;\ud83c\udfa8',
        'woman_astronaut': '\ud83d\udc69&zwj;\ud83d\ude80',
        'woman_cartwheeling': '\ud83e\udd38&zwj;\u2640\ufe0f',
        'woman_cook': '\ud83d\udc69&zwj;\ud83c\udf73',
        'woman_facepalming': '\ud83e\udd26&zwj;\u2640\ufe0f',
        'woman_factory_worker': '\ud83d\udc69&zwj;\ud83c\udfed',
        'woman_farmer': '\ud83d\udc69&zwj;\ud83c\udf3e',
        'woman_firefighter': '\ud83d\udc69&zwj;\ud83d\ude92',
        'woman_health_worker': '\ud83d\udc69&zwj;\u2695\ufe0f',
        'woman_judge': '\ud83d\udc69&zwj;\u2696\ufe0f',
        'woman_juggling': '\ud83e\udd39&zwj;\u2640\ufe0f',
        'woman_mechanic': '\ud83d\udc69&zwj;\ud83d\udd27',
        'woman_office_worker': '\ud83d\udc69&zwj;\ud83d\udcbc',
        'woman_pilot': '\ud83d\udc69&zwj;\u2708\ufe0f',
        'woman_playing_handball': '\ud83e\udd3e&zwj;\u2640\ufe0f',
        'woman_playing_water_polo': '\ud83e\udd3d&zwj;\u2640\ufe0f',
        'woman_scientist': '\ud83d\udc69&zwj;\ud83d\udd2c',
        'woman_shrugging': '\ud83e\udd37&zwj;\u2640\ufe0f',
        'woman_singer': '\ud83d\udc69&zwj;\ud83c\udfa4',
        'woman_student': '\ud83d\udc69&zwj;\ud83c\udf93',
        'woman_teacher': '\ud83d\udc69&zwj;\ud83c\udfeb',
        'woman_technologist': '\ud83d\udc69&zwj;\ud83d\udcbb',
        'woman_with_turban': '\ud83d\udc73&zwj;\u2640\ufe0f',
        'womans_clothes': '\ud83d\udc5a',
        'womans_hat': '\ud83d\udc52',
        'women_wrestling': '\ud83e\udd3c&zwj;\u2640\ufe0f',
        'womens': '\ud83d\udeba',
        'world_map': '\ud83d\uddfa',
        'worried': '\ud83d\ude1f',
        'wrench': '\ud83d\udd27',
        'writing_hand': '\u270d\ufe0f',
        'x': '\u274c',
        'yellow_heart': '\ud83d\udc9b',
        'yen': '\ud83d\udcb4',
        'yin_yang': '\u262f\ufe0f',
        'yum': '\ud83d\ude0b',
        'zap': '\u26a1\ufe0f',
        'zipper_mouth_face': '\ud83e\udd10',
        'zzz': '\ud83d\udca4',
        /* special emojis :P */
        'octocat': '<img alt=":octocat:" height="20" width="20" align="absmiddle" src="https://assets-cdn.github.com/images/icons/emoji/octocat.png">',
        'showdown': '<span style="font-family: \'Anonymous Pro\', monospace; text-decoration: underline; text-decoration-style: dashed; text-decoration-color: #3e8b8a;text-underline-position: under;">S</span>'
      };

      /**
       * Created by Estevao on 31-05-2015.
       */

      /**
       * Showdown Converter class
       * @class
       * @param {object} [converterOptions]
       * @returns {Converter}
       */
      showdown.Converter = function (converterOptions) {

        var
          /**
           * Options used by this converter
           * @private
           * @type {{}}
           */
          options = {},
          /**
           * Language extensions used by this converter
           * @private
           * @type {Array}
           */
          langExtensions = [],
          /**
           * Output modifiers extensions used by this converter
           * @private
           * @type {Array}
           */
          outputModifiers = [],
          /**
           * Event listeners
           * @private
           * @type {{}}
           */
          listeners = {},
          /**
           * The flavor set in this converter
           */
          setConvFlavor = setFlavor,
          /**
           * Metadata of the document
           * @type {{parsed: {}, raw: string, format: string}}
           */
          metadata = {
            parsed: {},
            raw: '',
            format: ''
          };
        _constructor();

        /**
         * Converter constructor
         * @private
         */
        function _constructor() {
          converterOptions = converterOptions || {};
          for (var gOpt in globalOptions) {
            if (globalOptions.hasOwnProperty(gOpt)) {
              options[gOpt] = globalOptions[gOpt];
            }
          }

          // Merge options
          if (typeof converterOptions === 'object') {
            for (var opt in converterOptions) {
              if (converterOptions.hasOwnProperty(opt)) {
                options[opt] = converterOptions[opt];
              }
            }
          } else {
            throw Error('Converter expects the passed parameter to be an object, but ' + typeof converterOptions + ' was passed instead.');
          }
          if (options.extensions) {
            showdown.helper.forEach(options.extensions, _parseExtension);
          }
        }

        /**
         * Parse extension
         * @param {*} ext
         * @param {string} [name='']
         * @private
         */
        function _parseExtension(ext, name) {
          name = name || null;
          // If it's a string, the extension was previously loaded
          if (showdown.helper.isString(ext)) {
            ext = showdown.helper.stdExtName(ext);
            name = ext;

            // LEGACY_SUPPORT CODE
            if (showdown.extensions[ext]) {
              console.warn('DEPRECATION WARNING: ' + ext + ' is an old extension that uses a deprecated loading method.' + 'Please inform the developer that the extension should be updated!');
              legacyExtensionLoading(showdown.extensions[ext], ext);
              return;
              // END LEGACY SUPPORT CODE
            } else if (!showdown.helper.isUndefined(extensions[ext])) {
              ext = extensions[ext];
            } else {
              throw Error('Extension "' + ext + '" could not be loaded. It was either not found or is not a valid extension.');
            }
          }
          if (typeof ext === 'function') {
            ext = ext();
          }
          if (!showdown.helper.isArray(ext)) {
            ext = [ext];
          }
          var validExt = validate(ext, name);
          if (!validExt.valid) {
            throw Error(validExt.error);
          }
          for (var i = 0; i < ext.length; ++i) {
            switch (ext[i].type) {
              case 'lang':
                langExtensions.push(ext[i]);
                break;
              case 'output':
                outputModifiers.push(ext[i]);
                break;
            }
            if (ext[i].hasOwnProperty('listeners')) {
              for (var ln in ext[i].listeners) {
                if (ext[i].listeners.hasOwnProperty(ln)) {
                  listen(ln, ext[i].listeners[ln]);
                }
              }
            }
          }
        }

        /**
         * LEGACY_SUPPORT
         * @param {*} ext
         * @param {string} name
         */
        function legacyExtensionLoading(ext, name) {
          if (typeof ext === 'function') {
            ext = ext(new showdown.Converter());
          }
          if (!showdown.helper.isArray(ext)) {
            ext = [ext];
          }
          var valid = validate(ext, name);
          if (!valid.valid) {
            throw Error(valid.error);
          }
          for (var i = 0; i < ext.length; ++i) {
            switch (ext[i].type) {
              case 'lang':
                langExtensions.push(ext[i]);
                break;
              case 'output':
                outputModifiers.push(ext[i]);
                break;
              default:
                // should never reach here
                throw Error('Extension loader error: Type unrecognized!!!');
            }
          }
        }

        /**
         * Listen to an event
         * @param {string} name
         * @param {function} callback
         */
        function listen(name, callback) {
          if (!showdown.helper.isString(name)) {
            throw Error('Invalid argument in converter.listen() method: name must be a string, but ' + typeof name + ' given');
          }
          if (typeof callback !== 'function') {
            throw Error('Invalid argument in converter.listen() method: callback must be a function, but ' + typeof callback + ' given');
          }
          if (!listeners.hasOwnProperty(name)) {
            listeners[name] = [];
          }
          listeners[name].push(callback);
        }
        function rTrimInputText(text) {
          var rsp = text.match(/^\s*/)[0].length,
            rgx = new RegExp('^\\s{0,' + rsp + '}', 'gm');
          return text.replace(rgx, '');
        }

        /**
         * Dispatch an event
         * @private
         * @param {string} evtName Event name
         * @param {string} text Text
         * @param {{}} options Converter Options
         * @param {{}} globals
         * @returns {string}
         */
        this._dispatch = function dispatch(evtName, text, options, globals) {
          if (listeners.hasOwnProperty(evtName)) {
            for (var ei = 0; ei < listeners[evtName].length; ++ei) {
              var nText = listeners[evtName][ei](evtName, text, this, options, globals);
              if (nText && typeof nText !== 'undefined') {
                text = nText;
              }
            }
          }
          return text;
        };

        /**
         * Listen to an event
         * @param {string} name
         * @param {function} callback
         * @returns {showdown.Converter}
         */
        this.listen = function (name, callback) {
          listen(name, callback);
          return this;
        };

        /**
         * Converts a markdown string into HTML
         * @param {string} text
         * @returns {*}
         */
        this.makeHtml = function (text) {
          //check if text is not falsy
          if (!text) {
            return text;
          }
          var globals = {
            gHtmlBlocks: [],
            gHtmlMdBlocks: [],
            gHtmlSpans: [],
            gUrls: {},
            gTitles: {},
            gDimensions: {},
            gListLevel: 0,
            hashLinkCounts: {},
            langExtensions: langExtensions,
            outputModifiers: outputModifiers,
            converter: this,
            ghCodeBlocks: [],
            metadata: {
              parsed: {},
              raw: '',
              format: ''
            }
          };

          // This lets us use ¨ trema as an escape char to avoid md5 hashes
          // The choice of character is arbitrary; anything that isn't
          // magic in Markdown will work.
          text = text.replace(/¨/g, '¨T');

          // Replace $ with ¨D
          // RegExp interprets $ as a special character
          // when it's in a replacement string
          text = text.replace(/\$/g, '¨D');

          // Standardize line endings
          text = text.replace(/\r\n/g, '\n'); // DOS to Unix
          text = text.replace(/\r/g, '\n'); // Mac to Unix

          // Stardardize line spaces
          text = text.replace(/\u00A0/g, '&nbsp;');
          if (options.smartIndentationFix) {
            text = rTrimInputText(text);
          }

          // Make sure text begins and ends with a couple of newlines:
          text = '\n\n' + text + '\n\n';

          // detab
          text = showdown.subParser('detab')(text, options, globals);

          /**
           * Strip any lines consisting only of spaces and tabs.
           * This makes subsequent regexs easier to write, because we can
           * match consecutive blank lines with /\n+/ instead of something
           * contorted like /[ \t]*\n+/
           */
          text = text.replace(/^[ \t]+$/mg, '');

          //run languageExtensions
          showdown.helper.forEach(langExtensions, function (ext) {
            text = showdown.subParser('runExtension')(ext, text, options, globals);
          });

          // run the sub parsers
          text = showdown.subParser('metadata')(text, options, globals);
          text = showdown.subParser('hashPreCodeTags')(text, options, globals);
          text = showdown.subParser('githubCodeBlocks')(text, options, globals);
          text = showdown.subParser('hashHTMLBlocks')(text, options, globals);
          text = showdown.subParser('hashCodeTags')(text, options, globals);
          text = showdown.subParser('stripLinkDefinitions')(text, options, globals);
          text = showdown.subParser('blockGamut')(text, options, globals);
          text = showdown.subParser('unhashHTMLSpans')(text, options, globals);
          text = showdown.subParser('unescapeSpecialChars')(text, options, globals);

          // attacklab: Restore dollar signs
          text = text.replace(/¨D/g, '$$');

          // attacklab: Restore tremas
          text = text.replace(/¨T/g, '¨');

          // render a complete html document instead of a partial if the option is enabled
          text = showdown.subParser('completeHTMLDocument')(text, options, globals);

          // Run output modifiers
          showdown.helper.forEach(outputModifiers, function (ext) {
            text = showdown.subParser('runExtension')(ext, text, options, globals);
          });

          // update metadata
          metadata = globals.metadata;
          return text;
        };

        /**
         * Converts an HTML string into a markdown string
         * @param src
         * @param [HTMLParser] A WHATWG DOM and HTML parser, such as JSDOM. If none is supplied, window.document will be used.
         * @returns {string}
         */
        this.makeMarkdown = this.makeMd = function (src, HTMLParser) {
          // replace \r\n with \n
          src = src.replace(/\r\n/g, '\n');
          src = src.replace(/\r/g, '\n'); // old macs

          // due to an edge case, we need to find this: > <
          // to prevent removing of non silent white spaces
          // ex: <em>this is</em> <strong>sparta</strong>
          src = src.replace(/>[ \t]+</, '>¨NBSP;<');
          if (!HTMLParser) {
            if (window && window.document) {
              HTMLParser = window.document;
            } else {
              throw new Error('HTMLParser is undefined. If in a webworker or nodejs environment, you need to provide a WHATWG DOM and HTML such as JSDOM');
            }
          }
          var doc = HTMLParser.createElement('div');
          doc.innerHTML = src;
          var globals = {
            preList: substitutePreCodeTags(doc)
          };

          // remove all newlines and collapse spaces
          clean(doc);

          // some stuff, like accidental reference links must now be escaped
          // TODO
          // doc.innerHTML = doc.innerHTML.replace(/\[[\S\t ]]/);

          var nodes = doc.childNodes,
            mdDoc = '';
          for (var i = 0; i < nodes.length; i++) {
            mdDoc += showdown.subParser('makeMarkdown.node')(nodes[i], globals);
          }
          function clean(node) {
            for (var n = 0; n < node.childNodes.length; ++n) {
              var child = node.childNodes[n];
              if (child.nodeType === 3) {
                if (!/\S/.test(child.nodeValue) && !/^[ ]+$/.test(child.nodeValue)) {
                  node.removeChild(child);
                  --n;
                } else {
                  child.nodeValue = child.nodeValue.split('\n').join(' ');
                  child.nodeValue = child.nodeValue.replace(/(\s)+/g, '$1');
                }
              } else if (child.nodeType === 1) {
                clean(child);
              }
            }
          }

          // find all pre tags and replace contents with placeholder
          // we need this so that we can remove all indentation from html
          // to ease up parsing
          function substitutePreCodeTags(doc) {
            var pres = doc.querySelectorAll('pre'),
              presPH = [];
            for (var i = 0; i < pres.length; ++i) {
              if (pres[i].childElementCount === 1 && pres[i].firstChild.tagName.toLowerCase() === 'code') {
                var content = pres[i].firstChild.innerHTML.trim(),
                  language = pres[i].firstChild.getAttribute('data-language') || '';

                // if data-language attribute is not defined, then we look for class language-*
                if (language === '') {
                  var classes = pres[i].firstChild.className.split(' ');
                  for (var c = 0; c < classes.length; ++c) {
                    var matches = classes[c].match(/^language-(.+)$/);
                    if (matches !== null) {
                      language = matches[1];
                      break;
                    }
                  }
                }

                // unescape html entities in content
                content = showdown.helper.unescapeHTMLEntities(content);
                presPH.push(content);
                pres[i].outerHTML = '<precode language="' + language + '" precodenum="' + i.toString() + '"></precode>';
              } else {
                presPH.push(pres[i].innerHTML);
                pres[i].innerHTML = '';
                pres[i].setAttribute('prenum', i.toString());
              }
            }
            return presPH;
          }
          return mdDoc;
        };

        /**
         * Set an option of this Converter instance
         * @param {string} key
         * @param {*} value
         */
        this.setOption = function (key, value) {
          options[key] = value;
        };

        /**
         * Get the option of this Converter instance
         * @param {string} key
         * @returns {*}
         */
        this.getOption = function (key) {
          return options[key];
        };

        /**
         * Get the options of this Converter instance
         * @returns {{}}
         */
        this.getOptions = function () {
          return options;
        };

        /**
         * Add extension to THIS converter
         * @param {{}} extension
         * @param {string} [name=null]
         */
        this.addExtension = function (extension, name) {
          name = name || null;
          _parseExtension(extension, name);
        };

        /**
         * Use a global registered extension with THIS converter
         * @param {string} extensionName Name of the previously registered extension
         */
        this.useExtension = function (extensionName) {
          _parseExtension(extensionName);
        };

        /**
         * Set the flavor THIS converter should use
         * @param {string} name
         */
        this.setFlavor = function (name) {
          if (!flavor.hasOwnProperty(name)) {
            throw Error(name + ' flavor was not found');
          }
          var preset = flavor[name];
          setConvFlavor = name;
          for (var option in preset) {
            if (preset.hasOwnProperty(option)) {
              options[option] = preset[option];
            }
          }
        };

        /**
         * Get the currently set flavor of this converter
         * @returns {string}
         */
        this.getFlavor = function () {
          return setConvFlavor;
        };

        /**
         * Remove an extension from THIS converter.
         * Note: This is a costly operation. It's better to initialize a new converter
         * and specify the extensions you wish to use
         * @param {Array} extension
         */
        this.removeExtension = function (extension) {
          if (!showdown.helper.isArray(extension)) {
            extension = [extension];
          }
          for (var a = 0; a < extension.length; ++a) {
            var ext = extension[a];
            for (var i = 0; i < langExtensions.length; ++i) {
              if (langExtensions[i] === ext) {
                langExtensions.splice(i, 1);
              }
            }
            for (var ii = 0; ii < outputModifiers.length; ++ii) {
              if (outputModifiers[ii] === ext) {
                outputModifiers.splice(ii, 1);
              }
            }
          }
        };

        /**
         * Get all extension of THIS converter
         * @returns {{language: Array, output: Array}}
         */
        this.getAllExtensions = function () {
          return {
            language: langExtensions,
            output: outputModifiers
          };
        };

        /**
         * Get the metadata of the previously parsed document
         * @param raw
         * @returns {string|{}}
         */
        this.getMetadata = function (raw) {
          if (raw) {
            return metadata.raw;
          } else {
            return metadata.parsed;
          }
        };

        /**
         * Get the metadata format of the previously parsed document
         * @returns {string}
         */
        this.getMetadataFormat = function () {
          return metadata.format;
        };

        /**
         * Private: set a single key, value metadata pair
         * @param {string} key
         * @param {string} value
         */
        this._setMetadataPair = function (key, value) {
          metadata.parsed[key] = value;
        };

        /**
         * Private: set metadata format
         * @param {string} format
         */
        this._setMetadataFormat = function (format) {
          metadata.format = format;
        };

        /**
         * Private: set metadata raw text
         * @param {string} raw
         */
        this._setMetadataRaw = function (raw) {
          metadata.raw = raw;
        };
      };

      /**
       * Turn Markdown link shortcuts into XHTML <a> tags.
       */
      showdown.subParser('anchors', function (text, options, globals) {

        text = globals.converter._dispatch('anchors.before', text, options, globals);
        var writeAnchorTag = function (wholeMatch, linkText, linkId, url, m5, m6, title) {
          if (showdown.helper.isUndefined(title)) {
            title = '';
          }
          linkId = linkId.toLowerCase();

          // Special case for explicit empty url
          if (wholeMatch.search(/\(<?\s*>? ?(['"].*['"])?\)$/m) > -1) {
            url = '';
          } else if (!url) {
            if (!linkId) {
              // lower-case and turn embedded newlines into spaces
              linkId = linkText.toLowerCase().replace(/ ?\n/g, ' ');
            }
            url = '#' + linkId;
            if (!showdown.helper.isUndefined(globals.gUrls[linkId])) {
              url = globals.gUrls[linkId];
              if (!showdown.helper.isUndefined(globals.gTitles[linkId])) {
                title = globals.gTitles[linkId];
              }
            } else {
              return wholeMatch;
            }
          }

          //url = showdown.helper.escapeCharacters(url, '*_', false); // replaced line to improve performance
          url = url.replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
          var result = '<a href="' + url + '"';
          if (title !== '' && title !== null) {
            title = title.replace(/"/g, '&quot;');
            //title = showdown.helper.escapeCharacters(title, '*_', false); // replaced line to improve performance
            title = title.replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
            result += ' title="' + title + '"';
          }

          // optionLinksInNewWindow only applies
          // to external links. Hash links (#) open in same page
          if (options.openLinksInNewWindow && !/^#/.test(url)) {
            // escaped _
            result += ' rel="noopener noreferrer" target="¨E95Eblank"';
          }
          result += '>' + linkText + '</a>';
          return result;
        };

        // First, handle reference-style links: [link text] [id]
        text = text.replace(/\[((?:\[[^\]]*]|[^\[\]])*)] ?(?:\n *)?\[(.*?)]()()()()/g, writeAnchorTag);

        // Next, inline-style links: [link text](url "optional title")
        // cases with crazy urls like ./image/cat1).png
        text = text.replace(/\[((?:\[[^\]]*]|[^\[\]])*)]()[ \t]*\([ \t]?<([^>]*)>(?:[ \t]*((["'])([^"]*?)\5))?[ \t]?\)/g, writeAnchorTag);

        // normal cases
        text = text.replace(/\[((?:\[[^\]]*]|[^\[\]])*)]()[ \t]*\([ \t]?<?([\S]+?(?:\([\S]*?\)[\S]*?)?)>?(?:[ \t]*((["'])([^"]*?)\5))?[ \t]?\)/g, writeAnchorTag);

        // handle reference-style shortcuts: [link text]
        // These must come last in case you've also got [link test][1]
        // or [link test](/foo)
        text = text.replace(/\[([^\[\]]+)]()()()()()/g, writeAnchorTag);

        // Lastly handle GithubMentions if option is enabled
        if (options.ghMentions) {
          text = text.replace(/(^|\s)(\\)?(@([a-z\d]+(?:[a-z\d.-]+?[a-z\d]+)*))/gmi, function (wm, st, escape, mentions, username) {
            if (escape === '\\') {
              return st + mentions;
            }

            //check if options.ghMentionsLink is a string
            if (!showdown.helper.isString(options.ghMentionsLink)) {
              throw new Error('ghMentionsLink option must be a string');
            }
            var lnk = options.ghMentionsLink.replace(/\{u}/g, username),
              target = '';
            if (options.openLinksInNewWindow) {
              target = ' rel="noopener noreferrer" target="¨E95Eblank"';
            }
            return st + '<a href="' + lnk + '"' + target + '>' + mentions + '</a>';
          });
        }
        text = globals.converter._dispatch('anchors.after', text, options, globals);
        return text;
      });

      // url allowed chars [a-z\d_.~:/?#[]@!$&'()*+,;=-]

      var simpleURLRegex = /([*~_]+|\b)(((https?|ftp|dict):\/\/|www\.)[^'">\s]+?\.[^'">\s]+?)()(\1)?(?=\s|$)(?!["<>])/gi,
        simpleURLRegex2 = /([*~_]+|\b)(((https?|ftp|dict):\/\/|www\.)[^'">\s]+\.[^'">\s]+?)([.!?,()\[\]])?(\1)?(?=\s|$)(?!["<>])/gi,
        delimUrlRegex = /()<(((https?|ftp|dict):\/\/|www\.)[^'">\s]+)()>()/gi,
        simpleMailRegex = /(^|\s)(?:mailto:)?([A-Za-z0-9!#$%&'*+-/=?^_`{|}~.]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]+)(?=$|\s)/gmi,
        delimMailRegex = /<()(?:mailto:)?([-.\w]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]+)>/gi,
        replaceLink = function (options) {

          return function (wm, leadingMagicChars, link, m2, m3, trailingPunctuation, trailingMagicChars) {
            link = link.replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
            var lnkTxt = link,
              append = '',
              target = '',
              lmc = leadingMagicChars || '',
              tmc = trailingMagicChars || '';
            if (/^www\./i.test(link)) {
              link = link.replace(/^www\./i, 'http://www.');
            }
            if (options.excludeTrailingPunctuationFromURLs && trailingPunctuation) {
              append = trailingPunctuation;
            }
            if (options.openLinksInNewWindow) {
              target = ' rel="noopener noreferrer" target="¨E95Eblank"';
            }
            return lmc + '<a href="' + link + '"' + target + '>' + lnkTxt + '</a>' + append + tmc;
          };
        },
        replaceMail = function (options, globals) {

          return function (wholeMatch, b, mail) {
            var href = 'mailto:';
            b = b || '';
            mail = showdown.subParser('unescapeSpecialChars')(mail, options, globals);
            if (options.encodeEmails) {
              href = showdown.helper.encodeEmailAddress(href + mail);
              mail = showdown.helper.encodeEmailAddress(mail);
            } else {
              href = href + mail;
            }
            return b + '<a href="' + href + '">' + mail + '</a>';
          };
        };
      showdown.subParser('autoLinks', function (text, options, globals) {

        text = globals.converter._dispatch('autoLinks.before', text, options, globals);
        text = text.replace(delimUrlRegex, replaceLink(options));
        text = text.replace(delimMailRegex, replaceMail(options, globals));
        text = globals.converter._dispatch('autoLinks.after', text, options, globals);
        return text;
      });
      showdown.subParser('simplifiedAutoLinks', function (text, options, globals) {

        if (!options.simplifiedAutoLink) {
          return text;
        }
        text = globals.converter._dispatch('simplifiedAutoLinks.before', text, options, globals);
        if (options.excludeTrailingPunctuationFromURLs) {
          text = text.replace(simpleURLRegex2, replaceLink(options));
        } else {
          text = text.replace(simpleURLRegex, replaceLink(options));
        }
        text = text.replace(simpleMailRegex, replaceMail(options, globals));
        text = globals.converter._dispatch('simplifiedAutoLinks.after', text, options, globals);
        return text;
      });

      /**
       * These are all the transformations that form block-level
       * tags like paragraphs, headers, and list items.
       */
      showdown.subParser('blockGamut', function (text, options, globals) {

        text = globals.converter._dispatch('blockGamut.before', text, options, globals);

        // we parse blockquotes first so that we can have headings and hrs
        // inside blockquotes
        text = showdown.subParser('blockQuotes')(text, options, globals);
        text = showdown.subParser('headers')(text, options, globals);

        // Do Horizontal Rules:
        text = showdown.subParser('horizontalRule')(text, options, globals);
        text = showdown.subParser('lists')(text, options, globals);
        text = showdown.subParser('codeBlocks')(text, options, globals);
        text = showdown.subParser('tables')(text, options, globals);

        // We already ran _HashHTMLBlocks() before, in Markdown(), but that
        // was to escape raw HTML in the original Markdown source. This time,
        // we're escaping the markup we've just created, so that we don't wrap
        // <p> tags around block-level tags.
        text = showdown.subParser('hashHTMLBlocks')(text, options, globals);
        text = showdown.subParser('paragraphs')(text, options, globals);
        text = globals.converter._dispatch('blockGamut.after', text, options, globals);
        return text;
      });
      showdown.subParser('blockQuotes', function (text, options, globals) {

        text = globals.converter._dispatch('blockQuotes.before', text, options, globals);

        // add a couple extra lines after the text and endtext mark
        text = text + '\n\n';
        var rgx = /(^ {0,3}>[ \t]?.+\n(.+\n)*\n*)+/gm;
        if (options.splitAdjacentBlockquotes) {
          rgx = /^ {0,3}>[\s\S]*?(?:\n\n)/gm;
        }
        text = text.replace(rgx, function (bq) {
          // attacklab: hack around Konqueror 3.5.4 bug:
          // "----------bug".replace(/^-/g,"") == "bug"
          bq = bq.replace(/^[ \t]*>[ \t]?/gm, ''); // trim one level of quoting

          // attacklab: clean up hack
          bq = bq.replace(/¨0/g, '');
          bq = bq.replace(/^[ \t]+$/gm, ''); // trim whitespace-only lines
          bq = showdown.subParser('githubCodeBlocks')(bq, options, globals);
          bq = showdown.subParser('blockGamut')(bq, options, globals); // recurse

          bq = bq.replace(/(^|\n)/g, '$1  ');
          // These leading spaces screw with <pre> content, so we need to fix that:
          bq = bq.replace(/(\s*<pre>[^\r]+?<\/pre>)/gm, function (wholeMatch, m1) {
            var pre = m1;
            // attacklab: hack around Konqueror 3.5.4 bug:
            pre = pre.replace(/^  /mg, '¨0');
            pre = pre.replace(/¨0/g, '');
            return pre;
          });
          return showdown.subParser('hashBlock')('<blockquote>\n' + bq + '\n</blockquote>', options, globals);
        });
        text = globals.converter._dispatch('blockQuotes.after', text, options, globals);
        return text;
      });

      /**
       * Process Markdown `<pre><code>` blocks.
       */
      showdown.subParser('codeBlocks', function (text, options, globals) {

        text = globals.converter._dispatch('codeBlocks.before', text, options, globals);

        // sentinel workarounds for lack of \A and \Z, safari\khtml bug
        text += '¨0';
        var pattern = /(?:\n\n|^)((?:(?:[ ]{4}|\t).*\n+)+)(\n*[ ]{0,3}[^ \t\n]|(?=¨0))/g;
        text = text.replace(pattern, function (wholeMatch, m1, m2) {
          var codeblock = m1,
            nextChar = m2,
            end = '\n';
          codeblock = showdown.subParser('outdent')(codeblock, options, globals);
          codeblock = showdown.subParser('encodeCode')(codeblock, options, globals);
          codeblock = showdown.subParser('detab')(codeblock, options, globals);
          codeblock = codeblock.replace(/^\n+/g, ''); // trim leading newlines
          codeblock = codeblock.replace(/\n+$/g, ''); // trim trailing newlines

          if (options.omitExtraWLInCodeBlocks) {
            end = '';
          }
          codeblock = '<pre><code>' + codeblock + end + '</code></pre>';
          return showdown.subParser('hashBlock')(codeblock, options, globals) + nextChar;
        });

        // strip sentinel
        text = text.replace(/¨0/, '');
        text = globals.converter._dispatch('codeBlocks.after', text, options, globals);
        return text;
      });

      /**
       *
       *   *  Backtick quotes are used for <code></code> spans.
       *
       *   *  You can use multiple backticks as the delimiters if you want to
       *     include literal backticks in the code span. So, this input:
       *
       *         Just type ``foo `bar` baz`` at the prompt.
       *
       *       Will translate to:
       *
       *         <p>Just type <code>foo `bar` baz</code> at the prompt.</p>
       *
       *    There's no arbitrary limit to the number of backticks you
       *    can use as delimters. If you need three consecutive backticks
       *    in your code, use four for delimiters, etc.
       *
       *  *  You can use spaces to get literal backticks at the edges:
       *
       *         ... type `` `bar` `` ...
       *
       *       Turns to:
       *
       *         ... type <code>`bar`</code> ...
       */
      showdown.subParser('codeSpans', function (text, options, globals) {

        text = globals.converter._dispatch('codeSpans.before', text, options, globals);
        if (typeof text === 'undefined') {
          text = '';
        }
        text = text.replace(/(^|[^\\])(`+)([^\r]*?[^`])\2(?!`)/gm, function (wholeMatch, m1, m2, m3) {
          var c = m3;
          c = c.replace(/^([ \t]*)/g, ''); // leading whitespace
          c = c.replace(/[ \t]*$/g, ''); // trailing whitespace
          c = showdown.subParser('encodeCode')(c, options, globals);
          c = m1 + '<code>' + c + '</code>';
          c = showdown.subParser('hashHTMLSpans')(c, options, globals);
          return c;
        });
        text = globals.converter._dispatch('codeSpans.after', text, options, globals);
        return text;
      });

      /**
       * Create a full HTML document from the processed markdown
       */
      showdown.subParser('completeHTMLDocument', function (text, options, globals) {

        if (!options.completeHTMLDocument) {
          return text;
        }
        text = globals.converter._dispatch('completeHTMLDocument.before', text, options, globals);
        var doctype = 'html',
          doctypeParsed = '<!DOCTYPE HTML>\n',
          title = '',
          charset = '<meta charset="utf-8">\n',
          lang = '',
          metadata = '';
        if (typeof globals.metadata.parsed.doctype !== 'undefined') {
          doctypeParsed = '<!DOCTYPE ' + globals.metadata.parsed.doctype + '>\n';
          doctype = globals.metadata.parsed.doctype.toString().toLowerCase();
          if (doctype === 'html' || doctype === 'html5') {
            charset = '<meta charset="utf-8">';
          }
        }
        for (var meta in globals.metadata.parsed) {
          if (globals.metadata.parsed.hasOwnProperty(meta)) {
            switch (meta.toLowerCase()) {
              case 'doctype':
                break;
              case 'title':
                title = '<title>' + globals.metadata.parsed.title + '</title>\n';
                break;
              case 'charset':
                if (doctype === 'html' || doctype === 'html5') {
                  charset = '<meta charset="' + globals.metadata.parsed.charset + '">\n';
                } else {
                  charset = '<meta name="charset" content="' + globals.metadata.parsed.charset + '">\n';
                }
                break;
              case 'language':
              case 'lang':
                lang = ' lang="' + globals.metadata.parsed[meta] + '"';
                metadata += '<meta name="' + meta + '" content="' + globals.metadata.parsed[meta] + '">\n';
                break;
              default:
                metadata += '<meta name="' + meta + '" content="' + globals.metadata.parsed[meta] + '">\n';
            }
          }
        }
        text = doctypeParsed + '<html' + lang + '>\n<head>\n' + title + charset + metadata + '</head>\n<body>\n' + text.trim() + '\n</body>\n</html>';
        text = globals.converter._dispatch('completeHTMLDocument.after', text, options, globals);
        return text;
      });

      /**
       * Convert all tabs to spaces
       */
      showdown.subParser('detab', function (text, options, globals) {

        text = globals.converter._dispatch('detab.before', text, options, globals);

        // expand first n-1 tabs
        text = text.replace(/\t(?=\t)/g, '    '); // g_tab_width

        // replace the nth with two sentinels
        text = text.replace(/\t/g, '¨A¨B');

        // use the sentinel to anchor our regex so it doesn't explode
        text = text.replace(/¨B(.+?)¨A/g, function (wholeMatch, m1) {
          var leadingText = m1,
            numSpaces = 4 - leadingText.length % 4; // g_tab_width

          // there *must* be a better way to do this:
          for (var i = 0; i < numSpaces; i++) {
            leadingText += ' ';
          }
          return leadingText;
        });

        // clean up sentinels
        text = text.replace(/¨A/g, '    '); // g_tab_width
        text = text.replace(/¨B/g, '');
        text = globals.converter._dispatch('detab.after', text, options, globals);
        return text;
      });
      showdown.subParser('ellipsis', function (text, options, globals) {

        if (!options.ellipsis) {
          return text;
        }
        text = globals.converter._dispatch('ellipsis.before', text, options, globals);
        text = text.replace(/\.\.\./g, '…');
        text = globals.converter._dispatch('ellipsis.after', text, options, globals);
        return text;
      });

      /**
       * Turn emoji codes into emojis
       *
       * List of supported emojis: https://github.com/showdownjs/showdown/wiki/Emojis
       */
      showdown.subParser('emoji', function (text, options, globals) {

        if (!options.emoji) {
          return text;
        }
        text = globals.converter._dispatch('emoji.before', text, options, globals);
        var emojiRgx = /:([\S]+?):/g;
        text = text.replace(emojiRgx, function (wm, emojiCode) {
          if (showdown.helper.emojis.hasOwnProperty(emojiCode)) {
            return showdown.helper.emojis[emojiCode];
          }
          return wm;
        });
        text = globals.converter._dispatch('emoji.after', text, options, globals);
        return text;
      });

      /**
       * Smart processing for ampersands and angle brackets that need to be encoded.
       */
      showdown.subParser('encodeAmpsAndAngles', function (text, options, globals) {

        text = globals.converter._dispatch('encodeAmpsAndAngles.before', text, options, globals);

        // Ampersand-encoding based entirely on Nat Irons's Amputator MT plugin:
        // http://bumppo.net/projects/amputator/
        text = text.replace(/&(?!#?[xX]?(?:[0-9a-fA-F]+|\w+);)/g, '&amp;');

        // Encode naked <'s
        text = text.replace(/<(?![a-z\/?$!])/gi, '&lt;');

        // Encode <
        text = text.replace(/</g, '&lt;');

        // Encode >
        text = text.replace(/>/g, '&gt;');
        text = globals.converter._dispatch('encodeAmpsAndAngles.after', text, options, globals);
        return text;
      });

      /**
       * Returns the string, with after processing the following backslash escape sequences.
       *
       * attacklab: The polite way to do this is with the new escapeCharacters() function:
       *
       *    text = escapeCharacters(text,"\\",true);
       *    text = escapeCharacters(text,"`*_{}[]()>#+-.!",true);
       *
       * ...but we're sidestepping its use of the (slow) RegExp constructor
       * as an optimization for Firefox.  This function gets called a LOT.
       */
      showdown.subParser('encodeBackslashEscapes', function (text, options, globals) {

        text = globals.converter._dispatch('encodeBackslashEscapes.before', text, options, globals);
        text = text.replace(/\\(\\)/g, showdown.helper.escapeCharactersCallback);
        text = text.replace(/\\([`*_{}\[\]()>#+.!~=|:-])/g, showdown.helper.escapeCharactersCallback);
        text = globals.converter._dispatch('encodeBackslashEscapes.after', text, options, globals);
        return text;
      });

      /**
       * Encode/escape certain characters inside Markdown code runs.
       * The point is that in code, these characters are literals,
       * and lose their special Markdown meanings.
       */
      showdown.subParser('encodeCode', function (text, options, globals) {

        text = globals.converter._dispatch('encodeCode.before', text, options, globals);

        // Encode all ampersands; HTML entities are not
        // entities within a Markdown code span.
        text = text.replace(/&/g, '&amp;')
        // Do the angle bracket song and dance:
        .replace(/</g, '&lt;').replace(/>/g, '&gt;')
        // Now, escape characters that are magic in Markdown:
        .replace(/([*_{}\[\]\\=~-])/g, showdown.helper.escapeCharactersCallback);
        text = globals.converter._dispatch('encodeCode.after', text, options, globals);
        return text;
      });

      /**
       * Within tags -- meaning between < and > -- encode [\ ` * _ ~ =] so they
       * don't conflict with their use in Markdown for code, italics and strong.
       */
      showdown.subParser('escapeSpecialCharsWithinTagAttributes', function (text, options, globals) {

        text = globals.converter._dispatch('escapeSpecialCharsWithinTagAttributes.before', text, options, globals);

        // Build a regex to find HTML tags.
        var tags = /<\/?[a-z\d_:-]+(?:[\s]+[\s\S]+?)?>/gi,
          comments = /<!(--(?:(?:[^>-]|-[^>])(?:[^-]|-[^-])*)--)>/gi;
        text = text.replace(tags, function (wholeMatch) {
          return wholeMatch.replace(/(.)<\/?code>(?=.)/g, '$1`').replace(/([\\`*_~=|])/g, showdown.helper.escapeCharactersCallback);
        });
        text = text.replace(comments, function (wholeMatch) {
          return wholeMatch.replace(/([\\`*_~=|])/g, showdown.helper.escapeCharactersCallback);
        });
        text = globals.converter._dispatch('escapeSpecialCharsWithinTagAttributes.after', text, options, globals);
        return text;
      });

      /**
       * Handle github codeblocks prior to running HashHTML so that
       * HTML contained within the codeblock gets escaped properly
       * Example:
       * ```ruby
       *     def hello_world(x)
       *       puts "Hello, #{x}"
       *     end
       * ```
       */
      showdown.subParser('githubCodeBlocks', function (text, options, globals) {

        // early exit if option is not enabled
        if (!options.ghCodeBlocks) {
          return text;
        }
        text = globals.converter._dispatch('githubCodeBlocks.before', text, options, globals);
        text += '¨0';
        text = text.replace(/(?:^|\n)(?: {0,3})(```+|~~~+)(?: *)([^\s`~]*)\n([\s\S]*?)\n(?: {0,3})\1/g, function (wholeMatch, delim, language, codeblock) {
          var end = options.omitExtraWLInCodeBlocks ? '' : '\n';

          // First parse the github code block
          codeblock = showdown.subParser('encodeCode')(codeblock, options, globals);
          codeblock = showdown.subParser('detab')(codeblock, options, globals);
          codeblock = codeblock.replace(/^\n+/g, ''); // trim leading newlines
          codeblock = codeblock.replace(/\n+$/g, ''); // trim trailing whitespace

          codeblock = '<pre><code' + (language ? ' class="' + language + ' language-' + language + '"' : '') + '>' + codeblock + end + '</code></pre>';
          codeblock = showdown.subParser('hashBlock')(codeblock, options, globals);

          // Since GHCodeblocks can be false positives, we need to
          // store the primitive text and the parsed text in a global var,
          // and then return a token
          return '\n\n¨G' + (globals.ghCodeBlocks.push({
            text: wholeMatch,
            codeblock: codeblock
          }) - 1) + 'G\n\n';
        });

        // attacklab: strip sentinel
        text = text.replace(/¨0/, '');
        return globals.converter._dispatch('githubCodeBlocks.after', text, options, globals);
      });
      showdown.subParser('hashBlock', function (text, options, globals) {

        text = globals.converter._dispatch('hashBlock.before', text, options, globals);
        text = text.replace(/(^\n+|\n+$)/g, '');
        text = '\n\n¨K' + (globals.gHtmlBlocks.push(text) - 1) + 'K\n\n';
        text = globals.converter._dispatch('hashBlock.after', text, options, globals);
        return text;
      });

      /**
       * Hash and escape <code> elements that should not be parsed as markdown
       */
      showdown.subParser('hashCodeTags', function (text, options, globals) {

        text = globals.converter._dispatch('hashCodeTags.before', text, options, globals);
        var repFunc = function (wholeMatch, match, left, right) {
          var codeblock = left + showdown.subParser('encodeCode')(match, options, globals) + right;
          return '¨C' + (globals.gHtmlSpans.push(codeblock) - 1) + 'C';
        };

        // Hash naked <code>
        text = showdown.helper.replaceRecursiveRegExp(text, repFunc, '<code\\b[^>]*>', '</code>', 'gim');
        text = globals.converter._dispatch('hashCodeTags.after', text, options, globals);
        return text;
      });
      showdown.subParser('hashElement', function (text, options, globals) {

        return function (wholeMatch, m1) {
          var blockText = m1;

          // Undo double lines
          blockText = blockText.replace(/\n\n/g, '\n');
          blockText = blockText.replace(/^\n/, '');

          // strip trailing blank lines
          blockText = blockText.replace(/\n+$/g, '');

          // Replace the element text with a marker ("¨KxK" where x is its key)
          blockText = '\n\n¨K' + (globals.gHtmlBlocks.push(blockText) - 1) + 'K\n\n';
          return blockText;
        };
      });
      showdown.subParser('hashHTMLBlocks', function (text, options, globals) {

        text = globals.converter._dispatch('hashHTMLBlocks.before', text, options, globals);
        var blockTags = ['pre', 'div', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'blockquote', 'table', 'dl', 'ol', 'ul', 'script', 'noscript', 'form', 'fieldset', 'iframe', 'math', 'style', 'section', 'header', 'footer', 'nav', 'article', 'aside', 'address', 'audio', 'canvas', 'figure', 'hgroup', 'output', 'video', 'p'],
          repFunc = function (wholeMatch, match, left, right) {
            var txt = wholeMatch;
            // check if this html element is marked as markdown
            // if so, it's contents should be parsed as markdown
            if (left.search(/\bmarkdown\b/) !== -1) {
              txt = left + globals.converter.makeHtml(match) + right;
            }
            return '\n\n¨K' + (globals.gHtmlBlocks.push(txt) - 1) + 'K\n\n';
          };
        if (options.backslashEscapesHTMLTags) {
          // encode backslash escaped HTML tags
          text = text.replace(/\\<(\/?[^>]+?)>/g, function (wm, inside) {
            return '&lt;' + inside + '&gt;';
          });
        }

        // hash HTML Blocks
        for (var i = 0; i < blockTags.length; ++i) {
          var opTagPos,
            rgx1 = new RegExp('^ {0,3}(<' + blockTags[i] + '\\b[^>]*>)', 'im'),
            patLeft = '<' + blockTags[i] + '\\b[^>]*>',
            patRight = '</' + blockTags[i] + '>';
          // 1. Look for the first position of the first opening HTML tag in the text
          while ((opTagPos = showdown.helper.regexIndexOf(text, rgx1)) !== -1) {
            // if the HTML tag is \ escaped, we need to escape it and break

            //2. Split the text in that position
            var subTexts = showdown.helper.splitAtIndex(text, opTagPos),
              //3. Match recursively
              newSubText1 = showdown.helper.replaceRecursiveRegExp(subTexts[1], repFunc, patLeft, patRight, 'im');

            // prevent an infinite loop
            if (newSubText1 === subTexts[1]) {
              break;
            }
            text = subTexts[0].concat(newSubText1);
          }
        }
        // HR SPECIAL CASE
        text = text.replace(/(\n {0,3}(<(hr)\b([^<>])*?\/?>)[ \t]*(?=\n{2,}))/g, showdown.subParser('hashElement')(text, options, globals));

        // Special case for standalone HTML comments
        text = showdown.helper.replaceRecursiveRegExp(text, function (txt) {
          return '\n\n¨K' + (globals.gHtmlBlocks.push(txt) - 1) + 'K\n\n';
        }, '^ {0,3}<!--', '-->', 'gm');

        // PHP and ASP-style processor instructions (<?...?> and <%...%>)
        text = text.replace(/(?:\n\n)( {0,3}(?:<([?%])[^\r]*?\2>)[ \t]*(?=\n{2,}))/g, showdown.subParser('hashElement')(text, options, globals));
        text = globals.converter._dispatch('hashHTMLBlocks.after', text, options, globals);
        return text;
      });

      /**
       * Hash span elements that should not be parsed as markdown
       */
      showdown.subParser('hashHTMLSpans', function (text, options, globals) {

        text = globals.converter._dispatch('hashHTMLSpans.before', text, options, globals);
        function hashHTMLSpan(html) {
          return '¨C' + (globals.gHtmlSpans.push(html) - 1) + 'C';
        }

        // Hash Self Closing tags
        text = text.replace(/<[^>]+?\/>/gi, function (wm) {
          return hashHTMLSpan(wm);
        });

        // Hash tags without properties
        text = text.replace(/<([^>]+?)>[\s\S]*?<\/\1>/g, function (wm) {
          return hashHTMLSpan(wm);
        });

        // Hash tags with properties
        text = text.replace(/<([^>]+?)\s[^>]+?>[\s\S]*?<\/\1>/g, function (wm) {
          return hashHTMLSpan(wm);
        });

        // Hash self closing tags without />
        text = text.replace(/<[^>]+?>/gi, function (wm) {
          return hashHTMLSpan(wm);
        });

        /*showdown.helper.matchRecursiveRegExp(text, '<code\\b[^>]*>', '</code>', 'gi');*/

        text = globals.converter._dispatch('hashHTMLSpans.after', text, options, globals);
        return text;
      });

      /**
       * Unhash HTML spans
       */
      showdown.subParser('unhashHTMLSpans', function (text, options, globals) {

        text = globals.converter._dispatch('unhashHTMLSpans.before', text, options, globals);
        for (var i = 0; i < globals.gHtmlSpans.length; ++i) {
          var repText = globals.gHtmlSpans[i],
            // limiter to prevent infinite loop (assume 10 as limit for recurse)
            limit = 0;
          while (/¨C(\d+)C/.test(repText)) {
            var num = RegExp.$1;
            repText = repText.replace('¨C' + num + 'C', globals.gHtmlSpans[num]);
            if (limit === 10) {
              console.error('maximum nesting of 10 spans reached!!!');
              break;
            }
            ++limit;
          }
          text = text.replace('¨C' + i + 'C', repText);
        }
        text = globals.converter._dispatch('unhashHTMLSpans.after', text, options, globals);
        return text;
      });

      /**
       * Hash and escape <pre><code> elements that should not be parsed as markdown
       */
      showdown.subParser('hashPreCodeTags', function (text, options, globals) {

        text = globals.converter._dispatch('hashPreCodeTags.before', text, options, globals);
        var repFunc = function (wholeMatch, match, left, right) {
          // encode html entities
          var codeblock = left + showdown.subParser('encodeCode')(match, options, globals) + right;
          return '\n\n¨G' + (globals.ghCodeBlocks.push({
            text: wholeMatch,
            codeblock: codeblock
          }) - 1) + 'G\n\n';
        };

        // Hash <pre><code>
        text = showdown.helper.replaceRecursiveRegExp(text, repFunc, '^ {0,3}<pre\\b[^>]*>\\s*<code\\b[^>]*>', '^ {0,3}</code>\\s*</pre>', 'gim');
        text = globals.converter._dispatch('hashPreCodeTags.after', text, options, globals);
        return text;
      });
      showdown.subParser('headers', function (text, options, globals) {

        text = globals.converter._dispatch('headers.before', text, options, globals);
        var headerLevelStart = isNaN(parseInt(options.headerLevelStart)) ? 1 : parseInt(options.headerLevelStart),
          // Set text-style headers:
          //	Header 1
          //	========
          //
          //	Header 2
          //	--------
          //
          setextRegexH1 = options.smoothLivePreview ? /^(.+)[ \t]*\n={2,}[ \t]*\n+/gm : /^(.+)[ \t]*\n=+[ \t]*\n+/gm,
          setextRegexH2 = options.smoothLivePreview ? /^(.+)[ \t]*\n-{2,}[ \t]*\n+/gm : /^(.+)[ \t]*\n-+[ \t]*\n+/gm;
        text = text.replace(setextRegexH1, function (wholeMatch, m1) {
          var spanGamut = showdown.subParser('spanGamut')(m1, options, globals),
            hID = options.noHeaderId ? '' : ' id="' + headerId(m1) + '"',
            hLevel = headerLevelStart,
            hashBlock = '<h' + hLevel + hID + '>' + spanGamut + '</h' + hLevel + '>';
          return showdown.subParser('hashBlock')(hashBlock, options, globals);
        });
        text = text.replace(setextRegexH2, function (matchFound, m1) {
          var spanGamut = showdown.subParser('spanGamut')(m1, options, globals),
            hID = options.noHeaderId ? '' : ' id="' + headerId(m1) + '"',
            hLevel = headerLevelStart + 1,
            hashBlock = '<h' + hLevel + hID + '>' + spanGamut + '</h' + hLevel + '>';
          return showdown.subParser('hashBlock')(hashBlock, options, globals);
        });

        // atx-style headers:
        //  # Header 1
        //  ## Header 2
        //  ## Header 2 with closing hashes ##
        //  ...
        //  ###### Header 6
        //
        var atxStyle = options.requireSpaceBeforeHeadingText ? /^(#{1,6})[ \t]+(.+?)[ \t]*#*\n+/gm : /^(#{1,6})[ \t]*(.+?)[ \t]*#*\n+/gm;
        text = text.replace(atxStyle, function (wholeMatch, m1, m2) {
          var hText = m2;
          if (options.customizedHeaderId) {
            hText = m2.replace(/\s?\{([^{]+?)}\s*$/, '');
          }
          var span = showdown.subParser('spanGamut')(hText, options, globals),
            hID = options.noHeaderId ? '' : ' id="' + headerId(m2) + '"',
            hLevel = headerLevelStart - 1 + m1.length,
            header = '<h' + hLevel + hID + '>' + span + '</h' + hLevel + '>';
          return showdown.subParser('hashBlock')(header, options, globals);
        });
        function headerId(m) {
          var title, prefix;

          // It is separate from other options to allow combining prefix and customized
          if (options.customizedHeaderId) {
            var match = m.match(/\{([^{]+?)}\s*$/);
            if (match && match[1]) {
              m = match[1];
            }
          }
          title = m;

          // Prefix id to prevent causing inadvertent pre-existing style matches.
          if (showdown.helper.isString(options.prefixHeaderId)) {
            prefix = options.prefixHeaderId;
          } else if (options.prefixHeaderId === true) {
            prefix = 'section-';
          } else {
            prefix = '';
          }
          if (!options.rawPrefixHeaderId) {
            title = prefix + title;
          }
          if (options.ghCompatibleHeaderId) {
            title = title.replace(/ /g, '-')
            // replace previously escaped chars (&, ¨ and $)
            .replace(/&amp;/g, '').replace(/¨T/g, '').replace(/¨D/g, '')
            // replace rest of the chars (&~$ are repeated as they might have been escaped)
            // borrowed from github's redcarpet (some they should produce similar results)
            .replace(/[&+$,\/:;=?@"#{}|^¨~\[\]`\\*)(%.!'<>]/g, '').toLowerCase();
          } else if (options.rawHeaderId) {
            title = title.replace(/ /g, '-')
            // replace previously escaped chars (&, ¨ and $)
            .replace(/&amp;/g, '&').replace(/¨T/g, '¨').replace(/¨D/g, '$')
            // replace " and '
            .replace(/["']/g, '-').toLowerCase();
          } else {
            title = title.replace(/[^\w]/g, '').toLowerCase();
          }
          if (options.rawPrefixHeaderId) {
            title = prefix + title;
          }
          if (globals.hashLinkCounts[title]) {
            title = title + '-' + globals.hashLinkCounts[title]++;
          } else {
            globals.hashLinkCounts[title] = 1;
          }
          return title;
        }
        text = globals.converter._dispatch('headers.after', text, options, globals);
        return text;
      });

      /**
       * Turn Markdown link shortcuts into XHTML <a> tags.
       */
      showdown.subParser('horizontalRule', function (text, options, globals) {

        text = globals.converter._dispatch('horizontalRule.before', text, options, globals);
        var key = showdown.subParser('hashBlock')('<hr />', options, globals);
        text = text.replace(/^ {0,2}( ?-){3,}[ \t]*$/gm, key);
        text = text.replace(/^ {0,2}( ?\*){3,}[ \t]*$/gm, key);
        text = text.replace(/^ {0,2}( ?_){3,}[ \t]*$/gm, key);
        text = globals.converter._dispatch('horizontalRule.after', text, options, globals);
        return text;
      });

      /**
       * Turn Markdown image shortcuts into <img> tags.
       */
      showdown.subParser('images', function (text, options, globals) {

        text = globals.converter._dispatch('images.before', text, options, globals);
        var inlineRegExp = /!\[([^\]]*?)][ \t]*()\([ \t]?<?([\S]+?(?:\([\S]*?\)[\S]*?)?)>?(?: =([*\d]+[A-Za-z%]{0,4})x([*\d]+[A-Za-z%]{0,4}))?[ \t]*(?:(["'])([^"]*?)\6)?[ \t]?\)/g,
          crazyRegExp = /!\[([^\]]*?)][ \t]*()\([ \t]?<([^>]*)>(?: =([*\d]+[A-Za-z%]{0,4})x([*\d]+[A-Za-z%]{0,4}))?[ \t]*(?:(?:(["'])([^"]*?)\6))?[ \t]?\)/g,
          base64RegExp = /!\[([^\]]*?)][ \t]*()\([ \t]?<?(data:.+?\/.+?;base64,[A-Za-z0-9+/=\n]+?)>?(?: =([*\d]+[A-Za-z%]{0,4})x([*\d]+[A-Za-z%]{0,4}))?[ \t]*(?:(["'])([^"]*?)\6)?[ \t]?\)/g,
          referenceRegExp = /!\[([^\]]*?)] ?(?:\n *)?\[([\s\S]*?)]()()()()()/g,
          refShortcutRegExp = /!\[([^\[\]]+)]()()()()()/g;
        function writeImageTagBase64(wholeMatch, altText, linkId, url, width, height, m5, title) {
          url = url.replace(/\s/g, '');
          return writeImageTag(wholeMatch, altText, linkId, url, width, height, m5, title);
        }
        function writeImageTag(wholeMatch, altText, linkId, url, width, height, m5, title) {
          var gUrls = globals.gUrls,
            gTitles = globals.gTitles,
            gDims = globals.gDimensions;
          linkId = linkId.toLowerCase();
          if (!title) {
            title = '';
          }
          // Special case for explicit empty url
          if (wholeMatch.search(/\(<?\s*>? ?(['"].*['"])?\)$/m) > -1) {
            url = '';
          } else if (url === '' || url === null) {
            if (linkId === '' || linkId === null) {
              // lower-case and turn embedded newlines into spaces
              linkId = altText.toLowerCase().replace(/ ?\n/g, ' ');
            }
            url = '#' + linkId;
            if (!showdown.helper.isUndefined(gUrls[linkId])) {
              url = gUrls[linkId];
              if (!showdown.helper.isUndefined(gTitles[linkId])) {
                title = gTitles[linkId];
              }
              if (!showdown.helper.isUndefined(gDims[linkId])) {
                width = gDims[linkId].width;
                height = gDims[linkId].height;
              }
            } else {
              return wholeMatch;
            }
          }
          altText = altText.replace(/"/g, '&quot;')
          //altText = showdown.helper.escapeCharacters(altText, '*_', false);
          .replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
          //url = showdown.helper.escapeCharacters(url, '*_', false);
          url = url.replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
          var result = '<img src="' + url + '" alt="' + altText + '"';
          if (title && showdown.helper.isString(title)) {
            title = title.replace(/"/g, '&quot;')
            //title = showdown.helper.escapeCharacters(title, '*_', false);
            .replace(showdown.helper.regexes.asteriskDashAndColon, showdown.helper.escapeCharactersCallback);
            result += ' title="' + title + '"';
          }
          if (width && height) {
            width = width === '*' ? 'auto' : width;
            height = height === '*' ? 'auto' : height;
            result += ' width="' + width + '"';
            result += ' height="' + height + '"';
          }
          result += ' />';
          return result;
        }

        // First, handle reference-style labeled images: ![alt text][id]
        text = text.replace(referenceRegExp, writeImageTag);

        // Next, handle inline images:  ![alt text](url =<width>x<height> "optional title")

        // base64 encoded images
        text = text.replace(base64RegExp, writeImageTagBase64);

        // cases with crazy urls like ./image/cat1).png
        text = text.replace(crazyRegExp, writeImageTag);

        // normal cases
        text = text.replace(inlineRegExp, writeImageTag);

        // handle reference-style shortcuts: ![img text]
        text = text.replace(refShortcutRegExp, writeImageTag);
        text = globals.converter._dispatch('images.after', text, options, globals);
        return text;
      });
      showdown.subParser('italicsAndBold', function (text, options, globals) {

        text = globals.converter._dispatch('italicsAndBold.before', text, options, globals);

        // it's faster to have 3 separate regexes for each case than have just one
        // because of backtracing, in some cases, it could lead to an exponential effect
        // called "catastrophic backtrace". Ominous!

        function parseInside(txt, left, right) {
          /*
          if (options.simplifiedAutoLink) {
            txt = showdown.subParser('simplifiedAutoLinks')(txt, options, globals);
          }
          */
          return left + txt + right;
        }

        // Parse underscores
        if (options.literalMidWordUnderscores) {
          text = text.replace(/\b___(\S[\s\S]*?)___\b/g, function (wm, txt) {
            return parseInside(txt, '<strong><em>', '</em></strong>');
          });
          text = text.replace(/\b__(\S[\s\S]*?)__\b/g, function (wm, txt) {
            return parseInside(txt, '<strong>', '</strong>');
          });
          text = text.replace(/\b_(\S[\s\S]*?)_\b/g, function (wm, txt) {
            return parseInside(txt, '<em>', '</em>');
          });
        } else {
          text = text.replace(/___(\S[\s\S]*?)___/g, function (wm, m) {
            return /\S$/.test(m) ? parseInside(m, '<strong><em>', '</em></strong>') : wm;
          });
          text = text.replace(/__(\S[\s\S]*?)__/g, function (wm, m) {
            return /\S$/.test(m) ? parseInside(m, '<strong>', '</strong>') : wm;
          });
          text = text.replace(/_([^\s_][\s\S]*?)_/g, function (wm, m) {
            // !/^_[^_]/.test(m) - test if it doesn't start with __ (since it seems redundant, we removed it)
            return /\S$/.test(m) ? parseInside(m, '<em>', '</em>') : wm;
          });
        }

        // Now parse asterisks
        if (options.literalMidWordAsterisks) {
          text = text.replace(/([^*]|^)\B\*\*\*(\S[\s\S]*?)\*\*\*\B(?!\*)/g, function (wm, lead, txt) {
            return parseInside(txt, lead + '<strong><em>', '</em></strong>');
          });
          text = text.replace(/([^*]|^)\B\*\*(\S[\s\S]*?)\*\*\B(?!\*)/g, function (wm, lead, txt) {
            return parseInside(txt, lead + '<strong>', '</strong>');
          });
          text = text.replace(/([^*]|^)\B\*(\S[\s\S]*?)\*\B(?!\*)/g, function (wm, lead, txt) {
            return parseInside(txt, lead + '<em>', '</em>');
          });
        } else {
          text = text.replace(/\*\*\*(\S[\s\S]*?)\*\*\*/g, function (wm, m) {
            return /\S$/.test(m) ? parseInside(m, '<strong><em>', '</em></strong>') : wm;
          });
          text = text.replace(/\*\*(\S[\s\S]*?)\*\*/g, function (wm, m) {
            return /\S$/.test(m) ? parseInside(m, '<strong>', '</strong>') : wm;
          });
          text = text.replace(/\*([^\s*][\s\S]*?)\*/g, function (wm, m) {
            // !/^\*[^*]/.test(m) - test if it doesn't start with ** (since it seems redundant, we removed it)
            return /\S$/.test(m) ? parseInside(m, '<em>', '</em>') : wm;
          });
        }
        text = globals.converter._dispatch('italicsAndBold.after', text, options, globals);
        return text;
      });

      /**
       * Form HTML ordered (numbered) and unordered (bulleted) lists.
       */
      showdown.subParser('lists', function (text, options, globals) {

        /**
         * Process the contents of a single ordered or unordered list, splitting it
         * into individual list items.
         * @param {string} listStr
         * @param {boolean} trimTrailing
         * @returns {string}
         */
        function processListItems(listStr, trimTrailing) {
          // The $g_list_level global keeps track of when we're inside a list.
          // Each time we enter a list, we increment it; when we leave a list,
          // we decrement. If it's zero, we're not in a list anymore.
          //
          // We do this because when we're not inside a list, we want to treat
          // something like this:
          //
          //    I recommend upgrading to version
          //    8. Oops, now this line is treated
          //    as a sub-list.
          //
          // As a single paragraph, despite the fact that the second line starts
          // with a digit-period-space sequence.
          //
          // Whereas when we're inside a list (or sub-list), that line will be
          // treated as the start of a sub-list. What a kludge, huh? This is
          // an aspect of Markdown's syntax that's hard to parse perfectly
          // without resorting to mind-reading. Perhaps the solution is to
          // change the syntax rules such that sub-lists must start with a
          // starting cardinal number; e.g. "1." or "a.".
          globals.gListLevel++;

          // trim trailing blank lines:
          listStr = listStr.replace(/\n{2,}$/, '\n');

          // attacklab: add sentinel to emulate \z
          listStr += '¨0';
          var rgx = /(\n)?(^ {0,3})([*+-]|\d+[.])[ \t]+((\[(x|X| )?])?[ \t]*[^\r]+?(\n{1,2}))(?=\n*(¨0| {0,3}([*+-]|\d+[.])[ \t]+))/gm,
            isParagraphed = /\n[ \t]*\n(?!¨0)/.test(listStr);

          // Since version 1.5, nesting sublists requires 4 spaces (or 1 tab) indentation,
          // which is a syntax breaking change
          // activating this option reverts to old behavior
          if (options.disableForced4SpacesIndentedSublists) {
            rgx = /(\n)?(^ {0,3})([*+-]|\d+[.])[ \t]+((\[(x|X| )?])?[ \t]*[^\r]+?(\n{1,2}))(?=\n*(¨0|\2([*+-]|\d+[.])[ \t]+))/gm;
          }
          listStr = listStr.replace(rgx, function (wholeMatch, m1, m2, m3, m4, taskbtn, checked) {
            checked = checked && checked.trim() !== '';
            var item = showdown.subParser('outdent')(m4, options, globals),
              bulletStyle = '';

            // Support for github tasklists
            if (taskbtn && options.tasklists) {
              bulletStyle = ' class="task-list-item" style="list-style-type: none;"';
              item = item.replace(/^[ \t]*\[(x|X| )?]/m, function () {
                var otp = '<input type="checkbox" disabled style="margin: 0px 0.35em 0.25em -1.6em; vertical-align: middle;"';
                if (checked) {
                  otp += ' checked';
                }
                otp += '>';
                return otp;
              });
            }

            // ISSUE #312
            // This input: - - - a
            // causes trouble to the parser, since it interprets it as:
            // <ul><li><li><li>a</li></li></li></ul>
            // instead of:
            // <ul><li>- - a</li></ul>
            // So, to prevent it, we will put a marker (¨A)in the beginning of the line
            // Kind of hackish/monkey patching, but seems more effective than overcomplicating the list parser
            item = item.replace(/^([-*+]|\d\.)[ \t]+[\S\n ]*/g, function (wm2) {
              return '¨A' + wm2;
            });

            // m1 - Leading line or
            // Has a double return (multi paragraph) or
            // Has sublist
            if (m1 || item.search(/\n{2,}/) > -1) {
              item = showdown.subParser('githubCodeBlocks')(item, options, globals);
              item = showdown.subParser('blockGamut')(item, options, globals);
            } else {
              // Recursion for sub-lists:
              item = showdown.subParser('lists')(item, options, globals);
              item = item.replace(/\n$/, ''); // chomp(item)
              item = showdown.subParser('hashHTMLBlocks')(item, options, globals);

              // Colapse double linebreaks
              item = item.replace(/\n\n+/g, '\n\n');
              if (isParagraphed) {
                item = showdown.subParser('paragraphs')(item, options, globals);
              } else {
                item = showdown.subParser('spanGamut')(item, options, globals);
              }
            }

            // now we need to remove the marker (¨A)
            item = item.replace('¨A', '');
            // we can finally wrap the line in list item tags
            item = '<li' + bulletStyle + '>' + item + '</li>\n';
            return item;
          });

          // attacklab: strip sentinel
          listStr = listStr.replace(/¨0/g, '');
          globals.gListLevel--;
          if (trimTrailing) {
            listStr = listStr.replace(/\s+$/, '');
          }
          return listStr;
        }
        function styleStartNumber(list, listType) {
          // check if ol and starts by a number different than 1
          if (listType === 'ol') {
            var res = list.match(/^ *(\d+)\./);
            if (res && res[1] !== '1') {
              return ' start="' + res[1] + '"';
            }
          }
          return '';
        }

        /**
         * Check and parse consecutive lists (better fix for issue #142)
         * @param {string} list
         * @param {string} listType
         * @param {boolean} trimTrailing
         * @returns {string}
         */
        function parseConsecutiveLists(list, listType, trimTrailing) {
          // check if we caught 2 or more consecutive lists by mistake
          // we use the counterRgx, meaning if listType is UL we look for OL and vice versa
          var olRgx = options.disableForced4SpacesIndentedSublists ? /^ ?\d+\.[ \t]/gm : /^ {0,3}\d+\.[ \t]/gm,
            ulRgx = options.disableForced4SpacesIndentedSublists ? /^ ?[*+-][ \t]/gm : /^ {0,3}[*+-][ \t]/gm,
            counterRxg = listType === 'ul' ? olRgx : ulRgx,
            result = '';
          if (list.search(counterRxg) !== -1) {
            (function parseCL(txt) {
              var pos = txt.search(counterRxg),
                style = styleStartNumber(list, listType);
              if (pos !== -1) {
                // slice
                result += '\n\n<' + listType + style + '>\n' + processListItems(txt.slice(0, pos), !!trimTrailing) + '</' + listType + '>\n';

                // invert counterType and listType
                listType = listType === 'ul' ? 'ol' : 'ul';
                counterRxg = listType === 'ul' ? olRgx : ulRgx;

                //recurse
                parseCL(txt.slice(pos));
              } else {
                result += '\n\n<' + listType + style + '>\n' + processListItems(txt, !!trimTrailing) + '</' + listType + '>\n';
              }
            })(list);
          } else {
            var style = styleStartNumber(list, listType);
            result = '\n\n<' + listType + style + '>\n' + processListItems(list, !!trimTrailing) + '</' + listType + '>\n';
          }
          return result;
        }

        /** Start of list parsing **/
        text = globals.converter._dispatch('lists.before', text, options, globals);
        // add sentinel to hack around khtml/safari bug:
        // http://bugs.webkit.org/show_bug.cgi?id=11231
        text += '¨0';
        if (globals.gListLevel) {
          text = text.replace(/^(( {0,3}([*+-]|\d+[.])[ \t]+)[^\r]+?(¨0|\n{2,}(?=\S)(?![ \t]*(?:[*+-]|\d+[.])[ \t]+)))/gm, function (wholeMatch, list, m2) {
            var listType = m2.search(/[*+-]/g) > -1 ? 'ul' : 'ol';
            return parseConsecutiveLists(list, listType, true);
          });
        } else {
          text = text.replace(/(\n\n|^\n?)(( {0,3}([*+-]|\d+[.])[ \t]+)[^\r]+?(¨0|\n{2,}(?=\S)(?![ \t]*(?:[*+-]|\d+[.])[ \t]+)))/gm, function (wholeMatch, m1, list, m3) {
            var listType = m3.search(/[*+-]/g) > -1 ? 'ul' : 'ol';
            return parseConsecutiveLists(list, listType, false);
          });
        }

        // strip sentinel
        text = text.replace(/¨0/, '');
        text = globals.converter._dispatch('lists.after', text, options, globals);
        return text;
      });

      /**
       * Parse metadata at the top of the document
       */
      showdown.subParser('metadata', function (text, options, globals) {

        if (!options.metadata) {
          return text;
        }
        text = globals.converter._dispatch('metadata.before', text, options, globals);
        function parseMetadataContents(content) {
          // raw is raw so it's not changed in any way
          globals.metadata.raw = content;

          // escape chars forbidden in html attributes
          // double quotes
          content = content
          // ampersand first
          .replace(/&/g, '&amp;')
          // double quotes
          .replace(/"/g, '&quot;');
          content = content.replace(/\n {4}/g, ' ');
          content.replace(/^([\S ]+): +([\s\S]+?)$/gm, function (wm, key, value) {
            globals.metadata.parsed[key] = value;
            return '';
          });
        }
        text = text.replace(/^\s*«««+(\S*?)\n([\s\S]+?)\n»»»+\n/, function (wholematch, format, content) {
          parseMetadataContents(content);
          return '¨M';
        });
        text = text.replace(/^\s*---+(\S*?)\n([\s\S]+?)\n---+\n/, function (wholematch, format, content) {
          if (format) {
            globals.metadata.format = format;
          }
          parseMetadataContents(content);
          return '¨M';
        });
        text = text.replace(/¨M/g, '');
        text = globals.converter._dispatch('metadata.after', text, options, globals);
        return text;
      });

      /**
       * Remove one level of line-leading tabs or spaces
       */
      showdown.subParser('outdent', function (text, options, globals) {

        text = globals.converter._dispatch('outdent.before', text, options, globals);

        // attacklab: hack around Konqueror 3.5.4 bug:
        // "----------bug".replace(/^-/g,"") == "bug"
        text = text.replace(/^(\t|[ ]{1,4})/gm, '¨0'); // attacklab: g_tab_width

        // attacklab: clean up hack
        text = text.replace(/¨0/g, '');
        text = globals.converter._dispatch('outdent.after', text, options, globals);
        return text;
      });

      /**
       *
       */
      showdown.subParser('paragraphs', function (text, options, globals) {

        text = globals.converter._dispatch('paragraphs.before', text, options, globals);
        // Strip leading and trailing lines:
        text = text.replace(/^\n+/g, '');
        text = text.replace(/\n+$/g, '');
        var grafs = text.split(/\n{2,}/g),
          grafsOut = [],
          end = grafs.length; // Wrap <p> tags

        for (var i = 0; i < end; i++) {
          var str = grafs[i];
          // if this is an HTML marker, copy it
          if (str.search(/¨(K|G)(\d+)\1/g) >= 0) {
            grafsOut.push(str);

            // test for presence of characters to prevent empty lines being parsed
            // as paragraphs (resulting in undesired extra empty paragraphs)
          } else if (str.search(/\S/) >= 0) {
            str = showdown.subParser('spanGamut')(str, options, globals);
            str = str.replace(/^([ \t]*)/g, '<p>');
            str += '</p>';
            grafsOut.push(str);
          }
        }

        /** Unhashify HTML blocks */
        end = grafsOut.length;
        for (i = 0; i < end; i++) {
          var blockText = '',
            grafsOutIt = grafsOut[i],
            codeFlag = false;
          // if this is a marker for an html block...
          // use RegExp.test instead of string.search because of QML bug
          while (/¨(K|G)(\d+)\1/.test(grafsOutIt)) {
            var delim = RegExp.$1,
              num = RegExp.$2;
            if (delim === 'K') {
              blockText = globals.gHtmlBlocks[num];
            } else {
              // we need to check if ghBlock is a false positive
              if (codeFlag) {
                // use encoded version of all text
                blockText = showdown.subParser('encodeCode')(globals.ghCodeBlocks[num].text, options, globals);
              } else {
                blockText = globals.ghCodeBlocks[num].codeblock;
              }
            }
            blockText = blockText.replace(/\$/g, '$$$$'); // Escape any dollar signs

            grafsOutIt = grafsOutIt.replace(/(\n\n)?¨(K|G)\d+\2(\n\n)?/, blockText);
            // Check if grafsOutIt is a pre->code
            if (/^<pre\b[^>]*>\s*<code\b[^>]*>/.test(grafsOutIt)) {
              codeFlag = true;
            }
          }
          grafsOut[i] = grafsOutIt;
        }
        text = grafsOut.join('\n');
        // Strip leading and trailing lines:
        text = text.replace(/^\n+/g, '');
        text = text.replace(/\n+$/g, '');
        return globals.converter._dispatch('paragraphs.after', text, options, globals);
      });

      /**
       * Run extension
       */
      showdown.subParser('runExtension', function (ext, text, options, globals) {

        if (ext.filter) {
          text = ext.filter(text, globals.converter, options);
        } else if (ext.regex) {
          // TODO remove this when old extension loading mechanism is deprecated
          var re = ext.regex;
          if (!(re instanceof RegExp)) {
            re = new RegExp(re, 'g');
          }
          text = text.replace(re, ext.replace);
        }
        return text;
      });

      /**
       * These are all the transformations that occur *within* block-level
       * tags like paragraphs, headers, and list items.
       */
      showdown.subParser('spanGamut', function (text, options, globals) {

        text = globals.converter._dispatch('spanGamut.before', text, options, globals);
        text = showdown.subParser('codeSpans')(text, options, globals);
        text = showdown.subParser('escapeSpecialCharsWithinTagAttributes')(text, options, globals);
        text = showdown.subParser('encodeBackslashEscapes')(text, options, globals);

        // Process anchor and image tags. Images must come first,
        // because ![foo][f] looks like an anchor.
        text = showdown.subParser('images')(text, options, globals);
        text = showdown.subParser('anchors')(text, options, globals);

        // Make links out of things like `<http://example.com/>`
        // Must come after anchors, because you can use < and >
        // delimiters in inline links like [this](<url>).
        text = showdown.subParser('autoLinks')(text, options, globals);
        text = showdown.subParser('simplifiedAutoLinks')(text, options, globals);
        text = showdown.subParser('emoji')(text, options, globals);
        text = showdown.subParser('underline')(text, options, globals);
        text = showdown.subParser('italicsAndBold')(text, options, globals);
        text = showdown.subParser('strikethrough')(text, options, globals);
        text = showdown.subParser('ellipsis')(text, options, globals);

        // we need to hash HTML tags inside spans
        text = showdown.subParser('hashHTMLSpans')(text, options, globals);

        // now we encode amps and angles
        text = showdown.subParser('encodeAmpsAndAngles')(text, options, globals);

        // Do hard breaks
        if (options.simpleLineBreaks) {
          // GFM style hard breaks
          // only add line breaks if the text does not contain a block (special case for lists)
          if (!/\n\n¨K/.test(text)) {
            text = text.replace(/\n+/g, '<br />\n');
          }
        } else {
          // Vanilla hard breaks
          text = text.replace(/  +\n/g, '<br />\n');
        }
        text = globals.converter._dispatch('spanGamut.after', text, options, globals);
        return text;
      });
      showdown.subParser('strikethrough', function (text, options, globals) {

        function parseInside(txt) {
          if (options.simplifiedAutoLink) {
            txt = showdown.subParser('simplifiedAutoLinks')(txt, options, globals);
          }
          return '<del>' + txt + '</del>';
        }
        if (options.strikethrough) {
          text = globals.converter._dispatch('strikethrough.before', text, options, globals);
          text = text.replace(/(?:~){2}([\s\S]+?)(?:~){2}/g, function (wm, txt) {
            return parseInside(txt);
          });
          text = globals.converter._dispatch('strikethrough.after', text, options, globals);
        }
        return text;
      });

      /**
       * Strips link definitions from text, stores the URLs and titles in
       * hash references.
       * Link defs are in the form: ^[id]: url "optional title"
       */
      showdown.subParser('stripLinkDefinitions', function (text, options, globals) {

        var regex = /^ {0,3}\[([^\]]+)]:[ \t]*\n?[ \t]*<?([^>\s]+)>?(?: =([*\d]+[A-Za-z%]{0,4})x([*\d]+[A-Za-z%]{0,4}))?[ \t]*\n?[ \t]*(?:(\n*)["|'(](.+?)["|')][ \t]*)?(?:\n+|(?=¨0))/gm,
          base64Regex = /^ {0,3}\[([^\]]+)]:[ \t]*\n?[ \t]*<?(data:.+?\/.+?;base64,[A-Za-z0-9+/=\n]+?)>?(?: =([*\d]+[A-Za-z%]{0,4})x([*\d]+[A-Za-z%]{0,4}))?[ \t]*\n?[ \t]*(?:(\n*)["|'(](.+?)["|')][ \t]*)?(?:\n\n|(?=¨0)|(?=\n\[))/gm;

        // attacklab: sentinel workarounds for lack of \A and \Z, safari\khtml bug
        text += '¨0';
        var replaceFunc = function (wholeMatch, linkId, url, width, height, blankLines, title) {
          // if there aren't two instances of linkId it must not be a reference link so back out
          linkId = linkId.toLowerCase();
          if (text.toLowerCase().split(linkId).length - 1 < 2) {
            return wholeMatch;
          }
          if (url.match(/^data:.+?\/.+?;base64,/)) {
            // remove newlines
            globals.gUrls[linkId] = url.replace(/\s/g, '');
          } else {
            globals.gUrls[linkId] = showdown.subParser('encodeAmpsAndAngles')(url, options, globals); // Link IDs are case-insensitive
          }

          if (blankLines) {
            // Oops, found blank lines, so it's not a title.
            // Put back the parenthetical statement we stole.
            return blankLines + title;
          } else {
            if (title) {
              globals.gTitles[linkId] = title.replace(/"|'/g, '&quot;');
            }
            if (options.parseImgDimensions && width && height) {
              globals.gDimensions[linkId] = {
                width: width,
                height: height
              };
            }
          }
          // Completely remove the definition from the text
          return '';
        };

        // first we try to find base64 link references
        text = text.replace(base64Regex, replaceFunc);
        text = text.replace(regex, replaceFunc);

        // attacklab: strip sentinel
        text = text.replace(/¨0/, '');
        return text;
      });
      showdown.subParser('tables', function (text, options, globals) {

        if (!options.tables) {
          return text;
        }
        var tableRgx = /^ {0,3}\|?.+\|.+\n {0,3}\|?[ \t]*:?[ \t]*(?:[-=]){2,}[ \t]*:?[ \t]*\|[ \t]*:?[ \t]*(?:[-=]){2,}[\s\S]+?(?:\n\n|¨0)/gm,
          //singeColTblRgx = /^ {0,3}\|.+\|\n {0,3}\|[ \t]*:?[ \t]*(?:[-=]){2,}[ \t]*:?[ \t]*\|[ \t]*\n(?: {0,3}\|.+\|\n)+(?:\n\n|¨0)/gm;
          singeColTblRgx = /^ {0,3}\|.+\|[ \t]*\n {0,3}\|[ \t]*:?[ \t]*(?:[-=]){2,}[ \t]*:?[ \t]*\|[ \t]*\n( {0,3}\|.+\|[ \t]*\n)*(?:\n|¨0)/gm;
        function parseStyles(sLine) {
          if (/^:[ \t]*--*$/.test(sLine)) {
            return ' style="text-align:left;"';
          } else if (/^--*[ \t]*:[ \t]*$/.test(sLine)) {
            return ' style="text-align:right;"';
          } else if (/^:[ \t]*--*[ \t]*:$/.test(sLine)) {
            return ' style="text-align:center;"';
          } else {
            return '';
          }
        }
        function parseHeaders(header, style) {
          var id = '';
          header = header.trim();
          // support both tablesHeaderId and tableHeaderId due to error in documentation so we don't break backwards compatibility
          if (options.tablesHeaderId || options.tableHeaderId) {
            id = ' id="' + header.replace(/ /g, '_').toLowerCase() + '"';
          }
          header = showdown.subParser('spanGamut')(header, options, globals);
          return '<th' + id + style + '>' + header + '</th>\n';
        }
        function parseCells(cell, style) {
          var subText = showdown.subParser('spanGamut')(cell, options, globals);
          return '<td' + style + '>' + subText + '</td>\n';
        }
        function buildTable(headers, cells) {
          var tb = '<table>\n<thead>\n<tr>\n',
            tblLgn = headers.length;
          for (var i = 0; i < tblLgn; ++i) {
            tb += headers[i];
          }
          tb += '</tr>\n</thead>\n<tbody>\n';
          for (i = 0; i < cells.length; ++i) {
            tb += '<tr>\n';
            for (var ii = 0; ii < tblLgn; ++ii) {
              tb += cells[i][ii];
            }
            tb += '</tr>\n';
          }
          tb += '</tbody>\n</table>\n';
          return tb;
        }
        function parseTable(rawTable) {
          var i,
            tableLines = rawTable.split('\n');
          for (i = 0; i < tableLines.length; ++i) {
            // strip wrong first and last column if wrapped tables are used
            if (/^ {0,3}\|/.test(tableLines[i])) {
              tableLines[i] = tableLines[i].replace(/^ {0,3}\|/, '');
            }
            if (/\|[ \t]*$/.test(tableLines[i])) {
              tableLines[i] = tableLines[i].replace(/\|[ \t]*$/, '');
            }
            // parse code spans first, but we only support one line code spans
            tableLines[i] = showdown.subParser('codeSpans')(tableLines[i], options, globals);
          }
          var rawHeaders = tableLines[0].split('|').map(function (s) {
              return s.trim();
            }),
            rawStyles = tableLines[1].split('|').map(function (s) {
              return s.trim();
            }),
            rawCells = [],
            headers = [],
            styles = [],
            cells = [];
          tableLines.shift();
          tableLines.shift();
          for (i = 0; i < tableLines.length; ++i) {
            if (tableLines[i].trim() === '') {
              continue;
            }
            rawCells.push(tableLines[i].split('|').map(function (s) {
              return s.trim();
            }));
          }
          if (rawHeaders.length < rawStyles.length) {
            return rawTable;
          }
          for (i = 0; i < rawStyles.length; ++i) {
            styles.push(parseStyles(rawStyles[i]));
          }
          for (i = 0; i < rawHeaders.length; ++i) {
            if (showdown.helper.isUndefined(styles[i])) {
              styles[i] = '';
            }
            headers.push(parseHeaders(rawHeaders[i], styles[i]));
          }
          for (i = 0; i < rawCells.length; ++i) {
            var row = [];
            for (var ii = 0; ii < headers.length; ++ii) {
              if (showdown.helper.isUndefined(rawCells[i][ii])) ;
              row.push(parseCells(rawCells[i][ii], styles[ii]));
            }
            cells.push(row);
          }
          return buildTable(headers, cells);
        }
        text = globals.converter._dispatch('tables.before', text, options, globals);

        // find escaped pipe characters
        text = text.replace(/\\(\|)/g, showdown.helper.escapeCharactersCallback);

        // parse multi column tables
        text = text.replace(tableRgx, parseTable);

        // parse one column tables
        text = text.replace(singeColTblRgx, parseTable);
        text = globals.converter._dispatch('tables.after', text, options, globals);
        return text;
      });
      showdown.subParser('underline', function (text, options, globals) {

        if (!options.underline) {
          return text;
        }
        text = globals.converter._dispatch('underline.before', text, options, globals);
        if (options.literalMidWordUnderscores) {
          text = text.replace(/\b___(\S[\s\S]*?)___\b/g, function (wm, txt) {
            return '<u>' + txt + '</u>';
          });
          text = text.replace(/\b__(\S[\s\S]*?)__\b/g, function (wm, txt) {
            return '<u>' + txt + '</u>';
          });
        } else {
          text = text.replace(/___(\S[\s\S]*?)___/g, function (wm, m) {
            return /\S$/.test(m) ? '<u>' + m + '</u>' : wm;
          });
          text = text.replace(/__(\S[\s\S]*?)__/g, function (wm, m) {
            return /\S$/.test(m) ? '<u>' + m + '</u>' : wm;
          });
        }

        // escape remaining underscores to prevent them being parsed by italic and bold
        text = text.replace(/(_)/g, showdown.helper.escapeCharactersCallback);
        text = globals.converter._dispatch('underline.after', text, options, globals);
        return text;
      });

      /**
       * Swap back in all the special characters we've hidden.
       */
      showdown.subParser('unescapeSpecialChars', function (text, options, globals) {

        text = globals.converter._dispatch('unescapeSpecialChars.before', text, options, globals);
        text = text.replace(/¨E(\d+)E/g, function (wholeMatch, m1) {
          var charCodeToReplace = parseInt(m1);
          return String.fromCharCode(charCodeToReplace);
        });
        text = globals.converter._dispatch('unescapeSpecialChars.after', text, options, globals);
        return text;
      });
      showdown.subParser('makeMarkdown.blockquote', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes()) {
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            var innerTxt = showdown.subParser('makeMarkdown.node')(children[i], globals);
            if (innerTxt === '') {
              continue;
            }
            txt += innerTxt;
          }
        }
        // cleanup
        txt = txt.trim();
        txt = '> ' + txt.split('\n').join('\n> ');
        return txt;
      });
      showdown.subParser('makeMarkdown.codeBlock', function (node, globals) {

        var lang = node.getAttribute('language'),
          num = node.getAttribute('precodenum');
        return '```' + lang + '\n' + globals.preList[num] + '\n```';
      });
      showdown.subParser('makeMarkdown.codeSpan', function (node) {

        return '`' + node.innerHTML + '`';
      });
      showdown.subParser('makeMarkdown.emphasis', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes()) {
          txt += '*';
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
          txt += '*';
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.header', function (node, globals, headerLevel) {

        var headerMark = new Array(headerLevel + 1).join('#'),
          txt = '';
        if (node.hasChildNodes()) {
          txt = headerMark + ' ';
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.hr', function () {

        return '---';
      });
      showdown.subParser('makeMarkdown.image', function (node) {

        var txt = '';
        if (node.hasAttribute('src')) {
          txt += '![' + node.getAttribute('alt') + '](';
          txt += '<' + node.getAttribute('src') + '>';
          if (node.hasAttribute('width') && node.hasAttribute('height')) {
            txt += ' =' + node.getAttribute('width') + 'x' + node.getAttribute('height');
          }
          if (node.hasAttribute('title')) {
            txt += ' "' + node.getAttribute('title') + '"';
          }
          txt += ')';
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.links', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes() && node.hasAttribute('href')) {
          var children = node.childNodes,
            childrenLength = children.length;
          txt = '[';
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
          txt += '](';
          txt += '<' + node.getAttribute('href') + '>';
          if (node.hasAttribute('title')) {
            txt += ' "' + node.getAttribute('title') + '"';
          }
          txt += ')';
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.list', function (node, globals, type) {

        var txt = '';
        if (!node.hasChildNodes()) {
          return '';
        }
        var listItems = node.childNodes,
          listItemsLenght = listItems.length,
          listNum = node.getAttribute('start') || 1;
        for (var i = 0; i < listItemsLenght; ++i) {
          if (typeof listItems[i].tagName === 'undefined' || listItems[i].tagName.toLowerCase() !== 'li') {
            continue;
          }

          // define the bullet to use in list
          var bullet = '';
          if (type === 'ol') {
            bullet = listNum.toString() + '. ';
          } else {
            bullet = '- ';
          }

          // parse list item
          txt += bullet + showdown.subParser('makeMarkdown.listItem')(listItems[i], globals);
          ++listNum;
        }

        // add comment at the end to prevent consecutive lists to be parsed as one
        txt += '\n<!-- -->\n';
        return txt.trim();
      });
      showdown.subParser('makeMarkdown.listItem', function (node, globals) {

        var listItemTxt = '';
        var children = node.childNodes,
          childrenLenght = children.length;
        for (var i = 0; i < childrenLenght; ++i) {
          listItemTxt += showdown.subParser('makeMarkdown.node')(children[i], globals);
        }
        // if it's only one liner, we need to add a newline at the end
        if (!/\n$/.test(listItemTxt)) {
          listItemTxt += '\n';
        } else {
          // it's multiparagraph, so we need to indent
          listItemTxt = listItemTxt.split('\n').join('\n    ').replace(/^ {4}$/gm, '').replace(/\n\n+/g, '\n\n');
        }
        return listItemTxt;
      });
      showdown.subParser('makeMarkdown.node', function (node, globals, spansOnly) {

        spansOnly = spansOnly || false;
        var txt = '';

        // edge case of text without wrapper paragraph
        if (node.nodeType === 3) {
          return showdown.subParser('makeMarkdown.txt')(node, globals);
        }

        // HTML comment
        if (node.nodeType === 8) {
          return '<!--' + node.data + '-->\n\n';
        }

        // process only node elements
        if (node.nodeType !== 1) {
          return '';
        }
        var tagName = node.tagName.toLowerCase();
        switch (tagName) {
          //
          // BLOCKS
          //
          case 'h1':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 1) + '\n\n';
            }
            break;
          case 'h2':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 2) + '\n\n';
            }
            break;
          case 'h3':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 3) + '\n\n';
            }
            break;
          case 'h4':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 4) + '\n\n';
            }
            break;
          case 'h5':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 5) + '\n\n';
            }
            break;
          case 'h6':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.header')(node, globals, 6) + '\n\n';
            }
            break;
          case 'p':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.paragraph')(node, globals) + '\n\n';
            }
            break;
          case 'blockquote':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.blockquote')(node, globals) + '\n\n';
            }
            break;
          case 'hr':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.hr')(node, globals) + '\n\n';
            }
            break;
          case 'ol':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.list')(node, globals, 'ol') + '\n\n';
            }
            break;
          case 'ul':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.list')(node, globals, 'ul') + '\n\n';
            }
            break;
          case 'precode':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.codeBlock')(node, globals) + '\n\n';
            }
            break;
          case 'pre':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.pre')(node, globals) + '\n\n';
            }
            break;
          case 'table':
            if (!spansOnly) {
              txt = showdown.subParser('makeMarkdown.table')(node, globals) + '\n\n';
            }
            break;

          //
          // SPANS
          //
          case 'code':
            txt = showdown.subParser('makeMarkdown.codeSpan')(node, globals);
            break;
          case 'em':
          case 'i':
            txt = showdown.subParser('makeMarkdown.emphasis')(node, globals);
            break;
          case 'strong':
          case 'b':
            txt = showdown.subParser('makeMarkdown.strong')(node, globals);
            break;
          case 'del':
            txt = showdown.subParser('makeMarkdown.strikethrough')(node, globals);
            break;
          case 'a':
            txt = showdown.subParser('makeMarkdown.links')(node, globals);
            break;
          case 'img':
            txt = showdown.subParser('makeMarkdown.image')(node, globals);
            break;
          default:
            txt = node.outerHTML + '\n\n';
        }

        // common normalization
        // TODO eventually

        return txt;
      });
      showdown.subParser('makeMarkdown.paragraph', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes()) {
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
        }

        // some text normalization
        txt = txt.trim();
        return txt;
      });
      showdown.subParser('makeMarkdown.pre', function (node, globals) {

        var num = node.getAttribute('prenum');
        return '<pre>' + globals.preList[num] + '</pre>';
      });
      showdown.subParser('makeMarkdown.strikethrough', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes()) {
          txt += '~~';
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
          txt += '~~';
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.strong', function (node, globals) {

        var txt = '';
        if (node.hasChildNodes()) {
          txt += '**';
          var children = node.childNodes,
            childrenLength = children.length;
          for (var i = 0; i < childrenLength; ++i) {
            txt += showdown.subParser('makeMarkdown.node')(children[i], globals);
          }
          txt += '**';
        }
        return txt;
      });
      showdown.subParser('makeMarkdown.table', function (node, globals) {

        var txt = '',
          tableArray = [[], []],
          headings = node.querySelectorAll('thead>tr>th'),
          rows = node.querySelectorAll('tbody>tr'),
          i,
          ii;
        for (i = 0; i < headings.length; ++i) {
          var headContent = showdown.subParser('makeMarkdown.tableCell')(headings[i], globals),
            allign = '---';
          if (headings[i].hasAttribute('style')) {
            var style = headings[i].getAttribute('style').toLowerCase().replace(/\s/g, '');
            switch (style) {
              case 'text-align:left;':
                allign = ':---';
                break;
              case 'text-align:right;':
                allign = '---:';
                break;
              case 'text-align:center;':
                allign = ':---:';
                break;
            }
          }
          tableArray[0][i] = headContent.trim();
          tableArray[1][i] = allign;
        }
        for (i = 0; i < rows.length; ++i) {
          var r = tableArray.push([]) - 1,
            cols = rows[i].getElementsByTagName('td');
          for (ii = 0; ii < headings.length; ++ii) {
            var cellContent = ' ';
            if (typeof cols[ii] !== 'undefined') {
              cellContent = showdown.subParser('makeMarkdown.tableCell')(cols[ii], globals);
            }
            tableArray[r].push(cellContent);
          }
        }
        var cellSpacesCount = 3;
        for (i = 0; i < tableArray.length; ++i) {
          for (ii = 0; ii < tableArray[i].length; ++ii) {
            var strLen = tableArray[i][ii].length;
            if (strLen > cellSpacesCount) {
              cellSpacesCount = strLen;
            }
          }
        }
        for (i = 0; i < tableArray.length; ++i) {
          for (ii = 0; ii < tableArray[i].length; ++ii) {
            if (i === 1) {
              if (tableArray[i][ii].slice(-1) === ':') {
                tableArray[i][ii] = showdown.helper.padEnd(tableArray[i][ii].slice(-1), cellSpacesCount - 1, '-') + ':';
              } else {
                tableArray[i][ii] = showdown.helper.padEnd(tableArray[i][ii], cellSpacesCount, '-');
              }
            } else {
              tableArray[i][ii] = showdown.helper.padEnd(tableArray[i][ii], cellSpacesCount);
            }
          }
          txt += '| ' + tableArray[i].join(' | ') + ' |\n';
        }
        return txt.trim();
      });
      showdown.subParser('makeMarkdown.tableCell', function (node, globals) {

        var txt = '';
        if (!node.hasChildNodes()) {
          return '';
        }
        var children = node.childNodes,
          childrenLength = children.length;
        for (var i = 0; i < childrenLength; ++i) {
          txt += showdown.subParser('makeMarkdown.node')(children[i], globals, true);
        }
        return txt.trim();
      });
      showdown.subParser('makeMarkdown.txt', function (node) {

        var txt = node.nodeValue;

        // multiple spaces are collapsed
        txt = txt.replace(/ +/g, ' ');

        // replace the custom ¨NBSP; with a space
        txt = txt.replace(/¨NBSP;/g, ' ');

        // ", <, > and & should replace escaped html entities
        txt = showdown.helper.unescapeHTMLEntities(txt);

        // escape markdown magic characters
        // emphasis, strong and strikethrough - can appear everywhere
        // we also escape pipe (|) because of tables
        // and escape ` because of code blocks and spans
        txt = txt.replace(/([*_~|`])/g, '\\$1');

        // escape > because of blockquotes
        txt = txt.replace(/^(\s*)>/g, '\\$1>');

        // hash character, only troublesome at the beginning of a line because of headers
        txt = txt.replace(/^#/gm, '\\#');

        // horizontal rules
        txt = txt.replace(/^(\s*)([-=]{3,})(\s*)$/, '$1\\$2$3');

        // dot, because of ordered lists, only troublesome at the beginning of a line when preceded by an integer
        txt = txt.replace(/^( {0,3}\d+)\./gm, '$1\\.');

        // +, * and -, at the beginning of a line becomes a list, so we need to escape them also (asterisk was already escaped)
        txt = txt.replace(/^( {0,3})([+-])/gm, '$1\\$2');

        // images and links, ] followed by ( is problematic, so we escape it
        txt = txt.replace(/]([\s]*)\(/g, '\\]$1\\(');

        // reference URIs must also be escaped
        txt = txt.replace(/^ {0,3}\[([\S \t]*?)]:/gm, '\\[$1]:');
        return txt;
      });
      var root = this;

      // AMD Loader
      if (module.exports) {
        module.exports = showdown;

        // Regular Browser loader
      } else {
        root.showdown = showdown;
      }
    }).call(commonjsGlobal);
  })(showdown);
  var showdownExports = showdown.exports;

  var hljs = common;
  hljs.configure({
    ignoreUnescapedHTML: true
  });
  hljs.safeMode();
  var converter = new showdownExports.Converter({
    requireSpaceBeforeHeadingText: true,
    tables: true
  });

  /**
   * Escapes HTML special characters in a string
   * Source: https://stackoverflow.com/questions/1787322
   *
   * @param {string} text Raw text
   * @returns string Escaped HTML
   */
  function escapeHtml(text) {
    var map = {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#039;'
    };
    return text.replace(/[&<>"']/g, function (m) {
      return map[m];
    });
  }
  function convertMarkdownToHtml(text) {
    // add ending code block tags when missing
    var code_block_count = (text.match(/```/g) || []).length;
    if (code_block_count % 2 !== 0) {
      text += "\n```";
    }

    // HTML-escape parts of text that are not inside ticks.
    // This prevents <?php from turning into a comment tag
    var escaped_parts = [];
    var code_parts = text.split("`");
    for (var i = 0; i < code_parts.length; i++) {
      if (i % 2 === 0) {
        escaped_parts.push(escapeHtml(code_parts[i]));
      } else {
        escaped_parts.push(code_parts[i]);
      }
    }
    var escaped_message = escaped_parts.join("`");

    // Convert Markdown to HTML
    var formatted_message = "";
    var code_blocks = escaped_message.split("```");
    for (var _i = 0; _i < code_blocks.length; _i++) {
      if (_i % 2 === 0) {
        // add two spaces in the end of every line
        // for non-codeblocks so that one-per-line lists
        // without markdown can be generated
        formatted_message += converter.makeHtml(code_blocks[_i].trim().replace(/\n/g, "  \n"));
      } else {
        // convert Markdown code blocks to HTML
        formatted_message += converter.makeHtml("```" + code_blocks[_i] + "```");
      }
    }
    return formatted_message;
  }
  function markdownToHtml(text) {
    var html = convertMarkdownToHtml(text);
    var el = document.createElement('div');
    el.innerHTML = html;
    el.querySelectorAll('pre code').forEach(function (el) {
      var text = el.innerText.trim();
      var h = hljs.highlightAuto(text);
      el.innerHTML = h.value;
      var actions = document.createElement('div');
      actions.classList.add('actions');
      var lang = document.createElement('span');
      lang.classList.add('lang');
      lang.innerText = h.language;
      actions.appendChild(lang);
      var copy = document.createElement('x-copy');
      copy.classList.add('copy');
      var icon = document.createElement('i');
      icon.classList.add('ti', 'ti-copy');
      copy.appendChild(icon);
      copy.setAttribute('data-copy', text);
      actions.appendChild(copy);
      el.closest('pre').prepend(actions);
    });
    return el.innerHTML;
  }

  function documentView() {
    module_default$1.data('document', function (doc) {
      return {
        doc: {},
        model: {},
        required: ['title'],
        isProcessing: false,
        output: '',
        init: function init() {
          var _this = this;
          this.doc = doc;
          this.model = _objectSpread2({}, this.doc);
          this.output = markdownToHtml(this.doc.content);
          this.required.forEach(function (field) {
            _this.$watch("model.".concat(field), function () {
              return _this.$refs.submit.disabled = !_this.isSubmitable();
            });
          });
        },
        submit: function submit() {
          if (!this.isSubmitable() || this.isProcessing) {
            return;
          }
          this.update();
        },
        update: function update() {
          var _this2 = this;
          this.isProcessing = true;
          var data = this.model;
          data.status = data.status ? 1 : 0;
          api.post("/documents/".concat(this.doc.id), this.model).then(function (response) {
            return response.json();
          }).then(function (doc) {
            _this2.doc = doc;
            _this2.model = _objectSpread2({}, _this2.doc);
            _this2.output = markdownToHtml(_this2.doc.content);
            _this2.isProcessing = false;
            toast$1.success('Document has been updated successfully!');
          });
        },
        isSubmitable: function isSubmitable() {
          for (var i = 0; i < this.required.length; i++) {
            var field = this.required[i];
            if (!this.model[field]) {
              return false;
            }
          }
          return true;
        },
        copyDocumentContents: function copyDocumentContents() {
          navigator.clipboard.writeText(this.doc.content).then(function () {
            toast$1.show('Document copied to clipboard!', 'ti ti-square-rounded-check-filled');
          });
        },
        download: function download(format) {
          if (format == 'markdown') {
            var mimeType = 'text/markdown';
            var ext = 'md';
            var content = this.doc.content;
          } else if (format == 'html') {
            var mimeType = 'text/html';
            var ext = 'html';
            var content = "<html><head><meta charset=\"utf-8\" /><title>".concat(this.model.title || this.doc.title, "</title></head><body>").concat(this.output, "</body></html>");
          } else if (format == 'word') {
            var mimeType = 'application/vnd.ms-word';
            var ext = 'doc';
            var content = "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" xmlns=\"http://www.w3.org/TR/REC-html40\"><head><meta charset=\"utf-8\" /><title>".concat(this.doc.title, "</title></head><body>").concat(this.output, "</body></html>");
          } else {
            var mimeType = 'text/plain';
            var ext = 'txt';
            var content = this.doc.content;
          }
          this.downloadFromUrl("data:".concat(mimeType, ";charset=utf-8,").concat(encodeURIComponent(content)), this.model.title || this.doc.title, ext);
        },
        downloadFromUrl: function downloadFromUrl(url, filename, ext) {
          var anchor = document.createElement('a');
          anchor.href = url;
          anchor.download = "".concat(filename, ".").concat(ext);
          document.body.appendChild(anchor);
          anchor.click();

          // Clean up
          document.body.removeChild(anchor);
        }
      };
    });
  }

  function billingView() {
    module_default$1.data('billing', function () {
      return {
        orders: [],
        init: function init() {
          this.getOrders();
        },
        cancelSubscription: function cancelSubscription() {
          api["delete"]("/billing/subscription").then(function () {
            toast$1.success('Subscription cancelled!');
            window.modal.close();

            // Reload the page to reflect the changes
            window.location.reload();
          });
        },
        getOrders: function getOrders() {
          var _this = this;
          api.get("/billing/orders", {
            sort: 'created_at:desc',
            limit: 3
          }).then(function (response) {
            return response.json();
          }).then(function (list) {
            return _this.orders = list.data;
          });
        }
      };
    });
    module_default$1.data('plans', function () {
      return {
        state: 'initial',
        plans: {
          monthly: [],
          yearly: [],
          lifetime: []
        },
        freePlan: null,
        cycle: null,
        showSwitch: false,
        init: function init() {
          var _this2 = this;
          getPlanList().then(function (plans) {
            if (!plans) {
              _this2.state = 'empty';
              return;
            }
            var free = plans.filter(function (plan) {
              return plan.price === 0 && ['monthly', 'yearly'].includes(plan.billing_cycle);
            });
            if (free.length == 1) {
              _this2.freePlan = free[0];
            }
            ['monthly', 'yearly', 'lifetime'].forEach(function (cycle) {
              _this2.plans[cycle] = plans.filter(function (plan) {
                return plan.billing_cycle === cycle && (!_this2.freePlan || plan.id !== _this2.freePlan.id);
              });
            });

            // Set cycle to the first available cycle
            if (_this2.plans.monthly.length > 0) {
              _this2.cycle = 'monthly';
            } else if (_this2.plans.yearly.length > 0) {
              _this2.cycle = 'yearly';
            }
            if (!_this2.$store.workspace.is_eligible_for_free_plan) {
              _this2.freePlan = null;
            }
            _this2.state = _this2.freePlan || _this2.plans.monthly.length > 0 || _this2.plans.yearly.length > 0 ? 'normal' : 'empty';

            // Show the switcher if at least two cycles are available

            // Set showSwitch to true if at least two plans have a non-zero length
            _this2.showSwitch = Object.values(_this2.plans).map(function (plan) {
              return plan.length;
            }).filter(function (length) {
              return length > 0;
            }).length >= 2;
          });
        }
      };
    });
    module_default$1.data('packs', function () {
      return {
        state: 'initial',
        packs: [],
        init: function init() {
          var _this3 = this;
          getPlanList().then(function (plans) {
            if (!plans) {
              _this3.state = 'empty';
              return;
            }
            _this3.packs = plans.filter(function (plan) {
              return plan.billing_cycle === 'one-time';
            });
            _this3.state = _this3.packs.length > 0 ? 'normal' : 'empty';
          });
        }
      };
    });
  }

  var device = {};

  var isAndroid$2 = function isAndroid(ua) {
    ua = ua || window.navigator.userAgent;
    return /Android/i.test(ua);
  };

  var isAndroid$1 = isAndroid$2;

  var isChromeOs$2 = function isChromeOS(ua) {
    ua = ua || window.navigator.userAgent;
    return /CrOS/i.test(ua);
  };

  var isChromeOs$1 = isChromeOs$2;

  var isEdge$1 = function isEdge(ua) {
    ua = ua || window.navigator.userAgent;
    return ua.indexOf("Edge/") !== -1 || ua.indexOf("Edg/") !== -1;
  };

  var isSamsung$1 = function isSamsungBrowser(ua) {
    ua = ua || window.navigator.userAgent;
    return /SamsungBrowser/i.test(ua);
  };

  var isDuckduckgo = function isDuckDuckGo(ua) {
    ua = ua || window.navigator.userAgent;
    return ua.indexOf("DuckDuckGo/") !== -1;
  };

  var isOpera$1 = function isOpera(ua) {
    ua = ua || window.navigator.userAgent;
    return ua.indexOf("OPR/") !== -1 || ua.indexOf("Opera/") !== -1 || ua.indexOf("OPT/") !== -1;
  };

  var isSilk$1 = function isSilk(ua) {
    ua = ua || window.navigator.userAgent;
    return ua.indexOf("Silk/") !== -1;
  };

  var isEdge = isEdge$1;
  var isSamsung = isSamsung$1;
  var isDuckDuckGo = isDuckduckgo;
  var isOpera = isOpera$1;
  var isSilk = isSilk$1;
  var isChrome$2 = function isChrome(ua) {
    ua = ua || window.navigator.userAgent;
    return (ua.indexOf("Chrome") !== -1 || ua.indexOf("CriOS") !== -1) && !isEdge(ua) && !isSamsung(ua) && !isDuckDuckGo(ua) && !isOpera(ua) && !isSilk(ua);
  };

  var isChrome$1 = isChrome$2;

  var isIpados = function isIpadOS(ua, document) {
    ua = ua || window.navigator.userAgent;
    document = document || window.document;
    // "ontouchend" is used to determine if a browser is on an iPad, otherwise
    // user-agents for iPadOS behave/identify as a desktop browser
    return /Mac|iPad/i.test(ua) && "ontouchend" in document;
  };

  var isIpadOS = isIpados;
  var isIos$2 = function isIos(ua, checkIpadOS, document) {
    if (checkIpadOS === void 0) {
      checkIpadOS = true;
    }
    ua = ua || window.navigator.userAgent;
    var iOsTest = /iPhone|iPod|iPad/i.test(ua);
    return checkIpadOS ? iOsTest || isIpadOS(ua, document) : iOsTest;
  };

  var isIos$1 = isIos$2;

  var isIe9$1 = function isIe9(ua) {
    ua = ua || window.navigator.userAgent;
    return ua.indexOf("MSIE 9") !== -1;
  };

  var isIe9 = isIe9$1;

  Object.defineProperty(device, "__esModule", {
    value: true
  });
  device.isIos = device.isIE9 = device.isSamsungBrowser = device.isAndroidChrome = device.isKitKatWebview = void 0;
  // server side rendering check
  var UA = typeof window !== "undefined" && window.navigator && window.navigator.userAgent;
  // TODO remove this when browser detection is converted to typescript
  /* eslint-disable @typescript-eslint/ban-ts-comment */
  // @ts-ignore
  var isAndroid = isAndroid$1;
  // @ts-ignore
  var isChromeOs = isChromeOs$1;
  // @ts-ignore
  var isChrome = isChrome$1;
  // @ts-ignore
  var isIos = isIos$1;
  device.isIos = isIos;
  // @ts-ignore
  var isIE9 = isIe9;
  device.isIE9 = isIE9;
  /* eslint-enable @typescript-eslint/ban-ts-comment */
  // Old Android Webviews used specific versions of Chrome with 0.0.0 as their version suffix
  // https://developer.chrome.com/multidevice/user-agent#webview_user_agent
  var KITKAT_WEBVIEW_REGEX = /Version\/\d\.\d* Chrome\/\d*\.0\.0\.0/;
  function isOldSamsungBrowserOrSamsungWebview(ua) {
    return !isChrome(ua) && ua.indexOf("Samsung") > -1;
  }
  function isKitKatWebview(ua) {
    if (ua === void 0) {
      ua = UA;
    }
    return isAndroid(ua) && KITKAT_WEBVIEW_REGEX.test(ua);
  }
  device.isKitKatWebview = isKitKatWebview;
  function isAndroidChrome(ua) {
    if (ua === void 0) {
      ua = UA;
    }
    return (isAndroid(ua) || isChromeOs(ua)) && isChrome(ua);
  }
  device.isAndroidChrome = isAndroidChrome;
  function isSamsungBrowser(ua) {
    if (ua === void 0) {
      ua = UA;
    }
    return /SamsungBrowser/.test(ua) || isOldSamsungBrowserOrSamsungWebview(ua);
  }
  device.isSamsungBrowser = isSamsungBrowser;

  var device_1$1 = device;
  var supportsInputFormatting$1 = function supportsInputFormatting() {
    // Digits get dropped in samsung browser
    return !(0, device_1$1.isSamsungBrowser)();
  };

  var ios = {};

  var base = {};

  var strategyInterface = {};

  Object.defineProperty(strategyInterface, "__esModule", {
    value: true
  });
  strategyInterface.StrategyInterface = void 0;
  var StrategyInterface = /** @class */function () {
    function StrategyInterface(options) {
      this.inputElement = options.element;
      this.isFormatted = false;
    }
    return StrategyInterface;
  }();
  strategyInterface.StrategyInterface = StrategyInterface;

  var keyCannotMutateValue$1 = {};

  var inputSelection = {};

  Object.defineProperty(inputSelection, "__esModule", {
    value: true
  });
  inputSelection.set = inputSelection.get = void 0;
  function get(element) {
    var start = element.selectionStart || 0;
    var end = element.selectionEnd || 0;
    return {
      start: start,
      end: end,
      delta: Math.abs(end - start)
    };
  }
  inputSelection.get = get;
  function set(element, start, end) {
    // Some browsers explode if you use setSelectionRange
    // on a non-focused element
    if (document.activeElement === element && element.setSelectionRange) {
      element.setSelectionRange(start, end);
    }
  }
  inputSelection.set = set;

  Object.defineProperty(keyCannotMutateValue$1, "__esModule", {
    value: true
  });
  keyCannotMutateValue$1.keyCannotMutateValue = void 0;
  var input_selection_1$4 = inputSelection;
  // eslint-disable-next-line complexity
  function keyCannotMutateValue(event) {
    var input = event.currentTarget || event.srcElement;
    var selection = (0, input_selection_1$4.get)(input);
    var isAtBeginning = selection.start === 0;
    var isAtEnd = selection.start === input.value.length;
    var isShifted = event.shiftKey === true;
    // https://www.w3.org/TR/DOM-Level-3-Events/#widl-KeyboardEvent-key
    switch (event.key) {
      case undefined: // eslint-disable-line
      case "Unidentified": // Cannot be determined
      case "":
        // Uninitialized
        break;
      case "Backspace":
        // backspace at the beginning
        return isAtBeginning;
      case "Del": // delete at the end
      case "Delete":
        return isAtEnd;
      default:
        return event.key.length !== 1;
    }
    // http://unixpapa.com/js/key.html
    switch (event.keyCode) {
      case 9: // tab
      case 19: // pause/break
      case 20: // caps lock
      case 27: // escape
      case 39: // arrows
      case 45:
        // insert
        return true;
      case 33: // page up (if shifted, '!')
      case 34: // page down (if shifted, ''')
      case 35: // end (if shifted, '#')
      case 36: // home (if shifted, '$')
      case 37: // arrows (if shifted, '%')
      case 38: // arrows (if shifted, '&')
      case 40:
        // arrows (if shifted, '(')
        return !isShifted;
      case 8:
        // backspace at the beginning
        return isAtBeginning;
      case 46:
        // delete at the end
        return isAtEnd;
      default:
        return false;
    }
  }
  keyCannotMutateValue$1.keyCannotMutateValue = keyCannotMutateValue;

  var isBackspace$1 = {};

  Object.defineProperty(isBackspace$1, "__esModule", {
    value: true
  });
  isBackspace$1.isBackspace = void 0;
  function isBackspace(event) {
    return event.key === "Backspace" || event.keyCode === 8;
  }
  isBackspace$1.isBackspace = isBackspace;

  var isDelete$1 = {};

  Object.defineProperty(isDelete$1, "__esModule", {
    value: true
  });
  isDelete$1.isDelete = void 0;
  var DELETE_REGEX = /^Del(ete)?$/;
  function isDelete(event) {
    return DELETE_REGEX.test(event.key) || event.keyCode === 46;
  }
  isDelete$1.isDelete = isDelete;

  var formatter = {};

  var parsePattern$1 = {};

  Object.defineProperty(parsePattern$1, "__esModule", {
    value: true
  });
  parsePattern$1.parsePattern = void 0;
  var ALPHA_REGEX = /[A-Za-z]/;
  var DIGIT_REGEX = /\d/;
  var WILD_REGEX = /./;
  var PLACEHOLDER_REGEX = /^[A-Za-z0-9\*]$/;
  var PLACEHOLDER_PATTERN = "({{[^}]+}})";
  var PERMACHAR_REGEX = "(\\s|\\S)";
  var PATTERN_REGEX = new RegExp(PLACEHOLDER_PATTERN + "|" + PERMACHAR_REGEX, "g");
  var PLACEHOLDER_PATTERN_REGEX = new RegExp("^" + PLACEHOLDER_PATTERN + "$");
  var replacerRegex = new RegExp("{|}", "g");
  function isDigit(char) {
    return DIGIT_REGEX.test(char);
  }
  function isAlpha(char) {
    return ALPHA_REGEX.test(char);
  }
  function createRegexForChar(char) {
    if (isDigit(char)) {
      return DIGIT_REGEX;
    } else if (isAlpha(char)) {
      return ALPHA_REGEX;
    }
    return WILD_REGEX;
  }
  function isPlaceholder(char) {
    return PLACEHOLDER_REGEX.test(char);
  }
  function isPlaceholderPattern(str) {
    return PLACEHOLDER_PATTERN_REGEX.test(str);
  }
  function parsePattern(patternString) {
    var patternArray = [];
    var patternParts = patternString.match(PATTERN_REGEX);
    if (!patternParts) {
      return patternArray;
    }
    for (var index = 0, i = 0; i < patternParts.length; i++) {
      var patternPart = patternParts[i];
      if (isPlaceholderPattern(patternPart)) {
        var placeholderChars = patternPart.replace(replacerRegex, "").split("");
        for (var j = 0; j < placeholderChars.length; j++) {
          var placeholderChar = placeholderChars[j];
          if (!isPlaceholder(placeholderChar)) {
            throw new Error("Only alphanumeric or wildcard pattern matchers are allowed");
          }
          patternArray.push({
            value: createRegexForChar(placeholderChar),
            isPermaChar: false,
            index: index++
          });
        }
      } else {
        patternArray.push({
          value: patternPart,
          isPermaChar: true,
          index: index++
        });
      }
    }
    return patternArray;
  }
  parsePattern$1.parsePattern = parsePattern;

  Object.defineProperty(formatter, "__esModule", {
    value: true
  });
  formatter.PatternFormatter = void 0;
  var parse_pattern_1 = parsePattern$1;
  var is_backspace_1$1 = isBackspace$1;
  var PatternFormatter = /** @class */function () {
    function PatternFormatter(pattern) {
      this.pattern = (0, parse_pattern_1.parsePattern)(pattern);
    }
    PatternFormatter.prototype.format = function (options) {
      var originalString = options.value;
      var originalStringIndex = 0;
      var formattedString = "";
      var selection = {
        start: options.selection.start,
        end: options.selection.end
      };
      for (var i = 0; i < this.pattern.length; i++) {
        var patternChar = this.pattern[i];
        var inputChar = originalString[originalStringIndex];
        if (originalStringIndex > originalString.length) {
          break;
        }
        if (typeof patternChar.value === "string") {
          if (inputChar != null || formattedString.length === patternChar.index) {
            formattedString += patternChar.value;
            if (patternChar.index <= selection.start) {
              selection.start++;
            }
            if (patternChar.index <= selection.end) {
              selection.end++;
            }
          }
        } else {
          // User input char
          // prettier-ignore
          for (; originalStringIndex < originalString.length; originalStringIndex++) {
            inputChar = originalString[originalStringIndex];
            if (patternChar.value.test(inputChar)) {
              formattedString += inputChar;
              originalStringIndex++;
              break;
            } else {
              if (patternChar.index <= selection.start) {
                selection.start--;
              }
              if (patternChar.index <= selection.end) {
                selection.end--;
              }
            }
          }
        }
      }
      return {
        value: formattedString,
        selection: selection
      };
    };
    PatternFormatter.prototype.unformat = function (options) {
      var start = options.selection.start;
      var end = options.selection.end;
      var unformattedString = "";
      for (var i = 0; i < this.pattern.length; i++) {
        var patternChar = this.pattern[i];
        if (typeof patternChar.value !== "string" && options.value[i] != null && patternChar.value.test(options.value[i])) {
          unformattedString += options.value[i];
          continue;
        }
        if (patternChar.value !== options.value[patternChar.index]) {
          continue;
        }
        if (patternChar.index < options.selection.start) {
          start--;
        }
        if (patternChar.index < options.selection.end) {
          end--;
        }
      }
      return {
        selection: {
          start: start,
          end: end
        },
        value: unformattedString
      };
    };
    PatternFormatter.prototype.simulateDeletion = function (options) {
      var deletionStart, deletionEnd;
      var state = this.unformat(options);
      var value = state.value;
      var selection = state.selection;
      var delta = Math.abs(state.selection.end - state.selection.start);
      if (delta) {
        deletionStart = selection.start;
        deletionEnd = selection.end;
      } else if ((0, is_backspace_1$1.isBackspace)(options.event)) {
        deletionStart = Math.max(0, selection.start - 1);
        deletionEnd = selection.start;
      } else {
        // Handle forward delete
        deletionStart = selection.start;
        deletionEnd = Math.min(value.length, selection.start + 1);
      }
      return {
        selection: {
          start: deletionStart,
          end: deletionStart
        },
        value: value.substr(0, deletionStart) + value.substr(deletionEnd)
      };
    };
    return PatternFormatter;
  }();
  formatter.PatternFormatter = PatternFormatter;

  var __extends$5 = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(base, "__esModule", {
    value: true
  });
  base.BaseStrategy = void 0;
  var strategy_interface_1$1 = strategyInterface;
  var key_cannot_mutate_value_1$3 = keyCannotMutateValue$1;
  var input_selection_1$3 = inputSelection;
  var is_backspace_1 = isBackspace$1;
  var is_delete_1 = isDelete$1;
  var formatter_1 = formatter;
  function isSimulatedEvent(event) {
    // 1Password sets input.value then fires keyboard events. Dependent on browser
    // here might be falsy values (key = '', keyCode = 0) or these keys might be omitted
    // Chrome autofill inserts keys all at once and fires a single event without key info
    return !event.key && !event.keyCode;
  }
  var BaseStrategy = /** @class */function (_super) {
    __extends$5(BaseStrategy, _super);
    function BaseStrategy(options) {
      var _this = _super.call(this, options) || this;
      _this.hasKeypressEvent = false;
      _this.formatter = new formatter_1.PatternFormatter(options.pattern);
      _this.onPasteEvent = options.onPasteEvent;
      _this.attachListeners();
      _this.formatIfNotEmpty();
      return _this;
    }
    BaseStrategy.prototype.getUnformattedValue = function (forceUnformat) {
      var value = this.inputElement.value;
      if (forceUnformat || this.isFormatted) {
        value = this.formatter.unformat({
          value: this.inputElement.value,
          selection: {
            start: 0,
            end: 0
          }
        }).value;
      }
      return value;
    };
    BaseStrategy.prototype.formatIfNotEmpty = function () {
      if (this.inputElement.value) {
        this.reformatInput();
      }
    };
    BaseStrategy.prototype.setPattern = function (pattern) {
      this.unformatInput();
      this.formatter = new formatter_1.PatternFormatter(pattern);
      this.formatIfNotEmpty();
    };
    BaseStrategy.prototype.attachListeners = function () {
      var _this = this;
      this.inputElement.addEventListener("keydown", function (e) {
        var event = e;
        if (isSimulatedEvent(event)) {
          _this.isFormatted = false;
        }
        if ((0, key_cannot_mutate_value_1$3.keyCannotMutateValue)(event)) {
          return;
        }
        if (_this.isDeletion(event)) {
          _this.unformatInput();
        }
      });
      this.inputElement.addEventListener("keypress", function (e) {
        _this.hasKeypressEvent = true;
        _this.onKeypress(e);
      });
      this.inputElement.addEventListener("keyup", function () {
        _this.reformatInput();
        // if the user changes their keyboard and
        // the browser doesn't support the keypress event listener,
        // we need to reset the keypress flag to be able to enable the
        // fallback for the custom input event listener
        // to be able to format the field
        _this.hasKeypressEvent = false;
      });
      this.inputElement.addEventListener("input", function (e) {
        var event = e;
        // Some input sources on Mac OS prevent
        // the keypress event from being fired,
        // so if we can't detect that the keypress
        // event fired, we simulate the event
        // here before the handler for the input
        // event
        if (!_this.hasKeypressEvent) {
          _this.onKeypress(e);
        }
        // Safari AutoFill fires CustomEvents
        // LastPass sends an `isTrusted: false` property
        // Since the input is changed all at once, set isFormatted
        // to false so that reformatting actually occurs
        if (event instanceof CustomEvent || !event.isTrusted) {
          _this.isFormatted = false;
        }
        _this.reformatInput();
      });
      this.inputElement.addEventListener("paste", function (event) {
        _this.pasteEventHandler(event);
      });
    };
    BaseStrategy.prototype.isDeletion = function (event) {
      return (0, is_delete_1.isDelete)(event) || (0, is_backspace_1.isBackspace)(event);
    };
    BaseStrategy.prototype.reformatInput = function () {
      if (this.isFormatted) {
        return;
      }
      this.isFormatted = true;
      var input = this.inputElement;
      var formattedState = this.formatter.format({
        selection: (0, input_selection_1$3.get)(input),
        value: input.value
      });
      input.value = formattedState.value;
      (0, input_selection_1$3.set)(input, formattedState.selection.start, formattedState.selection.end);
      this.afterReformatInput(formattedState);
    };
    // If a strategy needs to impliment specific behavior
    // after reformatting has happend, the strategy just
    // overwrites this method on their own prototype
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    BaseStrategy.prototype.afterReformatInput = function (formattedState) {
      // noop
    };
    BaseStrategy.prototype.unformatInput = function () {
      if (!this.isFormatted) {
        return;
      }
      this.isFormatted = false;
      var input = this.inputElement;
      var selection = (0, input_selection_1$3.get)(input);
      var unformattedState = this.formatter.unformat({
        selection: selection,
        value: input.value
      });
      input.value = unformattedState.value;
      (0, input_selection_1$3.set)(input, unformattedState.selection.start, unformattedState.selection.end);
    };
    BaseStrategy.prototype.prePasteEventHandler = function (event) {
      // without this, the paste event is called twice
      // so if you were pasting abc it would result in
      // abcabc
      event.preventDefault();
    };
    BaseStrategy.prototype.postPasteEventHandler = function () {
      this.reformatAfterPaste();
    };
    BaseStrategy.prototype.pasteEventHandler = function (event) {
      var splicedEntry;
      var entryValue = "";
      this.prePasteEventHandler(event);
      this.unformatInput();
      if (event.clipboardData) {
        entryValue = event.clipboardData.getData("Text");
      } else if (window.clipboardData) {
        entryValue = window.clipboardData.getData("Text");
      }
      var selection = (0, input_selection_1$3.get)(this.inputElement);
      splicedEntry = this.inputElement.value.split("");
      splicedEntry.splice(selection.start, selection.end - selection.start, entryValue);
      splicedEntry = splicedEntry.join("");
      if (this.onPasteEvent) {
        this.onPasteEvent({
          unformattedInputValue: splicedEntry
        });
      }
      this.inputElement.value = splicedEntry;
      (0, input_selection_1$3.set)(this.inputElement, selection.start + entryValue.length, selection.start + entryValue.length);
      this.postPasteEventHandler();
    };
    BaseStrategy.prototype.reformatAfterPaste = function () {
      var event = document.createEvent("Event");
      this.reformatInput();
      event.initEvent("input", true, true);
      this.inputElement.dispatchEvent(event);
    };
    BaseStrategy.prototype.getStateToFormat = function () {
      var input = this.inputElement;
      var selection = (0, input_selection_1$3.get)(input);
      var stateToFormat = {
        selection: selection,
        value: input.value
      };
      if (this.stateToFormat) {
        stateToFormat = this.stateToFormat;
        delete this.stateToFormat;
      } else if (selection.start === input.value.length && this.isFormatted) {
        stateToFormat = this.formatter.unformat(stateToFormat);
      }
      return stateToFormat;
    };
    BaseStrategy.prototype.onKeypress = function (event) {
      if (isSimulatedEvent(event)) {
        this.isFormatted = false;
      }
      if ((0, key_cannot_mutate_value_1$3.keyCannotMutateValue)(event)) {
        return;
      }
      this.unformatInput();
    };
    return BaseStrategy;
  }(strategy_interface_1$1.StrategyInterface);
  base.BaseStrategy = BaseStrategy;

  var __extends$4 = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(ios, "__esModule", {
    value: true
  });
  ios.IosStrategy = void 0;
  var base_1$3 = base;
  var key_cannot_mutate_value_1$2 = keyCannotMutateValue$1;
  var input_selection_1$2 = inputSelection;
  var IosStrategy = /** @class */function (_super) {
    __extends$4(IosStrategy, _super);
    function IosStrategy() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    IosStrategy.prototype.getUnformattedValue = function () {
      return _super.prototype.getUnformattedValue.call(this, true);
    };
    IosStrategy.prototype.attachListeners = function () {
      var _this = this;
      this.inputElement.addEventListener("keydown", function (event) {
        _this.keydownListener(event);
      });
      this.inputElement.addEventListener("input", function (event) {
        var isCustomEvent = event instanceof CustomEvent;
        // Safari AutoFill fires CustomEvents
        // Set state to format before calling format listener
        if (isCustomEvent) {
          _this.stateToFormat = {
            selection: {
              start: 0,
              end: 0
            },
            value: _this.inputElement.value
          };
        }
        _this.formatListener();
        if (!isCustomEvent) {
          _this.fixLeadingBlankSpaceOnIos();
        }
      });
      this.inputElement.addEventListener("focus", function () {
        _this.formatListener();
      });
      this.inputElement.addEventListener("paste", function (event) {
        _this.pasteEventHandler(event);
      });
    };
    // When deleting the last character on iOS, the cursor
    // is positioned as if there is a blank space when there
    // is not, setting it to '' in a setTimeout fixes it ¯\_(ツ)_/¯
    IosStrategy.prototype.fixLeadingBlankSpaceOnIos = function () {
      var input = this.inputElement;
      if (input.value === "") {
        setTimeout(function () {
          input.value = "";
        }, 0);
      }
    };
    IosStrategy.prototype.formatListener = function () {
      var input = this.inputElement;
      var stateToFormat = this.getStateToFormat();
      var formattedState = this.formatter.format(stateToFormat);
      input.value = formattedState.value;
      (0, input_selection_1$2.set)(input, formattedState.selection.start, formattedState.selection.end);
    };
    IosStrategy.prototype.keydownListener = function (event) {
      if ((0, key_cannot_mutate_value_1$2.keyCannotMutateValue)(event)) {
        return;
      }
      if (this.isDeletion(event)) {
        this.stateToFormat = this.formatter.simulateDeletion({
          event: event,
          selection: (0, input_selection_1$2.get)(this.inputElement),
          value: this.inputElement.value
        });
      }
    };
    return IosStrategy;
  }(base_1$3.BaseStrategy);
  ios.IosStrategy = IosStrategy;

  var androidChrome = {};

  var __extends$3 = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(androidChrome, "__esModule", {
    value: true
  });
  androidChrome.AndroidChromeStrategy = void 0;
  var key_cannot_mutate_value_1$1 = keyCannotMutateValue$1;
  var base_1$2 = base;
  var input_selection_1$1 = inputSelection;
  var AndroidChromeStrategy = /** @class */function (_super) {
    __extends$3(AndroidChromeStrategy, _super);
    function AndroidChromeStrategy() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    AndroidChromeStrategy.prototype.attachListeners = function () {
      var _this = this;
      this.inputElement.addEventListener("keydown", function (event) {
        if ((0, key_cannot_mutate_value_1$1.keyCannotMutateValue)(event)) {
          return;
        }
        _this.unformatInput();
      });
      this.inputElement.addEventListener("keyup", function () {
        _this.reformatInput();
      });
      this.inputElement.addEventListener("input", function () {
        _this.reformatInput();
      });
      this.inputElement.addEventListener("paste", function (event) {
        event.preventDefault();
        _this.pasteEventHandler(event);
      });
    };
    AndroidChromeStrategy.prototype.prePasteEventHandler = function () {
      // the default strategy calls preventDefault here
      // but that removes the clipboard data in Android chrome
      // so we noop instead
    };
    AndroidChromeStrategy.prototype.postPasteEventHandler = function () {
      var _this = this;
      // the default strategy calls this without a timeout
      setTimeout(function () {
        _this.reformatAfterPaste();
      }, 0);
    };
    AndroidChromeStrategy.prototype.afterReformatInput = function (formattedState) {
      var input = this.inputElement;
      // Some Android Chrome keyboards (notably Samsung)
      // cause the browser to not know that the value
      // of the input has changed when adding
      // permacharacters. This results in the selection
      // putting the cursor before the permacharacter,
      // instead of after.
      //
      // There is also the case of some Android Chrome
      // keyboards reporting a ranged selection on the
      // first character input. Restricted Input maintains
      // that range even though it is incorrect from the
      // keyboard.
      //
      // To resolve these issues we setTimeout and reset
      // the selection to the formatted end position.
      setTimeout(function () {
        var formattedSelection = formattedState.selection;
        (0, input_selection_1$1.set)(input, formattedSelection.end, formattedSelection.end);
      }, 0);
    };
    return AndroidChromeStrategy;
  }(base_1$2.BaseStrategy);
  androidChrome.AndroidChromeStrategy = AndroidChromeStrategy;

  var kitkatChromiumBasedWebview = {};

  // Android Devices on KitKat use Chromium based webviews. For some reason,
  // the value of the inputs are not accessible in the event loop where the
  // key event listeners are called. This causes formatting to get stuck
  // on permacharacters. By putting them in setTimeouts, this fixes the
  // problem. This causes other problems in non-webviews, so we give it
  // its own strategy.
  var __extends$2 = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(kitkatChromiumBasedWebview, "__esModule", {
    value: true
  });
  kitkatChromiumBasedWebview.KitKatChromiumBasedWebViewStrategy = void 0;
  var android_chrome_1$1 = androidChrome;
  var KitKatChromiumBasedWebViewStrategy = /** @class */function (_super) {
    __extends$2(KitKatChromiumBasedWebViewStrategy, _super);
    function KitKatChromiumBasedWebViewStrategy() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    KitKatChromiumBasedWebViewStrategy.prototype.reformatInput = function () {
      var _this = this;
      setTimeout(function () {
        _super.prototype.reformatInput.call(_this);
      }, 0);
    };
    KitKatChromiumBasedWebViewStrategy.prototype.unformatInput = function () {
      var _this = this;
      setTimeout(function () {
        _super.prototype.unformatInput.call(_this);
      }, 0);
    };
    return KitKatChromiumBasedWebViewStrategy;
  }(android_chrome_1$1.AndroidChromeStrategy);
  kitkatChromiumBasedWebview.KitKatChromiumBasedWebViewStrategy = KitKatChromiumBasedWebViewStrategy;

  var ie9 = {};

  var __extends$1 = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(ie9, "__esModule", {
    value: true
  });
  ie9.IE9Strategy = void 0;
  var base_1$1 = base;
  var key_cannot_mutate_value_1 = keyCannotMutateValue$1;
  var input_selection_1 = inputSelection;
  function padSelection(selection, pad) {
    return {
      start: selection.start + pad,
      end: selection.end + pad
    };
  }
  var IE9Strategy = /** @class */function (_super) {
    __extends$1(IE9Strategy, _super);
    function IE9Strategy() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    IE9Strategy.prototype.getUnformattedValue = function () {
      return base_1$1.BaseStrategy.prototype.getUnformattedValue.call(this, true);
    };
    IE9Strategy.prototype.attachListeners = function () {
      var _this = this;
      this.inputElement.addEventListener("keydown", function (event) {
        _this.keydownListener(event);
      });
      this.inputElement.addEventListener("focus", function () {
        _this.format();
      });
      this.inputElement.addEventListener("paste", function (event) {
        _this.pasteEventHandler(event);
      });
    };
    IE9Strategy.prototype.format = function () {
      var input = this.inputElement;
      var stateToFormat = this.getStateToFormat();
      var formattedState = this.formatter.format(stateToFormat);
      input.value = formattedState.value;
      (0, input_selection_1.set)(input, formattedState.selection.start, formattedState.selection.end);
    };
    IE9Strategy.prototype.keydownListener = function (event) {
      if ((0, key_cannot_mutate_value_1.keyCannotMutateValue)(event)) {
        return;
      }
      event.preventDefault();
      if (this.isDeletion(event)) {
        this.stateToFormat = this.formatter.simulateDeletion({
          event: event,
          selection: (0, input_selection_1.get)(this.inputElement),
          value: this.inputElement.value
        });
      } else {
        // IE9 does not update the input's value attribute
        // during key events, only after they complete.
        // We must retrieve the key from event.key and
        // add it to the input's value before formatting.
        var oldValue = this.inputElement.value;
        var selection = (0, input_selection_1.get)(this.inputElement);
        var newValue = oldValue.slice(0, selection.start) + event.key + oldValue.slice(selection.start);
        selection = padSelection(selection, 1);
        this.stateToFormat = {
          selection: selection,
          value: newValue
        };
        if (selection.start === newValue.length) {
          this.stateToFormat = this.formatter.unformat(this.stateToFormat);
        }
      }
      this.format();
    };
    IE9Strategy.prototype.reformatAfterPaste = function () {
      var input = this.inputElement;
      var selection = (0, input_selection_1.get)(this.inputElement);
      var value = this.formatter.format({
        selection: selection,
        value: input.value
      }).value;
      selection = padSelection(selection, 1);
      input.value = value;
      // IE9 sets the selection to the end of the input
      // manually setting it in a setTimeout puts it
      // in the correct position after pasting
      setTimeout(function () {
        (0, input_selection_1.set)(input, selection.start, selection.end);
      }, 0);
    };
    return IE9Strategy;
  }(base_1$1.BaseStrategy);
  ie9.IE9Strategy = IE9Strategy;

  var noop = {};

  var __extends = commonjsGlobal && commonjsGlobal.__extends || function () {
    var extendStatics = function (d, b) {
      extendStatics = Object.setPrototypeOf || {
        __proto__: []
      } instanceof Array && function (d, b) {
        d.__proto__ = b;
      } || function (d, b) {
        for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
      };
      return extendStatics(d, b);
    };
    return function (d, b) {
      if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
      extendStatics(d, b);
      function __() {
        this.constructor = d;
      }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
  }();
  Object.defineProperty(noop, "__esModule", {
    value: true
  });
  noop.NoopKeyboardStrategy = void 0;
  var strategy_interface_1 = strategyInterface;
  var NoopKeyboardStrategy = /** @class */function (_super) {
    __extends(NoopKeyboardStrategy, _super);
    function NoopKeyboardStrategy() {
      return _super !== null && _super.apply(this, arguments) || this;
    }
    NoopKeyboardStrategy.prototype.getUnformattedValue = function () {
      return this.inputElement.value;
    };
    NoopKeyboardStrategy.prototype.setPattern = function () {
      // noop
    };
    return NoopKeyboardStrategy;
  }(strategy_interface_1.StrategyInterface);
  noop.NoopKeyboardStrategy = NoopKeyboardStrategy;

  var device_1 = device;
  var supportsInputFormatting = supportsInputFormatting$1;
  var ios_1 = ios;
  var android_chrome_1 = androidChrome;
  var kitkat_chromium_based_webview_1 = kitkatChromiumBasedWebview;
  var ie9_1 = ie9;
  var base_1 = base;
  var noop_1 = noop;
  /**
   * Instances of this class can be used to modify the formatter for an input
   * @class
   * @param {object} options The initialization paramaters for this class
   * @param {object} options.element - A Input DOM object that RestrictedInput operates on
   * @param {string} options.pattern - The pattern to enforce on this element
   */
  var RestrictedInput$2 = /** @class */function () {
    function RestrictedInput(options) {
      if (!RestrictedInput.supportsFormatting()) {
        this.strategy = new noop_1.NoopKeyboardStrategy(options);
      } else if ((0, device_1.isIos)()) {
        this.strategy = new ios_1.IosStrategy(options);
      } else if ((0, device_1.isKitKatWebview)()) {
        this.strategy = new kitkat_chromium_based_webview_1.KitKatChromiumBasedWebViewStrategy(options);
      } else if ((0, device_1.isAndroidChrome)()) {
        this.strategy = new android_chrome_1.AndroidChromeStrategy(options);
      } else if ((0, device_1.isIE9)()) {
        this.strategy = new ie9_1.IE9Strategy(options);
      } else {
        this.strategy = new base_1.BaseStrategy(options);
      }
    }
    /**
     * @public
     * @returns {string} the unformatted value of the element
     */
    RestrictedInput.prototype.getUnformattedValue = function () {
      return this.strategy.getUnformattedValue();
    };
    /**
     * @public
     * @param {string} pattern - the pattern to enforce on the element
     * @return {void}
     */
    RestrictedInput.prototype.setPattern = function (pattern) {
      this.strategy.setPattern(pattern);
    };
    RestrictedInput.supportsFormatting = function () {
      return supportsInputFormatting();
    };
    return RestrictedInput;
  }();
  var restrictedInput = RestrictedInput$2;

  var RestrictedInput = restrictedInput;
  var main = RestrictedInput;
  var RestrictedInput$1 = /*@__PURE__*/getDefaultExportFromCjs(main);

  var cardTypes$1 = {
    visa: {
      niceType: "Visa",
      type: "visa",
      patterns: [4],
      gaps: [4, 8, 12],
      lengths: [16, 18, 19],
      code: {
        name: "CVV",
        size: 3
      }
    },
    mastercard: {
      niceType: "Mastercard",
      type: "mastercard",
      patterns: [[51, 55], [2221, 2229], [223, 229], [23, 26], [270, 271], 2720],
      gaps: [4, 8, 12],
      lengths: [16],
      code: {
        name: "CVC",
        size: 3
      }
    },
    "american-express": {
      niceType: "American Express",
      type: "american-express",
      patterns: [34, 37],
      gaps: [4, 10],
      lengths: [15],
      code: {
        name: "CID",
        size: 4
      }
    },
    "diners-club": {
      niceType: "Diners Club",
      type: "diners-club",
      patterns: [[300, 305], 36, 38, 39],
      gaps: [4, 10],
      lengths: [14, 16, 19],
      code: {
        name: "CVV",
        size: 3
      }
    },
    discover: {
      niceType: "Discover",
      type: "discover",
      patterns: [6011, [644, 649], 65],
      gaps: [4, 8, 12],
      lengths: [16, 19],
      code: {
        name: "CID",
        size: 3
      }
    },
    jcb: {
      niceType: "JCB",
      type: "jcb",
      patterns: [2131, 1800, [3528, 3589]],
      gaps: [4, 8, 12],
      lengths: [16, 17, 18, 19],
      code: {
        name: "CVV",
        size: 3
      }
    },
    unionpay: {
      niceType: "UnionPay",
      type: "unionpay",
      patterns: [620, [624, 626], [62100, 62182], [62184, 62187], [62185, 62197], [62200, 62205], [622010, 622999], 622018, [622019, 622999], [62207, 62209], [622126, 622925], [623, 626], 6270, 6272, 6276, [627700, 627779], [627781, 627799], [6282, 6289], 6291, 6292, 810, [8110, 8131], [8132, 8151], [8152, 8163], [8164, 8171]],
      gaps: [4, 8, 12],
      lengths: [14, 15, 16, 17, 18, 19],
      code: {
        name: "CVN",
        size: 3
      }
    },
    maestro: {
      niceType: "Maestro",
      type: "maestro",
      patterns: [493698, [500000, 504174], [504176, 506698], [506779, 508999], [56, 59], 63, 67, 6],
      gaps: [4, 8, 12],
      lengths: [12, 13, 14, 15, 16, 17, 18, 19],
      code: {
        name: "CVC",
        size: 3
      }
    },
    elo: {
      niceType: "Elo",
      type: "elo",
      patterns: [401178, 401179, 438935, 457631, 457632, 431274, 451416, 457393, 504175, [506699, 506778], [509000, 509999], 627780, 636297, 636368, [650031, 650033], [650035, 650051], [650405, 650439], [650485, 650538], [650541, 650598], [650700, 650718], [650720, 650727], [650901, 650978], [651652, 651679], [655000, 655019], [655021, 655058]],
      gaps: [4, 8, 12],
      lengths: [16],
      code: {
        name: "CVE",
        size: 3
      }
    },
    mir: {
      niceType: "Mir",
      type: "mir",
      patterns: [[2200, 2204]],
      gaps: [4, 8, 12],
      lengths: [16, 17, 18, 19],
      code: {
        name: "CVP2",
        size: 3
      }
    },
    hiper: {
      niceType: "Hiper",
      type: "hiper",
      patterns: [637095, 63737423, 63743358, 637568, 637599, 637609, 637612],
      gaps: [4, 8, 12],
      lengths: [16],
      code: {
        name: "CVC",
        size: 3
      }
    },
    hipercard: {
      niceType: "Hipercard",
      type: "hipercard",
      patterns: [606282],
      gaps: [4, 8, 12],
      lengths: [16],
      code: {
        name: "CVC",
        size: 3
      }
    }
  };
  var cardTypes_1 = cardTypes$1;

  var addMatchingCardsToResults$1 = {};

  var clone$1 = {};

  Object.defineProperty(clone$1, "__esModule", {
    value: true
  });
  clone$1.clone = void 0;
  function clone(originalObject) {
    if (!originalObject) {
      return null;
    }
    return JSON.parse(JSON.stringify(originalObject));
  }
  clone$1.clone = clone;

  var matches$1 = {};

  /*
   * Adapted from https://github.com/polvo-labs/card-type/blob/aaab11f80fa1939bccc8f24905a06ae3cd864356/src/cardType.js#L37-L42
   * */
  Object.defineProperty(matches$1, "__esModule", {
    value: true
  });
  matches$1.matches = void 0;
  function matchesRange(cardNumber, min, max) {
    var maxLengthToCheck = String(min).length;
    var substr = cardNumber.substr(0, maxLengthToCheck);
    var integerRepresentationOfCardNumber = parseInt(substr, 10);
    min = parseInt(String(min).substr(0, substr.length), 10);
    max = parseInt(String(max).substr(0, substr.length), 10);
    return integerRepresentationOfCardNumber >= min && integerRepresentationOfCardNumber <= max;
  }
  function matchesPattern(cardNumber, pattern) {
    pattern = String(pattern);
    return pattern.substring(0, cardNumber.length) === cardNumber.substring(0, pattern.length);
  }
  function matches(cardNumber, pattern) {
    if (Array.isArray(pattern)) {
      return matchesRange(cardNumber, pattern[0], pattern[1]);
    }
    return matchesPattern(cardNumber, pattern);
  }
  matches$1.matches = matches;

  Object.defineProperty(addMatchingCardsToResults$1, "__esModule", {
    value: true
  });
  addMatchingCardsToResults$1.addMatchingCardsToResults = void 0;
  var clone_1$1 = clone$1;
  var matches_1 = matches$1;
  function addMatchingCardsToResults(cardNumber, cardConfiguration, results) {
    var i, patternLength;
    for (i = 0; i < cardConfiguration.patterns.length; i++) {
      var pattern = cardConfiguration.patterns[i];
      if (!matches_1.matches(cardNumber, pattern)) {
        continue;
      }
      var clonedCardConfiguration = clone_1$1.clone(cardConfiguration);
      if (Array.isArray(pattern)) {
        patternLength = String(pattern[0]).length;
      } else {
        patternLength = String(pattern).length;
      }
      if (cardNumber.length >= patternLength) {
        clonedCardConfiguration.matchStrength = patternLength;
      }
      results.push(clonedCardConfiguration);
      break;
    }
  }
  addMatchingCardsToResults$1.addMatchingCardsToResults = addMatchingCardsToResults;

  var isValidInputType$1 = {};

  Object.defineProperty(isValidInputType$1, "__esModule", {
    value: true
  });
  isValidInputType$1.isValidInputType = void 0;
  function isValidInputType(cardNumber) {
    return typeof cardNumber === "string" || cardNumber instanceof String;
  }
  isValidInputType$1.isValidInputType = isValidInputType;

  var findBestMatch$1 = {};

  Object.defineProperty(findBestMatch$1, "__esModule", {
    value: true
  });
  findBestMatch$1.findBestMatch = void 0;
  function hasEnoughResultsToDetermineBestMatch(results) {
    var numberOfResultsWithMaxStrengthProperty = results.filter(function (result) {
      return result.matchStrength;
    }).length;
    /*
     * if all possible results have a maxStrength property that means the card
     * number is sufficiently long enough to determine conclusively what the card
     * type is
     * */
    return numberOfResultsWithMaxStrengthProperty > 0 && numberOfResultsWithMaxStrengthProperty === results.length;
  }
  function findBestMatch(results) {
    if (!hasEnoughResultsToDetermineBestMatch(results)) {
      return null;
    }
    return results.reduce(function (bestMatch, result) {
      if (!bestMatch) {
        return result;
      }
      /*
       * If the current best match pattern is less specific than this result, set
       * the result as the new best match
       * */
      if (Number(bestMatch.matchStrength) < Number(result.matchStrength)) {
        return result;
      }
      return bestMatch;
    });
  }
  findBestMatch$1.findBestMatch = findBestMatch;

  var __assign$1 = commonjsGlobal && commonjsGlobal.__assign || function () {
    __assign$1 = Object.assign || function (t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
    };
    return __assign$1.apply(this, arguments);
  };
  var cardTypes = cardTypes_1;
  var add_matching_cards_to_results_1 = addMatchingCardsToResults$1;
  var is_valid_input_type_1 = isValidInputType$1;
  var find_best_match_1 = findBestMatch$1;
  var clone_1 = clone$1;
  var customCards = {};
  var cardNames = {
    VISA: "visa",
    MASTERCARD: "mastercard",
    AMERICAN_EXPRESS: "american-express",
    DINERS_CLUB: "diners-club",
    DISCOVER: "discover",
    JCB: "jcb",
    UNIONPAY: "unionpay",
    MAESTRO: "maestro",
    ELO: "elo",
    MIR: "mir",
    HIPER: "hiper",
    HIPERCARD: "hipercard"
  };
  var ORIGINAL_TEST_ORDER = [cardNames.VISA, cardNames.MASTERCARD, cardNames.AMERICAN_EXPRESS, cardNames.DINERS_CLUB, cardNames.DISCOVER, cardNames.JCB, cardNames.UNIONPAY, cardNames.MAESTRO, cardNames.ELO, cardNames.MIR, cardNames.HIPER, cardNames.HIPERCARD];
  var testOrder = clone_1.clone(ORIGINAL_TEST_ORDER);
  function findType(cardType) {
    return customCards[cardType] || cardTypes[cardType];
  }
  function getAllCardTypes() {
    return testOrder.map(function (cardType) {
      return clone_1.clone(findType(cardType));
    });
  }
  function getCardPosition(name, ignoreErrorForNotExisting) {
    if (ignoreErrorForNotExisting === void 0) {
      ignoreErrorForNotExisting = false;
    }
    var position = testOrder.indexOf(name);
    if (!ignoreErrorForNotExisting && position === -1) {
      throw new Error('"' + name + '" is not a supported card type.');
    }
    return position;
  }
  function creditCardType$1(cardNumber) {
    var results = [];
    if (!is_valid_input_type_1.isValidInputType(cardNumber)) {
      return results;
    }
    if (cardNumber.length === 0) {
      return getAllCardTypes();
    }
    testOrder.forEach(function (cardType) {
      var cardConfiguration = findType(cardType);
      add_matching_cards_to_results_1.addMatchingCardsToResults(cardNumber, cardConfiguration, results);
    });
    var bestMatch = find_best_match_1.findBestMatch(results);
    if (bestMatch) {
      return [bestMatch];
    }
    return results;
  }
  creditCardType$1.getTypeInfo = function (cardType) {
    return clone_1.clone(findType(cardType));
  };
  creditCardType$1.removeCard = function (name) {
    var position = getCardPosition(name);
    testOrder.splice(position, 1);
  };
  creditCardType$1.addCard = function (config) {
    var existingCardPosition = getCardPosition(config.type, true);
    customCards[config.type] = config;
    if (existingCardPosition === -1) {
      testOrder.push(config.type);
    }
  };
  creditCardType$1.updateCard = function (cardType, updates) {
    var originalObject = customCards[cardType] || cardTypes[cardType];
    if (!originalObject) {
      throw new Error("\"" + cardType + "\" is not a recognized type. Use `addCard` instead.'");
    }
    if (updates.type && originalObject.type !== updates.type) {
      throw new Error("Cannot overwrite type parameter.");
    }
    var clonedCard = clone_1.clone(originalObject);
    clonedCard = __assign$1(__assign$1({}, clonedCard), updates);
    customCards[clonedCard.type] = clonedCard;
  };
  creditCardType$1.changeOrder = function (name, position) {
    var currentPosition = getCardPosition(name);
    testOrder.splice(currentPosition, 1);
    testOrder.splice(position, 0, name);
  };
  creditCardType$1.resetModifications = function () {
    testOrder = clone_1.clone(ORIGINAL_TEST_ORDER);
    customCards = {};
  };
  creditCardType$1.types = cardNames;
  var dist$1 = creditCardType$1;

  var cardholderName$1 = {};

  Object.defineProperty(cardholderName$1, "__esModule", {
    value: true
  });
  cardholderName$1.cardholderName = void 0;
  var CARD_NUMBER_REGEX = /^[\d\s-]*$/;
  var MAX_LENGTH = 255;
  function verification$6(isValid, isPotentiallyValid) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid
    };
  }
  function cardholderName(value) {
    if (typeof value !== "string") {
      return verification$6(false, false);
    }
    if (value.length === 0) {
      return verification$6(false, true);
    }
    if (value.length > MAX_LENGTH) {
      return verification$6(false, false);
    }
    if (CARD_NUMBER_REGEX.test(value)) {
      return verification$6(false, true);
    }
    return verification$6(true, true);
  }
  cardholderName$1.cardholderName = cardholderName;

  var cardNumber$1 = {};

  /* eslint-disable */
  function luhn10$1(identifier) {
    var sum = 0;
    var alt = false;
    var i = identifier.length - 1;
    var num;
    while (i >= 0) {
      num = parseInt(identifier.charAt(i), 10);
      if (alt) {
        num *= 2;
        if (num > 9) {
          num = num % 10 + 1; // eslint-disable-line no-extra-parens
        }
      }

      alt = !alt;
      sum += num;
      i--;
    }
    return sum % 10 === 0;
  }
  var luhn10_1 = luhn10$1;

  Object.defineProperty(cardNumber$1, "__esModule", {
    value: true
  });
  cardNumber$1.cardNumber = void 0;
  var luhn10 = luhn10_1;
  var getCardTypes = dist$1;
  function verification$5(card, isPotentiallyValid, isValid) {
    return {
      card: card,
      isPotentiallyValid: isPotentiallyValid,
      isValid: isValid
    };
  }
  function cardNumber(value, options) {
    if (options === void 0) {
      options = {};
    }
    var isPotentiallyValid, isValid, maxLength;
    if (typeof value !== "string" && typeof value !== "number") {
      return verification$5(null, false, false);
    }
    var testCardValue = String(value).replace(/-|\s/g, "");
    if (!/^\d*$/.test(testCardValue)) {
      return verification$5(null, false, false);
    }
    var potentialTypes = getCardTypes(testCardValue);
    if (potentialTypes.length === 0) {
      return verification$5(null, false, false);
    } else if (potentialTypes.length !== 1) {
      return verification$5(null, true, false);
    }
    var cardType = potentialTypes[0];
    if (options.maxLength && testCardValue.length > options.maxLength) {
      return verification$5(cardType, false, false);
    }
    if (options.skipLuhnValidation === true || cardType.type === getCardTypes.types.UNIONPAY && options.luhnValidateUnionPay !== true) {
      isValid = true;
    } else {
      isValid = luhn10(testCardValue);
    }
    maxLength = Math.max.apply(null, cardType.lengths);
    if (options.maxLength) {
      maxLength = Math.min(options.maxLength, maxLength);
    }
    for (var i = 0; i < cardType.lengths.length; i++) {
      if (cardType.lengths[i] === testCardValue.length) {
        isPotentiallyValid = testCardValue.length < maxLength || isValid;
        return verification$5(cardType, isPotentiallyValid, isValid);
      }
    }
    return verification$5(cardType, testCardValue.length < maxLength, false);
  }
  cardNumber$1.cardNumber = cardNumber;

  var expirationDate$1 = {};

  var parseDate$1 = {};

  var expirationYear$1 = {};

  Object.defineProperty(expirationYear$1, "__esModule", {
    value: true
  });
  expirationYear$1.expirationYear = void 0;
  var DEFAULT_VALID_NUMBER_OF_YEARS_IN_THE_FUTURE = 19;
  function verification$4(isValid, isPotentiallyValid, isCurrentYear) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid,
      isCurrentYear: isCurrentYear || false
    };
  }
  function expirationYear(value, maxElapsedYear) {
    if (maxElapsedYear === void 0) {
      maxElapsedYear = DEFAULT_VALID_NUMBER_OF_YEARS_IN_THE_FUTURE;
    }
    var isCurrentYear;
    if (typeof value !== "string") {
      return verification$4(false, false);
    }
    if (value.replace(/\s/g, "") === "") {
      return verification$4(false, true);
    }
    if (!/^\d*$/.test(value)) {
      return verification$4(false, false);
    }
    var len = value.length;
    if (len < 2) {
      return verification$4(false, true);
    }
    var currentYear = new Date().getFullYear();
    if (len === 3) {
      // 20x === 20x
      var firstTwo = value.slice(0, 2);
      var currentFirstTwo = String(currentYear).slice(0, 2);
      return verification$4(false, firstTwo === currentFirstTwo);
    }
    if (len > 4) {
      return verification$4(false, false);
    }
    var numericValue = parseInt(value, 10);
    var twoDigitYear = Number(String(currentYear).substr(2, 2));
    var valid = false;
    if (len === 2) {
      if (String(currentYear).substr(0, 2) === value) {
        return verification$4(false, true);
      }
      isCurrentYear = twoDigitYear === numericValue;
      valid = numericValue >= twoDigitYear && numericValue <= twoDigitYear + maxElapsedYear;
    } else if (len === 4) {
      isCurrentYear = currentYear === numericValue;
      valid = numericValue >= currentYear && numericValue <= currentYear + maxElapsedYear;
    }
    return verification$4(valid, valid, isCurrentYear);
  }
  expirationYear$1.expirationYear = expirationYear;

  var isArray = {};

  // Polyfill taken from <https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray#Polyfill>.
  Object.defineProperty(isArray, "__esModule", {
    value: true
  });
  isArray.isArray = void 0;
  isArray.isArray = Array.isArray || function (arg) {
    return Object.prototype.toString.call(arg) === "[object Array]";
  };

  Object.defineProperty(parseDate$1, "__esModule", {
    value: true
  });
  parseDate$1.parseDate = void 0;
  var expiration_year_1$2 = expirationYear$1;
  var is_array_1 = isArray;
  function getNumberOfMonthDigitsInDateString(dateString) {
    var firstCharacter = Number(dateString[0]);
    var assumedYear;
    /*
      if the first character in the string starts with `0`,
      we know that the month will be 2 digits.
         '0122' => {month: '01', year: '22'}
    */
    if (firstCharacter === 0) {
      return 2;
    }
    /*
      if the first character in the string starts with
      number greater than 1, it must be a 1 digit month
         '322' => {month: '3', year: '22'}
    */
    if (firstCharacter > 1) {
      return 1;
    }
    /*
      if the first 2 characters make up a number between
      13-19, we know that the month portion must be 1
         '139' => {month: '1', year: '39'}
    */
    if (firstCharacter === 1 && Number(dateString[1]) > 2) {
      return 1;
    }
    /*
      if the first 2 characters make up a number between
      10-12, we check if the year portion would be considered
      valid if we assumed that the month was 1. If it is
      not potentially valid, we assume the month must have
      2 digits.
         '109' => {month: '10', year: '9'}
      '120' => {month: '1', year: '20'} // when checked in the year 2019
      '120' => {month: '12', year: '0'} // when checked in the year 2021
    */
    if (firstCharacter === 1) {
      assumedYear = dateString.substr(1);
      return (0, expiration_year_1$2.expirationYear)(assumedYear).isPotentiallyValid ? 1 : 2;
    }
    /*
      If the length of the value is exactly 5 characters,
      we assume a full year was passed in, meaning the remaining
      single leading digit must be the month value.
         '12202' => {month: '1', year: '2202'}
    */
    if (dateString.length === 5) {
      return 1;
    }
    /*
      If the length of the value is more than five characters,
      we assume a full year was passed in addition to the month
      and therefore the month portion must be 2 digits.
         '112020' => {month: '11', year: '2020'}
    */
    if (dateString.length > 5) {
      return 2;
    }
    /*
      By default, the month value is the first value
    */
    return 1;
  }
  function parseDate(datestring) {
    var date;
    if (/^\d{4}-\d{1,2}$/.test(datestring)) {
      date = datestring.split("-").reverse();
    } else if (/\//.test(datestring)) {
      date = datestring.split(/\s*\/\s*/g);
    } else if (/\s/.test(datestring)) {
      date = datestring.split(/ +/g);
    }
    if ((0, is_array_1.isArray)(date)) {
      return {
        month: date[0] || "",
        year: date.slice(1).join()
      };
    }
    var numberOfDigitsInMonth = getNumberOfMonthDigitsInDateString(datestring);
    var month = datestring.substr(0, numberOfDigitsInMonth);
    return {
      month: month,
      year: datestring.substr(month.length)
    };
  }
  parseDate$1.parseDate = parseDate;

  var expirationMonth$1 = {};

  Object.defineProperty(expirationMonth$1, "__esModule", {
    value: true
  });
  expirationMonth$1.expirationMonth = void 0;
  function verification$3(isValid, isPotentiallyValid, isValidForThisYear) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid,
      isValidForThisYear: isValidForThisYear || false
    };
  }
  function expirationMonth(value) {
    var currentMonth = new Date().getMonth() + 1;
    if (typeof value !== "string") {
      return verification$3(false, false);
    }
    if (value.replace(/\s/g, "") === "" || value === "0") {
      return verification$3(false, true);
    }
    if (!/^\d*$/.test(value)) {
      return verification$3(false, false);
    }
    var month = parseInt(value, 10);
    if (isNaN(Number(value))) {
      return verification$3(false, false);
    }
    var result = month > 0 && month < 13;
    return verification$3(result, result, result && month >= currentMonth);
  }
  expirationMonth$1.expirationMonth = expirationMonth;

  var __assign = commonjsGlobal && commonjsGlobal.__assign || function () {
    __assign = Object.assign || function (t) {
      for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
      }
      return t;
    };
    return __assign.apply(this, arguments);
  };
  Object.defineProperty(expirationDate$1, "__esModule", {
    value: true
  });
  expirationDate$1.expirationDate = void 0;
  var parse_date_1 = parseDate$1;
  var expiration_month_1$1 = expirationMonth$1;
  var expiration_year_1$1 = expirationYear$1;
  function verification$2(isValid, isPotentiallyValid, month, year) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid,
      month: month,
      year: year
    };
  }
  function expirationDate(value, maxElapsedYear) {
    var date;
    if (typeof value === "string") {
      value = value.replace(/^(\d\d) (\d\d(\d\d)?)$/, "$1/$2");
      date = (0, parse_date_1.parseDate)(String(value));
    } else if (value !== null && typeof value === "object") {
      var fullDate = __assign({}, value);
      date = {
        month: String(fullDate.month),
        year: String(fullDate.year)
      };
    } else {
      return verification$2(false, false, null, null);
    }
    var monthValid = (0, expiration_month_1$1.expirationMonth)(date.month);
    var yearValid = (0, expiration_year_1$1.expirationYear)(date.year, maxElapsedYear);
    if (monthValid.isValid) {
      if (yearValid.isCurrentYear) {
        var isValidForThisYear = monthValid.isValidForThisYear;
        return verification$2(isValidForThisYear, isValidForThisYear, date.month, date.year);
      }
      if (yearValid.isValid) {
        return verification$2(true, true, date.month, date.year);
      }
    }
    if (monthValid.isPotentiallyValid && yearValid.isPotentiallyValid) {
      return verification$2(false, true, null, null);
    }
    return verification$2(false, false, null, null);
  }
  expirationDate$1.expirationDate = expirationDate;

  var cvv$1 = {};

  Object.defineProperty(cvv$1, "__esModule", {
    value: true
  });
  cvv$1.cvv = void 0;
  var DEFAULT_LENGTH = 3;
  function includes(array, thing) {
    for (var i = 0; i < array.length; i++) {
      if (thing === array[i]) {
        return true;
      }
    }
    return false;
  }
  function max(array) {
    var maximum = DEFAULT_LENGTH;
    var i = 0;
    for (; i < array.length; i++) {
      maximum = array[i] > maximum ? array[i] : maximum;
    }
    return maximum;
  }
  function verification$1(isValid, isPotentiallyValid) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid
    };
  }
  function cvv(value, maxLength) {
    if (maxLength === void 0) {
      maxLength = DEFAULT_LENGTH;
    }
    maxLength = maxLength instanceof Array ? maxLength : [maxLength];
    if (typeof value !== "string") {
      return verification$1(false, false);
    }
    if (!/^\d*$/.test(value)) {
      return verification$1(false, false);
    }
    if (includes(maxLength, value.length)) {
      return verification$1(true, true);
    }
    if (value.length < Math.min.apply(null, maxLength)) {
      return verification$1(false, true);
    }
    if (value.length > max(maxLength)) {
      return verification$1(false, false);
    }
    return verification$1(true, true);
  }
  cvv$1.cvv = cvv;

  var postalCode$1 = {};

  Object.defineProperty(postalCode$1, "__esModule", {
    value: true
  });
  postalCode$1.postalCode = void 0;
  var DEFAULT_MIN_POSTAL_CODE_LENGTH = 3;
  function verification(isValid, isPotentiallyValid) {
    return {
      isValid: isValid,
      isPotentiallyValid: isPotentiallyValid
    };
  }
  function postalCode(value, options) {
    if (options === void 0) {
      options = {};
    }
    var minLength = options.minLength || DEFAULT_MIN_POSTAL_CODE_LENGTH;
    if (typeof value !== "string") {
      return verification(false, false);
    } else if (value.length < minLength) {
      return verification(false, true);
    }
    return verification(true, true);
  }
  postalCode$1.postalCode = postalCode;

  var __createBinding = commonjsGlobal && commonjsGlobal.__createBinding || (Object.create ? function (o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = {
        enumerable: true,
        get: function () {
          return m[k];
        }
      };
    }
    Object.defineProperty(o, k2, desc);
  } : function (o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
  });
  var __setModuleDefault = commonjsGlobal && commonjsGlobal.__setModuleDefault || (Object.create ? function (o, v) {
    Object.defineProperty(o, "default", {
      enumerable: true,
      value: v
    });
  } : function (o, v) {
    o["default"] = v;
  });
  var __importStar = commonjsGlobal && commonjsGlobal.__importStar || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
  };
  var creditCardType = __importStar(dist$1);
  var cardholder_name_1 = cardholderName$1;
  var card_number_1 = cardNumber$1;
  var expiration_date_1 = expirationDate$1;
  var expiration_month_1 = expirationMonth$1;
  var expiration_year_1 = expirationYear$1;
  var cvv_1 = cvv$1;
  var postal_code_1 = postalCode$1;
  var cardValidator = {
    creditCardType: creditCardType,
    cardholderName: cardholder_name_1.cardholderName,
    number: card_number_1.cardNumber,
    expirationDate: expiration_date_1.expirationDate,
    expirationMonth: expiration_month_1.expirationMonth,
    expirationYear: expiration_year_1.expirationYear,
    cvv: cvv_1.cvv,
    postalCode: postal_code_1.postalCode
  };
  var dist = cardValidator;
  var cardValidator$1 = /*@__PURE__*/getDefaultExportFromCjs(dist);

  function checkoutView() {
    module_default$1.data('cardForm', function () {
      return {
        model: {
          number: '',
          expiry: '',
          cvc: ''
        },
        ri: {
          number: null,
          expiry: null,
          cvc: null
        },
        errors: {
          number: null,
          expiry: null,
          cvc: null
        },
        error: null,
        card: {},
        data: {
          number: null,
          expire_month: null,
          expire_year: null,
          cvc: null
        },
        init: function init() {
          var _this = this;
          for (var input in this.ri) {
            this.ri[input] = new RestrictedInput$1({
              element: this.$refs[input],
              pattern: this.$refs[input].dataset.pattern
            });
            this.$watch('errors.' + input, function (value) {
              _this.error = _this.errors.number || _this.errors.expiry || _this.errors.cvc;
            });
          }
          this.cardInput();
          this.expiryInput();
          this.cvcInput();
        },
        cardInput: function cardInput() {
          var _this2 = this;
          this.$watch('model.number', function (value, current) {
            _this2.data.number = null;
            _this2.errors.number = null;
            var validation = cardValidator$1.number(value);
            _this2.card = validation.card || {};
            if (validation.card) {
              _this2.ri.number.setPattern(_this2.generateCardInputPattern(validation));
              _this2.ri.cvc.setPattern('{{' + '9'.repeat(validation.card.code.size) + '}}');
              _this2.$refs.cvc.setAttribute('placeholder', validation.card.code.name);
              _this2.$refs.cvc.setAttribute('maxlength', validation.card.code.size);
              if (_this2.model.cvc && _this2.model.cvc.length < validation.card.code.size) {
                _this2.errors.cvc = __('Your card\'s security code is incomplete.');
              }
            }
            if (value.length > current.length && validation.isValid && validation.card.type != "unionpay") {
              if (!cardValidator$1.expirationDate(_this2.model.expiry).isValid) {
                _this2.$refs.expiry.focus();
              } else if (!cardValidator$1.cvv(_this2.model.cvc).isValid) {
                _this2.$refs.cvc.focus();
              }
              _this2.data.number = value;
            } else if (!validation.isValid && !validation.isPotentiallyValid) {
              _this2.errors.number = __('Invalid card number');
            }
          });
          this.$refs.number.addEventListener('blur', function () {
            var validation = cardValidator$1.number(_this2.model.number);
            if (!validation.isValid && _this2.model.number.length > 0) {
              _this2.errors.number = validation.isPotentiallyValid ? __('Your card number is incomplete.') : __('Invalid card number');
            } else {
              _this2.errors.number = null;
            }
          });
        },
        expiryInput: function expiryInput() {
          var _this3 = this;
          this.$watch('model.expiry', function (value, current) {
            _this3.data.expire_month = null;
            _this3.data.expire_year = null;
            _this3.errors.expiry = null;
            var validation = cardValidator$1.expirationDate(value);
            if (validation.isValid) {
              if (!cardValidator$1.cvv(_this3.model.cvc).isValid) {
                _this3.$refs.cvc.focus();
              }
              _this3.data.expire_month = validation.month;
              _this3.data.expire_year = validation.year;
            } else {
              if (value.length == 1 && parseInt(value, 10) > 1) {
                _this3.model.expiry = '0' + value + '/';
              } else if (value.length == 3 && parseInt(value.substring(0, 2), 10) > '12') {
                _this3.model.expiry = '0' + value[0] + '/' + value[1];
              }
            }
            validation = cardValidator$1.expirationDate(_this3.model.expiry);
            if (!validation.isPotentiallyValid) {
              _this3.errors.expiry = __('Your card\'s expiration date is invalid.');
            }
          });
          this.$refs.expiry.addEventListener('blur', function () {
            var validation = cardValidator$1.expirationDate(_this3.model.expiry);
            if (!validation.isValid && _this3.model.expiry.length > 0) {
              _this3.errors.expiry = validation.isPotentiallyValid ? __('Your card\'s expiration date is incomplete.') : __('Your card\'s expiration date is invalid.');
            } else {
              _this3.errors.expiry = null;
            }
          });
          this.$refs.expiry.addEventListener('keyup', function (e) {
            if (e.key == 'Backspace' && _this3.model.expiry.length == 0) {
              _this3.$refs.number.focus();
            }
          });
        },
        cvcInput: function cvcInput() {
          var _this4 = this;
          this.$watch('model.cvc', function (value, current) {
            _this4.data.cvc = null;
            _this4.errors.cvc = null;
            var validation = cardValidator$1.cvv(value, _this4.$refs.cvc.getAttribute('maxlength') || 3);
            if (validation.isValid) {
              _this4.data.cvc = value;
            } else if (!validation.isPotentiallyValid) {
              _this4.errors.cvc = __('Your card\'s security code is invalid.');
            }
          });
          this.$refs.cvc.addEventListener('blur', function () {
            var validation = cardValidator$1.cvv(_this4.model.cvc, _this4.$refs.cvc.getAttribute('maxlength') || 3);
            if (!validation.isValid && _this4.model.cvc.length > 0) {
              _this4.errors.cvc = validation.isPotentiallyValid ? __('Your card\'s security code is incomplete.') : __('Your card\'s security code is invalid.');
            } else {
              _this4.errors.cvc = null;
            }
          });
          this.$refs.cvc.addEventListener('keyup', function (e) {
            if (e.key == 'Backspace' && _this4.model.cvc.length == 0) {
              _this4.$refs.expiry.focus();
            }
          });
        },
        generateCardInputPattern: function generateCardInputPattern(verification) {
          var cardInfo = verification.card;
          var pattern = '';
          var lastIndex = 0;

          // Add parts for each gap
          cardInfo.gaps.forEach(function (gap, index) {
            var gapSize = gap - lastIndex;
            pattern += '{{' + '9'.repeat(gapSize) + '}} ';
            lastIndex = gap;
          });

          // Add the last part, considering the maximum length
          var maxLength = Math.max.apply(Math, _toConsumableArray(cardInfo.lengths));
          var remainingLength = maxLength - lastIndex;
          pattern += '{{' + '9'.repeat(remainingLength) + '}}';
          return pattern.trim();
        },
        icon: function icon() {
          return "<svg><use xlink:href=\"#icon-".concat(this.card.type || 'default', "\"></use></svg>");
        }
      };
    });
    module_default$1.data("stripe", function (key) {
      return {
        stripe: null,
        error: null,
        disabled: true,
        card: null,
        init: function init() {
          var _this5 = this;
          this.stripe = Stripe(key);
          var elements = this.stripe.elements();
          this.card = elements.create("card", {
            style: {
              base: {
                fontSize: '16px',
                color: "rgb(".concat(getComputedStyle(document.documentElement).getPropertyValue('--color-content'), ")")
              }
            }
          });
          this.card.mount(this.$refs.card);
          this.card.on('change', function (_ref) {
            var complete = _ref.complete,
              error = _ref.error;
            _this5.disabled = !complete;
            _this5.error = error ? error.message : null;
          });
        },
        submit: function submit() {
          var _this6 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var response, _data, data, clientSecret, confirmIntent, result, url;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!(_this6.disabled || _this6.processing)) {
                    _context.next = 2;
                    break;
                  }
                  return _context.abrupt("return");
                case 2:
                  _this6.processing = 'stripe';
                  _context.prev = 3;
                  _context.next = 6;
                  return api.post('/billing/checkout', {
                    id: _this6.plan.id,
                    gateway: 'stripe'
                  });
                case 6:
                  response = _context.sent;
                  _context.next = 18;
                  break;
                case 9:
                  _context.prev = 9;
                  _context.t0 = _context["catch"](3);
                  _context.next = 13;
                  return _context.t0.json();
                case 13:
                  _data = _context.sent;
                  _this6.error = _data.message || null;
                  _this6.disabled = false;
                  _this6.processing = null;
                  return _context.abrupt("return");
                case 18:
                  _context.next = 20;
                  return response.json();
                case 20:
                  data = _context.sent;
                  clientSecret = data.purchase_token;
                  confirmIntent = clientSecret.startsWith('seti_') ? _this6.stripe.confirmCardSetup : _this6.stripe.confirmCardPayment;
                  _context.next = 25;
                  return confirmIntent(clientSecret, {
                    payment_method: {
                      card: _this6.card
                    }
                  });
                case 25:
                  result = _context.sent;
                  if (!result.error) {
                    _context.next = 32;
                    break;
                  }
                  _this6.error = result.error.message;
                  _this6.disabled = false;
                  _this6.processing = null;
                  _context.next = 36;
                  break;
                case 32:
                  url = 'payment-callback/' + data.id + '/stripe';
                  if (result.setupIntent) {
                    url += '?setup_intent_id=' + result.setupIntent.id;
                  } else {
                    url += '?payment_intent_id=' + result.paymentIntent.id;
                  }
                  window.location.href = url;
                  return _context.abrupt("return");
                case 36:
                case "end":
                  return _context.stop();
              }
            }, _callee, null, [[3, 9]]);
          }))();
        }
      };
    });
    module_default$1.data('checkout', function () {
      var plan = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      return {
        processing: null,
        error: null,
        showAddressForm: false,
        init: function init() {
          this.plan = plan;
        },
        saveAddress: function saveAddress(id, form) {
          var _this7 = this;
          if (this.processing) {
            return;
          }
          this.processing = true;
          api.post("/workspaces/".concat(id), new FormData(form)).then(function (response) {
            _this7.$store.workspace = response.data;
            _this7.processing = false;
            _this7.showAddressForm = false;
          })["catch"](function (error) {
            return _this7.processing = false;
          });
        },
        purchase: function purchase() {
          var _this8 = this;
          var gateway = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          var card = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
          if (this.processing) {
            return;
          }
          this.processing = gateway;
          api.post('/billing/checkout', {
            id: this.plan.id,
            gateway: gateway,
            card: card
          }).then(function (response) {
            return response.json();
          }).then(function (data) {
            if (data.redirect) {
              window.location.href = data.redirect;
              return;
            }
            if (data.id) {
              window.location.href = 'app/billing/orders/' + data.id + '/receipt';
              return;
            }
            _this8.processing = null;
          })["catch"](function (error) {
            var msg = 'An unexpected error occurred! Please try again later!';
            _this8.processing = null;
            _this8.error = error.message || msg;
          });
        }
      };
    });
  }

  function accountView() {
    module_default$1.data('account', function () {
      return {
        isProcessing: false,
        submit: function submit() {
          var _this = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          var data = {};
          new FormData(this.$refs.form).forEach(function (value, key) {
            return data[key] = value;
          });
          api.post("/account".concat(this.$refs.form.dataset.path || ''), data).then(function (response) {
            return response.json();
          }).then(function (data) {
            if (data.jwt) {
              // Save the JWT to local storage 
              // to be used for future api requests
              localStorage.setItem('jwt', data.jwt);
            }
            _this.isProcessing = false;
            toast$1.success(_this.$refs.form.dataset.successMsg || 'Changes saved successfully!');
          })["catch"](function (error) {
            return _this.isProcessing = false;
          });
        },
        resendIn: 0,
        resendVerificationEmail: function resendVerificationEmail() {
          var _this2 = this;
          if (this.resent) {
            return;
          }
          this.resendIn = 60;
          var interval = setInterval(function () {
            _this2.resendIn--;
            if (_this2.resendIn <= 0) {
              clearInterval(interval);
            }
          }, 1000);
          api.post('/account/verification').then(function () {
            return toast$1.success('Email sent successfully!');
          });
        }
      };
    });
  }

  function searchForm() {
    module_default$1.data('search', function () {
      return {
        isProcessing: false,
        showResults: false,
        results: [],
        init: function init() {
          this.bindKeyboardShortcuts();
        },
        bindKeyboardShortcuts: function bindKeyboardShortcuts() {
          var _this = this;
          window.addEventListener('keydown', function (e) {
            if (e.metaKey && e.key === 'k') {
              e.preventDefault();
              _this.$refs.input.focus();
            } else if (e.key === 'Escape') {
              _this.$refs.input.blur();
              _this.showResults = false;
            }
          });
        },
        search: function search(query) {
          var _this2 = this;
          this.isProcessing = true;
          api.get('/search', {
            query: query
          }).then(function (response) {
            return response.json();
          }).then(function (list) {
            _this2.results = list.data;
            _this2.isProcessing = false;
            _this2.showResults = _this2.results.length > 0;
          })["catch"](function (error) {
            _this2.isProcessing = false;
            _this2.showResults = false;
          });
        }
      };
    });
  }

  var RedirectHelper = /*#__PURE__*/function () {
    function RedirectHelper() {
      _classCallCheck(this, RedirectHelper);
    }
    _createClass(RedirectHelper, [{
      key: "saveRedirectPath",
      value: function saveRedirectPath() {
        var currentUrl = new URL(window.location.href);
        var params = new URLSearchParams(currentUrl.search);
        var redirectPath = params.get('redirect');
        if (!redirectPath) {
          return;
        }
        localStorage.setItem('redirect', redirectPath);
        this.checkRedirectPath();
      }
    }, {
      key: "getRedirectPath",
      value: function getRedirectPath() {
        this.checkRedirectPath();
        return localStorage.getItem('redirect') || null;
      }
    }, {
      key: "clearRedirectPath",
      value: function clearRedirectPath() {
        localStorage.removeItem('redirect');
      }
    }, {
      key: "checkRedirectPath",
      value: function checkRedirectPath() {
        var path = localStorage.getItem('redirect');
        if (!path) {
          return null;
        }
        var currentUrl = new URL(window.location.href);
        var redirectUrl = new URL(path, currentUrl.origin);
        if (redirectUrl.origin === currentUrl.origin && redirectUrl.pathname && redirectUrl.pathname !== '/') {
          localStorage.setItem('redirect', redirectUrl.pathname);
          return;
        }
        localStorage.removeItem('redirect');
      }
    }]);
    return RedirectHelper;
  }();
  var helper = new RedirectHelper();

  function dashboardView() {
    module_default$1.data('dashboard', function () {
      return {
        documents: [],
        documentsFetched: false,
        init: function init() {
          this.checkPendingRedirection();
          searchForm();
          this.getRecentDocuments();
        },
        getRecentDocuments: function getRecentDocuments() {
          var _this = this;
          var params = {
            limit: 5,
            sort: 'created_at:desc'
          };
          api.get('/library/documents', params).then(function (response) {
            return response.json();
          }).then(function (list) {
            _this.documentsFetched = true;
            _this.documents = list.data;
          });
        },
        checkPendingRedirection: function checkPendingRedirection() {
          var path = helper.getRedirectPath();
          if (path) {
            // Remove the redirect path from local storage
            helper.clearRedirectPath();

            // Redirect the user to the path
            window.location.href = path;
          }
        }
      };
    });
  }

  function voiceover() {
    module_default$1.data('voiceover', function () {
      var voice = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var speech = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return {
        isProcessing: false,
        isDeleting: false,
        history: null,
        preview: speech,
        showSettings: false,
        voice: voice,
        prompt: null,
        query: '',
        voices: null,
        isLoading: false,
        hasMore: true,
        currentResource: null,
        showList: false,
        init: function init() {
          var _this = this;
          this.$watch('preview', function (value) {
            // Update the item in the history list
            if (_this.history && value) {
              var index = _this.history.findIndex(function (item) {
                return item.id === value.id;
              });
              if (index >= 0) {
                _this.history[index] = value;
              }
            }
          });
          this.fetchHistory();
          this.getVoices();
        },
        fetchHistory: function fetchHistory() {
          var _this2 = this;
          api.get('/library/speeches').then(function (response) {
            return response.json();
          }).then(function (list) {
            var data = list.data;
            _this2.history = data.reverse();
          });
        },
        getVoices: function getVoices() {
          var _this3 = this;
          var cursor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
          var reset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
          if (reset) {
            this.isLoading = false;
            this.hasMore = true;
          }
          if (!this.hasMore || this.isLoading) {
            return;
          }
          this.isLoading = true;
          var params = {
            limit: 25
          };
          if (cursor) {
            params.starting_after = cursor;
          }
          if (this.query) {
            params.query = this.query;
          }
          api.get('/voices', params).then(function (response) {
            return response.json();
          }).then(function (list) {
            var _this3$voices;
            _this3.isLoading = false;
            if (!_this3.voices) {
              _this3.voices = [];
            }
            reset ? _this3.voices = list.data : (_this3$voices = _this3.voices).push.apply(_this3$voices, _toConsumableArray(list.data));
            _this3.hasMore = list.data.length >= params.limit;
          });
        },
        submit: function submit() {
          var _this4 = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          var data = {
            voice_id: this.voice.id,
            prompt: this.prompt
          };
          api.post('/ai/speeches', data).then(function (response) {
            return response.json();
          }).then(function (speech) {
            if (_this4.history === null) {
              _this4.history = [];
            }
            _this4.history.push(speech);
            _this4.preview = speech;
            _this4.isProcessing = false;
            _this4.prompt = null;
            _this4.select(speech);
          })["catch"](function (error) {
            _this4.isProcessing = false;
            console.error(error);
          });
        },
        select: function select(speech) {
          this.preview = speech;
          var url = new URL(window.location.href);
          url.pathname = '/app/voiceover/' + speech.id;
          window.history.pushState({}, '', url);
          if (speech.voice) {
            this.voice = speech.voice;
          }
        },
        save: function save(speech) {
          api.post("/library/speeches/".concat(speech.id), {
            title: speech.title
          });
        },
        remove: function remove(transcription) {
          var _this5 = this;
          this.isDeleting = true;
          api["delete"]("/library/speeches/".concat(transcription.id)).then(function () {
            var _this5$voice;
            _this5.preview = null;
            window.modal.close();
            toast.show("Speech has been deleted successfully.", 'ti ti-trash');
            _this5.isDeleting = false;
            var url = new URL(window.location.href);
            url.pathname = '/app/voiceover/' + (((_this5$voice = _this5.voice) === null || _this5$voice === void 0 ? void 0 : _this5$voice.id) || _this5.voices[0] || '');
            window.history.pushState({}, '', url);
            _this5.history.splice(_this5.history.indexOf(transcription), 1);
          })["catch"](function (error) {
            return _this5.isDeleting = false;
          });
        },
        selectVoice: function selectVoice(voice) {
          this.voice = voice;
          window.modal.close();
          var url = new URL(window.location.href);
          url.pathname = '/app/voiceover/' + voice.id;
          window.history.pushState({}, '', url);
        }
      };
    });
    module_default$1.data('audience', function (item) {
      return {
        item: item,
        isProcessing: null,
        changeAudience: function changeAudience(visibility) {
          var _this6 = this;
          this.isProcessing = visibility;
          api.post("/library/".concat(this.item.id), {
            visibility: visibility
          }).then(function (resp) {
            return resp.json();
          }).then(function (resp) {
            window.modal.close();
            _this6.isProcessing = null;
            _this6.item = resp;
          });
        }
      };
    });
  }

  function imagineView() {
    module_default$1.data('imagine', function (model) {
      var adapters = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var samples = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var image = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      return {
        samples: samples,
        adapters: [],
        adapter: null,
        showSettings: false,
        history: null,
        isProcessing: false,
        isDeleting: false,
        preview: {},
        prompt: null,
        negativePrompt: null,
        params: {
          width: null,
          height: null
        },
        original: {},
        placeholder: null,
        timer: 0,
        init: function init() {
          var _this = this;
          adapters.forEach(function (adapter) {
            if (adapter.is_available) {
              adapter.models.forEach(function (model) {
                if (model.is_available) {
                  _this.adapters.push(model);
                }
              });
            }
          });
          this.$watch('preview.image', function (value) {
            // Update the item in the history list
            if (_this.history && value) {
              var index = _this.history.findIndex(function (item) {
                return item.id === value.id;
              });
              if (index >= 0) {
                _this.history[index] = value;
              }
            }
          });
          api.get('/library/images').then(function (response) {
            return response.json();
          }).then(function (list) {
            var data = list.data;
            _this.history = data.reverse();
          });
          this.original = _objectSpread2({}, this.params);
          this.adapter = this.adapters.find(function (adapter) {
            return adapter.model == model;
          });
          if (!this.adapter && this.adapters.length > 0) {
            this.adapter = this.adapters[0];
          }
          this.$watch('adapter', function () {
            return _this.reset();
          });
          if (image) {
            this.select(image);
          }
        },
        reset: function reset() {
          for (var key in this.params) {
            if (this.original[key] === undefined) {
              delete this.params[key];
              continue;
            }
            this.params[key] = this.original[key];
          }
        },
        typeWrite: function typeWrite(field, value) {
          var _this2 = this;
          var i = 0;
          var speed = 10;
          var typeWriter = function typeWriter() {
            if (i < value.length) {
              _this2[field] += value.charAt(i);
              i++;
              clearTimeout(_this2.timer);
              _this2.timer = setTimeout(typeWriter, speed);
            }
          };
          this[field] = '';
          typeWriter();
        },
        surprise: function surprise() {
          var prompt = this.samples[Math.floor(Math.random() * this.samples.length)];
          this.$refs.prompt.focus();
          this.typeWrite('prompt', prompt);
        },
        placeholderSurprise: function placeholderSurprise() {
          var _this3 = this;
          clearTimeout(this.timer);
          if (this.prompt) {
            return;
          }
          this.timer = setTimeout(function () {
            var randomPrompt = _this3.samples[Math.floor(Math.random() * _this3.samples.length)];
            _this3.typeWrite('placeholder', randomPrompt);
          }, 2000);
        },
        tab: function tab(e) {
          if (this.prompt != this.placeholder && this.placeholder) {
            e.preventDefault();
            this.prompt = this.placeholder;
          }
        },
        blur: function blur() {
          this.placeholder = null;
          clearTimeout(this.timer);
        },
        submit: function submit($el) {
          var _this4 = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          var data = _objectSpread2(_objectSpread2({}, this.params), {}, {
            prompt: this.prompt,
            negative_prompt: this.negativePrompt,
            model: this.adapter.model || null
          });
          if (!data.width || !data.height) {
            var size = this.adapter.sizes[0] || {
              width: 640,
              height: 400
            };
            data.width = size.width;
            data.height = size.height;
          }
          this.setPreviewDimensions(data.width, data.height);
          api.post("/ai/images", data).then(function (response) {
            return response.json();
          }).then(function (image) {
            _this4.history.push(image);
            _this4.preview.image = image;
            _this4.prompt = null;
            _this4.isProcessing = false;
          })["catch"](function (error) {
            _this4.isProcessing = false;
            _this4.preview = {};
            var url = new URL(window.location.href);
            url.pathname = '/app/imagine/';
            window.history.pushState({}, '', url);
            _this4.history.splice(_this4.history.indexOf(image), 1);
          });
        },
        select: function select(image) {
          this.setPreviewDimensions(image.output_file.width, image.output_file.height);
          this.preview.image = image;
          var url = new URL(window.location.href);
          url.pathname = '/app/imagine/' + image.id;
          window.history.pushState({}, '', url);
        },
        remove: function remove(image) {
          var _this5 = this;
          this.isDeleting = true;
          api["delete"]("/library/images/".concat(image.id)).then(function () {
            _this5.preview = {};
            window.modal.close();
            toast$1.show("Image has been deleted successfully.", 'ti ti-trash');
            _this5.isDeleting = false;
            var url = new URL(window.location.href);
            url.pathname = '/app/imagine/';
            window.history.pushState({}, '', url);
            _this5.history.splice(_this5.history.indexOf(image), 1);
          })["catch"](function (error) {
            return _this5.isDeleting = false;
          });
        },
        setPreviewDimensions: function setPreviewDimensions(width, height) {
          var w = width > 672 ? 672 : width;
          var h = w / width * height;
          if (h > 856) {
            h = 856;
            w = h / height * width;
          }
          this.preview.width = w;
          this.preview.height = h;
        },
        copyImgToClipboard: function copyImgToClipboard(image) {
          fetch(image.output_file.url).then(function (res) {
            return res.blob();
          }).then(function (blob) {
            var item = new ClipboardItem(_defineProperty({}, blob.type, blob));
            return navigator.clipboard.write([item]);
          }).then(function () {
            toast$1.success('Image copied to clipboard!');
          });
        }
      };
    });
  }

  function workspace() {
    module_default$1.data('workspace', function () {
      var workspace = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var user = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return {
        workspace: workspace,
        user: user,
        isSwithcing: null,
        isProcessing: false,
        currentResource: null,
        init: function init() {},
        switchWorkspace: function switchWorkspace(id) {
          if (this.isSwithcing) {
            return;
          }
          this.isSwithcing = id;
          api.post('/account/workspace', {
            id: id
          }).then(function () {
            toast$1.defer('Workspace switched!');
            window.location.reload();
          });
        },
        rename: function rename(id, name) {
          var _this = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          api.post("/workspaces/".concat(id), {
            name: name
          }).then(function (response) {
            return response.json();
          }).then(function (ws) {
            _this.$store.workspace = ws;
            _this.isProcessing = false;
            toast$1.success('Workspace name updated!');
            window.modal.close();
          })["catch"](function (error) {
            return _this.isProcessing = false;
          });
        },
        create: function create(name) {
          var _this2 = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          api.post("/workspaces", {
            name: name
          }).then(function () {
            toast$1.defer('Workspace created!');
            window.location = '/app/workspace';
          })["catch"](function (error) {
            return _this2.isProcessing = false;
          });
        },
        removeMember: function removeMember(wsid, uid) {
          var _this3 = this;
          this.isProcessing = true;
          api["delete"]("/workspaces/".concat(wsid, "/users/").concat(uid)).then(function (response) {
            _this3.isProcessing = false;
            response.json().then(function (ws) {
              _this3.$store.workspace = ws;
              toast$1.success('Member removed!');
            })["catch"](function (error) {
              toast$1.show('Leaving workspace...', 'ti ti-progress');
              setTimeout(function () {
                return window.location.reload();
              }, 2000);
            });
          })["catch"](function (error) {
            return _this3.isProcessing = false;
          });
        },
        inviteMember: function inviteMember(wsid, email) {
          var _this4 = this;
          this.isProcessing = true;
          api.post("/workspaces/".concat(wsid, "/invitations"), {
            email: email
          }).then(function (response) {
            return response.json();
          }).then(function (ws) {
            _this4.isProcessing = false;
            _this4.$store.workspace = ws;
            toast$1.success('Invitation sent!');
            window.modal.close();
          })["catch"](function (error) {
            return _this4.isProcessing = false;
          });
        },
        deleteInvitation: function deleteInvitation(wsid, uid) {
          var _this5 = this;
          this.isProcessing = true;
          api["delete"]("/workspaces/".concat(wsid, "/invitations/").concat(uid)).then(function (response) {
            return response.json();
          }).then(function (ws) {
            _this5.isProcessing = false;
            _this5.$store.workspace = ws;
            toast$1.success('Invitation removed!');
          })["catch"](function (error) {
            return _this5.isProcessing = false;
          });
        },
        deleteWorkspace: function deleteWorkspace(wsid) {
          var _this6 = this;
          this.isProcessing = true;
          api["delete"]("/workspaces/".concat(wsid)).then(function () {
            toast$1.defer('Workspace deleted!', 'ti ti-trash');
            window.location.reload();
          })["catch"](function (error) {
            return _this6.isProcessing = false;
          });
        },
        transferOwnership: function transferOwnership(wsid, uid) {
          var _this7 = this;
          this.isProcessing = true;
          api.post("/workspaces/".concat(wsid), {
            owner_id: uid
          }).then(function (response) {
            return response.json();
          }).then(function (ws) {
            _this7.isProcessing = false;
            _this7.$store.workspace = ws;
            toast$1.success('Workspace ownership transferred!');
          })["catch"](function (error) {
            return _this7.isProcessing = false;
          });
        }
      };
    });
  }

  function createParser(onParse) {
    let isFirstChunk;
    let buffer;
    let startingPosition;
    let startingFieldLength;
    let eventId;
    let eventName;
    let data;
    reset();
    return {
      feed,
      reset
    };
    function reset() {
      isFirstChunk = true;
      buffer = "";
      startingPosition = 0;
      startingFieldLength = -1;
      eventId = void 0;
      eventName = void 0;
      data = "";
    }
    function feed(chunk) {
      buffer = buffer ? buffer + chunk : chunk;
      if (isFirstChunk && hasBom(buffer)) {
        buffer = buffer.slice(BOM.length);
      }
      isFirstChunk = false;
      const length = buffer.length;
      let position = 0;
      let discardTrailingNewline = false;
      while (position < length) {
        if (discardTrailingNewline) {
          if (buffer[position] === "\n") {
            ++position;
          }
          discardTrailingNewline = false;
        }
        let lineLength = -1;
        let fieldLength = startingFieldLength;
        let character;
        for (let index = startingPosition; lineLength < 0 && index < length; ++index) {
          character = buffer[index];
          if (character === ":" && fieldLength < 0) {
            fieldLength = index - position;
          } else if (character === "\r") {
            discardTrailingNewline = true;
            lineLength = index - position;
          } else if (character === "\n") {
            lineLength = index - position;
          }
        }
        if (lineLength < 0) {
          startingPosition = length - position;
          startingFieldLength = fieldLength;
          break;
        } else {
          startingPosition = 0;
          startingFieldLength = -1;
        }
        parseEventStreamLine(buffer, position, fieldLength, lineLength);
        position += lineLength + 1;
      }
      if (position === length) {
        buffer = "";
      } else if (position > 0) {
        buffer = buffer.slice(position);
      }
    }
    function parseEventStreamLine(lineBuffer, index, fieldLength, lineLength) {
      if (lineLength === 0) {
        if (data.length > 0) {
          onParse({
            type: "event",
            id: eventId,
            event: eventName || void 0,
            data: data.slice(0, -1)
            // remove trailing newline
          });

          data = "";
          eventId = void 0;
        }
        eventName = void 0;
        return;
      }
      const noValue = fieldLength < 0;
      const field = lineBuffer.slice(index, index + (noValue ? lineLength : fieldLength));
      let step = 0;
      if (noValue) {
        step = lineLength;
      } else if (lineBuffer[index + fieldLength + 1] === " ") {
        step = fieldLength + 2;
      } else {
        step = fieldLength + 1;
      }
      const position = index + step;
      const valueLength = lineLength - step;
      const value = lineBuffer.slice(position, position + valueLength).toString();
      if (field === "data") {
        data += value ? "".concat(value, "\n") : "\n";
      } else if (field === "event") {
        eventName = value;
      } else if (field === "id" && !value.includes("\0")) {
        eventId = value;
      } else if (field === "retry") {
        const retry = parseInt(value, 10);
        if (!Number.isNaN(retry)) {
          onParse({
            type: "reconnect-interval",
            value: retry
          });
        }
      }
    }
  }
  const BOM = [239, 187, 191];
  function hasBom(buffer) {
    return BOM.every((charCode, index) => buffer.charCodeAt(index) === charCode);
  }

  class EventSourceParserStream extends TransformStream {
    constructor() {
      let parser;
      super({
        start(controller) {
          parser = createParser(event => {
            if (event.type === "event") {
              controller.enqueue(event);
            }
          });
        },
        transform(chunk) {
          parser.feed(chunk);
        }
      });
    }
  }

  var populate$1 = {exports: {}};

  (function (module) {
    /**
     * Populate form fields from a JSON object.
     *
     * @param {HTMLFormElement} form The form element containing your input fields.
     * @param {object} data JSON data to populate the fields with.
     * @param {string} basename Optional basename which is added to `name` attributes, eg basename[fieldname]
     */
    function populate(form, data, basename) {
      for (const key in data) {
        if (!data.hasOwnProperty(key)) {
          continue;
        }
        const name = key;
        let value = data[key];
        if ('undefined' === typeof value) {
          value = '';
        }
        if (null === value) {
          value = '';
        }

        // handle array name attributes
        if (typeof basename !== "undefined") {
          name = basename + "[" + key + "]";
        }
        if (value.constructor === Array) {
          name += '[]';
        } else if (typeof value == "object") {
          populate(form, value, name);
          continue;
        }

        // only proceed if form has element with the given name attribute
        const element = form.elements.namedItem(name);
        if (!element) {
          continue;
        }

        // set element value
        const type = element.type || element[0].type;
        switch (type) {
          default:
            element.value = value;
            break;
          case 'radio':
          case 'checkbox':
            {
              const values = value.constructor === Array ? value : [value];
              for (let j = 0; j < element.length; j++) {
                element[j].checked = values.indexOf(element[j].value) > -1;
              }
            }
            break;
          case 'select-multiple':
            {
              const values = value.constructor === Array ? value : [value];
              for (let k = 0; k < element.options.length; k++) {
                element.options[k].selected = values.indexOf(element.options[k].value) > -1;
              }
            }
            break;
          case 'select':
          case 'select-one':
            element.value = value.toString() || value;
            break;
          case 'date':
            element.value = new Date(value).toISOString().split('T')[0];
            break;
        }

        // fire change event on element
        const changeEvent = new Event('change', {
          bubbles: true
        });
        switch (type) {
          default:
            element.dispatchEvent(changeEvent);
            break;
          case 'radio':
          case 'checkbox':
            for (let j = 0; j < element.length; j++) {
              if (element[j].checked) {
                element[j].dispatchEvent(changeEvent);
              }
            }
            break;
        }
      }
    }
    if (module.exports) {
      module.exports = populate;
    }
  })(populate$1);
  var populateExports = populate$1.exports;
  var populate = /*@__PURE__*/getDefaultExportFromCjs(populateExports);

  function writerView() {
    module_default$1.data('writer', function () {
      var preset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var doc = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return {
        required: [],
        isProcessing: false,
        showForm: true,
        docs: [],
        index: 0,
        preset: preset,
        init: function init() {
          var _this = this;
          if (doc) {
            this.showForm = false;
            this.docs.push(doc);
            populate(this.$refs.form, doc.params);
          } else if (!this.preset && this.$refs.form.checkValidity()) {
            this.submit();
          }
          this.$watch('index', function (index) {
            if (_this.docs[index].id) {
              _this.select(_this.docs[index]);
            }
          });
        },
        submit: function submit() {
          var _arguments = arguments,
            _this2 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var params, newIndex, response, stream, reader, _yield$reader$read, value, done;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  params = _arguments.length > 0 && _arguments[0] !== undefined ? _arguments[0] : null;
                  if (!_this2.isProcessing) {
                    _context.next = 3;
                    break;
                  }
                  return _context.abrupt("return");
                case 3:
                  _this2.docs.push({});
                  _this2.index = _this2.docs.length - 1;
                  newIndex = _this2.docs.length - 1;
                  _this2.isProcessing = true;
                  _this2.showForm = false;
                  if (!params) {
                    params = {};
                    new FormData(_this2.$refs.form).forEach(function (value, key) {
                      return params[key] = value;
                    });
                  }
                  _context.prev = 9;
                  _context.next = 12;
                  return api.post("/ai/completions/".concat(_this2.preset ? _this2.preset.id : ''), params);
                case 12:
                  response = _context.sent;
                  // Get the readable stream from the response body
                  stream = response.body.pipeThrough(new TextDecoderStream()).pipeThrough(new EventSourceParserStream()); // Get the reader from the stream
                  reader = stream.getReader();
                case 15:
                  _context.next = 18;
                  return reader.read();
                case 18:
                  _yield$reader$read = _context.sent;
                  value = _yield$reader$read.value;
                  done = _yield$reader$read.done;
                  if (!done) {
                    _context.next = 24;
                    break;
                  }
                  _this2.isProcessing = false;
                  return _context.abrupt("break", 40);
                case 24:
                  if (!(value.event == 'token')) {
                    _context.next = 27;
                    break;
                  }
                  _this2.docs[newIndex].content = (_this2.docs[newIndex].content || '') + JSON.parse(value.data);
                  return _context.abrupt("continue", 15);
                case 27:
                  if (!(value.event == 'document')) {
                    _context.next = 31;
                    break;
                  }
                  _this2.docs[newIndex] = JSON.parse(value.data);
                  _this2.select(_this2.docs[newIndex]);
                  return _context.abrupt("continue", 15);
                case 31:
                  if (!(value.event == 'error')) {
                    _context.next = 38;
                    break;
                  }
                  _this2.isProcessing = false;
                  _this2.showForm = true;
                  _this2.docs.splice(newIndex, 1);
                  _this2.index = _this2.docs.length > 1 ? _this2.docs.length - 1 : 0;
                  toast$1.error(value.data);
                  return _context.abrupt("break", 40);
                case 38:
                  _context.next = 15;
                  break;
                case 40:
                  _context.next = 48;
                  break;
                case 42:
                  _context.prev = 42;
                  _context.t0 = _context["catch"](9);
                  _this2.isProcessing = false;
                  _this2.showForm = true;
                  _this2.docs.pop();
                  _this2.index = _this2.docs.length > 1 ? _this2.docs.length - 1 : 0;
                case 48:
                case "end":
                  return _context.stop();
              }
            }, _callee, null, [[9, 42]]);
          }))();
        },
        format: function format(content) {
          return markdownToHtml(content);
        },
        copyDocumentContents: function copyDocumentContents(doc) {
          navigator.clipboard.writeText(doc.content).then(function () {
            toast$1.success('Document copied to clipboard!');
          });
        },
        download: function download(doc, format) {
          if (format == 'markdown') {
            var mimeType = 'text/markdown';
            var ext = 'md';
            var content = doc.content;
          } else if (format == 'html') {
            var mimeType = 'text/html';
            var ext = 'html';
            var content = "<html><head><meta charset=\"utf-8\" /><title>".concat(doc.title, "</title></head><body>").concat(this.format(doc.content), "</body></html>");
          } else if (format == 'word') {
            var mimeType = 'application/vnd.ms-word';
            var ext = 'doc';
            var content = "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" xmlns=\"http://www.w3.org/TR/REC-html40\"><head><meta charset=\"utf-8\" /><title>".concat(doc.title, "</title></head><body>").concat(this.format(doc.content), "</body></html>");
          } else {
            var mimeType = 'text/plain';
            var ext = 'txt';
            var content = doc.content;
          }
          this.downloadFromUrl("data:".concat(mimeType, ";charset=utf-8,").concat(encodeURIComponent(content)), doc.title, ext);
        },
        downloadFromUrl: function downloadFromUrl(url, filename, ext) {
          var anchor = document.createElement('a');
          anchor.href = url;
          anchor.download = "".concat(filename, ".").concat(ext);
          document.body.appendChild(anchor);
          anchor.click();

          // Clean up
          document.body.removeChild(anchor);
        },
        saveDocument: function saveDocument(doc) {
          api.post("/library/documents/".concat(doc.id), doc);
        },
        deleteDocument: function deleteDocument(doc) {
          var _this3 = this;
          api["delete"]("/library/documents/".concat(doc.id)).then(function () {
            toast$1.success('Document deleted successfully!');
            _this3.docs = _this3.docs.filter(function (d) {
              return d.id != doc.id;
            });
            _this3.index = _this3.docs.length > 1 ? _this3.docs.length - 1 : 0;
            if (_this3.docs.length == 0) {
              _this3.showForm = true;
            }
          });
        },
        select: function select(doc) {
          var _doc$id;
          var url = new URL(window.location.href);
          url.pathname = '/app/writer/' + ((_doc$id = doc.id) !== null && _doc$id !== void 0 ? _doc$id : '');
          window.history.pushState({}, '', url);
        }
      };
    });
  }

  function coderView() {
    module_default$1.data('coder', function () {
      var doc = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      return {
        required: [],
        isProcessing: false,
        showForm: true,
        docs: [],
        index: 0,
        init: function init() {
          var _this = this;
          if (doc) {
            this.showForm = false;
            this.docs.push(doc);
            populate(this.$refs.form, doc.params);
          }
          this.$watch('index', function (index) {
            if (_this.docs[index].id) {
              _this.select(_this.docs[index]);
            }
          });
        },
        submit: function submit() {
          var _arguments = arguments,
            _this2 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var params, newIndex, response, stream, reader, _yield$reader$read, value, done;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  params = _arguments.length > 0 && _arguments[0] !== undefined ? _arguments[0] : null;
                  if (!_this2.isProcessing) {
                    _context.next = 3;
                    break;
                  }
                  return _context.abrupt("return");
                case 3:
                  _this2.docs.push({});
                  _this2.index = _this2.docs.length - 1;
                  newIndex = _this2.docs.length - 1;
                  _this2.isProcessing = true;
                  _this2.showForm = false;
                  if (!params) {
                    params = {};
                    new FormData(_this2.$refs.form).forEach(function (value, key) {
                      return params[key] = value;
                    });
                  }
                  _context.prev = 9;
                  _context.next = 12;
                  return api.post("/ai/completions/code", params);
                case 12:
                  response = _context.sent;
                  // Get the readable stream from the response body
                  stream = response.body.pipeThrough(new TextDecoderStream()).pipeThrough(new EventSourceParserStream()); // Get the reader from the stream
                  reader = stream.getReader();
                case 15:
                  _context.next = 18;
                  return reader.read();
                case 18:
                  _yield$reader$read = _context.sent;
                  value = _yield$reader$read.value;
                  done = _yield$reader$read.done;
                  if (!done) {
                    _context.next = 24;
                    break;
                  }
                  _this2.isProcessing = false;
                  return _context.abrupt("break", 40);
                case 24:
                  if (!(value.event == 'token')) {
                    _context.next = 27;
                    break;
                  }
                  _this2.docs[newIndex].content = (_this2.docs[newIndex].content || '') + JSON.parse(value.data);
                  return _context.abrupt("continue", 15);
                case 27:
                  if (!(value.event == 'document')) {
                    _context.next = 31;
                    break;
                  }
                  _this2.docs[newIndex] = JSON.parse(value.data);
                  _this2.select(_this2.docs[newIndex]);
                  return _context.abrupt("continue", 15);
                case 31:
                  if (!(value.event == 'error')) {
                    _context.next = 38;
                    break;
                  }
                  _this2.isProcessing = false;
                  _this2.showForm = true;
                  _this2.docs.splice(newIndex, 1);
                  _this2.index = _this2.docs.length > 1 ? _this2.docs.length - 1 : 0;
                  toast$1.error(value.data);
                  return _context.abrupt("break", 40);
                case 38:
                  _context.next = 15;
                  break;
                case 40:
                  _context.next = 48;
                  break;
                case 42:
                  _context.prev = 42;
                  _context.t0 = _context["catch"](9);
                  _this2.isProcessing = false;
                  _this2.showForm = true;
                  _this2.docs.pop();
                  _this2.index = _this2.docs.length > 1 ? _this2.docs.length - 1 : 0;
                case 48:
                case "end":
                  return _context.stop();
              }
            }, _callee, null, [[9, 42]]);
          }))();
        },
        format: function format(content) {
          return markdownToHtml(content);
        },
        copyDocumentContents: function copyDocumentContents(doc) {
          navigator.clipboard.writeText(doc.content).then(function () {
            toast$1.success('Document copied to clipboard!');
          });
        },
        download: function download(doc, format) {
          if (format == 'markdown') {
            var mimeType = 'text/markdown';
            var ext = 'md';
            var content = doc.content;
          } else if (format == 'html') {
            var mimeType = 'text/html';
            var ext = 'html';
            var content = "<html><head><meta charset=\"utf-8\" /><title>".concat(doc.title, "</title></head><body>").concat(this.format(doc.content), "</body></html>");
          } else if (format == 'word') {
            var mimeType = 'application/vnd.ms-word';
            var ext = 'doc';
            var content = "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:w=\"urn:schemas-microsoft-com:office:word\" xmlns=\"http://www.w3.org/TR/REC-html40\"><head><meta charset=\"utf-8\" /><title>".concat(doc.title, "</title></head><body>").concat(this.format(doc.content), "</body></html>");
          } else {
            var mimeType = 'text/plain';
            var ext = 'txt';
            var content = doc.content;
          }
          this.downloadFromUrl("data:".concat(mimeType, ";charset=utf-8,").concat(encodeURIComponent(content)), doc.title, ext);
        },
        downloadFromUrl: function downloadFromUrl(url, filename, ext) {
          var anchor = document.createElement('a');
          anchor.href = url;
          anchor.download = "".concat(filename, ".").concat(ext);
          document.body.appendChild(anchor);
          anchor.click();

          // Clean up
          document.body.removeChild(anchor);
        },
        saveDocument: function saveDocument(doc) {
          api.post("/library/code-documents/".concat(doc.id), doc);
        },
        deleteDocument: function deleteDocument(doc) {
          var _this3 = this;
          api["delete"]("/library/code-documents/".concat(doc.id)).then(function () {
            toast$1.success('Document deleted successfully!');
            _this3.docs = _this3.docs.filter(function (d) {
              return d.id != doc.id;
            });
            _this3.index = _this3.docs.length > 1 ? _this3.docs.length - 1 : 0;
            if (_this3.docs.length == 0) {
              _this3.showForm = true;
            }
          });
        },
        select: function select(doc) {
          var _doc$id;
          var url = new URL(window.location.href);
          url.pathname = '/app/coder/' + ((_doc$id = doc.id) !== null && _doc$id !== void 0 ? _doc$id : '');
          window.history.pushState({}, '', url);
        }
      };
    });
  }

  function transcriberView() {
    module_default$1.data('transcriber', function () {
      var transcription = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      return {
        isProcessing: false,
        isDeleting: false,
        history: null,
        preview: transcription,
        previewTime: 0,
        file: null,
        viewSegments: true,
        init: function init() {
          var _this = this;
          this.$watch('preview', function (value) {
            // Update the item in the history list
            if (_this.history && value) {
              var index = _this.history.findIndex(function (item) {
                return item.id === value.id;
              });
              if (index >= 0) {
                _this.history[index] = value;
              }
            }
          });
          api.get('/library/transcriptions').then(function (response) {
            return response.json();
          }).then(function (list) {
            var data = list.data;
            _this.history = data.reverse();
          });
        },
        /** @param {HTMLFormElement} el */submit: function submit(el) {
          var _this2 = this;
          if (this.isProcessing) {
            return;
          }
          this.isProcessing = true;
          api.post('/ai/transcriptions', new FormData(el)).then(function (response) {
            return response.json();
          }).then(function (transcription) {
            if (_this2.history === null) {
              _this2.history = [];
            }
            _this2.history.push(transcription);
            _this2.select(transcription);
            _this2.isProcessing = false;
            el.reset();
            _this2.file = null;
          })["catch"](function (error) {
            return _this2.isProcessing = false;
          });
        },
        save: function save(transcription) {
          api.post("/library/transcriptions/".concat(transcription.id), {
            title: transcription.title
          });
        },
        select: function select(transcription) {
          this.preview = transcription;
          var url = new URL(window.location.href);
          url.pathname = '/app/transcriber/' + transcription.id;
          window.history.pushState({}, '', url);
        },
        remove: function remove(transcription) {
          var _this3 = this;
          this.isDeleting = true;
          api["delete"]("/library/transcriptions/".concat(transcription.id)).then(function () {
            _this3.preview = null;
            window.modal.close();
            toast$1.show("Transcription has been deleted successfully.", 'ti ti-trash');
            _this3.isDeleting = false;
            var url = new URL(window.location.href);
            url.pathname = '/app/transcriber/';
            window.history.pushState({}, '', url);
            _this3.history.splice(_this3.history.indexOf(transcription), 1);
          })["catch"](function (error) {
            return _this3.isDeleting = false;
          });
        },
        getReadableDuration: function getReadableDuration(duration) {
          var date = new Date(0);
          date.setSeconds(duration);
          if (duration > 3600) {
            return date.toISOString().substring(11, 19);
          }
          return date.toISOString().substring(14, 19);
        },
        download: function download(transcription, format) {
          if (format == 'vtt') {
            mimeType = 'text/vtt';
            ext = 'vtt';
            content = this.toVTT(transcription);
          } else if (format == 'srt') {
            mimeType = 'text/srt';
            ext = 'srt';
            content = this.toSRT(transcription);
          } else {
            var mimeType = 'text/plain';
            var ext = 'txt';
            var content = transcription.content.text;
          }
          this.downloadFromUrl("data:".concat(mimeType, ";charset=utf-8,").concat(encodeURIComponent(content)), transcription.title, ext);
        },
        downloadFromUrl: function downloadFromUrl(url, filename, ext) {
          var anchor = document.createElement('a');
          anchor.href = url;
          anchor.download = "".concat(filename, ".").concat(ext);
          document.body.appendChild(anchor);
          anchor.click();

          // Clean up
          document.body.removeChild(anchor);
        },
        toVTT: function toVTT(transcription) {
          var vtt = 'WEBVTT\n\n';
          transcription.content.segments.forEach(function (segment, index) {
            var start = new Date(0);
            start.setSeconds(segment.start);
            start = start.toISOString().substring(11, 23);
            var end = new Date(0);
            end.setSeconds(segment.end);
            end = end.toISOString().substring(11, 23);
            vtt += "".concat(index + 1, "\n");
            vtt += "".concat(start, " --> ").concat(end, "\n");
            vtt += "".concat(segment.text.trim(), "\n\n");
          });
          return vtt;
        },
        toSRT: function toSRT(transcription) {
          var srt = '';
          transcription.content.segments.forEach(function (segment, index) {
            var start = new Date(0);
            start.setSeconds(segment.start);
            start = start.toISOString().substring(11, 23).replace('.', ',');
            var end = new Date(0);
            end.setSeconds(segment.end);
            end = end.toISOString().substring(11, 23).replace('.', ',');
            srt += "".concat(index + 1, "\n");
            srt += "".concat(start, " --> ").concat(end, "\n");
            srt += "".concat(segment.text.trim(), "\n\n");
          });
          return srt;
        }
      };
    });
  }

  /**
   * @copypright https://bennadel.com/4602
   */
  module_default$1.directive("template-outlet", function (element, metadata, framework) {
    module_default$1.nextTick(function () {
      // Get the template reference that we want to clone and render.
      var templateRef = framework.evaluate(metadata.expression);
      if (!templateRef) {
        return;
      }

      // Clone the template and get the root node - this is the node that we will
      // inject into the DOM.
      var clone = templateRef.content.cloneNode(true).firstElementChild;

      // CAUTION: The following logic ASSUMES that the template-outlet directive has
      // an "x-data" scope binding on it. If it didn't we would have to change the
      // logic. But, I don't think Alpine.js has mechanics to solve this use-case
      // quite yet.
      module_default$1.addScopeToNode(clone,
      // Use the "x-data" scope from the template-outlet element as a means to
      // supply initializing data to the clone (for constructor injection).
      module_default$1.closestDataStack(element)[0],
      // use the template-outlet element's parent to define the rest of the
      // scope chain.
      element.parentElement);

      // Swap the template-outlet element with the hook and clone.
      // --
      // NOTE: Doing this inside the mutateDom() method will pause Alpine's internal
      // MutationObserver, which allows us to perform DOM manipulation without
      // triggering actions in the framework. Then, we can call initTree() and
      // destroyTree() to have explicitly setup and teardowm DOM node bindings.
      module_default$1.mutateDom(function pauseMutationObserver() {
        element.after(clone);
        module_default$1.initTree(clone);
        element.remove();
        module_default$1.destroyTree(element);
      });
    });
  });
  function chat() {
    module_default$1.data('chat', function (model) {
      var adapters = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      var assistant = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var conversation = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      return {
        adapters: [],
        adapter: null,
        conversation: null,
        assistant: assistant,
        history: null,
        assistants: null,
        file: null,
        prompt: null,
        isProcessing: false,
        parent: null,
        tree: null,
        quote: null,
        autoScroll: false,
        isDeleting: false,
        query: '',
        promptUpdated: false,
        init: function init() {
          var _this = this;
          adapters.forEach(function (adapter) {
            if (adapter.is_available) {
              adapter.models.forEach(function (model) {
                if (model.is_available) {
                  _this.adapters.push(model);
                }
              });
            }
          });
          this.adapter = this.adapters.find(function (adapter) {
            return adapter.model == model;
          });
          if (!this.adapter && this.adapters.length > 0) {
            this.adapter = this.adapters[0];
          }
          if (conversation) {
            this.select(conversation);
            setTimeout(function () {
              return window.scroll({
                behavior: 'smooth',
                top: document.body.scrollHeight
              });
            }, 500);
          }
          this.fetchHistory();
          this.getAssistants();
          window.addEventListener('scroll', function () {
            _this.autoScroll = window.scrollY + window.innerHeight + 500 >= document.documentElement.scrollHeight;
          });
          window.addEventListener('mouseup', function (e) {
            _this.$refs.quote.classList.add('hidden');
            _this.$refs.quote.classList.remove('flex');
          });
          this.$watch('prompt', function () {
            return _this.promptUpdated = true;
          });
        },
        format: function format(message) {
          return message ? markdownToHtml(message.content) : '';
        },
        generateMap: function generateMap() {
          var msgId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
          var map = new Map();
          this.conversation.messages.forEach(function (message) {
            map.set(message.id, message);
          });
          var tree = {
            index: 0,
            children: this.buildTree(null, map)
          };
          if (msgId) {
            this.updateIndicesToMessage(tree, msgId);
          }
          this.tree = tree;
        },
        updateIndicesToMessage: function updateIndicesToMessage(node, messageId) {
          if (node.id === messageId) {
            return true; // Found the node, no need to update further
          }

          if (node.children && node.children.length > 0) {
            for (var i = 0; i < node.children.length; i++) {
              if (this.updateIndicesToMessage(node.children[i], messageId)) {
                node.index = i; // Update the parent's index to point to this child
                return true; // Propagate the update up the tree
              }
            }
          }

          return false; // Node not found in this subtree
        },
        buildTree: function buildTree(pid, map) {
          var tree = [];
          var _iterator = _createForOfIteratorHelper(map),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var _step$value = _slicedToArray(_step.value, 2),
                id = _step$value[0],
                message = _step$value[1];
              if (message.parent_id === pid) {
                tree.push(message);
                message.index = 0;
                message.children = this.buildTree(id, map);
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          return tree;
        },
        fetchHistory: function fetchHistory() {
          var _this2 = this;
          api.get('/library/conversations', {
            limit: 5
          }).then(function (response) {
            return response.json();
          }).then(function (list) {
            var data = list.data;
            _this2.history = data.reverse();
          });
        },
        getAssistants: function getAssistants() {
          var _this3 = this;
          var cursor = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
          var params = {
            limit: 250
          };
          if (cursor) {
            params.starting_after = cursor;
          }
          api.get('/assistants', params).then(function (response) {
            return response.json();
          }).then(function (list) {
            var _this3$assistants;
            if (!_this3.assistants) {
              _this3.assistants = [];
            }
            (_this3$assistants = _this3.assistants).push.apply(_this3$assistants, _toConsumableArray(list.data));
            if (list.data.length > 0 && list.data.length == params.limit) {
              _this3.getAssistants(_this3.assistants[_this3.assistants.length - 1].id);
            }
          });
        },
        submit: function submit() {
          var _this4 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var _this4$assistant, _this4$adapter;
            var data, msgs, pid;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!_this4.isProcessing) {
                    _context.next = 2;
                    break;
                  }
                  return _context.abrupt("return");
                case 2:
                  _this4.isProcessing = true;
                  if (_this4.conversation) {
                    _context.next = 13;
                    break;
                  }
                  _context.prev = 4;
                  _context.next = 7;
                  return _this4.createConversation();
                case 7:
                  _context.next = 13;
                  break;
                case 9:
                  _context.prev = 9;
                  _context.t0 = _context["catch"](4);
                  _this4.isProcessing = false;
                  return _context.abrupt("return");
                case 13:
                  data = new FormData();
                  data.append('content', _this4.prompt);
                  data.append('model', _this4.adapter.model);
                  if ((_this4$assistant = _this4.assistant) !== null && _this4$assistant !== void 0 && _this4$assistant.id) {
                    data.append('assistant_id', _this4.assistant.id);
                  }
                  if (_this4.quote) {
                    data.append('quote', _this4.quote);
                  }
                  msgs = document.getElementsByClassName('message');
                  if (msgs.length > 0) {
                    pid = msgs[msgs.length - 1].dataset.id;
                    if (pid) {
                      data.append('parent_id', pid);
                    }
                  }
                  if ((_this4$adapter = _this4.adapter) !== null && _this4$adapter !== void 0 && _this4$adapter.supports_image && _this4.file) {
                    data.append('file', _this4.file);
                  }
                  _this4.ask(data, _this4.assistant);
                case 22:
                case "end":
                  return _context.stop();
              }
            }, _callee, null, [[4, 9]]);
          }))();
        },
        ask: function ask(data, assistant) {
          var _this5 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
            var response, stream, reader, message, pushed, lastMessage, _yield$reader$read, value, done, msg;
            return _regeneratorRuntime().wrap(function _callee2$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  _context2.prev = 0;
                  _context2.next = 3;
                  return api.post('/ai/conversations/' + _this5.conversation.id + '/messages', data);
                case 3:
                  response = _context2.sent;
                  // Get the readable stream from the response body
                  stream = response.body.pipeThrough(new TextDecoderStream()).pipeThrough(new EventSourceParserStream()); // Get the reader from the stream
                  reader = stream.getReader(); // Temporary message
                  message = {
                    object: 'message',
                    id: 'temp',
                    model: null,
                    role: 'assistant',
                    content: '',
                    quote: null,
                    assistant: assistant,
                    parent_id: data.get('parent_id'),
                    children: []
                  };
                  pushed = false;
                  lastMessage = null;
                  window.scrollTo(0, document.body.scrollHeight);
                  _this5.autoScroll = true;
                  _this5.promptUpdated = false;
                  _this5.file = null;
                case 13:
                  if (_this5.autoScroll) {
                    window.scrollTo(0, document.body.scrollHeight);
                  }
                  _context2.next = 17;
                  return reader.read();
                case 17:
                  _yield$reader$read = _context2.sent;
                  value = _yield$reader$read.value;
                  done = _yield$reader$read.done;
                  if (!done) {
                    _context2.next = 25;
                    break;
                  }
                  _this5.isProcessing = false;

                  // Remove messages with null id from the conversation
                  _this5.conversation.messages = _this5.conversation.messages.filter(function (msg) {
                    return msg.id !== 'temp';
                  });
                  _this5.generateMap(lastMessage.id);
                  return _context2.abrupt("break", 43);
                case 25:
                  if (!(value.event == 'token')) {
                    _context2.next = 30;
                    break;
                  }
                  message.content += JSON.parse(value.data);
                  if (!pushed) {
                    _this5.conversation.messages.push(message);
                    pushed = true;
                  }
                  _this5.generateMap(message.id);
                  return _context2.abrupt("continue", 13);
                case 30:
                  if (!(value.event == 'message')) {
                    _context2.next = 38;
                    break;
                  }
                  msg = JSON.parse(value.data);
                  if (!_this5.promptUpdated) {
                    _this5.quote = null;
                    _this5.prompt = null;
                  }
                  _this5.conversation.messages.push(msg);
                  if (msg.role === 'user') {
                    message.parent_id = msg.id;
                  }
                  _this5.generateMap();
                  lastMessage = msg;
                  return _context2.abrupt("continue", 13);
                case 38:
                  if (!(value.event == 'error')) {
                    _context2.next = 41;
                    break;
                  }
                  _this5.error(value.data);
                  return _context2.abrupt("break", 43);
                case 41:
                  _context2.next = 13;
                  break;
                case 43:
                  _context2.next = 48;
                  break;
                case 45:
                  _context2.prev = 45;
                  _context2.t0 = _context2["catch"](0);
                  _this5.error(_context2.t0);
                case 48:
                case "end":
                  return _context2.stop();
              }
            }, _callee2, null, [[0, 45]]);
          }))();
        },
        error: function error(msg) {
          this.isProcessing = false;
          toast.error(msg);
          console.error(msg);

          // Remove messages with null id from the conversation
          this.conversation.messages = this.conversation.messages.filter(function (msg) {
            return msg.id !== 'temp';
          });
          this.generateMap();
        },
        createConversation: function createConversation() {
          var _this6 = this;
          return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
            var resp, conversation;
            return _regeneratorRuntime().wrap(function _callee3$(_context3) {
              while (1) switch (_context3.prev = _context3.next) {
                case 0:
                  _context3.next = 2;
                  return api.post('/ai/conversations');
                case 2:
                  resp = _context3.sent;
                  conversation = resp.data;
                  if (_this6.history === null) {
                    _this6.history = [];
                  }
                  _this6.history.push(conversation);
                  _this6.select(conversation);
                case 7:
                case "end":
                  return _context3.stop();
              }
            }, _callee3);
          }))();
        },
        select: function select(conversation) {
          this.conversation = conversation;
          this.generateMap();
          var url = new URL(window.location.href);
          url.pathname = '/app/chat/' + conversation.id;
          window.history.pushState({}, '', url);
        },
        save: function save(conversation) {
          var _this7 = this;
          api.post("/library/conversations/".concat(conversation.id), {
            title: conversation.title
          }).then(function (resp) {
            // Update the item in the history list
            if (_this7.history) {
              var index = _this7.history.findIndex(function (item) {
                return item.id === resp.data.id;
              });
              if (index >= 0) {
                _this7.history[index] = resp.data;
              }
            }
          });
        },
        enter: function enter(e) {
          if (e.key === 'Enter' && !e.shiftKey && !this.isProcessing && this.prompt && this.prompt.trim() !== '') {
            e.preventDefault();
            this.submit();
          }
        },
        copy: function copy(message) {
          navigator.clipboard.writeText(message.content).then(function () {
            toast.success('Copied to clipboard!');
          });
        },
        textSelect: function textSelect(e) {
          this.$refs.quote.classList.add('hidden');
          this.$refs.quote.classList.remove('flex');
          var selection = window.getSelection();
          if (selection.rangeCount <= 0) {
            return;
          }
          var range = selection.getRangeAt(0);
          var text = range.toString();
          if (text.trim() == '') {
            return;
          }
          e.stopPropagation();
          var startNode = range.startContainer;
          var startOffset = range.startOffset;
          var rect;
          if (startNode.nodeType === Node.TEXT_NODE) {
            // Create a temporary range to get the exact position of the start
            var tempRange = document.createRange();
            tempRange.setStart(startNode, startOffset);
            tempRange.setEnd(startNode, startOffset + 1); // Add one character to make the range visible
            rect = tempRange.getBoundingClientRect();
          } else if (startNode.nodeType === Node.ELEMENT_NODE) {
            // For element nodes, get the bounding rect directly
            rect = startNode.getBoundingClientRect();
          }

          // Adjust coordinates relative to the container (parent)
          var container = this.$refs.quote.parentElement;
          var containerRect = container.getBoundingClientRect();
          var x = rect.left - containerRect.left + container.scrollLeft;
          var y = rect.top - containerRect.top + container.scrollTop;
          this.$refs.quote.style.top = y + 'px';
          this.$refs.quote.style.left = x + 'px';
          this.$refs.quote.classList.add('flex');
          this.$refs.quote.classList.remove('hidden');
          this.$refs.quote.dataset.value = range.toString();
          return;
        },
        selectQuote: function selectQuote() {
          this.quote = this.$refs.quote.dataset.value;
          this.$refs.quote.dataset.value = null;
          this.$refs.quote.classList.add('hidden');
          this.$refs.quote.classList.remove('flex');

          // Clear selection
          window.getSelection().removeAllRanges();
        },
        regenerate: function regenerate(message) {
          var model = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
          if (!message.parent_id) {
            return;
          }
          var parentMessage = this.conversation.messages.find(function (msg) {
            return msg.id === message.parent_id;
          });
          if (!parentMessage) {
            return;
          }
          var data = new FormData();
          data.append('parent_id', parentMessage.id);
          data.append('model', model || message.model);
          this.ask(data, message.assistant);
        },
        edit: function edit(message, content) {
          var _message$assistant;
          var data = new FormData();
          data.append('model', message.model);
          data.append('content', content);
          if (message.parent_id) {
            data.append('parent_id', message.parent_id);
          }
          if ((_message$assistant = message.assistant) !== null && _message$assistant !== void 0 && _message$assistant.id) {
            data.append('assistant_id', message.assistant.id);
          }
          if (message.quote) {
            data.append('quote', message.quote);
          }
          this.ask(data, message.assistant);
        },
        remove: function remove(conversation) {
          var _this8 = this;
          this.isDeleting = true;
          api["delete"]("/library/conversations/".concat(conversation.id)).then(function () {
            _this8.conversation = null;
            window.modal.close();
            toast.show("Conversation has been deleted successfully.", 'ti ti-trash');
            _this8.isDeleting = false;
            var url = new URL(window.location.href);
            url.pathname = '/app/chat/';
            window.history.pushState({}, '', url);
            _this8.history.splice(_this8.history.indexOf(conversation), 1);
          })["catch"](function (error) {
            return _this8.isDeleting = false;
          });
        },
        doesAssistantMatch: function doesAssistantMatch(assistant, query) {
          query = query.trim().toLowerCase();
          if (!query) {
            return true;
          }
          if (assistant.name.toLowerCase().includes(query)) {
            return true;
          }
          if (assistant.expertise && assistant.expertise.toLowerCase().includes(query)) {
            return true;
          }
          if (assistant.description && assistant.description.toLowerCase().includes(query)) {
            return true;
          }
          return false;
        },
        selectAssistant: function selectAssistant(assistant) {
          this.assistant = assistant;
          window.modal.close();
          if (!this.conversation) {
            var url = new URL(window.location.href);
            url.pathname = '/app/chat/' + assistant.id;
            window.history.pushState({}, '', url);
          }
        }
      };
    });
  }

  initState();
  dashboardView();
  listView();
  writerView();
  coderView();
  imagineView();
  transcriberView();
  documentView();
  billingView();
  accountView();
  voiceover();
  workspace();
  checkoutView();
  chat();
  module_default$1.plugin(module_default.defaultProps({
    arrow: false
  }));
  module_default$1.start();

})();
//# sourceMappingURL=app.js.map
